UNIT MSOBJLST;

{ MatrixSoft Selection From Listing Object                             }
{ Written by Lars Hellsten / Dated: 01/11/96                           }

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES  MSOBJH;

TYPE  PListing = ^TListing;
      TListing = OBJECT

         private
            x1,y1,x2,y2 : Byte;
            LastItem    : Word;
            BeginPos    : Word;
            EndPos      : Word;





FUNCTION ConfStr(Num:Integer):String;
BEGIN
   ConfStr := ' '+PadRight(StrFunc(Num),' ',5)+
                  PadRight(MsPcb_ConfFullName,' ',27)+' '+
                  PadRight(PCWS_NetGetStr(Num),' ',14);
END;


PROCEDURE TaggedAttr(Num:Integer);
BEGIN
   WITH TagMenu^.ItemData^[Num] DO
      BEGIN
         IF Tagged^[TagMenu^.ItemData^[Num].ID-1] = NetworkNum
            THEN BEGIN
                  TagMenu^.ItemData^[Num].AttrNorm := $1A;
                  TagMenu^.ItemData^[Num].AttrHigh := $9A;
               END
            ELSE BEGIN
                  TagMenu^.ItemData^[Num].AttrNorm := $1F;
                  TagMenu^.ItemData^[Num].AttrHigh := $9F;
               END;
      END;
END;



PROCEDURE PCWS_PrevProc(VAR Menu:PMenuType); FAR;
   BEGIN
       IF TopConf > 0 THEN
          BEGIN
             MenuH_PrevDefault(Menu);
             Dec(BotConf);
             Dec(TopConf);
             WITH Menu^.ItemData^[1] DO
                BEGIN
                   MsPcb_ConfRead(TopConf);
                   Char := ' ';
                   Extended := FALSE;
                   ID := TopConf+1;
                   HelpID := -1;
                   Desc := ConfStr(TopConf);
                   Status := '';
                   XPos := Menu^.StartX+1;
                   YPos := Menu^.StartY+3;
                   CharPos := 0;

                   IF UseTagged THEN TaggedAttr(1);

                   LinkUp := (TopConf+1)-1;
                   LinkDown := (TopConf+1)+1;
                   LinkLeft := 0;
                   LinkRight := 0;

                   IF TopConf < 1 THEN LinkUp := 0;
                END;
          END;
    END;

    PROCEDURE PCWS_NextProc(VAR Menu:PMenuType); FAR;
    BEGIN
       IF BotConf < nc THEN
          BEGIN
             MenuH_NextDefault(Menu);
             Inc(BotConf);
             Inc(TopConf);
             WITH Menu^.ItemData^[Menu^.ItemNum] DO
                BEGIN
                   MsPcb_ConfRead(BotConf);
                   Char := ' ';
                   Extended := FALSE;
                   ID := BotConf+1;
                   HelpID := -1;
                   Desc := ConfStr(BotConf);
                   Status := '';
                   XPos := Menu^.StartX+1;
                   YPos := Menu^.EndY-1;
                   CharPos := 0;

                   IF UseTagged THEN TaggedAttr(Menu^.ItemNum);

                   LinkUp := (BotConf+1)-1;
                   LinkDown := (BotConf+1)+1;
                   LinkLeft := 0;
                   LinkRight := 0;

                   IF BotConf+1 >= nc THEN LinkDown := 0;
                END;
          END;
    END;

FUNCTION Handle_SelectConf:LongINt;

    PROCEDURE InitMenu;
    VAR i:Word; s:String;
    BEGIN
       UseTagged := FALSE;
       nc := (FileSize(Msp_ConfFile)-2) DIV SizeOf(Msp_Conf);
       TopConf := 0;
       BotConf := 12;
       PrevProc := PCWS_PrevProc;
       NextProc := PCWS_NextProc;
       Menu_Init(TagMenu,15,7,64,23,3,25,15,TRUE,'');
       TagMenu^.Scrollable := TRUE;
       FOR i := TopConf TO BotConf DO
          BEGIN
             MsPcb_ConfRead(i);
             s := '[ENTER]-Select conference  [ESC]=Abort ';
             Menu_AddItem(TagMenu,i+1,-1,' ',FALSE,i,i+2,0,0,16,10+i,0,2,ConfStr(i),s);
             IF i < 1 THEN TagMenu^.ItemData^[TagMenu^.ItemNum].LinkUp := 0;
             IF i+1 >= nc THEN TagMenu^.ItemData^[TagMenu^.ItemNum].LinkDown := 0;
          END;
    END;

    PROCEDURE PageUp;
    VAR i:Word;
    BEGIN
       IF TopConf > 0 THEN
          BEGIN
             IF TopConf < 14
                THEN TopConf := 0
                ELSE TopConf := TopConf-13;
             BotConf := TopConf + 12;

             FOR i := TopConf TO BotConf DO WITH TagMenu^.ItemData^[i-TopConf+1] DO
                BEGIN
                   MsPcb_ConfRead(i);
                   ID := i+1;
                   Desc := ConfStr(i);

                   LinkUp := (i+1)-1;
                   LinkDown := (i+1)+1;
                   LinkLeft := 0;
                   LinkRight := 0;

                   IF i < 1 THEN TagMenu^.ItemData^[i-TopConf+1].LinkUp := 0;
                   IF i+1 >= nc THEN TagMenu^.ItemData^[i-TopConf+1].LinkDown := 0;

                   WriteFast(XPos,YPos,Desc,AttrNorm);
                END;
          END;
    END;

    PROCEDURE PageDown;
    VAR i:Word;
    BEGIN
       IF BotConf < (nc-1) THEN
          BEGIN
             IF BotConf > (nc-14)
                THEN BotConf := nc-1
                ELSE BotConf := BotConf+13;
             TopConf := BotConf - 12;

             FOR i := TopConf TO BotConf DO WITH TagMenu^.ItemData^[i-TopConf+1] DO
                BEGIN
                   MsPcb_ConfRead(i);
                   ID := i+1;
                   Desc := ConfStr(i);

                   LinkUp := (i+1)-1;
                   LinkDown := (i+1)+1;
                   LinkLeft := 0;
                   LinkRight := 0;

                   IF i < 1 THEN TagMenu^.ItemData^[i-TopConf+1].LinkUp := 0;
                   IF i+1 >= nc THEN TagMenu^.ItemData^[i-TopConf+1].LinkDown := 0;

                   WriteFast(XPos,YPos,Desc,AttrNorm);
                END;
          END;
    END;

BEGIN
   InitMenu;
   Menu_ClearMenu(TagMenu);
   Menu_DrawMenu(TagMenu);
   Menu_DrawItems(TagMenu);
   REPEAT
      WritePipeXY(16,8,'|25|11 #### Conference Name              Network      ');
      WritePipeXY(16,9,'|17|09');
      SetCursor(cmOff);
      MenuH_GetChoice(TagMenu,ChoiceID,' ?REU',#73#81);
      CASE ChoiceID OF
         -2 : CASE AlternateCh OF
                 #73 : PageUp;
                 #81 : PageDown;
              END;
      END;
   UNTIL (ChoiceID >= -1);
   Menu_DeInit(TagMenu);
   IF ChoiceID > 0
      THEN Handle_SelectConf := ChoiceID-1
      ELSE Handle_SelectConf := -1;
END;
