{$O+,I-}

UNIT RGUNIT;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


USES RECORDS,MSRGGEN;


TYPE UFlagsType = SET OF UFlags;
     ACRQType   = SET OF acrq;
VAR  VoteQues   : Integer;


FUNCTION  EvalACSFunc(Func:String):Boolean;
FUNCTION  EvaluateACSString(ACSStringIn:String):Boolean;
FUNCTION  ProcessAge(Func,BDay:String):Boolean;
FUNCTION  ProcessConf(Func:String):Boolean;
FUNCTION  ProcessDSL(Func:String; DSL:Byte):Boolean;
FUNCTION  ProcessEmulation(Func:String; Flags:UFlagsType):Boolean;
FUNCTION  ProcessARFlag(Func:String; AR:ACRQType):Boolean;
FUNCTION  ProcessGender(Func:String; Sex:Char):Boolean;
FUNCTION  ProcessLastMSG(Func:String; Lastmbase:Integer):Boolean;
FUNCTION  ProcessLastFILE(Func:String; Lastfbase:Integer):Boolean;
FUNCTION  ProcessACFlag(Func:String; Flags:UFlagsType):Boolean;
FUNCTION  ProcessSL(Func:String; SL:Byte):Boolean;
FUNCTION  ProcessTimeLeft(Func:String; TimeLeft:Integer):Boolean;
FUNCTION  ProcessUserNum(Func:String):Boolean;
FUNCTION  ProcessSubExpire(Func:String; Expiration:LongInt):Boolean;
FUNCTION  ProcessTime(Func:String):Boolean;
FUNCTION  ProcessPCR(Func:String):Boolean;
FUNCTION  ProcessVotes:Boolean;


IMPLEMENTATION

USES DOS,CRT,MISC1,STRINGS,UNIXDATE;


FUNCTION EvalACSFunc(Func:String):Boolean;
BEGIN
   CASE Func[1] OF
      'A' : EvalACSFunc := ProcessAge(func,MsRg_User.BDay);
      'C' : EvalACSFunc := ProcessConf(func);
      'D' : EvalACSFunc := ProcessDSL(func,MsRg_User.DSL);
      'E' : EvalACSFunc := ProcessEmulation(func,MsRg_User.Flags);
      'F' : EvalACSFunc := ProcessARFlag(func,MsRg_User.AR);
      'G' : EvalACSFunc := ProcessGender(func,MsRg_User.Sex);
      'K' : EvalACSFunc := ProcessLastMSG(func,MsRg_User.Lastmbase);
      'L' : EvalACSFunc := ProcessLastFILE(func,MsRg_User.Lastfbase);
      'R' : EvalACSFunc := ProcessACFlag(func,MsRg_User.Flags);
      'S' : EvalACSFunc := ProcessSL(func,MsRg_User.SL);
      'T' : EvalACSFunc := ProcessTimeLeft(func,MsRg_User.TlToday);
      'U' : EvalACSFunc := ProcessUserNum(Func);
      'X' : EvalACSFunc := ProcessSubExpire(func,MsRg_User.Expiration);
      'Y' : EvalACSFunc := ProcessTime(Func);
      ELSE
        IF      (Func = 'ZZ') THEN EvalACSFunc := ProcessPCR(func)
        ELSE IF (Func = 'JJ') THEN EvalACSFunc := (Novice IN MsRg_User.Flags)
        ELSE IF (Func = 'VV') THEN EvalACSFunc := ProcessVotes
        ELSE EvalACSFunc := True;
   END;
END;


FUNCTION EvaluateACSString(ACSStringIn:String):Boolean;
VAR ACSString,
    OneState,
    TempS          : String;
    ThisCh         : Byte;
    FinalStatus,
    SkipProc       : Boolean;
    LogicalStat    : Char;
    i              : integer;

   PROCEDURE GetNextStatement(VAR OneState, ACSString:String);
   VAR ThisChar,PosB:Integer;
   BEGIN
      ThisChar := 2; OneState := '';
      IF ACSString[1] IN ['!','|','&']
         THEN OneState := ACSString[1]
         ELSE BEGIN
               OneState := '&';
               Insert('&',ACSString,1);
            END;
      IF ACSString[2] = '(' THEN
         BEGIN
            i := Pos(')',ACSString);
            IF (i > 0)
               THEN OneState := Copy(ACSString,1,i)
               ELSE OneState := ACSString;
         END
      ELSE IF (ACSString[2] IN ['C','E','F','G','J','M','O','R','V','Z'])
         THEN OneState := Copy(ACSString,1,3)
         ELSE BEGIN
               OneState := OneState + ACSString[2];
               WHILE (ACSString[ThisChar+1] IN ['0'..'9']) AND (ThisChar+1 <= Length(ACSString)) DO
                  BEGIN
                     OneState := OneState + ACSString[ThisChar+1];
                     Inc(ThisChar);
                  END;
            END;
      Delete(acsstring,1,Length(OneState));
   END;

   FUNCTION EvalBracket(VAR InStr:String):Boolean;
   VAR OneState,TempS,TempS2:String;  TempStatus:Boolean;
   BEGIN
      TempStatus := TRUE;
      TempS2 := InStr;
      WHILE Length(TempS2) <> 0 DO
         BEGIN
            GetNextStatement(OneState,TempS2);
            TempS := Copy(OneState,2,Length(OneState) - 1);
            CASE OneState[1] OF
               '!' : TempStatus := TempStatus AND (NOT EvalACSFunc(TempS));
               '|' : TempStatus := TempStatus OR EvalACSFunc(TempS);
               '&' : TempStatus := TempStatus AND EvalACSFunc(TempS);
            END;
         END;
      InStr := '';
      EvalBracket := TempStatus;
   END;

BEGIN
   FinalStatus := TRUE;

   ACSString := ACSStringIn;
   ACSString := UpcaseStr(ACSString);
   WHILE Pos(' ',ACSString) > 0 DO Delete(ACSString,Pos(' ',ACSString),1);

   IF Pos('^',ACSString) <> 0      THEN FinalStatus := TRUE
   ELSE IF Pos('%',ACSString) <> 0 THEN FinalStatus := FALSE
   ELSE WHILE Length(ACSString) <> 0 DO
      BEGIN
         GetNextStatement(OneState,ACSString);
         TempS := Copy(OneState,2,Length(OneState)-1);
         IF OneState[2] = '(' THEN
            BEGIN
               TempS := Copy(OneState,3,Length(OneState)-3);
               CASE OneState[1] OF
                  '!' : FinalStatus := FinalStatus AND (NOT EvalBracket(TempS));
                  '|' : FinalStatus := FinalStatus OR EvalBracket(TempS);
                  '&' : FinalStatus := FinalStatus AND EvalBracket(TempS);
               END;
            END
         ELSE CASE OneState[1] OF
               '!' : FinalStatus := FinalStatus AND (NOT EvalACSFunc(TempS));
               '|' : FinalStatus := FinalStatus OR EvalACSFunc(TempS);
               '&' : FinalStatus := FinalStatus AND EvalACSFunc(TempS)
               ELSE ACSString := '';
            END;
      END;
   EvaluateACSString := FinalStatus;
END;


FUNCTION ProcessAge(Func,BDay:String):Boolean;
VAR Year,Month,Day,yy,mm,dd,Junk,InAge:Word;
BEGIN
   InAge := ValFunc(Copy(Func,2,Length(Func)-1));
   Year  := ValFunc('19'+Copy(BDay,7,2));
   Month := ValFunc(Copy(BDay,1,2));
   Day   := ValFunc(Copy(BDay,4,2));
   GetDate(yy,mm,dd,Junk);
   yy := yy - Year;
   IF (Month = mm)
      THEN BEGIN
            IF (Day < dd)
               THEN Dec(yy)
         END
      ELSE IF (mm < Month) THEN Dec(yy);
   ProcessAge := (yy >= InAge)
END;


FUNCTION ProcessConf(Func:String):Boolean;
VAR ConfFile : FILE OF ConfRec;
    Conf     : ConfRec;
BEGIN
   Assign(ConfFile,MsRg_Config.DataPath+'CONFRENC.DAT');
   IF FExists(MsRg_Config.DataPath+'CONFRENC.DAT')
      THEN BEGIN
            Reset(ConfFile);
            Seek(ConfFile,0);
            Read(ConfFile,Conf);
            Close(ConfFile);
            ProcessConf := EvaluateACSString(Conf.Conference[Func[2]].ACS);
         END
      ELSE ProcessConf := TRUE;
END;


FUNCTION ProcessDSL(Func:String; DSL:Byte):Boolean;
VAR InDSL,ErrCode:Word;
BEGIN
   Val(Copy(Func,2,Length(Func)-1),InDSL,ErrCode);
   IF (ErrCode <> 0)
      THEN ProcessDSL := False
      ELSE ProcessDSL := (DSL >= InDSL)
END;


FUNCTION ProcessEmulation(Func:String; Flags:UFlagsType):Boolean;
BEGIN
   CASE func[2] OF
      'A' : ProcessEmulation := (ANSI IN Flags);
      'V' : ProcessEmulation := (AVATAR IN Flags);
      'N' : ProcessEmulation := (vt100 IN Flags)
      ELSE ProcessEmulation := FALSE
   END
END;


FUNCTION ProcessARFlag(Func:String; AR:ACRQType):Boolean;
BEGIN
   ProcessARFlag := (Func[2] IN AR);
END;


FUNCTION ProcessGender(Func:String; Sex:Char):Boolean;
BEGIN
   IF (Func[2] = 'F')
      THEN ProcessGender := (Sex = 'F')
      ELSE ProcessGender := (Sex = 'M')
END;


FUNCTION ProcessLastMSG(Func:String; Lastmbase:Integer):Boolean;
VAR MBNum,ErrCode:Integer;
BEGIN
   Val(Copy(Func,2,Length(Func)-1),MBNum,ErrCode);
   ProcessLastMSG := ((MBNum = Lastmbase) AND (ErrCode = 0))
END;


FUNCTION ProcessLastFILE (func : String; Lastfbase : Integer) : Boolean;

VAR
   FBNum, ErrCode : Integer;

Begin
   Val(Copy(func,2,Length(func) - 1),FBNum,ErrCode);
   ProcessLastFILE := ((FBNum = Lastfbase) AND (ErrCode = 0))
End;


FUNCTION ProcessACFlag (func : String; Flags : UFlagsType) : Boolean;
Begin
   Case func[2] of
      'L' : ProcessACFlag := (rlogon in flags);
      'C' : ProcessACFlag := (rchat in flags);
      'V' : ProcessACFlag := (rvalidate in flags);
      'U' : ProcessACFlag := (ruserlist in flags);
      'A' : ProcessACFlag := (ramsg in flags);
      '*' : ProcessACFlag := (rpostan in flags);
      'P' : ProcessACFlag := (rpost in flags);
      'E' : ProcessACFlag := (remail in flags);
      'K' : ProcessACFlag := (rvoting in flags);
      'M' : ProcessACFlag := (rmsg in flags);
      '1' : ProcessACFlag := (fnodlratio in flags);
      '2' : ProcessACFlag := (fnopostratio in flags);
      '3' : ProcessACFlag := (fnocredits in flags);
      '4' : ProcessACFlag := (fnodeletion in flags)
      Else ProcessACFlag := False;
   End
End;


FUNCTION ProcessSL (func : String; SL : Byte) : Boolean;

VAR
   InSL : Byte;
   ErrCode : Integer;

Begin
   Val(Copy(func,2,Length(func) - 1),InSL,ErrCode);
   ProcessSL := ((SL >= InSL) AND (ErrCode = 0))
End;


FUNCTION ProcessTimeLeft (func : String; TimeLeft : Integer) : Boolean;

VAR
   InTime, ErrCode : Integer;

Begin
   Val(Copy(func,2,Length(func) - 1),InTime,ErrCode);
   ProcessTimeLeft := ((TimeLeft >= InTime) AND (ErrCode = 0))
End;


FUNCTION ProcessUserNum(Func:String):Boolean;
VAR InUser,ErrCode:Integer;
BEGIN
   Val(Copy(Func,2,Length(Func)-1),InUser,ErrCode);
   ProcessUserNum := ((InUser = MsRg_UserNum) AND (ErrCode = 0))
END;


FUNCTION ProcessSubExpire (func : String; Expiration : LongInt) : Boolean;

VAR
   InDaysLeft : Integer;
   Year, Month, Day, ErrCode : Word;
   CurrentDays, SubsDays : LongInt;

Begin
   Val(Copy(func,2,Length(func) - 1),InDaysLeft,ErrCode);
   If (ErrCode = 0) then
      Begin
         GetDate(Year,Month,Day,ErrCode);
         CurrentDays := DaysSince1970(Year,Month,Day);
         SubsDays := Expiration DIV 86400;
         ProcessSubExpire := (InDaysLeft <= (SubsDays - CurrentDays))
      End
   Else ProcessSubExpire := False
End;


FUNCTION ProcessTime(Func:String):Boolean;
VAR InMins,Hour,Minute,Second,ErrCode:Word;
BEGIN
   Val(Copy(func,2,Length(func)-1),InMins,ErrCode);
   IF (ErrCode = 0)
      THEN BEGIN
            GetTime(Hour,Minute,Second,ErrCode);
            Minute := (Hour * 60) + Minute;
            ProcessTime := (Minute >= InMins)
         END
      ELSE ProcessTime := False
END;


FUNCTION ProcessPCR(func:String):Boolean;
VAR GoodPost,TheirPost:Real;
BEGIN
   GoodPost := (MsRg_Config.Postratio[MsRg_User.SL] / 100);
   TheirPost := (MsRg_User.MSGPost / MsRg_User.LoggedOn);
   ProcessPCR := (TheirPost >= GoodPost);
END;


FUNCTION ProcessVotes:Boolean;
VAR tb:Boolean; ThisQues,CountTo:Byte;
BEGIN
   tb := TRUE;
   IF (VoteQues > 25)
      THEN CountTo := 25
      ELSE CountTo := VoteQues;
   FOR ThisQues := 1 TO CountTo DO
      tb := tb AND (MsRg_User.Vote[ThisQues] <> 0);
   ProcessVotes := tb;
END;


END.
