{$O+}
UNIT RWSTRUCT;

(* 
    RWSTRUCT - ReneWave data file formats and structures. 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES  RECORDS,MSBWGEN;

CONST MaxSelected    = 4000;

TYPE  RwKeyRec = RECORD { RENEWAVE.KEY }
         Junk1       : Array[1..657] OF Byte;
         RegName     : String[36];
         RegBBS      : String[36];
         RegPhone    : String[15];
         Junk2       : Array[1..1301] OF Byte;
      END;

      NetAttrSet     = SET OF NetAttr;

      RwIntProts     =
         (Nothing,

          Int_X,
          Int_X1K,
          Int_X1KG,
          Int_Y,
          Int_Y1K,
          Int_YG,
          Int_Z,
          Int_Zap
         );

      RwProtRec = RECORD
         Active  : Boolean;
         Letter  : Char;
         ErrLev  : Byte;
         Batch   : Boolean;
         ResultU : Array[1..3] OF String[5];
         ResultD : Array[1..3] OF String[5];
         ResultT : Boolean;
         LogFile : String[40];
         EnvCmd  : String[39];
         IntProt : RwIntProts;
         Desc    : String[35];
         Send    : String[75];
         Recv    : String[75];
      END;

   ConfigRec = RECORD
      RgMainDir,                         { Path to RENEGADE.DAT }
      RwMainDir,                         { Path to ReneWave data files }
      RwWorkDir,                         { Path to temp work directory }
      RwMenuDir,
      LogFile,                           { Path/filename of log file }
      LocalULDir,                        { For locally UL'd packets }
      LocalDLDir       : String[64];     { For locally DL'd packets }
      Junk1            : String[64];

      FilesList        : String[50];       { Filename/path of newfiles list }
      NewsFiles        : Array[1..5] OF RECORD
         TheFile       : String[52];       { Files to be included & dis- }
         ACS           : String[20];       { played when entering reader }
      END;

      Junk2,                               { Main & Config menu expert mode }
      Junk3            : String[79];       { prompts }
      TearLine         : String[29];       { Tearline to use }
      BBSID            : String[8];        { Name to use on packets }

      ACS_AllEmail,
      JunkAcs          : String[20];
      ForwardACS       : String[20];
      ForceOvrACS      : String[20];       { Forced area override ACS }
      FileReqACS       : String[20];       { ACS to file request files }

      TimeoutMinutes   : Byte;

      NTypeEmail,
      NTypeNetmail     : PostType;

      ForceEmail,                        { Is email base forced DL? }
      ForceNetmail,                      { Is netmail base forced DL? }
      HangUpOnTimeout,
      NukeLocalRep,
      AllowGoodbye,
      ImportPointers   : Boolean;        { Import area selection data }

      CreditsPublic    : Integer;
      CreditsEmail     : Integer;

      Junk200          : Byte;

      RwCommType       : Byte;           { 0=FOSSIL, 1=ASYNC }
      FreqLimit,                          { File request limit at one time }
      MaxPWTries       : Byte;
      SwapType         : SwapMethodType; { Where to swap }

      MaxTotalMsgs,
      MaxTotalBytes,
      MaxBaseMsgs,
      MaxBaseBytes     : LongInt;
      MaxDupes         : Word;

      LogOpts : RECORD
         ScanningInfo,
         BundlingInfo,
         TransferInfo,
         ErrorInfo,
         GeneralInfo,
         UserErrorsInfo,
         ReplyInfo      : Boolean;
      END;

      ACS_NetStatus:String[20];          { ACS to allow any name uploads }
      BBSZone,
      BBSNet,
      BBSNode,                           { System's default network }
      BBSPoint : Word;                   { address (if any) }

      DefaultNetAttr : NetAttrSet;       { Default netamil attributes }

      ACS_Crash,
      ACS_FAttach,
      ACS_KillSent,
      ACS_Hold,
      ACS_Imm,
      ACS_FREQ,
      ACS_Direct,
      ACS_UpdREQ       : String[20];
      AttachAcs        : String[20];

      Junk499 : Array[1..31] OF Byte;

      RwScanDir        : String[64];
      RwHelpDir        : String[64];
      RwTextDir        : String[64];
      RwLangDir        : String[64];

      BragLine         : Boolean;
      RgVer            : Word; { 0=5-11, 1=10-05, 3=10-31 }

      Junk501  : Array[1..20] OF Byte;

      FileListType     : Byte;            { 0=None/1=Internal/2=External }
      FileListHdr      : String[64];      { Header file }
      FileListFtr      : String[64];      { Footer file }
      FileListAreaT,                      { Include area totals? }
      FileListGrandT,                     { Include grand totals? }
      FileListCredits,                    { Include file points? }
      FileListOffline,                    { Include offline files? }
      FileListDates,                      { Include file dates? }
      FileListUploader : Boolean;         { Include uploader's name? }
      FileListOptional : Boolean;         { Is file list download optional? }
      FileListMaxDays  : Byte;            { Maximum days back (0=none) }

      Res4 : Array[1..672] OF Byte;

      AnyNameEmail,
      AnyNameNetmail   : String[20];

      RwArchivers : Array[1..1450] OF Byte;
      RwProtocols : Array[1..10] OF RwProtRec;

      Junk999 : Array[1..480] OF Byte;

      RwVer          : Word;          { Version number - v1.10=110 }

      res997         : Array[1..2985] OF Byte;

      DefaultHotkeys   : Boolean;
      DefaultExpert    : Boolean;
      DefaultGraphics  : Boolean;
      DefaultNotMyMail : Boolean;
      DefaultNumeric   : Boolean;
      DefaultFileList  : Boolean;
      DefaultQWK       : Boolean;
      DefaultNukeEmail : Boolean;
      DefaultMsgsLimit : LongInt;
      DefaultArc       : String[3];
      DefaultProt      : Char;

      InetActive       : Boolean;
      InetAcs          : String[40];
      InetAreaNum      : String[5];
      InetAreaTag      : String[20];
      InetAreaDesc     : String[40];
      InetToField      : String[35];
      InetGateZone,
      InetGateNet,
      InetGateNode,
      InetGatePoint    : Word;
      InetMsgAttr      : MsNetworkAttr;
      InetUseTo        : Boolean;
   END;

   RwUserRec = RECORD
      Alias,
      RealName   : String[36];
      UserRecNum : Word;
      RwPass     : String[20];
      PassUsage  : Byte;  { -- Password Usage ------------------------ }
                          { Bit 0 = Use password in door               }
                          { Bit 1 = Use password in reader             }

      BWaveFlags    : SET OF
                      (RwHotkeys,     { User uses "hotkeys" in door prompts }
                       RwXpert,       { Short menus displayed in door }
                       RwReserved,    { not currently used }
                       RwGraphics,    { Graphics - ReneWave doesn't use this }
                       RwNotMyMail,   { Do not bundle mail from user }
                       RwExtInfo,     { Not currently used }
                       RwNumericPkt,  { Use numeric packet extensions }
                       RwFileList);   { Include new files listing }

      RwFlags       : SET OF
                      (RwPacketQwk,   { Uses QWK packet format? }
                       RwNukeEmail);  { Nuke private messages after DL }

      Keywords      : Array[1..10] OF String[20];
      Filters       : Array[1..10] OF String[20];
      BundlMacros   : Array[1..3] OF String[76];
      AttachMethod  : Byte;
      RwProtocol    : Char;
      MsgsLimit,
      LastOn        : LongInt;

      Junk1         : Array[1..4] OF Byte;

      TodaysPackets : Byte;
      ScanEmail,
      ScanNetmail   : ScanInfoType;
      NukeEmail     : Boolean;

      Junk2         : Byte;

      PktNumber     : Word;
      LastDL        : LongInt;    { Date/Time of last download }
      Res1          : Array[1..41] of Byte;
   END;


TYPE  RepInfoRec = RECORD
         RepDownloads,
         RepDownloadK,
         RepFilePts,
         RepRewardUser,
         RepRewardPts,
         RepNetmail,
         RepEmail,
         RepPublic      : Word;
      END;


IMPLEMENTATION

END.
