{$O+,F+,I-}
UNIT RWFL;

(* 

    RWFL - ReneWave file list compiler

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


VAR Rwfl_Aborted : Boolean;


PROCEDURE RWF_CreateFileList(fn:String);


IMPLEMENTATION


USES  DOS,      CRT,      MSTRINGS, UNIXDATE, MISC1,    CRC32,
      RWMAIN,   RWLOGS,   MSRGGEN,  RWAREAS,  RWACS,    RWSTRUCT,
      MSFOSDOS, RECORDS,  BWSTRUCT;


TYPE  TDirTotalsType = RECORD
         AreaNum   : Word;     { Record number of this area in FBASES.DAT }
         NumFiles  : Word;     { Number of files in this area }
         NumBytes  : LongInt;  { Number of bytes in this area }
      END;
      PDirTotalsType = Array[1..1] OF TDirTotalsType;

VAR   OutFile       : TEXT;
      ThisBase,
      DirTotalsNum  : Word;
      DirTotals     : ^PDirTotalsType;
      TodayUnix     : LongInt;


PROCEDURE InitDataFiles(fn:String);
VAR HeaderFile:Text; OneLine:String;
BEGIN
   TodayUnix := CurrentSecsFunc;
   Rwfl_Aborted := FALSE;

   MsRg_FAreaOpen;
   MsRg_ExtOpen;

   Assign(OutFile,fn);
   Rewrite(OutFile);
   IF IOResult <> 0 THEN Exit;

   IF (RwConfig.FileListHdr <> '') AND FExists(RwConfig.FileListHdr) THEN
      BEGIN
         Assign(HeaderFile,RwConfig.FileListHdr);
         Reset(HeaderFile);
         WHILE NOT Eof(HeaderFile) DO
            BEGIN
               ReadLn(HeaderFile,OneLine);
               WriteLn(OutFile,OneLine);
            END;
         WriteLn(OutFile);
         Close(HeaderFile);
      END;

   GetMem(DirTotals,FileSize(MsRg_FAreaFile)*SizeOf(TDirTotalsType));
END;


FUNCTION CheckFileProcess:Boolean;
VAR TempResult:Boolean;
BEGIN
   TempResult := NOT (notval IN MsRg_Dir.FileStat) AND NOT (resumelater IN MsRg_Dir.FileStat);
   TempResult := TempResult AND (RGF2Unix(MsRg_Dir.DateN) >= MsRg_Scn.LastRead);
   TempResult := TempResult AND (RwConfig.FileListOffline OR NOT (isrequest IN MsRg_Dir.FileStat));

   IF RwConfig.FileListMaxDays > 0 THEN
      TempResult := TempResult AND (RGF2Unix(MsRg_Dir.DateN) >= CurrentSecsFunc-(RwConfig.FileListMaxDays*86400));

   CheckFileProcess := TempResult;
END;


PROCEDURE ProcessOneDir;
VAR ThisFile,ExtLine,DescPos:Word; NoMoreExt:Boolean; TempS:String;
BEGIN
  Inc(DirTotalsNum);

  DirTotals^[DirTotalsNum].AreaNum := ThisBase;
  DirTotals^[DirTotalsNum].NumFiles := 0;
  DirTotals^[DirTotalsNum].NumBytes := 0;

  IF FileSize(MsRg_DirFile) > 0 THEN FOR ThisFile := 0 TO (FileSize(MsRg_DirFile)-1) DO
    BEGIN
      MsRg_DirFileRead(ThisFile);

      IF CheckFileProcess THEN
        BEGIN
          IF DirTotals^[DirTotalsNum].NumFiles = 0 THEN
            BEGIN
              WriteLn(OutFile,'');
              WriteLn(OutFile,'Ŀ');
              WriteLn(OutFile,'ݱ Area: '+
                              PadRight(StripColor(MsRg_FArea.Name)+' (#'+StrFunc(ThisBase+1)+') ','',67)+
                              '');
              WriteLn(OutFile,'');

              TempS := ' Filename.Ext Bytes   ';
              IF RwConfig.FileListDates   THEN TempS := TempS + 'Date     ';
              IF RwConfig.FileListCredits THEN TempS := TempS + 'Cred ';
              DescPos := Length(TempS);
              WriteLn(OutFile,TempS+'Description                                  ');

              TempS := ' ------------ ------- ';
              IF RwConfig.FileListDates   THEN TempS := TempS + '-------- ';
              IF RwConfig.FileListCredits THEN TempS := TempS + '---- ';
              DescPos := Length(TempS);
              WriteLn(OutFile,TempS+'---------------------------------------------');
            END;
          Inc(DirTotals^[DirTotalsNum].NumFiles);
          DirTotals^[DirTotalsNum].NumBytes := DirTotals^[DirTotalsNum].NumBytes+MsRg_DirFileSize;

          Write(OutFile,'*'+PadRight(MsRg_Dir.FileName,' ',13));

          IF (isrequest IN MsRg_Dir.FileStat)
             THEN Write(OutFile,'Offline ')
             ELSE Write(OutFile,PadRight(StrFunc(MsRg_DirFileSize),' ',8));

          IF (RwConfig.FileListDates)   THEN Write(OutFile,PadRight(MsRg_Dir.Date,' ',9));
          IF (RwConfig.FileListCredits) THEN Write(OutFile,PadRight(StrFunc(MsRg_Dir.Credits),' ',5));

          WriteLn(OutFile,MsRg_Dir.Description);

          IF (MsRg_Dir.vPointer >= 0) AND (MsRg_Dir.vPointer*MsRg_ExtSize*51 < FileSize(MsRg_ExtFile)) THEN
             BEGIN
                MsRg_ExtRead(MsRg_Dir.vPointer);
                NoMoreExt := FALSE;
                FOR ExtLine := 1 TO MsRg_ExtSize DO
                   IF (MsRg_Ext.Descr[ExtLine] <> '') AND (NOT NoMoreExt)
                      THEN WriteLn(OutFile,RepChar(' ',DescPos)+MsRg_Ext.Descr[ExtLine])
                      ELSE NoMoreExt := TRUE;
             END;

          IF RwConfig.FileListUploader THEN
             WriteLn(OutFile,RepChar(' ',DescPos)+'Uploaded by '+FormatName(MsRg_Dir.stOwner));
        END;
    END; { For }

  IF RwConfig.FileListAreaT AND (DirTotals^[DirTotalsNum].NumFiles > 0) THEN
    BEGIN
      WriteLn(OutFile,'');
      IF DirTotals^[DirTotalsNum].NumFiles > 1
         THEN WriteLn(OutFile,' Total of '+StrFunc(DirTotals^[DirTotalsNum].NumFiles)+
                              ' files ('+
                              NumberCommas(DirTotals^[DirTotalsNum].NumBytes)+
                              ' bytes) in this area')
         ELSE WriteLn(OutFile,' Total of 1 file ('+
                              NumberCommas(DirTotals^[DirTotalsNum].NumBytes)+
                              ' bytes) in this area');
      WriteLn(OutFile,'');
    END; { If }
END;


PROCEDURE ProcessDirs;
VAR GrandBlocks,
    GrandFiles  : LongInt;
    GrandBytes,
    DirCounter  : Word;
    OneLine,
    StrBlocks,
    StrBytes    : String;
    FooterFile  : Text;
    ch          : Char;
BEGIN
   DirTotalsNum := 0;
   IF FileSize(MsRg_FAreaFile) > 0 THEN FOR ThisBase := 0 TO (FileSize(MsRg_FAreaFile)-1) DO
     BEGIN
        IF fk_KeyPressed THEN
          BEGIN
             ch := UpCase(fk_Read);
             IF Ch = ' ' THEN
                BEGIN
                  RWM_WriteColor('%LF%LF'+RWM_GetString(28));
                  Rwfl_Aborted := TRUE;
                  Exit;
               END;
         END;

       MsRg_FAreaRead(ThisBase);

       IF EvalAcs(MsRg_FArea.Acs) AND NOT (fbCdRom IN MsRg_FArea.fbStat) AND FExists(MsRg_FAreaGetDir+'.DIR') THEN
          BEGIN
             MsRg_Scn.NewScan := TRUE;
             MsRg_Scn.LastRead := 0;
             Assign(MsRg_ScnFile,MsRg_General.DataPath+MsRg_FArea.FileName+'.SCN');
             IF FExists(MsRg_General.DataPath+MsRg_FArea.FileName+'.SCN')
                THEN Reset(MsRg_ScnFile)
                ELSE Rewrite(MsRg_ScnFile);
             MsRg_ScnRead(RgUserNum-1);

             IF MsRg_Scn.NewScan THEN
                BEGIN
                   MsRg_DirFileOpen;
                   RWM_WriteColor(RWM_GetString(49));
                   ProcessOneDir;
                   Flush(OutFile);
                   MsRg_DirFileClose;
                END;

             MsRg_Scn.LastRead := CurrentSecsFunc;
             MsRg_ScnWrite(RgUserNum-1);
             Close(MsRg_ScnFile);
          END;
     END;

   IF RwConfig.FileListGrandT AND (DirTotalsNum > 0) THEN
     BEGIN
       DirCounter := 1;
       WriteLn(OutFile,'Ŀ');
       WriteLn(OutFile,'ݱ Area Information/Totals ');
       WriteLn(OutFile,'');
       WriteLn(OutFile,' Directory Name                                          # Fls         # Bytes');
       WriteLn(OutFile,' ------------------------------------------------------- ------ --------------');
       GrandFiles := 0;
       GrandBlocks := 0;
       GrandBytes := 0;
       WHILE DirCounter <= DirTotalsNum DO
         BEGIN
           IF (DirTotals^[DirCounter].NumFiles > 0) AND
              (DirTotals^[DirCounter].AreaNum < FileSize(MsRg_FAreaFile)) THEN
             BEGIN
               MsRg_FAreaRead(DirTotals^[DirCounter].AreaNum);

               Write(OutFile,' '+PadRight(StripColor(MsRg_FArea.Name)+' ','.',56)+
                                 PadLeft(StrFunc(DirTotals^[Dircounter].NumFiles),' ',6));
               WriteLn(OutFile,PadLeft(NumberCommas(DirTotals^[Dircounter].NumBytes),' ',15));
               GrandFiles  := GrandFiles  + LongInt(DirTotals^[Dircounter].NumFiles);
               GrandBlocks := GrandBlocks + (DirTotals^[Dircounter].NumBytes DIV 1000);
               GrandBytes  := GrandBytes  + (DirTotals^[Dircounter].NumBytes MOD 1000);
             END;
           Inc(DirCounter);
         END;
       GrandBlocks := GrandBlocks + (GrandBytes DIV 1000);
       GrandBytes  := GrandBytes MOD 1000;
       WriteLn(OutFile,RepChar(' ',57)+'------ --------------');
       Write(OutFile,' Directory Totals:                                    ');
       Write(OutFile,PadLeft(StrFunc(GrandFiles),' ',8));
       IF GrandBlocks = 0 THEN StrBlocks := ''                  ELSE StrBlocks := NumberCommas(GrandBlocks);
       IF GrandBlocks = 0 THEN StrBytes  := StrFunc(GrandBytes) ELSE StrBytes := ','+PadLeft(StrFunc(GrandBytes),'0',3);
       WriteLn(OutFile,PadLeft(StrBlocks+StrBytes,' ',15));
     END; { If }

   WriteLn(OutFile,'');

   IF (RwConfig.FileListFtr <> '') AND FExists(RwConfig.FileListFtr) THEN
      BEGIN
         Assign(FooterFile,RwConfig.FileListFtr);
         Reset(FooterFile);
         WHILE NOT Eof(FooterFile) DO
            BEGIN
               ReadLn(FooterFile,OneLine);
               WriteLn(OutFile,OneLine);
            END;
         WriteLn(OutFile);
         Close(FooterFile);
      END;

   WriteLn(OutFile,'');
   WriteLn(OutFile,' This file list was compiled using ReneWave v'+RwVer);
   WriteLn(OutFile,' Copyright 1994-1996 by Lars Hellsten and MatrixSoft, All Rights Reserved');
END; { ProcessDirs }


PROCEDURE DeInitDataFiles;
BEGIN
   MsRg_FAreaClose;
   MsRg_ExtClose;
   Close(OutFile);
END;


PROCEDURE RWF_CreateFileList(fn:String);
BEGIN
   RWM_WriteColor(RWM_GetString(34));
   InitDataFiles(fn);
   ProcessDirs;
   DeInitDataFiles;
END;


END.
