PROGRAM RWLCOMP;

(* 

    RWLCOMP - RENEWAVE Language Compiler v2.00, for use with ReneWave v2.00+ 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES  DOS,
      CRT,
      MISC1,
      MSTRINGS,
      RWSTRUCT;

CONST LcVer = '2.00';
      MaxStrings = 512;

TYPE  RwStrTableType = Array[1..MaxStrings] OF RECORD
         Ofs : Word;
         Len : Byte;
      END;

      RwStrBuffType = Array[1..1] OF Char;

VAR   LangName     : String;
      LangText     : Text;
      LangFile     : FILE;

      StrTable     : RwStrTableType;
      StrBuff      : ^RwStrBuffType;
      StrBuffSize  : Word;

      SetupRwF     : FILE OF ConfigRec;
      SetupRw      : ConfigRec;


PROCEDURE IntroScreen;
BEGIN
    ClrScr;
    WritePipe('|16|09|09|01|16');
    WritePipe('|17|09|15 RWLCOMP - RENEWAVE Language Compiler v2.00, for use with ReneWave v2.00+     |08|16');
    WritePipe('|17|09|09 Copyright (C) 1996 by Lars Hellsten, All Rights Reserved.                    |08|16');
    WritePipe('|17|09|07 Future Shock - The MatrixSoft Support BBS (416)494-9237 / 1:259/412          |08|16');
    WritePipe('|16|01|08|08|16');
    WritePipe(#13#10);
END;


PROCEDURE HelpScreen;
BEGIN
    IntroScreen;
    WritePipe('|09 |11Syntax  : |03RWLCOMP.EXE <language>'+#13#10);
    WriteLn;
    WritePipe('|07RWLCOMP.EXE must exist in the directory where SETUP.RW is located.  The'+#13#10);
    WritePipe('|07file <langauge>.RW must exist in your ReneWave MENU/TEXT directory.'+#13#10);
    WriteLn;
    Halt;
END;


PROCEDURE ProcessParams;
BEGIN
   IF ParamCount < 1 THEN HelpScreen;
   LangName := ParamStr(1);
END;


PROCEDURE InitDataFiles;
BEGIN
   IntroScreen;

   IF NOT FExists(ExtractFDir(ParamStr(0))+'SETUP.RW') THEN HelpScreen;

   Assign(SetupRwF,ExtractFDir(ParamStr(0))+'SETUP.RW');
   Reset(SetupRwF);
   Seek(SetupRwF,0);
   Read(SetupRwF,SetupRw);
   Close(SetupRwF);

   IF NOT FExists(SetupRw.RwLangDir+LangName+'.RW') THEN HelpScreen;

   Assign(LangText,SetupRw.RwLangDir+LangName+'.RW');
   Reset(LangText);
   Assign(LangFile,SetupRw.RwLangDir+LangName+'.RWL');
   Rewrite(LangFile,1);
END;


PROCEDURE DeInitDataFiles;
BEGIN
   WritePipe('|10*DONE*'+#13#10#13#10);
   Close(LangFile);
   Close(LangText);
END;


PROCEDURE GetSize;
VAR s:String; b:Byte;
BEGIN
   Reset(LangText);
   StrBuffSize := 0;
   WHILE NOT Eof(LangText) DO
      BEGIN
         ReadLn(LangText,s);

         s := StripLeadingCh(s,' ');
         s := StripTrailingCh(s,' ');
         b := Pos(' ',s);

         IF (b > 0) THEN
            IF (ValFunc(Copy(s,1,b-1)) > 0) THEN
               BEGIN
                  s := Copy(s,b+1,Length(s)-b);
                  StrBuffSize := StrBuffSize + Length(s);
               END;
    END;
END;


PROCEDURE ProcessText;
VAR s:String; b:Byte; StringNum:Word; BuffOfs:Word;
BEGIN
   GetSize;
   GetMem(StrBuff,StrBuffSize);
   FreeMem(StrBuff,StrBuffSize);
   Reset(LangText);
   BuffOfs := 1;

   WritePipe('|07Language text size: |11'+StrFunc(StrBuffSize)+' bytes'+#13#10);

   FillChar(StrBuff^,SizeOf(StrBuff^),0);
   FillChar(StrTable,SizeOf(StrTable),0);

   WHILE NOT Eof(LangText) DO
      BEGIN
         ReadLn(LangText,s);

{         s := StripTrailingCh(s,' ');}
         b := Pos(' ',s);

         IF (b > 0) THEN
            IF (ValFunc(Copy(s,1,b-1)) > 0) THEN
               BEGIN
                  StringNum := ValFunc(Copy(s,1,b-1));
                  IF (StringNum > 0) AND (StringNum <= MaxSTrings) THEN
                     BEGIN
                        s := Copy(s,b+1,Length(s)-b);
                        StrTable[StringNum].Ofs := BuffOfs;
                        StrTable[StringNum].Len := Length(s);
                        Move(s[1],StrBuff^[BuffOfs],Length(s));
                        BuffOfs := BuffOfs + Length(s);
                        IF s[1] = '@' THEN WritePipe('|07Warning: DISPLAY FILE from string '+StrFunc(StringNum)+#13#10);
                     END;
               END;
      END;

   BlockWrite(LangFile,StrTable,SizeOf(StrTable));
   BlockWrite(LangFile,StrBuff^,StrBuffSize);
END;


BEGIN
   ProcessParams;
   InitDataFiles;
   ProcessText;
   DeInitDataFiles;
END.
