{$O+,F+,I-}
UNIT RWUP2;

(* 

    RWUP2 - ReneWave upload processing routines

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

USES  RWMAIN,RWVARS;

TYPE  TServerVar = RECORD
         Name     : String[20];
         Data     : String[60];
      END;

      TServerInfo = RECORD
         Name,
         Password,
         Command  : String[8];
         ACS,
         Title    : String[40];
         Options  : String[127];
      END;

VAR   ServerReq     : Array[1..MaxServerReq] OF LongInt;
      ServerReqNum  : Byte;

      ServerVar     : Array[1..MaxServerVar] OF TServerVar;
      ServerVarNum  : Byte;


PROCEDURE RWU_DlFreqFile;
PROCEDURE RWU_ProcFREQ;
PROCEDURE RWU_ProcNewConfig;
PROCEDURE RWU_ProcOlc;
PROCEDURE RWU_ProcServerReq;


IMPLEMENTATION


USES  {$I FOSSTYPE.INC }

      DOS,      CRT,      MSTRINGS, UNIXDATE, MISC1,
      SPIN,     RWBT,     RWLOGS,   MSRGGEN,  RWAREAS,  RWACS,
      RWSTRUCT, RECORDS,  BWSTRUCT, RWMENUS,  RWINIT,   RWUP,
      MSBWGEN;


PROCEDURE RWU_DlFreqFile;
VAR FileName,s1,s2:String; ch:Char; FileK:LongInt;

    PROCEDURE UpdateStats;
    BEGIN
       MsRg_UserFileOpen;
       IF MsRg_General.RewardSystem AND (FileSize(MsRg_UserFile) > MsRg_Dir.Owner*MsRg_USerRecSize) THEN
          BEGIN
             MsRg_UserFileRead(MsRg_Dir.Owner);
             MsRg_User.Credit := MsRg_User.Credit+(LongInt(MsRg_General.RewardRatio DIV 100)*MsRg_Dir.Credits);
             MsRg_UserFileWrite(Msrg_Dir.Owner);
          END;
       MsRg_UserFileRead(RgUserNum);
       MsRg_User.Downloads := MsRg_User.Downloads+1;
       MsRg_User.DLToday   := MsRg_User.DLToday+1;
       MsRg_User.DK        := MsRg_User.DK + FileK;
       MsRg_User.DLKToday  := MsRg_User.DLKToday + FileK;

       WITH MsRg_General,MsRg_User DO
          IF FileCreditRatio AND NOT EvalAcs(NoFileCredits) AND NOT (fNoCredits IN Flags) THEN
             MsRg_User.Debit := MsRg_User.Debit+MsRg_Dir.Credits;

       MsRg_UserFileWrite(RgUserNum);
       MsRg_UserFileClose;

       MsRg_HistFileOpen;
       MsRg_HistFileRead(FileSize(MsRg_HistFile)-1);
       MsRg_History.Downloads := MsRg_History.Downloads+1;
       MsRg_History.DK := MsRg_History.DK+FileK;
       MsRg_HistFileWrite(FileSize(MsRg_HistFile)-1);
       MsRg_HistFileClose;

       MsRg_GeneralRead;
       Inc(MsRg_General.TotalDLoads);
       MsRg_GEneralWrite;
    END;

    PROCEDURE DispInfo;
    VAR ExtLine:Byte;
    BEGIN
       RwVariables^[1] := MsRg_Dir.FileName;
       RwVariables^[2] := NumberCommas(MsRg_DirFileSize);
       RwVariables^[3] := MsRg_Dir.Date;
       RwVariables^[4] := StrFunc(MsRg_Dir.Credits);
       RwVariables^[5] := MsRg_Dir.Description;

       RWM_WriteColor(RWM_GetString(166));
       RWM_WriteColor(RWM_GetString(167));
       RWM_WriteColor(RWM_GetString(168));
       RWM_WriteColor(RWM_GetString(169));
       RWM_WriteColor(RWM_GetString(170));
       RWM_WriteColor(RWM_GetString(171));

       IF (MsRg_Dir.vPointer >= 0) AND FExists(MsRg_General.DataPath+'EXTENDED.DAT') THEN
          BEGIN
             MsRg_ExtOpen;
             IF ((MsRg_Dir.vPointer*MsRg_ExtSize) <= (FileSize(MsRg_ExtFile)-1)) THEN
                BEGIN
                   MsRg_ExtRead(MsRg_Dir.vPointer);
                   ExtLine := 1;
                   WHILE (Ord(MsRg_Ext.Descr[ExtLine][0]) > 0) AND (ExtLine <= MsRg_ExtSize) DO
                      BEGIN
                         RwVariables^[5] := MsRg_Ext.Descr[ExtLine];
                         RWM_WriteColor(RWM_GetString(172));
                         Inc(ExtLine);
                      END;
                END;
             MsRg_ExtClose;
          END;
       RWM_WriteColor(#13#10);
    END;

    FUNCTION CheckDownload:Boolean;
    VAR TempRes:Boolean;
    BEGIN
       TempRes := TRUE;
       FileK := MsRg_DirFileSize DIV 1024;
       WITH MsRg_General,MsRg_User DO
          BEGIN
             IF UlDlRatio AND NOT EvalAcs(NoDlRatio) AND NOT (FNoDlRatio IN Flags) THEN
                BEGIN
                   TempRes := ((DK+FileK) / UK <= DLKRatio[SL]) AND ((Downloads+1) / Uploads <= DLRatio[SL]);
                   IF NOT TempRes THEN RWM_WriteColor(RWM_GetString(23));
                END;
             IF TempRes AND FileCreditRatio AND NOT EvalAcs(NoFileCredits) AND NOT (FNoCredits IN Flags) THEN
                BEGIN
                   TempRes := (Credit-Debit) >= MsRg_Dir.Credits;
                   IF NOT TempRes THEN RWM_WriteColor(RWM_GetString(24));
                END;
             IF TempRes AND DailyLimits THEN
                BEGIN
                   TempRes := (DLToday < DLOneDay[SL]) AND (DLKToday+FileK <= DLKOneDay[SL]);
                   IF NOT TempRes THEN RWM_WriteColor(RWM_GetString(25));
                END;
          END;
       CheckDownload := TempRes;
    END;

BEGIN
   DispInfo;

   IF NOT CheckDownload THEN Exit;

   IF NOT WarpUL THEN
      BEGIN
         RWM_WriteColor(RWM_GetString(165));
         ch := RWM_GetYesOrNo(TRUE);
         IF (ch = RWM_GetCh(4,1)) THEN
            BEGIN
               RWL_WriteLog('+',RWL_LogTime+'    "'+FileName+'" - chose not to download.');
               Exit;
            END;
      END;
   RWL_WriteLog('+',RWL_LogTime+'    "'+FileName+'" - sending file.');

   IF FExists(MsRg_FArea.ulPath+MsRg_Dir.FileName)
      THEN FileName := MsRg_FArea.ULPath+MsRg_Dir.FileName
      ELSE FileName := MsRg_FArea.DLPath+MsRg_Dir.FileName;

   IF (fk_Fossil.Baud > 0) THEN IF NOT RWB_SendFile(RwUser.RwProtocol) THEN
      BEGIN
         IF NOT WarpUL THEN RWM_Pause;
         Exit;
      END;

   UpdateStats;
END;


PROCEDURE RWU_ProcFREQ;
VAR ThisFreq : Word;
    FreqFile : FILE OF ReqRec;
    Freq     : ReqRec;
    FoundAny : Boolean;
    FileName : String;

    PROCEDURE ProcOneBase;
    VAR i,ThisFreq,ThisFile:LongInt;
    BEGIN
       MsRg_DirFileOpen;
       IF FileSize(MsRg_DirFile) = 0 THEN
          BEGIN
             MsRg_DirFileClose;
             Exit;
          END;
       RWM_WriteColor(#13+'|09 |11Processing file request: |07'+PadRight(StripColor(MsRg_FArea.Name),' ',40));
       FOR ThisFile := 0 TO (FileSize(MsRg_DirFile)-1) DO
          BEGIN
             MsRg_DirFileRead(ThisFile);
             MsRg_Dir.FileName := StripChar(MsRg_Dir.FileName,' ');
             MsRg_Dir.FileName := UpcaseStr(MsRg_Dir.FileName);
             FOR ThisFreq := 0 TO (FileSize(FreqFile)-1) DO
                BEGIN
                   Seek(FreqFile,ThisFREQ);
                   Read(FreqFile,Freq);
                   FileName := Nul2Str(Freq.FileName,12);
                   FileName := StripChar(FileName,' ');
                   FileName := UpcaseStr(FileName);
                   IF MatchWildcards(FileName,MsRg_Dir.FileName) AND
                      (NOT (NotVal IN MsRg_Dir.FileStat)) AND
                      (NOT (IsRequest IN MsRg_Dir.FileStat)) AND
                      (NOT (ResumeLater IN MsRg_Dir.FileStat)) AND
                      (FExists(MsRg_FArea.ULPath+MsRg_Dir.FileName) OR
                       FExists(MsRg_FArea.DLPath+MsRg_Dir.FileName))
                      THEN BEGIN
                         FoundAny := TRUE;
                         ClrScr;
                         RWU_DlFreqFile;
                         ClrScr;
                      END;
                END;
          END;
       MsRg_DirFileClose;
    END;

BEGIN
   fk_ClrScr;
   FoundAny := FALSE;

   IF NOT Regd THEN
      BEGIN
         RWL_WriteLog('!',RWL_LogTime+'    Aborted - File requests are a registered-only feature!');
         RWM_WriteColor('|12Sorry, your file request could not be processed - file requests are only'+#13#10);
         RWM_WriteColor('|12available in registered copies of ReneWave.'+#13#10);
         RWM_Pause;
         Exit;
      END;
   IF NOT EvalAcs(RwConfig.FileReqACS) THEN
      BEGIN
         RWL_WriteLog('?',RWL_LogTime+'    Aborted - Does not have file request access.');
         RWM_WriteColor(RWM_GetString(173));
         Exit;
      END;

   MsRg_FAreaOpen;
   Assign(FreqFile,RwWorkDir+RwConfig.BBSID+'.REQ');
   Reset(FreqFile);

   IF FileSize(FreqFile) > 0 THEN
      BEGIN
         RWL_WriteLog('+',RWL_LogTime+' Processing file request:');
         FOR ThisFREQ := 0 TO (FileSize(FreqFile)-1) DO
            BEGIN
               Seek(FreqFile,ThisFREQ);
               Read(FreqFile,Freq);
               RWL_WriteLog('+',RWL_LogTime+'    '+Nul2Str(Freq.FileName,12));
            END;
         IF FileSize(MsRg_FAreaFile) > 0 THEN FOR ThisBase := 0 TO (FileSize(MsRg_FAreaFile)-1) DO
            BEGIN
               MsRg_FAreaRead(ThisBase);
               IF (EvalAcs(MsRg_FArea.Acs)) AND (EvalAcs(MsRg_FArea.DlAcs)) THEN ProcOneBase;
            END;
      END;

   IF NOT FoundAny THEN RWM_WriteColor(RWM_GetString(174));

   MsRg_FAreaClose;
   Close(FreqFile);
END;


PROCEDURE RWU_ProcNewConfigAreas;
TYPE TNewAreasArr = Array[1..1] OF String[8];
VAR  NewAreas     : ^TNewAreasArr;
     Pdq          : PdqArea;
     PdqLen       : Word;
     i            : Word;

     PROCEDURE InitAreasList;
     VAR PdqNum:Word;
     BEGIN
        PdqLen := (FileSize(PdqFile)-SizeOf(PdqRec)) DIV SizeOf(PdqArea);
        GetMem(NewAreas,PdqLen*9);
        FOR PdqNum := 0 TO (PdqLen-1) DO
           BEGIN
              Seek(PdqFile,SizeOf(PdqRec)+(LongInt(SizeOf(PdqArea))*PdqNum));
              BlockRead(PdqFile,Pdq,SizeOf(Pdq),BytesRead);
              NewAreas^[PdqNum+1] := Nul2Str(Pdq.EchoTag,12);
           END;
     END;

     PROCEDURE ToggleBase(ToggleOn:Boolean);
     VAR i:Word;
     BEGIN
        i := MsRg_MArea.QwkIndex;
        IF (ToggleOn=TRUE)
           THEN BEGIN
                 RwBaseIdx^[ThisBase] := -i;
                 ScanInfo^[i] := ScanInfo^[i]+[scn_Selected]-[scn_PersonalAll,scn_PersonalOnly];
              END
           ELSE RWA_ToggleBase(ThisBase,'-');
     END;

     PROCEDURE ProcAreasList;
     VAR NewAreasPos,i:Word;
     BEGIN
        FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
           BEGIN
              MsRg_MAreaRead(ThisBase);
              IF EvalAcs(MsRg_MArea.Acs) THEN
                 BEGIN
                    NewAreasPos := 1;
                    WHILE (NewAreas^[NewAreasPos] <> MsRg_MArea.FileName) AND (NewAreasPos <= PdqLen) DO Inc(NewAreasPos);
                    IF (NewAreas^[NewAreasPos] = MsRg_MArea.FileName)
                       THEN ToggleBase(TRUE)
                       ELSE ToggleBase(FALSE);
                 END;
        END;
     END;

     PROCEDURE DeInitScanInfo;
     BEGIN
        Seek(ScanInfoFile,RwUserNum);
        BlockWrite(ScanInfoFile,ScanInfo^,1);
        Close(ScanInfoFile);
     END;

     PROCEDURE InitScanInfo;
     BEGIN
        Assign(ScanInfoFile,RwConfig.RwMainDir+'SCANINFO.RW');
        IF NOT FExists(RwConfig.RwMainDir+'SCANINFO.RW')
           THEN Rewrite(ScanInfoFile,4096)
           ELSE Reset(ScanInfoFile,4096);

        IF RwUserNum >= FileSize(ScanInfoFile) THEN RWI_InitScanInfo;

        Seek(ScanInfoFile,RwUserNum);
        BlockRead(ScanInfoFile,ScanInfo^,1,BytesRead);
     END;


BEGIN
   RWM_WriteColor('|09Updating area configuration ... |07');

   InitScanInfo;
   InitAreasList;
   ProcAreasList;
   DeInitScanInfo;

   FreeMem(NewAreas,PdqLen*9);
   NewAreas := NIL;
   RWM_WriteColor(RepChar(#8,4)+'|15Done!'+#13#10#13#10);
END;


PROCEDURE RWU_ProcNewConfig;
VAR Pdq:PdqRec;

    PROCEDURE DoChanges(Pdq:PdqRec);
    VAR Counter:Word;
    BEGIN
       FOR Counter := 1 TO 10 DO
          BEGIN
             RwUser.Keywords[Counter] := Nul2Str(Pdq.Keywords[Counter],20);
             RwUser.Filters [Counter] := Nul2Str(Pdq.Filters [Counter],20);
          END;
       FOR Counter := 1 TO 3 DO
          RwUser.BundlMacros[Counter] := Nul2Str(Pdq.Macros[Counter],76);

       RwUser.RwPass := DecryptPW(Nul2Str(Pdq.Password,20));
       RwUser.PassUsage := Pdq.PassType;

       IF (PdqHotkeys   IN Pdq.Flags) THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwHotkeys];
       IF (PdqXpert     IN Pdq.Flags) THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwXpert];
       IF (PdqNotMyMail IN Pdq.Flags) THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNotMyMail];

       Seek(RwUserFile,RwUserNum);
       Write(RwUserFile,RwUser);
    END;

BEGIN
   Assign(PdqFile,RwWorkDir+RwConfig.BBSID+'.PDQ');
   Reset(PdqFile,1);

   IF FileSize(PdqFile) < SizeOf(PdqRec) THEN
      BEGIN
         Close(PdqFile);
         Exit;
      END;

   RWM_KeyPressOff;
   RWM_WriteColor(RWM_GetString(330));
   RWL_WriteLog('+',RWL_LogTime+' Updating user''s configuration.');

   Seek(PdqFile,0);
   BlockRead(PdqFile,Pdq,SizeOf(PdqRec),BytesRead);
   DoChanges(Pdq);

   RWM_WriteColor(RWM_GetString(331));

   IF (PdqAreaChanges IN Pdq.Flags) AND (FileSize(PdqFile) >= SizeOf(PdqRec)+SizeOf(PdqArea))
      THEN RWU_ProcNewConfigAreas;

   RealDelay(500);
   Close(PdqFile);
   RWM_KeyPressOn;
END;


PROCEDURE RWU_ProcOlc;
TYPE AreaListRec = RECORD
        Name     : String[8];
        TogType  : Byte;
     END;
     TAreaList   = Array[1..1] OF AreaListRec;

VAR  AreaList    : ^TAreaList;
     AreaListLen : Word;
     i           : Word;

     OlcFile     : Text;
     s,s2        : String;
     CurrFilter  : Byte;
     CurrKeyword : Byte;
     CurrMacro   : Byte;
     AreaChanges : Boolean;

BEGIN
   IF NOT FExists(RwWorkDir+RwConfig.BBSID+'.OLC') THEN Exit;
   Assign(OlcFile,RwWorkDir+RwConfig.BBSID+'.OLC');
   Reset(OlcFile);

   RWM_KeyPressOff;
   RWM_WriteColor(RWM_GetString(330));
   RWL_WriteLog('+',RWL_LogTime+' Updating configuration.');

   CurrFilter := 0;
   CurrKeyword := 0;
   CurrMacro := 0;
   Move(MsgTxtBuff,AreaList,SizeOf(MsgTxtBuff));
   AreaListLen := 0;

   FillChar(RwUser.Keywords,SizeOf(RwUser.Keywords),0);
   FillChar(RwUser.Filters,SizeOf(RwUser.Filters),0);
   FillChar(RwUser.BundlMacros,SizeOf(RwUser.BundlMacros),0);

   WHILE NOT Eof(OlcFile) DO
      BEGIN
         ReadLn(OlcFile,s);
         s := UpcaseStr(s);
         s := StripLeadingCh(s,' ');
         s := StripTrailingCh(s,' ');
         IF Copy(s,1,14) = 'MENUHOTKEYS = ' THEN
            BEGIN
               IF Copy(s,15,Length(s)-14) = 'ON'
                  THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwHotkeys]
                  ELSE RwUser.BWaveFlags := RwUser.BWaveFlags-[RwHotkeys];
            END
         ELSE IF Copy(s,1,14) = 'EXPERTMENUS = ' THEN
            BEGIN
               IF Copy(s,15,Length(s)-14) = 'ON'
                  THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwXpert]
                  ELSE RwUser.BWaveFlags := RwUser.BWaveFlags-[RwXpert];
            END
         ELSE IF Copy(s,1,14) = 'AREACHANGES = ' THEN
            BEGIN
               AreaChanges := Copy(s,15,Length(s)-14) = 'ON';
            END
         ELSE IF Copy(s,1,15) = 'SKIPUSERMSGS = ' THEN
            BEGIN
               IF Copy(s,16,Length(s)-15) = 'ON'
                  THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNotMyMail]
                  ELSE RwUser.BWaveFlags := RwUser.BWaveFlags-[RwNotMyMail];
            END
         ELSE IF Copy(s,1,20) = 'NUMERICEXTENSIONS = ' THEN
            BEGIN
               IF Copy(s,21,Length(s)-20) = 'ON'
                  THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNumericPkt]
                  ELSE RwUser.BWaveFlags := RwUser.BWaveFlags-[RwNumericPkt];
            END
         ELSE IF Copy(s,1,14) = 'NEWFILELIST = ' THEN
            BEGIN
               IF Copy(s,15,Length(s)-14) = 'OFF'
                  THEN RwUser.BWAveFlags := RwUser.BWaveFlags-[RwFileList]
                  ELSE RwUser.BWaveFlags := RwUser.BWaveFlags+[RwFileList];
            END
         ELSE IF Copy(s,1,16) = 'MAXPACKETSIZE = ' THEN
            BEGIN
               IF (ValFunc(Copy(s,17,Length(s)-15)) >= 0) AND (s[Length(s)]='K')
                  THEN RwUser.MsgsLimit := ValFunc(Copy(s,17,Length(s)-15));
            END
         ELSE IF Copy(s,1,11) = 'PASSWORD = ' THEN
            BEGIN
               s2 := Copy(s,12,Length(s)-11);
               IF GetSegment(s2,1,',') = 'OFF'
                  THEN RwUser.PassUsage := 0
                  ELSE BEGIN
                        RwUser.RwPass := GetSegment(s2,2,',');
                        IF GetSegment(s2,1,',') = 'DOOR' THEN RwUser.Passusage := 1 ELSE
                        IF GetSegment(s2,1,',') = 'READER' THEN RwUser.PassUsage := 2 ELSE
                        IF GetSegment(s2,1,',') = 'BOTH' THEN RwUser.PassUsage := 3;
                     END;
            END
         ELSE IF Copy(s,1,9) = 'FILTER = ' THEN
            BEGIN
               Inc(CurrFilter);
               IF CurrFilter <= 10 THEN RwUser.Filters[CurrFilter] := Copy(s,10,Length(s)-9);
            END
         ELSE IF Copy(s,1,10) = 'KEYWORD = ' THEN
            BEGIN
               Inc(CurrKEyword);
               IF CurrKeyword <= 10 THEN RwUser.Keywords[CurrKeyword] := Copy(s,11,Length(s)-10);
            END
         ELSE IF Copy(s,1,8) = 'MACRO = ' THEN
            BEGIN
               Inc(CurrMacro);
               IF CurrMacro <= 3 THEN RwUser.BundlMacros[CurrMacro] := Copy(s,9,Length(s)-8);
            END
         ELSE IF (s = '') AND AreaChanges THEN
            BEGIN
               WHILE NOT Eof(OlcFile) DO
                  BEGIN
                     ReadLn(OlcFile,s);
                     s := StripLeadingCh(s,' ');
                     s := StripTrailingCh(s,' ');
                     IF (s[1] = '[') AND (s[Length(s)] = ']')
                        THEN BEGIN
                              Inc(AreaListLen);
                              AreaList^[AreaListLen].Name := UpcaseStr(Copy(s,2,Length(s)-2))
                           END
                        ELSE IF (Copy(UpcaseStr(s),1,7) = 'SCAN = ') THEN
                           BEGIN
                              s := UpcaseStr(Copy(s,8,Length(s)-7));
                              IF (s='ALL')      THEN AreaList^[AreaListLen].TogType := 0 ELSE
                              IF (s='PERSONLY') THEN AreaList^[AreaListLen].TogType := 1 ELSE
                              IF (s='PERS+ALL') THEN AreaList^[AreaListLen].TogType := 2;
                           END;
                  END;

               FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
                  IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
                     BEGIN
                        MsRg_MAreaRead(ThisBase);
                        i := 1;
                        AreaChanges := FALSE;
                        WHILE (i <= AreaListLen) AND (AreaChanges=FALSE) DO
                           BEGIN
                              AreaChanges := AreaList^[i].Name = MsRg_MArea.FileName;
                              IF NOT AreaChanges THEN Inc(i);
                           END;
                        IF AreaChanges
                           THEN BEGIN
                                 CASE AreaList^[i].TogType OF
                                    0 : RWA_ToggleBase(ThisBase,'+');
                                    1 : RWA_ToggleBase(ThisBase,'P');
                                    2 : RWA_ToggleBase(ThisBAse,'A');
                                 END;
                                 Move(AreaList^[i+1],AreaList^[i],SizeOf(AreaListRec)*(AreaListLen-i));
                              END
                           ELSE RWA_ToggleBase(ThisBase,'-');
                     END;
               RWM_WriteScanInfo;
            END;
      END;

   RWM_WriteColor(RWM_GetString(331));
   RWM_KeyPressOn;
   Close(OlcFile);
   RealDelay(500);
END;


PROCEDURE RWU_ProcServerReq;
VAR i,StrPos:Byte; ReqName,ReqPW:String; ServerInfo:TServerInfo;

    FUNCTION ExtractArguments(s:String):String;
    VAR StrPos:Byte; TempS:String;
    BEGIN
       TempS := '';
       StrPos := Pos(' ',s);
       IF StrPos > 0 THEN
          BEGIN
             TempS := Copy(s,StrPos,Length(s)-StrPos+1);
             TempS := StripLeadingCh(TempS,' ');
             TempS := StripTrailingCh(TempS,' ');
          END;
       ExtractArguments := TempS;
    END;

    PROCEDURE ProcServerReq;
    VAR VarNum,b:Byte;
    BEGIN
       IF ServerVarNum > 0 THEN FOR VarNum := 1 TO ServerVarNum DO
          BEGIN
             b := Pos('@'+ServerVar[VarNum].Name+'@',UpcaseStr(ServerInfo.Options));
             WHILE b > 0 DO
                BEGIN
                   Delete(ServerInfo.Options,b,2+Length(ServerVar[VarNum].Name));
                   Insert(ServerVar[VarNum].Data,ServerInfo.Options,b);
                   b := Pos('@'+ServerVar[VarNum].Name+'@',UpcaseStr(ServerInfo.Options));
                END;
          END;

       RwVariables^[5] := RwWorkDir+'SERVTEXT.REQ';

       ServerInfo.Options := MsRg_MciString(ServerInfo.Options);

       RwVariables^[2] := ServerInfo.Title;
       RwVariables^[3] := ServerInfo.Options;
       RwVariables^[4] := '"'+ReqPW+'"';

       IF NOT EvalAcs(ServerInfo.ACS) THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(220));
             Exit
          END;

       IF UpcaseStr(ReqPW) <> UpcaseStr(ServerInfo.Password) THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(219));
             Exit;
          END;

       RWM_WriteColor(RWM_GetString(216));
       RWM_WriteColor(RWM_GetString(217));
       RWM_WriteColor(RWM_GetString(218));

       IF ServerInfo.Command = 'SHELL'
          THEN DoorProc(ServerInfo.Options,FALSE)
          ELSE IF ServerInfo.Command = 'MENU' THEN
             CASE ServerInfo.Options[1] OF
                '&' : CASE ServerInfo.Options[2] OF
                         'T' : CASE ValFunc(GetWord(ServerInfo.Options,2)) OF
                                  00 : RWM_ToggleFormat;
                                  01 : RWM_ResetPointers;
                                  02 : RWM_ChooseArchiver;
                                  03 : RWM_ChooseProtocol;
                                  04 : RWM_DefinePassword;
                                  05 : RWM_ToggleBundleOwn;
                                  06 : RWM_ToggleHotkeys;
                                  07 : RWM_ToggleDelEmail;
                                  08 : RWM_ToggleExpert;
                                  09 : RWM_ToggleNumericPkt;
                                  10 : RWM_DefineSizeLimit;
                                  11 : RWM_DefineKeywords;
                                  12 : RWM_DefineFilters;
                                  13 : RWM_DefineMacros;
                                  14 : RWA_ChooseAreas;
                               END;
                      END;
                'H' : CASE ServerInfo.Options[2] OF
                         'I' : BEGIN
                                  RWL_WriteLog('=',RWL_LogTime+' User logged off; dropping carrier.');
                                  fk_CarrierLoss := RWB_CarrierLoss;
                                  fk_ToggleDTR(FALSE); RealDelay(2000);
                                  fk_ToggleDTR(TRUE);  RealDelay(1000);
                               END;
                      END;

             END;
    END;

    FUNCTION SearchServerFunc:Boolean;
    VAR ServerF:Text; Res:Boolean; s:String;
    BEGIN
       Res := FALSE;
       FillChar(ServerInfo,SizeOf(ServerInfo),0);
       IF FExists(RwConfig.RwMainDir+'RW_SERV.TXT') THEN
          BEGIN
             Assign(ServerF,RwConfig.RwMainDir+'RW_SERV.TXT');
             Reset(ServerF);
             WHILE NOT Res AND NOT Eof(ServerF) DO
                BEGIN
                   ReadLn(ServerF,s);
                   s := StripLeadingCh(StripTrailingCh(s,' '),' ');
                   IF (s[1] <> ';') THEN
                      BEGIN
                         IF Copy(s,1,8) = 'FUNCTION' THEN
                            BEGIN
                               Res := (ServerInfo.Name = ReqName) OR Res;
                               IF NOT Res THEN
                                  BEGIN
                                     s := UpcaseStr(ExtractArguments(s));
                                     FillChar(ServerInfo,SizeOf(ServerInfo),0);
                                     ServerInfo.Name := s;
                                  END;
                            END
                         ELSE IF Copy(s,1,8) = 'PASSWORD' THEN ServerInfo.Password := UpcaseStr(ExtractArguments(s))
                         ELSE IF Copy(s,1,3) = 'ACS'      THEN ServerInfo.Acs := ExtractArguments(s)
                         ELSE IF Copy(s,1,5) = 'TITLE'    THEN ServerInfo.Title := ExtractArguments(s)
                         ELSE IF Copy(s,1,7) = 'COMMAND'  THEN ServerInfo.Command := UpcaseStr(ExtractArguments(s))
                         ELSE IF Copy(s,1,7) = 'OPTIONS'  THEN ServerInfo.Options := ExtractArguments(s);
                      END;
                END;
             Res := (ServerInfo.Name = ReqName) OR Res;
          END;
       SearchServerFunc := Res;
    END;

    PROCEDURE ProcText;
    VAR BwReplyText,ServText:Text; s:String; b:Byte; Done:Boolean;
    BEGIN
       Assign(ServText,RwWorkDir+'SERVTEXT.REQ');
       Rewrite(ServText);
       ServerVarNum := 0;
       Done := FALSE;
       IF FExists(RwWorkDir+MsgTextName) THEN
          BEGIN
             Assign(bwReplyText,RwWorkDir+MsgTextName);
             Reset(bwReplyText);
             WHILE NOT Eof(bwReplyText) DO
                BEGIN
                   ReadLn(bwReplyText,s);
                   IF NOT Done THEN
                      BEGIN
                         s := StripLeadingCh(StripTrailingCh(s,' '),' ');
                         IF Copy(UpcaseStr(s),1,7) = 'SETVAR ' THEN
                            BEGIN
                               Delete(s,1,7);
                               s := StripLeadingCh(StripTrailingCh(s,' '),' ');
                               b := Pos(' ',s);
                               IF b > 0 THEN
                                 BEGIN
                                   Inc(ServerVarNum);
                                   ServerVar[ServerVarNum].Name := UpcaseStr(Copy(s,1,b-1));
                                   Delete(s,1,b);
                                   s := StripLeadingCh(StripTrailingCh(s,' '),' ');
                                   IF s[1] = '"' THEN Delete(s,1,1);
                                   IF s[Length(s)] = '"' THEN Dec(s[0]);
                                   ServerVar[ServerVarNum].Data := s;
                                 END;
                            END
                            ELSE BEGIN
                                Done := TRUE;
                            END;
                      END
                      ELSE WriteLn(ServText,s);
                END;
             Close(bwReplyText);
          END;
       Close(ServText);
    END;

BEGIN
   IF NOT Regd THEN
      BEGIN
         RWL_WriteLog('!',RWL_LogTime+'    Aborted - Server requests are a registered-only feature!');
         RWM_WriteColor('|12Sorry, your server request could not be processed - server requests are'+#13#10);
         RWM_WriteColor('|12only available in registered copies of ReneWave.'+#13#10);
         RWM_Pause;
         Exit;
      END;
   RWM_WriteColor(RWM_GetString(215));
   FOR i := 1 TO ServerReqNum DO
      BEGIN
         Seek(ReplyFile,ServerReq[i]);
         BlockRead(ReplyFile,Reply,bwReplyHdr.UplRecLen,BytesRead);
         MsgTextName := Nul2Str(Reply.FileName,12);
         ProcText;

         ReqPW := '';
         ReqName := UpcaseStr(Nul2Str(Reply.Subject,72));
         ReqName := StripLeadingCh(ReqName,' ');
         ReqName := StripTrailingCh(ReqName,' ');
         StrPos := Pos(' ',ReqName);
         IF StrPos > 0 THEN
            BEGIN
               ReqPW := Copy(ReqName,StrPos+1,Length(ReqName)-StrPos);
               REqName := Copy(ReqName,1,StrPos-1);
            END;
         RwVariables^[1] := ReqName;

         IF SearchServerFunc
            THEN ProcServerReq
            ELSE RWM_WriteColor(RWM_GetString(221));

      END;
   RWM_WriteColor(RWM_GetString(223));
END;


END.


