PROGRAM WB1toWB2;

{ ReneWave v1.00 Widbeta 1 -> Widebeta 2 conversion program }

USES DOS, STRINGS, MISC1, CRT, RWSTRUCT;

VAR OldConfigFile : FILE OF OldConfigRec;
    OldConfig     : OldConfigRec;
    ConfigFile    : FILE OF ConfigRec;
    Config        : ConfigRec;
    ArcFile       : FILE OF ArchiveRec;
    Arc           : ArchiveRec;
    ProtFile      : FILE OF ProtocolRec;
    Prot          : ProtocolRec;


PROCEDURE IntroScr;
BEGIN
   ClrScr;
   WritePipe('|16|09|09|01|16');
   WritePipe('|17|09|15 WB1TOWB2 - ReneWave v1.00.wb1 -> v1.00.wb2 conversion utility                |08|16');
   WritePipe('|17|09|09 Copyright (C) 1994 by Lars Hellsten and Jeff Fanjoy, All Rights Reserved     |08|16');
   WritePipe('|17|09|07 Support - APC MatrixSoft Support BBS (416)494-9237 - 1:250/320 / 50:660/300  |08|16');
   WritePipe('|16|01|08|08|16');
   WritePipe(#13#10);
END;


PROCEDURE ReportErr(Lvl:Word; s:String);
BEGIN
   WritePipe('|16|03Error: |07'+s+#13#10#13#10);
   Halt(Lvl);
END;


PROCEDURE InitFiles;
VAR ch:Char;
BEGIN
   IF NOT FExists('SETUP.RW')    THEN ReportErr(1,'SETUP.RW not found in current directory');
   IF NOT FExists('ARCHIVER.RW') THEN ReportErr(1,'ARCHIVER.RW not found in current directory');
   IF NOT FExists('PROTOCOL.RW') THEN ReportErr(1,'PROTOCL.RW not found in current directory');

   WritePipe('|15WARNING - You should only run this utility once, and then delete it.  Running'+#13#10);
   WritePipe('|15it on an already-converted setup could cause you to lose your system settings.'+#13#10#13#10);
   WritePipe('|07Proceed? [Yes]: ');

   REPEAT
      ch := Upcase(ReadKey);
   UNTIL (ch IN ['Y','N',#13]);
   IF ch = 'N' THEN
      BEGIN
         WritePipe(#13#10#13#10+'|12Aborted.'+#13#10);
         Halt;
      END;
   WritePipe(#13#10#13#10);

   Assign(OldConfigFile,'SETUP.RW');
   Rename(OldConfigFile,'SETUP.$$T');
   Reset(OldConfigFile);
   Assign(ConfigFile,'SETUP.RW');
   Rewrite(ConfigFile);
   Assign(ArcFile,'ARCHIVER.RW');
   Reset(ArcFile);
   Assign(ProtFile,'PROTOCOL.RW');
   Reset(ProtFile);

   IF (FileSize(ArcFile) < 9) THEN ReportErr(1,'Error in ARCHIVER.RW');
   IF (FileSize(ProtFile) < 9) THEN ReportErr(1,'Error in PROTOCOL.RW');
END;


PROCEDURE DeInitFiles;
BEGIN
   Close(ConfigFile);
   Close(OldConfigFile);
   Erase(OldConfigFile);
   Close(ArcFile);
   Erase(ArcFile);
   Close(ProtFile);
   Erase(ProtFile);
   WritePipe('|16|10Conversion from WIDEBETA1 to WIDEBETA2 completed successfully.'+#13#10#13#10);
END;


PROCEDURE DoConversion;
VAR Num:Byte;
BEGIN
   Seek(OldConfigFile,0);
   Read(OldConfigFile,OldConfig);
   Seek(ConfigFile,0);
   FillChar(Config,SizeOf(Config),0);

   Config.RGMainDir             := OldConfig.RGMainDir;
   Config.RWMainDir             := OldConfig.RWMainDir;
   Config.WorkDir               := OldConfig.WorkDir;
   Config.RWMenuDir             := OldConfig.RWMainDir;
   Config.LogFile               := OldConfig.LogFile;
   Config.LocalULDir            := OldConfig.LocalULDir;
   Config.LocalDLDir            := OldConfig.LocalDLDir;
   Config.RWPtrDir              := OldConfig.RWPtrDir;
   Config.FilesList             := OldConfig.FilesList;
   Config.MainPrompt            := OldConfig.MainPrompt;
   Config.ConfigPrompt          := OldConfig.ConfigPrompt;
   Config.TearLine              := OldConfig.TearLine;
   Config.BBSID                 := OldConfig.BBSID;
   Config.ACS_AllEmail          := OldConfig.ACS_AllEmail;
   Config.ACS_QWKSystem         := OldConfig.ACS_QWKSystem;
   Config.ForwardACS            := OldConfig.ForwardACS;
   Config.ForceOvrACS           := OldConfig.ForceOvrACS;
   Config.FileReqACS            := OldConfig.FileReqACS;
   Config.TimeoutMinutes        := OldConfig.TimeoutMinutes;
   Config.NTypeEmail            := OldConfig.NTypeEmail;
   Config.NTypeNetmail          := OldConfig.NTypeNetmail;
   Config.ForceEmail            := OldConfig.ForceEmail;
   Config.ForceNetmail          := OldConfig.ForceNetmail;
   Config.HangUpOnTimeout       := OldConfig.HangUpOnTimeout;
   Config.NukeLocalRep          := OldConfig.NukeLocalRep;
   Config.AllowGoodbye          := OldConfig.AllowGoodbye;
   Config.UseOwnPointers        := 1;
   Config.CreditsPublic         := OldConfig.CreditsPublic;
   Config.CreditsEmail          := OldConfig.CreditsEmail;
   Config.DefaultProtocol       := OldConfig.DefaultProtocol;
   Config.DefaultArchiver       := OldConfig.DefaultArchiver;
   Config.FREQLimit             := OldConfig.FreqLimit;
   Config.MaxPWTries            := OldConfig.MaxPWTries;
   Config.SwapType              := OldConfig.SwapType;
   Config.MaxTotalMsgs          := OldConfig.MaxTotalMsgs;
   Config.MaxBaseMsgs           := OldConfig.MaxBaseMsgs;
   Config.MaxDupes              := OldConfig.MaxDupes;
   Config.ACS_NetStatus         := OldConfig.ACS_NetStatus;
   Config.BBSZone               := OldConfig.BBSZone;
   Config.BBSNet                := OldConfig.BBSNet;
   Config.BBSNode               := OldConfig.BBSNode;
   Config.BBSPoint              := OldConfig.BBSPoint;
   Config.DefaultNetAttr        := OldConfig.DefaultNetATtr;
   Config.ACS_Crash             := OldConfig.ACS_Crash;
   Config.ACS_FAttach           := OldConfig.ACS_FAttach;
   Config.ACS_KillSent          := OldConfig.ACS_KillSEnt;
   Config.ACS_Hold              := OldConfig.ACS_Hold;
   Config.ACS_Imm               := OldConfig.ACS_Imm;
   Config.ACS_FREQ              := OldConfig.ACS_FREQ;
   Config.ACS_Direct            := OldConfig.ACS_Direct;
   Config.ACS_UpdREQ            := OldConfig.ACS_UpdReq;
   Config.AttachACS_Netmail     := OldConfig.AttachACS_Netmail;
   Config.AttachACS_Email       := OldConfig.AttachACS_Email;
   Config.FileAttachDays        := OldConfig.FileAttachDays;
   Config.FileExtLines          := OldConfig.FileExtLines;
   Config.FAttachDir            := OldConfig.FAttachDir;
   Config.FAttachSpace          := OldConfig.FAttachSpace;
   Config.FAttachTestLine       := OldConfig.FAttachTestLine;
   Config.FAttachDelFail        := OldConfig.FAttachDelFail;

   Config.PromptMain            := '|07Your selection, %FN: |15';
   Config.PromptConfig          := '|07Your selection, %FN: |15';
   Config.AnyNameEmail          := 's255';
   Config.AnyNameNetmail        := 's255';

   Move(OldConfig.NewsFiles,Config.NewsFiles,SizeOf(Config.NewsFiles));
   Move(OldConfig.LogOpts,Config.LogOpts,SizeOf(Config.LogOpts));

   FOR Num := 0 TO 9 DO
      BEGIN
         Seek(ArcFile,Num);
         Seek(ProtFile,Num);
         Read(arcFile,Arc);
         Read(ProtFile,Prot);
         Config.RW_Archivers[Num+1] := Arc;
         Config.RW_Protocols[Num+1] := Prot;
      END;

   Write(ConfigFile,Config);
END;


BEGIN
   IntroScr;
   InitFiles;
   DoConversion;
   DeInitFiles;
END.