{$D-,L-,R-,S-,I+,Q-,V-,B-,X+,T-,P-,O+}

UNIT RWSA;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES RWSGEN,   RWSMAIN,  CRT,      MSOBJ,    MSTRINGS, MISC1,    CURSOR,
     FASTW,    SCREENS,  RECORDS,  KEYINPUT, MSRGGEN,  MSBWGEN,  RWSTRUCT;


PROCEDURE Handle_BulletinsForReader;
PROCEDURE Handle_NetmailAttributeACSSettings;
PROCEDURE Handle_NetmailInformation;
PROCEDURE Handle_LoggingOptions;
PROCEDURE Handle_SystemACSSettings;
PROCEDURE Handle_FileRequest;
PROCEDURE Handle_NewUserDefaults;
PROCEDURE Handle_InternetConfig;



IMPLEMENTATION


PROCEDURE Handle_NetmailInformation;
CONST Len = 32;
      MenuCol = 15;
VAR
   TempStr             : String;
   Zone,Net,Node,Point : Word;
   Err                 : Integer;
   NetChoice           : Integer;
   RWMenu_Net          : PMenuType;

   PROCEDURE Init_NetmailInformation;
   CONST MenuItems = 4;
   BEGIN
      RWS_ReadMenuDesc(1,MenuItems);

      Menu_Init(RWMenu_Net,14,9,68,16,1,25,MenuItems,TRUE,'Netmail information');
      Menu_AddItem(RWMenu_Net,1,90,' ',FALSE,0,2,0,0,MenuCol,11,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RWMenu_Net,2,91,' ',FALSE,1,3,0,0,MenuCol,12,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RWMenu_Net,3,92,' ',FALSE,2,4,0,0,MenuCol,13,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RWMenu_Net,4,93,'N',FALSE,3,0,0,0,MenuCol,15,2,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      GotoXY(MenuCol+21,RWmenu_Net^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawNetmailInformation;
   BEGIN
      WritePipeXY(15,14,'|17|09'+RepChar('',53));
      DrawChoice(1,StrFunc(SRW.BBSZone)+':'+
                   StrFunc(SRW.BBSNet)+'/'+
                   StrFunc(SRW.BBSNode)+'.'+
                   StrFunc(SRW.BBSPoint),Len);
      DrawChoice(2,YesNoBoolean(SRW.BragLine),Len);
      DrawChoice(3,SRW.Tearline,Len);
   END;

BEGIN
   New(TempScreen2);
   Init_NetmailInformation;
   Menu_DrawMenu(RWMenu_Net);
   Menu_ClearMenu(RWMenu_Net);
   Menu_DrawItems(RWMenu_Net);
   DrawNetmailInformation;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RWMenu_Net,NetChoice);
      CASE NetChoice OF
         1 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.BBSZone)+':'+
                                 StrFunc(SRW.BBSNet)+'/'+
                                 StrFunc(SRW.BBSNode)+'.'+
                                 StrFunc(SRW.BBSPoint),Standard,20,MenuCol+21,11,0,FALSE);
                FidoSplitAddr(TempStr,Zone,Net,Node,Point);
                IF (Pos(':',TempStr) > 0) AND (Pos('/',TempStr) > 0) AND (Zone > 0) AND (Net > 0)
                    THEN
                      BEGIN
                         SRW.BBSZone := Zone;
                         SRW.BBSNet := Net;
                         SRW.BBSNode := Node;
                         SRW.BBSPoint := Point;
                      END;
                DrawChoice(1,StrFunc(SRW.BBSZone)+':'+
                             StrFunc(SRW.BBSNet)+'/'+
                             StrFunc(SRW.BBSNode)+'.'+
                             StrFunc(SRW.BBSPoint),Len);
             END;
         2 : BEGIN
                SRW.BragLine := SRW.BragLine XOR TRUE;
                DrawChoice(2,YesNoBoolean(SRW.BragLine),Len);
             END;
         3 : BEGIN
                ReadScreen(TempScreen2^);
                MakeBox('Tear Line',23,14,59,16,TRUE);
                WritePipeXY(25,15,'|17|11--- ');
                GetInput(SRW.Tearline,SRW.Tearline,Standard,29,29,15,0,FALSE);
                WriteScreen(TempScreen2^);
                DrawChoice(3,SRW.Tearline,Len);
             END;
         4 : Handle_NetmailAttributeACSSettings;
      END;
   UNTIL (NetChoice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(RWMenu_Net);
END;


PROCEDURE Handle_LoggingOptions;
CONST MenuCol  = 24;
VAR RWMenu_Log : PMenuType;
    LogChoice  : Integer;


   PROCEDURE Init_LoggingOptions;
   CONST MenuItems = 7;
   BEGIN
      RWS_ReadMenuDesc(20,MenuItems);
      Menu_Init(RWMenu_Log,23,9,58,19,1,25,MenuItems,TRUE,'Logging options');
      Menu_AddItem(RWMenu_Log, 1,80,':',FALSE,0,2,0,0,MenuCol,11,2,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RWMenu_Log, 2,80,'#',FALSE,1,3,0,0,MenuCol,12,2,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RWMenu_Log, 3,80,'-',FALSE,2,4,0,0,MenuCol,13,2,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RWMenu_Log, 4,80,'!',FALSE,3,5,0,0,MenuCol,14,2,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(RWMenu_Log, 5,80,'=',FALSE,4,6,0,0,MenuCol,15,2,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(RWMenu_Log, 6,80,'?',FALSE,5,7,0,0,MenuCol,16,2,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);
      Menu_AddItem(RWMenu_Log, 7,80,'+',FALSE,6,0,0,0,MenuCol,17,2,1,MenuDesc^[7].Desc,MenuDesc^[7].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      GotoXY(MenuCol+25,RWMenu_Log^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;


   PROCEDURE DrawLoggingOptions;
   CONST Len = 5;
   BEGIN
      DrawChoice(1,YesNoBoolean(SRW.LogOpts.ScanningInfo),Len);
      DrawChoice(2,YesNoBoolean(SRW.LogOpts.BundlingInfo),Len);
      DrawChoice(3,YesNoBoolean(SRW.LogOpts.TransferInfo),Len);
      DrawChoice(4,YesNoBoolean(SRW.LogOpts.ErrorInfo),Len);
      DrawChoice(5,YesNoBoolean(SRW.LogOpts.GeneralInfo),Len);
      DrawChoice(6,YesNoBoolean(SRW.LogOpts.UserErrorsInfo),Len);
      DrawChoice(7,YesNoBoolean(SRW.LogOpts.ReplyInfo),Len);
   END;


BEGIN
   Init_LoggingOptions;
   Menu_DrawMenu(RWMenu_Log);
   Menu_ClearMenu(RWMenu_Log);
   Menu_DrawItems(RWMenu_Log);
   DrawLoggingOptions;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RWMenu_Log,LogChoice);
      WITH SRW.LogOpts DO CASE LogChoice OF
         1 : ScanningInfo   := ScanningInfo   XOR TRUE;
         2 : BundlingInfo   := BundlingInfo   XOR TRUE;
         3 : TransferInfo   := TransferInfo   XOR TRUE;
         4 : ErrorInfo      := ErrorInfo      XOR TRUE;
         5 : GeneralInfo    := Generalinfo    XOR TRUE;
         6 : UserErrorsInfo := UserErrorsInfo XOR TRUE;
         7 : ReplyInfo      := ReplyInfo      XOR TRUE;
      END;
      DrawLoggingOptions;
   UNTIL (LogChoice = -1);
   Menu_DeInit(RWMenu_Log);
END;


PROCEDURE Handle_SystemAcsSettings;
CONST Len        = 20;
      MenuCol    = 11;
      EditCol    = 38;
VAR   RwMenu     : PMenuType;
      Choice     : Integer;

   PROCEDURE Init_SystemACSSettings;
   CONST MenuItems = 6;
   BEGIN
      RWS_ReadMenuDesc(40,MenuItems);

      Menu_Init(RwMenu,10,9,70,18,1,25,MenuItems,TRUE,'System ACS settings');
      Menu_AddItem(RwMenu,1,70,' ',FALSE,0,2,0,0,MenuCol,11,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RwMenu,2,71,' ',FALSE,1,3,0,0,MenuCol,12,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RwMenu,3,72,' ',FALSE,2,4,0,0,MenuCol,13,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RwMenu,4,73,' ',FALSE,3,5,0,0,MenuCol,14,0,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(RwMenu,5,74,' ',FALSE,4,6,0,0,MenuCol,15,0,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(RwMenu,6,75,' ',FALSE,5,0,0,0,MenuCol,16,0,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH RwMenu^.ItemData^[MChoice] DO GotoXY(Length(Desc)+MenuCol+1,YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawSystemACSSettings;
   BEGIN
      DrawChoice(1,SRW.ForwardACS,Len);
      DrawChoice(2,SRW.ForceOvrACS,Len);
      DrawChoice(3,SRW.ACS_AllEmail,Len);
      DrawChoice(4,SRW.AttachAcs,Len);
      DrawChoice(5,SRW.AnyNameEmail,Len);
      DrawChoice(6,SRW.AnyNameNetmail,Len);
   END;


BEGIN
   New(TempScreen2);
   Init_SystemACSSettings;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawSystemAcsSettings;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Choice);
      CASE Choice OF
         1 : BEGIN
                GetInput(SRW.ForwardACS,SRW.ForwardACS,Standard,20,EditCol,11,0,FALSE);
                DrawChoice(1,SRW.ForwardACS,Len);
             END;
         2 : BEGIN
                GetInput(SRW.ForceOvrACS,SRW.ForceOvrACS,Standard,20,EditCol,12,0,FALSE);
                DrawChoice(2,SRW.ForceOvrACS,Len);
             END;
         3 : BEGIN
                GetInput(SRW.ACS_AllEmail,SRW.ACS_AllEmail,Standard,20,EditCol,13,0,FALSE);
                DrawChoice(3,SRW.ACS_AllEmail,Len);
             END;
         4 : BEGIN
                GetInput(SRW.AttachAcs,SRW.AttachAcs,Standard,20,EditCol,14,0,FALSE);
                DrawChoice(4,SRW.AttachAcs,Len);
             END;
         5 : BEGIN
                GetInput(SRW.AnyNameEmail,SRW.AnyNameEmail,Standard,20,EditCol,15,0,FALSE);
                DrawChoice(5,SRW.AnyNameEmail,Len);
             END;
         6 : BEGIN
                GetInput(SRW.AnyNameNetmail,SRW.AnyNameNetmail,Standard,20,EditCol,16,0,FALSE);
                DrawChoice(6,SRW.AnyNameNetmail,Len);
             END;
      END;
   UNTIL (Choice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(RwMenu);
END;


PROCEDURE Handle_FileRequest;
CONST Len      = 20;
      MenuCol  = 6;
      EditCol  = 34;
VAR   RwMenu   : PMenuType;
      TempStr  : String;
      TempInt,
      Err,
      Choice   : Integer;

   PROCEDURE Init_FileRequest;
   CONST MenuItems = 2;
   BEGIN
      Menu_Init(RwMenu,5,10,74,15,1,25,MenuItems,TRUE,'{+} File request settings');

      RWS_ReadMenuDesc(60,20);
      Menu_AddItem(RwMenu,1,130,' ',FALSE,0,2,0,0,MenuCol,12,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RwMenu,2,131,' ',FALSE,1,0,0,0,MenuCol,13,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH RwMenu^.ItemData^[MChoice] DO GotoXY(Length(Desc)+MenuCol+1,YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawFileRequest;
   BEGIN
      DrawChoice(1,SRW.FileReqACS,Len);
      DrawChoice(2,StrFunc(SRW.FREQLimit),Len);
   END;

BEGIN
   New(TempScreen2);
   Init_FileRequest;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawFileRequest;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Choice);
      CASE Choice OF
         1 : BEGIN
                GetInput(SRW.FileReqACS,SRW.FileReqACS,Standard,20,EditCol,12,0,FALSE);
                DrawChoice(1,SRW.FileReqACS,Len);
             END;
         2 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.FREQLimit),Number,3,EditCol,13,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) THEN SRW.FREQLimit := TempInt;
                DrawChoice(2,StrFunc(SRW.FREQLimit),Len);
             END;
      END;
   UNTIL (Choice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(RwMenu);
END;


PROCEDURE HAndle_InternalListConfig;
CONST MenuCol        = 5;
      Len            = 44;
VAR   RWMenu_FL      : PMenuType;
      FileListChoice : Integer;
      s              : String;

   PROCEDURE Init_FileListOptions;
   CONST MenuItems = 10;
   BEGIN
      RWS_ReadMenuDesc(110,MenuItems);

      Menu_Init(RWMenu_FL,4,8,76,20,1,25,MenuItems,TRUE,'Internal File List Generator');
      Menu_AddItem(RWMenu_FL,01,101,' ',FALSE,00,02,0,0,MenuCol,10,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
      Menu_AddItem(RWMenu_FL,02,102,' ',FALSE,01,03,0,0,MenuCol,11,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
      Menu_AddItem(RWMenu_FL,03,103,' ',FALSE,02,04,0,0,MenuCol,12,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
      Menu_AddItem(RWMenu_FL,04,104,' ',FALSE,03,05,0,0,MenuCol,13,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
      Menu_AddItem(RWMenu_FL,05,105,' ',FALSE,04,06,0,0,MenuCol,14,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
      Menu_AddItem(RWMenu_FL,06,106,' ',FALSE,05,07,0,0,MenuCol,15,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
      Menu_AddItem(RWMenu_FL,07,107,' ',FALSE,06,08,0,0,MenuCol,16,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
      Menu_AddItem(RWMenu_FL,08,108,' ',FALSE,07,09,0,0,MenuCol,17,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);
      Menu_AddItem(RWMenu_FL,09,109,' ',FALSE,08,10,0,0,MenuCol,18,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
      Menu_AddItem(RWMenu_FL,10,110,' ',FALSE,09,00,0,0,MenuCol,19,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      GotoXY(MenuCol+24,RWMenu_FL^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawFileListOptions;
   BEGIN
      DrawChoice(1,SRW.FileListHdr,Len);
      DrawChoice(2,SRW.FileListFtr,Len);
      DrawChoice(3,YesNoBoolean(SRW.FileListAreaT),Len);
      DrawChoice(4,YesNoBoolean(SRW.FileListGrandT),Len);
      DrawChoice(5,YesNoBoolean(SRW.FileListCredits),Len);
      DrawChoice(6,YesNoBoolean(SRW.FileListOffline),Len);
      DrawChoice(7,YesNoBoolean(SRW.FileListDates),Len);
      DrawChoice(8,YesNoBoolean(SRW.FileListUploader),Len);

      IF SRW.FileListOptional
         THEN DrawChoice(9,'User toggle',Len)
         ELSE DrawChoice(9,'Mandatory',Len);

      IF SRW.FileListMaxDays = 0
         THEN DrawChoice(10,'<disabled>',Len)
         ELSE DrawChoice(10,StrFunc(SRW.FileListMaxDays)+' days old',Len);
   END;


BEGIN
   Init_FileListOptions;
   Menu_DrawMenu(RWMenu_FL);
   Menu_ClearMenu(RWMenu_FL);
   Menu_DrawItems(RWMenu_FL);
   DrawFileListOptions;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RWMenu_FL,FileListChoice);

      CASE FileListChoice OF
         1 : GetInput(SRW.FileListHdr,SRW.FileListHdr,FilePath,44,29,10,0,TRUE);
         2 : GetInput(SRW.FileListFtr,SRW.FileListFtr,FilePath,44,29,11,0,TRUE);

         3 : IF SRW.FileListAreaT    THEN SRW.FileListAreaT    := FALSE ELSE SRW.FileListAreaT    := TRUE;
         4 : IF SRW.FileListGrandT   THEN SRW.FileListGrandT   := FALSE ELSE SRW.FileListGrandT   := TRUE;
         5 : IF SRW.FileListCredits  THEN SRW.FileListCredits  := FALSE ELSE SRW.FileListCredits  := TRUE;
         6 : IF SRW.FileListOffline  THEN SRW.FileListOFfline  := FALSE ELSE SRW.FileListOffline  := TRUE;
         7 : IF SRW.FileListDates    THEN SRW.FileListDates    := FALSE ELSE SRW.FileListDates    := TRUE;
         8 : IF SRW.FileListUploader THEN SRW.FileListUploader := FALSE ELSE SRW.FileListUploader := TRUE;
         9 : IF SRW.FileListOptional THEN SRW.FileListOptional := FALSE ELSE SRW.FileListOptional := TRUE;
        10 : BEGIN
                DrawChoice(10,StrFunc(SRW.FileListMaxDays),Len);
                GetInput(s,StrFunc(SRW.FileListMaxDays),'0123456789',2,29,19,0,TRUE);
                IF ValFunc(s) >= 0 THEN SRW.FileListMaxDays :=  ValFunc(s);
             END;
      END;

      DrawFileListOptions;
   UNTIL (FileListChoice = -1);
   Menu_DeInit(RWMenu_FL);
END;


PROCEDURE Handle_BulletinsForReader;
CONST Len1       = 50;
      Len2       = 20;
      MenuCol    = 3;
VAR   BullChoice : Integer;
      BullNum    : Byte;
      BullMenu   : PMenuType;


   PROCEDURE Init_BulletinsForReader(VAR BullMenu:PMenuType);
   CONST MenuItems = 8;
   BEGIN
      RWS_ReadMenuDesc(130,MenuItems);

      Menu_Init(BullMenu,2,8,78,21,1,25,MenuItems,TRUE,'Bulletins & New Files Listing');
      Menu_AddItem(BullMenu,1,100,' ',FALSE,0,8,0,0,MenuCol,10,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);

      Menu_AddItem(BullMenu,2,120,'1',FALSE,8,3,0,0,MenuCol+1,15,2,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(BullMenu,3,120,'2',FALSE,2,4,0,0,MenuCol+1,16,2,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(BullMenu,4,120,'3',FALSE,3,5,0,0,MenuCol+1,17,2,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(BullMenu,5,120,'4',FALSE,4,6,0,0,MenuCol+1,18,2,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(BullMenu,6,120,'5',FALSE,5,0,0,0,MenuCol+1,19,2,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);

      Menu_AddItem(BullMenu,7,120,' ',FALSE,0,0,0,0,0,0,0,0,'','');

      Menu_AddItem(BullMenu,8,100,' ',FALSE,1,2,0,0,MenuCol,11,0,1,MenuDesc^[8].Desc,MenuDesc^[8].Status);
   END;


   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH BullMenu^.ItemData^[MChoice] DO GotoXY(XPos+1+Length(Desc),YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;


   PROCEDURE DrawBull(MChoice:Integer; Str1,Str2:String; Len1,Len2:Byte);
   BEGIN
      WITH BullMenu^.ItemData^[MChoice] DO GotoXY(XPos+1+Length(Desc),YPos);
      TextAttr := 27;
      Write(PadRight(Str1,' ',Len1)+' '+PadRight(Str2,' ',Len2));
   END;


   PROCEDURE DrawBulletinsForReader;
   BEGIN
      DrawBull(2,SRW.NewsFiles[1].TheFile,SRW.NewsFiles[1].ACS,Len1,Len2);
      DrawBull(3,SRW.NewsFiles[2].TheFile,SRW.NewsFiles[2].ACS,Len1,Len2);
      DrawBull(4,SRW.NewsFiles[3].TheFile,SRW.NewsFiles[3].ACS,Len1,Len2);
      DrawBull(5,SRW.NewsFiles[4].TheFile,SRW.NewsFiles[4].ACS,Len1,Len2);
      DrawBull(6,SRW.NewsFiles[5].TheFile,SRW.NewsFiles[5].ACS,Len1,Len2);

      WritePipeXY(4,13,'|17|09# Complete path and filename of the actual file      ACS for inclusion'+#13#10);
      WritePipeXY(4,14,'|17|09  ');

      CASE SRW.FileListType OF
         0 : DrawChoice(1,'Disabled',Len1);
         1 : DrawChoice(1,'Internal',Len1);
         2 : DrawChoice(1,'External',Len1);
      END;

      CASE SRW.FileListType OF
         0 : DrawChoice(8,'<n/a>',Len1);
         1 : DrawChoice(8,'',Len1);
         2 : DrawChoice(8,SRW.FilesList,Len1);
      END;
   END;

VAR Crap:Word;

BEGIN
   New(TempScreen2);
   Init_BulletinsForReader(BullMenu);
   Menu_DrawMenu(BullMenu);
   Menu_ClearMenu(BullMenu);
   Menu_DrawItems(BullMenu);
   DrawBulletinsForReader;
   REPEAT
      Crap := 1;
      IF SRW.FileListType = 0
         THEN BullMenu^.ItemData^[Crap].LinkDown := 2
         ELSE BullMenu^.ItemData^[Crap].LinkDown := 8;

      Crap := 2;
      IF SRW.FileListType = 0
         THEN BullMenu^.ItemData^[Crap].LinkUp := 1
         ELSE BullMenu^.ItemData^[Crap].LinkUp := 8;

      SetCursor(cmOff);
      Menu_GetChoice(BullMenu,BullChoice);
      CASE BullChoice OF
         1 : BEGIN
                Inc(SRW.FileListType);
                IF SRW.FileListType > 2 THEN SRW.FileListType := 0;
                CASE SRW.FileListType OF
                   0 : DrawChoice(1,'Disabled',Len1);
                   1 : DrawChoice(1,'Internal',Len1);
                   2 : DrawChoice(1,'External',Len1);
                END;
                CASE SRW.FileListType OF
                   0 : DrawChoice(8,'<n/a>',Len1);
                   1 : DrawChoice(8,'',Len1);
                   2 : DrawChoice(8,SRW.FilesList,Len1);
                END;
             END;
         8 : CASE SRW.FileListType OF
                1 : Handle_InternalListConfig;
                2 : BEGIN
                       GetInput(SRW.FilesList,SRW.FilesList,Filepath,50,23,11,0,TRUE);
                       DrawChoice(8,SRW.FilesList,Len1);
                    END;
             END;
         2..6 : WITH BullMenu^.ItemData^[BullChoice],SRW.NewsFiles[BullChoice-1] DO BEGIN
                GetInput(TheFile,TheFile,Filepath,50,XPos+1+Length(Desc),YPos,0,TRUE);
                GetInput(ACS,ACS,Standard,20,XPos+2+Length(Desc)+Len1,YPos,0,FALSE);
                DrawBull(BullChoice,SRW.NewsFiles[BullChoice-1].TheFile,SRW.NewsFiles[BullChoice-1].ACS,Len1,Len2);
             END;
       END;
   UNTIL (BullChoice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(BullMenu);
END;


PROCEDURE Handle_NetmailAttributeACSSettings;
CONST Len         = 20;
      MenuCol1    = 6;
      MenuCol2    = 40;
      EditCol1    = 20;
      EditCol2    = 54;
VAR NetACSChoice  : Integer;
    RWMenu_NetACS : PMenuType;

   FUNCTION CalcAttrStr(n:NetAttrSet):String;
   VAR s:String;
   BEGIN
      s := '';
      IF (Crash    IN n) THEN s := 'Crash '     + s;
      IF (Hold     IN n) THEN s := 'Hold '      + s;
      IF (KillSent IN n) THEN s := 'Kill/Sent ' + s;
      IF (Local    IN n) THEN s := 'Local '     + s;
      IF (Private  IN n) THEN s := 'Pvt '       + s;
      s := StripTrailingCh(s,' ');
      s := StripLeadingCh(s,' ');
      IF s <> ''
         THEN CalcAttrStr := s
         ELSE CalcAttrStr := '[none]';
   END;

   PROCEDURE GetNetDefaults;
   VAR TempScreen:ScreenType; RWMenu:PMenuType; Choice:Integer; s:String;
   BEGIN
      s := '|09|16 Press [ENTER] to toggle this attribute ';
      Menu_Init(RWMenu,23,10,57,19,1,25,5,TRUE,'Default attributes');
      Menu_AddITem(RWMenu, 1,93,' ',FALSE,0,2,0,0,24,14,0,1,' Private                         ',s);
      Menu_AddItem(RWMenu, 2,93,' ',FALSE,1,3,0,0,24,15,0,1,' Local                           ',s);
      Menu_AddItem(RWMenu, 3,93,' ',FALSE,2,4,0,0,24,16,0,1,' Kill/Sent                       ',s);
      Menu_AddItem(RWMenu, 4,93,' ',FALSE,3,5,0,0,24,17,0,1,' Crash                           ',s);
      Menu_AddItem(RWMenu, 5,93,' ',FALSE,4,0,0,0,24,18,0,1,' Hold                            ',s);
      Menu_DrawMenu(RWMenu);
      Menu_ClearMenu(RWMenu);
      Menu_DrawItems(RWMenu);
      WritePipeXY(24,13,'|17|09'+RepChar('',33));
      REPEAT
         WritePipeXY(25,12,'|17|11'+PadRight(CalcAttrStr(SRW.DefaultNetAttr),' ',30));
         SetCursor(cmOff);
         Menu_GetChoice(RWMenu,Choice);
         CASE Choice OF
            1 : IF (Private  IN SRW.DefaultNetAttr)
                   THEN SRW.DefaultNetAttr := SRW.DefaultNetAttr - [Private]
                   ELSE SRW.DefaultNetAttr := SRW.DefaultNetAttr + [Private];
            2 : IF (Local    IN SRW.DefaultNetAttr)
                   THEN SRW.DefaultNetAttr := SRW.DefaultNetAttr - [Local]
                   ELSE SRW.DefaultNetAttr := SRW.DefaultNetAttr + [Local];
            3 : IF (KillSent IN SRW.DefaultNetAttr)
                   THEN SRW.DefaultNetAttr := SRW.DefaultNetAttr - [KillSent]
                   ELSE SRW.DefaultNetAttr := SRW.DefaultNetAttr + [KillSent];
            4 : IF (Crash    IN SRW.DefaultNetAttr)
                   THEN SRW.DefaultNetAttr := SRW.DefaultNetAttr - [Crash]
                   ELSE SRW.DefaultNetAttr := SRW.DefaultNetAttr + [Crash];
            5 : IF (Hold     IN SRW.DefaultNetAttr)
                   THEN SRW.DefaultNetAttr := SRW.DefaultNetAttr - [Hold]
                   ELSE SRW.DefaultNetAttr := SRW.DefaultNetAttr + [Hold];
         END;
      UNTIL (Choice = -1);
      Menu_DeInit(RWMenu);
   END;

   PROCEDURE Init_NetmailACSInfo(VAR RWMenu_NetACS:PMenuType);
   CONST MenuItems = 9;
   BEGIN
      RWS_ReadMEnuDesc(150,MenuItems);
      Menu_Init(RWMenu_NetACS,5,10,74,18,1,25,MenuItems,TRUE,'Netmail status ACS settings');
      Menu_AddITem(RWMenu_NetACS, 1,94,' ',FALSE,0,2,0,0,MenuCol1,12,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RWMenu_NetACS, 2,94,' ',FALSE,1,3,0,6,MenuCol1,14,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RWMenu_NetACS, 3,94,' ',FALSE,2,4,0,7,MenuCol1,15,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RWMenu_NetACS, 4,94,' ',FALSE,3,5,0,8,MenuCol1,16,0,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(RWMenu_NetACS, 5,94,' ',FALSE,4,0,0,9,MenuCol1,17,0,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(RWMenu_NetACS, 6,94,' ',FALSE,0,7,2,0,MenuCol2,14,0,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);
      Menu_AddItem(RWMenu_NetACS, 7,94,' ',FALSE,6,8,3,0,MenuCol2,15,0,1,MenuDesc^[7].Desc,MenuDesc^[7].Status);
      Menu_AddItem(RWMenu_NetACS, 8,94,' ',FALSE,7,9,4,0,MenuCol2,16,0,1,MenuDesc^[8].Desc,MenuDesc^[8].Status);
      Menu_AddItem(RWMenu_NetACS, 9,94,' ',FALSE,8,0,5,0,MenuCol2,17,0,1,MenuDesc^[9].Desc,MenuDesc^[9].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      IF MChoice < 6
         THEN GotoXY(MenuCol1+14,RWMenu_NetACS^.ItemData^[MChoice].YPos)
         ELSE GotoXY(MenuCol2+14,RWMenu_NetACS^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawNetmailAttributeACSSettings;
   BEGIN
      WritePipeXY(6,13,'|17|09'+RepChar('',68));
      DrawChoice(1,CalcAttrStr(SRW.DefaultNetAttr),30);
      DrawChoice(2,SRW.ACS_Crash,Len);
      DrawChoice(3,SRW.ACS_FAttach,Len);
      DrawChoice(4,SRW.ACS_KillSent,Len);
      DrawChoice(5,SRW.ACS_Hold,Len);
      DrawChoice(6,SRW.ACS_Imm,Len);
      DrawChoice(7,SRW.ACS_FREQ,Len);
      DrawChoice(8,SRW.ACS_Direct,Len);
      DrawChoice(9,SRW.ACS_UpdREQ,Len);
   END;

BEGIN
   Init_NetmailACSInfo(RWMenu_NetACS);
   Menu_DrawMenu(RWMenu_NetACS);
   Menu_ClearMenu(RWMenu_NetACS);
   Menu_DrawItems(RWMenu_NetACS);
   DrawNetmailAttributeACSSettings;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RWMenu_NetACS,NetACSChoice);
      CASE NetACSChoice OF
         1 : BEGIN
                GetNetDefaults;
                DrawChoice(1,CalcAttrStr(SRW.DefaultNetAttr),30);
             END;
         2 : BEGIN
                GetInput(SRW.ACS_Crash,SRW.ACS_Crash,Standard,20,EditCol1,14,0,FALSE);
                DrawChoice(2,SRW.ACS_Crash,Len);
             END;
         3 : BEGIN
                GetInput(SRW.ACS_FAttach,SRW.ACS_FAttach,Standard,20,EditCol1,15,0,FALSE);
                DrawChoice(3,SRW.ACS_FAttach,Len);
             END;
         4 : BEGIN
                GetInput(SRW.ACS_KillSent,SRW.ACS_KillSent,Standard,20,EditCol1,16,0,FALSE);
                DrawChoice(4,SRW.ACS_KillSent,Len);
             END;
         5 : BEGIN
                GetInput(SRW.ACS_Hold,SRW.ACS_Hold,Standard,20,EditCol1,17,0,FALSE);
                DrawChoice(5,SRW.ACS_Hold,Len);
             END;
         6 : BEGIN
                GetInput(SRW.ACS_Imm,SRW.ACS_Imm,Standard,20,EditCol2,14,0,FALSE);
                DrawChoice(6,SRW.ACS_Imm,Len);
             END;
         7 : BEGIN
                GetInput(SRW.ACS_FREQ,SRW.ACS_FREQ,Standard,20,EditCol2,15,0,FALSE);
                DrawChoice(7,SRW.ACS_FREQ,Len);
             END;
         8 : BEGIN
                GetInput(SRW.ACS_Direct,SRW.ACS_Direct,Standard,20,EditCol2,16,0,FALSE);
                DrawChoice(8,SRW.ACS_Direct,Len);
             END;
         9 : BEGIN
                GetInput(SRW.ACS_UpdREQ,SRW.ACS_UpdREQ,Standard,20,EditCol2,17,0,FALSE);
                DrawChoice(9,SRW.ACS_UpdREQ,Len);
             END;
      END;
   UNTIL (NetACSChoice = -1);
   Menu_DeInit(RWMenu_NetACS);
END;


PROCEDURE Handle_NewUserDefaults;
CONST Len      = 38;
      MenuCol  = 6;
      EditCol  = 34;
VAR   Choice   : Integer;
      RwMenu   : PMenuType;
      TempStr  : String[10];
      i        : Byte;

   PROCEDURE Init_NewUser;
   CONST MenuItems = 10;
   BEGIN
      RWS_ReadMenuDesc(290,MenuItems);

      Menu_Init(RwMenu,5,8,75,21,1,25,MenuItems,TRUE,'New user default settings');
      Menu_AddItem(RwMenu,01,140,' ',FALSE,0,02,0,0,MenuCol,10,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
      Menu_AddItem(RwMenu,02,141,' ',FALSE,1,03,0,0,MenuCol,11,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
      Menu_AddItem(RwMenu,03,142,' ',FALSE,2,04,0,0,MenuCol,12,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
      Menu_AddItem(RwMenu,04,143,' ',FALSE,3,05,0,0,MenuCol,13,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
      Menu_AddItem(RwMenu,05,144,' ',FALSE,4,06,0,0,MenuCol,14,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
      Menu_AddItem(RwMenu,06,145,' ',FALSE,5,07,0,0,MenuCol,15,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
      Menu_AddItem(RwMenu,07,146,' ',FALSE,6,08,0,0,MenuCol,16,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
      Menu_AddItem(RwMenu,08,147,' ',FALSE,7,09,0,0,MenuCol,17,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);
      Menu_AddItem(RwMenu,09,148,' ',FALSE,8,10,0,0,MenuCol,18,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
      Menu_AddItem(RwMenu,10,149,' ',FALSE,9,00,0,0,MenuCol,19,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      GotoXY(MenuCol+28,RwMenu^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawNewUser;
   BEGIN
      i := RWS_ProtSearch(SRW.DefaultProt);
      IF i > 0 THEN DrawChoice(1,'('+SRW.RwProtocols[i].Letter+') '+SRW.RwProtocols[i].Desc,Len);

      DrawChoice(2,SRW.Defaultarc,Len);

      IF SRW.DefaultMsgsLimit > 0
         THEN DrawChoice(3,StrFunc(SRW.DefaultMsgsLimit),Len)
         ELSE DrawChoice(3,'<disabled>',Len);

      IF SRW.DefaultQwk
         THEN DrawChoice(4,'QWK',Len)
         ELSE DrawChoice(4,'Blue Wave',Len);

      DrawChoice(5,YesNoBoolean(SRW.DefaultHotkeys),Len);
      DrawChoice(6,YesNoBoolean(SRW.DefaultExpert),Len);
      DrawChoice(7,YesNoBoolean(NOT SRW.DefaultNotMyMail),Len);
      DrawChoice(8,YesNoBoolean(SRW.DefaultNumeric),Len);
      DrawChoice(9,YesNoBoolean(SRW.DefaultFileList),Len);
      DrawChoice(10,YesNoBoolean(SRW.DefaultNukeEmail),Len);
   END;


BEGIN
   Init_NewUser;
   Menu_ClearMenu(RwMenu);
   Menu_DrawMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawNewUser;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Choice);
      CASE Choice OF
         1 : BEGIN
                i := RWS_SelectProt;
                IF (i >= 1) AND (i <= 10) THEN SRW.DefaultProt := SRW.RwProtocols[i].Letter;
                i := RWS_ProtSearch(SRW.DefaultProt);
                DrawChoice(1,'('+SRW.RwProtocols[i].Letter+') '+SRW.RwProtocols[i].Desc,Len);
             END;
         2 : BEGIN
                GetInput(SRW.DefaultArc,SRW.DefaultArc,FileName,3,EditCol,11,0,TRUE);
                DrawChoice(2,SRW.DefaultArc,Len);
             END;
         3 : BEGIN
                DrawChoice(3,StrFunc(SRW.DefaultMsgsLimit),Len);
                GetInput(TempStr,StrFunc(SRW.DefaultMsgsLimit),Number,10,EditCol,12,0,FALSE);
                IF ValFunc(TempStr) >= 0 THEN SRW.DefaultMsgsLimit := ValFunc(TempStr);
                IF SRW.DefaultMsgsLimit > 0
                   THEN DrawChoice(3,StrFunc(SRW.DefaultMsgsLimit),Len)
                   ELSE DrawChoice(3,'<disabled>',Len);
             END;
         4 : BEGIN
                SRW.DefaultQWK := SRW.DefaultQWK XOR TRUE;
                IF SRW.DefaultQwk
                   THEN DrawChoice(4,'QWK',Len)
                   ELSE DrawChoice(4,'Blue Wave',Len);
             END;
         5 : BEGIN
                SRW.DefaultHotkeys := SRW.DefaultHotkeys XOR TRUE;
                DrawChoice(5,YesNoBoolean(SRW.DefaultHotkeys),Len);
             END;
         6 : BEGIN
                SRW.DefaultExpert := SRW.DefaultExpert XOR TRUE;
                DrawChoice(6,YesNoBoolean(SRW.DefaultExpert),Len);
             END;
         7 : BEGIN
                SRW.DefaultNotMyMail := SRW.DefaultNotMyMail XOR TRUE;
                DrawChoice(7,YesNoBoolean(NOT SRW.DefaultNotMyMail),Len);
             END;
         8 : BEGIN
                SRW.DefaultNumeric := SRW.DefaultNumeric XOR TRUE;
                DrawChoice(8,YesNoBoolean(SRW.DefaultNumeric),Len);
             END;
         9 : BEGIN
                SRW.DefaultFileList := SRW.DefaultFileList XOR TRUE;
                DrawChoice(9,YesNoBoolean(SRW.DefaultFileList),Len);
             END;
        10 : BEGIN
                SRW.DefaultNukeEmail := SRW.DefaultNukeEmail XOR TRUE;
                DrawChoice(10,YesNoBoolean(SRW.DefaultNukeEmail),Len);
             END;
      END;
   UNTIL (Choice = -1);
   Menu_DeInit(RwMenu);
END;


PROCEDURE Handle_InternetConfig;
CONST Len      = 44;
      MenuCol  = 4;
      EditCol  = 31;
VAR   RwMenu   : PMenuType;
      TempStr  : String;
      Choice   : Integer;
      i        : LongInt;
      Zone,
      Net,
      Node,
      Point    : Word;

   PROCEDURE Init_InternetConfig;
   CONST MenuItems = 9;
   BEGIN
      RWS_ReadMenuDesc(310,MenuItems);

      Menu_Init(RwMenu,3,7,76,20,1,25,MenuItems,TRUE,'Internet Gateway Configuration');
      Menu_AddItem(RwMenu,01,160,' ',FALSE,00,02,0,0,MenuCol, 9,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
      Menu_AddItem(RwMenu,02,161,' ',FALSE,01,03,0,0,MenuCol,11,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
      Menu_AddItem(RwMenu,03,162,' ',FALSE,02,04,0,0,MenuCol,12,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
      Menu_AddItem(RwMenu,04,163,' ',FALSE,03,05,0,0,MenuCol,13,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
      Menu_AddItem(RwMenu,05,164,' ',FALSE,04,06,0,0,MenuCol,14,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
      Menu_AddItem(RwMenu,06,165,' ',FALSE,05,07,0,0,MenuCol,15,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
      Menu_AddItem(RwMenu,07,166,' ',FALSE,06,08,0,0,MenuCol,16,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
      Menu_AddItem(RwMenu,08,167,' ',FALSE,07,09,0,0,MenuCol,17,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);
      Menu_AddItem(RwMenu,09,168,' ',FALSE,08,00,0,0,MenuCol,18,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH RwMenu^.ItemData^[MChoice] DO GotoXY(Length(Desc)+MenuCol+1,YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   FUNCTION NetAttribStr:String;
   VAR s:String;
   BEGIN
      s := '';
      IF (MsPrivate IN SRW.InetMsgAttr)   THEN s := s+'Pvt ';
      IF (MsLocal IN SRW.InetMsgAttr)     THEN s := s+'Local ';
      IF (MsKillSent IN SRW.InetMsgAttr)  THEN s := s+'Kill/Sent ';
      IF (MsHold IN SRW.InetMsgAttr)      THEN s := s+'Hold ';
      IF (MsCrash IN SRW.InetMsgAttr)     THEN s := s+'Crash ';
      IF (MsDirect IN SRW.InetMsgAttr)    THEN s := s+'Direct ';
      IF s = ''
         THEN NetAttribStr := '[none]'
         ELSE NetAttribStr := StripTrailingCh(s,' ');
   END;

   PROCEDURE GetNetDefaults;
   VAR RwMenu:PMenuType; Choice:Integer; s:String;
   BEGIN
      s := ' Press [ENTER] to toggle this attribute ';
      Menu_Init(RwMenu,23,9,58,20,3,25,6,TRUE,'Default attributes');
      Menu_AddITem(RwMenu,1,-1,' ',FALSE,0,2,0,0,25,13,0,1,' Private                        ',s);
      Menu_AddItem(RwMenu,2,-1,' ',FALSE,1,3,0,0,25,14,0,1,' Local                          ',s);
      Menu_AddItem(RwMenu,3,-1,' ',FALSE,2,4,0,0,25,15,0,1,' Kill/Sent                      ',s);
      Menu_AddItem(RwMenu,4,-1,' ',FALSE,3,5,0,0,25,16,0,1,' Crash                          ',s);
      Menu_AddItem(RwMenu,5,-1,' ',FALSE,4,6,0,0,25,17,0,1,' Hold                           ',s);
      Menu_AddItem(RwMenu,6,-1,' ',FALSE,5,0,0,0,25,18,0,1,' Direct                         ',s);
      Menu_ClearMenu(RwMenu);
      Menu_DrawMenu(RwMenu);
      Menu_DrawItems(RwMenu);
      WritePipeXY(25,12,'|17|09'+Repchar('',32));
      WritePipeXY(25,19,'|17|09'+Repchar('',32));
      REPEAT
         WritePipeXY(25,11,'|17|11'+PadRight(NetAttribStr,' ',32));
         SetCursor(cmOff);
         Menu_GetChoice(RwMenu,Choice);
         CASE Choice OF
            1 : IF (MsPrivate IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsPrivate]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsPrivate];
            2 : IF (MsLocal IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsLocal]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsLocal];
            3 : IF (MsKillSent IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsKillSent]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsKillSent];
            4 : IF (MsCrash IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsCrash]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsCrash] - [MsHold];
            5 : IF (MsHold IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsHold]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsHold] - [MsCrash];
            6 : IF (MsDirect IN SRW.InetMsgAttr)
                   THEN SRW.InetMsgAttr := SRW.InetMsgAttr - [MsDirect]
                   ELSE SRW.InetMsgAttr := SRW.InetMsgAttr + [MsDirect];
         END;
      UNTIL (Choice = -1);
      Menu_DeInit(RwMenu);
   END;

   PROCEDURE DrawInternetConfig;
   BEGIN
      WritePipeXY(4,10,'|17|09'+RepChar('',72));
      WritePipeXY(4,19,'|17|09'+RepChar('',72));

      DrawChoice(1,YesNoBoolean(SRW.InetActive),Len);
      DrawChoice(2,SRW.InetAcs,Len);
      DrawChoice(3,SRW.InetAreaNum,Len);
      DrawChoice(4,SRW.InetAreaTag,Len);
      DrawChoice(5,SRW.InetAreaDesc,Len);
      DrawChoice(6,SRW.InetToField,Len);
      DrawChoice(7,Strfunc(SRW.InetGateZone)+':'+
                   StrFunc(SRW.InetGateNet)+'/'+
                   StrFunc(SRW.InetGateNode)+'.'+
                   StrFunc(SRW.InetGatePoint),Len);
      DrawChoice(8,NetAttribStr,Len);
      DrawChoice(9,YesNoBoolean(SRW.InetUseTo),Len);
   END;

BEGIN
   Init_InternetConfig;
   Menu_ClearMenu(RwMenu);
   Menu_DrawMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawInternetConfig;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Choice);
      CASE Choice OF
         1 : BEGIN
                SRW.InetActive := SRW.InetActive XOR TRUE;
                DrawChoice(1,YesNoBoolean(SRW.INetActive),Len);
             END;
         2 : BEGIN
                GetInput(SRW.InetAcs,SRW.InetAcs,Standard,40,EditCol,11,0,FALSE);
                DrawChoice(2,SRW.InetAcs,Len);
             END;
         3 : BEGIN
                GetInput(SRW.InetAreaNum,SRW.InetAreaNum,HighBit,5,EditCol,12,0,FALSE);
                DrawChoice(3,SRW.InetAreaNum,Len);
             END;
         4 : BEGIN
                GetInput(SRW.InetAreaTag,SRW.InetAreaTag,HighBit,20,EditCol,13,0,FALSE);
                DrawChoice(4,SRW.InetAreaTag,Len);
             END;
         5 : BEGIN
                GetInput(SRW.InetAreaDesc,SRW.InetAreaDesc,HighBit,40,EditCol,14,0,FALSE);
                DrawChoice(5,SRW.InetAreaDesc,Len);
             END;
         6 : BEGIN
                GetInput(SRW.InetToField,SRW.InetToField,HighBit,35,EditCol,15,0,FALSE);
                DrawChoice(6,SRW.InetToField,Len);
             END;
         7 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.InetGateZone)+':'+StrFunc(SRW.InetGateNet)+'/'+
                                 StrFunc(SRW.InetGateNode)+'.'+StrFunc(SRW.InetGatePoint),
                                 Number+':/.',20,EditCol,16,0,FALSE);
                FidoSplitAddr(TempStr,Zone,Net,Node,Point);
                IF (Pos(':',TempStr) > 0) AND (Pos('/',TempStr) > 0) AND (Zone > 0) AND (Net > 0) THEN
                   BEGIN
                      SRW.InetGateZone  := Zone;
                      SRW.InetGateNet   := Net;
                      SRW.InetGateNode  := Node;
                      SRW.InetGatePoint := Point;
                   END;
                DrawChoice(7,Strfunc(SRW.InetGateZone)+':'+StrFunc(SRW.InetGateNet)+'/'+
                             StrFunc(SRW.InetGateNode)+'.'+StrFunc(SRW.InetGatePoint),Len);
             END;
         8 : BEGIN
                GetNetDefaults;
                DrawChoice(8,NetAttribStr,Len);
             END;
         9 : BEGIN
                SRW.InetUseTo := SRW.InetUseTo XOR TRUE;
                DrawChoice(9,YesNoBoolean(SRW.InetUseTo),Len);
             END;
      END;
   UNTIL (Choice = -1);
   Menu_DeInit(RwMenu);
END;


END.
