(***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is TurboPower Async Professional
 *
 * The Initial Developer of the Original Code is
 * TurboPower Software
 *
 * Portions created by the Initial Developer are Copyright (C) 1991-2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    Sulaiman Mah
 *    Sean B. Durkin
 * ***** END LICENSE BLOCK ***** *)

{*********************************************************}
{*                   ADSTRMAP.PAS 5.00                   *}
{*********************************************************}
(* Defines the string mapping tables                     *)
{*********************************************************}

{
  This replaces the string resource manager. Disable the
  UseResourceStrings define in AwDefine.inc to use the string
  resource manager instead if desired.
}
{Global defines potentially affecting this unit}
{$I ..\includes\AWDEFINE.INC}

unit AdStrMap;

interface

uses
  OOMisc, AdExcept;

const
  AdMaxMessages = 896;  { the number of messages in the message map array } // SWB

type
  AdMessageNumberLookupRecord = record
    MessageNumber : integer;
    MessageString : string;
  end;

const
  AdMessageNumberLookup : array [0..AdMaxMessages] of AdMessageNumberLookupRecord =(
{  #  }                 {Error mnemonic or code}                      {Error string}
{    0}(MessageNumber : ecOK;                         MessageString : secOK),
{    2}(MessageNumber : ecFileNotFound;               MessageString : secFileNotFound),
{    3}(MessageNumber : ecPathNotFound;               MessageString : secPathNotFound),
{    4}(MessageNumber : ecTooManyFiles;               MessageString : secTooManyFiles),
{    5}(MessageNumber : ecAccessDenied;               MessageString : secAccessDenied),
{    6}(MessageNumber : ecInvalidHandle;              MessageString : secInvalidHandle),
{    8}(MessageNumber : ecOutOfMemory;                MessageString : secOutOfMemory),
{   15}(MessageNumber : ecInvalidDrive;               MessageString : secInvalidDrive),
{   18}(MessageNumber : ecNoMoreFiles;                MessageString : secNoMoreFiles),
{  100}(MessageNumber : ecDiskRead;                   MessageString : secDiskRead),
{  101}(MessageNumber : ecDiskFull;                   MessageString : secDiskFull),
{  102}(MessageNumber : ecNotAssigned;                MessageString : secNotAssigned),
{  103}(MessageNumber : ecNotOpen;                    MessageString : secNotOpen),
{  104}(MessageNumber : ecNotOpenInput;               MessageString : secNotOpenInput),
{  105}(MessageNumber : ecNotOpenOutput;              MessageString : secNotOpenOutput),
{  150}(MessageNumber : ecWriteProtected;             MessageString : secWriteProtected),
{  151}(MessageNumber : ecUnknownUnit;                MessageString : secUnknownUnit),
{  152}(MessageNumber : ecDriveNotReady;              MessageString : secDriveNotReady),
{  153}(MessageNumber : ecUnknownCommand;             MessageString : secUnknownCommand),
{  154}(MessageNumber : ecCrcError;                   MessageString : secCrcError),
{  155}(MessageNumber : ecBadStructLen;               MessageString : secBadStructLen),
{  156}(MessageNumber : ecSeekError;                  MessageString : secSeekError),
{  157}(MessageNumber : ecUnknownMedia;               MessageString : secUnknownMedia),
{  158}(MessageNumber : ecSectorNotFound;             MessageString : secSectorNotFound),
{  159}(MessageNumber : ecOutOfPaper;                 MessageString : secOutOfPaper),
{  160}(MessageNumber : ecDeviceWrite;                MessageString : secDeviceWrite),
{  161}(MessageNumber : ecDeviceRead;                 MessageString : secDeviceRead),
{  162}(MessageNumber : ecHardwareFailure;            MessageString : secHardwareFailure),
{ 1001}(MessageNumber : ecBadHandle;                  MessageString : secBadHandle),
{ 1002}(MessageNumber : ecBadArgument;                MessageString : secBadArgument),
{ 1003}(MessageNumber : ecGotQuitMsg;                 MessageString : secGotQuitMsg),
{ 1004}(MessageNumber : ecBufferTooBig;               MessageString : secBufferTooBig),
{ 1005}(MessageNumber : ecPortNotAssigned;            MessageString : secPortNotAssigned),
{ 1006}(MessageNumber : ecInternal;                   MessageString : secInternal),
{ 1007}(MessageNumber : ecModemNotAssigned;           MessageString : secModemNotAssigned),
{ 1008}(MessageNumber : ecPhonebookNotAssigned;       MessageString : secPhonebookNotAssigned),
{ 1009}(MessageNumber : ecCannotUseWithWinSock;       MessageString : secCannotUseWithWinSock),
{ 2001}(MessageNumber : ecBadId;                      MessageString : secBadId),
{ 2002}(MessageNumber : ecBaudRate;                   MessageString : secBaudRate),
{ 2003}(MessageNumber : ecByteSize;                   MessageString : secByteSize),
{ 2004}(MessageNumber : ecDefault;                    MessageString : secDefault),
{ 2005}(MessageNumber : ecHardware;                   MessageString : secHardware),
{ 2006}(MessageNumber : ecMemory;                     MessageString : secMemory),
{ 2007}(MessageNumber : ecCommNotOpen;                MessageString : secCommNotOpen),
{ 2008}(MessageNumber : ecAlreadyOpen;                MessageString : secAlreadyOpen),
{ 2009}(MessageNumber : ecNoHandles;                  MessageString : secNoHandles),
{ 2010}(MessageNumber : ecNoTimers;                   MessageString : secNoTimers),
{ 2011}(MessageNumber : ecNoPortSelected;             MessageString : secNoPortSelected),
{ 2012}(MessageNumber : ecNotOpenedByTapi;            MessageString : secNotOpenedByTapi),
{ 3001}(MessageNumber : ecNullApi;                    MessageString : secNullApi),
{ 3002}(MessageNumber : ecNotSupported;               MessageString : secNotSupported),
{ 3003}(MessageNumber : ecRegisterHandlerFailed;      MessageString : secRegisterHandlerFailed),
{ 3004}(MessageNumber : ecPutBlockFail;               MessageString : secPutBlockFail),
{ 3005}(MessageNumber : ecGetBlockFail;               MessageString : secGetBlockFail),
{ 3006}(MessageNumber : ecOutputBufferTooSmall;       MessageString : secOutputBufferTooSmall),
{ 3007}(MessageNumber : ecBufferIsEmpty;              MessageString : secBufferIsEmpty),
{ 3008}(MessageNumber : ecTracingNotEnabled;          MessageString : secTracingNotEnabled),
{ 3009}(MessageNumber : ecLoggingNotEnabled;          MessageString : secLoggingNotEnabled),
{ 3010}(MessageNumber : ecBaseAddressNotSet;          MessageString : secBaseAddressNotSet),
{ 4001}(MessageNumber : ecModemNotStarted;            MessageString : secModemNotStarted),
{ 4002}(MessageNumber : ecModemBusy;                  MessageString : secModemBusy),
{ 4003}(MessageNumber : ecModemNotDialing;            MessageString : secModemNotDialing),
{ 4004}(MessageNumber : ecNotDialing;                 MessageString : secNotDialing),
{ 4005}(MessageNumber : ecAlreadyDialing;             MessageString : secAlreadyDialing),
{ 4006}(MessageNumber : ecModemNotResponding;         MessageString : secModemNotResponding),
{ 4007}(MessageNumber : ecModemRejectedCommand;       MessageString : secModemRejectedCommand),
{ 4008}(MessageNumber : ecModemStatusMismatch;        MessageString : secModemStatusMismatch),
{ 4009}(MessageNumber : ecDeviceNotSelected;          MessageString : secDeviceNotSelected),
{ 4010}(MessageNumber : ecModemDetectedBusy;          MessageString : secModemDetectedBusy),
{ 4011}(MessageNumber : ecModemNoDialtone;            MessageString : secModemNoDialtone),
{ 4012}(MessageNumber : ecModemNoCarrier;             MessageString : secModemNoCarrier),
{ 4013}(MessageNumber : ecModemNoAnswer;              MessageString : secModemNoAnswer),
{ 4014}(MessageNumber : ecInitFail;                   MessageString : secInitFail),
{ 4015}(MessageNumber : ecLoginFail;                  MessageString : secLoginFail),
{ 4016}(MessageNumber : ecMinorSrvErr;                MessageString : secMinorSrvErr),
{ 4017}(MessageNumber : ecFatalSrvErr;                MessageString : secFatalSrvErr),
{ 4020}(MessageNumber : ecModemNotFound;              MessageString : secModemNotFound),
{ 4021}(MessageNumber : ecInvalidFile;                MessageString : secInvalidFile),
{ 4101}(MessageNumber : 4101;                         MessageString : spbeDeleteQuery),
{ 4200}(MessageNumber : 4200;                         MessageString : sdsmMsgBase),
{ 4201}(MessageNumber : 4201;                         MessageString : sdsmMsgReady),
{ 4202}(MessageNumber : 4202;                         MessageString : sdsmMsgInitialize),
{ 4203}(MessageNumber : 4203;                         MessageString : sdsmMsgInitializeTimeout),
{ 4204}(MessageNumber : 4204;                         MessageString : sdsmMsgAutoAnswerBackground),
{ 4205}(MessageNumber : 4205;                         MessageString : sdsmMsgAutoAnswerWait),
{ 4206}(MessageNumber : 4206;                         MessageString : sdsmMsgAnswerWait),
{ 4207}(MessageNumber : 4207;                         MessageString : sdsmMsgDialWait),
{ 4208}(MessageNumber : 4208;                         MessageString : sdsmMsgDialCycle),
{ 4209}(MessageNumber : 4209;                         MessageString : sdsmMsgNoDialtone),
{ 4210}(MessageNumber : 4210;                         MessageString : sdsmMsgConnectWait),
{ 4211}(MessageNumber : 4211;                         MessageString : sdsmMsgConnected),
{ 4212}(MessageNumber : 4212;                         MessageString : sdsmMsgHangup),
{ 4213}(MessageNumber : 4213;                         MessageString : sdsmMsgCancel),
{ 4301}(MessageNumber : 4301;                         MessageString : sdddCycling),
{ 4302}(MessageNumber : 4302;                         MessageString : sdddRetryWaiting),
{ 4303}(MessageNumber : 4303;                         MessageString : sdddRetryWaitOver),
{ 4304}(MessageNumber : 4304;                         MessageString : sdddDialing),
{ 4305}(MessageNumber : 4305;                         MessageString : sdddModemConnect),
{ 4306}(MessageNumber : 4306;                         MessageString : sdddModemConnectAt),
{ 4307}(MessageNumber : 4307;                         MessageString : sdddModemVoice),
{ 4308}(MessageNumber : 4308;                         MessageString : sdddModemError),
{ 4309}(MessageNumber : 4309;                         MessageString : sdddModemNoCarrier),
{ 4310}(MessageNumber : 4310;                         MessageString : sdddModemBusy),
{ 4311}(MessageNumber : 4311;                         MessageString : sdddModemNoDialTone),
{ 4312}(MessageNumber : 4312;                         MessageString : sdddDialTimedOut),
{ 4401}(MessageNumber : 4401;                         MessageString : sdpeMustEnterName),
{ 4402}(MessageNumber : 4402;                         MessageString : sdpeMustEnterNumber),
{ 4403}(MessageNumber : 4403;                         MessageString : sdpeNameExists),
{ 4500}(MessageNumber : csOpenPort;                   MessageString : scsOpenPort),
{ 4501}(MessageNumber : csPortOpened;                 MessageString : scsPortOpened),
{ 4502}(MessageNumber : csConnectDevice;              MessageString : scsConnectDevice),
{ 4503}(MessageNumber : csDeviceConnected;            MessageString : scsDeviceConnected),
{ 4504}(MessageNumber : csAllDevicesConnected;        MessageString : scsAllDevicesConnected),
{ 4505}(MessageNumber : csAuthenticate;               MessageString : scsAuthenticate),
{ 4506}(MessageNumber : csAuthNotify;                 MessageString : scsAuthNotify),
{ 4507}(MessageNumber : csAuthRetry;                  MessageString : scsAuthRetry),
{ 4508}(MessageNumber : csAuthCallback;               MessageString : scsAuthCallback),
{ 4509}(MessageNumber : csAuthChangePassword;         MessageString : scsAuthChangePassword),
{ 4510}(MessageNumber : csAuthProject;                MessageString : scsAuthProject),
{ 4511}(MessageNumber : csAuthLinkSpeed;              MessageString : scsAuthLinkSpeed),
{ 4512}(MessageNumber : csAuthAck;                    MessageString : scsAuthAck),
{ 4513}(MessageNumber : csReAuthenticate;             MessageString : scsReAuthenticate),
{ 4514}(MessageNumber : csAuthenticated;              MessageString : scsAuthenticated),
{ 4515}(MessageNumber : csPrepareForCallback;         MessageString : scsPrepareForCallback),
{ 4516}(MessageNumber : csWaitForModemReset;          MessageString : scsWaitForModemReset),
{ 4517}(MessageNumber : csWaitForCallback;            MessageString : scsWaitForCallback),
{ 4518}(MessageNumber : csProjected;                  MessageString : scsProjected),
{ 4519}(MessageNumber : csStartAuthentication;        MessageString : scsStartAuthentication),
{ 4520}(MessageNumber : csCallbackComplete;           MessageString : scsCallbackComplete),
{ 4521}(MessageNumber : csLogonNetwork;               MessageString : scsLogonNetwork),
{ 4522}(MessageNumber : csSubEntryConnected;          MessageString : scsSubEntryConnected),
{ 4523}(MessageNumber : csSubEntryDisconnected;       MessageString : scsSubEntryDisconnected),
{ 4550}(MessageNumber : csRasInteractive;             MessageString : scsRasInteractive),
{ 4551}(MessageNumber : csRasRetryAuthentication;     MessageString : scsRasRetryAuthentication),
{ 4552}(MessageNumber : csRasCallbackSetByCaller;     MessageString : scsRasCallbackSetByCaller),
{ 4553}(MessageNumber : csRasPasswordExpired;         MessageString : scsRasPasswordExpired),
{ 4599}(MessageNumber : csRasDeviceConnected;         MessageString : scsRasDeviceConnected),
{ 4600}(MessageNumber : 4600;                         MessageString : sPDS_NONE),
{ 4601}(MessageNumber : 4601;                         MessageString : sPDS_OFFHOOK),
{ 4602}(MessageNumber : 4602;                         MessageString : sPDS_DIALING),
{ 4603}(MessageNumber : 4603;                         MessageString : sPDS_RINGING),
{ 4604}(MessageNumber : 4604;                         MessageString : sPDS_WAITFORCONNECT),
{ 4605}(MessageNumber : 4605;                         MessageString : sPDS_CONNECTED),
{ 4606}(MessageNumber : 4606;                         MessageString : sPDS_WAITINGTOREDIAL),
{ 4607}(MessageNumber : 4607;                         MessageString : sPDS_REDIALING),
{ 4608}(MessageNumber : 4608;                         MessageString : sPDS_MSGNOTSENT),
{ 4609}(MessageNumber : 4609;                         MessageString : sPDS_CANCELLING),
{ 4610}(MessageNumber : 4610;                         MessageString : sPDS_DISCONNECT),
{ 4611}(MessageNumber : 4611;                         MessageString : sPDS_CLEANUP),
{ 4630}(MessageNumber : 4630;                         MessageString : sPDE_NONE),
{ 4631}(MessageNumber : 4631;                         MessageString : sPDE_NODIALTONE),
{ 4632}(MessageNumber : 4632;                         MessageString : sPDE_LINEBUSY),
{ 4633}(MessageNumber : 4633;                         MessageString : sPDE_NOCONNECTION),
{ 4660}(MessageNumber : 4660;                         MessageString : sTAPS_NONE),
{ 4661}(MessageNumber : 4661;                         MessageString : sTAPS_LOGINPROMPT),
{ 4662}(MessageNumber : 4662;                         MessageString : sTAPS_LOGGEDIN),
{ 4663}(MessageNumber : 4663;                         MessageString : sTAPS_LOGINERR),
{ 4664}(MessageNumber : 4664;                         MessageString : sTAPS_LOGINFAIL),
{ 4665}(MessageNumber : 4665;                         MessageString : sTAPS_MSGOKTOSEND),
{ 4666}(MessageNumber : 4666;                         MessageString : sTAPS_SENDINGMSG),
{ 4667}(MessageNumber : 4667;                         MessageString : sTAPS_MSGACK),
{ 4668}(MessageNumber : 4668;                         MessageString : sTAPS_MSGNAK),
{ 4669}(MessageNumber : 4669;                         MessageString : sTAPS_MSGRS),
{ 4670}(MessageNumber : 4670;                         MessageString : sTAPS_MSGCOMPLETED),
{ 4671}(MessageNumber : 4671;                         MessageString : sTAPS_DONE),
{ 4700}(MessageNumber : psOK;                         MessageString : spsOK),
{ 4701}(MessageNumber : psProtocolHandshake;          MessageString : spsProtocolHandshake),
{ 4702}(MessageNumber : psInvalidDate;                MessageString : spsInvalidDate),
{ 4703}(MessageNumber : psFileRejected;               MessageString : spsFileRejected),
{ 4704}(MessageNumber : psFileRenamed;                MessageString : spsFileRenamed),
{ 4705}(MessageNumber : psSkipFile;                   MessageString : spsSkipFile),
{ 4706}(MessageNumber : psFileDoesntExist;            MessageString : spsFileDoesntExist),
{ 4707}(MessageNumber : psCantWriteFile;              MessageString : spsCantWriteFile),
{ 4708}(MessageNumber : psTimeout;                    MessageString : spsTimeout),
{ 4709}(MessageNumber : psBlockCheckError;            MessageString : spsBlockCheckError),
{ 4710}(MessageNumber : psLongPacket;                 MessageString : spsLongPacket),
{ 4711}(MessageNumber : psDuplicateBlock;             MessageString : spsDuplicateBlock),
{ 4712}(MessageNumber : psProtocolError;              MessageString : spsProtocolError),
{ 4713}(MessageNumber : psCancelRequested;            MessageString : spsCancelRequested),
{ 4714}(MessageNumber : psEndFile;                    MessageString : spsEndFile),
{ 4715}(MessageNumber : psResumeBad;                  MessageString : spsResumeBad),
{ 4716}(MessageNumber : psSequenceError;              MessageString : spsSequenceError),
{ 4717}(MessageNumber : psAbortNoCarrier;             MessageString : spsAbortNoCarrier),
{ 4718}(MessageNumber : psGotCrcE;                    MessageString : spsGotCrcE),
{ 4719}(MessageNumber : psGotCrcG;                    MessageString : spsGotCrcG),
{ 4720}(MessageNumber : psGotCrcW;                    MessageString : spsGotCrcW),
{ 4721}(MessageNumber : psGotCrcQ;                    MessageString : spsGotCrcQ),
{ 4722}(MessageNumber : psTryResume;                  MessageString : spsTryResume),
{ 4723}(MessageNumber : psHostResume;                 MessageString : spsHostResume),
{ 4724}(MessageNumber : psWaitAck;                    MessageString : spsWaitAck),
{ 4725}(MessageNumber : psNoHeader;                   MessageString : spsNoHeader),
{ 4726}(MessageNumber : psGotHeader;                  MessageString : spsGotHeader),
{ 4727}(MessageNumber : psGotData;                    MessageString : spsGotData),
{ 4728}(MessageNumber : psNoData;                     MessageString : spsNoData),
{ 4730}(MessageNumber : psAbort;                      MessageString : spsAbort),
{ 4801}(MessageNumber : fpInitModem;                  MessageString : sfpInitModem),
{ 4802}(MessageNumber : fpDialing;                    MessageString : sfpDialing),
{ 4803}(MessageNumber : fpBusyWait;                   MessageString : sfpBusyWait),
{ 4804}(MessageNumber : fpSendPage;                   MessageString : sfpSendPage),
{ 4805}(MessageNumber : fpSendPageStatus;             MessageString : sfpSendPageStatus),
{ 4806}(MessageNumber : fpPageError;                  MessageString : sfpPageError),
{ 4807}(MessageNumber : fpPageOK;                     MessageString : sfpPageOK),
{ 4808}(MessageNumber : fpConnecting;                 MessageString : sfpConnecting),
{ 4820}(MessageNumber : fpWaiting;                    MessageString : sfpWaiting),
{ 4821}(MessageNumber : fpNoConnect;                  MessageString : sfpNoConnect),
{ 4822}(MessageNumber : fpAnswer;                     MessageString : sfpAnswer),
{ 4823}(MessageNumber : fpIncoming;                   MessageString : sfpIncoming),
{ 4824}(MessageNumber : fpGetPage;                    MessageString : sfpGetPage),
{ 4825}(MessageNumber : fpGetPageResult;              MessageString : sfpGetPageResult),
{ 4826}(MessageNumber : fpCheckMorePages;             MessageString : sfpCheckMorePages),
{ 4827}(MessageNumber : fpGetHangup;                  MessageString : sfpGetHangup),
{ 4828}(MessageNumber : fpGotHangup;                  MessageString : sfpGotHangup),
{ 4830}(MessageNumber : fpSwitchModes;                MessageString : sfpSwitchModes),
{ 4831}(MessageNumber : fpMonitorEnabled;             MessageString : sfpMonitorEnabled),
{ 4832}(MessageNumber : fpMonitorDisabled;            MessageString : sfpMonitorDisabled),
{ 4840}(MessageNumber : fpSessionParams;              MessageString : sfpSessionParams),
{ 4841}(MessageNumber : fpGotRemoteID;                MessageString : sfpGotRemoteID),
{ 4842}(MessageNumber : fpCancel;                     MessageString : sfpCancel),
{ 4843}(MessageNumber : fpFinished;                   MessageString : sfpFinished),
{ 5001}(MessageNumber : ecNoMoreTriggers;             MessageString : secNoMoreTriggers),
{ 5002}(MessageNumber : ecTriggerTooLong;             MessageString : secTriggerTooLong),
{ 5003}(MessageNumber : ecBadTriggerHandle;           MessageString : secBadTriggerHandle),
{ 5501}(MessageNumber : ecStartStringEmpty;           MessageString : secStartStringEmpty),
{ 5502}(MessageNumber : ecPacketTooSmall;             MessageString : secPacketTooSmall),
{ 5503}(MessageNumber : ecNoEndCharCount;             MessageString : secNoEndCharCount),
{ 5504}(MessageNumber : ecEmptyEndString;             MessageString : secEmptyEndString),
{ 5505}(MessageNumber : ecZeroSizePacket;             MessageString : secZeroSizePacket),
{ 5506}(MessageNumber : ecPacketTooLong;              MessageString : secPacketTooLong),
{ 6001}(MessageNumber : ecBadFileList;                MessageString : secBadFileList),
{ 6002}(MessageNumber : ecNoSearchMask;               MessageString : secNoSearchMask),
{ 6003}(MessageNumber : ecNoMatchingFiles;            MessageString : secNoMatchingFiles),
{ 6004}(MessageNumber : ecDirNotFound;                MessageString : secDirNotFound),
{ 6005}(MessageNumber : ecCancelRequested;            MessageString : secCancelRequested),
{ 6006}(MessageNumber : ecTimeout;                    MessageString : secTimeout),
{ 6007}(MessageNumber : ecProtocolError;              MessageString : secProtocolError),
{ 6008}(MessageNumber : ecTooManyErrors;              MessageString : secTooManyErrors),
{ 6009}(MessageNumber : ecSequenceError;              MessageString : secSequenceError),
{ 6010}(MessageNumber : ecNoFilename;                 MessageString : secNoFilename),
{ 6011}(MessageNumber : ecFileRejected;               MessageString : secFileRejected),
{ 6012}(MessageNumber : ecCantWriteFile;              MessageString : secCantWriteFile),
{ 6013}(MessageNumber : ecTableFull;                  MessageString : secTableFull),
{ 6014}(MessageNumber : ecAbortNoCarrier;             MessageString : secAbortNoCarrier),
{ 6015}(MessageNumber : ecBadProtocolFunction;        MessageString : secBadProtocolFunction),
{ 6016}(MessageNumber : ecProtocolAbort;              MessageString : secProtocolAbort),
{ 7001}(MessageNumber : ecKeyTooLong;                 MessageString : secKeyTooLong),
{ 7002}(MessageNumber : ecDataTooLarge;               MessageString : secDataTooLarge),
{ 7003}(MessageNumber : ecNoFieldsDefined;            MessageString : secNoFieldsDefined),
{ 7004}(MessageNumber : ecIniWrite;                   MessageString : secIniWrite),
{ 7005}(MessageNumber : ecIniRead;                    MessageString : secIniRead),
{ 7006}(MessageNumber : ecNoIndexKey;                 MessageString : secNoIndexKey),
{ 7007}(MessageNumber : ecRecordExists;               MessageString : secRecordExists),
{ 7008}(MessageNumber : ecRecordNotFound;             MessageString : secRecordNotFound),
{ 7009}(MessageNumber : ecMustHaveIdxVal;             MessageString : secMustHaveIdxVal),
{ 7010}(MessageNumber : ecDatabaseFull;               MessageString : secDatabaseFull),
{ 7011}(MessageNumber : ecDatabaseEmpty;              MessageString : secDatabaseEmpty),
{ 7012}(MessageNumber : ecDatabaseNotPrepared;        MessageString : secDatabaseNotPrepared),
{ 7013}(MessageNumber : ecBadFieldList;               MessageString : secBadFieldList),
{ 7014}(MessageNumber : ecBadFieldForIndex;           MessageString : secBadFieldForIndex),
{ 7500}(MessageNumber : ecNoStateMachine;             MessageString : secNoStateMachine),
{ 7501}(MessageNumber : ecNoStartState;               MessageString : secNoStartState),
{ 7502}(MessageNumber : ecNoSapiEngine;               MessageString : secNoSapiEngine),
{ 8001}(MessageNumber : ecFaxBadFormat;               MessageString : secFaxBadFormat),
{ 8002}(MessageNumber : ecBadGraphicsFormat;          MessageString : secBadGraphicsFormat),
{ 8003}(MessageNumber : ecConvertAbort;               MessageString : secConvertAbort),
{ 8004}(MessageNumber : ecUnpackAbort;                MessageString : secUnpackAbort),
{ 8005}(MessageNumber : ecCantMakeBitmap;             MessageString : secCantMakeBitmap),
{ 8050}(MessageNumber : ecNoImageLoaded;              MessageString : secNoImageLoaded),
{ 8051}(MessageNumber : ecNoImageBlockMarked;         MessageString : secNoImageBlockMarked),
{ 8052}(MessageNumber : ecFontFileNotFound;           MessageString : secFontFileNotFound),
{ 8053}(MessageNumber : ecInvalidPageNumber;          MessageString : secInvalidPageNumber),
{ 8054}(MessageNumber : ecBmpTooBig;                  MessageString : secBmpTooBig),
{ 8055}(MessageNumber : ecEnhFontTooBig;              MessageString : secEnhFontTooBig),
{ 8060}(MessageNumber : ecFaxBadMachine;              MessageString : secFaxBadMachine),
{ 8061}(MessageNumber : ecFaxBadModemResult;          MessageString : secFaxBadModemResult),
{ 8062}(MessageNumber : ecFaxTrainError;              MessageString : secFaxTrainError),
{ 8063}(MessageNumber : ecFaxInitError;               MessageString : secFaxInitError),
{ 8064}(MessageNumber : ecFaxBusy;                    MessageString : secFaxBusy),
{ 8065}(MessageNumber : ecFaxVoiceCall;               MessageString : secFaxVoiceCall),
{ 8066}(MessageNumber : ecFaxDataCall;                MessageString : secFaxDataCall),
{ 8067}(MessageNumber : ecFaxNoDialTone;              MessageString : secFaxNoDialTone),
{ 8068}(MessageNumber : ecFaxNoCarrier;               MessageString : secFaxNoCarrier),
{ 8069}(MessageNumber : ecFaxSessionError;            MessageString : secFaxSessionError),
{ 8070}(MessageNumber : ecFaxPageError;               MessageString : secFaxPageError),
{ 8071}(MessageNumber : ecFaxGDIPrintError;           MessageString : secFaxGDIPrintError),
{ 8072}(MessageNumber : ecFaxMixedResolution;         MessageString : secFaxMixedResolution),
{ 8073}(MessageNumber : ecFaxConverterInitFail;       MessageString : secFaxConverterInitFail),
{ 8074}(MessageNumber : ecNoAnswer;                   MessageString : secNoAnswer),
{ 8075}(MessageNumber : ecAlreadyMonitored;           MessageString : secAlreadyMonitored),
{ 8080}(MessageNumber : ecUniAlreadyInstalled;        MessageString : secUniAlreadyInstalled),
{ 8081}(MessageNumber : ecUniCannotGetSysDir;         MessageString : secUniCannotGetSysDir),
{ 8082}(MessageNumber : ecUniCannotGetWinDir;         MessageString : secUniCannotGetWinDir),
{ 8083}(MessageNumber : ecUniUnknownLayout;           MessageString : secUniUnknownLayout),
{ 8085}(MessageNumber : ecUniCannotInstallFile;       MessageString : secUniCannotInstallFile),
{ 8087}(MessageNumber : ecDrvCopyError;               MessageString : secDrvCopyError),
{ 8088}(MessageNumber : ecCannotAddPrinter;           MessageString : secCannotAddPrinter),
{ 8089}(MessageNumber : ecDrvBadResources;            MessageString : secDrvBadResources),
{ 8090}(MessageNumber : ecDrvDriverNotFound;          MessageString : secDrvDriverNotFound),
{ 8091}(MessageNumber : ecUniCannotGetPrinterDriverDir;MessageString : secUniCannotGetPrinterDriverDir),
{ 8092}(MessageNumber : ecInstallDriverFailed;        MessageString : secInstallDriverFailed),
{ 8100}(MessageNumber : ecSMSBusy;                    MessageString : secSMSBusy),
{ 8101}(MessageNumber : ecSMSTimedOut;                MessageString : secSMSTimedOut),
{ 8102}(MessageNumber : ecSMSTooLong;                 MessageString : secSMSTooLong),
{ 8103}(MessageNumber : ecSMSUnknownStatus;           MessageString : secSMSUnknownStatus),
{ 8300}(MessageNumber : ecMEFailure;                  MessageString : secMEFailure),
{ 8301}(MessageNumber : ecServiceRes;                 MessageString : secServiceRes),
{ 8302}(MessageNumber : ecBadOperation;               MessageString : secBadOperation),
{ 8303}(MessageNumber : ecUnsupported;                MessageString : secUnsupported),
{ 8304}(MessageNumber : ecInvalidPDU;                 MessageString : secInvalidPDU),
{ 8305}(MessageNumber : ecInvalidText;                MessageString : secInvalidText),
{ 8310}(MessageNumber : ecSIMInsert;                  MessageString : secSIMInsert),
{ 8311}(MessageNumber : ecSIMPin;                     MessageString : secSIMPin),
{ 8312}(MessageNumber : ecSIMPH;                      MessageString : secSIMPH),
{ 8313}(MessageNumber : ecSIMFailure;                 MessageString : secSIMFailure),
{ 8314}(MessageNumber : ecSIMBusy;                    MessageString : secSIMBusy),
{ 8315}(MessageNumber : ecSIMWrong;                   MessageString : secSIMWrong),
{ 8316}(MessageNumber : ecSIMPUK;                     MessageString : secSIMPUK),
{ 8317}(MessageNumber : ecSIMPIN2;                    MessageString : secSIMPIN2),
{ 8318}(MessageNumber : ecSIMPUK2;                    MessageString : secSIMPUK2),
{ 8320}(MessageNumber : ecMemFail;                    MessageString : secMemFail),
{ 8321}(MessageNumber : ecInvalidMemIndex;            MessageString : secInvalidMemIndex),
{ 8322}(MessageNumber : ecMemFull;                    MessageString : secMemFull),
{ 8330}(MessageNumber : ecSMSCAddUnknown;             MessageString : secSMSCAddUnknown),
{ 8331}(MessageNumber : ecNoNetwork;                  MessageString : secNoNetwork),
{ 8332}(MessageNumber : ecNetworkTimeout;             MessageString : secNetworkTimeout),
{ 8340}(MessageNumber : ecCNMAAck;                    MessageString : secCNMAAck),
{ 8500}(MessageNumber : ecUnknown;                    MessageString : secUnknown),
{ 9001}(MessageNumber : ecADWSERROR;                  MessageString : secADWSERROR),
{ 9002}(MessageNumber : ecADWSLOADERROR;              MessageString : secADWSLOADERROR),
{ 9003}(MessageNumber : ecADWSVERSIONERROR;           MessageString : secADWSVERSIONERROR),
{ 9004}(MessageNumber : ecADWSNOTINIT;                MessageString : secADWSNOTINIT),
{ 9005}(MessageNumber : ecADWSINVPORT;                MessageString : secADWSINVPORT),
{ 9006}(MessageNumber : ecADWSCANTCHANGE;             MessageString : secADWSCANTCHANGE),
{ 9007}(MessageNumber : ecADWSCANTRESOLVE;            MessageString : secADWSCANTRESOLVE),
{10000}(MessageNumber : wsaBaseErr;                   MessageString : swsaBaseErr),
{10004}(MessageNumber : wsaEIntr;                     MessageString : swsaEIntr),
{10009}(MessageNumber : wsaEBadF;                     MessageString : swsaEBadF),
{10013}(MessageNumber : wsaEAcces;                    MessageString : swsaEAcces),
{10014}(MessageNumber : wsaEFault;                    MessageString : swsaEFault),
{10022}(MessageNumber : wsaEInVal;                    MessageString : swsaEInVal),
{10024}(MessageNumber : wsaEMFile;                    MessageString : swsaEMFile),
{10035}(MessageNumber : wsaEWouldBlock;               MessageString : swsaEWouldBlock),
{10036}(MessageNumber : wsaEInProgress;               MessageString : swsaEInProgress),
{10037}(MessageNumber : wsaEAlReady;                  MessageString : swsaEAlReady),
{10038}(MessageNumber : wsaENotSock;                  MessageString : swsaENotSock),
{10039}(MessageNumber : wsaEDestAddrReq;              MessageString : swsaEDestAddrReq),
{10040}(MessageNumber : wsaEMsgSize;                  MessageString : swsaEMsgSize),
{10041}(MessageNumber : wsaEPrototype;                MessageString : swsaEPrototype),
{10042}(MessageNumber : wsaENoProtoOpt;               MessageString : swsaENoProtoOpt),
{10043}(MessageNumber : wsaEProtoNoSupport;           MessageString : swsaEProtoNoSupport),
{10044}(MessageNumber : wsaESocktNoSupport;           MessageString : swsaESocktNoSupport),
{10045}(MessageNumber : wsaEOpNotSupp;                MessageString : swsaEOpNotSupp),
{10046}(MessageNumber : wsaEPfNoSupport;              MessageString : swsaEPfNoSupport),
{10047}(MessageNumber : wsaEAfNoSupport;              MessageString : swsaEAfNoSupport),
{10048}(MessageNumber : wsaEAddrInUse;                MessageString : swsaEAddrInUse),
{10049}(MessageNumber : wsaEAddrNotAvail;             MessageString : swsaEAddrNotAvail),
{10050}(MessageNumber : wsaENetDown;                  MessageString : swsaENetDown),
{10051}(MessageNumber : wsaENetUnreach;               MessageString : swsaENetUnreach),
{10052}(MessageNumber : wsaENetReset;                 MessageString : swsaENetReset),
{10053}(MessageNumber : wsaEConnAborted;              MessageString : swsaEConnAborted),
{10054}(MessageNumber : wsaEConnReset;                MessageString : swsaEConnReset),
{10055}(MessageNumber : wsaENoBufs;                   MessageString : swsaENoBufs),
{10056}(MessageNumber : wsaEIsConn;                   MessageString : swsaEIsConn),
{10057}(MessageNumber : wsaENotConn;                  MessageString : swsaENotConn),
{10058}(MessageNumber : wsaEShutDown;                 MessageString : swsaEShutDown),
{10059}(MessageNumber : wsaETooManyRefs;              MessageString : swsaETooManyRefs),
{10060}(MessageNumber : wsaETimedOut;                 MessageString : swsaETimedOut),
{10061}(MessageNumber : wsaEConnRefused;              MessageString : swsaEConnRefused),
{10062}(MessageNumber : wsaELoop;                     MessageString : swsaELoop),
{10063}(MessageNumber : wsaENameTooLong;              MessageString : swsaENameTooLong),
{10064}(MessageNumber : wsaEHostDown;                 MessageString : swsaEHostDown),
{10065}(MessageNumber : wsaEHostUnreach;              MessageString : swsaEHostUnreach),
{10066}(MessageNumber : wsaENotEmpty;                 MessageString : swsaENotEmpty),
{10067}(MessageNumber : wsaEProcLim;                  MessageString : swsaEProcLim),
{10068}(MessageNumber : wsaEUsers;                    MessageString : swsaEUsers),
{10069}(MessageNumber : wsaEDQuot;                    MessageString : swsaEDQuot),
{10070}(MessageNumber : wsaEStale;                    MessageString : swsaEStale),
{10071}(MessageNumber : wsaERemote;                   MessageString : swsaERemote),
{10091}(MessageNumber : wsaSysNotReady;               MessageString : swsaSysNotReady),
{10092}(MessageNumber : wsaVerNotSupported;           MessageString : swsaVerNotSupported),
{10093}(MessageNumber : wsaNotInitialised;            MessageString : swsaNotInitialised),
{10101}(MessageNumber : wsaEDiscOn;                   MessageString : swsaEDiscOn),
{11001}(MessageNumber : wsaHost_Not_Found;            MessageString : swsaHost_Not_Found),
{11002}(MessageNumber : wsaTry_Again;                 MessageString : swsaTry_Again),
{11003}(MessageNumber : wsaNo_Recovery;               MessageString : swsaNo_Recovery),
{11004}(MessageNumber : wsaNo_Data;                   MessageString : swsaNo_Data),
{13501}(MessageNumber : 13501;                        MessageString : stcs_Idle),
{13502}(MessageNumber : 13502;                        MessageString : stcs_Offering),
{13503}(MessageNumber : 13503;                        MessageString : stcs_Accepted),
{13504}(MessageNumber : 13504;                        MessageString : stcs_Dialtone),
{13505}(MessageNumber : 13505;                        MessageString : stcs_Dialing),
{13506}(MessageNumber : 13506;                        MessageString : stcs_Ringback),
{13507}(MessageNumber : 13507;                        MessageString : stcs_Busy),
{13508}(MessageNumber : 13508;                        MessageString : stcs_SpecialInfo),
{13509}(MessageNumber : 13509;                        MessageString : stcs_Connected),
{13510}(MessageNumber : 13510;                        MessageString : stcs_Proceeding),
{13511}(MessageNumber : 13511;                        MessageString : stcs_OnHold),
{13512}(MessageNumber : 13512;                        MessageString : stcs_Conferenced),
{13513}(MessageNumber : 13513;                        MessageString : stcs_OnHoldPendConf),
{13514}(MessageNumber : 13514;                        MessageString : stcs_OnHoldPendTransfer),
{13515}(MessageNumber : 13515;                        MessageString : stcs_Disconnected),
{13516}(MessageNumber : 13516;                        MessageString : stcs_Unknown),
{13533}(MessageNumber : 13533;                        MessageString : stds_Other),
{13534}(MessageNumber : 13534;                        MessageString : stds_Ringing),
{13535}(MessageNumber : 13535;                        MessageString : stds_Connected),
{13536}(MessageNumber : 13536;                        MessageString : stds_Disconnected),
{13537}(MessageNumber : 13537;                        MessageString : stds_MsgWaitOn),
{13538}(MessageNumber : 13538;                        MessageString : stds_MsgWaitOff),
{13539}(MessageNumber : 13539;                        MessageString : stds_InService),
{13540}(MessageNumber : 13540;                        MessageString : stds_OutOfService),
{13541}(MessageNumber : 13541;                        MessageString : stds_Maintenance),
{13542}(MessageNumber : 13542;                        MessageString : stds_Open),
{13543}(MessageNumber : 13543;                        MessageString : stds_Close),
{13544}(MessageNumber : 13544;                        MessageString : stds_NumCalls),
{13545}(MessageNumber : 13545;                        MessageString : stds_NumCompletions),
{13546}(MessageNumber : 13546;                        MessageString : stds_Terminals),
{13547}(MessageNumber : 13547;                        MessageString : stds_RoamMode),
{13548}(MessageNumber : 13548;                        MessageString : stds_Battery),
{13549}(MessageNumber : 13549;                        MessageString : stds_Signal),
{13550}(MessageNumber : 13550;                        MessageString : stds_DevSpecific),
{13551}(MessageNumber : 13551;                        MessageString : stds_ReInit),
{13552}(MessageNumber : 13552;                        MessageString : stds_Lock),
{13553}(MessageNumber : 13553;                        MessageString : stds_CapsChange),
{13554}(MessageNumber : 13554;                        MessageString : stds_ConfigChange),
{13555}(MessageNumber : 13555;                        MessageString : stds_TranslateChange),
{13556}(MessageNumber : 13556;                        MessageString : stds_ComplCancel),
{13557}(MessageNumber : 13557;                        MessageString : stds_Removed),
{13565}(MessageNumber : 13565;                        MessageString : sTAPILineReply),
{13597}(MessageNumber : 13597;                        MessageString : sTAPIStateChange),
{13598}(MessageNumber : 13598;                        MessageString : sTAPICalledBusy),
{13599}(MessageNumber : 13599;                        MessageString : sTAPIDialFail),
{13600}(MessageNumber : 13600;                        MessageString : sTAPIRetryWait),
{13601}(MessageNumber : 13601;                        MessageString : sTAPIDeviceInUse),
{13650}(MessageNumber : 13650;                        MessageString : sTAPIDisconnect_Unspecified),
{13651}(MessageNumber : 13651;                        MessageString : sTAPIDisconnect_Normal),
{13652}(MessageNumber : 13652;                        MessageString : sTAPIDisconnect_Unknown),
{13653}(MessageNumber : 13653;                        MessageString : sTAPIDisconnect_Reject),
{13654}(MessageNumber : 13654;                        MessageString : sTAPIDisconnect_PickUp),
{13655}(MessageNumber : 13655;                        MessageString : sTAPIDisconnect_Forwarded),
{13656}(MessageNumber : 13656;                        MessageString : sTAPIDisconnect_Busy),
{13657}(MessageNumber : 13657;                        MessageString : sTAPIDisconnect_NoAnswer),
{13658}(MessageNumber : 13658;                        MessageString : sTAPIDisconnect_BadAddress),
{13659}(MessageNumber : 13659;                        MessageString : sTAPIDisconnect_Unreachable),
{13660}(MessageNumber : 13660;                        MessageString : sTAPIDisconnect_Congestion),
{13661}(MessageNumber : 13661;                        MessageString : sTAPIDisconnect_Incompatible),
{13662}(MessageNumber : 13662;                        MessageString : sTAPIDisconnect_Unavail),
{13663}(MessageNumber : 13663;                        MessageString : sTAPIDisconnect_NoDialtone),
{13664}(MessageNumber : 13664;                        MessageString : sTAPIDisconnect_NumberChanged),
{13665}(MessageNumber : 13665;                        MessageString : sTAPIDisconnect_OutOfOrder),
{13666}(MessageNumber : 13666;                        MessageString : sTAPIDisconnect_TempFailure),
{13667}(MessageNumber : 13667;                        MessageString : sTAPIDisconnect_QOSUnavail),
{13668}(MessageNumber : 13668;                        MessageString : sTAPIDisconnect_Blocked),
{13669}(MessageNumber : 13669;                        MessageString : sTAPIDisconnect_DoNotDisturb),
{13670}(MessageNumber : 13670;                        MessageString : sTAPIDisconnect_Cancelled),
{13801}(MessageNumber : ecAllocated;                  MessageString : secAllocated),
{13802}(MessageNumber : ecBadDeviceID;                MessageString : secBadDeviceID),
{13803}(MessageNumber : ecBearerModeUnavail;          MessageString : secBearerModeUnavail),
{13805}(MessageNumber : ecCallUnavail;                MessageString : secCallUnavail),
{13806}(MessageNumber : ecCompletionOverrun;          MessageString : secCompletionOverrun),
{13807}(MessageNumber : ecConferenceFull;             MessageString : secConferenceFull),
{13808}(MessageNumber : ecDialBilling;                MessageString : secDialBilling),
{13809}(MessageNumber : ecDialDialtone;               MessageString : secDialDialtone),
{13810}(MessageNumber : ecDialPrompt;                 MessageString : secDialPrompt),
{13811}(MessageNumber : ecDialQuiet;                  MessageString : secDialQuiet),
{13812}(MessageNumber : ecIncompatibleApiVersion;     MessageString : secIncompatibleApiVersion),
{13813}(MessageNumber : ecIncompatibleExtVersion;     MessageString : secIncompatibleExtVersion),
{13814}(MessageNumber : ecIniFileCorrupt;             MessageString : secIniFileCorrupt),
{13815}(MessageNumber : ecInUse;                      MessageString : secInUse),
{13816}(MessageNumber : ecInvalAddress;               MessageString : secInvalAddress),
{13817}(MessageNumber : ecInvalAddressID;             MessageString : secInvalAddressID),
{13818}(MessageNumber : ecInvalAddressMode;           MessageString : secInvalAddressMode),
{13819}(MessageNumber : ecInvalAddressState;          MessageString : secInvalAddressState),
{13820}(MessageNumber : ecInvalAppHandle;             MessageString : secInvalAppHandle),
{13821}(MessageNumber : ecInvalAppName;               MessageString : secInvalAppName),
{13822}(MessageNumber : ecInvalBearerMode;            MessageString : secInvalBearerMode),
{13823}(MessageNumber : ecInvalCallComplMode;         MessageString : secInvalCallComplMode),
{13824}(MessageNumber : ecInvalCallHandle;            MessageString : secInvalCallHandle),
{13825}(MessageNumber : ecInvalCallParams;            MessageString : secInvalCallParams),
{13826}(MessageNumber : ecInvalCallPrivilege;         MessageString : secInvalCallPrivilege),
{13827}(MessageNumber : ecInvalCallSelect;            MessageString : secInvalCallSelect),
{13828}(MessageNumber : ecInvalCallState;             MessageString : secInvalCallState),
{13829}(MessageNumber : ecInvalCallStatelist;         MessageString : secInvalCallStatelist),
{13830}(MessageNumber : ecInvalCard;                  MessageString : secInvalCard),
{13831}(MessageNumber : ecInvalCompletionID;          MessageString : secInvalCompletionID),
{13832}(MessageNumber : ecInvalConfCallHandle;        MessageString : secInvalConfCallHandle),
{13833}(MessageNumber : ecInvalConsultCallHandle;     MessageString : secInvalConsultCallHandle),
{13834}(MessageNumber : ecInvalCountryCode;           MessageString : secInvalCountryCode),
{13835}(MessageNumber : ecInvalDeviceClass;           MessageString : secInvalDeviceClass),
{13836}(MessageNumber : ecInvalDeviceHandle;          MessageString : secInvalDeviceHandle),
{13837}(MessageNumber : ecInvalDialParams;            MessageString : secInvalDialParams),
{13838}(MessageNumber : ecInvalDigitList;             MessageString : secInvalDigitList),
{13839}(MessageNumber : ecInvalDigitMode;             MessageString : secInvalDigitMode),
{13840}(MessageNumber : ecInvalDigits;                MessageString : secInvalDigits),
{13841}(MessageNumber : ecInvalExtVersion;            MessageString : secInvalExtVersion),
{13842}(MessageNumber : ecInvalGroupID;               MessageString : secInvalGroupID),
{13843}(MessageNumber : ecInvalLineHandle;            MessageString : secInvalLineHandle),
{13844}(MessageNumber : ecInvalLineState;             MessageString : secInvalLineState),
{13845}(MessageNumber : ecInvalLocation;              MessageString : secInvalLocation),
{13846}(MessageNumber : ecInvalMediaList;             MessageString : secInvalMediaList),
{13847}(MessageNumber : ecInvalMediaMode;             MessageString : secInvalMediaMode),
{13848}(MessageNumber : ecInvalMessageID;             MessageString : secInvalMessageID),
{13850}(MessageNumber : ecInvalParam;                 MessageString : secInvalParam),
{13851}(MessageNumber : ecInvalParkID;                MessageString : secInvalParkID),
{13852}(MessageNumber : ecInvalParkMode;              MessageString : secInvalParkMode),
{13853}(MessageNumber : ecInvalPointer;               MessageString : secInvalPointer),
{13854}(MessageNumber : ecInvalPrivSelect;            MessageString : secInvalPrivSelect),
{13855}(MessageNumber : ecInvalRate;                  MessageString : secInvalRate),
{13856}(MessageNumber : ecInvalRequestMode;           MessageString : secInvalRequestMode),
{13857}(MessageNumber : ecInvalTerminalID;            MessageString : secInvalTerminalID),
{13858}(MessageNumber : ecInvalTerminalMode;          MessageString : secInvalTerminalMode),
{13859}(MessageNumber : ecInvalTimeout;               MessageString : secInvalTimeout),
{13860}(MessageNumber : ecInvalTone;                  MessageString : secInvalTone),
{13861}(MessageNumber : ecInvalToneList;              MessageString : secInvalToneList),
{13862}(MessageNumber : ecInvalToneMode;              MessageString : secInvalToneMode),
{13863}(MessageNumber : ecInvalTransferMode;          MessageString : secInvalTransferMode),
{13864}(MessageNumber : ecLineMapperFailed;           MessageString : secLineMapperFailed),
{13865}(MessageNumber : ecNoConference;               MessageString : secNoConference),
{13866}(MessageNumber : ecNoDevice;                   MessageString : secNoDevice),
{13867}(MessageNumber : ecNoDriver;                   MessageString : secNoDriver),
{13868}(MessageNumber : ecNoMem;                      MessageString : secNoMem),
{13869}(MessageNumber : ecNoRequest;                  MessageString : secNoRequest),
{13870}(MessageNumber : ecNotOwner;                   MessageString : secNotOwner),
{13871}(MessageNumber : ecNotRegistered;              MessageString : secNotRegistered),
{13872}(MessageNumber : ecOperationFailed;            MessageString : secOperationFailed),
{13873}(MessageNumber : ecOperationUnavail;           MessageString : secOperationUnavail),
{13874}(MessageNumber : ecRateUnavail;                MessageString : secRateUnavail),
{13875}(MessageNumber : ecResourceUnavail;            MessageString : secResourceUnavail),
{13876}(MessageNumber : ecRequestOverrun;             MessageString : secRequestOverrun),
{13877}(MessageNumber : ecStructureTooSmall;          MessageString : secStructureTooSmall),
{13878}(MessageNumber : ecTargetNotFound;             MessageString : secTargetNotFound),
{13879}(MessageNumber : ecTargetSelf;                 MessageString : secTargetSelf),
{13880}(MessageNumber : ecUninitialized;              MessageString : secUninitialized),
{13881}(MessageNumber : ecUserUserInfoTooBig;         MessageString : secUserUserInfoTooBig),
{13882}(MessageNumber : ecReinit;                     MessageString : secReinit),
{13883}(MessageNumber : ecAddressBlocked;             MessageString : secAddressBlocked),
{13884}(MessageNumber : ecBillingRejected;            MessageString : secBillingRejected),
{13885}(MessageNumber : ecInvalFeature;               MessageString : secInvalFeature),
{13886}(MessageNumber : ecNoMultipleInstance;         MessageString : secNoMultipleInstance),
{13928}(MessageNumber : ecTapiBusy;                   MessageString : secTapiBusy),
{13929}(MessageNumber : ecTapiNotSet;                 MessageString : secTapiNotSet),
{13930}(MessageNumber : ecTapiNoSelect;               MessageString : secTapiNoSelect),
{13931}(MessageNumber : ecTapiLoadFail;               MessageString : secTapiLoadFail),
{13932}(MessageNumber : ecTapiGetAddrFail;            MessageString : secTapiGetAddrFail),
{13933}(MessageNumber : 13933;                        MessageString : sTAPIdisabled16bit),
{13934}(MessageNumber : ecTapiUnexpected;             MessageString : secTapiUnexpected),
{13935}(MessageNumber : ecTapiVoiceNotSupported;      MessageString : secTapiVoiceNotSupported),
{13936}(MessageNumber : ecTapiWaveFail;               MessageString : secTapiWaveFail),
{13937}(MessageNumber : ecTapiCIDBlocked;             MessageString : secTapiCIDBlocked),
{13938}(MessageNumber : ecTapiCIDOutOfArea;           MessageString : secTapiCIDOutOfArea),
{13939}(MessageNumber : ecTapiWaveFormatError;        MessageString : secTapiWaveFormatError),
{13940}(MessageNumber : ecTapiWaveReadError;          MessageString : secTapiWaveReadError),
{13941}(MessageNumber : ecTapiWaveBadFormat;          MessageString : secTapiWaveBadFormat),
{13942}(MessageNumber : ecTapiTranslateFail;          MessageString : secTapiTranslateFail),
{13943}(MessageNumber : ecTapiWaveDeviceInUse;        MessageString : secTapiWaveDeviceInUse),
{13944}(MessageNumber : ecTapiWaveFileExists;         MessageString : secTapiWaveFileExists),
{13945}(MessageNumber : ecTapiWaveNoData;             MessageString : secTapiWaveNoData),
{13950}(MessageNumber : ecVoIPNotSupported;           MessageString : secVoIPNotSupported),
{13951}(MessageNumber : ecVoIPCallBusy;               MessageString : secVoIPCallBusy),
{13952}(MessageNumber : ecVoIPBadAddress;             MessageString : secVoIPBadAddress),
{13953}(MessageNumber : ecVoIPNoAnswer;               MessageString : secVoIPNoAnswer),
{13954}(MessageNumber : ecVoIPCancelled;              MessageString : secVoIPCancelled),
{13955}(MessageNumber : ecVoIPRejected;               MessageString : secVoIPRejected),
{13956}(MessageNumber : ecVoIPFailed;                 MessageString : secVoIPFailed),
{13957}(MessageNumber : ecVoIPTapi3NotInstalled;      MessageString : secVoIPTapi3NotInstalled),
{13958}(MessageNumber : ecVoIPH323NotFound;           MessageString : secVoIPH323NotFound),
{13959}(MessageNumber : ecVoIPTapi3EventFailure;      MessageString : secVoIPTapi3EventFailure),
{13980}(MessageNumber : ecRasLoadFail;                MessageString : secRasLoadFail),
{15001}(MessageNumber : 15001;                        MessageString : sdtNone),
{15002}(MessageNumber : 15002;                        MessageString : sdtDispatch),
{15003}(MessageNumber : 15003;                        MessageString : sdtTrigger),
{15004}(MessageNumber : 15004;                        MessageString : sdtError),
{15005}(MessageNumber : 15005;                        MessageString : sdtThread),
{15006}(MessageNumber : 15006;                        MessageString : sdtTriggerAlloc),
{15007}(MessageNumber : 15007;                        MessageString : sdtTriggerDispose),
{15008}(MessageNumber : 15008;                        MessageString : sdtTriggerHandlerAlloc),
{15009}(MessageNumber : 15009;                        MessageString : sdtTriggerHandlerDispose),
{15010}(MessageNumber : 15010;                        MessageString : sdtTriggerDataChange),
{15011}(MessageNumber : 15011;                        MessageString : sdtTelnet),
{15012}(MessageNumber : 15012;                        MessageString : sdtFax),
{15013}(MessageNumber : 15013;                        MessageString : sdtXModem),
{15014}(MessageNumber : 15014;                        MessageString : sdtYModem),
{15015}(MessageNumber : 15015;                        MessageString : sdtZModem),
{15016}(MessageNumber : 15016;                        MessageString : sdtKermit),
{15017}(MessageNumber : 15017;                        MessageString : sdtAscii),
{15018}(MessageNumber : 15018;                        MessageString : sdtBPlus),
{15019}(MessageNumber : 15019;                        MessageString : sdtPacket),
{15020}(MessageNumber : 15020;                        MessageString : sdtUser),
{15021}(MessageNumber : 15021;                        MessageString : sdtScript),
{15100}(MessageNumber : 15100;                        MessageString : sdstNone),
{15101}(MessageNumber : 15101;                        MessageString : sdstReadCom),
{15102}(MessageNumber : 15102;                        MessageString : sdstWriteCom),
{15103}(MessageNumber : 15103;                        MessageString : sdstLineStatus),
{15104}(MessageNumber : 15104;                        MessageString : sdstModemStatus),
{15105}(MessageNumber : 15105;                        MessageString : sdstAvail),
{15106}(MessageNumber : 15106;                        MessageString : sdstTimer),
{15107}(MessageNumber : 15107;                        MessageString : sdstData),
{15108}(MessageNumber : 15108;                        MessageString : sdstStatus),
{15109}(MessageNumber : 15109;                        MessageString : sdstThreadStart),
{15110}(MessageNumber : 15110;                        MessageString : sdstThreadExit),
{15111}(MessageNumber : 15111;                        MessageString : sdstThreadSleep),
{15112}(MessageNumber : 15112;                        MessageString : sdstThreadWake),
{15113}(MessageNumber : 15113;                        MessageString : sdstDataTrigger),
{15114}(MessageNumber : 15114;                        MessageString : sdstTimerTrigger),
{15115}(MessageNumber : 15115;                        MessageString : sdstStatusTrigger),
{15116}(MessageNumber : 15116;                        MessageString : sdstAvailTrigger),
{15117}(MessageNumber : 15117;                        MessageString : sdstWndHandler),
{15118}(MessageNumber : 15118;                        MessageString : sdstProcHandler),
{15119}(MessageNumber : 15119;                        MessageString : sdstEventHandler),
{15120}(MessageNumber : 15120;                        MessageString : sdstSWill),
{15121}(MessageNumber : 15121;                        MessageString : sdstSWont),
{15122}(MessageNumber : 15122;                        MessageString : sdstSDo),
{15123}(MessageNumber : 15123;                        MessageString : sdstSDont),
{15124}(MessageNumber : 15124;                        MessageString : sdstRWill),
{15125}(MessageNumber : 15125;                        MessageString : sdstRWont),
{15126}(MessageNumber : 15126;                        MessageString : sdstRDo),
{15127}(MessageNumber : 15127;                        MessageString : sdstRDont),
{15128}(MessageNumber : 15128;                        MessageString : sdstCommand),
{15129}(MessageNumber : 15129;                        MessageString : sdstSTerm),
{15130}(MessageNumber : 15130;                        MessageString : sdsttfNone),
{15131}(MessageNumber : 15131;                        MessageString : sdsttfGetEntry),
{15132}(MessageNumber : 15132;                        MessageString : sdsttfInit),
{15133}(MessageNumber : 15133;                        MessageString : sdsttf1Init1),
{15134}(MessageNumber : 15134;                        MessageString : sdsttf2Init1),
{15135}(MessageNumber : 15135;                        MessageString : sdsttf2Init1A),
{15136}(MessageNumber : 15136;                        MessageString : sdsttf2Init1B),
{15137}(MessageNumber : 15137;                        MessageString : sdsttf2Init2),
{15138}(MessageNumber : 15138;                        MessageString : sdsttf2Init3),
{15139}(MessageNumber : 15139;                        MessageString : sdsttfDial),
{15140}(MessageNumber : 15140;                        MessageString : sdsttfRetryWait),
{15141}(MessageNumber : 15141;                        MessageString : sdsttf1Connect),
{15142}(MessageNumber : 15142;                        MessageString : sdsttf1SendTSI),
{15143}(MessageNumber : 15143;                        MessageString : sdsttf1TSIResponse),
{15144}(MessageNumber : 15144;                        MessageString : sdsttf1DCSResponse),
{15145}(MessageNumber : 15145;                        MessageString : sdsttf1TrainStart),
{15146}(MessageNumber : 15146;                        MessageString : sdsttf1TrainFinish),
{15147}(MessageNumber : 15147;                        MessageString : sdsttf1WaitCFR),
{15148}(MessageNumber : 15148;                        MessageString : sdsttf1WaitPageConnect),
{15149}(MessageNumber : 15149;                        MessageString : sdsttf2Connect),
{15150}(MessageNumber : 15150;                        MessageString : sdsttf2GetParams),
{15151}(MessageNumber : 15151;                        MessageString : sdsttfWaitXon),
{15152}(MessageNumber : 15152;                        MessageString : sdsttfWaitFreeHeader),
{15153}(MessageNumber : 15153;                        MessageString : sdsttfSendPageHeader),
{15154}(MessageNumber : 15154;                        MessageString : sdsttfOpenCover),
{15155}(MessageNumber : 15155;                        MessageString : sdsttfSendCover),
{15156}(MessageNumber : 15156;                        MessageString : sdsttfPrepPage),
{15157}(MessageNumber : 15157;                        MessageString : sdsttfSendPage),
{15158}(MessageNumber : 15158;                        MessageString : sdsttfDrainPage),
{15159}(MessageNumber : 15159;                        MessageString : sdsttf1PageEnd),
{15160}(MessageNumber : 15160;                        MessageString : sdsttf1PrepareEOP),
{15161}(MessageNumber : 15161;                        MessageString : sdsttf1SendEOP),
{15162}(MessageNumber : 15162;                        MessageString : sdsttf1WaitMPS),
{15163}(MessageNumber : 15163;                        MessageString : sdsttf1WaitEOP),
{15164}(MessageNumber : 15164;                        MessageString : sdsttf1WaitMCF),
{15165}(MessageNumber : 15165;                        MessageString : sdsttf1SendDCN),
{15166}(MessageNumber : 15166;                        MessageString : sdsttf1Hangup),
{15167}(MessageNumber : 15167;                        MessageString : sdsttf1WaitHangup),
{15168}(MessageNumber : 15168;                        MessageString : sdsttf2SendEOP),
{15169}(MessageNumber : 15169;                        MessageString : sdsttf2WaitFPTS),
{15170}(MessageNumber : 15170;                        MessageString : sdsttf2WaitFET),
{15171}(MessageNumber : 15171;                        MessageString : sdsttf2WaitPageOK),
{15172}(MessageNumber : 15172;                        MessageString : sdsttf2SendNewParams),
{15173}(MessageNumber : 15173;                        MessageString : sdsttf2NextPage),
{15174}(MessageNumber : 15174;                        MessageString : sdsttf20CheckPage),
{15175}(MessageNumber : 15175;                        MessageString : sdsttfClose),
{15176}(MessageNumber : 15176;                        MessageString : sdsttfCompleteOK),
{15177}(MessageNumber : 15177;                        MessageString : sdsttfAbort),
{15178}(MessageNumber : 15178;                        MessageString : sdsttfDone),
{15179}(MessageNumber : 15179;                        MessageString : sdstrfNone),
{15180}(MessageNumber : 15180;                        MessageString : sdstrfInit),
{15181}(MessageNumber : 15181;                        MessageString : sdstrf1Init1),
{15182}(MessageNumber : 15182;                        MessageString : sdstrf2Init1),
{15183}(MessageNumber : 15183;                        MessageString : sdstrf2Init1A),
{15184}(MessageNumber : 15184;                        MessageString : sdstrf2Init1B),
{15185}(MessageNumber : 15185;                        MessageString : sdstrf2Init2),
{15186}(MessageNumber : 15186;                        MessageString : sdstrf2Init3),
{15187}(MessageNumber : 15187;                        MessageString : sdstrfWaiting),
{15188}(MessageNumber : 15188;                        MessageString : sdstrfAnswer),
{15189}(MessageNumber : 15189;                        MessageString : sdstrf1SendCSI),
{15190}(MessageNumber : 15190;                        MessageString : sdstrf1SendDIS),
{15191}(MessageNumber : 15191;                        MessageString : sdstrf1CollectFrames),
{15192}(MessageNumber : 15192;                        MessageString : sdstrf1CollectRetry1),
{15193}(MessageNumber : 15193;                        MessageString : sdstrf1CollectRetry2),
{15194}(MessageNumber : 15194;                        MessageString : sdstrf1StartTrain),
{15195}(MessageNumber : 15195;                        MessageString : sdstrf1CollectTrain),
{15196}(MessageNumber : 15196;                        MessageString : sdstrf1Timeout),
{15197}(MessageNumber : 15197;                        MessageString : sdstrf1Retrain),
{15198}(MessageNumber : 15198;                        MessageString : sdstrf1FinishTrain),
{15199}(MessageNumber : 15199;                        MessageString : sdstrf1SendCFR),
{15200}(MessageNumber : 15200;                        MessageString : sdstrf1WaitPageConnect),
{15201}(MessageNumber : 15201;                        MessageString : sdstrf2ValidConnect),
{15202}(MessageNumber : 15202;                        MessageString : sdstrf2GetSenderID),
{15203}(MessageNumber : 15203;                        MessageString : sdstrf2GetConnect),
{15204}(MessageNumber : 15204;                        MessageString : sdstrfStartPage),
{15205}(MessageNumber : 15205;                        MessageString : sdstrfGetPageData),
{15206}(MessageNumber : 15206;                        MessageString : sdstrf1FinishPage),
{15207}(MessageNumber : 15207;                        MessageString : sdstrf1WaitEOP),
{15208}(MessageNumber : 15208;                        MessageString : sdstrf1WritePage),
{15209}(MessageNumber : 15209;                        MessageString : sdstrf1SendMCF),
{15210}(MessageNumber : 15210;                        MessageString : sdstrf1WaitDCN),
{15211}(MessageNumber : 15211;                        MessageString : sdstrf1WaitHangup),
{15212}(MessageNumber : 15212;                        MessageString : sdstrf2GetPageResult),
{15213}(MessageNumber : 15213;                        MessageString : sdstrf2GetFHNG),
{15214}(MessageNumber : 15214;                        MessageString : sdstrfComplete),
{15215}(MessageNumber : 15215;                        MessageString : sdstrfAbort),
{15216}(MessageNumber : 15216;                        MessageString : sdstrfDone),
{15217}(MessageNumber : 15217;                        MessageString : sdsttxInitial),
{15218}(MessageNumber : 15218;                        MessageString : sdsttxHandshake),
{15219}(MessageNumber : 15219;                        MessageString : sdsttxGetBlock),
{15220}(MessageNumber : 15220;                        MessageString : sdsttxWaitFreeSpace),
{15221}(MessageNumber : 15221;                        MessageString : sdsttxSendBlock),
{15222}(MessageNumber : 15222;                        MessageString : sdsttxDraining),
{15223}(MessageNumber : 15223;                        MessageString : sdsttxReplyPending),
{15224}(MessageNumber : 15224;                        MessageString : sdsttxEndDrain),
{15225}(MessageNumber : 15225;                        MessageString : sdsttxFirstEndOfTransmit),
{15226}(MessageNumber : 15226;                        MessageString : sdsttxRestEndOfTransmit),
{15227}(MessageNumber : 15227;                        MessageString : sdsttxEotReply),
{15228}(MessageNumber : 15228;                        MessageString : sdsttxFinished),
{15229}(MessageNumber : 15229;                        MessageString : sdsttxDone),
{15230}(MessageNumber : 15230;                        MessageString : sdstrxInitial),
{15231}(MessageNumber : 15231;                        MessageString : sdstrxWaitForHSReply),
{15232}(MessageNumber : 15232;                        MessageString : sdstrxWaitForBlockStart),
{15233}(MessageNumber : 15233;                        MessageString : sdstrxCollectBlock),
{15234}(MessageNumber : 15234;                        MessageString : sdstrxProcessBlock),
{15235}(MessageNumber : 15235;                        MessageString : sdstrxFinishedSkip),
{15236}(MessageNumber : 15236;                        MessageString : sdstrxFinished),
{15237}(MessageNumber : 15237;                        MessageString : sdstrxDone),
{15238}(MessageNumber : 15238;                        MessageString : sdsttyInitial),
{15239}(MessageNumber : 15239;                        MessageString : sdsttyHandshake),
{15240}(MessageNumber : 15240;                        MessageString : sdsttyGetFileName),
{15241}(MessageNumber : 15241;                        MessageString : sdsttySendFileName),
{15242}(MessageNumber : 15242;                        MessageString : sdsttyDraining),
{15243}(MessageNumber : 15243;                        MessageString : sdsttyReplyPending),
{15244}(MessageNumber : 15244;                        MessageString : sdsttyPrepXmodem),
{15245}(MessageNumber : 15245;                        MessageString : sdsttySendXmodem),
{15246}(MessageNumber : 15246;                        MessageString : sdsttyFinished),
{15247}(MessageNumber : 15247;                        MessageString : sdsttyFinishDrain),
{15248}(MessageNumber : 15248;                        MessageString : sdsttyDone),
{15249}(MessageNumber : 15249;                        MessageString : sdstryInitial),
{15250}(MessageNumber : 15250;                        MessageString : sdstryDelay),
{15251}(MessageNumber : 15251;                        MessageString : sdstryWaitForHSReply),
{15252}(MessageNumber : 15252;                        MessageString : sdstryWaitForBlockStart),
{15253}(MessageNumber : 15253;                        MessageString : sdstryCollectBlock),
{15254}(MessageNumber : 15254;                        MessageString : sdstryProcessBlock),
{15255}(MessageNumber : 15255;                        MessageString : sdstryOpenFile),
{15256}(MessageNumber : 15256;                        MessageString : sdstryPrepXmodem),
{15257}(MessageNumber : 15257;                        MessageString : sdstryReceiveXmodem),
{15258}(MessageNumber : 15258;                        MessageString : sdstryFinished),
{15259}(MessageNumber : 15259;                        MessageString : sdstryDone),
{15260}(MessageNumber : 15260;                        MessageString : sdsttzInitial),
{15261}(MessageNumber : 15261;                        MessageString : sdsttzHandshake),
{15262}(MessageNumber : 15262;                        MessageString : sdsttzGetFile),
{15263}(MessageNumber : 15263;                        MessageString : sdsttzSendFile),
{15264}(MessageNumber : 15264;                        MessageString : sdsttzCheckFile),
{15265}(MessageNumber : 15265;                        MessageString : sdsttzStartData),
{15266}(MessageNumber : 15266;                        MessageString : sdsttzEscapeData),
{15267}(MessageNumber : 15267;                        MessageString : sdsttzSendData),
{15268}(MessageNumber : 15268;                        MessageString : sdsttzWaitAck),
{15269}(MessageNumber : 15269;                        MessageString : sdsttzSendEof),
{15270}(MessageNumber : 15270;                        MessageString : sdsttzDrainEof),
{15271}(MessageNumber : 15271;                        MessageString : sdsttzCheckEof),
{15272}(MessageNumber : 15272;                        MessageString : sdsttzSendFinish),
{15273}(MessageNumber : 15273;                        MessageString : sdsttzCheckFinish),
{15274}(MessageNumber : 15274;                        MessageString : sdsttzError),
{15275}(MessageNumber : 15275;                        MessageString : sdsttzCleanup),
{15276}(MessageNumber : 15276;                        MessageString : sdsttzDone),
{15277}(MessageNumber : 15277;                        MessageString : sdstrzRqstFile),
{15278}(MessageNumber : 15278;                        MessageString : sdstrzDelay),
{15279}(MessageNumber : 15279;                        MessageString : sdstrzWaitFile),
{15280}(MessageNumber : 15280;                        MessageString : sdstrzCollectFile),
{15281}(MessageNumber : 15281;                        MessageString : sdstrzSendInit),
{15282}(MessageNumber : 15282;                        MessageString : sdstrzSendBlockPrep),
{15283}(MessageNumber : 15283;                        MessageString : sdstrzSendBlock),
{15284}(MessageNumber : 15284;                        MessageString : sdstrzSync),
{15285}(MessageNumber : 15285;                        MessageString : sdstrzStartFile),
{15286}(MessageNumber : 15286;                        MessageString : sdstrzStartData),
{15287}(MessageNumber : 15287;                        MessageString : sdstrzCollectData),
{15288}(MessageNumber : 15288;                        MessageString : sdstrzGotData),
{15289}(MessageNumber : 15289;                        MessageString : sdstrzWaitEof),
{15290}(MessageNumber : 15290;                        MessageString : sdstrzEndOfFile),
{15291}(MessageNumber : 15291;                        MessageString : sdstrzSendFinish),
{15292}(MessageNumber : 15292;                        MessageString : sdstrzCollectFinish),
{15293}(MessageNumber : 15293;                        MessageString : sdstrzError),
{15294}(MessageNumber : 15294;                        MessageString : sdstrzWaitCancel),
{15295}(MessageNumber : 15295;                        MessageString : sdstrzCleanup),
{15296}(MessageNumber : 15296;                        MessageString : sdstrzDone),
{15297}(MessageNumber : 15297;                        MessageString : sdsttkInit),
{15298}(MessageNumber : 15298;                        MessageString : sdsttkInitReply),
{15299}(MessageNumber : 15299;                        MessageString : sdsttkCollectInit),
{15300}(MessageNumber : 15300;                        MessageString : sdsttkOpenFile),
{15301}(MessageNumber : 15301;                        MessageString : sdsttkSendFile),
{15302}(MessageNumber : 15302;                        MessageString : sdsttkFileReply),
{15303}(MessageNumber : 15303;                        MessageString : sdsttkCollectFile),
{15304}(MessageNumber : 15304;                        MessageString : sdsttkCheckTable),
{15305}(MessageNumber : 15305;                        MessageString : sdsttkSendData),
{15306}(MessageNumber : 15306;                        MessageString : sdsttkBlockReply),
{15307}(MessageNumber : 15307;                        MessageString : sdsttkCollectBlock),
{15308}(MessageNumber : 15308;                        MessageString : sdsttkSendEof),
{15309}(MessageNumber : 15309;                        MessageString : sdsttkEofReply),
{15310}(MessageNumber : 15310;                        MessageString : sdsttkCollectEof),
{15311}(MessageNumber : 15311;                        MessageString : sdsttkSendBreak),
{15312}(MessageNumber : 15312;                        MessageString : sdsttkBreakReply),
{15313}(MessageNumber : 15313;                        MessageString : sdsttkCollectBreak),
{15314}(MessageNumber : 15314;                        MessageString : sdsttkComplete),
{15315}(MessageNumber : 15315;                        MessageString : sdsttkWaitCancel),
{15316}(MessageNumber : 15316;                        MessageString : sdsttkError),
{15317}(MessageNumber : 15317;                        MessageString : sdsttkDone),
{15318}(MessageNumber : 15318;                        MessageString : sdstrkInit),
{15319}(MessageNumber : 15319;                        MessageString : sdstrkGetInit),
{15320}(MessageNumber : 15320;                        MessageString : sdstrkCollectInit),
{15321}(MessageNumber : 15321;                        MessageString : sdstrkGetFile),
{15322}(MessageNumber : 15322;                        MessageString : sdstrkCollectFile),
{15323}(MessageNumber : 15323;                        MessageString : sdstrkGetData),
{15324}(MessageNumber : 15324;                        MessageString : sdstrkCollectData),
{15325}(MessageNumber : 15325;                        MessageString : sdstrkComplete),
{15326}(MessageNumber : 15326;                        MessageString : sdstrkWaitCancel),
{15327}(MessageNumber : 15327;                        MessageString : sdstrkError),
{15328}(MessageNumber : 15328;                        MessageString : sdstrkDone),
{15329}(MessageNumber : 15329;                        MessageString : sdsttaInitial),
{15330}(MessageNumber : 15330;                        MessageString : sdsttaGetBlock),
{15331}(MessageNumber : 15331;                        MessageString : sdsttaWaitFreeSpace),
{15332}(MessageNumber : 15332;                        MessageString : sdsttaSendBlock),
{15333}(MessageNumber : 15333;                        MessageString : sdsttaSendDelay),
{15334}(MessageNumber : 15334;                        MessageString : sdsttaFinishDrain),
{15335}(MessageNumber : 15335;                        MessageString : sdsttaFinished),
{15336}(MessageNumber : 15336;                        MessageString : sdsttaDone),
{15337}(MessageNumber : 15337;                        MessageString : sdstraInitial),
{15338}(MessageNumber : 15338;                        MessageString : sdstraCollectBlock),
{15339}(MessageNumber : 15339;                        MessageString : sdstraProcessBlock),
{15340}(MessageNumber : 15340;                        MessageString : sdstraFinished),
{15341}(MessageNumber : 15341;                        MessageString : sdstraDone),
{15342}(MessageNumber : 15342;                        MessageString : sdstEnable),
{15343}(MessageNumber : 15343;                        MessageString : sdstDisable),
{15344}(MessageNumber : 15344;                        MessageString : sdstStringPacket),
{15345}(MessageNumber : 15345;                        MessageString : sdstSizePacket),
{15346}(MessageNumber : 15346;                        MessageString : sdstPacketTimeout),
{15347}(MessageNumber : 15347;                        MessageString : sdstStartStr),
{15348}(MessageNumber : 15348;                        MessageString : sdstEndStr),
{15349}(MessageNumber : 15349;                        MessageString : sdstIdle),
{15350}(MessageNumber : 15350;                        MessageString : sdstWaiting),
{15351}(MessageNumber : 15351;                        MessageString : sdstCollecting),
{15352}(MessageNumber : 15352;                        MessageString : sdstThreadStatusQueued),  // SWB
{15353}(MessageNumber : 15353;                        MessageString : sdstThreadDataQueued),    // SWB
{15354}(MessageNumber : 15354;                        MessageString : sdstThreadDataWritten),   // SWB
{15355}(MessageNumber : 15355;                        MessageString : sdsttzSInit),             // SWB
{15356}(MessageNumber : 15356;                        MessageString : sdsttzCheckSInit),        // SWB
{15501}(MessageNumber : 15501;                        MessageString : sdispHeader),
{15502}(MessageNumber : 15502;                        MessageString : sdispHeaderLine),
{15601}(MessageNumber : 15601;                        MessageString : sdispmdmtagDCTS),
{15602}(MessageNumber : 15602;                        MessageString : sdispmdmtagDDSR),
{15603}(MessageNumber : 15603;                        MessageString : sdispmdmtagTERI),
{15604}(MessageNumber : 15604;                        MessageString : sdispmdmtagDDCD),
{15605}(MessageNumber : 15605;                        MessageString : sdispmdmtagCTS),
{15606}(MessageNumber : 15606;                        MessageString : sdispmdmtagDSR),
{15607}(MessageNumber : 15607;                        MessageString : sdispmdmtagRI),
{15608}(MessageNumber : 15608;                        MessageString : sdispmdmtagDCD),
{15700}(MessageNumber : 15700;                        MessageString : sdispTelnetBinary),
{15701}(MessageNumber : 15701;                        MessageString : sdispTelnetEcho),
{15702}(MessageNumber : 15702;                        MessageString : sdispTelnetReconnection),
{15703}(MessageNumber : 15703;                        MessageString : sdispTelnetSupressGoAhead),
{15704}(MessageNumber : 15704;                        MessageString : sdispTelnetApproxMsgSize),
{15705}(MessageNumber : 15705;                        MessageString : sdispTelnetStatus),
{15706}(MessageNumber : 15706;                        MessageString : sdispTelnetTimingMark),
{15707}(MessageNumber : 15707;                        MessageString : sdispTelnetRemoteTransEcho),
{15708}(MessageNumber : 15708;                        MessageString : sdispTelnetOutputLineWidth),
{15709}(MessageNumber : 15709;                        MessageString : sdispTelnetOutputPageSize),
{15710}(MessageNumber : 15710;                        MessageString : sdispTelnetOutputCRDisp),
{15711}(MessageNumber : 15711;                        MessageString : sdispTelnetOutputHorzTabs),
{15712}(MessageNumber : 15712;                        MessageString : sdispTelnetOutputHorzTabDisp),
{15713}(MessageNumber : 15713;                        MessageString : sdispTelnetOutputFFDisp),
{15714}(MessageNumber : 15714;                        MessageString : sdispTelnetOutputVertTabs),
{15715}(MessageNumber : 15715;                        MessageString : sdispTelnetOutputVertTabDisp),
{15716}(MessageNumber : 15716;                        MessageString : sdispTelnetOutputLinefeedDisp),
{15717}(MessageNumber : 15717;                        MessageString : sdispTelnetExtendedASCII),
{15718}(MessageNumber : 15718;                        MessageString : sdispTelnetLogout),
{15719}(MessageNumber : 15719;                        MessageString : sdispTelnetByteMacro),
{15720}(MessageNumber : 15720;                        MessageString : sdispTelnetDataEntryTerminal),
{15721}(MessageNumber : 15721;                        MessageString : sdispTelnetSUPDUP),
{15722}(MessageNumber : 15722;                        MessageString : sdispTelnetSUPDUPOutput),
{15723}(MessageNumber : 15723;                        MessageString : sdispTelnetSendLocation),
{15724}(MessageNumber : 15724;                        MessageString : sdispTelnetTerminalType),
{15725}(MessageNumber : 15725;                        MessageString : sdispTelnetEndofRecord),
{15726}(MessageNumber : 15726;                        MessageString : sdispTelnetTACACSUserID),
{15727}(MessageNumber : 15727;                        MessageString : sdispTelnetOutputMarking),
{15728}(MessageNumber : 15728;                        MessageString : sdispTelnetTerminalLocNum),
{15729}(MessageNumber : 15729;                        MessageString : sdispTelnetTelnet3270Regime),
{15730}(MessageNumber : 15730;                        MessageString : sdispTelnetX3PAD),
{15731}(MessageNumber : 15731;                        MessageString : sdispTelnetNegWindowSize),
{15732}(MessageNumber : 15732;                        MessageString : sdispTelnetTerminalSpeed),
{15733}(MessageNumber : 15733;                        MessageString : sdispTelnetFlowControl),
{15734}(MessageNumber : 15734;                        MessageString : sdispTelnetLineMode),
{15735}(MessageNumber : 15735;                        MessageString : sdispTelnetXDisplayLocation),
{15736}(MessageNumber : 15736;                        MessageString : sdispTelnetEnvironment),
{15737}(MessageNumber : 15737;                        MessageString : sdispTelnetAuthentication),
{15738}(MessageNumber : 15738;                        MessageString : sdispTelnetTelnetcode38),
{15739}(MessageNumber : 15739;                        MessageString : sdispTelnetNewEnvironment),
{15740}(MessageNumber : 15740;                        MessageString : sdispTelnetTelnetcode40),
{15741}(MessageNumber : 15741;                        MessageString : sdispTelnetTelnetcode41),
{15742}(MessageNumber : 15742;                        MessageString : sdispTelnetCharacterSet)
  );

implementation
end.
