{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT AreaMgr;

{ De AreaFix, AreaMgr, NewsFix, ... }

{ History

RvdW 20-02-93 Deze unit begonnen ConnectArea en DisConnectArea gemaakt
     26-02-93 ConnectArea public gemaakt voor de Import unit
     02-04-93 MgrAreaData en MgrUserData public aangemaakt ipv lokaal in
              de procedures.
MD   24-06-93 Samenvoegen met de Fido Areafix routines
     21-10-93 Toevoegen van %PASSIVE en %ACTIVE aan de fido routines
     17-02-94 Bug gefixed in %QUERY commando, en een standaard uucp
              adres parsing routine toegevoegt.

Note: Er zit in deze routines een hoop onnodige en dubbele code, als ik een
      keer de geest krijg zal ik er eens een bezem doorhalen.

RvdW ??-??-94 Correctie op het sorteren van de lijst.
     18-02-95 Rewrite en integratie van AreaFix/NewsFix.
              Uitbreiding met sorteren op group.

     19-08-95 Query en List lijsten worden in altijd in het geheugen
              gesorteerd met de geavanceerde methode die ook bij
              Pack Databases gebruikt wordt.
}

INTERFACE

USES Database;

{ de volgende types worden ook door WtrConf gebruikt }

TYPE AreaListType = (lstAREASBBS,lstNAMES);

     AreafixForwardRecord = RECORD
                                  UplinkAddress : FidoAddrType; { System to send requests to }
                                  Unconditional : BOOLEAN;      { Always forward messages?   }
                                  AreaListPath  : STRING[50];   { Path to file with names    }
                                  AreaList      : AreaListType; { AREAS.BBS or normal list?  }
                                  AreaManager   : STRING[10];   { Name of 'Areafix'          }
                                  Password      : STRING[10];   { Password to use for uplink }
                                  Group         : BYTE;         { Group to work              }
                                  AddPlus       : BOOLEAN;      { Add a '+' before the name? }
                            END;

     UUCPForwardRecord  = RECORD
                                UUCPName     : STRING[MaxLenUUCPName]; { UUCP Name of the user                 }
                                AreaListPath : STRING[49];             { to search in this file for area names }
                                Group        : BYTE; { RWI 960211 }
                          END;

PROCEDURE ConnectArea (AreaBaseRecordNr : AreaBaseRecordNrType; UserBaseRecordNr : UserBaseRecordNrType);
PROCEDURE UUCPAreaFix;
PROCEDURE FidoAreaFix;
PROCEDURE ExportAreaFixForwardRequests;
PROCEDURE ExportNewsFixForwardRequests;


IMPLEMENTATION

USES Cfg,
     Msgs,
     Ramon,
     Fido,
     Logs,
     TextFile,
     Usenet,
     Globals,
     AreaBase,
     SwapMem,
     Language,
     MakeOut;

CONST FIDOFWDBUFFER_FILENAME = 'FIDOREQ.LST';

{
TYPE SortedEntryType = RECORD
                             PrevRec,
                             LowerRec,
                             HigherRec : LONGINT;
                             Area      : AreaNameString;
                             ARecNr    : AreaBaseRecordNrType;
                       END;

VAR SortedAreaFile : FILE;
}

    { schrijver van de fix }
VAR UserInfoRecNr  : UserBaseRecordNrType;
    UserInfo       : UserBaseRecord;

    { voor de processor }
    IgnoreCommand,              { onbekende %FROM node }
    RequestedQuery,
    RequestedList,
    RequestedHelp  : BOOLEAN;

    SearchDescr    : STRING[MaxLenComment];

{
VAR AreaFixForwardList,
    NewsFixForwardList : TopRegelRecordPtr;
}

{ structuren voor List en Query lijsten om de lijst te sorteren }
CONST QLXb  = 10;
      QLYb  = 5;
      QLXl  = 60;
      QLYl  = 9;
      QLXb2 = 42;

CONST MapRecordsPerArray = 4096; { veelvoud van twee, optimaliseert DIV en MOD }
      MapArrays          = 65536 DIV MapRecordsPerArray; { max arrays nodig voor alle areabase records }

TYPE NamesBlock    = ARRAY[1..61440] OF CHAR;
     NamesBlockPtr = ^NamesBlock;

     MapRecord    = RECORD
                          RecNr : WORD; { NILRecordNr = Deleted }

                          { GroupCh wordt ingevuld als het geheugen voor   }
                          { de area namen vrijgegeven wordt, zodat bij het }
                          { toevoegen aan het bericht de GroupCh gebruikt  }
                          { kan worden om de area in een bepaalde groep te }
                          { stoppen. Ze worden dus niet tegelijk gebruikt. }
                          CASE Integer OF
                               0 : (NamePtr : ^STRING);
                               1 : (Group   : STRING[2]);
                    END;

     MapRecordPtr = ^MapRecord;

     MapArray     = ARRAY[0..MapRecordsPerArray-1] OF MapRecord;
     MapArrayPtr  = ^MapArray;

     FetchNextRecNrFunc = PROCEDURE (VAR RecNr : WORD; VAR AreaName : STRING);

VAR MapAreaRecCount : WORD;
    PartNameLen     : BYTE;
    AreaDataTable   : ARRAY[0..MapArrays-1] OF MapArrayPtr;
    NameCount       : BYTE;
    NameLengths     : ARRAY[1..10] OF WORD;
    NamePtrs        : ARRAY[1..10] OF NamesBlockPtr;

    QuerySearch     : SubscrSearchRecord;

{--------------------------------------------------------------------------}
{ ConnectArea                                                              }
{                                                                          }
{ Deze routine sluit een area aan bij een user. Deze routine koppelt zowel }
{ de Area bij de UserSubscrList van de UserBase als de User bij de         }
{ AreaSubscrList bij de AreaBase. Het is van groot belang dat beide        }
{ records die mogelijk gewijzigd kunnen worden naar disk geschreven zijn.  }
{ Dat zijn dus de records waarvan de nummers aan deze routine worden mee-  }
{ gegeven. Achteraf moeten deze weer ingelezen worden om up to date te     }
{ zijn.                                                                    }
{                                                                          }
PROCEDURE ConnectArea (AreaBaseRecordNr : AreaBaseRecordNrType; UserBaseRecordNr : UserBaseRecordNrType);

VAR MgrAreaData : AreaBaseRecord;
    MgrUserData : UserBaseRecord;

BEGIN
     IF (AreaBaseRecordNr = NILRecordNr) OR (UserBaseRecordNr = NILRecordNr) THEN
        Exit;

     ReadAreaBaseRecord (AreaBaseRecordNr,MgrAreaData);
     AddUserToAreaSubscrList (MgrAreaData,UserBaseRecordNr);
     WriteAreaBaseRecord (AreaBaseRecordNr,MgrAreaData);

     ReadUserBaseRecord (UserBaseRecordNr,MgrUserData);
     AddAreaToUserSubscrToList (MgrUserData,AreaBaseRecordNr);
     WriteUserBaseRecord (UserBaseRecordNr,MgrUserData);
END;


{--------------------------------------------------------------------------}
{ DisconnectArea                                                           }
{                                                                          }
{ Deze routine koppelt een area voor een user af. Bij de AreaBase wordt    }
{ het User nummer uit de UserSubscrList gehaald en in de UserBase wordt    }
{ het Area nummer uit de AreaSubscrList gehaald. Het is van groot belang   }
{ dat beide records waarvan de record nummers zijn opgegeven, zijn         }
{ geupdate op disk. Na de aanroep van deze routine kunnen ze weer worden   }
{ ingelezen.                                                               }
{                                                                          }
PROCEDURE DisconnectArea (AreaBaseRecordNr : AreaBaseRecordNrType; UserBaseRecordNr : UserBaseRecordNrType);

VAR MgrAreaData : AreaBaseRecord;
    MgrUserData : UserBaseRecord;

BEGIN
     ReadAreaBaseRecord (AreaBaseRecordNr,MgrAreaData);
     RemoveUserFromAreaSubscrList (MgrAreaData,UserBaseRecordNr);
     WriteAreaBaseRecord (AreaBaseRecordNr,MgrAreaData);

     ReadUserBaseRecord (UserBaseRecordNr,MgrUserData);
     RemoveAreaFromUserSubscrToList (MgrUserData,AreaBaseRecordNr);
     WriteUserBaseRecord (UserBaseRecordNr,MgrUserData);
END;


{==========================================================================}
{                        AREAFIX FORWARDING                                }
{                                                                          }
{ Dit stel routines kijkt of we een area bij een ander systeem wel kunnen  }
{ aanvragen als deze lokaal niet beschikbaar is.                           }
{==========================================================================}


{--------------------------------------------------------------------------}
{ ExportAreaFixForwardRequests                                             }
{                                                                          }
{ Deze routine handelt de areafix forward verzoeken af en zet deze om in   }
{ berichten aan uplink systemen.                                           }
{                                                                          }
PROCEDURE ExportAreaFixForwardRequests;

VAR InFile    : TEXT;
    InPath    : FilePathStr;
    OutFile   : TEXT;
    OutPath   : FilePathStr;
    IORes     : BYTE;
    Regel     : STRING;
    FwdStr    : STRING[MaxLenFidoAddrString];
    OurAddr,
    FwdAddr   : FidoAddrType;
    Lp        : BYTE;
    AdminBody : TopRegelRecordPtr;
    P         : BYTE;
    AddedSome : BOOLEAN;
    First     : BOOLEAN;

LABEL Einde;

BEGIN
     { we kunnen maar e'e'n netmailtje tegelijk schrijven, dus we moeten }
     { een paar keer door de file heen. We schrijven alles wat we niet   }
     { verwerken naar een tijdelijke file.                               }

     InPath:=Config.SystemDir+FIDOFWDBUFFER_FILENAME;
     OutPath:=Config.SystemDir+'FIDOREQ.$$$';
     AdminBody:=NIL;

     REPEAT
           Assign (InFile,InPath);
           {$I-} Reset (InFile); {$I+} IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                IF (IORes <> 2{file not found is normaal}) THEN
                   LogDiskIOError (IORes,'Cannot open '+InPath);
                Exit;
           END;

           PeekFiles;

           { lees een regel uit de InFile }
           ReadLn (InFile,Regel);

           IF (Regel = '') OR (Pos (' ',Regel) = 0) THEN
           BEGIN
                LogMessage (InPath+' is corrupt');
                AddToLineBuffer (AdminBody,'');
                AddToLineBuffer (AdminBody,InPath+' is corrupt, PLEASE CHECK!!');
                AddToLineBuffer (AdminBody,'');
                Close (InFile);
                GOTO Einde;
           END;

           Assign (OutFile,OutPath);
           {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'Cannot create temporary file '+OutPath);
                Close (InFile);
                Exit;
           END;

           AddedSome:=FALSE;

           { zoek het forward systeem voor deze regel. Alle andere regels }
           { voor ditzelfde systeem worden nu behandeld.                  }

           FwdStr:=Copy (Regel,1,Pos (' ',Regel)-1);
           FidoSplit (FwdStr,FwdAddr);

           FOR Lp:=1 TO MaxAreaFixFwd DO
               WITH Config.AreaFixForward[Lp] DO
                    IF FidoCompare (FwdAddr,UplinkAddress) THEN
                    BEGIN
                         { gevonden }
                         FidoMatch (UplinkAddress,OurAddr);

{$IFNDEF SuppressFeatureRequests}
## group AKA gebruiken uit groep in areafix forward definitie record
## (Config.AreaFixForward[Lp].Group -> Config.NodeNrs[GroupRec.GroupAka];
## needs change in fidoreq.lst file.
{$ENDIF}

                         FidoBuildNetmail (TRUE,            { empty }
                                           OurAddr,         { from aka }
                                           UplinkAddress,   { to aka }
                                           Config.Sysop,    { from }
                                           AreaManager,     { to }
                                           Password);       { subj }

                         Delete (Regel,1,Pos (' ',Regel));
                         MsgsAddLineTo (Body,Regel);

                         IF First THEN
                         BEGIN
                              First:=FALSE;
                              AddToLineBuffer (AdminBody,'AreaFix Forward Request Report to Administrator');
                              AddToLineBuffer (AdminBody,'Processed at '+FidoCurrTime2Str);
                         END;

                         AddToLineBuffer (AdminBody,'');
                         AddToLineBuffer (AdminBody,'Sent AreaFix message to "'+AreaManager+'" at '+FwdStr);
                         AddToLineBuffer (AdminBody,'---[begin]'+RepChar (50,'-'));
                         AddToLineBuffer (AdminBody,Regel);

                         WHILE (NOT Eof (InFile)) DO
                         BEGIN
                              ReadLn (InFile,Regel);

                              P:=Pos (' ',Regel);

                              IF (P <> 0) AND (Copy (Regel,1,P-1) = FwdStr) THEN
                              BEGIN
                                   Delete (Regel,1,P);
                                   MsgsAddLineTo (Body,Regel);
                                   AddToLineBuffer (AdminBody,Regel);
                              END ELSE
                              BEGIN
                                   WriteLn (OutFile,Regel);
                                   AddedSome:=TRUE;
                              END;

                         END; { while }

                         AddToLineBuffer (AdminBody,'---[end]--'+RepChar (50,'-'));

                         Break; { uit de for }
                    END;

           IF (NOT Eof (InFile)) THEN
              LogMessage (FwdStr+' is not a AreaFix forward system');

           Close (OutFile);
           Close (InFile);
           Erase (InFile);

           IF AddedSome THEN
              Rename (OutFile,InPath)
           ELSE
               Erase (OutFile);

           IF (Msg.BodyTop <> NIL) THEN
              MsgsExport;

     UNTIL (NOT AddedSome);

Einde:

     { send a message to the administrator }
     IF (AdminBody <> NIL) THEN
     BEGIN
          FidoBuildNetmail (TRUE,
                            Config.NodeNrs[1],
                            Config.NodeNrs[1],
                            Config.AreaFixName,
                            Config.SysOp,
                            'CC: of forward request(s)');

          { lege regel aan het einde }
          AddToLineBuffer (AdminBody,'');

          Msg.BodyTop:=AdminBody;

          MsgsExport;
     END;

     MsgsEmpty;

     { not implemented yet }
(*
VAR ForwardTeller : 1..MaxAreafixFwd;
    OurAka        : FidoAddrType;
    SearchRegel,
    EenRegel      : EenRegelRecordPtr;
    Adres         : FidoAddrString;
    Regel         : STRING;
    FoundMatch    : Boolean;
    RecNr         : UserBaseRecordNrType;
    Lp,
    Code,System   : Integer;
    Fido_Dest     : FidoAddrType;

BEGIN
     { Kijk of er wel forward requests zijn }
     IF (AreaFixForwardList = NIL) THEN
        Exit;

     { Zorg voor een lege structuur }
     MsgsEmpty;

     { Loop alle nodes af, en kijk of er requests voor ze klaar staan. }

     { De verzoeken worden gegroepeerd op forward node. Bij de eerste  }
     { nog niet verwerkte regel (geen * aan het begin) wordt het adres }
     { van de regel gepakt en daarna alle andere regels doorlopen. Als }
     { in een van die andere regels hetzelfde adres staat, dan wordt   }
     { die regel ook met een * gemarkeerd en die regel in het bericht  }
     { gezet.                                                          }
     EenRegel:=AreaFixForwardList^.FirstRegelRecordPtr;
     WHILE (EenRegel <> NIL) DO
     BEGIN
          { Ga op zoek naar een nog niet gebruikt adres }
          IF (EenRegel^.RegelPtr^[1] = '*') THEN
          BEGIN
               EenRegel:=EenRegel^.NextRegelRecordPtr;
               Continue;
          END;

          EenRegel^.RegelPtr^[1]:='*';
          SearchRegel:=EenRegel^.NextRegelRecordPtr;
          Regel:=EenRegel^.RegelPtr^;
          Adres:=Copy (Regel,2,Pos (' ',Regel)-1);

          MsgsAddLineTo (Body,Copy (Regel,Pos (' ',Regel)+1,255));

          WHILE (SearchRegel <> NIL) DO
          BEGIN
               IF (Copy (SearchRegel^.RegelPtr^,2,Pos (' ',Regel)-1) = Adres) THEN
               BEGIN
                    SearchRegel^.RegelPtr^[1]:='*';
                    MsgsAddLineTo (Body,Copy (SearchRegel^.RegelPtr^,Pos (' ',Regel)+1,255));
               END;

               SearchRegel:=SearchRegel^.NextRegelRecordPtr;
          END; { while }

          { Stuur een bericht met wijzigingen naar het betreffende systeem }
          { Dit bericht bevat zowel toevoegingen als afsluitingen.         }

          IF (Msg.BodyTop <> NIL) THEN
          BEGIN
               { Zorg voor een matchend AKA }

               { Kijk of het adres waar we het bericht heen sturen een    }
               { bekende Forward systeem is, zoja gebruik alle informatie }
               { die we hebben zoniet, haal de informatie dan uit het     }
               { userbase record met wat default informatie.              }
               FoundMatch:=FALSE;
               FidoSplit (Adres,Fido_Dest);

               FOR Lp:=1 TO MaxAreafixFwd DO
                   WITH Config.AreafixForward[ForwardTeller] DO
                        IF FidoCompare (Fido_Dest,UplinkAddress) THEN
                        BEGIN
                             FidoMatch (UplinkAddress,OurAka);
                             FidoBuildNetmail (FALSE,OurAka,Config.AreafixForward[Lp].UplinkAddress,Config.Sysop,
                                               Config.AreaFixForward[Lp].AreaManager,Config.AreaFixForward[Lp].Password);

                             Msg.Attr_F:=Msg.Attr_F OR MSGKILL;
                             FoundMatch:=TRUE;
                        END;

               IF (NOT FoundMatch) THEN
               BEGIN
                    FindUserBaseRecordByFidoAddress (Fido_Dest,RecNr);
                    { Dit record MOET in de userbase zitten, anders had het }
                    { verzoek nooit gemaakt kunnen worden.                  }
                    ReadUserBaseRecord (RecNr,UserData);
                    FidoMatch (UserData.Address,OurAka);
                    FidoBuildNetmail (FALSE,OurAka,Fido_Dest,Config.Sysop,Config.AreafixName,UserData.AreafixPwd);
                    Msg.Attr_F:=Msg.Attr_F OR MSGKILL;
               END;

               Msg.Date_F:=FidoCurrTime2Str;
               MsgsExport;
          END;

          MsgsEmpty;

     END; { while }

     { Stuur een netmailtje met alles wat we gedaan hebben aan de sysop }
     { zodat die ook een overzicht heeft van wat er allemaal gebeurd.   }
     EenRegel:=AreaFixForwardList^.FirstRegelRecordPtr;
     FidoBuildNetmail (FALSE,Config.NodeNrs[1],Config.NodeNrs[1],
                       DesktopProgramName,Config.Sysop,'Areafix status report' );
     Msg.Attr_F:=Msg.Attr_F OR MSGKILL;
     Msg.Date_F:=FidoCurrTime2Str;

     WHILE (EenRegel <> NIL) DO
     BEGIN
          Regel:=Copy (EenRegel^.RegelPtr^,Pos (' ',EenRegel^.RegelPtr^)+1,255);

          IF (Regel[1] = '-') THEN
          BEGIN
               Delete (Regel,1,1);
               MsgsAddLineTo (Body,'Disconnected passthough area '+Regel+' from '+
                                   Copy (EenRegel^.RegelPtr^,2,Pos (' ',EenRegel^.RegelPtr^)-1));
          END ELSE
              MsgsAddLineTo (Body,'Forwared request for '+Regel+' to '+
                                  Copy (EenRegel^.RegelPtr^,2,Pos (' ',EenRegel^.RegelPtr^)-1));

          EenRegel:=EenRegel^.NextRegelRecordPtr;
     END; { while }

     MsgsExport;
*)
END;


{---------------------------------------------------------------------------}
{ ExportNewsFixForwardRequests                                              }
{                                                                           }
{ Deze routine handelt de forward requests die voor uucp uplinks nog        }
{ staan te wachten om afgehandeld te worden.                                }
{                                                                           }
PROCEDURE ExportNewsFixForwardRequests;
BEGIN
     { nog niet geimplementeerd }
END;


{---------------------------------------------------------------------------}
{ FidoUplinkRequest                                                         }
{                                                                           }
{ Deze routine verzoekt om een area bij een uplink. Deze verzoeken worden   }
{ in een file opgeslagen (zodat het bij een crash ook goed gaat) en later   }
{ verwerkt.                                                                 }
{ Action bepaald +, niets of -.                                             }
{                                                                           }
PROCEDURE FidoUplinkRequest (UplinkAddr : FidoAddrType; AreaName : AreaNameString; Action : STRING);

VAR AFile : TEXT;
    IORes : BYTE;

BEGIN
     Assign (AFile,Config.SystemDir+FIDOFWDBUFFER_FILENAME);
     {$I-} Append (AFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (AFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Cannot store AreaFix forward request in '+FIDOFWDBUFFER_FILENAME);
          Exit;
     END;

     WriteLn (AFile,Fido2Str (UplinkAddr)+' '+Action+AreaName);
     Close (AFile);

     IF Config.LogAreaFix THEN
        LogMessage ('Forward to '+Fido2Str (UplinkAddr)+': '+Action+AreaName);
END;


{---------------------------------------------------------------------------}
{ UUCPUplinkRequest                                                         }
{                                                                           }
{ Deze routine verzoekt om een area bij een uplink. Deze verzoeken worden   }
{ in een file opgeslagen (zodat het bij een crash ook goed gaat) en later   }
{ verwerkt.                                                                 }
{ Action bepaald +, niets of -.                                             }
{                                                                           }
PROCEDURE UUCPUplinkRequest (UplinkUUCPName : STRING; AreaName : AreaNameString; Action : STRING);

VAR AFile : TEXT;
    IORes : BYTE;

BEGIN
     Assign (AFile,Config.SystemDir+'UUCPREQ.LST');
     {$I-} Append (AFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (AFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Cannot store NewsFix forward request in UUCPREQ.LST');
          Exit;
     END;

     WriteLn (AFile,UplinkUUCPName+','+Action+AreaName);
     Close (AFile);

     IF Config.LogAreaFix THEN
        LogMessage ('Forward to '+UplinkUUCPName+': '+Action+AreaName);
END;


{--------------------------------------------------------------------------}
{ SearchAreasBBS                                                           }
{                                                                          }
{ Doorzoek een file met het AREAS.BBS formaat door om te kijken of de      }
{ genoemde area naam erin voorkomt en we het verzoek ervoor dus mogen      }
{ forwarden. Het formaat is als volgt:                                     }
{                                                                          }
{ origin!sysop                                                             }
{ ; comment                                                                }
{ P     ARENA 2:280/802  passthrough        <-- alleen deze worden bekeken }
{ %path ARENA 2:280/802  squish msgbase                                    }
{ !path ARENA 2:280/802  jam msgbase                                       }
{ 150   ARENA 2:280/802  hudson base                                       }
{                                                                          }
FUNCTION SearchAreasBBS (FileName,AreaName : STRING) : BOOLEAN;

VAR AreasFile : TEXT;
    IORes     : BYTE;
    Regel     : STRING;

BEGIN
     SearchAreasBBS:=FALSE; { assume not found }

     Assign (AreasFile,Filename);
     {$I-} Reset (AreasFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SearchAreasBBS] Cannot open areas file '+Filename);
          Exit;
     END;

     { Skip de eerste regel van een AREAS.BBS file }
     ReadLn (AreasFile,Regel);

     WHILE (NOT Eof (AreasFile)) DO
     BEGIN
          ReadLn (AreasFile,Regel);

          { alleen regels met passthrough interpreteren }
          IF (Regel = '') OR (UpCase (Regel[1]) <> 'P') THEN
             Continue;

          { Strip het eerste gedeelte }
          Delete (Regel,1,Pos (' ',Regel));
          Regel:=DeleteFrontSpaces (Regel)+' ';

          { Strip het achterste gedeelte }
          Delete (Regel,Pos (' ',Regel),255);

          IF (UpCaseString (Regel) = AreaName) THEN
          BEGIN
               SearchAreasBBS:=TRUE;
               Break;
          END;
     END; { while }

     Close (AreasFile);
END;


{--------------------------------------------------------------------------}
{ SearchNamesList                                                          }
{                                                                          }
{ Doorzoek een file met het volgende formaat:                              }
{                                                                          }
{ ; comment                                                                }
{ AREANAME  Beschrijving                                                   }
{                                                                          }
{ Als in die file de opgegeven areanaam voorkomt, dan gegeven we TRUE      }
{ terug en mag het verzoek voor deze area resulteren in een forward        }
{ verzoek aan een uplink.                                                  }
{                                                                          }
FUNCTION SearchNamesList (FileName,AreaName : STRING) : BOOLEAN;

VAR AreasFile : TEXT;
    IORes     : BYTE;
    Comment,
    Regel     : STRING;

BEGIN
     SearchNamesList:=FALSE; { assume not found }

     Assign (AreasFile,Filename);
     {$I-} Reset (AreasFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SearchNamesList] Cannot open file '+Filename);
          Exit;
     END;

     WHILE (NOT Eof (AreasFile)) DO
     BEGIN
          ReadLn (AreasFile,Regel);

          IF (Regel = '') OR (Regel[1] = ';') THEN
             Continue;

          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          IF (Pos (' ',Regel) > 0) THEN
          BEGIN
               Comment:=Copy (Regel,Pos (' ',Regel),255);
               Comment:=DeleteFrontSpaces (Regel);
               Regel:=Copy (Regel,1,Pos (' ',Regel)-1);
          END ELSE
              Comment:='';

          IF (UpCaseString (Regel) = AreaName) THEN
          BEGIN
               IF (Comment <> '') THEN
                  SearchDescr:=Comment;

               SearchNamesList:=TRUE;
               Break;
          END;
     END; { while }

     Close (AreasFile);
END;


{--------------------------------------------------------------------------}
{ AreafixCheckForward                                                      }
{                                                                          }
{ Loop door de geconfigureerde lijsten, op zoek naar een matching areanaam }
{                                                                          }
{ Return : 0 = no match                                                    }
{          1 = Fido match                                                  }
{          2 = UUCP match                                                  }
{                                                                          }
FUNCTION AreafixCheckForward (AreaName : STRING) : INTEGER;

VAR ForwardTeller : 1..MaxAreafixFwd;
    RecNr         : UserBaseRecordNrType;
    Dummy         : FidoAddrType;
    Regel         : STRING;
    Res           : BOOLEAN;
    Found         : BOOLEAN;
    UUCPFile,
    UUCPAreaFile  : TEXT;
    IORes         : BYTE;
    Asteriks      : BYTE;
    AddStr        : STRING[1];
    P             : BYTE;
    Comment       : STRING[MaxLenComment];

BEGIN
     AreafixCheckForward:=0; { niet gevonden }

     Found:=FALSE;

     FOR ForwardTeller:=1 TO MaxAreafixFwd DO
         WITH Config.AreaFixForward[ForwardTeller] DO
         BEGIN
              { controleer of de user toegang heeft tot de groep }
              IF (NOT TestIfInGroup (UserInfo.Groups,Group)) THEN
                 Continue;

              { controleer of er uberhaupt wel een adres is }
              IF (UplinkAddress.Zone = 0) AND (UplinkAddress.Net = 0) THEN
                 Continue;

              { controleer of de geconfigureerde NODE wel bestaat }
              IF (NOT FindUserBaseRecordByFidoAddress (UplinkAddress,RecNr)) THEN
              BEGIN
                   LogMessage (Config.AreaFixName+' forward system '+Fido2Str (UplinkAddress)+
                               ' is not defined in the Userbase!');
                   Continue;
              END;

              { kijk of dit een unconditional forward is }
              IF (NOT Unconditional) THEN
              BEGIN
                   { Kijk of er wel een path gedefinieerd is }
                   IF (AreaListPath = '') THEN
                   BEGIN
                        LogMessage ('No arealist defined for conditional areafix forward system '+
                                    Fido2Str (UplinkAddress));
                        Continue;
                   END;

                   SearchDescr:='Requested from '+Fido2Str (UplinkAddress);

                   IF (AreaList = lstAREASBBS) THEN
                      Res:=SearchAreasBBS (AreaListPath,AreaName);

                   IF (AreaList = lstNAMES) THEN
                      Res:=SearchNamesList (AreaListPath,AreaName);

                   IF NOT Res THEN
                      Continue;
              END; { not unconditional }

              { voeg het verzoek om een area toe aan de lijst }
              IF (Config.AreaFixForward[ForwardTeller].AddPlus) THEN
                 AddStr:='+'
              ELSE
                  AddStr:='';

              FidoUplinkRequest (UplinkAddress,AreaName,AddStr);

              AreaFixCheckForward:=1; { fido match }

              { creer een area en sluit de uplink en downlink aan }
              EmptyAreaDataRecord;

              AreaData.AreaName_F:=AreaName;
              AreaData.AreaName_U:=AreaName;
              ResetGroupFlags (AreaData.IsInGroups);
              AddGroupToGroupList (AreaData.IsInGroups,Group);
              AreaData.Comment:=SearchDescr;
              LogMessage ('Requested '+AreaName+' from '+Fido2Str (UplinkAddress));

              { probeer het adres aan te passen aan de zender }
              AreaData.OriginAKA:=FidoMatchAdres (UplinkAddress,Dummy);

              SetSingleSeenByBit (AreaData.AddSeenByAkas,AreaData.OriginAKA);

              AddIndexValueToAreaBaseIndexTable (GetAreaNameIndexValue (AreaName));
              WriteNewAreaBaseRecord (AreaData);

              { sluit de leverancier aan op de area }
              ConnectArea (AreaBaseRecCount,RecNr);

              { sluit de klant aan op de area }
              ConnectArea (AreaBaseRecCount,UserInfoRecNr);

              Found:=TRUE;
              Break; { Spring uit for }
         END; { with, for }

     { als ie nu nog niet gevonden is, dan kan ie nog in een van de uucp }
     { lijsten voorkomen.                                                }
     IF (NOT Found) THEN
        FOR ForwardTeller:=1 TO MaxAreafixFwd DO
            WITH Config.UUCPForward[ForwardTeller] DO
                 IF (UUCPName <> '') AND (AreaListPath <> '') THEN
                 BEGIN
                      { controleer of de user toegang heeft tot de groep }
                      IF (NOT TestIfInGroup (UserInfo.Groups,Group)) THEN
                         Continue;

                      { controleer of de geconfigureerde NODE wel bestaat }
                      IF (NOT FindUserBaseRecordByUUCPName (UUCPName,RecNr)) THEN
                      BEGIN
                           LogMessage (Config.AreafixName+' forward system '+UUCPName+' is not defined in the Userbase!');
                           Continue;
                      END;

                      Assign (UUCPFile,AreaListPath);
                      {$I-} Reset (UUCPFile); {$I+} IORes:=IOResult;
                      IF (IORes <> 0) THEN
                      BEGIN
                           LogDiskIOError (IORes,'[AreaFixCheckForward] Cannot open UUCP areas file '+AreaListPath);
                           Continue;
                      END;

                      WHILE (NOT Eof (UUCPFile)) DO
                      BEGIN
                           ReadLn (UUCPFile,Regel);

                           { omdat we verderop een spatie zoeken, }
                           { zetten we de eerste eventuele tab om }
                           { in een spatie.                       }
                           IF (Pos (#9,Regel) > 0) THEN
                              Regel[Pos (#9,Regel)]:=' ';

                           { breek af op eerste spatie, zodat we     }
                           { "name description moderated" aankunnen. }
                           IF (Pos (' ',Regel) > 0) THEN
                           BEGIN
                                Comment:=Copy (Regel,Pos (' ',Regel),255);
                                Regel:=Copy (Regel,1,Pos (' ',Regel)-1);
                           END ELSE
                               Comment:='';

                           Regel:=UpCaseString (Regel);

                           Asteriks:=Pos ('*',Regel);

                           { vergelijk naam uit file met areaname }
                           IF (Asteriks = 0) THEN
                           BEGIN
                                IF (Regel <> AreaName) THEN
                                   Continue;
                           END ELSE
                               IF (Copy (Regel,1,Asteriks-1) <> Copy (AreaName,1,Asteriks-1)) THEN
                                  Continue;

                           { gevonden! }

                           UUCPUplinkRequest (UUCPName,AreaName,'+');

                           (* un in aparte routine
                           { Schrijf een entry naar \System\UUCPREQ.LST }
                           Assign (UUCPAreaFile,Config.SystemDir+'UUCPREQ.LST');
                           {$I-} Append (UUCPAreaFile); {$I+} IORes:=IOResult;
                           IF (IORes = 2{file not found}) THEN
                           BEGIN
                                {$I-} ReWrite (UUCPAreaFile); {$I+} IORes:=IOResult;
                           END;

                           IF (IORes <> 0) THEN
                           BEGIN
                                LogDiskIOError (IORes,'Error writing to '+Config.SystemDir+'UUCPREQ.LST');
                                Continue;  { too bad after all }
                           END;

                           WriteLn (UUCPAreaFile,UUCPName,',',AreaName);
                           Close (UUCPAreaFile);
                           *)

                           LogMessage ('Requested '+AreaName+' from '+UUCPName);

                           AreaFixCheckForward:=2; { uucp }

                           { creer een area, en sluit de uplink en downlink aan }
                           EmptyAreaDataRecord;

                           AreaData.AreaName_F:=AreaName;
                           AreaData.AreaName_U:=AreaName;
                           ResetGroupFlags (AreaData.IsInGroups);
                           AddGroupToGroupList (AreaData.IsInGroups,Group);
                           IF (Comment <> '') THEN
                           BEGIN
                                WHILE (Pos (#9,Comment) > 0) DO
                                      Comment[Pos (#9,Comment)]:=' ';

                                Comment:=DeleteFrontSpaces (Comment);

                                P:=Pos ('/MOD',UpCaseString (Comment));
                                IF (P > 0) THEN
                                   Comment:=Copy (Comment,1,P-1);

                                P:=Pos ('/MEXP',UpCaseString (Comment));
                                IF (P > 0) THEN
                                   Comment:=Copy (Comment,1,P-1);

                                AreaData.Comment:=DeleteBackSpaces (Comment);
                           END ELSE
                               AreaData.Comment:='Requested from '+UUCPName;

                           { probeer het adres aan te passen aan de zender }
                           AreaData.OriginAKA:=Config.GatewayAKA;

                           SetSingleSeenByBit (AreaData.AddSeenByAkas,AreaData.OriginAKA);

                           AddIndexValueToAreaBaseIndexTable (GetAreaNameIndexValue (AreaName));
                           WriteNewAreaBaseRecord (AreaData);

                           { sluit de leverancier aan op de area }
                           ConnectArea (AreaBaseRecCount,RecNr);

                           { sluit de klant aan op de area }
                           ConnectArea (AreaBaseRecCount,UserInfoRecNr);

                           Break; { uit de while }
                      END;

                      Close (UUCPFile);
                      Break; { uit de for }
                 END; { if, with, for, if }
END;


{---------------------------------------------------------------------------}
{ CheckIfAreaCanGoPassive                                                   }
{                                                                           }
{ Deze routine controleert of een area die zojuist door iemand afgesloten   }
{ is nu in passieve mode gezet kan worden. AreaInfo moet de data van het    }
{ record bevatten en AreaInfoRecNr het record nummer.                       }
{                                                                           }
PROCEDURE CheckIfAreaCanGoPassive (VAR AreaInfo : AreaBaseRecord; AreaInfoRecNr : AreaBaseRecordNrType);

VAR DeletePassT : SubscrSearchRecord;
    TempUser    : UserBaseRecord;

BEGIN
     { Nu kijken of die A) een passthrough area is, en B) of er nog }
     { maar een persoon op aangesloten is.                          }
     IF {(AreaInfo.FidoMsgStyle = NoneType) AND }(AreaInfo.AllowPassive) THEN {Passthough}
     BEGIN
          GetFirstUserSubscribedToThisArea (AreaInfo.UserList,DeletePassT);

          IF DeletePassT.Found THEN { Er is tenminste 1 persoon aangesloten }
          BEGIN
               GetNextUserSubscribedToThisArea (DeletePassT);

               IF (NOT DeletePassT.Found{Maar gelukkig niet meer}) THEN
               BEGIN
                    { Lees het record in van die enige aangesloten }
                    { gebruiker. Hierbij maken we gebruik van het  }
                    { feit dat een NextUser actie alleen de flag   }
                    { Found of False zet, en de rest van de data   }
                    { intact blijft.                               }
                    ReadUserBaseRecord (DeletePassT.UserBaseRecordNr,TempUser);

                    IF (TempUser.System = _F) THEN
                       FidoUplinkRequest (TempUser.Address,AreaInfo.AreaName_F,'-');

                    IF (TempUser.System = _U) THEN
                       UUCPUplinkRequest (TempUser.UUCPName,AreaInfo.AreaName_U,'-');

                    (*
                    IF (TempUser.System = _F) THEN
                       AddToLineBuffer (AreaFixForwardList,' '+Fido2Str (TempUser.Address)+' -'+AreaInfo.AreaName_F)
                    ELSE
{RWI941106: Toegevoegd} IF (TempUser.System = _U) THEN
                           AddToLineBuffer (NewsFixForwardList,' '+TempUser.UUCPName+' -'+AreaInfo.AreaName_U);
                    *)

                    { Zet de passive vlag van de area, op die manier   }
                    { hoeft niet het hele record weggegooid te worden. }
                    { Als iemand de area weer aansluit dan kunnen we   }
                    { gewoon een berichtje aan de uplink sturen.       }
                    AreaInfo.Passive:=TRUE;
                    WriteAreaBaseRecord (AreaInfoRecNr,AreaInfo);
               END; { Search.Found not }
          END; { Search.Found }
     END; { passthough }
END;


{---------------------------------------------------------------------------}
{ CheckIfAreaHasToGoNonePassive                                             }
{                                                                           }
{ Deze routine controleert of de area waar iemand zich zometeen op aan gaat }
{ sluiten uit de passieve mode gehaald moet worden. Zoja, dan wordt het     }
{ verzoek klaargezet in een van de forward lists.                           }
{                                                                           }
PROCEDURE CheckIfAreaHasToGoNonePassive (VAR AreaInfo : AreaBaseRecord; AreaInfoRecNr : AreaBaseRecordNrType);

VAR DeletePassT : SubscrSearchRecord;
    TempUser    : UserBaseRecord;

BEGIN
     { Als de area PASSIVE was, moeten we gaan kijken was wie er ook }
     { al aangesloten was. Die moet dan een bericht krijgen dat de   }
     { area weer aangesloten is. (De uplink dus meestal) (hopen we)  }
     IF AreaInfo.Passive THEN
     BEGIN
          { area is nu passive en moet dus non-passive gemaakt worden }
          GetFirstUserSubscribedToThisArea (AreaInfo.UserList,DeletePassT);

          IF (DeletePassT.Found) THEN { Er is tenminste 1 persoon aangesloten }
          BEGIN
               GetNextUserSubscribedToThisArea (DeletePassT);

               IF (NOT DeletePassT.Found{Maar gelukkig niet meer}) THEN
               BEGIN
                    { Lees het record in van die enige aangesloten gebruiker }
                    { Hierbij maken we gebruik van het feit dat een NextUser }
                    { actie alleen de flag Found of False zet, en de rest    }
                    { van de data intact blijft.                             }
                    ReadUserBaseRecord (DeletePassT.UserBaseRecordNr,TempUser);

                    IF (TempUser.System = _F) THEN
                       FidoUplinkRequest (TempUser.Address,AreaInfo.AreaName_F,'+');

                    IF (TempUser.System = _U) THEN
                       UUCPUplinkRequest (TempUser.UUCPName,AreaInfo.AreaName_U,'+');

                    (*
                    IF (TempUser.System = _F) THEN
                       AddToLineBuffer (AreaFixForwardList,' '+Fido2Str (TempUser.Address)+' '+AreaInfo.AreaName_F)
                    ELSE
                        IF (TempUser.System = _U) THEN
                           AddToLineBuffer (NewsFixForwardList,' '+TempUser.UUCPName+' '+AreaInfo.AreaName_U);
                    *)

                    AreaInfo.Passive:=FALSE;
                    WriteAreaBaseRecord (AreaInfoRecNr,AreaInfo);
               END ELSE
                   LogMessage ('SERIOUS: Passive area has more than one subscribed user! Cannot forward request!!');

          END; { search.found 1e }
     END; { passthrough type }
END;


{--------------------------------------------------------------------------}
{ CommandAddAll                                                            }
{                                                                          }
{ %+ALL gevonden in het Areafix bericht, en toegestaan door de config      }
{ De huidige gebruiker wordt aangesloten op ALLE gebieden.                 }
{ Er wordt geen lijst gegeven van alle areas die aangesloten worden,       }
{ dit om laden alle area records te voorkomen.                             }
{                                                                          }
PROCEDURE CommandAddAll;

VAR AreaCount,
    AreaLp    : BaseRecordNrType;
    AreaInfo  : AreaBaseRecord;

BEGIN
     AreaCount:=AreaBaseRecCount;

     { het eigenlijke toevoegen }
     FOR AreaLp:=1 TO AreaCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaInfo);

          IF (NOT AreaInfo.Deleted) AND TestIfGroupCommon (AreaInfo.IsInGroups,UserInfo.Groups) THEN
          BEGIN
               CheckIfAreaHasToGoNonePassive (AreaInfo,AreaLp);

               AddAreaToUserSubscrToList (UserInfo,AreaLp);
               WriteUserBaseRecord (UserInfoRecNr,UserInfo);

               AddUserToAreaSubscrList (AreaInfo,UserInfoRecNr);
               WriteAreaBaseRecord (AreaLp,AreaInfo);

               IF (UserInfo.System = _U) THEN
                  AddToLineBuffer (LineBuffer,'  '+GetLang1 (2000,AreaInfo.AreaName_U))
               ELSE
                   AddToLineBuffer (LineBuffer,'  '+GetLang1 (2000,AreaInfo.AreaName_F));
          END;
     END; { for }
END;


{--------------------------------------------------------------------------}
{ CommandDelAll                                                            }
{                                                                          }
{ %-ALL gevonden in het Areafix bericht, en toegestaan door de config      }
{ De huidige gebruiker wordt afgesloten van ALLE gebieden.                 }
{ Er wordt geen lijst gegeven van alle areas die aangesloten worden,       }
{ dit om laden alle area records te voorkomen.                             }
{                                                                          }
{ RWI 960121: re-write. Loop nu de lijst van aangesloten areas voor deze   }
{             user af, in plaats van alle areas en dan kijken of de user   }
{             aangesloten is.                                              }
{                                                                          }
PROCEDURE CommandDelAll;

VAR Search   : SubscrSearchRecord;
    AreaInfo : AreaBaseRecord;

BEGIN
     GetFirstAreaUserIsSubscribedTo (UserInfo.AreaList,Search);

     WHILE (Search.Found) DO
     BEGIN
          RemoveAreaFromUserSubscrToList (UserInfo,Search.AreaBaseRecordNr);

          ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaInfo);
          RemoveUserFromAreaSubscrList (AreaInfo,UserInfoRecNr);
          WriteAreaBaseRecord (Search.AreaBaseRecordNr,AreaInfo);

          CheckIfAreaCanGoPassive (AreaInfo,Search.AreaBaseRecordNr);

          IF (UserInfo.System = _U) THEN
             AddToLineBuffer (LineBuffer,'  '+GetLang1 (2001,AreaInfo.AreaName_U))
          ELSE
              AddToLineBuffer (LineBuffer,'  '+GetLang1 (2001,AreaInfo.AreaName_F));

          GetNextAreaUserIsSubscribedTo (Search);
     END;

     WriteUserBaseRecord (UserInfoRecNr,UserInfo);

(* oud... wordt nu vanaf user perspectief afgesloten
VAR AreaCount,
    AreaLp    : BaseRecordNrType;
    AreaInfo  : AreaBaseRecord;

BEGIN
     AreaCount:=AreaBaseRecCount;

     { Het eigenlijke verwijderen }
     FOR AreaLp:=1 TO AreaCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaInfo);

          IF (NOT AreaInfo.Deleted) AND ((AreaInfo.IsInGroups AND UserInfo.Groups) > 0) THEN
          BEGIN
               RemoveAreaFromUserSubscrToList (UserInfo,AreaLp);
               WriteUserBaseRecord (UserInfoRecNr,UserInfo);

               RemoveUserFromAreaSubscrList (AreaInfo,UserInfoRecNr);
               WriteAreaBaseRecord (AreaLp,AreaInfo);

               IF (UserInfo.System = _U) THEN
                  AddToLineBuffer (LineBuffer,'  '+GetLang1 (2001,AreaInfo.AreaName_U))
               ELSE
                   AddToLineBuffer (LineBuffer,'  '+GetLang1 (2001,AreaInfo.AreaName_F));
          END;
     END;
*)
END;


{---------------------------------------------------------------------------}
{ InitQLWindow                                                              }
{                                                                           }
{ Deze routine tekents het window waarin de vooruitgang van de %QUERY en    }
{ %LIST opbouw routines getoond wordt.                                      }
{                                                                           }
PROCEDURE InitQLWindow (Title : STRING);
BEGIN
     PushKeysLine;
     WriteKeysLine (' Please wait...');

     WindowPush (QLXb,QLYb,QLXl,QLYl);
     BoxDraw (Double,QLXb,QLYb,QLXl,QLYl);

     WriteXY (QLXb+2,QLYb+1,Title);

     WriteXY (QLXb+2,QLYb+3,'[ ] Add header .txt file');
     WriteXY (QLXb+2,QLYb+4,'[ ] Build list of area names');
     WriteXY (QLXb+2,QLYb+5,'[ ] Sort the list');
     WriteXY (QLXb+2,QLYb+6,'[ ] Add listing to message');
     WriteXY (QLXb+2,QLYb+7,'[ ] Add footer .txt file');

     IF (Video.Color) THEN
        ModifyColor (cCustom1,cBlue*16+cWhite+cBlink)
     ELSE
         ModifyColor (cCustom1,mBlack*16+mWhite+mBlink);
END;


{---------------------------------------------------------------------------}
{ InitAreaDataTable                                                         }
{                                                                           }
{ Deze routine vraagt het geheugen aan voor de mapping table waarmee de     }
{ area records straks gesorteerd kunnen worden. Ze bestaan uit het record   }
{ nummer en een pointer naar de naam of een gedeelte daarvan. De geheugen-  }
{ blokken voor de namen worden apart aangevraagd.                           }
{                                                                           }
PROCEDURE InitAreaDataTable (RecCount : WORD; FirstRecNr : WORD; FetchNextRecNr : FetchNextRecNrFunc);

VAR BigBlocks : BYTE;
    LeftOver  : WORD;
    Lp        : WORD;
    AreaName  : STRING;
    MaxHelp   : LONGINT;
    ToCopy    : WORD;
    MaxCopy   : WORD;  { maximum aantal tekens van de AreaRec.AreaName }
                       { die gekopieerd kunnen worden. Wordt continue  }
                       { bijgesteld.                                   }
    StorePos  : WORD;
    PercDone  : BYTE;

BEGIN
     MapAreaRecCount:=RecCount;

     { bereken hoeveel volle blokken van 4096 er nodig zijn }
     { het resultaat van beide berekeningen is 0-based! }
     BigBlocks:=MapAreaRecCount DIV MapRecordsPerArray;
     LeftOver:=MapAreaRecCount MOD MapRecordsPerArray;

     { vraag deze nu allemaal aan }
     IF (BigBlocks > 0) THEN
        FOR Lp:=0 TO BigBlocks-1 DO
            GetMem (AreaDataTable[Lp],SizeOf (MapArray));

     IF (LeftOver <> 0) THEN
        GetMem (AreaDataTable[BigBlocks],SizeOf (MapRecord)*(LeftOver+1));

     NameCount:=1;
     NameLengths[NameCount]:=61440;
     IF ((MaxAvail-5000) < NameLengths[NameCount]) THEN
        NameLengths[NameCount]:=MaxAvail-5000;

     GetMem (NamePtrs[NameCount],NameLengths[NameCount]);
     PeekMem;

     StorePos:=1;

     { lees nu alle benodigde gegevens van de areas in }
     FOR Lp:=1 TO RecCount DO
     BEGIN
          { reken uit hoeveel tekens van de area naam van de nog te  }
          { verwerken records er maximaal opgeslagen kunnen worden,  }
          { inclusief de lengte byte. Dit wordt continue bijgesteld, }
          { zodat lange namen dit aantal omlaag brengen en korte     }
          { namen dit aantal omhoog halen.                           }

          { de berekening is als volgt: het geheugen dat nog vrij is, }
          { plus het geheugen dat we nog vrij hebben maar al wel      }
          { aangevraag hebben en dat gedeeld door het aantal records  }
          { dat we nog moeten verwerken.                              }

          { RWI 950910: mogelijke probleem veroorzaker uitgeschakeld...
                        nu wordt gewoon altijd de formule gebruikt.

          IF ((NameLengths[NameCount]-StorePos) > 256) THEN
             MaxCopy:=256
          ELSE BEGIN
          }
               MaxHelp:=((MemAvail-5000)+(NameLengths[NameCount]-StorePos)) DIV (MapAreaRecCount-Lp+1);
               IF (MaxHelp > 256) THEN
                  MaxCopy:=256
               ELSE
                   MaxCopy:=MaxHelp;
          {
          END;
          }
          { haal de naam van het volgende record op }
          FetchNextRecNr (FirstRecNr,AreaName);

          IF ((Lp MOD 25) = 1) THEN
          BEGIN
               PercDone:=Round ((Lp/MapAreaRecCount)*100);
               WriteXYC (QLXb2,QLYb+4,cBoxData,Word2String (Lp)+'/'+Word2String (MapAreaRecCount)+
                                               ' ('+Byte2String (PercDone)+'%)');
          END;

          WITH AreaDataTable[Lp DIV MapRecordsPerArray]^[Lp MOD MapRecordsPerArray] DO
          BEGIN
               RecNr:=FirstRecNr;

               ToCopy:=Length (AreaName)+1{lengte byte};
               IF (ToCopy > MaxCopy) THEN
                  ToCopy:=MaxCopy;

               { kijk of er nog ruimte genoeg voor is }
               IF ((NameLengths[NameCount]-StorePos) < ToCopy) THEN
               BEGIN
                    { naam, vraag een nieuw geheugen blok aan, }
                    { zo groot mogelijk.                       }
                    Inc (NameCount);

                    NameLengths[NameCount]:=61440;
                    IF ((MaxAvail-5000) < NameLengths[NameCount]) THEN
                       NameLengths[NameCount]:=MaxAvail-5000;

                    GetMem (NamePtrs[NameCount],NameLengths[NameCount]);
                    PeekMem;

                    StorePos:=1;
               END;

               NamePtr:=Addr (NamePtrs[NameCount]^[StorePos]);

               Move (AreaName,NamePtr^,ToCopy);

               Inc (StorePos,ToCopy);
          END; { with }

     END; { for }

     WriteXYC (QLXb2,QLYb+4,cBoxData,Word2String (MapAreaRecCount)+' records, '+
                                     Longint2String (MemAvail DIV 1024)+'Kb free');
END;


{--------------------------------------------------------------------------}
{ DestroyAreaDataTable                                                     }
{                                                                          }
{ Deze routine ruimt de AreaDataTable en NameBlocks weer op door al het    }
{ geheugen weer vrij te gegeven.                                           }
{                                                                          }
PROCEDURE DestroyAreaDataTable;

VAR Lp,
    BigBlocks,
    LeftOver  : BYTE;

BEGIN
     { het resultaat van beide berekeningen is 0-based! }
     BigBlocks:=MapAreaRecCount DIV MapRecordsPerArray;
     LeftOver:=MapAreaRecCount MOD MapRecordsPerArray;

     IF (BigBlocks > 0) THEN
        FOR Lp:=0 TO BigBlocks-1 DO
            FreeMem (AreaDataTable[Lp],SizeOf (MapArray));

     IF (LeftOver <> 0) THEN
        FreeMem (AreaDataTable[BigBlocks],SizeOf (MapRecord)*(LeftOver+1));

     { geef nu de geheugen blokken vrij waarin de namen opgeslagen }
     { staan. Dit doen we nadat de pointers naar deze blokken      }
     { verwijderd zijn.                                            }
     FOR Lp:=1 TO NameCount DO
         FreeMem (NamePtrs[Lp],NameLengths[Lp]);

     NameCount:=0;
END;


{--------------------------------------------------------------------------}
{ SortAreaData                                                             }
{                                                                          }
{ Deze routine sorteert de lijst met areas aan de hand van de gegevens die }
{ in AreaDataTable beschikbaar zijn.                                       }
{ Hier wordt gebruik gemaakt van domme oude BubbleSort. Voornamelijk       }
{ omdat we niet zoveel geheugen vrij hebben. InsertionSort zou ook nog     }
{ kunnen, maar het is niet echt een heap structuur, dus inserten kan       }
{ nogal wat overhead veroorzaken.                                          }
{                                                                          }
PROCEDURE SortAreaData;

VAR Lp1,
    Lp2      : WORD;
    PercDone : BYTE;
    SwapRec  : MapRecord;
    SPtr,                        { smallest }
    T1Ptr,
    T2Ptr    : MapRecordPtr;
    DidRecS  : BOOLEAN;
    RecS,
    Rec2     : AreaBaseRecord;

BEGIN
     IF (MapAreaRecCount < 1) THEN
     BEGIN
          WriteXYC (QLXb2,QLYb+5,cBoxData,'No work');
          Exit; { nothing to sort }
     END;

     { quickly check to see if the whole thing is already sorted }
     T1Ptr:=Addr (AreaDataTable[0]^[1]);
     FOR Lp1:=2 TO MapAreaRecCount DO
     BEGIN
          T2Ptr:=Addr (AreaDataTable[Lp1 DIV MapRecordsPerArray]^[Lp1 MOD MapRecordsPerArray]);

          IF (T1Ptr^.NamePtr^ >= T2Ptr^.NamePtr^) THEN
          BEGIN
               { een verschil is gevonden! }
               T1Ptr:=NIL;
               Break;
          END;
     END;

     IF (T1Ptr <> NIL) THEN
     BEGIN
          WriteXYC (QLXb2,QLYb+5,cBoxData,'Already sorted');
          Exit;
     END;

     FOR Lp1:=1 TO MapAreaRecCount-1 DO
     BEGIN
          T1Ptr:=Addr (AreaDataTable[Lp1 DIV MapRecordsPerArray]^[Lp1 MOD MapRecordsPerArray]);
          SPtr:=T1Ptr;

          DidRecS:=FALSE; { nog niet van disk geladen }

          { ga op zoek naar het kleinste record }

          FOR Lp2:=Lp1+1 TO MapAreaRecCount DO
          BEGIN
               T2Ptr:=Addr (AreaDataTable[Lp2 DIV MapRecordsPerArray]^[Lp2 MOD MapRecordsPerArray]);

               IF (T2Ptr^.NamePtr^ <= SPtr^.NamePtr^) THEN
               BEGIN
                    IF (T2Ptr^.NamePtr^ < SPtr^.NamePtr^) THEN
                    BEGIN
                         SPtr:=T2Ptr;
                         DidRecS:=FALSE; { er is nu een nieuwe }
                    END ELSE
                    BEGIN
                         { ze zijn gelijk, dus we moeten op disk kijken }
                         { voor de zekerheid.                           }

                         IF (NOT DidRecS) THEN
                         BEGIN
                              ReadAreaBaseRecord (SPtr^.RecNr,RecS);
                              DidRecS:=TRUE;
                         END;

                         ReadAreaBaseRecord (T2Ptr^.RecNr,Rec2);

                         { Nu nog eens vergelijken of ie echt kleiner is   }
                         { PS: NOOIT vergelijken tegen wat er het geheugen }
                         {     staat, want daar zit de GroupCh bij in!!    }
                         IF (Rec2.AreaName_F < RecS.AreaName_F) THEN
                         BEGIN
                              { ja! Het is echt. deze is vanaf nu de kleinste }
                              SPtr:=T2Ptr;
                              RecS:=Rec2; { DidRecS blijft TRUE }
                         END; { echt swappen }
                    END; { disk controle }
               END; { uberhaupt mogelijk kleiner }
          END; { for 2 }

          { als we een kleinere gevonden hebben, ze die dan op deze positie }
          IF (SPtr <> T1Ptr) THEN
          BEGIN
               SwapRec:=T1Ptr^;
               T1Ptr^:=SPtr^;
               SPtr^:=SwapRec;
          END;

          PercDone:=Round (Lp1/MapAreaRecCount*100);
          WriteXYC (QLXb2,QLYb+5,cBoxData,Word2String (Lp1)+'/'+Word2String (MapAreaRecCount)+
                                          ' ('+Byte2String (PercDone)+'%)');
     END; { for 1 }

     WriteXYC (QLXb2,QLYb+5,cBoxData,Word2String (MapAreaRecCount)+'/'+Word2String (MapAreaRecCount)+' (100%)');
END;


{---------------------------------------------------------------------------}
{ FreeUpNameTables                                                          }
{                                                                           }
{ Deze routine maakt wat geheugen vrij door de Name tables vrij te geven.   }
{ Maar... het eerste teken van de naam bevat de groep waarin deze area zit  }
{ en die moet bewaard worden. Dus, gebruiken we een variant record en       }
{ stoppen we deze group code over de pointer heen. Daarna zijn alle         }
{ pointers niet meer te gebruiken en kunnen de Name tables vrij gegeven     }
{ worden.                                                                   }
{                                                                           }
PROCEDURE FreeUpNameTables;

VAR Lp     : WORD;
    MapPtr : MapRecordPtr;

BEGIN
     FOR Lp:=1 TO MapAreaRecCount DO
     BEGIN
          MapPtr:=Addr (AreaDataTable[Lp DIV MapRecordsPerArray]^[Lp MOD MapRecordsPerArray]);

          { kopieer de groep code }
          MapPtr^.Group:=Copy (MapPtr^.NamePtr^,1,2);
     END; { for }

     { geef nu de geheugen blokken vrij waarin de namen opgeslagen staan }
     FOR Lp:=1 TO NameCount DO
         FreeMem (NamePtrs[Lp],NameLengths[Lp]);

     NameCount:=0;
END;


{---------------------------------------------------------------------------}
{ AddAreaDataTableToMessage                                                 }
{                                                                           }
{ Deze routine voegt de gesorteerde lijst met areas toe aan het bericht dat }
{ naar de user gaat.                                                        }
{                                                                           }
PROCEDURE AddAreaDataTableToMessage;

VAR AreaRec : AreaBaseRecord;

    {-----------------------------------------------------------------------}
    { AddArea                                                               }
    {                                                                       }
    { Deze routine voegt een area aan de output (LineBuffer) toe. Hierbij   }
    { wordt de areanaam gevolgd door de area description genomen. Dit kan   }
    { een of meerdere regels innemen, afhankelijk van de lengte van de      }
    { areaname en description.                                              }
    { Nodig: AreaRec, UserInfo.System                                       }
    {                                                                       }
    PROCEDURE AddArea;

    VAR HulpStr : STRING;
        AName   : STRING[MaxLenAreaName];
        ZoekPos : BYTE;

    BEGIN
         HulpStr:=DeleteFrontAndBackSpaces (AreaRec.Comment);

         IF (UserInfo.System = _F) THEN
            AName:=AreaRec.AreaName_F
         ELSE
             AName:=AreaRec.AreaName_U;

         IF (HulpStr = '') THEN
            AddToLineBuffer (LineBuffer,AName)
         ELSE BEGIN
             { commentaar erachter plaatsen als de areaname }
             { kleiner is dan 30 tekens, anders commentaar  }
             { op de volgende regel zetten.                 }
             IF (Length (AName) <= 30) THEN
             BEGIN
                  { als er een commentaar regel is, dan toevoegen }
                  HulpStr:=AddUpWithSpaces (30,AName)+' - '+HulpStr;

                  { lijn splitsen bij te lang }
                  IF (Length (HulpStr) > 75) THEN
                  BEGIN
                       ZoekPos:=75;
                       WHILE (ZoekPos > 33) AND (HulpStr[ZoekPos] <> ' ') DO
                             Dec (ZoekPos);

                       IF (ZoekPos = 33) THEN
                          ZoekPos:=75;

                       AddToLineBuffer (LineBuffer,DeleteBackSpaces (Copy (HulpStr,1,ZoekPos)));
                       AddToLineBuffer (LineBuffer,Spaces (33)+DeleteFrontSpaces (Copy (HulpStr,ZoekPos+1,255)));
                  END ELSE
                      AddToLineBuffer (LineBuffer,HulpStr);
             END ELSE
             BEGIN
                  { Area Name is langer dan 30 tekens, dus }
                  { commentaar begint pas op de volgende   }
                  { regel. Als er commentaar is tenminste  }
                  AddToLineBuffer (LineBuffer,AName);

                  HulpStr:=Spaces (31)+'- '+HulpStr;
                  IF (Length (HulpStr) > 75) THEN
                  BEGIN
                       { te lang voor op 1 regel, dus maken }
                       { we er twee regels van.             }
                       ZoekPos:=75;
                       WHILE (ZoekPos > 33) AND (HulpStr[ZoekPos] <> ' ') DO
                             Dec (ZoekPos);

                       IF (ZoekPos = 33) THEN
                          ZoekPos:=75;

                       AddToLineBuffer (LineBuffer,DeleteBackSpaces (Copy (HulpStr,1,ZoekPos)));
                       AddToLineBuffer (LineBuffer,
                                        Spaces (33)+DeleteFrontSpaces (Copy (HulpStr,ZoekPos+1,255)));
                  END ELSE
                      AddToLineBuffer (LineBuffer,HulpStr);
             END; { area name langer dan 40 tekens }
         END; { commentaar toevoegen }
    END;

{AddAreaDataTableToMessage}
VAR GroupLp     : GroupNrType;
    Group       : STRING[2];
    GroupAny    : BOOLEAN; { area gevonden in deze group? }
    Lp          : WORD;
    AreaPtr     : MapRecordPtr;
    GroupRec    : GroupDescRecord;
    HulpStr     : STRING;

BEGIN
     FOR GroupLp:=1 TO MaxGroups DO
     BEGIN
          IF (NOT TestIfInGroup (UserInfo.Groups,GroupLp)) THEN
             Continue; { group mag ie niet in, sla maar over }

          Group:=BuildSingleGroupDesc (GroupLp);

          ReadGroupDescRecord (GroupLp,GroupRec);

          HulpStr:=GetLang2 (2002,Group,DeleteBackSpaces (GroupRec.GroupDesc));
          IF GroupRec.ReadOnly THEN
             HulpStr:=HulpStr+' ['+GetLang0 (2003)+']';

          AddToLineBuffer (LineBuffer,'');
          AddToLineBuffer (LineBuffer,HulpStr);
          AddToLineBuffer (LineBuffer,'');

          { nu de lijst met areas toevoegen }
          GroupAny:=FALSE;
          FOR Lp:=1 TO MapAreaRecCount DO
          BEGIN
               AreaPtr:=Addr (AreaDataTable[Lp DIV MapRecordsPerArray]^[Lp MOD MapRecordsPerArray]);

               { Niet zeker of de RecNr wel gecontroleerd en op NIL gezet hoeft te worden }
               IF (AreaPtr^.Group = Group) AND
                  (AreaPtr^.RecNr <> NILRecordNr) THEN
               BEGIN
                    { deze area toevoegen aan de lijst }
                    ReadAreaBaseRecord (AreaPtr^.RecNr,AreaRec);
                    AreaPtr^.RecNr:=NILRecordNr; { is nu verwerkt }
                    AreaPtr^.Group:=''; { versnelt check hierboven }

                    AddArea;

                    GroupAny:=TRUE; { RWI 950910 }
               END;

          END; { areadata loop }

          IF (NOT GroupAny) THEN
             AddToLineBuffer (LineBuffer,GetLang0 (2004));

     END; { group loop }
END;


{--------------------------------------------------------------------------}
{ ListFetchNextRecNr                                                       }
{                                                                          }
{ Deze routine geeft het volgende record nummer terug.                     }
{                                                                          }
PROCEDURE ListFetchNextRecNr (VAR RecNr : WORD; VAR AreaName : STRING); FAR;

VAR AreaRec   : AreaBaseRecord;
    Test,
    Filter    : GroupFlagType;
    GroupDesc : STRING;
    GroupLp   : GroupNrType;

BEGIN
     REPEAT
           Inc (RecNr);
           ReadAreaBaseRecord (RecNr,AreaRec);
     UNTIL (NOT AreaRec.Deleted) AND
           (NOT AreaRec.Hidden) AND
           (AreaRec.AreaType = Area_Echo) AND
           TestIfGroupCommon (AreaRec.IsInGroups,UserInfo.Groups);

     { welke groepen waar de area in zit zijn van belang voor deze user? }
     CreateCommonGroup (Filter,AreaRec.IsInGroups,UserInfo.Groups);

     { zit er bij deze groepen ook een read/write groep? }
     CreateCommonGroup (Test,Filter,ReadWriteGroupsFilter);
     IF (NOT TestGroupListIsEmpty (Test)) THEN
        Filter:=Test;

     { de eerste area in Filter wordt de groep waar deze area in komt }
     GroupDesc:='?'; { error etc. }
     FOR GroupLp:=1 TO MaxGroups DO
         IF TestIfInGroup (Filter,GroupLp) THEN
         BEGIN
              GroupDesc:=BuildSingleGroupDesc (GroupLp);
              Break;
         END;

     IF (UserInfo.System = _F) THEN
        AreaName:=GroupDesc+AreaRec.AreaName_F
     ELSE
         AreaName:=GroupDesc+AreaRec.AreaName_U;
END;


{--------------------------------------------------------------------------}
{ AreaCountUser_Can_Subscribe                                              }
{                                                                          }
{ Deze routine geeft het aantal records terug waar deze user toegang tot   }
{ heeft. Helaas moet de hele areabase daarvoor doorlopen worden, maar ja.. }
{                                                                          }
FUNCTION AreaCountUser_Can_Subscribe : WORD;

VAR Lp,
    Count   : WORD;
    AreaRec : AreaBaseRecord;

BEGIN
     Count:=0;

     FOR Lp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (Lp,AreaRec);

          IF (NOT AreaRec.Deleted) AND
             (NOT AreaRec.Hidden) AND
             (AreaRec.AreaType = Area_Echo) AND
             TestIfGroupCommon (AreaRec.IsInGroups,UserInfo.Groups)
          THEN
              Inc (Count);
     END;

     AreaCountUser_Can_Subscribe:=Count;
END;


{--------------------------------------------------------------------------}
{ BuildList                                                                }
{                                                                          }
{ Deze routine bouwt een lijst op in het LineBuffer met daarin alle        }
{ areas die de user aan kan sluiten. Ook de al aangesloten areas staan     }
{ hierin. Deze routine wordt zowel voor Fido als voor UUCP gebruikt.       }
{                                                                          }
PROCEDURE BuildList;
BEGIN
     InitQLWindow ('%LIST progress');

     { Plaats een 'Areafix LiSt Request HeaDeR' aan het begin }
     WriteXYC (QLXb+3,QLYb+3,cCustom1,'');
     IF (NOT AddFileToMsg (LineBuffer,'AFLSRHDR.TXT')) THEN
     BEGIN
          AddToLineBuffer (LineBuffer,#13'You can connect to the following areas:');
          WriteXYC (QLXb2,QLYb+3,cBoxData,'System line');
     END ELSE
         WriteXYC (QLXb2,QLYb+3,cBoxData,'AFLSRHDR.TXT');
     WriteXY (QLXb+3,QLYb+3,'');

     WriteXYC (QLXb+3,QLYb+4,cCustom1,'');
     InitAreaDataTable (AreaCountUser_Can_Subscribe,0,ListFetchNextRecNr);
     WriteXYC (QLXb+3,QLYb+4,cBoxData,'');

     WriteXYC (QLXb+3,QLYb+5,cCustom1,'');
     SortAreaData;
     WriteXYC (QLXb+3,QLYb+5,cBoxData,'');

     WriteXYC (QLXb+3,QLYb+6,cCustom1,'');
     FreeUpNameTables; { maakt ruimte voor het bericht }

     AddAreaDataTableToMessage;
     WriteXYC (QLXb+3,QLYb+6,cBoxData,'');

     DestroyAreaDataTable;

     { Voeg een 'Areafix LiSt Request Footer' toe ...          }
     { MD : Hoe verklaren we die afkortingen in de manual ???? }
     { MD : Doen we niet... we laten ze raden <gna gna gna>    }
     WriteXYC (QLXb+3,QLYb+7,cCustom1,'');
     IF (NOT AddFileToMsg (LineBuffer,'AFLSRFTR.TXT')) THEN
     BEGIN
          AddToLineBuffer (LineBuffer,#13'-- All '+Word2String (MapAreaRecCount)+' available areas listed'#13);
          WriteXYC (QLXb2,QLYb+7,cBoxData,'System line');
     END ELSE
         WriteXYC (QLXb2,QLYb+7,cBoxData,'AFLSRFTR.TXT');
     WriteXY (QLXb+3,QLYb+7,'');

     WindowPop;
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ QueryFetchNextRecNr                                                      }
{                                                                          }
PROCEDURE QueryFetchNextRecNr (VAR RecNr : WORD; VAR AreaName : STRING); FAR;

VAR AreaRec   : AreaBaseRecord;
    Test,
    Filter    : GroupFlagType;
    GroupDesc : STRING;
    GroupLp   : GroupNrType;

BEGIN
     IF (RecNr = NILRecordNr) THEN
        GetFirstAreaUserIsSubscribedTo (UserInfo.AreaList,QuerySearch)
     ELSE
         GetNextAreaUserIsSubscribedTo (QuerySearch);

     RecNr:=QuerySearch.AreaBaseRecordNr;
     ReadAreaBaseRecord (RecNr,AreaRec);

     { welke groepen waar de area in zit zijn van belang voor deze user? }
     CreateCommonGroup (Filter,AreaRec.IsInGroups,UserInfo.Groups);

     { zit er bij deze groepen ook een read/write groep? }
     CreateCommonGroup (Test,Filter,ReadWriteGroupsFilter);
     IF (NOT TestGroupListIsEmpty (Test)) THEN
        Filter:=Test;

     { de eerste area in Filter wordt de groep waar deze area in komt }
     GroupDesc:='?'; { error }
     FOR GroupLp:=1 TO MaxGroups DO
         IF TestIfInGroup (Filter,GroupLp) THEN
         BEGIN
              GroupDesc:=BuildSingleGroupDesc (GroupLp);
              Break;
         END;

     { RWI 950916: added GroupCh as first character }
     IF (UserInfo.System = _F) THEN
        AreaName:=GroupDesc+AreaRec.AreaName_F
     ELSE
         AreaName:=GroupDesc+AreaRec.AreaName_U;
END;


{--------------------------------------------------------------------------}
{ BuildQuery                                                               }
{                                                                          }
{ Deze routine bouwt een lijst op in het LineBuffer met daarin alle        }
{ areas die de user aan kan sluiten. Deze routine wordt zowel voor Fido    }
{ als voor UUCP gebruikt.                                                  }
{                                                                          }
PROCEDURE BuildQuery;
BEGIN
     InitQLWindow ('%QUERY progress');

     { Plaats een 'Areafix QueRy Request HeaDeR' aan het begin }
     WriteXYC (QLXb+3,QLYb+3,cCustom1,'');
     IF (NOT AddFileToMsg (LineBuffer,'AFQRRHDR.TXT')) THEN
     BEGIN
          AddToLineBuffer (LineBuffer,#13'You are connected to the following areas:');
          WriteXYC (QLXb2,QLYb+3,cBoxData,'System line');
     END ELSE
         WriteXYC (QLXb2,QLYb+3,cBoxData,'AFQRRHDR.TXT');
     WriteXY (QLXb+3,QLYb+3,'');

     WriteXYC (QLXb+3,QLYb+4,cCustom1,'');
     InitAreaDataTable (CountSubscribedAreas (UserInfo.AreaList),NILRecordNr,QueryFetchNextRecNr);
     WriteXYC (QLXb+3,QLYb+4,cBoxData,'');

     WriteXYC (QLXb+3,QLYb+5,cCustom1,'');
     SortAreaData;
     WriteXYC (QLXb+3,QLYb+5,cBoxData,'');

     WriteXYC (QLXb+3,QLYb+6,cCustom1,'');
     FreeUpNameTables; { maakt ruimte om het bericht op te bouwen }

     AddAreaDataTableToMessage;
     WriteXYC (QLXb+3,QLYb+6,cBoxData,'');

     DestroyAreaDataTable;

     { Plaats een 'Areafix QueRy Request FooTeR' aan het einde }
     WriteXYC (QLXb+3,QLYb+7,cCustom1,'');
     IF (NOT AddFileToMsg (LineBuffer,'AFQRRFTR.TXT')) THEN
     BEGIN
          AddToLineBuffer (LineBuffer,#13'-- All '+Word2String (MapAreaRecCount)+' connected areas listed'#13);
          WriteXYC (QLXb2,QLYb+3,cBoxData,'System line');
     END ELSE
         WriteXYC (QLXb2,QLYb+7,cBoxData,'AFQRRFTR.TXT');
     WriteXY (QLXb+3,QLYb+7,'');

     WindowPop;
     PopKeysLine;
END;


{---------------------------------------------------------------------------}
{ ProcessFixLine                                                            }
{                                                                           }
{ Deze routine verwerkt een areafix/newsfix regel. Eindelijk worden ze dan  }
{ door e'e'n routine verwerkt.                                              }
{                                                                           }
PROCEDURE ProcessFixLine (Regel : STRING);

VAR Keyword  : STRING;
    ComprLp  : CompressionType;

    AreaLp   : AreaBaseRecordNrType;
    AreaRec  : AreaBaseRecord;

    GroupCh  : CHAR;
    GroupLp  : GroupDescBaseRecordNrType;
    GroupRec : GroupDescRecord;

BEGIN
     { er kunnen meerdere enters staan zodra ik in de toekomst een lege }
     { enter aan de vorige regel plak bij het importeren...             }
     WHILE (Regel <> '') AND (Regel[Length (Regel)] = #13) DO
           Delete (Regel,Length (Regel),1);

     Regel:=UpCaseString (DeleteFrontAndBackSpaces (Regel));

     IF (Regel = '') THEN
        Exit;

     AddToLineBuffer (LineBuffer,'--> '+Regel);

     { Als de regel met een % begint is het een commando optie }
     IF (Regel[1] = '%') THEN
     BEGIN
          (*
          IF (Pos ('%FROM',TempInfo) = 1) THEN
          BEGIN
               IF (NOT UserInfo.AllowFrom) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Access denied');
                    Exit;
               END;

               IF (UserInfo.System = _F) THEN
               BEGIN
                    (*
                    TempInfo:=Copy (TempInfo,6,Length (TempInfo));
                    TempInfo:=DeleteFrontSpaces (TempInfo);
                    FidoSplit (TempInfo,CurrentFromAddress);

                    { Probeer het bijbehorende record te lezen }
                    IF (NOT FindUserBaseRecordByFidoAddress (CurrentFromAddress,UserInfoRecNr)) THEN
                    BEGIN
                         AddToLineBuffer (LineBuffer,'Unknown %FROM adress ('+TempInfo+'), ignoring commands');
                         AddToLineBuffer (LineBuffer,'until an other %FROM command is found.');
                         IgnoreCommand:=TRUE;
                    END ELSE
                    BEGIN
                         AddToLineBuffer (LineBuffer,'Now processing commands for '+TempInfo);
                         ReadUserBaseRecord (UserInfoRecNr,UserData);
                         IgnoreCommand:=FALSE;
                    END;
                    * )

                    AddToLineBuffer ('  Not implemented yet, sorry');
                    Exit;
               END ELSE
               BEGIN
                    { uucp }
                    (*
                    BadFrom:=TRUE;
                    FOR FLp:=1 TO UserBaseRecCount DO
                    BEGIN
                         ReadUserBaseRecord (FLp,FromData);

                         IF (NOT FromData.Deleted) AND (UpcaseString(FromData.UUCPName)=REGEL) THEN
                                 BadFrom:=FALSE; { found }

                         IF (NOT BadFrom) THEN Break; { for }
                    END; { for ULp }

                    IF BadFrom THEN
                    BEGIN
                         MsgsAddLineTo (Header_F,'  System '+Regel+' not found!');
                         MsgsAddLineTo (Header_F,'  Rest of newsfix will be skipped for protection reasons,');
                         MsgsAddLineTo (Header_F,'  until an other %FROM command.');
                    END ELSE
                    BEGIN
                         MsgsAddLineTo (Header_F,'  Further processing will be as '+FromData.UUCPName);

                         WriteUserBaseRecord (ULp,MgrUserData); { pff.. }
                         MgrUserData:=FromData;
                         ULp:=FLp;
                    END;
                    * )

                    AddToLineBuffer ('  Not implemented yet, sorry');
                    Exit;
               END;
          END;
          *)

          IF IgnoreCommand THEN
          BEGIN
               { er is een verkeerde %FROM geweest }
               AddToLineBuffer (LineBuffer,'  Ignoring');
               Exit;
          END;

          IF Config.LogAreaFix THEN
             LogMessage ('Processing '+Regel);

          IF (Regel = '%HELP') THEN
          BEGIN
               {Help will follow in an other message}
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2005));
               RequestedHelp:=TRUE;
               Exit;
          END;

          IF (Regel = '%QUERY') THEN
          BEGIN
               {The query listing will follow in an other message');}
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2006));
               RequestedQuery:=TRUE;
               Exit;
          END;

          IF (Regel = '%LIST') THEN
          BEGIN
               {The listing will follow in an other message');}
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2007));
               RequestedList:=TRUE;
               Exit;
          END;

          IF (Regel = '%+ALL') THEN
          BEGIN
               CommandAddAll;
               Exit;
          END;

          IF (Regel = '%-ALL') THEN
          BEGIN
               CommandDelAll;
               Exit;
          END;

          IF (Regel = '%LISTNEW') THEN
          BEGIN
               IF (NOT UserInfo.AllowFrom) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Access denied');
                    Exit;
               END;

               AddToLineBuffer (LineBuffer,'  Listing of new areas in group Z:');

               FOR AreaLp:=1 TO AreaBaseRecCount DO
               BEGIN
                    ReadAreaBaseRecord (AreaLp,AreaRec);

                    IF (UserInfo.System <> _F) THEN
                       AreaRec.AreaName_F:=AreaRec.AreaName_U;

                    IF (NOT AreaRec.Deleted) AND TestIfInGroup (AreaRec.IsInGroups,Group_NewAreas) THEN
                       AddToLineBuffer (LineBuffer,'    '+AreaRec.AreaName_F);
               END;

               AddToLineBuffer (LineBuffer,'  End of listing');
               Exit;
          END;

          IF (Regel = '%GROUPS') THEN
          BEGIN
               IF (NOT UserInfo.AllowFrom) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Access denied');
                    Exit;
               END;

               AddToLineBuffer (LineBuffer,'  Listing of all groups:');

               FOR GroupLp:=1 TO MaxGroups DO
               BEGIN
                    ReadGroupDescRecord (GroupLp,GroupRec);
                    AddToLineBuffer (LineBuffer,'  '+BuildSingleGroupDesc (GroupLp)+' '+DeleteBackSpaces (GroupRec.GroupDesc));
                    AddToLineBuffer (LineBuffer,'    Origin AKA: '+Fido2Str (Config.NodeNrs[GroupRec.OriginAka]));
                    IF (GroupRec.Readonly) THEN
                       AddToLineBuffer (LineBuffer,'    '+GetLang0 (2036));
               END;

               AddToLineBuffer (LineBuffer,'  End of groups listing');
               Exit;
          END;

          IF (Regel = '%PASSIVE') OR (Regel = '%DISABLE') THEN
          BEGIN
               IF (NOT UserInfo.Passive) THEN
               BEGIN
                    UserInfo.Passive:=TRUE;
                    {Your system is now PASSIVE');}
                    AddToLineBuffer (LineBuffer,'  '+GetLang1 (2008,'PASSIVE'));
                    WriteUserBaseRecord (UserInfoRecNr,UserInfo);
               END ELSE
                   {Your system was PASSIVE already');}
                   AddToLineBuffer (LineBuffer,'  '+GetLang1 (2009,'PASSIVE'));

               Exit;
          END;

          IF (Regel = '%ACTIVE') OR (Regel = '%ENABLE') THEN
          BEGIN
               IF (UserInfo.Passive) THEN
               BEGIN
                    UserInfo.Passive:=FALSE;
                    WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                    {Your system is now ACTIVE');}
                    AddToLineBuffer (LineBuffer,'  '+GetLang1 (2008,'ACTIVE'));
               END ELSE
                   {Your system was ACTIVE already');}
                   AddToLineBuffer (LineBuffer,'  '+GetLang1 (2009,'ACTIVE'));

               Exit;
          END;

          IF (Pos (' ',Regel) > 0) THEN
          BEGIN
               Keyword:=Copy (Regel,1,Pos (' ',Regel)-1);
               Delete (Regel,1,Pos (' ',Regel));
          END ELSE
          BEGIN
               { unknown }
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2010));
               Exit;
          END;

          IF (Keyword = '%PASSWORD') THEN
          BEGIN
               UserInfo.AreaFixPwd:=UpCaseString (DeleteBackSpaces (Copy (DeleteFrontSpaces (Regel),1,MaxLenAreafixPwd)));
               WriteUserBaseRecord (UserInfoRecNr,UserInfo);

               IF (UserInfo.System = _F) THEN
                  {Your AreaFix password is now set to "'+UserInfo.AreaFixPwd+'"')}
                  AddToLineBuffer (LineBuffer,'  '+GetLang2 (2011,Config.AreafixName,UserInfo.AreaFixPwd))
               ELSE
                   AddToLineBuffer (LineBuffer,'  '+GetLang2 (2011,Config.NewsfixName,UserInfo.AreaFixPwd));

               Exit;
          END;

          IF (Keyword = '%PACKETPWD') OR (Keyword = '%PKTPWD') THEN
          BEGIN
               IF (UserInfo.System <> _F) THEN
               BEGIN
                    { unknown }
                    AddToLineBuffer (LineBuffer,'  '+GetLang0 (2010));
                    Exit;
               END;

               { gebruik DeleteBackSpaces om bij een zin met woorden die }
               { afkapt wordt geen spaties over te houden.               }
               UserInfo.PacketPwd:=DeleteBackSpaces (Copy (DeleteFrontSpaces (Regel),1,8));
               WriteUserBaseRecord (UserInfoRecNr,UserInfo);
               AddToLineBuffer (LineBuffer,'  '+GetLang1 (2012,UserInfo.PacketPwd));
               Exit;
          END;

          IF (Keyword = '%COMPRESS') THEN
          BEGIN
               IF (UserInfo.System = _F) THEN
               BEGIN
                    FOR ComprLp:=ARC TO PKT DO
                        IF (ComprLp <> GUS) AND (Regel = ComprDescr[ComprLp]) THEN
                        BEGIN
                             UserInfo.Compression:=ComprLp;
                             WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                             { your compression program is now set to }
                             AddToLineBuffer (LineBuffer,'  '+GetLang1 (2013,ComprDescr[ComprLp]));
                             Exit;
                        END;

                    { unknown compression program }
                    AddToLineBuffer (LineBuffer,'  '+GetLang1 (2014,Regel));
                    Exit;
               END ELSE
               BEGIN
                    { uucp (of baglink, maar dat zal wel nooit) }
                    IF (Regel = 'NONE') THEN
                    BEGIN
                         UserInfo.Compress:=USE_NONE;
                         WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                         { compression set to }
                         AddToLineBuffer (LineBuffer,'  '+GetLang1 (2015,'NONE'));
                         Exit;
                    END;

                    IF (Regel = 'COMPRESS') OR (Regel = 'COMP430D') THEN
                    BEGIN
                         UserInfo.Compress:=USE_COMPRESS;
                         WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                         { compression set to }
                         AddToLineBuffer (LineBuffer,'  '+GetLang1 (2015,'COMPRESS/COMP430D'));
                         Exit;
                    END;

                    IF (Regel = 'GZIP') THEN
                    BEGIN
                         UserInfo.Compress:=USE_ZIP;
                         WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                         { compression set to }
                         AddToLineBuffer (LineBuffer,'  '+GetLang1 (2015,'GZIP'));
                         Exit;
                    END;

                    {Unknown compression type. Use NONE, COMPRESS or GZIP.');}
                    AddToLineBuffer (LineBuffer,'  '+GetLang0 (2016));
                    Exit;
               END;
          END; { compress }

          IF (Keyword = '%CUNBATCH') THEN
          BEGIN
               IF (UserInfo.System <> _U) THEN
               BEGIN
                    { unknown }
                    AddToLineBuffer (LineBuffer,'  '+GetLang0 (2010));
                    Exit;
               END;

               IF (Regel = 'ON') OR (Regel = 'YES') OR (Regel = 'ENABLE') THEN
               BEGIN
                    UserInfo.CunBatch:=TRUE;
                    WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                    { Enabled cunbatch }
                    AddToLineBuffer (LineBuffer,'  '+GetLang1 (2016,'#! '+GZipBatchLetter+'unbatch'));
                    Exit;
               END;

               IF (Regel = 'OFF') OR (Regel = 'NO') OR (Regel = 'DISABLE') THEN
               BEGIN
                    UserInfo.CunBatch:=FALSE;
                    WriteUserBaseRecord (UserInfoRecNr,UserInfo);
                    { disabled batch header }
                    AddToLineBuffer (LineBuffer,'  '+GetLang0 (2017));
                    Exit;
               END;

               { unknown batch header option. Use ON or OFF }
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2018));
               Exit;
          END;

          IF (Keyword = '%MOVENEW') THEN
          BEGIN
               IF (NOT UserInfo.AllowFrom) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Access denied');
                    Exit;
               END;

               GroupCh:=UpCase (Regel[1]);
               Delete (Regel,1,1);

               IF NOT (GroupCh IN ['A'..'Z']) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Invalid group ('+GroupCh+') to move to. Mind what you''re doing!');
                    Exit;
               END;

               IF (GroupCh = 'Z') THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Why move from group Z to group Z? Mind what you''re doing!');
                    Exit;
               END;

               Regel:=DeleteFrontSpaces (Regel);
               IF (Regel = '') THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Missing area name. Mind what you''re doing!');
                    Exit;
               END;

               IF (UserInfo.System = _U) THEN
                  AreaLp:=GetAreaBaseRecordNrByAreaName_U (Regel)
               ELSE
                   AreaLp:=GetAreaBaseRecordNrByAreaName_F (Regel);

               IF (AreaLp = NILRecordNr) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Cannot find an area with that name');
                    Exit;
               END;

               ReadAreaBaseRecord (AreaLp,AreaRec);
               IF (NOT AreaRec.Deleted) AND TestIfInGroup (AreaRec.IsInGroups,Group_NewAreas) THEN
               BEGIN
                    { found it! Let's move it }
                    DeleteGroupFromGroupList (AreaRec.IsInGroups,Group_NewAreas);
                    GroupLp:=Ord (GroupCh)-Ord ('A')+1;
                    AddGroupToGroupList (AreaRec.IsInGroups,GroupLp);
                    WriteAreaBaseRecord (AreaLp,AreaRec);
                    AddToLineBuffer (LineBuffer,'  Moved area '+AreaRec.AreaName_U+' to group '+GroupCh);
                    LogMessage ('Area '+AreaRec.AreaName_U+' was moved to group '+GroupCh);
                    Exit;
               END;

               AddToLineBuffer (LineBuffer,'  Area was deleted or already moved out of group Z');
               Exit;
          END;

          IF (Keyword = '%DELNEW') THEN
          BEGIN
               IF (NOT UserInfo.AllowFrom) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Access denied');
                    Exit;
               END;

               IF (UserInfo.System = _U) THEN
                  AreaLp:=GetAreaBaseRecordNrByAreaName_U (Regel)
               ELSE
                   AreaLp:=GetAreaBaseRecordNrByAreaName_F (Regel);

               IF (AreaLp = NILRecordNr) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'  Cannot find an area with that name');
                    Exit;
               END;

               ReadAreaBaseRecord (AreaLp,AreaRec);
               IF (NOT AreaRec.Deleted) AND TestIfInGroup (AreaRec.IsInGroups,Group_NewAreas) THEN
               BEGIN
                    AreaRec.Deleted:=TRUE;
                    WriteAreaBaseRecord (AreaLp,AreaRec);
                    AddToLineBuffer (LineBuffer,'  Deleted area '+AreaRec.AreaName_U);
                    LogMessage ('Area '+AreaRec.AreaName_U+' was deleted (was in group Z)');
                    Exit;
               END;

               AddToLineBuffer (LineBuffer,'  Area was already deleted or moved out of group Z');
               Exit;
          END;

          { unknown }
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2010));
          Exit;
     END; { Regel[1] = '%' }

     IF IgnoreCommand THEN
     BEGIN
          { ignoring }
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2019));
          Exit;
     END;

     IF Config.LogAreaFix THEN
        LogMessage ('Processing '+Regel);

     { '-' AREANAME or '!' AREANAME sluit de area effectief af ... }
     IF (Regel[1] IN ['!','-']) THEN
     BEGIN
          Delete (Regel,1,1);

          { RWI 960304: ondersteunt nu ook +<spatie>areaname }
          IF (Regel[1] = ' ') THEN
             Delete (Regel,1,1);

          { RWI 961001: we ondersteunen nu ook -areaname omschrijving }
          IF (Pos (' ',Regel) > 0) THEN
             Regel:=Copy (Regel,1,Pos (' ',Regel)-1);

          { Bestaat de area ? }
          IF (UserInfo.System = _U) THEN
             AreaLp:=GetAreaBaseRecordNrByAreaName_U (Regel)
          ELSE
              AreaLp:=GetAreaBaseRecordNrByAreaName_F (Regel);

          IF (AreaLp = NILRecordNr) THEN
          BEGIN
               { cannot find area with that name }
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2020));

               IF Config.LogAreaFix THEN
                  LogExtraMessage ('  Unknown area');

               Exit;
          END;

          ReadAreaBaseRecord (AreaLp,AreaRec);

          { is de gebruiker er wel op aangesloten ? }
          IF (NOT TestIfUserIsInAreaRec_UserList (AreaRec.UserList,UserInfoRecNr)) THEN
          BEGIN
               { Nee dus }
               {You are not connected to that area; no need to disconnect');}
               AddToLineBuffer (LineBuffer,'  '+GetLang0 (2021));

               IF Config.LogAreaFix THEN
                  LogExtraMessage ('  Not connected');

               Exit;
          END;

          { Alles overleeft, sluit de area nu maar af }
          RemoveUserFromAreaSubscrList (AreaRec,UserInfoRecNr);
          WriteAreaBaseRecord (AreaLp,AreaRec);

          RemoveAreaFromUserSubscrToList (UserInfo,AreaLp);
          WriteUserBaseRecord (UserInfoRecNr,UserInfo);

          { disconnected }
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2022));

          IF Config.LogAreaFix THEN
             LogExtraMessage ('  Disconnected');

          CheckIfAreaCanGoPassive (AreaRec,AreaLp);

          Exit;
     END; { einde delete }

     { Add User To Area }

     { Een plusje voor een Area betekent ook Connect-me-please }
     IF (Regel[1] = '+') THEN
     BEGIN
          Delete (Regel,1,1);

          { RWI 960304: ondersteunt nu ook +<spatie>areaname }
          IF (Regel[1] = ' ') THEN
             Delete (Regel,1,1);
     END;

     { Commando's zijn boven afgevangen, alles wat er nu nog over is }
     { moeten wel Area Connect requests zijn.                        }

     { RWI 961001: we ondersteunen nu ook -areaname omschrijving }
     IF (Pos (' ',Regel) > 0) THEN
        Regel:=Copy (Regel,1,Pos (' ',Regel)-1);

     { Bestaat de area ? }
     IF (UserInfo.System = _U) THEN
        AreaLp:=GetAreaBaseRecordNrByAreaName_U (Regel)
     ELSE
         AreaLp:=GetAreaBaseRecordNrByAreaName_F (Regel);

     (* RWI 960126: re-enabled areafix forwarding!
     IF (AreaLp = NILRecordNr) THEN
     BEGIN
          {Cannot find an area with that name');}
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2020));

          IF Config.LogAreaFix THEN
             LogExtraMessage ('  Unknown area');

          Exit;
     END;
     *)

     IF (AreaLp = NILRecordNr) THEN
     BEGIN
          { Probeer 'm aan te maken }
          CASE AreaFixCheckForward (Regel) OF
               0 : BEGIN
                        {Cannot find an area with that name');}
                        { ... nor request it from an uplink }
                        AddToLineBuffer (LineBuffer,'  '+GetLang0 (2020));
                        IF Config.LogAreaFix THEN
                           LogExtraMessage ('  Not found (not in forwarding tables)');
                   END;

               1 : BEGIN
                        {Connected + requested from Fido uplink');}
                        AddToLineBuffer (LineBuffer,'  '+GetLang1 (2023,'Fido'));
                        IF Config.LogAreaFix THEN
                           LogExtraMessage ('  Connected + requested from Fido uplink');
                   END;

               2 : BEGIN
                        {Connected + requested from UUCP uplink');}
                        AddToLineBuffer (LineBuffer,'  '+GetLang1 (2023,'UUCP'));
                        IF Config.LogAreaFix THEN
                           LogExtraMessage ('  Connected + requested from UUCP uplink');
                   END;
          END; { case }

          Exit;
     END;

     ReadAreaBaseRecord (AreaLp,AreaRec);

     { Bingo, we hebben hier dus een geldige areaname (!) en iemand  }
     { die 'm wil lezen.. wat kunnen we nog verzinnen om hem/haar te }
     { blokkeren ?                                                   }

     { Is de area Hidden? }
     IF AreaRec.Hidden THEN
     BEGIN
          {Cannot find an area with that name');}
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2020));

          IF Config.LogAreaFix THEN
             LogExtraMessage ('  Hidden area');

          Exit;
     END;

     { Is hij/zij al aangesloten ? }
     IF TestIfUserIsInAreaRec_UserList (AreaRec.UserList,UserInfoRecNr) THEN
     BEGIN
          { ja! <huhu;> }
          {You are already connected to that area');}
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2024)); { RWI 960220: foutief was 2023 }

          IF Config.LogAreaFix THEN
             LogExtraMessage ('  Already connected');

          Exit;
     END;

     { We nemen hier de rechten van degene die het bericht verzonden heeft }
     IF (NOT TestIfGroupCommon (UserInfo.Groups,AreaRec.IsInGroups)) THEN
     BEGIN
          {You are not allowed to connect to that area');}
          AddToLineBuffer (LineBuffer,'  '+GetLang0 (2025));

          IF Config.LogAreaFix THEN
             LogExtraMessage ('  Not allowed (groupwise)');

          Exit;
     END;

     CheckIfAreaHasToGoNonePassive (AreaRec,AreaLp);

     { Sluit de Area aan voor de user }
     AddUserToAreaSubscrList (AreaRec,UserInfoRecNr);
     WriteAreaBaseRecord (AreaLp,AreaRec);

     AddAreaToUserSubscrToList (UserInfo,AreaLp);
     WriteUserBaseRecord (UserInfoRecNr,UserInfo);

     AddToLineBuffer (LineBuffer,'  '+GetLang0 (2026));

     IF Config.LogAreaFix THEN
        LogExtraMessage ('  Connected');
END;


{---------------------------------------------------------------------------}
{ FidoAreafix                                                               }
{                                                                           }
{ Deze routine verwerkt een areafix fido-style areafix verzoek en kan daar  }
{ in netmail een reactie op schrijven.                                      }
{                                                                           }
PROCEDURE FidoAreafix;

CONST ERR_REFUSED = 'Refused AreaFix request from unknown system';

VAR FromAd,ToAd    : FidoAddrType;
    SenderName     : STRING[MaxLenFromUser_F];
    OurPassword,
    AF_Password    : STRING[MaxLenAreaFixPwd];
    Regel          : STRING;
    EenRegelPtr    : EenRegelRecordPtr;
    SwapPos        : LONGINT;

BEGIN
     FromAd:=Msg.FromAddr_F;
     ToAd:=Msg.ToAddr_F;
     SenderName:=Msg.FromUser_F;
     InitTokens (_F{Fido});

     IF (NOT FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserInfoRecNr)) THEN
     BEGIN
          { verkeerde gebruiker, retour aan de SYSOP van het systeem }
          LogMessage (ERR_REFUSED+' '+Fido2Str (Msg.FromAddr_F)+' '+Msg.FromUser_F);

          { we schrijven dit aan 'Sysop', omdat we geen user naam hebben }
          { en als we het naar de zender terug sturen, kan iemand buiten }
          { de sysop om dingen gaan proberen. Nu komt de sysop erachter. }
          { ofzo...                                                      }
          FidoBuildNetmail (TRUE,ToAd,FromAd,Config.AreafixName,'Sysop',
                            Config.AreafixName+' failure');
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL{sent};

          { voeg een standaard antwoord file of lijn toe aan het bericht }
          IF (NOT AddFileToMsg (Msg.BodyTop,'UNKAFUSR.TXT')) THEN
          BEGIN
               MsgsAddlineTo (Body,#13+ERR_REFUSED);
               MsgsAddlineTo (Body,'Requesting user: '+SenderName+#13);
          END;

          FidoRouteNetmail;
          Exit; { klaar }
     END;

     LogMessage ('Processing AreaFix request from '+Fido2Str (Msg.FromAddr_F)+' '+Msg.FromUser_F);

     { lees het record van deze bekende gebruiker in }
     ReadUserBaseRecord (UserInfoRecNr,UserInfo);

     { nog niets aangevraagd }
     RequestedQuery:=FALSE;
     RequestedList:=FALSE;
     RequestedHelp:=FALSE;

     IgnoreCommand:=FALSE; { nodig bij invalid %FROM }

     { hierin slaan we de reactie op }
     ClearLineBuffer (LineBuffer);

     Msg.Subj_F:=UpCaseString (Msg.Subj_F); { upcase ook voor -Q en -L }

     { Kijk of er nog 'stone age' vlaggen achter staan }
     IF (Pos ('-Q',Msg.Subj_F) > 0) THEN
        RequestedQuery:=TRUE;

     IF (Pos ('-L',Msg.Subj_F) > 0) THEN
        RequestedList:=TRUE;

     IF (Pos ('-H',Msg.Subj_F) > 0) THEN
        RequestedHelp:=TRUE;

     { snij het password uit de subject lijn }
     IF (Pos (' ',Msg.Subj_F) <> 0) THEN
        AF_Password:=Copy (Msg.Subj_F,1,Pos (' ',Msg.Subj_F)-1)
     ELSE
         AF_Password:=DeleteBackSpaces (Copy (Msg.Subj_F,1,MaxLenAreaFixPwd));

     { voeg het token 'Password' toe }
     SetToken (PassWord,AF_Password);

     { controleer of het password wel goed is }
     OurPassword:=UpCaseString (DeleteBackSpaces (UserInfo.AreaFixPwd));
     IF NOT ((OurPassword = '') OR (AF_Password = OurPassword)) THEN
     BEGIN
          { ongeldig password! }
          LogMessage ('AreaFix: Bad password. Found: "'+AF_Password+'"; UserBase: "'+OurPassword+'"');

          { schrijf een briefje terug }
          FidoBuildNetmail (TRUE,ToAd,FromAd,Config.AreafixName,UserInfo.Sysop,
                            Config.AreafixName+' failure');
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL;

          IF (NOT AddFileToMsg (Msg.BodyTop,'WRNGAPWD.TXT')) THEN
             {'Incorrect password "'+AF_Password+'"; refusing areafix request.');}
             MsgsAddLineTo (Body,#13+GetLang2 (2027,AF_Password,Config.AreafixName));

          FidoRouteNetmail;
          Exit; { klaar }
     END;

     { oke, toegang verleend. Verwerk nu de commando's die in de body staan }

     { pak de eerste regel van de body }
     IF (Msg.BodyTop <> NIL) THEN
        EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr
     ELSE
         EenRegelPtr:=NIL;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,Regel[0],1);

                        IF (Regel[0] = #0) THEN
                        BEGIN
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                   END;
          END; { case }

          IF SwapIsOpen THEN
             SwapPos:=FilePos (SwapFile);

          { stop at tear-line }
          IF (Regel = '---') OR (Regel = '---'+#13) OR (Copy (Regel,1,4) = '--- ') THEN
             Break;

          ProcessFixLine (Regel);

          IF SwapIsOpen THEN
             Seek (SwapFile,SwapPos);
     END;

     { stuur de opgebouwde reactie (als die er is) terug }
     IF (LineBuffer <> NIL) THEN
     BEGIN
          { er is een reactie }
          AddToLineBuffer (LineBuffer,'');  { lege regel }

          FidoBuildNetmail (TRUE,ToAd,UserInfo.Address,Config.AreafixName,
                            SenderName,GetLang1 (2035,Config.AreafixName));
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL{/sent};

          MsgsReleaseLines (Msg.BodyTop);
          Msg.BodyTop:=LineBuffer; { lekker rap }
          LineBuffer:=NIL; { zorg dat ie niet nog een keer wordt gewist! }

          MsgsAddLineTo (Body,'');
          { end of x response }
          MsgsAddLineTo (Body,GetLang1 (2031,Config.AreafixName));

          FidoRouteNetmail;
     END;

     { werk de vlaggen af }
     IF RequestedQuery THEN
     BEGIN
          LogMessage ('Writing areafix query message');
          FidoBuildNetmail (TRUE,ToAd,UserInfo.Address,Config.AreafixName,
                            SenderName,GetLang1 (2028,Config.AreafixName));
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL{/sent};

          BuildQuery;
          Msg.BodyTop:=LineBuffer; { nieuwe body, lekker rap }
          LineBuffer:=NIL; { voorkom verneuken bericht door ClearLineBuffer ofzo }

          FidoRouteNetmail;
     END;

     IF RequestedList THEN
     BEGIN
          LogMessage ('Writing areafix list message');
          FidoBuildNetmail (TRUE,ToAd,UserInfo.Address,Config.AreafixName,
                            SenderName,GetLang1 (2029,Config.AreafixName));
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL{/sent};

          BuildList;
          Msg.BodyTop:=LineBuffer; { nieuwe body, lekker rap }
          LineBuffer:=NIL; { voorkom verneuken bericht door ClearLineBuffer ofzo }

          FidoRouteNetmail;
     END;

     IF RequestedHelp THEN
     BEGIN
          LogMessage ('Writing areafix help message');

          FidoBuildNetmail (TRUE,ToAd,UserInfo.Address,Config.AreafixName,
                            SenderName,GetLang1 (2030,Config.AreafixName));
          Msg.Attr_F:=Msg.Attr_F OR MSGKILL{/sent};

          IF (NOT AddFileToMsg (Msg.BodyTop,'AREAFIX.TXT')) THEN
          BEGIN
               MsgsAddLineTo (Body,#13'From: '+AddUpWithSpaces (17,'John Doe')+'2:280/802.9996');
               MsgsAddLineTo (Body,   'To  : '+AddUpWithSpaces (17,Config.AreafixName)+'2:280/802');
               MsgsAddLineTo (Body,   'Subj: My_Areafix_Password');

               MsgsAddLineTo (Body,#13'+AREANAME       this will connect an area');
               MsgsAddLineTo (Body,   '-AREANAME       this will disconnect an area');
               MsgsAddLineTo (Body,   '%LIST           this will list all areas you have connected');
               MsgsAddLineTo (Body,   '%QUERY          this will list all areas available to you');
               MsgsAddLineTo (Body,   '%PASSWORD <pwd> change your '+Config.AreafixName+' password');
               MsgsAddLineTo (Body,   '%PKTPWD <pwd>   Change .PKT password');
               MsgsAddLineTo (Body,   '%COMPRESS <opt> change your compression program to one of the following:');
               MsgsAddLineTo (Body,   '                ARC ARJ LZH PAK ZIP ZOO RAR PKT');
               MsgsAddLineTo (Body,   '%PASSIVE        Don''t distribute messages to me anymore');
               MsgsAddLineTo (Body,   '%ACTIVE         Start distributing to me again');

               IF UserInfo.AllowFrom THEN
               BEGIN
                    MsgsAddLineTo (Body,'');
                    MsgsAddLineTo (Body,'Special commands:');
                   {MsgsAddLineTo (Body,'%FROM           Change identity');}
                    MsgsAddLineTo (Body,'%LISTNEW        List all areas in group Z');
                    MsgsAddLineTo (Body,'%MOVENEW <grp> <area>');
                    MsgsAddLineTo (Body,'                Move <area> from group Z to group <grp>');
                    MsgsAddLineTo (Body,'%DELNEW <area>  Delete <area> from group Z');
                    MsgsAddLineTo (Body,'%GROUPS         List all available groups + descriptions');
               END;
          END;

          FidoRouteNetmail;
     END;
END;


{---------------------------------------------------------------------------}
{ UUCPNewsfix                                                               }
{                                                                           }
{ Deze routine verwerkt een newsfix verzoek van een uucp user en kan daar   }
{ in uucp mail formaat een reactie op produceren.                           }
{                                                                           }
PROCEDURE UUCPAreafix;

VAR FromAd,
    ReplyAd,
    HulpName,
    Regel       : STRING;
    User        : UsenetUserNameString;
    Domain      : UsenetDomainNameString;
    Process,
    Found       : BOOLEAN;
    ULp         : UserBaseRecordNrType;
    DLp         : 1..MaxDomains;
    EenRegelPtr : EenRegelRecordPtr;
    OurPwd,
    HisPwd      : STRING[MaxLenAreaFixPwd];
    DateTime    : STRING[25];
    SwapPos     : LONGINT;

    PROCEDURE WriteReply (Subject : STRING; AddEmptyLines : BOOLEAN);
    BEGIN
         MsgsEmptyKeepSwapfile;   { LineBuffer kan de swapfile gebruiken }
         Msg.BodyTop:=LineBuffer; { nieuwe body, lekker rap }
         LineBuffer:=NIL;         { voorkom verneuken bericht door ClearLineBuffer ofzo }

         DateTime:=FidoCurrTime2Str;
         Delete (DateTime,Pos ('  ',DateTime),1); { dubbele spatie tussen ymd en hms }
         DateTime:=DateTime+' '+Config.TimeZone;

         Msg.ToUser_U:='To: '+HulpName; { RWI 960928: added "To: " }
         Msg.XqtTo_U:=ReplyAd;

         MsgsAddLineTo (Header_U,'From '+ProgramUserName+'  '+DateTime+' remote from '+Config.UUCPName);
         MsgsAddLineTo (Header_U,'Received: by '+Config.Domains[1]+' ('+Copy (FidoTear,5,255)+')');
         MsgsAddLineTo (Header_U,'          via UUCP; '+DateTime);
         MsgsAddLineTo (Header_U,'          for '+HulpName);
         MsgsAddLineTo (Header_U,'From: '+Config.NewsfixName+'@'+Config.Domains[1]);
         MsgsAddLineTo (Header_U,'Date: '+DateTime);
         MsgsAddLineTo (Header_U,'Message-ID: <'+GetFidoPktName+'@'+ProgramUserName+'.'+Config.Domains[1]+'>');
         MsgsAddLineTo (Header_U,+Msg.ToUser_U); {'To: '+Msg.ToUser_U); RWI960928}
         MsgsAddLineTo (Header_U,'Subject: '+Subject);
         IF AddEmptyLines THEN
         BEGIN
              MsgsAddLineTo (Header_U,''); { verplicht }

              MsgsAddLineTo (Body,''); { na de streepel lijn bijvoorbeeld }
         END;
         MsgsAddLineTo (Body,GetLang1 (2031,Config.NewsfixName));

         UsenetRouteMail;
    END;

{ UUCPAreaFix }
BEGIN
     { nog niets aangevraagd }
     RequestedQuery:=FALSE;
     RequestedList:=FALSE;
     RequestedHelp:=FALSE;

     IgnoreCommand:=FALSE; { nodig bij invalid %FROM }

     Process:=TRUE; { assume dat we zijn bericht verwerken }

     ClearLineBuffer (LineBuffer); { hierin slaan we de reactie op }

     { systeem naam opzoeken }
     HulpName:=UseGetAddress (Copy (Msg.FromUser_U,7,255));
     LogMessage ('Processing NewsFix request from '+HulpName);

     UsenetSplit (HulpName,Domain,User);
     Domain:=UpCaseString (Domain);

     IF (Domain = '') THEN
     BEGIN
          LogMessage ('NewsFix: cannot extract sending systems'' domain name');
          AddToLineBuffer (LineBuffer,GetLang1 (2032,Config.NewsfixName));
          Process:=FALSE;
     END ELSE
     BEGIN
          { ga het systeem controleren }

          { opzoeken in de UserBase ahv de domain naam }
          Found:=FALSE;
          FOR ULp:=1 TO UserBaseRecCount DO
          BEGIN
               ReadUserBaseRecord (ULp,UserInfo);

               IF (NOT UserInfo.Deleted) THEN
               BEGIN
                    FOR DLp:=1 TO MaxDomains DO
                        IF (Domain = UpCaseString (UserInfo.Domains[DLp])) THEN
                        BEGIN
                             UserInfoRecNr:=ULp; { RWI 950218: even vergeten... krijg je opeens verkeerd geroute mail... }
                             Found:=TRUE;
                             Break; { uit de DLp }
                        END;
               END;

               IF Found THEN
                  Break; { uit de ULp }
          END; { for ULp }

          { gevonden?, dan password controleren }
          IF Found THEN
          BEGIN
               { checken of het password wel klopt }
               Regel:=UpCaseString (Copy (Msg.Subj_U,Pos (' ',Msg.Subj_U)+1,255));

               IF (Pos ('-Q',Regel) > 0) THEN
                  RequestedQuery:=TRUE;

               IF (Pos ('-L',Regel) > 0) THEN
                  RequestedList:=TRUE;

               IF (Pos ('-H',Regel) > 0) THEN
                  RequestedHelp:=TRUE;

               IF (Pos (' ',Regel) > 0) THEN
                  HisPwd:=Copy (Regel,1,Pos (' ',Regel)-1)
               ELSE
                   HisPwd:=Regel;

               OurPwd:=UpCaseString (UserInfo.AreaFixPwd);

               IF (NOT ((OurPwd = '') OR (HisPwd = OurPwd))) THEN
               BEGIN
                    { niet dus }
                    LogMessage ('NewsFix: Bad password. Found: "'+HisPwd+'"; UserBase: "'+OurPwd+'"');
                    Process:=FALSE;

                    IF (NOT AddFileToMsg (LineBuffer,'WRNGAPWD.TXT')) THEN
                       AddToLineBuffer (LineBuffer,GetLang2 (2027,HisPwd,Config.NewsfixName));
               END;

          END; { found system in userbase }

          IF (NOT Found) THEN
          BEGIN
               UsenetSplit (HulpName,Domain,User); { domain terug naar lowcase }
               LogMessage ('NewsFix: domain "'+Domain+'" not found in userbase.');
               {'Unknown system; refusing NewsFix request.');}
               AddToLineBuffer (LineBuffer,GetLang1 (2032,Config.NewsfixName));
               Process:=FALSE;
          END;
     END; { einde systeem controle }

     IF (NOT Process) THEN
     BEGIN
          AddToLineBuffer (LineBuffer,''); { tussen foutmelding en --- regel }
          AddToLineBuffer (LineBuffer,GetLang0 (2033));
     END;

     IF (Msg.BodyTop^.FirstRegelRecordPtr = NIL) THEN
        EenRegelPtr:=NIL
     ELSE
         EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,Regel[0],1);

                        IF (Regel[0] = #0) THEN
                        BEGIN
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                   END;
          END; { case }

          IF (Copy (Regel,1,3) = '-- ') THEN
             Break; { signature tear-line -> kappen! (while) }

          IF SwapIsOpen THEN
             SwapPos:=FilePos (SwapFile);

          IF (NOT Process) THEN
             AddToLineBufferNoEOL (LineBuffer,'-->'+Regel)
          ELSE
              ProcessFixLine (Regel);

          IF SwapIsOpen THEN
             Seek (SwapFile,SwapPos);
     END; { while }

     IF (NOT Process) THEN
        AddToLineBuffer (LineBuffer,GetLang0 (2034));

     { nu een berichtje terug schrijven }
     ReplyAd:=UsenetReplyAdres; { uit Msg halen }

     { schrijf de standaard reply }
     WriteReply (GetLang1 (2035,Config.NewsfixName),TRUE);

     IF RequestedQuery THEN
     BEGIN
          LogMessage ('Writing newsfix query message');
          BuildQuery;
          WriteReply (GetLang1 (2028,Config.NewsfixName),FALSE{geen extra lege regels nodig});
     END;

     IF RequestedList THEN
     BEGIN
          LogMessage ('Writing newsfix list message');
          BuildList;
          WriteReply (GetLang1 (2029,Config.NewsfixName),FALSE);
     END;

     IF RequestedHelp THEN
     BEGIN
          LogMessage ('Writing newsfix help message');
          IF (NOT AddFileToMsg (LineBuffer,'NEWSFIX.TXT')) THEN
          BEGIN
               AddToLineBuffer (LineBuffer,'From: '+HulpName);
               AddToLineBuffer (LineBuffer,'To: '+Config.NewsfixName+'@'+Config.Domains[1]);
               AddToLineBuffer (LineBuffer,'Subject: My_NewsFix_Password');
               AddToLineBuffer (LineBuffer,'');
               AddToLineBuffer (LineBuffer,'+AREANAME       this will connect an area');
               AddToLineBuffer (LineBuffer,'-AREANAME       this will disconnect an area');
               AddToLineBuffer (LineBuffer,'%LIST           this will list all areas you have connected');
               AddToLineBuffer (LineBuffer,'%QUERY          this will list all areas available to you');
               AddToLineBuffer (LineBuffer,'%PASSWORD <pwd> change your '+Config.NewsfixName+' password');
               AddToLineBuffer (LineBuffer,'%COMPRESS <opt> set compression. Options: NONE, COMPRESS, GZIP');
               AddToLineBuffer (LineBuffer,'%CUNBATCH <opt> set cunbatch. Options: ON, OFF');
               AddToLineBuffer (LineBuffer,'%PASSIVE        Don''t distribute messages to me anymore');
               AddToLineBuffer (LineBuffer,'%ACTIVE         Start distributing to me again');

               IF UserInfo.AllowFrom THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'');
                    AddToLineBuffer (LineBuffer,'Special commands:');
                   {AddToLineBuffer (LineBuffer,'%FROM           Change identity');}
                    AddToLineBuffer (LineBuffer,'%LISTNEW        List all areas in group Z');
                    AddToLineBuffer (LineBuffer,'%MOVENEW <grp> <area>');
                    AddToLineBuffer (LineBuffer,'                Move area from group Z to group <grp>');
                    AddToLineBuffer (LineBuffer,'%DELNEW <area>  Delete area from group Z');
                    AddToLineBuffer (LineBuffer,'%GROUPS         List available groups + names');
               END;
          END;

          WriteReply (GetLang1 (2030,Config.NewsfixName),TRUE);
     END;
END;

END.

(* niet meer nodig... RWI 950821
{==========================================================================}
{                   SORTED AREA LISTING ROUTINES                           }
{==========================================================================}

{--------------------------------------------------------------------------}
{ CreateSortedAreaListing                                                  }
{                                                                          }
{ Deze routine creert een filetje op disk dat gebruikt wordt om areanamen  }
{ te sorteren. Omdat deze lijst potentieel erg groot is (6000*60=360Kb)    }
{ moet dat op disk gebeuren.                                               }
{                                                                          }
FUNCTION CreateSortedAreaListing : BOOLEAN;
BEGIN
      Assign (SortedAreaFile,Config.SystemDir+'AREALST.$$$');
      {$I-} ReWrite (SortedAreaFile,1); {$I+}
      PeekFiles;
      CreateSortedAreaListing:=(IOResult = 0);
END;


{--------------------------------------------------------------------------}
{ ReadAreaListingRecord                                                    }
{                                                                          }
{ Deze routine leest een record van de binaire tree met area namen in uit  }
{ de file op disk.                                                         }
{                                                                          }
FUNCTION ReadAreaListingRecord (AreaNr : LONGINT; VAR Entry : SortedEntryType) : BOOLEAN;
BEGIN
     {$I-}
     Seek (SortedAreaFile,AreaNr);
     BlockRead (SortedAreaFile,Entry,SizeOf (SortedEntryType));
     {$I+}
     ReadAreaListingRecord:=(IOResult = 0);
END;


{--------------------------------------------------------------------------}
{ WriteAreaListingRecord                                                   }
{                                                                          }
{ Deze routine schrijft een record naar de file waarin de binaire tree van }
{ gesorteerde area namen staat.                                            }
{                                                                          }
FUNCTION WriteAreaListingRecord (AreaNr : LONGINT; VAR Entry : SortedEntryType) : BOOLEAN;
BEGIN
     {$I-}
     Seek (SortedAreaFile,AreaNr);
     BlockWrite (SortedAreaFile,Entry,SizeOf (SortedEntryType));
     {$I+}
     WriteAreaListingRecord:=(IOResult = 0);
END;


{--------------------------------------------------------------------------}
{ AddItemToAreaListing                                                     }
{                                                                          }
{ Deze routine voegt een area informatie record toe aan de lijst op disk   }
{ De lijst is een binaire boom, waarop wat optimalisaties worden           }
{ losgelaten om ervoor te zorgen dat dit zo snel mogelijk gebeurd.         }
{                                                                          }
FUNCTION AddItemToAreaListing (Group : CHAR; AreaName : AreaNameString; AreaRecNr : AreaBaseRecordNrType) : BOOLEAN;

VAR PrevRecNo,
    CurrentRecNo : LONGINT;
    NewEntry,
    DiskEntry    : SortedEntryType;

BEGIN
     { Zoek in de file op disk naar een record waar we het nieuwe record }
     { aan kunnen verbinden. Het is een binaire boom op disk, dus steeds }
     { vergelijken of we links of rechts willen sorteren.                }
     AddItemToAreaListing:=FALSE;

     { group letter voor de areaname zetten. Daardoor wordt de lijst ook }
     { op groep gesorteerd. Die group letter gaat er later weer vanaf.   }
     AreaName:=Group+AreaName;

     {$I-}
     Seek (SortedAreaFile,0);
     CurrentRecNo:=0;
     PrevRecNo:=$FFFFFFFF;

     WHILE (NOT Eof (SortedAreaFile)) DO
     BEGIN
          PrevRecNo:=CurrentRecNo;

          IF (NOT ReadAreaListingRecord (CurrentRecNo,DiskEntry)) THEN
             Exit;

          IF (AreaName < DiskEntry.Area) THEN
          BEGIN
               IF (DiskEntry.LowerRec = 0) THEN
               BEGIN
                    DiskEntry.LowerRec:=FileSize (SortedAreaFile);
                    WriteAreaListingRecord (CurrentRecNo,DiskEntry);
                    CurrentRecNo:=DiskEntry.LowerRec;
                    Break; { uit de while }
               END;

               CurrentRecNo:=DiskEntry.LowerRec;
               Continue; { RWI 941106: added }
          END;

          IF (AreaName > DiskEntry.Area) THEN
          BEGIN
               IF (DiskEntry.HigherRec = 0) THEN
               BEGIN
                    DiskEntry.HigherRec:=FileSize (SortedAreaFile);
                    WriteAreaListingRecord (CurrentRecNo,DiskEntry);
                    CurrentRecNo:=DiskEntry.HigherRec;
                    Break; { uit de while }
               END;

               CurrentRecNo:=DiskEntry.HigherRec;
          END;
     END; { while }

     { We zijn aan het einde van de file gekomen, op dit punt moeten }
     { waar we een nieuw record op disk moeten schrijven.            }
     WITH NewEntry DO
     BEGIN
          PrevRec:=PrevRecNo;
          HigherRec:=0;
          LowerRec:=0;
          Area:=AreaName;
          ARecNr:=AreaRecNr;
     END;

     {$I+}
     AddItemToAreaListing:=WriteAreaListingRecord (CurrentRecNo,NewEntry);
END;


{---------------------------------------------------------------------------}
{ AddAreaListingToMessage                                                   }
{                                                                           }
{ Deze routine voegt de gesorteerde lijst met areas toe aan het bericht dat }
{ naar de user gaat.                                                        }
{                                                                           }
PROCEDURE AddAreaListingToMessage;

VAR SaveRecNr,
    CurRecNr  : LONGINT;
    DiskEntry : SortedEntryType;
    HulpStr   : STRING;
    ZoekPos   : BYTE;
    Group,
    PrevGroup : CHAR;
    AreaInfo  : AreaBaseRecord;
    GroupRec  : GroupDescRecord;

BEGIN
     { wandel door de file op disk heen als door een binaire boom }
     {$I-} Seek (SortedAreaFile,0); {$I+}
     CurRecNr:=0;
     PrevGroup:=' ';

     WHILE TRUE DO
     BEGIN
          IF (NOT ReadAreaListingRecord (CurRecNr,DiskEntry)) THEN
          BEGIN
               IF (PrevGroup = ' ') THEN
                  AddToLineBuffer (LineBuffer,'  No areas found')
               ELSE
                   AddToLineBuffer (LineBuffer,'  System error; area listing aborted!');
               Exit;
          END;

          { Kijk eerst of we links kunnen springen }
          IF (DiskEntry.LowerRec > 0) THEN
          BEGIN
               SaveRecNr:=CurRecNr;
               CurRecNr:=DiskEntry.LowerRec;
               DiskEntry.LowerRec:=0;
               WriteAreaListingRecord (SaveRecNr,DiskEntry);
               Continue; { while }
          END;

          { Geen ontkomen aan, filen met die hap }
          WITH DiskEntry DO
               IF (LowerRec = 0) AND (ARecNr <> 65535{not already processed}) THEN
               BEGIN
                    Group:=Area[1];
                    Delete (Area,1,1);

                    IF (Group <> PrevGroup) THEN
                    BEGIN
                         AddToLineBuffer (LineBuffer,'');

                         IF (Group IN ['A'..'Z']) THEN
                         BEGIN
                              ReadGroupDescRecord (Ord (Group)-Ord ('A')+1,GroupRec);
                              AddToLineBuffer (LineBuffer,'Group '+Group+': '+DeleteBackSpaces (GroupRec.GroupDesc));
                         END ELSE
                             AddToLineBuffer (LineBuffer,'Group '+Group+':');

                         AddToLineBuffer (LineBuffer,'');
                         PrevGroup:=Group;
                    END;

                    IF (ARecNr = 0) THEN
                       AddToLineBuffer (LineBuffer,Area)
                    ELSE BEGIN
                         ReadAreaBaseRecord (ARecNr,AreaInfo);
                         HulpStr:=DeleteFrontAndBackSpaces (AreaInfo.Comment);

                         IF (HulpStr = '') THEN
                            AddToLineBuffer (LineBuffer,Area)
                         ELSE
                             { commentaar erachter plaatsen als de areaname }
                             { kleiner is dan 40 tekens, anders commentaar  }
                             { op de volgende regel zetten.                 }
                             IF (Length (Area) <= 30) THEN
                             BEGIN
                                  { als er een commentaar regel is, dan toevoegen }
                                  HulpStr:=AddUpWithSpaces (30,Area)+' - '+HulpStr;

                                  { lijn splitsen bij te lang }
                                  IF (Length (HulpStr) > 79) THEN
                                  BEGIN
                                       ZoekPos:=79;
                                       WHILE (HulpStr[ZoekPos] <> ' ') DO
                                             Dec (ZoekPos);

                                       AddToLineBuffer (LineBuffer,DeleteBackSpaces (Copy (HulpStr,1,ZoekPos)));
                                       AddToLineBuffer (LineBuffer,
                                                        Spaces (33)+DeleteFrontSpaces (Copy (HulpStr,ZoekPos+1,255)));
                                  END ELSE
                                      AddToLineBuffer (LineBuffer,HulpStr);
                             END ELSE
                             BEGIN
                                  { Area Name is langer dan 40 tekens, dus }
                                  { commentaar begint pas op de volgende   }
                                  { regel. Als er commentaar is tenminste  }
                                  AddToLineBuffer (LineBuffer,Area);

                                  HulpStr:=Spaces (31)+'- '+HulpStr;
                                  IF (Length (HulpStr) > 79) THEN
                                  BEGIN
                                       { te lang voor op 1 regel, dus maken }
                                       { we er twee regels van.             }
                                       ZoekPos:=79;
                                       WHILE (HulpStr[ZoekPos] <> ' ') DO
                                             Dec (ZoekPos);

                                       AddToLineBuffer (LineBuffer,DeleteBackSpaces (Copy (HulpStr,1,ZoekPos)));
                                       AddToLineBuffer (LineBuffer,
                                                        Spaces (33)+DeleteFrontSpaces (Copy (HulpStr,ZoekPos+1,255)));
                                  END ELSE
                                      AddToLineBuffer (LineBuffer,HulpStr);
                             END; { area name langer dan 40 tekens }
                    END; { commentaar toevoegen }

                    ARecNr:=65535; { processed }
               END; { if, with }

          { Kijk daarna of we rechts kunnen springen }
          IF (DiskEntry.HigherRec > 0) THEN
          BEGIN
               SaveRecNr:=CurRecNr;
               CurRecNr:=DiskEntry.HigherRec;
               DiskEntry.HigherRec:=0;
               WriteAreaListingRecord (SaveRecNr,DiskEntry);
               Continue; { while }
          END;

          { En spring een verdieping hoger }
          { Als dat tenminste kan.         }
          IF (DiskEntry.PrevRec = $FFFFFFFF) THEN
             Break; { einde, spring uit de while true }

          CurRecNr:=DiskEntry.PrevRec;
     END; { while true }

     { Verwijder de file van disk }
     Close (SortedAreaFile);
     PeekFiles;
     Erase (SortedAreaFile);
END;
*)
