{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Cfg;

{ Deze unit bevat de routines om de configuratie file in te lezen, aan te  }
{ passen met een custom-editor en terug te schrijven naar disk als er iets }
{ aan veranderd is.                                                        }

INTERFACE

USES Ramon,
     Database,
     Msgs,
     AreaMgr,
     Globals;

TYPE TekenArrayType = ARRAY[128..255] OF CHAR;

CONST ConfigFileName = 'WTRCFG.TDB';

      MaxLenComprPrgDescr  = 79;
      MaxAreafixFwd        = 50; { RWI 960721: was 10 }
      MaxInboundDirs       = 2;
      MaxOrigins           = 2;
      MaxPrivMail          = 10;
      MaxCopyHeaders       = 30;
      MaxLenCopyHeaderName = 15;

      DefaultFidoMsgLen   = 12000; { default waarde: ongeveer 12kb }
      DefaultFidoArcLen   = 0;
      DefaultFidoAge      = 10;
      DefaultFidoLimit    = 250;

      MostHandles = 200;       { max. aantal handles, ivm interne tabellen }

TYPE CompDecompType    = (Compr,DeCompr);
     CompUUCPType      = (Compress,GZip);
     SecurityType      = (Secure,NotSecure);
     FidoSystemType    = (stBinkley,stFrontdoor,stDbridge);
     PrivateMailType   = (PvtFrom,PvtTo,PvtSubj);
     ArcType           = (ArcArc,ArcHex,ArcAll);
     CopyHeaderHowType = (chNot,chKludge,chText);
     RMailCorrectType  = (ctNot,ctAddDomain,ctScanHeaders);
     GateMsgIdType     = (gmNot,gmInclude);

     ConfigRecord = RECORD
                          { global }
                          SystemDir            : FilePathStr;
                          Sysop                : STRING[MaxLenSysopName];
                          DupeChecks           : WORD;
                          DoDupeChk            : BOOLEAN;
                          MaxHandles           : BYTE;
                          CacheTdbs            : BOOLEAN;
                          TooLargePath         : FilePathStr;
                          LogFilePath          : FilePathStr;

                          { fido }
                          NodeNrs              : ARRAY[AkaIndexType] OF FidoAddrType;
                          PointNets            : ARRAY[AkaIndexType] OF WORD;
                          Security_F           : ARRAY[1..MaxInboundDirs] OF SecurityType;
                          Inbound_F            : ARRAY[1..MaxInboundDirs] OF FilePathStr;
                          Outbound_F           : FilePathStr;
                          ComprPrgs_F          : ARRAY[CompDecompType,ARC..GUS] OF STRING[MaxLenComprPrgDescr];
                          MaxFidoMsgLen        : LONGINT;
                          MaxFidoArcLen        : LONGINT;
                          DefGroups_F          : GroupFlagType;
                          FidoSystem           : FidoSystemType;
                          FidoAcceptTO         : BOOLEAN;
                          FidoNetmailType      : FidoMsgStyleType;
                          FidoNetmailPath      : FilePathStr;
                          FidoBadAreaType      : FidoMsgStyleType;
                          FidoBadPath          : FilePathStr;
                          FidoDupeAreaType     : FidoMsgStyleType;
                          FidoDupePath         : FilePathStr;
                          FidoAutoCreateType   : FidoMsgStyleType;
                          DefaultFidoMsgPath   : FilePathStr;
                          StripSeenBy          : BOOLEAN;
                          AutoLink             : BOOLEAN;
                          ReplaceTear          : BOOLEAN;
                          DefNumbToKeep_F      : INTEGER;
                          DefDaystoKeep_F      : INTEGER;
                          FidoArcmailExtension : ArcType;  { 0..9,A..F,G..Z }

                          { import from uucp }
                          GatewayAKA           : AkaIndexType;
                          NameSeparator        : CHAR;
                          Origins              : ARRAY[1..MaxOrigins] OF STRING[MaxLenOrigin];

                          { UUCP }
                          WorldWide            : BOOLEAN;
                          DefGroups_U          : GroupFlagType;
                          SpoolBaseDir         : FilePathStr;
                          MaxDatLength         : LONGINT;
                          SmartHost            : STRING[MaxLenUUCPName];
                          UUCPName             : STRING[MaxLenUUCPName];
                          BackBone             : STRING[MaxLenDomain];
                          Organization         : STRING[MaxLenOrganization];
                          Domains              : ARRAY[1..MaxDomains] OF STRING[MaxLenDomain];
                          ComprPrg_U           : ARRAY[CompUUCPType,CompDecompType] OF STRING[MaxLenComprPrgDescr];

                          { Private mail informatie }
                          PrivmailType         : FidoMsgStyleType;
                          PrivmailPath         : FilePathStr;
                          PrivmailOption       : ARRAY[1..MaxPrivMail] OF STRING[MaxLenSubj_F];
                          PrivmailSelect       : ARRAY[1..MaxPrivMail] OF PrivateMailType;

                          { Areafix forwarding information }
                          AreafixForward       : ARRAY[1..MaxAreaFixFwd] OF AreaFixForwardRecord;
                          UUCPForward          : ARRAY[1..MaxAreaFixFwd] OF UUCPForwardRecord;

                          { Conversion Fido->UUCP }
                         {ConversionTabel      : TekenArrayType;}

                          MaxSquishMsgLen,
                          MaxJAMMsgLen         : LONGINT;

                          DefaultCompressor    : CompressionType;
                          PackedAddresses      : BOOLEAN;

                          { nieuwe velden 14/08/1994 }
                          RescanFlagFile       : FilePathStr; { RWI 251094: Changed to path+filename }
                          DBridgeQueuePath     : FilePathStr;
                          AreafixName          : STRING[10];

                          { nieuwe velden 11/02/95 }
                          KillGatedNetmail     : BOOLEAN;
                          NewsfixName          : STRING[10];

                          { nieuwe velden 15/04/95 }
                          UseSwapfile          : BOOLEAN;
                          SwapfilePath         : FilePathStr;
                          SwapfileSize         : BYTE; { in mb }

                          { nieuwe velden 23/05/95 }
                          ReplyFSC35           : BOOLEAN;   { FSC35 ReplyTo&Addr kludge  }
                          HeaderFullname       : BOOLEAN;   { Full name / e-mail address in fido From: veld }

                          LogDebug             : BOOLEAN;   { alles loggen? }
                          LogSpoolTossed       : BOOLEAN;   { log tossed spool files? }
                          LogFidoExtract       : BOOLEAN;   { log extracted files? }
                          LogFidoTossed        : BOOLEAN;   { log processed .PKT files? }
                          LogTranslationFU     : BOOLEAN;   { log vertaling van adressen F->U? }
                          LogCheckFilter       : BOOLEAN;   { log acceptatie/afwijzing van newsgroup namen? }
                          LogXFix              : BOOLEAN;   { log vervanging van adres uit .X file? }
                          LogCopyHeaders       : BOOLEAN;   { uit netmail/echomail overgenomen header regels loggen? }
                          LogIllegalHeaders    : BOOLEAN;   { illegale headers loggen? }
                          LogAreaFix           : BOOLEAN;   { extended areafix / newsfix logging }
                          LogMapApply          : BOOLEAN;   { log all applied mapping statements }
                          LogNetmailImport     : BOOLEAN;   { log all imported netmails? }
                          LogRODeny            : BOOLEAN;   { log all read-only denied postings in areas? }
                          LogPktEachEcho       : BOOLEAN;   { log iedere echomail plus lengte? }
                          LogUUCPOutbound      : BOOLEAN;   { log alle aangemaakte UUCP files? }
                          LogSMTPOutbound      : BOOLEAN;   { log alle aangemaakte SMTP jobs? }
                          LogExportedMsgs      : BOOLEAN;   { log alle geexporteerde messages? }
                          LogErrNewsgroups     : BOOLEAN;   { log newsgroups names of unprocessed articles? }
                          Log18,
                          Log19,Log20,Log21    : BOOLEAN; { paar extra om vooruit te kunnen }

                          CopyHeaderNames      : ARRAY[1..MaxCopyHeaders] OF STRING[MaxLenCopyHeaderName];
                          CopyHeaderHow        : ARRAY[1..MaxCopyHeaders] OF CopyHeaderHowType;

                          GatewayUser          : STRING[MaxLenToUser_F];

                          { new fields in 0.20 }
                          BounceUnknown        : BOOLEAN;
                          BounceSmall          : BOOLEAN;

                          AdminAddrType        : BYTE; { 0=None, 1=Netmail, 2=Email}
                          AdminFidoName        : STRING[MaxLenToUser_F];
                          AdminFidoAddr        : FidoAddrType;
                          AdminUUCPAddr        : STRING[MaxLenUser_U];

                          AdminSendLog         : BOOLEAN;
                          AdminSend2           : BOOLEAN;
                          AdminSend3           : BOOLEAN;
                          AdminSend4           : BOOLEAN;
                          AdminSend5           : BOOLEAN;
                          AdminSend6           : BOOLEAN;
                          AdminSend7           : BOOLEAN;
                          AdminSend8           : BOOLEAN;
                          AdminSend9           : BOOLEAN;
                          AdminSend10          : BOOLEAN;
                          AdminSend11          : BOOLEAN;
                          AdminSend12          : BOOLEAN;
                          AdminSend13          : BOOLEAN;
                          AdminSend14          : BOOLEAN;
                          AdminSend15          : BOOLEAN;
                          AdminSend16          : BOOLEAN;

                          TimeZone             : STRING[25];
                          CopyHeaders_FU       : BOOLEAN;
                          old_MailGrade        : CHAR;
                          old_NewsGrade        : CHAR;
                          TimeSlicing          : BOOLEAN;

                          NetmailDecode        : BOOLEAN;
                          NetmailDecodePath    : FilePathStr;

                          PrivateDecode        : BOOLEAN;
                          PrivateDecodePath    : FilePathStr;

                          { nieuwe velden 0.92.pre1 }
                          MaxRMailLineLen      : WORD;
                          MinimumDiskFree      : BYTE; { mb }
                          DiskFreeDrives       : STRING[26];
                          WrapLineLen          : BYTE;
                          RMailCorrect         : RMailCorrectType;

                          { nieuwe velden 0.92.pre2 }
                          GateMsgId            : GateMsgIdType;
                          ForceNoBitmask       : BOOLEAN;

                          { nieuwe velden 0.92.pre6 }
                          RescanFlagFile2      : FilePathStr;
                          OrganizationInOrigin : BYTE; { tri-state }

                          { nieuwe velden 0.93.pre4 }
                          AlwaysMimeQuotePrint : BOOLEAN;

                          { nieuwe velden 0.93.pre10 }
                          SmtpForward          : STRING[MaxLenDomain];
                          MaxXPostNewsgroups   : BYTE;
                          WildCatMsgLockDir    : STRING[MaxLenPath];
                          OpusDateFormat       : BOOLEAN;
                          MaxWildCatMsgLen     : LONGINT;

                          { nieuwe velden 0.93.pre13 }
                          KillAreaFixMsgs      : BOOLEAN;
                          Colors               : ARRAY[1..21] OF BYTE;
                    END;

VAR Config           : ConfigRecord;
    FoundConfigPath  : STRING[79]; { voor saven config file }

    {$IFDEF WtrGate}
    ForceDebugLog    : BOOLEAN;
    {$ENDIF}

FUNCTION  ReadConfigFile : BOOLEAN; { zie opmerking over aanroep! }
FUNCTION  CheckFidoAddr (BufferPtr : StringPtr) : BOOLEAN;

{$IFDEF WtrConf}
PROCEDURE ActivateColors;
PROCEDURE RestoreSystemColors;
PROCEDURE SetupEmptyConfig;
PROCEDURE SaveConfigFile;
FUNCTION  ConfigHasChanged : BOOLEAN;
PROCEDURE FixConfigRecord;
PROCEDURE UnfixConfigRecord;

FUNCTION  CheckNumberLimits (BufferPtr : StringPtr; MinSize : LONGINT) : LONGINT;
FUNCTION  CheckPathFunc (BufferPtr : StringPtr) : BOOLEAN;
FUNCTION  CheckFileAndPathFunc (BufferPtr : StringPtr) : BOOLEAN;
PROCEDURE PathFileMgr (BufferPtr : StringPtr);
PROCEDURE AnyFileMgr (BufferPtr : StringPtr);
PROCEDURE MsgBaseFileMgr (BufferPtr : StringPtr; BaseType : FidoMsgStyleType);
FUNCTION  FidoAkaListConvertFunc (Item : STRING) : STRING;
{$ENDIF (WtrConf)}


IMPLEMENTATION

USES Tdb,
     Logs,
     Dos,
     Fido;

CONST ConfigHeader = 'WtrGate Config 22';


{--------------------------------------------------------------------------}
{ RestoreSystemColors                                                      }
{                                                                          }
{ Deze routine vult de standaard kleuren in.                               }
{                                                                          }
PROCEDURE RestoreSystemColors;

CONST SystemColors : ARRAY[1..21] OF BYTE = ($12,$31,$1F,$1E,$1E,$08,$1F,$4E,
                                             $2F,$74,$70,$F4,$3F,$3E,$31,$1A,
                                             $4F,$17,$70,$F0,$1E);

BEGIN
     Move (SystemColors,Config.Colors,21);

     (*
     WITH Config DO
     BEGIN
          Colors[1]:=$12;  { desktop }
          Colors[2]:=$31;  { title }
          Colors[3]:=$1F;  { border, no focus }
          Colors[4]:=$1E;  { border, focus }
          Colors[5]:=$1E;  { window background }
          Colors[6]:=$08;  { window shadow }
          Colors[7]:=$1F;  { window text }
          Colors[8]:=$4E;  { error window }
          Colors[9]:=$2F;  { message window }
          Colors[10]:=$74; { key name }
          Colors[11]:=$70; { key descr }
          Colors[12]:=$F4; { key blink }
          Colors[13]:=$3F; { help }
          Colors[14]:=$3E; { help, highlight }
          Colors[15]:=$31; { help, link }
          Colors[16]:=$1A; { tagged item }
          Colors[17]:=$4F; { untaggable item }
          Colors[18]:=$17; { disabled field }
          Colors[19]:=$70; { cursor bar }
          Colors[20]:=$F0; { cursor on tagged item }
          Colors[21]:=$1E; { select menu/list item }
     END;
     *)
END;


{--------------------------------------------------------------------------}
{ ActivateColors                                                           }
{                                                                          }
{ Deze routine veranderd de kleuren in de Ramon Unit in the gekozen        }
{ kleuren.                                                                 }
{                                                                          }
PROCEDURE ActivateColors;
BEGIN
     IF (Video.Rows = 0) THEN
        Video.Color:=TRUE;

     ModifyColor (cDesktop,          Config.Colors[1]);
     ModifyColor (cHeaders,          Config.Colors[2]);
     ModifyColor (cBoxLinesInactive, Config.Colors[3]);
     ModifyColor (cBoxLinesActive,   Config.Colors[4]);
     ModifyColor (cBoxBack,          Config.Colors[5]);
     ModifyColor (cBoxShadow,        Config.Colors[6]);
     ModifyColor (cBoxData,          Config.Colors[7]);
     ModifyColor (cFieldData,        Config.Colors[7]);
     ModifyColor (cError,            Config.Colors[8]);
     ModifyColor (cMessage,          Config.Colors[9]);
     ModifyColor (cKeyName,          Config.Colors[10]);
     ModifyColor (cKeyDescr,         Config.Colors[11]);
     ModifyColor (cKeyBlink,         Config.Colors[12]);
     ModifyColor (cHelp,             Config.Colors[13]);
     ModifyColor (cHelpBright,       Config.Colors[14]);
     ModifyColor (cHelpLink,         Config.Colors[15]);
     ModifyColor (cBoxDataTagged,    Config.Colors[16]);
     ModifyColor (cNotTagable,       Config.Colors[17]);
     ModifyColor (cFieldDisabled,    Config.Colors[18]);
     ModifyColor (cMenuSelectBar,    Config.Colors[19]);
     ModifyColor (cFieldCursor,      Config.Colors[19]);
     ModifyColor (cFieldCursorTagged,Config.Colors[20]);
     ModifyColor (cMenuSelected,     Config.Colors[21]);
END;


{--------------------------------------------------------------------------}
{ SetupEmptyConfig                                                         }
{                                                                          }
{ Deze routine maakt het Config record leeg door deze met default waarden  }
{ te vullen. Deze routine wordt automatisch aangeroepen na het opstarten   }
{ van het programma dat deze unit gebruikt (zie onderaan).                 }
{                                                                          }
PROCEDURE SetupEmptyConfig;

VAR Lp : BYTE;

BEGIN
     WITH Config DO
     BEGIN
          { global }
          DoDupeChk:=TRUE;
          DupeChecks:=10000;
          SystemDir:='';
          NameSeparator:='_';
          TooLargePath:='';
          LogFilePath:='WTRGATE.LOG';
          MaxHandles:=8{MostHandles};
          TimeZone:='GMT';
          CacheTdbs:=FALSE; { in XMS geheugen! }
          Sysop:='John Doe'; {Default sysop}

          FOR Lp:=1 TO MaxAKAs DO
          BEGIN
               FidoSplit ('0',NodeNrs[Lp]);
               PointNets[Lp]:=0;
          END;

          FidoSystem:=stBinkley;
          FidoNetmailType:=FidoMsgType;
          FidoNetmailPath:='';
          PrivMailType:=NoneType;
          PrivMailPath:='';
          FidoBadAreaType:=NoneType;
          FidoDupeAreaType:=NoneType;
          FidoAutoCreateType:=NoneType;
          FidoBadPath:='';
          FidoDupePath:='';
          DefaultFidoMsgPath:='';
          FidoArcMailExtension:=ArcArc;
          StripSeenBy:=FALSE;
          AutoLink:=FALSE;
          ReplaceTear:=TRUE;
          FidoAcceptTo:=TRUE;
          PackedAddresses:=TRUE;

          DefNumbToKeep_F:=DefaultFidoLimit;
          DefDaysToKeep_F:=DefaultFidoAge;

          FOR Lp:=1 TO MaxInboundDirs DO
          BEGIN
               InBound_F[Lp]:='';
               Security_F[Lp]:=NotSecure;
          END;

          OutBound_F:='';

          ComprPrgs_F[Compr,ARC]:='PKPAK -OCT A';
          ComprPrgs_F[DeCompr,ARC]:='PKUNPAK /R';

          ComprPrgs_F[Compr,ARJ]:='ARJ A -E';
          ComprPrgs_F[DeCompr,ARJ]:='ARJ E -N';

          ComprPrgs_F[Compr,LZH]:='LHA A /M';
          ComprPrgs_F[DeCompr,LZH]:='LHA E';

          ComprPrgs_F[Compr,PAK]:='PAK A';
          ComprPrgs_F[DeCompr,PAK]:='PAK E /WN';

          ComprPrgs_F[Compr,ZIP]:='PKZIP -A';
          ComprPrgs_F[DeCompr,ZIP]:='PKUNZIP -O';

          ComprPrgs_F[Compr,ZOO]:='ZOO -Add';
          ComprPrgs_F[DeCompr,ZOO]:='ZOO -Extract';

          ComprPrgs_F[Compr,RAR]:='RAR A';
          ComprPrgs_F[DeCompr,RAR]:='RAR E';

          ComprPrgs_F[Compr,GUS]:=Spaces (MaxLenComprPrgDescr);
          ComprPrgs_F[DeCompr,GUS]:=Spaces (MaxLenComprPrgDescr);

          ComprPrgs_F[Compr,OP1]:=Spaces (MaxLenComprPrgDescr);

          MaxFidoMsgLen:=DefaultFidoMsgLen;
          MaxSquishMsgLen:=DefaultFidoMsgLen;
          MaxJAMMsgLen:=DefaultFidoMsgLen;

          MaxFidoArcLen:=DefaultFidoArcLen;
          ResetGroupFlags (DefGroups_F);

          { import from uucp }
          FOR Lp:=1 TO MaxOrigins DO
              Origins[Lp]:='';

          GatewayAKA:=1;
          GatewayUser:='UUCP';

          SpoolBaseDir:='';
          Organization:='Another '+DeskTopProgramName+' site !';
          SmartHost:='';
          ComprPrg_U[Compress,Compr]:='COMP430D -v';
          ComprPrg_U[Compress,DeCompr]:='COMP430D -dv';
          ComprPrg_U[Gzip,Compr]:='GZIP -v';
          ComprPrg_U[Gzip,DeCompr]:='GZIP -dv';
          ResetGroupFlags (DefGroups_U);

          WorldWide:=FALSE;
          UUCPName:='';
          BackBone:='Berkeley.EDU';

          FOR Lp:=1 TO MaxDomains DO
              Domains[Lp]:='';

          FOR Lp:=1 TO MaxAreafixFwd DO
          BEGIN
               WITH AreaFixForward[Lp] DO
               BEGIN
                    FidoSplit ('0',UplinkAddress);
                    Unconditional:=FALSE;
                    AreaListPath:='';
                    AreaList:=lstNAMES;
                    AreaManager:='Areafix';
                    Group:=1; { = A1 }
                    AddPlus:=FALSE;
               END;

               WITH UUCPForward[Lp] DO
               BEGIN
                    AreaListPath:='';
                    UUCPName:='';
                    Group:=1; { = A1 }
               END;
          END;

          FOR Lp:=1 TO MaxPrivMail DO
          BEGIN
               PrivMailSelect[Lp]:=PvtTo;
               PrivMailOption[Lp]:='';
          END;

          MaxDatLength:=200000; { 200k bij 50% compressie -> 100k }

          DBridgeQueuePath:='';
          RescanFlagFile:='FDRESCAN.NOW';
          AreafixName:='Areafix';
          NewsfixName:='newsfix';

          KillGatedNetmail:=FALSE;

          UseSwapfile:=TRUE;
          SwapfilePath:='WTRGATE.SWP';
          SwapfileSize:=5; { Mb }

          HeaderFullname:=TRUE; { = full name }
          ReplyFSC35:=TRUE;

          LogDebug:=FALSE;
          LogSpoolTossed:=TRUE;
          LogFidoExtract:=TRUE;
          LogFidoTossed:=TRUE;
          LogTranslationFU:=TRUE;
          LogCheckFilter:=TRUE;
          LogXFix:=TRUE;
          LogCopyHeaders:=TRUE;
          LogIllegalHeaders:=TRUE;
          LogAreaFix:=TRUE;
          LogMapApply:=TRUE;
          LogNetmailImport:=TRUE;
          LogRODeny:=TRUE;
          LogPktEachEcho:=TRUE;
          LogUUCPOutbound:=TRUE;
          LogSMTPOutbound:=TRUE;
          LogExportedMsgs:=TRUE;
          LogErrNewsgroups:=TRUE;
          Log18:=TRUE;
          Log19:=TRUE;
          Log20:=TRUE;
          Log21:=TRUE;

          CopyHeaderNames[1]:='From:';          CopyHeaderHow[1]:=chKludge;
          CopyHeaderNames[2]:='To:';            CopyHeaderHow[2]:=chKludge;
          CopyHeaderNames[3]:='Subject:';       CopyHeaderHow[3]:=chKludge;
          CopyHeaderNames[4]:='Date:';          CopyHeaderHow[4]:=chKludge;
          CopyHeaderNames[5]:='Message-Id:';
          CopyHeaderNames[6]:='Organization:';
          CopyHeaderNames[7]:='From';
          CopyHeaderNames[8]:='Path:';
          CopyHeaderNames[9]:='Newsgroups:';

          FOR Lp:=10 TO MaxCopyHeaders DO
              CopyHeaderNames[Lp]:='';

          FOR Lp:=5 TO MaxCopyHeaders DO
              CopyHeaderHow[Lp]:=chNot;

          BounceUnknown:=FALSE;
          BounceSmall:=TRUE;

          AdminAddrType:=0;
          AdminFidoName:='WaterGate Administrator';
          FidoSplit ('0',AdminFidoAddr);
          AdminUUCPAddr:='';

          AdminSendLog:=TRUE;
          AdminSend2:=TRUE;
          AdminSend3:=TRUE;
          AdminSend4:=TRUE;
          AdminSend5:=TRUE;
          AdminSend6:=TRUE;
          AdminSend7:=TRUE;
          AdminSend8:=TRUE;
          AdminSend9:=TRUE;
          AdminSend10:=TRUE;
          AdminSend11:=TRUE;
          AdminSend12:=TRUE;
          AdminSend13:=TRUE;
          AdminSend14:=TRUE;
          AdminSend15:=TRUE;
          AdminSend16:=TRUE;

          CopyHeaders_FU:=TRUE;
          {MailGrade:='A';}
          {NewsGrade:='Z';}
          TimeSlicing:=TRUE;

          NetmailDecode:=FALSE;
          NetmailDecodePath:='';

          PrivateDecode:=FALSE;
          PrivateDecodePath:='';

          MaxRMailLineLen:=250;
          MinimumDiskFree:=5; { mb }
          DiskFreeDrives:='';
          WrapLineLen:=72;
          RMailCorrect:=ctScanHeaders;

          GateMsgId:=gmNot;
          ForceNoBitmask:=TRUE;

          RescanFlagFile2:='FMRESCAN.NOW';
          OrganizationInOrigin:=0; { = no }

          AlwaysMimeQuotePrint:=TRUE;

          SmtpForward:='';
          MaxXPostNewsgroups:=255;
          WildCatMsgLockDir:='';
          OpusDateFormat:=FALSE;
          MaxWildCatMsgLen:=DefaultFidoMsgLen;

          KillAreaFixMsgs:=FALSE;

          RestoreSystemColors;
     END; { with }
END;


{$IFDEF WtrConf}
{--------------------------------------------------------------------------}
{ FixConfigRecord                                                          }
{                                                                          }
{ Deze routine maakt de config velden op lengte door ze met spaties aan te }
{ vullen, zodat ze met de Field routines gewijzigd kunnen worden.          }
{                                                                          }
PROCEDURE FixConfigRecord;

VAR ComprLp : CompressionType;
    Lp      : BYTE;

BEGIN
     WITH Config DO
     BEGIN
          Sysop:=AddUpWithSpaces (MaxLenSysopName,Sysop);
          SystemDir:=AddUpWithSpaces (79,SystemDir);
          TimeZone:=AddUpWithSpaces (25,TimeZone);

          TooLargePath:=AddUpWithSpaces (79,TooLargePath);
          LogFilePath:=AddUpWithSpaces (79,LogFilePath);
          FidoNetmailPath:=AddUpWithSpaces (79,FidoNetmailPath);
          PrivMailPath:=AddUpWithSpaces (79,PrivMaiLPath);
          DefaultFidoMsgPath:=AddUpWithSpaces (79,DefaultFidoMsgPath);
          FidoBadPath:=AddUpWithSpaces (79,FidoBadPath);
          FidoDupePath:=AddUpWithSpaces (79,FidoDupePath);
          GatewayUser:=UpCaseString (AddUpWithSpaces (MaxLenToUser_F,GateWayUser));

          FOR Lp:=1 TO MaxInboundDirs DO
              InBound_F[Lp]:=AddUpWithSpaces (79,InBound_F[Lp]);

          OutBound_F:=AddUpWithSpaces (79,OutBound_F);

          FOR ComprLp:=ARC TO GUS DO
          BEGIN
               ComprPrgs_F[Compr,ComprLp]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrgs_F[Compr,ComprLp]);
               ComprPrgs_F[DeCompr,ComprLp]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrgs_F[DeCompr,ComprLp]);
          END;

          FOR Lp:=1 TO MaxOrigins DO
              Origins[Lp]:=AddUpWithSpaces (MaxLenOrigin,Origins[Lp]);

          SpoolBaseDir:=AddUpWithSpaces (79,SpoolBaseDir);
          Organization:=AddUpWithSpaces (MaxLenOrganization,Organization);
          SmartHost:=AddUpWithSpaces (MaxLenUUCPName,SmartHost);
          BackBone:=AddUpWithSpaces (MaxLenDomain,BackBone);

          ComprPrg_U[Compress,Compr]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrg_U[Compress,Compr]);
          ComprPrg_U[Compress,DeCompr]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrg_U[Compress,DeCompr]);

          ComprPrg_U[GZip,Compr]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrg_U[GZip,Compr]);
          ComprPrg_U[GZip,DeCompr]:=AddUpWithSpaces (MaxLenComprPrgDescr,ComprPrg_U[Gzip,DeCompr]);

          UUCPName:=AddUpWithSpaces (MaxLenUUCPName,UUCPName);
          FOR Lp:=1 TO MaxDomains DO
              Domains[Lp]:=AddUpWithSpaces (MaxLenDomain,Domains[Lp]);

          FOR Lp:=1 TO MaxPrivMaiL DO
          BEGIN
               IF (PrivMaiLOption[Lp] = '') THEN
                  PrivMailOption[Lp]:='<not used>';
               PrivMaiLOption[Lp]:=AddUpWithSpaces (MaxlenSubj_F,PrivMaiLOption[Lp]);
          END;

          FOR Lp:=1 TO MaxAreaFixFwd DO
          BEGIN
               WITH AreaFixForward[Lp] DO
               BEGIN
                    AreaListPath:=AddUpWithSpaces (50,AreaListPath);
                    AreaManager:=AddUpWithSpaces (10,AreaManager);
                    Password:=AddUpWithSpaces (10,Password);
               END;

               WITH UUCPForward[Lp] DO
               BEGIN
                    UUCPName:=AddUpWithSpaces (MaxLenUUCPName,UUCPName);
                    AreaListPath:=AddUpWithSpaces (50,AreaListPath);
               END;
          END;

          DBridgeQueuePath:=AddUpWithSpaces (79,DBridgeQueuePath);
          RescanFlagFile:=AddUPwithSpaces (79,RescanFlagFile);
          RescanFlagFile2:=AddUPwithSpaces (79,RescanFlagFile2);

          AreafixName:=AddUpWithSpaces (10,AreafixName);
          NewsfixName:=AddUpWithSpaces (10,NewsfixName);

          SwapfilePath:=AddUpWithSpaces (79,SwapfilePath);

          FOR Lp:=1 TO MaxCopyHeaders DO
              CopyHeaderNames[Lp]:=AddUpWithSpaces (MaxLenCopyHeaderName,CopyHeaderNames[Lp]);

          AdminFidoName:=AddUpWithSpaces (MaxLenToUser_F,AdminFidoName);
          AdminUUCPAddr:=AddUpWithSpaces (MaxLenUser_U,AdminUUCPAddr);

          NetmailDecodePath:=AddUpWithSpaces (79,NetmailDecodePath);
          PrivateDecodePath:=AddUpWithSpaces (79,PrivateDecodePath);

          DiskFreeDrives:=AddUpWithSpaces (26,DiskFreeDrives);

          SmtpForward:=AddUpWithSpaces (MaxLenDomain,SmtpForward);
          WildCatMsgLockDir:=AddUpWithSpaces (MaxLenPath,WildCatMsgLockDir);
     END; { with }
END;


{--------------------------------------------------------------------------}
{ UnFixConfigRecord                                                        }
{                                                                          }
{ Deze routine verwijderd alle onnodige spaties uit de Config velden. Dit  }
{ belangrijk voor de paden en compressie programma's.                      }
{                                                                          }
PROCEDURE UnFixConfigRecord;

VAR ComprLp : CompressionType;
    Lp      : BYTE;

BEGIN
     WITH Config DO
     BEGIN
          SystemDir:=DeleteFrontAndBackSpaces (SystemDir);
          TimeZone:=DeleteFrontAndBackSpaces (TimeZone);
          Sysop:=DeleteFrontAndBackSpaces (Sysop);

          TooLargePath:=DeleteFrontAndBackSpaces (TooLargePath);
          LogFilePath:=DeleteFrontAndBackSpaces (LogFilePath);
          FidoNetmailPath:=DeleteFrontAndBackSpaces (FidoNetmailPath);
          PrivMaiLPath:=DeleteFrontAndBackSpaces (PrivMailPath);
          FidoBadPath:=DeleteFrontAndBackSpaces (FidoBadPath);
          FidoDupePath:=DeleteFrontAndBackSpaces (FidoDupePath);
          DefaultFidoMsgPath:=DeleteFrontAndBackSpaces (DefaultFidoMsgPath);
          GatewayUser:=DeleteFrontAndBackSpaces (GatewayUser);
          SmartHost:=DeleteFrontAndBackSpaces (SmartHost);
          BackBone:=DeleteFrontAndBackSpaces (BackBone);
          Organization:=DeleteFrontAndBackSpaces (Organization);
          OutBound_F:=DeleteFrontAndBackSpaces (OutBound_F);
          SpoolBaseDir:=DeleteFrontAndBackSpaces (SpoolBaseDir);

          ComprPrg_U[Compress,Compr]:=DeleteFrontAndBackSpaces (ComprPrg_U[Compress,Compr]);
          ComprPrg_U[Compress,DeCompr]:=DeleteFrontAndBackSpaces (ComprPrg_U[Compress,DeCompr]);

          ComprPrg_U[GZip,Compr]:=DeleteFrontAndBackSpaces (ComprPrg_U[GZip,Compr]);
          ComprPrg_U[GZip,DeCompr]:=DeleteFrontAndBackSpaces (ComprPrg_U[GZip,DeCompr]);

          UUCPName:=DeleteFrontAndBackSpaces (UUCPName);
          BackBone:=DeleteFrontAndBackSpaces (BackBone);

          FOR Lp:=1 TO MaxInboundDirs DO
              InBound_F[Lp]:=DeleteFrontAndBackSpaces (InBound_F[Lp]);

          FOR ComprLp:=ARC TO GUS DO
          BEGIN
               ComprPrgs_F[Compr,ComprLp]:=DeleteFrontAndBackSpaces (ComprPrgs_F[Compr,ComprLp]);
               ComprPrgs_F[DeCompr,ComprLp]:=DeleteFrontAndBackSpaces (ComprPrgs_F[DeCompr,ComprLp]);
          END;

          FOR Lp:=1 TO MaxOrigins DO
              Origins[Lp]:=DeleteFrontAndBackSpaces (Origins[Lp]);

          FOR Lp:=1 TO MaxDomains DO
              Domains[Lp]:=DeleteFrontAndBackSpaces (Domains[Lp]);

          FOR Lp:=1 TO MaxPrivMaiL DO
          BEGIN
               PrivMaiLOption[Lp]:=DeleteFrontAndBackSpaces (PrivMailOption[Lp]);
               IF (UpCaseString (PrivMailOption[Lp]) = '<NOT USED>') THEN
                  PrivMailOption[Lp]:='';
          END;

          FOR Lp:=1 TO MaxAreaFixFwd DO
          BEGIN
               WITH AreaFixForward[Lp] DO
               BEGIN
                    AreaListPath:=DeleteFrontAndBackSpaces (AreaListPath);
                    AreaManager:=DeleteFrontAndBackSpaces (AreaManager);
               END; { with }

               WITH UUCPForward[Lp] DO
               BEGIN
                    UUCPName:=DeleteFrontAndBackSpaces (UUCPName);
                    AreaListPath:=DeleteFrontAndBackSpaces (AreaListPath);
               END; { with }
          END; { for }

          AreafixName:=DeleteFrontAndBackSpaces (AreafixName);
          NewsfixName:=DeleteFrontAndBackSpaces (NewsfixName);
          DBridgeQueuePath:=DeleteFrontAndBackSpaces (DBridgeQueuePath);
          RescanFlagFile:=DeleteFrontAndBackSpaces (RescanFlagFile);
          RescanFlagFile2:=DeleteFrontAndBackSpaces (RescanFlagFile2);
          SwapfilePath:=DeleteFrontAndBackSpaces (SwapfilePath);

          FOR Lp:=1 TO MaxCopyHeaders DO
              CopyHeaderNames[Lp]:=DeleteFrontAndBackSpaces (CopyHeaderNames[Lp]);

          AdminFidoName:=DeleteFrontAndBackSpaces (AdminFidoName);
          AdminUUCPAddr:=DeleteFrontAndBackSpaces (AdminUUCPAddr);

          NetmailDecodePath:=DeleteFrontAndBackSpaces (NetmailDecodePath);
          PrivateDecodePath:=DeleteFrontAndBackSpaces (PrivateDecodePath);

          SmtpForward:=DeleteFrontAndBackSpaces (SmtpForward);
          WildCatMsgLockDir:=DeleteFrontAndBackSpaces (WildCatMsgLockDir);
     END; { with }
END;


{--------------------------------------------------------------------------}
{ SaveConfigFile                                                           }
{                                                                          }
{ Deze routine save't de huidige config gegevens naar disk. De oude config }
{ file wordt overschreven.                                                 }
{                                                                          }
PROCEDURE SaveConfigFile;

VAR TdbNr : TdbNrType;

BEGIN
     IF (TdbCreate (FoundConfigPath,ConfigHeader,TdbNr) = _tdbOk) THEN
     BEGIN
          { Kill the BackSpaces ! }
          UnFixConfigRecord;
          TdbSetIO (TdbNr,SizeOf (ConfigRecord));
          TdbWrite (TdbNr,1,Config);
          TdbClose (TdbNr);
     END ELSE
     BEGIN
          Error ('Cannot create Config File!');
          LogDiskIOError (TdbLastIOResult,'Cannot create Config File');
     END;
END;


{--------------------------------------------------------------------------}
{ ConfigHasChanged                                                         }
{                                                                          }
{ Deze routine controleert of de config file gewijzigd is. Dit wordt       }
{ gedaan door het huidige Config record te vergelijken met het record in   }
{ de config file op disk. Als deze niet hetzelfde zijn wordt FALSE terug   }
{ gegeven, anders TRUE.                                                    }
{                                                                          }
FUNCTION ConfigHasChanged : BOOLEAN;

TYPE Cmp = ARRAY[1..SizeOf (ConfigRecord)] OF BYTE;

VAR OldConfigPtr : ^ConfigRecord;
    Lp           : WORD; { weet niet hoe groot het record wordt }

BEGIN
     UnFixConfigRecord;

     GetMem (OldConfigPtr,SizeOf (ConfigRecord));
     OldConfigPtr^:=Config;

     SetupEmptyConfig;

     ReadConfigFile;
     ConfigHasChanged:=FALSE;

     FOR Lp:=1 TO SizeOf (ConfigRecord) DO
         IF (Cmp (Config)[Lp] <> Cmp (OldConfigPtr^)[Lp]) THEN
         BEGIN
              ConfigHasChanged:=TRUE;
              Break; { RM> stop de FOR, kan alleen in Borland Pascal 7.0! }
                     { MD> Turbo 7.0 lust er ook wel pap van hoor..       }
         END;

     Config:=OldConfigPtr^;
     FreeMem (OldConfigPtr,SizeOf (ConfigRecord));
     FixConfigRecord;

     ActivateColors; { ReadConfigFile had changed them.. }
END;


{--------------------------------------------------------------------------}
{ CheckPathFunc                                                            }
{                                                                          }
{ Deze routine voegt een backslash toe aan het pad als het nodig is. De    }
{ routine wordt door de Check fields aangeroepen.                          }
{                                                                          }
FUNCTION CheckPathFunc (BufferPtr : StringPtr) : BOOLEAN;

VAR OldLen : BYTE;

BEGIN
     OldLen:=Length (BufferPtr^);
     BufferPtr^:=CorrectPath (BufferPtr^);
     CheckAndCreatePath (BufferPtr^,FALSE);
     BufferPtr^:=AddUpWithSpaces (OldLen,BufferPtr^);
     CheckPathFunc:=TRUE; { niets aan het handje }
END;


{--------------------------------------------------------------------------}
{ CheckFileAndPathFunc                                                     }
{                                                                          }
{ Deze routine voegt een backslash toe aan het pad als het nodig is. De    }
{ routine wordt door de Check fields aangeroepen.                          }
{                                                                          }
FUNCTION CheckFileAndPathFunc (BufferPtr : StringPtr) : BOOLEAN;

VAR OldLen : BYTE;

BEGIN
     OldLen:=Length (BufferPtr^);
     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);
     CheckAndCreatePath (BufferPtr^,TRUE);
     BufferPtr^:=AddUpWithSpaces (OldLen,BufferPtr^);
     CheckFileAndPathFunc:=TRUE; { niets aan het handje }
END;


{--------------------------------------------------------------------------}
{ PathFileMgr                                                              }
{                                                                          }
{ Deze wordt gebruikt door van alles en nog wat.                           }
{                                                                          }
PROCEDURE PathFileMgr (BufferPtr : StringPtr);

VAR OldLen : BYTE;

BEGIN
     OldLen:=Length (BufferPtr^);
     BufferPtr^:=AddUpWithSpaces (OldLen,FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'',''));
END;


{--------------------------------------------------------------------------}
{ AnyFileMgr                                                              }
{                                                                          }
{ Deze wordt gebruikt door van alles en nog wat.                           }
{                                                                          }
PROCEDURE AnyFileMgr (BufferPtr : StringPtr);

VAR OldLen : BYTE;

BEGIN
     OldLen:=Length (BufferPtr^);
     BufferPtr^:=AddUpWithSpaces (OldLen,FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*'));
END;


{--------------------------------------------------------------------------}
{ MsgBaseFileMgr                                                           }
{                                                                          }
PROCEDURE MsgBaseFileMgr (BufferPtr : StringPtr; BaseType : FidoMsgStyleType);
BEGIN
     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);

     CASE BaseType OF
          FidoMsgType:
              BufferPtr^:=FileManager (BufferPtr^,'*.MSG message base','');

          JamType:
              BufferPtr^:=FileManager (BufferPtr^,'JAM message base','*.JDT');

          SquishType:
              BufferPtr^:=FileManager (BufferPtr^,'Squish message base','*.SQD');

          WildCatType:
              BufferPtr^:=FileManager (BufferPtr^,'WildCat message base','*.IX');
     END; { case }

     BufferPtr^:=AddUpWithSpaces (79,BufferPtr^);
END;


{---------------------------------------------------------------------------}
{ CheckNumberLimits                                                         }
{                                                                           }
{ Deze routine wordt gebruikt om de waarden van een aantal limiterende      }
{ getallen te controleren. Het getal moet of 0 zijn, of groter dan de       }
{ minumum waarde zijn. Als het getal kleiner dan de minimum waarde is, dan  }
{ wordt deze op de minimum waarde gezet, tenzijn het getal 0 was. Het       }
{ buffer wordt als een longint geformatteerd.                               }
{                                                                           }
FUNCTION CheckNumberLimits (BufferPtr : StringPtr; MinSize : LONGINT) : LONGINT;

VAR Number : LONGINT;
    Nop    : ValNop;
    OldLen : BYTE;

BEGIN
     OldLen:=Length (BufferPtr^);
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Number,Nop);

     IF (Nop <> 0) THEN
        Number:=MinSize
     ELSE
         IF (Number <= 0) THEN
            Number:=0
         ELSE
             IF (Number < MinSize) THEN
             BEGIN
                  Error ('Minimum allowed value is '+Longint2String (MinSize));
                  Number:=MinSize;
             END;

     BufferPtr^:=AddUpWithSpaces (OldLen,Longint2String (Number));
     CheckNumberLimits:=Number;
END;


{--------------------------------------------------------------------------}
{ FidoAkaListConvertFunc                                                   }
{                                                                          }
FUNCTION FidoAkaListConvertFunc (Item : STRING) : STRING;

VAR Addr : FidoAddrType;
    P    : BYTE;

BEGIN
     FidoSplit (DeleteBackSpaces (Item),Addr);

     IF NOT ((Addr.Zone=0) AND (Addr.Net=0) AND (Addr.Node=0) AND (Addr.Point=0)) THEN
     BEGIN
          Item:=AddUpWithPre0s (5,Word2String (Addr.Zone))+':'+
                AddUpWithPre0s (5,Word2String (Addr.Net))+'/'+
                AddUpWithPre0s (5,Word2String (Addr.Node))+'.'+
                AddUpWithPre0s (5,Word2String (Addr.Point))+'@'+
                Addr.Domain;
     END;

     FidoAkaListConvertFunc:=Item;
END;
{$ENDIF (WtrConf)}


{--------------------------------------------------------------------------}
{ CheckFidoAddr                                                            }
{                                                                          }
FUNCTION CheckFidoAddr (BufferPtr : StringPtr) : BOOLEAN;

VAR Addr : FidoAddrType;

BEGIN
     FidoSplit (DeleteFrontAndBackSpaces (BufferPtr^),Addr);
     BufferPtr^:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Addr));
     CheckFidoAddr:=TRUE;
END;


{--------------------------------------------------------------------------}
{ ReadConfigFile                                                           }
{                                                                          }
{ Deze routine probeert het config record van disk in te lezen             }
{ en slaat deze daarna op in de globaal gedefinieerde variabele Config.    }
{ Als de file niet op disk aanwezig is, dan wordt de bij de initialisatie  }
{ leeg gemaakte config record naar disk geschreven via SaveConfigFile.     }
{ Als de file wel bestond wordt de header ingelezen en gecontroleerd. Als  }
{ deze niet goed is, dan wordt FALSE terug gegeven en moet het programma   }
{ gestopt worden, anders wordt TRUE terug gegeven.                         }
{                                                                          }
{ De routine probeert eerst in de huidige directory naar een config file   }
{ te zoeken. Als dat mislukt wordt een tweede poging gedaan via            }
{ de enviroment string WTRGATE                                             }
{                                                                          }
FUNCTION ReadConfigFile : BOOLEAN;

VAR TdbNr       : TdbNrType;
    Direc       : STRING;
    FoundConfig : BOOLEAN;
    Lp          : BYTE;

BEGIN
     ReadConfigFile:=TRUE; { assume succes }

     FoundConfigPath:=ConfigFilename; { voor saven }

     IF (TdbOpen (ConfigFileName,TdbNr) = _tdbOk) THEN
        FoundConfig:=TRUE
     ELSE BEGIN
          { Probeer het via de enviroment string }
          Direc:=UpCaseString (GetEnv ('WTRGATE'));
          IF (Direc <> '') THEN
          BEGIN
               { zorg dat het pad altijd op een backslash eindigd }
               IF (Direc[Length (Direc)] <> '\') THEN
                  Direc:=Direc+'\';

               FoundConfigPath:=Direc+ConfigFilename; { voor saven }
               FoundConfig:=(TdbOpen (FoundConfigPath,TdbNr) = _tdbOk);
          END ELSE
              FoundConfig:=FALSE;
     END;

     IF FoundConfig THEN
     BEGIN
          IF TdbSeemsLocked (TdbNr) THEN
          BEGIN
               WriteLn (#13'  Another process has locked the databases');
               TdbClose (TdbNr);
               ReadConfigFile:=FALSE;
               Exit;
          END;

          IF (TdbReadHeader (TdbNr) <> ConfigHeader) THEN
          BEGIN
               IF (Copy (TdbReadHeader (TdbNr),1,Length (ConfigHeader)-2) = Copy (ConfigHeader,1,Length (ConfigHeader)-2)) THEN
               BEGIN
                    WriteLn (' Please upgrade your configuration databases with the upgrade program.');
                    WriteLn ('  File used was ',FoundConfigPath,#7);
               END ELSE
                   WriteLn ('  Incompatible database type for WTRCFG.TDB',#7);

               TdbClose (TdbNr);
               ReadConfigFile:=FALSE;
               Exit;
          END;

          TdbSetIO (TdbNr,SizeOf (ConfigRecord));
          TdbRead (TdbNr,1,Config);
          TdbClose (TdbNr);
     END ELSE
         {$IFDEF WtrConf}
         SaveConfigFile;
         {$ELSE}
         ReadConfigFile:=FALSE;
         {$ENDIF}

     { Als er geen directory beschikbaar is, neem dan de huidige }
     IF (Config.SystemDir = '') THEN
     BEGIN
          GetDir (0,Config.SystemDir);

          {RWI 961128: required for OS/2..}
          Config.SystemDir:=UpCaseString (Config.SystemDir);

          { RWI 950415: controle op al aanwezige \ ivm D:\\WTRCFG.TDB }
          {             als je de root neemt voor de config files...  }
          IF (Config.SystemDir[Length (Config.SystemDir)] <> '\') THEN
             Config.SystemDir:=Config.SystemDir+'\';
     END;

     {$IFDEF WtrTest}
     Config.LogFilePath:=Config.SystemDir+'WTRTEST.LOG';
     {$ELSE}
     IF (Pos ('\',Config.LogFilePath) = 0) THEN
        Config.LogFilePath:=Config.SystemDir+Config.LogFilePath;
     {$ENDIF}

     {$IFDEF WtrGate}
     IF ForceDebugLog THEN
        Config.LogDebug:=TRUE;

     { bij WTRGATE.EXE als LogDebug gezet is, dan alle logs ook zetten }
     WITH Config DO
          IF LogDebug THEN
          BEGIN
               LogSpoolTossed:=TRUE;
               LogFidoExtract:=TRUE;
               LogFidoTossed:=TRUE;
               LogTranslationFU:=TRUE;
               LogCheckFilter:=TRUE;
               LogXFix:=TRUE;
               LogCopyHeaders:=TRUE;
               LogIllegalHeaders:=TRUE;
               LogAreaFix:=TRUE;
               LogMapApply:=TRUE;
               LogNetmailImport:=TRUE;
               LogRODeny:=TRUE;
               LogPktEachEcho:=TRUE;
               LogUUCPOutbound:=TRUE;
               LogSMTPOutbound:=TRUE;
               LogExportedMsgs:=TRUE;
               LogErrNewsgroups:=TRUE;
               Log18:=TRUE;
               Log19:=TRUE;
               Log20:=TRUE;
               Log21:=TRUE;
          END; { if, with }
     {$ENDIF (WtrGate)}

     ActivateColors;
END;


END.
