{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT DBridge;

{ Routines om ondersteuning van DBridge mogelijk te maken, eindelijke  }
{ toegevoegt na heel veel hints van Mitchell, zodat ik nu eindelijk de }
{ dodelijk mix van D'Bridge 1.58,Structure's, key en vrije tijd bij    }
{ elkaar heb.                                                          }

INTERFACE

USES Cfg,
     Database;

PROCEDURE DBridgeCreateQueueFile (OutFileName : STRING; Address : FidoAddrType; SendFormat : SendType);


IMPLEMENTATION

USES Globals,
     Logs;

{--------------------------------------------------------------------------}
{ QName                                                                    }
{                                                                          }
{ Hulp functie die een queue file naam creert. Deze functie overgenomen    }
{ de D'Bridge structs.                                                     }
{                                                                          }
FUNCTION QName (Kind : CHAR; Zone,Net,Node,Point : INTEGER) : STRING;

    FUNCTION base36 (N : INTEGER) : STRING;

    VAR d36   : STRING[36];
        I,J,K : INTEGER;

    BEGIN
         d36:='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
         I:=N DIV 1296;
         J:=N MOD 1296;
         K:=N MOD 36;
         J:=J DIV 36;
         Base36:=d36[I+1]+d36[J+1]+d36[K+1]
    END;

BEGIN
     IF (point <> 0) THEN
        QName:=Kind+'-POINT.'+Base36 (Point)
     ELSE
         QName:=Kind+'-'+Base36 (Zone)+base36 (Net)+'.'+Base36 (node);
END;


{--------------------------------------------------------------------------}
{ DBridgeCreateQueueFile                                                   }
{                                                                          }
{ Creer een d'Bridge compatible queue file.                                }
{                                                                          }
PROCEDURE DBridgeCreateQueueFile (OutFileName : STRING; Address : FidoAddrType; SendFormat : SendType);

CONST Priority : ARRAY[SendType] OF CHAR = ('N','H','C','N');

VAR QueueFile : TEXT;
    FileName  : STRING[12];
    NewLine   : STRING;
    Regel     : STRING;
    IORes     : BYTE;

BEGIN
     { RWI 941108: K aan het einde toegevoegd om ervoor te zorgen dat }
     {             de pakketten gewist worden na versturing.          }
     NewLine:=Priority[SendFormat]+' T '+Config.OutBound_F+OutFileName+' '+OutFileName+' K';

     WITH Address DO
     BEGIN
          FileName:=QName ('Q',Zone,Net,Node,Point);

          Assign (QueueFile,Config.DBridgeQueuePath+FileName);
          {$I-} Reset (QueueFile); {$I+} IORes:=IOResult;
          IF (IORes = 0) THEN
          BEGIN
               { check the queue file. If our line is already there, }
               { then don't add it again.                            }
               WHILE (NOT Eof (QueueFile)) DO
               BEGIN
                    ReadLn (QueueFile,Regel);

                    IF (Regel = NewLine) THEN
                    BEGIN
                         { this line is already present! }
                         Close (QueueFile);
                         Exit;
                    END;

               END; { while }

               Close (QueueFile);
          END;

          { Als er al een file met deze naam bestaat, er aan toevoegen }
          { anders een nieuwe file creeren.                            }
          {$I-} Append (QueueFile); {$I+}
          IF (IOResult <> 0) THEN
          BEGIN
               {$I-} ReWrite (QueueFile); {$I+}
               IF (IOResult <> 0) THEN
               BEGIN
                    LogDiskIOError (IORes,'Cannot create d''Bridge queue file '+Config.DBridgeQueuePath+Filename);
                    Exit;
               END;
          END;

          { schrijf een entry naar disk }
          {$I-} WriteLn (QueueFile,NewLine); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Error writing to d''Bridge queue file '+Config.DBridgeQueuePath+Filename);

          {$I-} Close (QueueFile); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Error closing d''Bridge queue file '+Config.DBridgeQueuePath+Filename);

     END; { with }
END;


END.
