{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Decode;

{ this routine is used to decode files from the internal format without  }
{ modifying the internal message. When import the message into a message }
{ base, you call ExtractFile for each line you want to process. It can   }
{ either be on disk or in the swapfile. This routine returns the line    }
{ you have to import into the message base in Regel. If it has found an  }
{ enclosed file, it extracts it, writes it to disk and returns TRUE,     }
{ which means that you have to attach the file. The path to the file is  }
{ in ExtractedPath.                                                      }
{ Before starting to call ExtractFile, you have to set ExtractPath to    }
{ the directory where you want to store the extracted files.             }
{ This routines automatically updates EenRegelPtr so it points to the    }
{ next line.                                                             }


INTERFACE

USES Msgs;

PROCEDURE ExtractInit (DoExtract : BOOLEAN; DecodePath,AreaName : STRING);
FUNCTION  ExtractFile (VAR EenRegelPtr : EenRegelRecordPtr; VAR Regel : STRING) : BOOLEAN;
FUNCTION  DecodeBase64Header (Line : STRING) : STRING;

VAR ExtractedFile : STRING[79];


IMPLEMENTATION

USES Ramon,
     Dos,
     SwapMem,
     Logs,
     Fido,
     Language,
     Globals;

CONST XXChars : STRING[64] = '+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
      UUChars : STRING[64] = '`!"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';
      Base64  : STRING[64] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

TYPE DecodeStates = (dsStayDown,
                     dsFindBegin,
                     dsFindCheckMime1,
                     dsFindXUUEncode,
                     dsFindTypeUUXX,
                     dsUUXX,dsUUXXCheckEnd,dsUUXXSkipSum,
                     dsBase64Next,dsBase64,
                     dsEnd,dsClose,
                     dsAbortOpen,dsAbort);

VAR ExtractPath  : STRING[79];
    OriginalName : STRING[40];  { in case of a unix name }
    State        : DecodeStates;
    Mime_Base64  : BOOLEAN;
    ExtractArea  : STRING[60{MaxLenAreaName}];


{--------------------------------------------------------------------------}
{ StateReset                                                               }
{                                                                          }
{ Reset the state machine by setting all variables appropriately.          }
{                                                                          }
PROCEDURE StateReset;
BEGIN
     State:=dsFindBegin;
     Mime_Base64:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ExtractInit                                                              }
{                                                                          }
{ Sets the path where to store the extracted files and initializes the     }
{ state machine.                                                           }
{                                                                          }
PROCEDURE ExtractInit (DoExtract : BOOLEAN; DecodePath,AreaName : STRING);
BEGIN
     ExtractPath:=CorrectPath (DecodePath);
     ExtractArea:=AreaName;

     IF DoExtract THEN
        StateReset
     ELSE
         State:=dsStayDown;
END;


{--------------------------------------------------------------------------}
{ ExtractFile                                                              }
{                                                                          }
{ This routine takes EenRegelPtr, if required loads it from disk and       }
{ checks it for encoded files if CheckExtract is set to TRUE. If not, it   }
{ simply returns the line in Regel. This routine has nicely put all line   }
{ fetching into one routine ;-)                                            }
{                                                                          }
{ If it has extracted a file, it returns TRUE and EenRegelPtr will then    }
{ point to the line after that file and Regel will hold a description of   }
{ what was extracted. You should then attach the file in ExtractedFile to  }
{ the message. Normally FALSE is returned. You should _always_ import      }
{ Regel.                                                                   }
{                                                                          }
FUNCTION ExtractFile (VAR EenRegelPtr : EenRegelRecordPtr; VAR Regel : STRING) : BOOLEAN;

    {----------------------------------------------------------------------}
    { LoadLine                                                             }
    {                                                                      }
    { This routine makes sure that Regel gets filled with the contents of  }
    { the next line. If it is in memory, it copies it. If it is in the     }
    { swapfile, then it loads it.                                          }
    {                                                                      }
    PROCEDURE LoadLine;

    VAR RegelLength : BYTE;

    BEGIN
         WHILE (EenRegelPtr <> NIL) DO
         BEGIN
              CASE EenRegelPtr^.Waar OF
                   wMem :
                       BEGIN
                            Regel:=EenRegelPtr^.RegelPtr^;
                            EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                            MsgsNewSeek (EenRegelPtr);
                            Exit; { to break the while }
                       END;

                   wSwapped :
                       BEGIN
                            BlockRead (SwapFile,RegelLength,1);

                            IF (RegelLength = 0) THEN
                            BEGIN
                                 EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (EenRegelPtr);
                                 Continue; { with the while }
                            END;

                            BlockRead (SwapFile,Regel[1],RegelLength);
                            Regel[0]:=Char (RegelLength);
                            Exit; { to exit the while }
                       END; { wSwapped }
              END; { case }
         END; { endless while }

         { never gets here... }
    END; { LoadLine }

{ ExtractFile }

VAR SwapPos     : LONGINT;
    OldRegelPtr : EenRegelRecordPtr;

    OutFile     : FILE;
    IORes       : BYTE;
    Ch2Byte     : ARRAY[0..255] OF BYTE;
    Buf         : ARRAY[1..128] OF BYTE;
    StorePos,
    GetPos      : BYTE;
    V1,V2,V3,V4 : BYTE;
    Lp          : BYTE;
    L,Len       : BYTE;

    {----------------------------------------------------------------------}
    { CreateFile                                                           }
    {                                                                      }
    FUNCTION CreateFile (Filename : STRING) : BOOLEAN;

    VAR Search : SearchRec;
        Dir    : DirStr;
        Name   : NameStr;
        Ext    : ExtStr;

    BEGIN
         { kijk of deze file al bestaat. Zoja, dan verzinnen we een }
         { andere naam.                                             }

         OriginalName:=Filename; { assume verandert en afdrukken }

         { RWI 960830: Strip paden, illegale tekens en te lange namen }
         Filename:=FilenameTo83 (Filename);

         ExtractedFile:=FilenameTo83Instance (ExtractPath,Filename);

         REPEAT
               FindFirst (ExtractedFile,$3F,Search);
               IF (DosError = 0) THEN
               BEGIN
                    FindClose (Search);
                    FSplit (ExtractedFile,Dir,Name,Ext);
                    ExtractedFile:=ExtractPath+UpCaseString (GetFidoPktName)+Ext; { keep same extension }
                    Continue; { nog een keer! }
               END;
         UNTIL (DosError <> 0);

         FindClose (Search);

         IF (ExtractPath+OriginalName = ExtractedFile) THEN
            OriginalName:='';

         Assign (OutFile,ExtractedFile);
         {$I-} ReWrite (OutFile,1); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'[Decode] Cannot create '+ExtractedFile);
              ExtractedFile:='';   { RWI 960608 }
              CreateFile:=FALSE;
         END ELSE
             CreateFile:=TRUE;
    END;

    {----------------------------------------------------------------------}
    { ProcessMimeParam                                                     }
    {                                                                      }
    { This routine is fed a single MIME parameter. It checks for the NAME  }
    { paramter and opens the file if found.                                }
    {                                                                      }
    PROCEDURE ProcessMimeParam (Param : STRING);

    VAR UpTest : STRING[8];
        UpLen  : BYTE;

    BEGIN
         IF (ExtractedFile <> '') THEN
            Exit;

         WHILE (Pos (#9,Param) > 0) DO
               Param[Pos (#9,Param)]:=' ';

         Param:=DeleteFrontSpaces (Param);
         UpTest:=UpCaseString (Copy (Param,1,8));

         UpLen:=0;

         IF (Copy (UpTest,1,4) = 'NAME') THEN
            UpLen:=4
         ELSE
             IF (UpTest = 'FILENAME') THEN
                Uplen:=8;

         IF (UpLen <> 0) THEN
         BEGIN
              Delete (Param,1,UpLen);
              Param:=DeleteFrontSpaces (Param);

              IF (Param[1] = '=') THEN
              BEGIN
                   Delete (Param,1,1);
                   Param:=DeleteFrontSpaces (Param);

                   IF (Pos ('"',Param) > 0) THEN
                   BEGIN
                        ExtractedFile:=Copy (Param,Pos ('"',Param)+1,255);
                        IF (Pos ('"',ExtractedFile) > 0) THEN
                           ExtractedFile:=Copy (ExtractedFile,1,Pos ('"',ExtractedFile)-1);
                   END ELSE
                   BEGIN
                        { RWI 970213 }

                        IF (Param[Length (Param)] = #13) THEN
                           Delete (Param,Length (Param),1);

                        ExtractedFile:=Param;
                   END;

                   IF NOT CreateFile (ExtractedFile) THEN
                      State:=dsAbort;
              END;
         END;
    END;

{ExtractFile}
BEGIN
     IF (State = dsStayDown) THEN
     BEGIN
          LoadLine;
          ExtractFile:=FALSE; { normal situation }
          Exit;
     END;

     { onthoud waar we nu staan in de swapfile en op welke regel   }
     { dat is. Als tijdens het decoderen iets mis gaat, dan kunnen }
     { we altijd nog hier naar terug gaan.                         }
     IF SwapIsOpen THEN
        SwapPos:=FilePos (SwapFile);

     OldRegelPtr:=EenRegelPtr;

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          { laad de volgende regel in -> Regel }
          LoadLine;

          IF (State <> dsFindBegin) THEN
             IF (Regel[Length (Regel)] = #13) THEN
                Delete (Regel,Length (Regel),1);

          CASE State OF
               dsFindBegin :
                   BEGIN
                        { things to detect and support:      }
                        { begin 666 ramon.zip                }
                        { begin 0600 ramon.zip               }
                        { begin 666 \simtel\subdir\ramon.zip }
                        IF (Length (Regel) > 10) AND (Copy (Regel,1,6) = 'begin ') AND
                           (Regel[7] IN ['0'..'9']) AND (Regel[8] IN ['0'..'9']) THEN
                        BEGIN
                             ExtractedFile:=Copy (Regel,11,255);

                             WHILE (ExtractedFile[Length (ExtractedFile)] = #13) DO
                                   Delete (ExtractedFile,Length (ExtractedFile),1);

                             ExtractedFile:=DeleteFrontAndBackSpaces (ExtractedFile);

                             IF CreateFile (ExtractedFile) THEN
                                State:=dsFindTypeUUXX
                             ELSE
                                 State:=dsAbort;
                        END;

                        IF (UpCaseString (Copy (Regel,1,14)) = 'CONTENT-TYPE: ') THEN
                        BEGIN
                             Delete (Regel,1,14);
                             Regel:=DeleteFrontSpaces (Regel);

                             { RWI 960325: now supports all type of "application/", like }
                             {             application/octet-stream                      }
                             {             application/zip                               }
                             IF ((UpCaseString (Copy (Regel,1,12)) = 'APPLICATION/') OR
                                 (UpCaseString (Copy (Regel,1,8)) = 'UNKNOWN/') OR
                                 (UpCaseString (Copy (Regel,1,6)) = 'IMAGE/') OR
                                 (UpCaseString (Copy (Regel,1,6)) = 'BASE64')) THEN
                             BEGIN
                                  ExtractedFile:=''; { nog niet gevonden }
                                  State:=dsFindCheckMime1;

                                  { RWI 960607: parameters now optional }
                                  IF (Pos (';',Regel) > 0) THEN
                                  BEGIN
                                       Delete (Regel,1,Pos (';',Regel));
                                       Regel:=DeleteFrontSpaces (Regel);

                                       { als er nog meer argumenten op deze }
                                       { regel staan, verwerk die dan.      }
                                       WHILE (Regel <> '') DO
                                       BEGIN
                                            IF (Pos (';',Regel) > 0) THEN
                                            BEGIN
                                                 ProcessMimeParam (Copy (Regel,1,Pos (';',Regel)));
                                                 Delete (Regel,1,Pos (';',Regel));
                                                 Regel:=DeleteFrontSpaces (Regel);
                                            END ELSE
                                            BEGIN
                                                 ProcessMimeParam (Regel);
                                                 Regel:='';
                                            END;
                                       END; { while }
                                  END;

                             END; { application/xxx, etc. }
                        END; { content-type }

                        IF (State = dsFindBegin) THEN
                        BEGIN
                             { worst case, maar helaas komt ie hier maar }
                             { al te vaak...                             }

                             { Regel is niet veranderd, dus die kunnen we }
                             { zo terug geven. Ga hier niet naar dsAbort, }
                             { want die laadt de regel nog een keer en    }
                             { dan zouden alle regels twee keer ingeladen }
                             { worden!!                                   }
                             ExtractFile:=FALSE;
                             Exit;
                        END;
                   END; { dsFindBegin }

               dsFindCheckMime1:
                   BEGIN
                        { process all other Content- headers }
                        { Content-Type was found and of correct type }

                        { controleren op het einde van de headers en het }
                        { begin van het encoded block.                   }

                        IF (Regel = '') THEN
                        BEGIN
                             IF Mime_Base64 AND (ExtractedFile <> '') THEN
                                State:=dsBase64Next
                             ELSE BEGIN
                                  IF (ExtractedFile = '') THEN
                                     LogMessage ('[DecodeMIME] Filename missing before MIME encoded block')
                                  ELSE
                                      IF (NOT Mime_Base64) THEN
                                         LogMessage ('[DecodeMIME] Encoding type indication missing before encoded block');

                                  State:=dsAbortOpen;  { assume failure }
                             END;
                        END ELSE
                            IF (NOT (Regel[1] IN [' ',#9])) AND { RWI 960830: vervolgregels nu mogelijk }
                               (UpCaseString (Copy (Regel,1,8)) <> 'CONTENT-')
                            THEN
                                State:=dsAbortOpen;

                        IF (State = dsFindCheckMime1) THEN
                        BEGIN
                             { controleer op een Content-Transfer-Encoding regel }
                             IF (UpCaseString (Copy (Regel,1,27)) = 'CONTENT-TRANSFER-ENCODING: ') THEN
                             BEGIN
                                  { if correct encoding found, then continue }
                                  IF (UpCaseString (Copy (Regel,28,255)) = 'BASE64') THEN
                                     Mime_Base64:=TRUE
                                  ELSE
                                      IF (UpCaseString (Copy (Regel,28,255)) = 'X-UUENCODE') THEN
                                      BEGIN
                                           { switch over the UU-encoding search }
                                           State:=dsFindXUUEncode;
                                           Regel:=''; { forget the rest }
                                      END ELSE
                                      BEGIN
                                           LogMessage ('[DecodeMIME] Unsupported MIME encoding method: '+Copy (Regel,28,255));
                                           State:=dsAbortOpen;
                                      END;
                             END;

                             IF (UpCaseString (Copy (Regel,1,20)) = 'CONTENT-DISPOSITION:') THEN
                             BEGIN
                                  { zorg dat blok beneden triggert voor variables processing }
                                  Regel:=' '+Copy (Regel,21,255);
                             END;

                             { controleer op vervolg regel }
                             { bijv: ' x-mac-type="705A4950"; x-mac-creator="705A4950"' }
                             IF (Regel[1] = ' ') OR (Regel[1] = #9) THEN
                             BEGIN
                                  { continuatie regel }
                                  WHILE (Regel <> '') DO
                                  BEGIN
                                       IF (Pos (';',Regel) > 0) THEN
                                       BEGIN
                                            ProcessMimeParam (Copy (Regel,1,Pos (';',Regel)-1));
                                            Delete (Regel,1,Pos (';',Regel));
                                            Regel:=DeleteFrontSpaces (Regel);
                                       END ELSE
                                       BEGIN
                                            ProcessMimeParam (Regel);
                                            Regel:='';
                                       END;
                                  END; { while }

                                  State:=dsFindCheckMime1; { overslaan }
                             END;
                        END;
                   END;

               dsFindXUUEncode:
                   BEGIN
                        IF (Length (Regel) > 10) AND (Regel[10] = ' ') AND (Copy (Regel,1,6) = 'begin ') THEN
                        BEGIN
                             ExtractedFile:=Copy (Regel,11,255);
                             WHILE (ExtractedFile[Length (ExtractedFile)] = #13) DO
                                   Delete (ExtractedFile,Length (ExtractedFile),1);

                             { verwijder de file als ie al open was }
                             {$I-} Close (OutFile); {$I+} IORes:=IOResult;
                             IF (IORes = 0) THEN
                             BEGIN
                                  {$I-} Erase (OutFile); {$I+} IORes:=IOResult;
                             END;

                             IF CreateFile (ExtractedFile) THEN
                                State:=dsFindTypeUUXX
                             ELSE
                                 State:=dsAbort;

                             Regel:=''; { voorkom trigger op volgende }
                        END;

                        IF (Regel <> '') THEN
                           IF (NOT (Regel[1] IN [' ',#9])) AND { RWI 960830: vervolgregels nu mogelijk }
                              (UpCaseString (Copy (Regel,1,8)) <> 'CONTENT-') THEN
                           BEGIN
                                LogMessage ('[XUUEDecode] (aborting) Unexpected: '+Regel);
                                State:=dsAbort;
                           END;
                   END;

               dsFindTypeUUXX:
                   BEGIN
                        { RWI 970101 }
                        IF (Regel[Length (Regel)] = ' ') THEN
                           Delete (Regel,Length (Regel),1);

                        L:=Length (Regel)-1;
                        { RWI 961006: controle aangepast }
                        {IF ((L MOD 4) = 0) THEN}
                        IF (L > 0) THEN
                        BEGIN
                             L:=(L DIV 4)*3;
                             IF (Regel[1] IN [UUChars[L+1],UUChars[L],UUChars[L-1]]) THEN
                             BEGIN
                                  State:=dsUUXX;

                                  FOR Lp:=0 TO 255 DO
                                      Ch2Byte[Lp]:=255;

                                  FOR Lp:=1 TO Length (UUChars) DO
                                      Ch2Byte[Ord (UUChars[Lp])]:=Lp-1;

                                  Ch2Byte[32]:=0;  { spatie ipv ` }
                             END ELSE
                                 IF (XXChars[L+1] = Regel[1]) THEN
                                 BEGIN
                                      State:=dsUUXX;

                                      FOR Lp:=0 TO 255 DO
                                          Ch2Byte[Lp]:=255;

                                      FOR Lp:=1 TO Length (XXChars) DO
                                          Ch2Byte[Ord (XXChars[Lp])]:=Lp-1;
                                 END;
                        END;

                        IF (State = dsFindTypeUUXX) THEN
                        BEGIN
                             LogMessage ('Could not detect UU or XX encoding in the following line:');
                             LogExtraMessage (Regel);
                             State:=dsAbortOpen;
                        END;
                   END;
          END; { case }

          CASE State OF
               dsUUXX:
                   BEGIN
                        IF (Regel = '') THEN
                        BEGIN
                             LogMessage ('Unexpected empty line in UU/XX encoded block; aborting');
                             State:=dsAbortOpen  { multi part? }
                        END ELSE
                        BEGIN
                             { RWI970101 }
                             IF (Regel[Length (Regel)] = ' ') THEN
                                Delete (Regel,Length (Regel),1);

                             { decodeer en controleer lengte van de regel }
                             Len:=Ch2Byte[Byte (Regel[1])];

                             IF (Len = 0) THEN
                                { zo hoort het! }
                                State:=dsUUXXCheckEnd { einde bereikt! }
                             ELSE
                                 IF (Len = 255) THEN
                                 BEGIN
                                      LogMessage ('[DecodeUUXX] Invalid line length specifier: '+Regel[1]);
                                      State:=dsAbortOpen;
                                 END;
                        END;

                        IF (State = dsUUXX) THEN
                        BEGIN
                             L:=Len DIV 3;

                             { RWI 960512: 'E' -> Len=37 -> L=12 = 36 tekens }
                             { BlockWrite neemt Len=37 -> laatste byte fout! }
                             IF (L*3 < Len) THEN
                                Inc (L);

                             { Zorg voor genoeg data }
                             IF (Length (Regel) < 1+L*4) THEN
                                Regel:=Regel+'AA';

                             GetPos:=2;
                             StorePos:=1;

                             FOR Lp:=1 TO L DO
                             BEGIN
                                  V1:=Ch2Byte[Byte (Regel[GetPos+0])];
                                  V2:=Ch2Byte[Byte (Regel[GetPos+1])];
                                  V3:=Ch2Byte[Byte (Regel[GetPos+2])];
                                  V4:=Ch2Byte[Byte (Regel[GetPos+3])];

                                  IF (V1 = 255) OR (V2 = 255) OR (V3 = 255) OR (V4 = 255) THEN
                                  BEGIN
                                       LogMessage ('[DecodeUUXX] Error in line sequence: '+Copy (Regel,GetPos,4));
                                       State:=dsAbortOpen;
                                       Break;
                                  END;

                                  Inc (GetPos,4);

                                  Buf[StorePos+0]:=(V1 SHL 2) OR ((V2 AND $30) SHR 4);
                                  Buf[StorePos+1]:=((V2 AND 15) SHL 4) OR ((V3 AND $3C) SHR 2);
                                  Buf[StorePos+2]:=((V3 AND 3) SHL 6) OR V4;

                                  Inc (StorePos,3);
                             END; { for }

                             BlockWrite (OutFile,Buf,Len);
                        END;
                   END; { dsUUXX }

               dsUUXXCheckEnd :
                   IF (Regel = 'end') THEN
                   BEGIN
                        IF (EenRegelPtr = NIL) THEN
                           State:=dsClose { 'end' als laatste regel nu mogelijk }
                        ELSE
                            State:=dsUUXXSkipSum
                   END ELSE
                       { unexpected end file file! }
                       { no logging...! }
                       State:=dsAbortOpen;

               dsUUXXSkipSum :
                   IF (EenRegelPtr = NIL) OR               { absolute end }
                      (Copy (Regel,1,11) <> 'sum -r/size') { skip these }
                   THEN
                       State:=dsClose;

               dsBase64Next :
                   BEGIN
                        { volgende regel bevat de eerste data }
                        State:=dsBase64;

                        { vul de decodeer tabel in voor MIME }
                        FOR Lp:=0 TO 255 DO
                            Ch2Byte[Lp]:=255;

                        FOR Lp:=1 TO Length (Base64) DO
                            Ch2Byte[Ord (Base64[Lp])]:=Lp-1;

                        Ch2Byte[Ord ('=')]:=254; { voor detectie aan het einde }
                   END;

               dsBase64:
                   IF (Regel = '') THEN
                        State:=dsClose  { einde bereikt }
                   ELSE BEGIN
                        IF ((Length (Regel) MOD 4) <> 0) THEN
                        BEGIN
                             LogMessage ('[DecodeMIME] Base64 coded line does not comply to the pair4 test');
                             State:=dsClose;
                        END;

                        L:=Length (Regel) DIV 4;

                        GetPos:=1;
                        StorePos:=1;

                        FOR Lp:=1 TO L DO
                        BEGIN
                             V1:=Ch2Byte[Byte (Regel[GetPos+0])];
                             V2:=Ch2Byte[Byte (Regel[GetPos+1])];
                             V3:=Ch2Byte[Byte (Regel[GetPos+2])];
                             V4:=Ch2Byte[Byte (Regel[GetPos+3])];

                             Inc (GetPos,4);

                             IF (V1 = 255) OR (V2 = 255) OR (V3 = 255) OR (V4 = 255) THEN
                             BEGIN
                                  LogMessage ('[DecodeMIME] Error in line sequence: '+Copy (Regel,1,4));
                                  State:=dsClose;
                                  Break;
                             END;

                             Buf[StorePos+0]:=(V1 SHL 2) OR ((V2 AND $30) SHR 4);
                             Buf[StorePos+1]:=((V2 AND 15) SHL 4) OR ((V3 AND $3C) SHR 2);
                             Buf[StorePos+2]:=((V3 AND 3) SHL 6) OR V4;

                             IF (V4 = 254) THEN
                             BEGIN
                                  Inc (StorePos); { 16 bits at the end }

                                  IF (V3 <> 254) THEN
                                     Inc (StorePos);  { 8 bits at the end }

                                  State:=dsClose;
                                  Break;
                             END;

                             Inc (StorePos,3);
                        END;

                        BlockWrite (OutFile,Buf,StorePos-1);
                   END;

          END; { case }

          IF (State = dsClose) THEN
          BEGIN
               Close (OutFile);

               { RWI 960929: voorkom "extracted xyz as XYZ" because of }
               {             case difference.                          }
               IF (OriginalName <> '') AND (ExtractPath+UpCaseString (OriginalName) = ExtractedFile) THEN
               BEGIN
                    Regel:=OriginalName;
                    OriginalName:='';
               END ELSE
                   Regel:=ExtractedFile;

               WHILE (Pos ('\',Regel) > 0) DO
                     Delete (Regel,1,Pos ('\',Regel));

               IF (OriginalName <> '') THEN
                  Regel:=OriginalName+' '+GetLang1 (204,Regel);

               Regel:=GetLang1 (203,Regel);

               IF (ExtractArea <> '') THEN
                  LogMessage (Regel+' in '+ExtractArea)
               ELSE
                   LogMessage (Regel);

               Regel:='*** '+Regel+#13+#13 { lege regel erachter };

               { restart the state machine }
               StateReset;

               { return that we have now extracted a file }
               ExtractFile:=TRUE;
               Exit;
          END;

          IF (State = dsAbortOpen) THEN
          BEGIN
               { het is mogelijk dat de file niet open is (bij MIME) }
               {$I-} Close (OutFile); {$I+} IORes:=IOResult;

               IF (IORes = 0) THEN
               BEGIN
                    {$I-} Erase (OutFile); {$I+} IORes:=IOResult;
                    IF (IORes <> 0) THEN
                       LogDiskIOError (IORes,'Error deleting '+ExtractedFile);
               END;

               State:=dsAbort;
          END;

          IF (State = dsAbort) THEN
          BEGIN
               { ga terug naar de plek voordat we hier kwamen }
               IF SwapIsOpen THEN
                  Seek (SwapFile,SwapPos);

               EenRegelPtr:=OldRegelPtr;

               { laad die regel opnieuw }
               LoadLine;

               { restart the state machine for the next entry }
               StateReset;

               { en geef em gewoon terug }
               ExtractFile:=FALSE;
               Exit;
          END;

     END; { while }

     { if we come here, then we have reached the end of the message, }
     { but did not find the end of the encoded file.                 }
     LogMessage ('Unexpected end of (multi part?) message');

     { file moet natuurlijk wel dichtgegooid worden! }
     {$I-} Close (OutFile); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
        LogExtraMessage ('  Keeping (partial?) result file '+ExtractedFile);

     { rest zoals dsAbort }

     { ga terug naar de plek voordat we hier kwamen }
     IF SwapIsOpen THEN
        Seek (SwapFile,SwapPos);

     EenRegelPtr:=OldRegelPtr;

     { laad die regel opnieuw }
     LoadLine;

     { restart the state machine for the next entry }
     StateReset;

     { en geef em gewoon terug }
     ExtractFile:=FALSE;
END;


{--------------------------------------------------------------------------}
{ DecodeBase64Header                                                       }
{                                                                          }
{ This routine decodes a base64 encoded header and returns the 8-bit       }
{ result.                                                                  }
{                                                                          }
FUNCTION DecodeBase64Header (Line : STRING) : STRING;

VAR Ch2Byte     : ARRAY[0..255] OF BYTE;
    Lp,
    L,
    GetPos,
    StorePos,
    V1,V2,V3,V4 : BYTE;

BEGIN
     DecodeBase64Header:=Line; { just Exit in case of errors }

     { vul de decodeer tabel in voor MIME }
     FOR Lp:=0 TO 255 DO
         Ch2Byte[Lp]:=255;

     FOR Lp:=1 TO Length (Base64) DO
         Ch2Byte[Ord (Base64[Lp])]:=Lp-1;

     Ch2Byte[Ord ('=')]:=254; { voor detectie aan het einde }

     IF ((Length (Line) MOD 4) <> 0) THEN
     BEGIN
          LogMessage ('[MimeHeader] Base64 coded line does not comply to the pair4 test');
          Exit; { keep original }
     END;

     L:=Length (Line) DIV 4;

     GetPos:=1;
     StorePos:=1;

     FOR Lp:=1 TO L DO
     BEGIN
          V1:=Ch2Byte[Byte (Line[GetPos+0])];
          V2:=Ch2Byte[Byte (Line[GetPos+1])];
          V3:=Ch2Byte[Byte (Line[GetPos+2])];
          V4:=Ch2Byte[Byte (Line[GetPos+3])];

          Inc (GetPos,4);

          IF (V1 = 255) OR (V2 = 255) OR (V3 = 255) OR (V4 = 255) THEN
          BEGIN
               LogMessage ('[MimeHeader] Error in line sequence: '+Copy (Line,1,4));
               Exit; { keep original }
          END;

          Line[StorePos+0]:=Char ((V1 SHL 2) OR ((V2 AND $30) SHR 4));
          Line[StorePos+1]:=Char (((V2 AND 15) SHL 4) OR ((V3 AND $3C) SHR 2));
          Line[StorePos+2]:=Char (((V3 AND 3) SHL 6) OR V4);

          IF (V4 = 254) THEN
          BEGIN
               Inc (StorePos); { 16 bits at the end }

               IF (V3 <> 254) THEN
                  Inc (StorePos);  { 8 bits at the end }

               Line[0]:=Char (StorePos-1);
               DecodeBase64Header:=Line;
               Exit;
          END;

          Inc (StorePos,3);
     END;

     { fill in changed length }
     Line[0]:=Char (StorePos-1);
     DecodeBase64Header:=Line;
END;


{--------------------------------------------------------------------------}
{ Unit initialization                                                      }
{                                                                          }
BEGIN
     ExtractPath:='';
     ExtractedFile:='';
     State:=dsStayDown;
END.
