UNIT FidoPack;

{ all code to "pack" outbounds }

INTERFACE

PROCEDURE Fido_Pack;


IMPLEMENTATION

USES Ramon,
     Dos,
     Cfg,
     Database,
     FidoPkt,
     Logs,
     NewExec,
     Fido,
     Routing,
     ReadRout,
     Usenet,
     UU,
     Msgs,
     Globals,
     Start,
     UserBase,
     AreaBase,
     Binkley,
     DBridge,
     Strings,
     FD;

{--------------------------------------------------------------------------}
{ PackFtnOutbound                                                          }
{                                                                          }
{ Deze routine loopt alle .QQQ files af in de FTN outbound directory,      }
{ zoekt uit voor welke node ze zijn en begint/update de archive met de in  }
{ .PKT hernoemde .QQQ file, mits ze een archive optie gekozen hebben,      }
{ anders blijven de .PKT files gewoon staan.                               }
{                                                                          }
PROCEDURE PackFtnOutbound;

VAR Search     : SearchRec;
    QQQFile    : FILE;
    NewDir     : STRING[79];
    Destination_Dir,
    Flagsline,
    Tmp        : STRING;
    IORes      : BYTE;
    Header     : FidoPktHdr;
    TmpAdres,
    QQQSource,
    QQQDest    : FidoAddrType;
    QQQRecNr   : UserBaseRecordNrType;
    OutName,
    OUTFileName: STRING[12];
    Nop,Dow    : WordLong;
    ProcessedAtLeastOneFile,
    NewAttachFile,
    Failed     : BOOLEAN;

    Address    : FidoAddrType;
    SendFormat : SendType;
    Compression: CompressionType;

    {----------------------------------------------------------------------}
    { FidoCompress                                                         }
    {                                                                      }
    { Deze routine gebruikt de argumenten als volgt:                       }
    {               <Compressor> <Directory><ArchiveFile> <Filename>       }
    { Bijvoorbeeld: PKZIP A C:\OUTBOUND.001\00004512.ZIP 12345678.PKT      }
    {                                                                      }
    FUNCTION FidoCompress (Directory,ArchiveFile,FileName : STRING) : BOOLEAN;

    VAR GoExecHulp   : STRING[MaxLenComprPrgDescr];
        KillFile     : FILE;
        TmpDirectory : STRING;

    BEGIN
         FidoCompress:=FALSE;

         { roep het juiste compressie programma aan }
         GoExec (Config.ComprPrgs_F[Compr,Compression],
                 Directory+ArchiveFile+' '+FileName,
                 'Adding .PKT file to archive for '+Fido2Str (Address));

         { en analyseer het resultaat }
         IF (ExecRes > $0000) THEN
         BEGIN
              Failed:=TRUE;
              LogMessage ('Program failure: '+Config.ComprPrgs_F[Compr,Compression]);
              LogClose; { ## TEMP ## }
              Exit;
         END;

         Assign (KillFile,FileName);
         {$I-} Erase (QQQFile); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'Unable to delete '+Filename);

         FidoCompress:=TRUE;
    END;


    {----------------------------------------------------------------------}
    { CreateFlagFile                                                       }
    {                                                                      }
    { Creer een lege file om de mailer te waarschuwen dat hij beter actie  }
    { kan ondernemen.                                                      }
    {                                                                      }
    { RWI 251094: Veranderd zodat er nu een compleet pad + FILENAME        }
    {             opgegeven moet worden. Voor FrontDoor werd FDRESCAN.NOW  }
    {             opgegeven en voor D'Bridge DBRIDGE.RSN. Nu kan ook       }
    {             FMRESCAN.NOW en IMRESCAN.NOW of zelf RESCAN.GO! gebruikt }
    {             worden.                                                  }
    {                                                                      }
    PROCEDURE CreateFlagFile;

    VAR FlagFile : FILE;

    BEGIN
         IF (DeleteBackSpaces (Config.RescanFlagFile) = '') THEN
            Exit; { niet opgegeven, dus niet aanmaken }

         Assign (FlagFile,Config.RescanFlagFile);
         {$I-} ReWrite (FlagFile,0); {$I+} IORes:=IOResult;
         IF (IORes = 0) THEN
         BEGIN
              {$I-} Close (FlagFile); {$I+} IORes:=IOResult;
         END;

         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'Error creating rescan flag file '+Config.RescanFlagFile);
              LogClose; { ## TEMP ## }
         END;
    END;


    {----------------------------------------------------------------------}
    { RenamePktBackToQQQ                                                   }
    {                                                                      }
    { Deze routine hernoemd de in .PKT hernoemde .?QQ file weer terug naar }
    { .CQQ of .QQQ.                                                        }
    {                                                                      }
    PROCEDURE RenamePktBackToQQQ (CurrName : STRING; SendFormat : SendType);

    VAR IORes : BYTE;
        AFile : FILE;
        Name  : STRING;

    BEGIN
         Name:=CurrName;
         Assign (AFile,CurrName);

         { extensie vervangen }
         CurrName:=Copy (CurrName,1,Length (CurrName)-3)+'QQQ';

         IF (SendFormat = CRASH) THEN
            CurrName[Length (CurrName)-2]:='C';

         {$I-} Rename (AFile,CurrName); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'Error renaming '+Name+' back to '+CurrName)
         ELSE
             LogMessage ('Renamed '+Name+' back to '+CurrName);

         LogClose; { ## TEMP ## }
    END;


    {----------------------------------------------------------------------}
    { WriteMailTunnelEmails                                                }
    {                                                                      }
    { Deze routine scant de outbound voor mail tunnel archives en encode   }
    { deze in e-mails voor de tunnel target adressen.                      }
    { Outbound is nog steeds de huidige directory.                         }
    {                                                                      }
    { Sla de laatste archive over als deze nog niet groot genoeg is.       }
    {                                                                      }
    PROCEDURE WriteMailTunnelEmails;

    VAR TunnelPtr : MailTunnelPtr;
        Latest    : LONGINT;
        Search    : SearchRec;

        PROCEDURE SendTunnelFiles;

        VAR DelFile    : FILE;
            ReachedEnd : BOOLEAN;
            StartOver  : BOOLEAN;   { removed a file, restart findfirst/next }

        BEGIN
             { nu steeds een archive zoeken totdat er geen over zijn, }
             { of alleen die ene die nog niet groot genoeg is.        }

             REPEAT
                   { now start searching over again for the oldest }
                   FindFirst (TunnelPtr^.ArchiveName+'.*',Archive,Search);
                   ReachedEnd:=(DosError <> 0);

                   IF (NOT ReachedEnd) THEN
                   BEGIN
                        StartOver:=FALSE;

                        WHILE (NOT StartOver) DO
                        BEGIN
                             IF (Search.Time <> Latest) OR { always send not-last archives }
                                (Search.Size >= TunnelPtr^.MinimumSize*1024) THEN
                             BEGIN
                                  { minimum archive size reached }
                                  LogMessage ('Tunneling '+Search.Name+' to '+TunnelPtr^.EMailAddress);
                                  LogClose; { ## TEMP ## }

                                  UsenetBuildMail (TunnelPtr^.EmailAddress,
                                                   'mailtunnel@'+Config.Domains[1],
                                                   'WaterGate MailTunnel Server',
                                                   'MailTunnel Delivery');

                                  XX_FileToBody (Search.Name,FALSE,FALSE);

                                  Assign (DelFile,Search.Name);
                                  {$I-} Erase (DelFile); {$I+} IORes:=IOResult;
                                  IF (IORes <> 0) THEN
                                  BEGIN
                                       LogDiskIOError (IORes,'Error deleting '+Search.Name);
                                       LogExtraMessage ('Security abort');
                                       LogClose; { ## TEMP ## }
                                       MsgsEmpty;
                                       Exit;
                                  END;

                                  UsenetRouteMail;

                                  StartOver:=TRUE; { file deleted, search again }
                             END ELSE
                             BEGIN
                                  FindNext (Search);

                                  IF (DosError <> 0) THEN
                                  BEGIN
                                       StartOver:=TRUE;  { abort while }
                                       ReachedEnd:=TRUE; { abort repeat }
                                  END;
                             END;

                        END; { while not startover }

                   END; { if not reached end }

                   FindClose (Search);

             UNTIL ReachedEnd;
        END;

    { WriteMailTunnelEmails }

    LABEL GaVerder;

    BEGIN
         TunnelPtr:=MailTunnelList.GetFirstItem;

         WHILE (TunnelPtr <> NIL) DO
         BEGIN
              { make sure this is a tunnel-to }
              IF (TunnelPtr^.FromOrTo <> mtTo) THEN
                 GOTO GaVerder;

              { find the latest archive. We have to do minimum size }
              { checking against _that_ archive only to prevent TH0 }
              { from never being sent when FR0 has been created...  }

              FindFirst (TunnelPtr^.ArchiveName+'.*',Archive,Search);
              IF (DosError <> 0) THEN
                 GOTO GaVerder;

              { als er meer zijn, bepaal dan de jongste voor min. archive check }
              Latest:=Search.Time;

              REPEAT
                    IF (Search.Time > Latest) THEN
                       Latest:=Search.Time;
                    FindNext (Search);
              UNTIL (DosError <> 0);

              SendTunnelFiles;

         GaVerder:

              FindClose (Search);

              TunnelPtr:=MailTunnelList.GetNextItem2 (TunnelPtr);
         END; { while }

         MsgsEmpty; { voor het geval dat er nog wat rond hing }
    END;


{ PackFtnOutbound }

LABEL SkipToNextPacket;

VAR OldDir,
    OldCurr   : PathStr;
    TunnelPtr : MailTunnelPtr;
    SysOp     : STRING[MaxLenSysOpName];

BEGIN
     UpdateAction ('Packing FTN outbound');

     Config.Outbound_F:=UpCaseString (Config.Outbound_F);
     ProcessedAtLeastOneFile:=FALSE;
     GetDir (0,OldCurr);

     GetDate (Nop,Nop,Nop,Dow);

     { is nu nog slechts de ene outbound die we hebben }
     NewDir:=FExpand (Config.Outbound_F);
     IF (NewDir[Length (NewDir)] = '\') AND (NewDir[Length (NewDir)-1] <> ':') THEN
        Delete (NewDir,Length (NewDir),1);

     { RWI 960904: now track the current directory on the outbound drive }
     GetDir (Ord (NewDir[1])-Ord ('A')+1,OldDir);

     { Alle QQQ's staan voor het gemak in 1 outbound directory  }
     { Hier worden ze gerenamed, gecomprimeerd en evt verplaats }

     {$I-} ChDir (NewDir); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Invalid FTN outbound: "'+NewDir+'"');
          Exit;
     END;

     { Doorloop de Outbound directory op zoek naar *.QQQ files }
     { en naar *.CQQ files voor crash outbound files           }

     { RWI 951231:                                                        }
     { De huidige directory veranderd nooit. Als de target archive in een }
     { andere directory aangemaakt moet worden, dan zorgt de archiver     }
     { daar voor. Bij binkley verandert dus NOOIT de huidige directory!   }

     FindFirst ('*.?QQ',Archive,Search);
     WHILE (NOT GlobalAbort) AND (DosError = 0) DO
     BEGIN
          LogClose; { ## TEMP ## }

          { Zorg ervoor dat we alleen *.QQQ & *.CQQ files kunnen openen! }
          IF NOT (Search.Name[10] IN ['Q','C']) THEN
             GOTO SkipToNextPacket;

          Failed:=FALSE;
          ProcessedAtLeastOneFile:=TRUE;

          { Probeer de QQQ file te openen en lees de binaire header }
          { in pluk hieruit het adres van de TO node en lees het    }
          { bijbehorende userbase record in.                        }

          UpdateReadFile (Config.Outbound_F+Search.Name,Search.Size);

          Assign (QQQFile,Search.Name);

          { RWI 960819: clean files that were left behind }
          IF (Search.Size = 0) THEN
          BEGIN
               {$I-} Erase (QQQFile); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'Error deleting 0-length file: '+Search.Name)
               ELSE
                   LogMessage ('Deleted 0-length outbound file: '+Search.Name);

               GOTO SkipToNextPacket;
          END;

          {$I-} Reset (QQQFile,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[FidoPack] Cannot open .?QQ file: '+Search.Name);
               GOTO SkipToNextPacket;
          END;

          {$I-} BlockRead (QQQFile,Header,SizeOf (FidoPktHdr)); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Error reading .?QQ file header '+Search.Name);

          {$I-} Close (QQQFile); {$I+} IORes:=IORes OR IOResult;

          IF (IORes <> 0) THEN
             GOTO SkipToNextPacket;

          { Decodeer de informatie die in de header zat naar een }
          { compleet 4D fido adres.                              }
          WITH QQQDest DO
          BEGIN
               Zone:=Header.Dest_zone;
               Net:=Header.Dest_net;
               Node:=Header.Dest_node;
               Point:=Header.Dest_point;
               Domain:=FidoGetZoneDomain (Zone); { RAWI 971206 }
          END; { with }

          WITH QQQSource DO
          BEGIN
               Zone:=Header.Orig_zone;
               Net:=Header.Orig_net;
               Node:=Header.Orig_node;
               Point:=Header.Orig_point;
               Domain:='';
          END; { with }

          LogMessage (Search.Name+' file destination: '+Fido2Str (QQQDest));
          LogClose; { ## TEMP ## }

          TunnelPtr:=GetMailTunnelTo (QQQDest);

          { Laad het node record in waar we naartoe gaan zenden }
          IF (NOT FindUserBaseRecordByFidoAddress (QQQDest,QQQRecNr)) THEN
          BEGIN
               { Het doel systeem niet direct aan ons bekent, nu moeten }
               { we improviseren aan de hand van de defaults.           }
               Compression:=Config.DefaultCompressor;
               SendFormat:=NORMAL;
               Address:=QQQDest;
               SysOp:='SysOp';
          END ELSE
          BEGIN
               { neem de instellingen over uit het userbase record }
               ReadUserBaseRecord (QQQRecNr,UserData);

               Compression:=UserData.Compression;
               SendFormat:=UserData.SendFormat;
               Address:=UserData.Address;
               SysOp:=UserData.SysOp;

               IF (Compression = PKT) AND (TunnelPtr <> NIL) THEN
               BEGIN
                    LogMessage ('WARNING: No compression set for Tunnel-To user! Using default.');
                    Compression:=Config.DefaultCompressor;
               END;
          END;

          { Een *.CQQ file overides the default SendFormat routing }
          IF (Search.Name[10] = 'C') THEN
             SendFormat:=CRASH;

          { Binkley: Zoek uit naar welke directory geschreven moet }
          {          worden, en plaats een BUSY vlag zodat de node }
          {          node niet begint te zenden op het moment dat  }
          {          wij aan het inpakken zijn.                     }
          IF (TunnelPtr = NIL) AND (Config.FidoSystem = stBinkley) THEN
          BEGIN
               Destination_Dir:=BinkleyOutbound (QQQDest);
               { bevat altijd een \ aan het einde }

               { Controle op BINKLEY.BSY flags !!!!! }
               IF BinkCheckBusy (Destination_Dir,{UserData.}Address) THEN
               BEGIN
                    LogExtraMessage ('Skipping '+StrPas (FileRec (QQQFile).Name)+' because Binkley node is busy!');
                    LogClose; { ## TEMP ## }
                    GOTO SkipToNextPacket;
               END;
          END;

          { verander de naam van de QQQ in PKT }
          Tmp:=StrPas (FileRec (QQQFile).Name);
          Tmp:=Copy (Tmp,1,Length (Tmp)-3)+'PKT';
          {$I-} Rename (QQQFile,Tmp); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'Error renaming '+Search.Name);
               LogClose; { ## TEMP ## }

               { RWI 951217: added deletion of .BSY file }
               IF (TunnelPtr = NIL) AND (Config.FidoSystem = stBinkley) THEN
                  BinkClearBusy (Destination_Dir,Address);

               FindNext (Search);
               Continue;
          END;

          { kijken welke compressie methode we gaan gebruiken }
          IF (Compression <> PKT) THEN
          BEGIN
               IF (TunnelPtr <> NIL) THEN
               BEGIN
                    { compression with the user set compression format, }
                    { but always keep the files in the main outbound.   }
                    { use special filenames as well.                    }

                    OutFilename:=TunnelPtr^.ArchiveName;
                    OutFilename:=OutFilename+FidoGetExtension (OutFileName,QQQRecNr,Config.Outbound_F);

                    IF (NOT FidoCompress (Config.Outbound_F,OutFileName,StrPas (FileRec (QQQFile).Name))) THEN
                    BEGIN
                         { packing failed }
                         RenamePktBackToQQQ (StrPas (FileRec (QQQFile).Name),SendFormat);
                         GOTO SkipToNextPacket;
                    END;
               END ELSE
               BEGIN
                    IF (Config.FidoSystem = stBinkley) THEN
                    BEGIN
                         IF (QQQDest.Point > 0) THEN
                            OutFileName:=Long2HexString (QQQDest.Point)
                         ELSE
                             WITH Header DO
                                  OUTFileName:=Word2HexString (Orig_Net-Dest_Net)+
                                               Word2HexString (Orig_Node-Dest_Node);

                        { Kijk of er archives bestaan met dezelfde naam, }
                        { maar met een lengte van 0 bytes.               }
                        OutFileName:=OutFileName+FidoGetExtension (OutFileName,QQQRecNr,Destination_Dir);

                        { run de archiver }
                        IF (NOT FidoCompress (Destination_Dir,OutFileName,StrPas (FileRec (QQQFile).Name))) THEN
                        BEGIN
                             RenamePktBackToQQQ (StrPas (FileRec (QQQFile).Name),SendFormat);
                             { verwijder de binkley .BSY vlag }
                             BinkClearBusy (Destination_Dir,Address);
                             GOTO SkipToNextPacket;
                        END; { packing failed }
                    END; { binkley }

                    IF (Config.FidoSystem = stFrontDoor) THEN
                    BEGIN
                         OutFilename:=FrontDoorGetOutboundFile (Config.Outbound_F,QQQDest,QQQSource,NewAttachFile,QQQRecNr);

                         { RWI 951105: debug log uitgezet.
                         LogMessage ('*** QQQDest='+Fido2Str (QQQDest)+
                                     ', QQQSource='+Fido2Str (QQQSource)+
                                     ', OutFilename='+OutFilename);
                         }

                         { run de archiver }
                         IF (NOT FidoCompress (Config.Outbound_F,OutFileName,StrPas (FileRec (QQQFile).Name))) THEN
                         BEGIN
                              RenamePktBackToQQQ (StrPas (FileRec (QQQFile).Name),SendFormat);
                              GOTO SkipToNextPacket;
                         END; { packing failed }
                    END; { frontdoor }

                    IF (Config.FidoSystem = stDBridge) THEN
                    BEGIN
                         WITH Header DO
                              IF (QQQDest.Point > 0) THEN
                                 OutFileName:='P'+Copy (Word2HexString (Dest_Node),2,3)+Word2HexString (Dest_Point)
                              ELSE
                                  OutFileName:=Word2HexString (Orig_Net-Dest_Net)+
                                               Word2HexString (Orig_Node-Dest_Node);

                         OutFileName:=OutFileName+FidoGetExtension (OutFileName,QQQRecNr,'');

                         { run de archiver }
                         IF (NOT FidoCompress (Config.Outbound_F,OutFileName,StrPas (FileRec(QQQFile).Name))) THEN
                         BEGIN
                              RenamePktBackToQQQ (StrPas (FileRec (QQQFile).Name),SendFormat);
                              GOTO SkipToNextPacket;
                         END; { packer failed }
                    END; { d'bridge }
               END;
          END ELSE
          BEGIN
               { PKT archiving }
               Tmp:=StrPas (FileRec (QQQFile).Name);
               OutFileName:=Copy (Tmp,Length (Tmp)-11,255);
          END;

          IF (TunnelPtr = NIL) THEN
          BEGIN
               { Als de target directory anders is dan de huidige, verplaats }
               { dan het archive naar de doel directory.                     }
               { 'Bereken' de binkley stijl outbound directory               }
               IF (Config.FidoSystem = stBinkley) THEN
               BEGIN
                    { creeren van Binkley Flag File }
                    IF (NOT BinkCreateOutfile ('^',Destination_Dir,OutFilename,Address,SendFormat)) THEN
                    BEGIN
                         LogMessage ('[FidoPack] Unable to create Binkley *.?LO file');
                         GOTO SkipToNextPacket;
                    END;

                    IF (Compression = PKT) THEN
                    BEGIN
                         { de .PKT file staat nog steeds in de outbound directory }
                         { zelf. Verplaats em nu naar de subdirectory.            }
                         { RWI 960209: dit ging dus mis als source=destination }
                         IF (NOT MoveFileWithDirectory (OutFilename,Destination_Dir+OutFilename)) THEN
                            LogMessage ('Error moving '+OutFilename+' to '+Destination_Dir);
                    END;

                    { ok, dan kan nu de .BSY vlag weer weg... }
                    BinkClearBusy (Destination_Dir,Address);
               END; { binkley }

               IF (Config.FidoSystem = stFrontdoor) THEN
               BEGIN
                    { Controleer eerst of we er al een attach voor deze node }
                    { is. Zoja, dan heeft het weinig zin om een nieuwe te    }
                    { creeren.                                               }
                    IF NewAttachFile THEN
                    BEGIN
                         { FrontDoor                                    }
                         { Zorg dat in een Frontdoor omgeving, de enige }
                         { netmail outbound een FidoMsgType is.         }
                         FidoBuildNetmail (TRUE{empty},
                                           Config.NodeNrs[FidoMatchAdres (Address,TmpAdres)],
                                           Address,
                                  { from } 'ARCmail',
                                  { to }   Sysop,
                                  { subj } Config.Outbound_F+OutFileName);

                         { slordig maar wel nodig, haal de tearline uit }
                         { het bericht.                                 }
                         MsgsReleaseLines (Msg.FooterTop_F);

                         { voeg Private/Kill_Sent/File_Attach vlaggen toe }
                         { RWI970101: truncate sent wordt niet meer toegevoegd }
                         { RWI970112: added truncate/sent again }
                         FidoAddToExtFlag (EXTMSGPVT OR EXTMSGK_S OR EXTMSGFIL OR EXTMSGTFS);

                         CASE UserData.SendFormat OF
                              Hold   : FidoAddToExtFlag (EXTMSGHLD);
                              Crash  : FidoAddToExtFlag (EXTMSGCRA);
                              Direct : FidoAddToExtFlag (EXTMSGDIR);
                         END; { case }

                         { Schrijf ^aFLAGS in het bericht }
                         FidoExportExtFlag;

                         Msg.Attr_F:=Msg.Attr_F OR MSGFILE OR MSGLOCAL OR MSGKILL;
                         IF (UserData.SendFormat = Hold) THEN
                            Msg.Attr_F:=Msg.Attr_F OR MSGHOLD;

                         AreaData.FidoMsgPath:=Config.FidoNetmailPath;
                         AreaData.AreaName_F:='Netmail';

                         { schrijf het file attach netmailtje }
                         FidoImportNetmail;
                    END; { newattachfile }
               END; { frontdoor }

               IF (Config.FidoSystem = stDbridge) THEN
               BEGIN
                    { Creer een D'Bridge compatible queue file op disk }
                    DBridgeCreateQueueFile (OutFileName,Address,SendFormat);
               END; { d'bridge }
          END;

SkipToNextPacket:
          FindNext (Search);

          IF KeyPressed AND (Ramon.ReadKey = kEsc) THEN
             GlobalAbort:=TRUE;

     END; { while }

     FindClose (Search);

     { creer flag files voor frontdoor en d'bridge systems }
     IF ProcessedAtLeastOneFile AND (Config.FidoSystem IN [stFrontdoor,stDBridge]) THEN
        CreateFlagFile;

     IF (NOT ForceNoTunnel) THEN
        WriteMailTunnelEmails;

     ChDir (OldDir);   { change back on outbound drive }
     ChDir (OldCurr);  { change back to old drive + path }
END;


{--------------------------------------------------------------------------}
{ PackBbsOutbounds                                                         }
{                                                                          }
{ Deze routine doorloopt de user base op zoek naar BBS Interface users en  }
{ "pack"t daarna de outbound voor die user. Dit is simpelweg het hernoemen }
{ van .QQQ files in .PKT.
{                                                                          }
PROCEDURE PackBbsOutbounds;

    PROCEDURE PackBbsOutbound;

    VAR NewDir  : STRING;
        OldDir  : STRING;
        IORes   : BYTE;
        Search  : SearchRec;
        QQQFile : FILE;

    BEGIN
         NewDir:=FExpand (UserData.Outbound);
         IF (NewDir[Length (NewDir)] = '\') AND (NewDir[Length (NewDir)-1] <> ':') THEN
            Delete (NewDir,Length (NewDir),1);

         { onthoud de huidige directory op die drive }
         GetDir (Ord (NewDir[1])-Ord ('A')+1,OldDir);

         {$I-} ChDir (NewDir); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'Invalid BBS outbound: "'+NewDir+'"');
              Exit;
         END;

         FindFirst ('*.QQQ',Archive,Search);
         WHILE (NOT GlobalAbort) AND (DosError = 0) DO
         BEGIN
              UpdateReadFile (Config.Outbound_F+Search.Name,Search.Size);

              Assign (QQQFile,Search.Name);

              {$I-}
              Rename (QQQFile,Copy (Search.Name,1,Pos ('.',Search.Name))+'PKT');
              {$I+} IORes:=IOResult;

              IF (IORes <> 0) THEN
                 LogDiskIOError (IORes,'Failed to rename '+Search.Name+' to .PKT');

              FindNext (Search);
         END; { while }

         FindClose (Search);

         ChDir (OldDir);   { change back on outbound drive }
    END;

{ PackBbsOutbounds }

VAR OldCurr : PathStr;
    UserLp  : UserBaseRecordNrType;

BEGIN
     UpdateAction ('Packing BBS outbound(s)');

     GetDir (0,OldCurr);

     FOR UserLp:=1 TO UserBaseRecCount DO
         IF (NOT GlobalAbort) THEN
         BEGIN
              ReadUserBaseRecord (UserLp,UserData);

              IF (NOT UserData.Deleted) AND (UserData.System = _BBS) THEN
                 PackBbsOutbound;
         END;

     ChDir (OldCurr);  { change back to old drive + path }
END;


{--------------------------------------------------------------------------}
{ Fido_Pack                                                                }
{                                                                          }
{ Deze routine pakt de FTN outbound in en doorloopt de outbound van iedere }
{ BBS Interface en hernoemd daar de .QQQ files naar .PKT.                  }
{                                                                          }
PROCEDURE Fido_Pack;
BEGIN
     LogMessage ('PACK outbound(s) started');
     LogClose; { ## TEMP ## }

     PackFtnOutbound;

     IF (NOT GlobalAbort) THEN
     BEGIN
          LogClose; { ## TEMP ## }
          PackBbsOutbounds;
     END;

     LogMessage ('PACK finished');
END;


END.
