{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT FidoPkt;

{ FidoPkt                                                                   }
{                                                                           }
{ Deze unit bevat de routines om Fido *.PKT bestanden te kunnen verwerken.  }
{ Oorspronkelijk waren deze routines verdeeld over <FIDO> en <MSGS>         }
{                                                                           }
{ MD 10-09-93 Hierheen verplaatst                                           }
{    23-09-93 Onbekende areas worden nu niet meer automatisch aangemaakt    }
{             maar in de bad mail gegooid.                                  }
{    18-11-93 FSC-0048 support toegevoegt, we creeren nog steeds gewone     }
{             stone age pakketen. (doet gecho ook, en is compatible met     }
{             alles.)                                                       }
{    19-01-94 FidoExportMsg geeft nu ook TRUE terug als een gebied          }
{             gemodereerd wordt door een Usenet Moderator                   }

INTERFACE

USES Cfg,
     Dos,
     DataBase;

TYPE FidoPktHdr = RECORD                               { close to stoneage }
                        orig_node : WORD;               { originating node }
                        dest_node : WORD;               { destination node }

                        year   : WORD;                      { 1989 - nnnnn }
                        month  : WORD;
                        day    : WORD;
                        hour   : WORD;
                        minute : WORD;
                        second : WORD;

                        baud : WORD;                              { unused }
                        ver  : WORD;                                   { 2 }

                        orig_net : INTEGER;              { originating net }
                        dest_net : INTEGER;              { destination net }

                        product : BYTE;                { FTSC produkt code }
                        rev_lev : BYTE;                    { versie nummer }

                        password : ARRAY[1..8] OF BYTE;    { Node password }

                        qm_orig_zone : WORD;               { qm = Qmail ?? }
                        qm_dest_zone : WORD;                 { (verouderd) }

                        F48_AuxNet         : WORD;
                        F48_ValidationCopy : WORD;
                        F48_ProduktCode    : BYTE;
                        F48_Revision       : BYTE;
                        F48_Capability     : WORD;

                        orig_zone  : WORD;              { originating zone }
                        dest_zone  : WORD;              { destination zone }
                        orig_point : WORD;             { originating point }
                        dest_point : WORD;             { destination point }
                        pr_data    : LONGINT;          { product dependent }
                  END;

     FidoPktMsgHdrAdres = RECORD
                                TypeIdent,               { Moet 0002 zijn }
                                OrigNode,
                                DestNode,
                                OrigNet,
                                DestNet,
                                AttrFlag,
                                Cost      : WORD;
                                { DateTime verhuisd naar FidoPktMsgHdr }
                         END;

     FidoPktMsgHdr = RECORD
                           Adres        : FidoPktMsgHdrAdres;
                           DateTime     : STRING[20];
                           ToUserName   : STRING[36]; {array[1..36] of char }
                           FromUserName : STRING[36]; {array[1..36] of char }
                           Subject      : STRING[72]; {array[1..72] of char }
                     END;

FUNCTION  FidoPktExportMsg : BOOLEAN;
PROCEDURE ProcessInboundPkts (Path : FilePathStr; Ext : ExtStr; Security : SecurityType; BBSRecNr : UserBaseRecordNrType);
PROCEDURE FidoPktProcess (PktPath : FilePathStr; Security : SecurityType; BBSRecNr : UserBaseRecordNrType);


IMPLEMENTATION

USES Ramon,
     Stats,
     Fido,
     DupeChk,
     FBuffer,
     Logs,
     AreaBase,
     UserBase,
     Msgs,
     Strings,
     MakeOut,
     Binkley,
     Globals,
     SwapMem,
     Routing,
     Start,
     SeenBy,
     Translat;

{--------------------------------------------------------------------------}
{ FidoReadPktMsgHdr                                                        }
{                                                                          }
{ Deze routine leest uit de .PKT file een message header. Terug gegeven    }
{ wordt:                                                                   }
{  0 = Succes                                                              }
{  1 = Einde .PKT                                                          }
{ -1 = Error                                                               }
{                                                                          }
FUNCTION FidoReadPktMsgHdr (VAR PktFile : FBufferType;
                            VAR Header  : FidoPktMsgHdr) : INTEGER;

BEGIN
     IF (NOT FBBlockRead (PktFile,Header,SizeOf (FidoPktMsgHdrAdres))) THEN
     BEGIN
          IF (FBByteRead (PktFile) = 0) THEN FidoReadPktMsgHdr:=1   { eof }
                                        ELSE FidoReadPktMsgHdr:=-1; { err }
          Exit;
     END;

     { deze strings zijn op disk null terminated }
     Header.DateTime:=FBReadNull (PktFile);
     Header.ToUserName:=FBReadNull (PktFile);
     Header.FromUserName:=FBReadNull (PktFile);
     Header.Subject:=FBReadNull (PktFile);

     FidoReadPktMsgHdr:=0; { succes }
END;


{--------------------------------------------------------------------------}
{ FidoOpenPktFile                                                          }
{                                                                          }
{ Deze routine opent een Fido Pkt file. En voert controles op de invoer    }
{ file uit, en leest de header. Het volledige pad naar de .PKT moet worden }
{ opgegeven. Als het packet met succes geopend is en de header goed inge-  }
{ lezen is, dan wordt TRUE terug gegeven, anders FALSE. De handl moet ook  }
{ worden opgegeven.                                                        }
{                                                                          }
FUNCTION FidoOpenPktFile (VAR PktPath : STRING;
                          VAR PktFile: FBufferType;
                          VAR Header : FidoPktHdr) : BOOLEAN;

VAR IORes : BYTE;
    RFile : FILE;

BEGIN
     { rename the .PKT before tossing }
     Assign (RFile,PktPath);

     PktPath[Length (PktPath)]:='P';
     PktPath[Length (PktPath)-1]:='P';

     {$I-} Rename (RFile,PktPath); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Failed to rename .PKT to '+PktPath);
          LogMessage ('Processing anyway; crash might cause re-toss!');
     END;

     IF (NOT FBufferOpen (PktFile,PktPath,15000,0)) THEN
     BEGIN
          FBufferClose (PktFile);
          FidoOpenPktFile:=FALSE;
          Exit;
     END;

     IF (NOT FBBlockRead (PktFile,Header,SizeOf (FidoPktHdr))) THEN
     BEGIN
          FBufferClose (PktFile);
          FidoOpenPktFile:=FALSE;
          Exit;
     END;

{ MD:   ---- Routine om programma dat pakket creerde te herkennen ----- }
{ RvdW: bull shit... waarom zou je? }
{ MD:   Staat stoer in de logs      }

     FidoOpenPktFile:=TRUE;
END;


{--------------------------------------------------------------------------}
{ FidoClosePktFile                                                         }
{                                                                          }
{ Routine om Pkt met stijl af te sluiten (ahum)... De file wordt via de    }
{ FBuffer routines gesloten.                                               }
{ Deze routine wordt alleen aangeroepen in geval van problemen met de .PKT }
{ file. We renamen em hier terug naar .PKT zodat andere tossers em kunnen  }
{ verwerken.                                                               }
{                                                                          }
PROCEDURE FidoClosePktFile (VAR PktFile : FBufferType; PktPath : STRING);

VAR IORes : BYTE;

BEGIN
     FBufferClose (PktFile);

     PktPath[Length (PktPath)]:='T';
     PktPath[Length (PktPath)-1]:='K';

     {$I-} Rename (PktFile.Bestand,PktPath); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Failed to rename .PPP file back to '+PktPath);
END;


{--------------------------------------------------------------------------}
{ StripSeenByAndPathLines                                                  }
{                                                                          }
{ Deze routine voegt alle regels toe aan de Footer_F, behalve SEEN-BY en   }
{ PATH lines. Dit wordt gebruikt voor inbound echomail van een BBS user.   }
{                                                                          }
PROCEDURE StripSeenByAndPathLines (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,8) = 'SEEN-BY:') OR (Copy (Regel,1,6) = #1'PATH:') THEN
        Exit;

     MsgsAddLineToNoEOL (Footer_F,Regel);
END;


{--------------------------------------------------------------------------}
{ FidoPktProcess                                                           }
{                                                                          }
{ Met deze routine wordt een gevonden .PKT bestand verwerkt. Het volledige }
{ pad moet meegegeven worden.                                              }
{                                                                          }
PROCEDURE FidoPktProcess (PktPath : FilePathStr; Security : SecurityType; BBSRecNr : UserBaseRecordNrType);

VAR
{ pkt variabelen }
    PktFile       : FBufferType;
    PktHeader     : FidoPktHdr;

{ msg variabelen }
    MsgHeader     : FidoPktMsgHdr;

{ regel variabelen }
    Regel,
    LastRegel     : STRING;
    WhereTo       : WhereToType;

{ security }
    Temp,
    Sender        : FidoAddrType;
    AreaRecNr     : AreaBaseRecordNrType;
    Result,
    IORes         : BYTE;

    Password      : STRING[9];
    Destination   : STRING;
    SenderIsKnownToUs : BOOLEAN;

    FromUserData  : UserBaseRecord;  { RWI 950621: lokaal gemaakt }
    FromUserRecNr : UserBaseRecordNrType;

    LineBuffer    : TopRegelRecordPtr;

BEGIN
     IF (NOT CheckMinDiskFree) THEN
        Exit;

     IF (NOT FidoOpenPktFile (PktPath,PktFile,PktHeader)) THEN
     BEGIN
          LogMessage ('Failed to open '+PktPath);
          Exit;
     END;

     UpdateInfoNr (INFO_PktIn_Jobs,1);

     { Lees adres informatie uit de FidoPkt header }
     { "ondersteuning van TYPE 2+"                 }

     WITH Sender,PktHeader DO
     BEGIN
          Zone:=orig_zone;

          { RWI 950317: als de zone nul is, dan pakken we de qm_orig_zone }
          IF (Zone = 0) THEN
             Zone:=qm_orig_zone;

          IF (Orig_Net = -1) AND (F48_ValidationCopy = F48_Capability) THEN
          BEGIN
               Net:=F48_AuxNet;
               Point:=orig_point;
          END ELSE
          BEGIN
               Point:=Orig_Point;
               Net:=Orig_Net;
          END;

          Node:=orig_node;
     END; { with }

     Sender.Domain:=''; { niet uit de header halen? Is dat receiver domain? }

     IF (BBSRecNr = NILRecordNr) THEN
     BEGIN
          { Aangezien 280/802 nu door ons niet herkent zou worden,.. }
          { fixup het binnenkomende adres                            }

          FidoMatch (Sender,Temp);
          FidoMergeAdres (Temp,Sender);

          {WriteXY (33,6,AddUpWithSpaces (23,Fido2Str (Sender)));}
          SenderIsKnownToUs:=FindUserBaseRecordByFidoAddress (Sender,FromUserRecNr);

          IF (Security = Secure) AND (NOT SenderIsKnownToUs) THEN
          BEGIN
               LogExtraMessage (Fido2Str (Sender)+' is not in the user base! Skipping '+PktPath);
               FidoClosePktFile (PktFile,PktPath);
               Exit;
          END;

          IF SenderIsKnownToUs THEN
          BEGIN
               { voor conversie etc. is het FROM user UserBase record nodig }
               ReadUserBaseRecord (FromUserRecNr,FromUserData);
               PacketUserData:=FromUserData; { RWI 950102 ivm routines achter MsgsExport }
               AreaCreatorUserBaseRecNr:=FromUserRecNr; { voor aanmaken nieuwe areas }
          END ELSE
              AreaCreatorUserBaseRecNr:=NILRecordNr;

          { Controle op passwords bij het importeren }

          { Converteer het password naar een pascal string }
          Move (PktHeader.password,Password[1],8);
          Password[0]:=#0;
          WHILE (Byte (Password[Byte (PassWord[0])+1]) <> 0) AND (Byte (Password[0]) < 8) DO
                Inc (Byte (Password[0]));

          IF (Security = Secure) THEN
          BEGIN
               { controleer adres + password creerder van het pakket met berichten }
               IF (FromUserData.PacketPwd <> '') AND
                  (UpCaseString (FromUserData.PacketPwd) <> UpCaseString (DeleteBackspaces (Password))) THEN
               BEGIN
                    { Pasword failure ! }
                    LogExtraMessage ('Password failure for '+PktPath+' from '+Fido2Str (Sender));
                    LogExtraMessage ('Got "'+Password+'" but expected "'+FromUserData.PacketPwd+'"');

                    Destination:=Copy (PktPath,1,Length (PktPath)-4)+'.PWD';

                    FBufferClose (PktFile);

                    IF RenameSerial (PktPath,Destination) THEN
                       LogExtraMessage ('Renaming to '+Destination)
                    ELSE
                        LogExtraMessage ('Rename of bad packet failed!');

                    Exit;
               END;

               IF Config.LogFidoTossed THEN
                  LogMessage ('Processing (secure) '+PktPath+' from '+Fido2Str (Sender)+
                              ' ('+Longint2String (FileSize (PktFile.Bestand))+' bytes)');
          END ELSE
              IF Config.LogFidoTossed THEN
                 LogMessage ('Processing (normal) '+PktPath+' from '+Fido2Str (Sender)+
                             ' ('+Longint2String (FileSize (PktFile.Bestand))+' bytes)');
     END ELSE
     BEGIN
          { BBS Interface }
          FromUserRecNr:=BBSRecNr;
          SenderIsKnownToUs:=TRUE;
          ReadUserBaseRecord (FromUserRecNr,FromUserData);
          PacketUserData:=FromUserData; { RWI 950102 ivm routines achter MsgsExport }
          AreaCreatorUserBaseRecNr:=NILRecordNr; { mag niet voorkomen }

          IF Config.LogFidoTossed THEN
             LogMessage ('Processing (bbs) '+PktPath+' ('+Longint2String (FileSize (PktFile.Bestand))+' bytes)');
     END;

     AreaRecNr:=NILRecordNr;

     {---------------------------------------------------------------}
     { controleren of het pakket wel aan ons gericht is met hdr info }
     { lees de berichten uit de .pkt                                 }
     WHILE (FidoReadPktMsgHdr (PktFile,MsgHeader) = 0) DO
     BEGIN
          {FidoProcessStatusShow;}

          { maak het universele MsgBuffer leeg }
          MsgsEmpty;

          { UserDataRecNr werd onderweg ergens onderuit gehaald en bij }
          { het verwerken van het tweede bericht gaat het dan mis.     }
          { Helaas werd deze niet altijd onderuit gehaald...           }
          UserDataRecNr:=FromUserRecNr;

          { copieer gegevens uit de PktMsgHdr naar het universele buffer }
          WITH Msg DO
          BEGIN
               {Ready_F:=Netmail; wordt nu achteraf bepaald! }
               FromUser_F:=MsgHeader.FromUserName;
               ToUser_F:=MsgHeader.ToUserName;
               Subj_F:=MsgHeader.Subject;
               Date_F:=FidoCorrectDate (MsgHeader.DateTime);
          {?}  Attr_F:=MsgHeader.Adres.AttrFlag;   { strip some? }
               Cost_F:=MsgHeader.Adres.Cost;
          END; { with }

          WITH Msg.ToAddr_F DO
          BEGIN
               Net:=MsgHeader.Adres.DestNet;
               Node:=MsgHeader.Adres.DestNode;
          END; { with }

          WITH Msg.FromAddr_F DO
          BEGIN
               Net:=MsgHeader.Adres.OrigNet;
               Node:=MsgHeader.Adres.OrigNode; { 31-03-93, was DestNode }
               { Origin will override this }
          END; { with }

          WhereTo:=Header_F;
          PrevKludgeID:=klNone;

          {--------------------------------------------------------------}
          { nu de hele body van het bericht inlezen en opslaan.          }
          WHILE FBReadLnCR (PktFile,Regel) AND (Regel <> #0) DO
          BEGIN
               FidoAddLineToMessage (Regel,LastRegel);

               { RWI 960223: changed "<> Echomail" into "= NotReady" om te }
               {             voorkomen dat een AREA: in het midden van een }
               {             netmail het bericht omzet in een echomail     }

               {IF (PrevKludgeID = klArea) AND (Msg.Ready_F = NotReady) THEN}

               { RAWI 970528: werkt natuurlijk niet, want Msg.Ready_F wordt }
               {              pas op Netmail gezet als het geen echomail    }
               {              was. Nieuwe check: er mag geen body zijn.     }

               IF (PrevKludgeID = klArea) AND ((Msg.BodyTop = NIL) OR (Msg.BodyTop^.TotalRegelLength = 0)) THEN
               BEGIN
                    { echomail bericht }
                    Msg.Ready_F:=Echomail;
                    UpdateInfoNr (INFO_PktIn_Echo,1);

                    { RWI 950215: UpCaseString toegevoegd... }
                    { RWI 960223: DeleteFrontSpaces toegevoegd... }
                    Msg.Area_F:=DeleteFrontSpaces (UpCaseString (Copy (Regel,Pos (':',Regel)+1,255)));

                    IF (Msg.Area_F <> '') AND (Msg.Area_F[Length (Msg.Area_F)] = #13) THEN
                       Delete (Msg.Area_F,Length (Msg.Area_F),1);

                    { Controleer of node toegang heeft tot de area dit    }
                    { is verplaatst naar vOOr MsgExport omdat er nog meer }
                    { informatie over de node nodig is, die nog uit rest  }
                    { van de kludges (Pntl etc.) moet worden gehaald.     }

                    { AreaData is hierheen verhuist, omdat deze informatie  }
                    { keihard nodig is voor SeenBy + Path lines             }
                    { Ook wordt een area nu al aangemaakt als die nog niet  }
                    { bestond, dit is ook nodig voor de bovenstaande regels }

                    IF (AreaData.AreaName_F <> Msg.Area_F) THEN
                    BEGIN
                         AreaRecNr:=GetAreaBaseRecordNrByAreaName_F (Msg.Area_F);

                         IF (AreaRecNr = NILRecordNr) THEN
                         BEGIN
                              { Controleer of een user wel een area mag creeren }
                              IF (NOT SenderIsKnownToUs) OR ((NOT FromUserData.AllowCreate) AND SenderIsKnownToUs) THEN
                              BEGIN
                                   LogMessage ('Echomail sent by '+Fido2Str (Sender)+' in unknown area '+Msg.Area_F);
                                   Msg.Ready_F:=BAD;
                                   Msg.BadReason:='Sender '+Fido2Str (Sender)+
                                                  ' is not allowed to create new area "'+Msg.Area_F+'"';
                              END ELSE
                              BEGIN
                                   LogMessage ('Auto creating area '+Msg.Area_F+' sent by '+Fido2Str (Sender));
                                   AreaRecNr:=AutoCreateArea (Msg.Area_F,'');
                                   ReadAreaBaseRecord (AreaRecNr,AreaData);
                                   {FidoProcessStatusShow; { screen update "New areas" }
                              END;
                         END ELSE
                             ReadAreaBaseRecord (AreaRecNr,AreaData);
                    END;
               END; { klArea }

          END; { while not entire message read in }

          FidoAddLastLine (LastRegel);

          { SEEN-BY en PATH lines verwijderen voor een BBS user }
          IF (BBSRecNr <> NILRecordNr) THEN
          BEGIN
               LineBuffer:=Msg.FooterTop_F;
               Msg.FooterTop_F:=NIL;
               MsgsForEachKill (LineBuffer,StripSeenByAndPathLines);
          END;

          { als het geen echomail was (of bad of dupes nu), dan moet }
          { het wel netmail zijn.                                    }
          IF (Msg.Ready_F = NotReady) THEN
             Msg.Ready_F:=Netmail;

          UpdateInfoNr (INFO_PktIn_Msgs,1);

          { controleer of de node wel in deze area mag schrijven }
          { en of de area wel bestaat.                           }
          IF SenderIsKnownToUs AND (FromUserData.System <> _BBS) THEN
          BEGIN
               IF (Msg.Ready_F = Echomail) THEN
               BEGIN
                    IF (NOT TestIfUserIsInAreaRec_UserList (AreaData.UserList,FromUserRecNr)) THEN
                    BEGIN
                         LogMessage ('Delivering user '+Fido2Str (Sender)+' is not subscribed to area '+AreaData.AreaName_F);
                         Msg.Ready_F:=Bad;
                         Msg.BadReason:='User '+Fido2Str (Sender)+' is not subscribed to area '+AreaData.AreaName_F;
                    END;
               END;

               IF (Msg.Ready_F = Echomail) THEN
               BEGIN
                    { kijk of de area in een read/write group zit, anders }
                    { mag de user er niet in schrijven. RWI 941126        }
                    { RWI 950621: Ipv FromUserData of PacketUserData werd UserData gebruikt... }
                    { RWI 950722: Er stond nog steeds UserData ipv FromUserData! }
                    { RWI 950802: Newly created areas area only in group Z!   }
                    {             Fixed by setting the Z flag for these users }

                    { the below statement doesn't allow users to write in    }
                    { read-only areas, but does allow posts in newly created }
                    { areas. Notice that it is not possible to block writes  }
                    { to these newly created areas.                          }

                    { RWI 960224: User now has write access when not in any }
                    {             of the groups the area is in.             }

                    IF TestIfGroupCommon (FromUserData.Groups,AreaData.IsInGroups) THEN { new }
                       IF (NOT TestIfGroupCommon3 (FromUserData.Groups,AreaData.IsInGroups,ReadWriteGroupsFilter)) AND
                          NOT ((FromUserData.AllowCreate AND TestIfInGroup (AreaData.IsInGroups,Group_NewAreas))) THEN
                      {IF ((FromUserData.Groups AND AreaData.IsInGroups AND ReadWriteGroupsFilter) = 0) AND
                          NOT ((FromUserData.AllowCreate AND (AreaData.IsInGroups = GROUP_Z))) THEN}
                       BEGIN
                            { nee, user mag niet in een group waarin de area zit }
                            { en waarin geschreven mag worden. BAD met die hap.  }
                            LogMessage ('User '+Fido2Str (Sender)+' attemted to post to read-only area '+AreaData.AreaName_F);
                            Msg.Ready_F:=Bad;
                            Msg.BadReason:='User "'+Fido2Str (Sender)+'" attempted to post to read-only area "'+
                                           AreaData.AreaName_F+'"';
                       END;
               END;
          END;

          IF (Msg.Ready_F = Echomail) THEN
          BEGIN
               { check of het een Dupe is }
               IF Config.DoDupeChk AND DupeCheckExist (FidoCRCMessage) THEN
               BEGIN
                    Msg.Ready_F:=Dupe;
                    {$IFDEF DEBUG}
                    LogBad ('Dupe found: '+Longint2String (FidoCRCMessage));
                    {$ENDIF}
               END;
          END;

          IF (Msg.Ready_F = Echomail) THEN
          BEGIN
               IF Config.LogPktEachEcho THEN
                  LogExtraMessage ('  '+AddUpWithPreSpaces (6,Longint2String (Msg.MsgSize))+' '+AreaData.AreaName_F);

               { werk de informatie van deze user bij }
               { de user is altijd bekend, want we staan geen echo }
               { van onbekende systemen toe.                       }
               UpdateUserStats (FromUserRecNr,EchoFrom,Msg.MsgSize);

               { RWI 960219: BAD echomail is no longer counted in the area stats }
               IF (Msg.Ready_F = Echomail) THEN
                  UpdateAreaStats (AreaRecNr,Msg.MsgSize);
          END; { echomail }

          { Fix: (16/11/93) Tel nu geen netmails meer in een bad area }
          IF (Msg.Ready_F = Netmail) THEN
          BEGIN
               IF Config.LogPktEachEcho THEN
                  LogExtraMessage ('  '+AddUpWithPreSpaces (6,Longint2String (Msg.MsgSize))+' netmail');

               UpdateInfoNr (INFO_PktIn_Net,1);

               { werk de informatie van deze user bij }
               IF SenderIsKnownToUs THEN
                  UpdateUserStats (FromUserRecNr,NetFrom,Msg.MsgSize);
          END;

          { Als de TO zone nog steeds nul is, probeer hem dan aan te }
          { vullen met de FROM zone.                                 }
          IF (Msg.ToAddr_F.Zone = 0) AND (Msg.FromAddr_F.Zone <> 0) THEN
             Msg.ToAddr_F.Zone:=Msg.FromAddr_F.Zone;

          { Als de Zone's NOG STEEDS nul zijn, dan zal het wel weer zo'n    }
          { halfgaar door Tmail verspreid bericht zijn, dat programma heeft }
          { het idee dat MSGID's toch niet nodig zijn... In de hoop dat ik  }
          { hier geen afgrijselijke dingen mee doe...                       }
          IF (Msg.ToAddr_F.Zone = 0) AND (Msg.FromAddr_F.Zone = 0) THEN
          BEGIN
               Msg.ToAddr_F.Zone:=Sender.Zone;
               Msg.FromAddr_F.Zone:=Sender.Zone;
          END;

          { replace the to-aka if it matches the fake aka for a bbs interface }
          IF (FromUserData.System = _BBS) THEN
             WITH FromUserData,Msg.ToAddr_F DO
                  IF (FakeZone = Zone) AND (FakeNet = Net) AND
                     (FakeNode = Node) AND (Point = 0) THEN
                  BEGIN
                       { take the system node number selected in the bbs record }
                       Msg.ToAddr_F:=Config.NodeNrs[FromUserData.SystemAka];
                  END;

          { Als het bericht om een of andere reden kapot is, toss het dan }
          { in de badmail directory.                                      }

          { Stript de CRASH flag om te voorkomen dat wij voor de rekening }
          { opdraaien.                                                    }
          Msg.Attr_F:=Msg.Attr_F AND ($FFFF-MSGCRASH);

          MsgsExport;
     END; { while niet einde .PKT }

     { uit de while verhuisd, stond vlak voor de END en er staat er ook }
     { eentje bovenin... RWI 941126.                                    }

     MsgsEmpty; { geef het geheugen weer vrij }

     UpdateInfoNr (INFO_PktIn_Bytes,FileSize (PktFile.Bestand));

     FBufferClose (PktFile);

     { PKT file wissen }

     {$I-} Erase (PktFile.Bestand); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Unable to delete '+PktPath);
END;


{--------------------------------------------------------------------------}
{ ProcessInboundPkts                                                       }
{                                                                          }
{ Deze routine loopt alle inbound directories af en leest daaruit alle     }
{ .PKT files in om te verwerken.                                           }
{                                                                          }
PROCEDURE ProcessInboundPkts (Path : FilePathStr; Ext : ExtStr; Security : SecurityType; BBSRecNr : UserBaseRecordNrType);

VAR Search : SearchRec;

BEGIN
     Path:=CorrectPath (Path);

     FindFirst (Path+'*.'+Ext,Archive,Search);
     WHILE (DosError = 0) DO
     BEGIN
          IF KeyPressed AND (Ramon.ReadKey = kEsc) THEN
          BEGIN
               GlobalAbort:=TRUE;
               Break; { uit de while }
          END;

          UpdateReadFile (Path+Search.Name,Search.Size);

          { verwerk het pakket }
          FidoPktProcess (Path+Search.Name,Security,BBSRecNr);

          FindNext (Search);
     END; { while }

     FindClose (Search);
END;


{--------------------------------------------------------------------------}
{ FidoPktExportMsg                                                         }
{                                                                          }
{ Deze routine exporteert de universele interne msg voor alle aangesloten  }
{ Fido nodes. Als het om een Usenet news of mailtje gaat, dan moet deze al }
{ vertaald zijn.                                                           }
{ Voor EchoMail moet AreaData de gegevens van de area waarin deze msgs     }
{ komt te staan bevatten.                                                  }
{ Voor NetMail moet Msg.ToAddr_F de bestemming bevatten en UserData het    }
{ record van de user bevatten waar het mailtje heen moet.                  }
{                                                                          }
FUNCTION FidoPktExportMsg : BOOLEAN;

TYPE MsgBufferPtr  = ^MsgBufferType;
     MsgBufferType = ARRAY[0..65528] OF BYTE;

VAR MsgBuffer   : MsgBufferPtr;
    MsgBufOfs   : WORD;
    SeenByOfs   : WORD;
    PathOfs     : WORD;
    WriteBufLen : WORD;
    MsgHeader   : FidoPktMsgHdrAdres;
    AddrToo     : BOOLEAN;

    {----------------------------------------------------------------------}
    { FillMsgBuffer                                                        }
    {                                                                      }
    { Deze routine vult het MsgBuffer met regels uit de message. Er worden }
    { maximaal Config.MaxFidoMsgLen-HeaderLen-FooterLen tekens in gezet.   }
    { Er wordt TRUE terug gegeven als het einde van het bericht bereikt    }
    { is.                                                                  }
    {                                                                      }
    { RWI 950506: Als CheckID gezet is, dan wordt gecontroleerd of de      }
    {             regel met MSGID begint. Die wordt dan aangepast, zodat   }
    {             ieder split part een eigen ID heeft.                     }
    {                                                                      }
    FUNCTION FillMsgBuffer (VAR EenRegelPtr : EenRegelRecordPtr;
                            VAR SwapPos : LONGINT;
                            VAR StoreLeft : LONGINT;
                            CheckID : BOOLEAN) : BOOLEAN;

    VAR Einde : WORD;
        Len   : BYTE;
        Regel : STRING;

    LABEL VolleBak;

    BEGIN
         { herstel de positie in de swapfile }
         IF SwapIsOpen THEN
            Seek (SwapFile,SwapPos);

         { blijf regels uit de Msg structuur toevoegen aan het buffer, }
         { totdat het buffer vol zit, of we het einde van het bericht  }
         { bereikt hebben, of we niets meer toe mogen voegen ivm de    }
         { maximale lengte van een split part.                         }

         WHILE (EenRegelPtr <> NIL) DO
         BEGIN
              CASE EenRegelPtr^.Waar OF
                   wMem :
                       BEGIN
                            Len:=Length (EenRegelPtr^.RegelPtr^);

                            IF (Len > (WriteBufLen-MsgBufOfs)) THEN
                               GOTO VolleBak;

                            IF (Len > StoreLeft) THEN
                            BEGIN
                                 { deze regel zal er nooit in passen voor }
                                 { dit split deel, dus voorkom nieuwe     }
                                 { pogingen.                              }
                                 StoreLeft:=0;
                                 GOTO VolleBak;
                            END;

                            Regel:=EenRegelPtr^.RegelPtr^;
                            EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                            MsgsNewSeek (EenRegelPtr);
                       END; { wMem }

                   wSwapped :
                       BEGIN
                            BlockRead (SwapFile,Len,1);

                            IF (Len = 0) THEN
                            BEGIN
                                 { einde van een swap blok }
                                 EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (EenRegelPtr);
                                 Continue;
                            END;

                            IF (Len > StoreLeft) THEN
                            BEGIN
                                 { zorg dat de lengte byte straks weer }
                                 { opnieuw gelezen wordt.              }
                                 Seek (SwapFile,FilePos (SwapFile)-1);

                                 { voorkom nieuwe pogingen in dit split }
                                 { part met dezelfde regel, die er toch }
                                 { niet in past.                        }
                                 StoreLeft:=0;
                                 GOTO VolleBak;
                            END;

                            IF (Len > (WriteBufLen-MsgBufOfs)) THEN
                            BEGIN
                                 Seek (SwapFile,FilePos (SwapFile)-1);
                                 GOTO VolleBak;
                            END;

                            BlockRead (SwapFile,Regel[1],Len);
                            Regel[0]:=Char (Len);
                       END; { wSwapped }
               END; { case }

               { RAWI 970406: nu testen op 1 plek }
               IF CheckID AND (Copy (Regel,1,6) = #1'MSGID') THEN
               BEGIN
                    { tjaka! }
                    Dec (Regel[0],9); { ook de #13 eraf }
                    Regel:=Regel+GetFidoPktName+#13; { en weer erbij }
               END;

               IF (SeenByOfs = 65535) AND (Copy (Regel,1,7) = 'SEEN-BY') THEN
                  SeenByOfs:=MsgBufOfs;

               IF (PathOfs = 65535) AND (Copy (Regel,1,6) = #1'PATH:') THEN
                  PathOfs:=MsgBufOfs;

               Move (Regel[1],MsgBuffer^[MsgBufOfs],Len);

               Inc (MsgBufOfs,Len);
               Dec (StoreLeft,Len);
         END; { while }

    VolleBak:

         { bewaar de huidige positie in de swapfile voor de volgende }
         { doorgang van een body blok.                               }
         IF SwapIsOpen THEN
            SwapPos:=FilePos (SwapFile);

         FillMsgBuffer:=(EenRegelPtr = NIL);  { TRUE bij einde bericht bereikt }
    END;


    {-----------------------------------------------------------------------}
    { WriteMsgBuffer                                                        }
    {                                                                       }
    { Deze routine exporteert het MsgBuffer naar alle users die daar een    }
    { kopie van moeten hebben. Als de bericht header zelf ook in dit blok   }
    { zit, dan wordt ook het adres van de user er nog even in gezet.        }
    { Helaas moeten we de adressen van de users iedere keer weer samen-     }
    { stellen omdat er een nieuwe PKT kan worden aangemaakt.                }
    {                                                                       }
    PROCEDURE WriteMsgBuffer;

    VAR Search     : SubscrSearchRecord;
        Status     : FidoMsgStatus;
        FoundAKA   : BYTE;
        PointNet   : BOOLEAN;
        DumDum,
        PointAdres : FidoAddrType;
        Tmp        : STRING;

    BEGIN
         IF (Msg.Ready_F IN [EchoMail,Local_Echomail]) THEN
         BEGIN
              { packed message wegschrijven naar alle subscribed users }
              GetFirstUserSubscribedToThisArea (AreaData.UserList,Search);

              WHILE Search.Found DO
              BEGIN
                   ReadUserBaseRecord (Search.UserBaseRecordNr,UserData);

                   IF (UserData.System = _F) AND UserData.Passive THEN
                      Exported^[Search.UserBaseRecordNr]:=3;

                   { alleen voor de fido nodes wegschrijven }
                   IF (Exported^[Search.UserBaseRecordNr] = 0) THEN
                      CASE UserData.System OF
                           _F :
                               BEGIN
                                    { voor Aantal niet msg.msgsize gebruiken, omdat }
                                    { na de translatie een aantal van de header     }
                                    { regels zijn weggevallen.                      }
                                    UpdateUserStats (Search.UserBaseRecordNr,EchoTo,MsgBufOfs);

                                    FoundAKA:=UserData.ExportAKA;

                                    IF (FoundAKA = 0) THEN
                                    BEGIN
                                         { bepaal de AKA die we gaan gebruiken }
                                         FoundAKA:=FidoMatchAdres (UserData.Address,DumDum);
                                    END;

                                    { Als we onder dit aka een pointnet hebben, en  }
                                    { we point zijn dan moeten een PointNetAdres in }
                                    { het te versturen pakket gebruiken.            }
                                    PointNet:=(Config.PointNets[FoundAKA] <> 0) AND
                                              (Config.NodeNrs[FoundAKA].Point <> 0);

                                    IF AddrToo THEN
                                    BEGIN
                                         { zet de destination in de message header }
                                         WITH MsgHeader DO
                                         BEGIN
                                              DestNode:=UserData.Address.Node;
                                              DestNet:=UserData.Address.Net;

                                              { RWI 960304: Squish node level security }
                                              IF TestOrigAddr THEN
                                              BEGIN
                                                   OrigNode:=Config.NodeNrs[FoundAKA].Node;
                                                   OrigNet:=Config.NodeNrs[FoundAKA].Net;
                                              END;
                                         END; { with }

                                         { schrijf header aan begin bericht }
                                         Move (MsgHeader,MsgBuffer^[0],SizeOf (MsgHeader));
                                    END;

                                    Status:=FidoMsgNormal;

                                    { schrijf het bericht naar de .PKT }
                                    IF PointNet THEN
                                    BEGIN
                                         { stel ons adres voor dit pointnet samen }
                                         WITH PointAdres DO
                                         BEGIN
                                              Zone:=Config.NodeNrs[FoundAKA].Zone;
                                              Net:=Config.PointNets[FoundAKA];
                                              Node:=Config.NodeNrs[FoundAKA].Point;
                                              Point:=0;
                                              Domain:=Config.NodeNrs[FoundAKA].Domain;
                                         END;

                                         WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],MsgBufOfs);
                                    END ELSE
                                        WriteMsgToPkt (Status,UserData,Config.NodeNrs[FoundAKA],MsgBuffer^[0],MsgBufOfs);
                               END;

                           _BBS :
                               BEGIN
                                    { export naar .PKT in speciale outbound }
                                    { en klooi wat met de AKAs.             }

                                    { voor Aantal niet msg.msgsize gebruiken, omdat }
                                    { na de translatie een aantal van de header     }
                                    { regels zijn weggevallen.                      }
                                    UpdateUserStats (Search.UserBaseRecordNr,EchoTo,MsgBufOfs);

                                    FoundAKA:=UserData.SystemAKA;

                                    IF AddrToo THEN
                                    BEGIN
                                         { zet de destination in de message header }
                                         WITH MsgHeader DO
                                         BEGIN
                                              DestNode:=Config.NodeNrs[FoundAKA].Node;
                                              DestNet:=Config.NodeNrs[FoundAKA].Net;

                                              { RWI 960304: Squish node level security }
                                              IF TestOrigAddr THEN
                                              BEGIN
                                                   OrigNode:=UserData.FakeNode;
                                                   OrigNet:=UserData.FakeNet;
                                              END;
                                         END; { with }

                                         { schrijf header aan begin bericht }
                                         Move (MsgHeader,MsgBuffer^[0],SizeOf (MsgHeader));
                                    END;

                                    Status:=FidoMsgNormal;

                                    { componeer de "PktSenderAdres" }
                                    PointAdres.Zone:=UserData.FakeZone;
                                    PointAdres.Net:=UserData.FakeNet;
                                    PointAdres.Node:=UserData.FakeNode;
                                    PointAdres.Point:=0;
                                    PointAdres.Domain:='';

                                    { schrijf het bericht naar de .PKT }

                                    IF UserData.KeepSBP THEN
                                    BEGIN
                                         { keep SEEN-BY and PATH. We need }
                                         { to know where the PATH start,  }
                                         { so we can add an extra SEEN-BY }
                                         IF (PathOfs < MsgBufOfs) THEN
                                         BEGIN
                                              WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],PathOfs);

                                              { Insert an extra SEEN-BY }
                                              Tmp:='SEEN-BY: '+Word2String (UserData.FakeNet)+'/'+
                                                               Word2String (UserData.FakeNode)+#13;

                                              WriteMsgToPkt (Status,UserData,PointAdres,Tmp[1],Length (Tmp));

                                              { now the PATH and rest }
                                              WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[PathOfs],MsgBufOfs-PathOfs);
                                         END ELSE
                                             WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],MsgBufOfs);
                                    END ELSE
                                    BEGIN
                                         { kijk of er een SEEN-BY in voorkomt   }
                                         { zoja, dan kappen op dat punt en zelf }
                                         { een fake SEEN-BY en PATH toevoegen.  }
                                         IF (SeenByOfs < MsgBufOfs) THEN
                                         BEGIN
                                              WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],SeenByOfs);

                                              { nu nog een fake SEEN-BY en PATH }
                                              Tmp:=Word2String (UserData.FakeNet)+'/'+
                                                   Word2String (UserData.FakeNode);

                                              Tmp:='SEEN-BY: '+Tmp+
                                                           ' '+Word2String (Config.NodeNrs[UserData.SystemAka].Net)+
                                                           '/'+Word2String (Config.NodeNrs[UserData.SystemAka].Node)+
                                                           #13+
                                                           #1+'PATH: '+Tmp+#13+#0;

                                              WriteMsgToPkt (Status,UserData,PointAdres,Tmp[1],Length (Tmp));
                                         END ELSE
                                             WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],MsgBufOfs);
                                    END;
                               END;

                           _U,
                           _B :
                               FidoPktExportMsg:=TRUE;

                      END; { case }

                      { RWI 960324: added _B }
                      IF (UserData.System = _U) OR (UserData.System = _B) THEN
                         FidoPktExportMsg:=TRUE; { export for UseNet also }

                  GetNextUserSubscribedToThisArea (Search);
              END; { while nog niet alle users gehad }
         END; { was echomail }

         IF (Msg.Ready_F IN [NetMail,Local_Netmail]) THEN
         BEGIN
              IF (UserData.System = _F) THEN
              BEGIN
                   FoundAKA:=UserData.ExportAKA;

                   IF (FoundAKA = 0) THEN
                   BEGIN
                        { bepaal de AKA die we gaan gebruiken }
                        FoundAKA:=FidoMatchAdres (UserData.Address,DumDum);
                   END;

                   { Als we onder dit aka een pointnet hebben, en we point zijn dan   }
                   { moeten een PointNetAdres in het te versturen pakket gebruiken    }
                   PointNet:=(Config.PointNets[FoundAKA] > 0) AND
                             (Config.NodeNrs[FoundAKA].Point > 0);
              END;

              IF AddrToo THEN
              BEGIN
                   { zet de destination in de message header     }
                   { Bugfix: Geroute netmail kreeg het verkeerde }
                   {         TO adres (!)                        }
                   WITH MsgHeader DO
                   BEGIN
                        DestNode:=Msg.ToAddr_F.Node;
                        DestNet:=Msg.ToAddr_F.Net;

                        { RWI 960304: Squish node level security }
                        (*  alleen echomail voor dit moment...
                        IF TestOrigAddr THEN
                        BEGIN
                             OrigNode:=Config.NodeNrs[FoundAKA].Node;
                             OrigNet:=Config.NodeNrs[FoundAKA].Net;
                        END;
                        *)
                   END; { with }

                   { schrijf header aan begin bericht }
                   Move (MsgHeader,MsgBuffer^[0],SizeOf (MsgHeader));
              END;

              { Kijk of het een lokaal bericht is met een file attach }
              { zoja , stuur dat dan ook mee..                        }
              { Dit geldt natuurlijk alleen voor Bink, Frontdoor doet }
              { automatisch file attaches.                            }
              IF (UserData.System = _F) THEN
              BEGIN
                   IF (Config.FidoSystem = stBinkley) THEN
                   BEGIN
                        IF ((Msg.Attr_F AND MSGFILE) > 0) THEN
                           { Nog? Geen controle of de file wel echt bestaat }
                           IF ((Msg.Attr_F AND MSGCRASH) > 0) THEN
                              BinkOUTFile_AddAttaches (BinkleyOutBound (UserData.Address),Msg.Subj_F,UserData.Address,
                                                       Crash)
                           ELSE
                               BinkOUTFile_AddAttaches (BinkleyOutBound (UserData.Address),Msg.Subj_F,UserData.Address,
                                                        UserData.SendFormat);

                        IF ((Msg.Attr_F AND MSGFRQ) > 0) THEN
                        BEGIN
                             { Creer een *.REQ file voor deze node }
                             { RWI 960127: put all filenames mentioned in there }
                             Tmp:=DeleteFrontAndBackSpaces (Msg.Subj_F)+' ';
                             WHILE (Tmp <> '') DO
                             BEGIN
                                  BinkCreateREQFile (BinkleyOutbound (UserData.Address),UserData.Address,
                                                     Copy (Tmp,1,Pos (' ',Tmp)-1));
                                  Delete (Tmp,1,Pos (' ',Tmp));
                                  Tmp:=DeleteFrontSpaces (Tmp);
                             END;
                        END;
                   END;

                   { schrijf het bericht naar de .PKT }
                   IF ((Msg.Attr_F AND MSGCRASH) > 0) THEN
                      Status:=FidoMsgCrash
                   ELSE
                       Status:=FidoMsgNormal;

                   IF PointNet THEN
                   BEGIN
                        { RWI 950212: hier pas het pointadres maken }
                        WITH PointAdres DO
                        BEGIN
                             Zone:=Config.NodeNrs[FoundAKA].Zone;
                             Net:=Config.PointNets[FoundAKA];
                             Node:=Config.NodeNrs[FoundAKA].Point;
                             Point:=0;
                             Domain:=Config.NodeNrs[FoundAKA].Domain;
                        END;

                        WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],MsgBufOfs)
                   END ELSE
                       WriteMsgToPkt (Status,UserData,Config.NodeNrs[FoundAKA],MsgBuffer^[0],MsgBufOfs);
              END ELSE
              BEGIN
                   { BBS Interface }
                   Status:=FidoMsgNormal;

                   { componeer de "PktSenderAdres" }
                   PointAdres.Zone:=UserData.FakeZone;
                   PointAdres.Net:=UserData.FakeNet;
                   PointAdres.Node:=UserData.FakeNode;
                   PointAdres.Point:=0;
                   PointAdres.Domain:='';

                   WriteMsgToPkt (Status,UserData,PointAdres,MsgBuffer^[0],MsgBufOfs);
              END;
         END; { was netmail }

         { alles is weggeschreven, dus het buffer is weer leeg }
         MsgBufOfs:=0;

         { de binary message header hoeft er maar 1 keer voor }
         AddrToo:=FALSE;
    END;

{FidoPktExportMsg}

VAR SubjectLine   : STRING[71];
    SplitLine     : STRING[80];
    SplitBodyLen  : LONGINT;   { hoeveel tekens van de body per split part }
    SplitParts_R  : REAL;
    SplitCurrent,
    SplitParts    : WORD;
    ReachedEOHdr,
    ReachedEOMsg  : BOOLEAN;
    CurrSplitSize,
    BodySwapPos,
    SomeSwapPos   : LONGINT;
    PreSize       : WORD;
    HulpPtr,
    BodyPtr       : EenRegelRecordPtr;
    StoreLeft     : LONGINT; { ivm FillMsgBuffer en splitten }
    HulpLen       : LONGINT;
    FidoHeaderLen,
    FidoFooterLen,
    FidoBodyLen   : LONGINT;

BEGIN
     FidoPktExportMsg:=FALSE; { (nog) niet voor UseNet exporteren }

{$IFDEF WtrTest}
     LogMessage ('Target: .PKT file');
{$ELSE}

     UpdateInfoNr (INFO_PktOut_Msgs,1);

     IF (Msg.Ready_F IN [EchoMail,Local_Echomail]) THEN
        UpdateInfoNr (INFO_PktOut_Echo,1)
     ELSE
         UpdateInfoNr (INFO_PktOut_Net,1);

     { wordt eventueel TRUE gezet in ExportMsgBuffer }

     { bereken de grootte van de Header, Footer en Body }
     IF (Msg.HeaderTop_F <> NIL) THEN
        FidoHeaderLen:=Msg.HeaderTop_F^.TotalRegelLength
     ELSE
         FidoHeaderLen:=0;

     IF (Msg.BodyTop <> NIL) THEN
        FidoBodyLen:=Msg.BodyTop^.TotalRegelLength
     ELSE
         FidoBodyLen:=0;

     IF (Msg.FooterTop_F <> NIL) THEN
        FidoFooterLen:=Msg.FooterTop_F^.TotalRegelLength
     ELSE
         FidoFooterLen:=0;

     IF (Msg.BodyTop = NIL) THEN
        BodyPtr:=NIL
     ELSE BEGIN
          BodyPtr:=Msg.BodyTop^.FirstRegelRecordPtr;

          IF SwapIsOpen THEN
          BEGIN
               MsgsNewSeek (BodyPtr);
               BodySwapPos:=FilePos (SwapFile);
          END;
     END;

     { controleer en corrigeer de To, From, Subj en Date velden, zodat  }
     { we de exacte lengte ervan kunnen bepalen en precies kunnen       }
     { berekenen hoeveel tekens van de body in ieder split deel kunnen. }

     { .PKT file protectie met alert in de logs }
     IF (Length (Msg.ToUser_F) = MaxLenToUser_F) THEN
     BEGIN
          Delete (Msg.ToUser_F,MaxLenToUser_F,1); { nu kan er nog een #0 achter }
          {LogMessage ('[FidoPktExportMsg] Shrunk too long ToUser_F at export');}
          {LogExtraMessage ('Created from ToUser_U: '+Msg.ToUser_U);}
     END;

     IF (Length (Msg.FromUser_F) = MaxLenFromUser_F) THEN
     BEGIN
          Delete (Msg.FromUser_F,MaxLenFromUser_F,1); { nu kan er nog een #0 achter }
          {LogMessage ('[FidoPktExportMsg] Shrunk too long FromUser_F at export');}
          {LogExtraMessage ('Created from FromUser_U: '+Msg.FromUser_U);}
     END;

     IF (Length (Msg.Subj_F) = MaxLenSubj_F) THEN
     BEGIN
          Delete (Msg.Subj_F,MaxLenSubj_F,1); { nu kan er nog een #0 achter }
          {LogMessage ('[FidoPktExportMsg] Shrunk too long Subj_F at export');}
          {LogExtraMessage ('Subj_U was: '+Msg.Subj_U);}
     END;

     IF (Pos (#0,Msg.Date_F) > 0) THEN
        Msg.Date_F:=Copy (Msg.Date_F,1,Pos (#0,Msg.Date_F)-1);

     { bereken uit hoeveel stukken dit bericht gaat bestaan }
     { als we uberhaupt moeten splitsen, tenminste.         }
     IF (Config.MaxFidoMsgLen <> 0) THEN
     BEGIN
          SplitBodyLen:=Config.MaxFidoMsgLen-
                        Length (Msg.ToUser_F)-1-      { -1 voor de #0 }
                        Length (Msg.FromUser_F)-1-
                        Length (Msg.Date_F)-1-
                        Length (Msg.Subj_F)-1-6-      { -6 ivm "(1/1) " }
                        FidoHeaderLen-
                        FidoFooterLen;

          { zoveel tekens kunnen er exact in de body. Als dit nu een  }
          { getal onder de 1kb is, dan klagen we even flink in de log }
          { en zetten we dit op 1kb.                                  }
          IF (SplitBodyLen < 1024) THEN
          BEGIN
               LogMessage ('Too small split parts for *.PKT export, using 1Kb body blocks instead');
               SplitBodyLen:=1024;
          END;

          SplitParts_R:=(FidoBodyLen / SplitBodyLen);

          SplitParts:=Trunc (SplitParts_R);
          IF (SplitParts < SplitParts_R) THEN
             Inc (SplitParts);
     END ELSE
     BEGIN
          SplitParts:=0; { geen splitting }
          SplitBodyLen:=MAXLONGINT; { largest number possible }
     END;

     IF (NOT CalcMaxAllowedMem (WriteBufLen,5000,25000)) THEN
     BEGIN
          LogMessage ('[FidoPktExportMsg] Short on memory ('+Word2String (WriteBufLen)+'), skipping message');
          Exit;
     END;

     { vraag geheugen aan voor een export buffer }
     GetMem (MsgBuffer,WriteBufLen);
     PeekMem;

     { doorloop voor ieder van de split parts nu deze repeat-until }
     SplitCurrent:=0;
     REPEAT
           { bouw een bericht op: header, body en footer. Split parts  }
           { in de subject. Ieder blok moet voor iedereen geexporteerd }
           { worden, alhoewel de header voor iedereen een ander adres  }
           { moet bevatten. Dus... we houden bij of dit een header     }
           { blok of iets anders is en we gaan het natuurlijk niet     }
           { voor iedereen opnieuw klaarzetten!                        }

           { vul het bericht header gedeelte met gegevens }
           WITH MsgHeader DO
           BEGIN
                TypeIdent:=0002;                   { standaard Fido Type 2 }

                { dit schijnen we moeten te veranderen in ons eigen node }
                { maar die moet overeen komen met het destnr, dus doen   }
                { we dit in pack routine verderop (hierboven).           }
                OrigNode:=Msg.FromAddr_F.Node;
                OrigNet:=Msg.FromAddr_F.Net;

                {AttrFlag:=Msg.Attr_F AND ($FFFF-MSGLOCAL); { local flag moeten we kwijt }

                { RWI 960313: Uit FTS-0001.015: de bits 0,1,4,10,12,13,14 }
                {             moet niet op 0 gezet worden bij het packen, }
                {             de rest dus wel.                            }
                AttrFlag:=Msg.Attr_F AND $7413;

                Cost:=Msg.Cost_F;
           END;

           { de rest van de header bestaat uit TO, FROM en SUBJECT }
           { als null terminated strings en de DATE van 20 bytes.  }

           { Is dit bericht in meerdere delen opgesplitst? }
           { zoja, pas dan de Subject lijn aan.            }
           { Een split kludge volgt later nog.             }
           IF (SplitParts > 1) THEN
           BEGIN
                Inc (SplitCurrent);
                SubjectLine:='('+Word2String (SplitCurrent)+
                             '/'+Word2String (SplitParts)+
                             ') '+RemovePathsFromSubject (Msg.Subj_F,Msg.Attr_F AND MSGFILE);
                SplitLine:=FidoCreateSplitLine (SplitCurrent,SplitParts)+#13;
           END ELSE
               SubjectLine:=RemovePathsFromSubject (Msg.Subj_F,Msg.Attr_F AND MSGFILE);

           { verplaats de buffer pointer, zodat de FidoPktMsgHdrAdres er }
           { ook nog voor geplaatst kan worden.                          }
           MsgBufOfs:=SizeOf (MsgHeader);

           StrPCopy (@MsgBuffer^[MsgBufOfs],Msg.Date_F+#0+
                                            Msg.ToUser_F+#0+
                                            Msg.FromUser_F+#0+
                                            SubjectLine+#0);

           { bereken hoeveel bytes we zojuist in het buffer gezet hebben }
           { en verplaats MsgBufOfs tot daarachter.                      }
           Inc (MsgBufOfs,Length (Msg.Date_F)+
                          Length (Msg.ToUser_F)+
                          Length (Msg.FromUser_F)+
                          Length (SubjectLine)+
                          4); { voor de #0-en }

           { onthoudt dat de header nog weggeschreven moet worden. Dit }
           { doet WriteMsgBuffer alleen de eerste keer.                }
           AddrToo:=TRUE;

           { oke. Nu kan het echt werk beginnen. Stouw het buffer iedere }
           { keer zo mudje vol totdat er niet meer bij kan. Probeer de   }
           { header, body en footer erin te proppen. Daarna worden de    }
           { blokken naar de PKT van iedere user geschreven.             }

           { nu komen alle kludges, de header dus. Omdat de bericht  }
           { header er al voor staat, gaat deze lus er vanuit dat de }
           { header niet in een keer in MsgBuffer kan.               }
           IF (Msg.HeaderTop_F <> NIL) THEN
           BEGIN
                HulpPtr:=Msg.HeaderTop_F^.FirstRegelRecordPtr;

                IF SwapIsOpen THEN
                BEGIN
                     MsgsNewSeek (HulpPtr);
                     SomeSwapPos:=FilePos (SwapFile);
                END ELSE
                    SomeSwapPos:=0; { je moet wat }

                SeenByOfs:=65534; { niet naar omkijken }
                PathOfs:=65534;

                REPEAT
                      StoreLeft:=MAXLONGINT;

                      ReachedEOHdr:=FillMsgBuffer (HulpPtr,
                                                   SomeSwapPos,
                                                   StoreLeft,
                                                   (SplitParts > 1){New MSGID's});

                      { als het einde van de header nog niet bereikt is, }
                      { dan zit het buffer waarschijnlijk vol en         }
                      { schrijven we die dus maar naar disk.             }
                      IF (NOT ReachedEOHdr) THEN
                         WriteMsgBuffer;

                UNTIL ReachedEOHdr;
           END;

           { als er niet genoeg ruimte meer is voor de SplitLine, }
           { dan moeten we eerst ruimte maken.                    }
           IF (Length (SplitLine) > (WriteBufLen-MsgBufOfs)) THEN
              WriteMsgBuffer;

           { de split lijn komt NA de header }
           IF (SplitParts > 1 ) THEN
           BEGIN
                Move (SplitLine[1],MsgBuffer^[MsgBufOfs],Length (SplitLine));
                Inc (MsgBufOfs,Length (SplitLine));
           END;

           { de body wordt nu in het bericht geplaatst }
           { alleen het gedeelte dat er door de split in past. Nu moeten }
           { we dus ook rekening gaan houden met de lengte van dit       }
           { gespleten deel. In ieder geval moet er altijd 1 regel in    }
           { passen, want anders komen we er nooit. FillMsgBuffer kijkt  }
           { naar de CurrSplitLength.                                    }
           IF (BodyPtr = NIL) THEN
              ReachedEOMsg:=TRUE
           ELSE BEGIN
                { neem over hoeveel tekens er van ieder split part van }
                { de body in het bericht mogen komen. FillMsgBuffer    }
                { houdt dit bij.                                       }

                SeenByOfs:=65534; { niet naar omkijken }
                PathOfs:=65534;

                StoreLeft:=SplitBodyLen;
                REPEAT
                      ReachedEOMsg:=FillMsgBuffer (BodyPtr,
                                                   BodySwapPos,
                                                   StoreLeft,
                                                   FALSE{geen msgid zoeken});

                      IF NOT (ReachedEOMsg OR (StoreLeft = 0)) THEN
                         WriteMsgBuffer;

                UNTIL ReachedEOMsg OR (StoreLeft = 0);
           END;

           SeenByOfs:=65535; { zoeken! }
           PathOfs:=65535;

           { nu de footer er nog achter. Hier staan dingen in als Origin  }
           { lines + SeenBy's die in iedere kopie + Split van het bericht }
           { moeten komen.                                                }
           IF (Msg.FooterTop_F <> NIL) THEN
           BEGIN
                { RWI 950216: voordat we aan de footer beginnen,          }
                {             controleren we eerst even of er twee enters }
                {             aan het einde van het blok staan want       }
                {             daardoor ontstaat een lege regel _voor_ de  }
                {             tear-line, die als eerste in de footer      }
                {             staat (waarschijnlijk).                     }
                {             Simpel: er moet #13#13 aan het einde staan, }
                {             anders maken we dat ervan. Als het buffer   }
                {             al weggeschreven was, dan kunnen we dit     }
                {             niet controleren en voegen we dus geen      }
                {             enters zomaar toe.                          }
                HulpLen:=2;
                IF (MsgBufOfs < 1) OR (MsgBuffer^[MsgBufOfs-1] = 13) THEN
                BEGIN
                     Dec (HulpLen);
                     IF (MsgBufOfs < 2) OR (MsgBuffer^[MsgBufOfs-2] = 13) THEN
                        Dec (HulpLen);
                END;

                { nu de enters toevoegen }
                WHILE (HulpLen <> 0) DO
                BEGIN
                     MsgBuffer^[MsgBufOfs]:=13;
                     Inc (MsgBufOfs);
                     Dec (HulpLen);
                END; { while }

                HulpPtr:=Msg.FooterTop_F^.FirstRegelRecordPtr;
                IF (SwapIsOpen) THEN
                BEGIN
                     MsgsNewSeek (HulpPtr);
                     SomeSwapPos:=FilePos (SwapFile);
                END;

                REPEAT
                      StoreLeft:=MAXLONGINT;

                      ReachedEOHdr:=FillMsgBuffer (HulpPtr,
                                                   SomeSwapPos,
                                                   StoreLeft,
                                                   FALSE);

                      IF (NOT ReachedEOHdr) THEN
                         WriteMsgBuffer;

                UNTIL ReachedEOHdr;
           END; { has footer }

           { controleer of er nog voldoende ruimte is voor een #0 }
           IF (MsgBufOfs = WriteBufLen) THEN
              WriteMsgBuffer; { it's a shame if this ever runs.. }

           { einde bericht. Ieder bericht wordt afgesloten met een 0 }
           MsgBuffer^[MsgBufOfs]:=0;
           Inc (MsgBufOfs);

           { nu moet het buffer weggeschreven worden. }
           WriteMsgBuffer;

           { controleren of we over de limiet gegaan zijn kunnen we wel }
           { bij iedere splitpart doen. Anders kan je nog een file van  }
           { weet ik veel hoe groot krijgen.                            }
           CheckExportFilesFull;

     UNTIL ReachedEOMsg;

     { Zorg ervoor dat Moderated Fido newsgroups OOK naar usenet worden  }
     { verzonden. Eigenlijk is dit de verkeerde manier, want het bericht }
     { moet als MAIL naar de moderator en verder nergens heen totdat die }
     { het goedgekeurd heeft!                                            }
     IF (Msg.Ready_F IN [Echomail,Local_Echomail]) AND (AreaData.Moderated = mdUSE) THEN
        FidoPktExportMsg:=TRUE;

     FreeMem (MsgBuffer,WriteBufLen);
{$ENDIF (WtrTest)}
END;

END.


