{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT UnixTime;

{ UnixDate                                                                  }
{                                                                           }
{ Een C style unixdate bestaat uit het aantal seconden sinds 1970           }
{ Deze unit kan ze omrekenen in beide richtingen, ofwel van een Dos datum   }
{ naar seconden en visa versa.                                              }
{                                                                           }
{ MD 03-08-93  Test progje omgezet naar een Unit                            }

INTERFACE

USES Dos;

CONST SEC_Dag              = 60*60*24;
      SEC_Uur    : LONGINT = 60*60;
      SEC_Minuut : LONGINT = 60;

PROCEDURE UnixToDos (Invoer : LONGINT; VAR Result : DateTime);
PROCEDURE DosToUnix (VAR Invoer : DateTime; VAR Result : LONGINT);
FUNCTION  GetCurrentUnixTime : LONGINT;
FUNCTION  UnixTimeToString (Invoer : LONGINT) : STRING;


IMPLEMENTATION

USES Ramon,
     Globals,
     Logs;

CONST SEC_Jaar   : ARRAY[FALSE..TRUE] OF LONGINT = (365*SEC_Dag,{Schrikkel}366*SEC_Dag);
      SEC_Maand  : ARRAY[1..12] OF LONGINT =
                       (31*SEC_Dag,   { Januari  }
                        28*SEC_Dag,   { Februari }
                        31*SEC_Dag,   { Maart    }
                        30*SEC_Dag,   { April    }
                        31*SEC_Dag,   { Mei      }
                        30*SEC_Dag,   { Juni     }
                        31*SEC_Dag,   { Juli     }
                        31*SEC_Dag,   { Augustus }
                        30*SEC_Dag,   { SeptemBer}
                        31*SEC_Dag,   { Oktober  }
                        30*SEC_Dag,   { November }
                        31*SEC_Dag);  { December }

{--------------------------------------------------------------------------}
{ IsSchrikkel                                                              }
{                                                                          }
{ Standaard, is dit jaar een schrikkeljaar?                                }
{                                                                          }
FUNCTION IsSchrikkel (Year : WORD) : BOOLEAN;
BEGIN
     IsSchrikkel:=(Year MOD 400 = 0) OR
                   (NOT (Year MOD 100 = 0) AND (Year MOD 4 = 0));
END;


{--------------------------------------------------------------------------}
{ UnixToDos                                                                }
{                                                                          }
{ Converteerd een Unix-Style datum naar een standaard DateTime structure   }
{                                                                          }
{ Een unix time bestaat uit het aantal seconden verlopen sinds 1 jan 1970. }
{                                                                          }
PROCEDURE UnixToDos (Invoer : LONGINT; VAR Result : DateTime);

VAR MaandNr  : WORD;
    MaandLen : LONGINT;
    DagNr    : WORD;

BEGIN
     { Unix date begint op 1 january 1970 }
     WITH Result DO
     BEGIN
          Year:=1970;

          WHILE (Invoer >= SEC_Jaar[IsSchrikkel (Year)]) DO
          BEGIN
               Invoer:=Invoer-SEC_Jaar[IsSchrikkel (Year)];
               Inc (Year);
          END;

          Month:=1; { January }
          { tel nu de maanden ervanaf }
          { RWI 950318: MaandLen en WHILE TRUE ingevoerd ipv }
          {             vijfdubbele bepaling.                }
          WHILE TRUE DO
          BEGIN
               MaandLen:=SEC_Maand[Month];
               IF (Month = 2) AND IsSchrikkel (Year) THEN
                  MaandLen:=MaandLen+SEC_Dag;

               IF (Invoer >= MaandLen) THEN
               BEGIN
                    Inc (Month);
                    Invoer:=Invoer-MaandLen;
               END ELSE
                   Break;
          END;

          Day:=(Invoer DIV SEC_Dag); { altijd 1 dag }
          Invoer:=(Invoer-Day*SEC_Dag);
          Inc (Day); { RWI 950318: dag nummer is 1-gebaseerd }

          Hour:=(Invoer DIV SEC_Uur);
          Invoer:=(Invoer-Hour*SEC_Uur);

          Min:=Invoer DIV SEC_Minuut;
          Invoer:=(Invoer-Min*SEC_Minuut);

          Sec:=Invoer;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ DosToUnix                                                                }
{                                                                          }
{ Converteert een dos datum naar een unix time.                            }
{                                                                          }
PROCEDURE DosToUnix (VAR Invoer : DateTime; VAR Result : LONGINT);

VAR Jaar,
    MaandNr : INTEGER;

BEGIN
     Result:=0;

     WITH Invoer DO
     BEGIN
          { doorloop het aantal jaren naar 1970 }
          FOR Jaar:=1970 TO (Year-1) DO
              Result:=Result+SEC_Jaar[IsSchrikkel (Jaar)];

          IF (Month = 0) OR (Month > 12) THEN
          BEGIN
               LogMessage ('Invalid month in date: '+Byte2String (Month));

               IF (Month = 0) THEN
                  Month:=1;

               IF (Month > 12) THEN
                  Month:=12;
          END;

          { doorloop het aantal maanden naar de huidige }
          FOR MaandNr:=1 TO (Month-1) DO
          BEGIN
               Result:=Result+SEC_Maand[MaandNr];
               { RWI 950318: toegevoeging controle op schrikkelmaand }
               IF (MaandNr = 2) AND IsSchrikkel (Year) THEN
                  Result:=Result+SEC_Dag;
          END;

          { tel hierbij het aantal dagen op }
          Result:=Result+SEC_Dag*(Day-1);

          { tel hierbij het aantal uren op }
          Result:=Result+SEC_Uur*Hour;

          { tel hierbij het aantal minuten }
          Result:=Result+SEC_Minuut*Min;

          { en uiteindelijk het aantal seconden }
          Result:=Result+Sec;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ GetCurrentUnixTime                                                       }
{                                                                          }
{ Converteert de huidige tijd naar Unix Tijd stempel.                      }
{                                                                          }
FUNCTION GetCurrentUnixTime : LONGINT;

VAR CurrentTime : DateTime;
    Res         : LONGINT;
    h,mi,s,x,
    y,mo,d,o    : WordLong;

BEGIN
     GetTime (h,mi,s,x);
     GetDate (y,mo,d,o);

     WITH CurrentTime DO
     BEGIN
          Year:=y;
          Month:=mo;
          Day:=d;
          Hour:=h;
          Min:=mi;
          Sec:=s;
     END; { with }

     DosToUnix (CurrentTime,Res);
     GetCurrentUnixTime:=Res;
END;


{--------------------------------------------------------------------------}
{ UnixTimeToString                                                         }
{                                                                          }
{ Deze routine conveert een UnixTime in een string.                        }
{                                                                          }
FUNCTION UnixTimeToString (Invoer : LONGINT) : STRING;

VAR DT : DateTime;

BEGIN
     IF (Invoer = 0) THEN
     BEGIN
          UnixTimeToString:='Never';
          Exit;
     END;

     UnixToDos (Invoer,DT);

     UnixTimeToString:=Byte2String (DT.Day)+' '+
                       Month[DT.Month]+' '+
                       Word2String (DT.Year)+' '+
                       AddUpWithPre0s (2,Byte2String (DT.Hour))+':'+
                       AddUpWithPre0s (2,Byte2String (DT.Min))+':'+
                       AddUpWithPre0s (2,Byte2String (DT.Sec));
END;


END.
