{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT WGMain;

INTERFACE

PROCEDURE WGMain_Start;

IMPLEMENTATION

{ conditional defines nodig:
    WtrGate       Guess why...
    Beta          Alleen voor Beta versies
    ReneGade      Andere PC-board support versie (voor wie?)

  directories nodig:
    exe         bin
    inc         ramon;object
    tpu         ramon;router;tdb;object;exec;c:\bp7\units
    obj         ramon;object
}

{$IFNDEF WTRGATE} ##### Check your conditional defines! ##### {$ENDIF}
{$IFDEF WTRTEST}  ##### Check your conditional defines! ##### {$ENDIF}


{ Primairy file van WaterGate }

{ History:

RvdW 20-02-93 Aanpassingen gemaakt ivm nieuwe units van WtrConf.
     02-03-93 IndexTable aanpassingen.
     17-05-93 Het controleren op de aanwezigheid en het eventueel aanmaken
              van de spool subdirs wordt nu vlak na het opstarten gedaan.
              Dit werd eerst bij het zoeken naar .X en .D files gedaan,
              maar bij het aanmaken van een .DAT ahv .X'n en .D's van een
              andere node bestond de subdir dan nog niet.
     25-05-93 Log messages window toegevoegd.
     06-06-93 Stats toegevoegd.
     07-06-93 .TDB Header controle toegevoegd.
MD   03-08-93 Commandline Link opstarten toegevoegd (en later weer verwijderd)
              De log van een leuk headertje voorzien
     04-08-93 ErrorFunc Toegevoegt, kijken of dit veel resultaat heeft
     12-10-93 Controle of enkele directory's wel bestaan toegevoegt
     14-06-94 Wat verwijzingen naar ReneGade support gemaakt
}

{$DEFINE WtrGate}

USES Ramon,
{$IFNDEF DPMI}
{$IFNDEF OS2}
{$IFDEF UseOvr}
     Overlay,
{$ENDIF}
     XmsLib,
{$ENDIF}
{$ENDIF}
     Dos,
     Globals,
     Cfg,
     Fido,
     Database,
     Start,
     Logs,
     SwapMem,
     Language,
     Keys,
     Slice,
     UserBase,
     Msgs,
     Routing,
     ListSrv,
     Stats,
     DupeChk,
     UUCPRout,
     ReadRout,
     Copyrigh,
     Err_Func,
     CharSets,
     BBSUsers,
     Tdb,
     {$IFNDEF OS2}
     {$IFNDEF DPMI}
     Extend,
     {$ENDIF}
     {$ENDIF}
     Crt,
     Gateway;

{---------------------------------------------------------------------------}
{ DoBogusKey                                                                }
{                                                                           }
{ Deze routine keilt een user naar dos als er een foute key gevonden werd.  }
{                                                                           }
PROCEDURE DoBogusKey;

CONST Line1 = 'Jowbmje!lfz!gpvoe"';
      Line2 = 'Zpv!ibwf!kvtu!cffo!jogfdufe!cz!uif!dvstf!pg!uif!qibsbp"';
      Line3 = 'Nbz!eppn!cf!uiz!eftujoz"';

    FUNCTION Decode (Line : STRING) : STRING;

    VAR Result : STRING;
        Lp     : BYTE;

    BEGIN
         Result:='';
         FOR Lp:=1 TO Length (Line) DO
             Result:=Result+Char (Ord (Line[Lp])-1);
         Decode:=Result;
    END;

BEGIN
     WriteLn (Decode (Line1),#7#7#7#7#7#7);
     WriteLn;
     WriteLn (Decode (Line2));
     WriteLn (Decode (Line3));
     WriteLn;
     Halt (3);
END;


{$I wtrstart}

{--------------------------------------------------------------------------}
{ TellAboutMessage                                                         }
{                                                                          }
{ Deze routine geeft de 'About' message op het scherm en wacht daarna op   }
{ een toetsdruk.                                                           }
{                                                                          }
PROCEDURE TellAboutMessage;

CONST Xb = 18;
      Xl = 43;
      Yl = 14;

VAR Yb : XYType;

BEGIN
     Yb:=(Video.Rows DIV 2)-(Yl DIV 2);
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDrawC (cMessage,Single,Xb,Yb,Xl,Yl);

     PushKeysLine;
     WriteKeysLine (' Press any key to continue...');

     WriteXYC (Xb+2,Yb+1,cMessage,DesktopProgramName);
     WriteXY (Xb+2,Yb+2,'Version number '+FullProgramVersion);
     WriteXY (Xb+2,Yb+3,'Compiled at '+CompileDateAndTime);
     WriteXY (Xb+2,Yb+5,'Authors: Ramon van der Winkel');
     WriteXY (Xb+2,Yb+6,'         Martijn Dijksterhuis');
     WriteXY (Xb+2,Yb+7,'         Michel van der Laan');

     WriteXY (Xb+2,Yb+9,'Support: support@wsd.wline.se');

     WriteXY (Xb+2,Yb+10,Repchar( 39 , '' ) );

     {$IFDEF OS2}
     WriteXY (Xb+2,Yb+11,'Mode        : OS/2 PM VIO');
     {$ELSE}
     {$IFDEF DPMI}
     WriteXY (Xb+2,Yb+11,'Mode        : DPMI');
     {$ELSE}
     {$IFDEF USEOVR}
     WriteXY (Xb+2,Yb+11,'Mode        : Overlay');
     {$ELSE}
     WriteXY (Xb+2,Yb+11,'Mode        : Normal');
     {$ENDIF (USEOVR)}
     {$ENDIF (DPMI)}
     {$ENDIF (OS2)}

     WriteXY (Xb+2,Yb+12,'Free memory : '+Longint2String (MemAvail DIV 1024)+'Kb');

     ReadKey;
     PopKeysLine;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ShowHelp                                                                 }
{                                                                          }
{ Laat een simpele help file zien voor WtrGate.                            }
{                                                                          }
PROCEDURE ShowHelp (Name : STRING);

    PROCEDURE WriteOp (Op,Expl : STRING);
    BEGIN
         TextColor (White);
         Write (' ',Op);
         TextColor (LightGray);
         WriteLn ('  ',Expl);
    END;

BEGIN
     WriteLn ('Usage: '+Name+' <command/option> [<command/option>..]');
     WriteLn;
     WriteLn ('Commands:');
     WriteLn;
     WriteOp ('SCAN','Scans local message bases for outgoing messages.');
     WriteOp ('TOSS','Toss files in FTN inbound.');
     WriteOp ('UUCP','Process received UUCP jobs in spool directory.');
     WriteOp ('BAG ','Process received BAG files.');
     WriteOp ('SMTP','Process received SMTP from Mail Queue.');
     WriteOp ('POP3','Process received POP3 mailbox files.');
     WriteLn;

     Write ('<press enter for more>');

     { #13 werkt niet onder OS/2 }
     IF (Crt.ReadKey <> #13) THEN
     BEGIN           {<press enter for more>}
          Write (#13,'                      '#13);
          Exit;
     END;
                 {<press enter for more>}
     WriteLn (#13'Options:              ');
     WriteLn;
     WriteOp ('-NONETSCAN ','Do not scan netmail areas.');
     WriteOp ('-NOECHOSCAN','Do not scan echomail area.');
     WriteOp ('-NONETMAIL ','Do not route received netmail messages, but store them.');
     WriteOp ('-NOEXPORT  ','Only import new messages into the local bases.');
     WriteOp ('-NOLOCAL   ','Only export new messages, do not import them.');
     WriteOp ('-NONEWSTOSS','Do not toss UUCP jobs with news.');
     WriteOp ('-NODUPE    ','Turn off dupe checking.');
     WriteOp ('-NOCHECK   ','Don''t check directories existance at startup.');
     WriteOp ('-NOTUNNEL  ','Do not write MailTunnel e-mails.');
     WriteOp ('-CLEANSCAN ','Ignore HighWater and *.MSG index files during SCAN.');
     WriteOp ('-KEEPFA    ','Keep f/a msg if file cannot be found (for busy LANs).');
     WriteOp ('-MEMUSAGE  ','Show memory used by configuration tables.');
     WriteOp ('-DEBUG     ','Force Debug Logging for this run.');
END;


{---------------------------------------------------------------------------}
{ HeapErrorHandler                                                          }
{                                                                           }
{ Deze routine werkt de heap error af. Hier kan later een swap routine aan  }
{ gehangen worden om geheugen vrij te maken... Zie HeapError in de help     }
{ voor meer info.                                                           }
{                                                                           }
FUNCTION HeapErrorHandler (Size : WORD) : INTEGER; FAR;
BEGIN
     IF (Size <> 0) THEN
     BEGIN
          WriteXYC (1,3,cExitPrg,' Heap Allocation Error!! (Size: '+Word2String (Size)+')');
          WriteXY (1,4,'Exitting with a run-time error');
          { RWI 950317: niet leuk voor unattended mode...
          ReadKey;
          }
          HeapErrorHandler:=0; { crash with runtime error }
     END;
     { ELSE is er ruimte gemaakt en is HeapPtr gewijzigd }
END;


{---------------------------------------------------------------------------}
{ WGMain_Start                                                              }
{                                                                           }
PROCEDURE WGMain_Start;

VAR Quit         : BOOLEAN;
    DelFile      : FILE;  { temp }
    Search2,              { temp }
    Search       : SearchRec;
    Param        : STRING;
    MenuAuto     : KeyType;
    LetterTel,
    ParamTel,
    IORes        : BYTE;
    WorkFlags    : BYTE;
    Lp           : UserBaseRecordNrType;
    ForceNoDupes : BOOLEAN;
    ForceNoCheck : BOOLEAN;
    DV_Versie    : WORD;
    Dir          : DirStr;
    Name         : NameStr;
    Ext          : ExtStr;


LABEL Fatal,
      StartFail;

BEGIN
     TextColor (LightGray);
     TextBackground (Black);

     WriteLn (DesktopProgramName+' v'+FullProgramVersion);
     WriteLn (CopyrightLine);
     {$IFDEF ReneGade}
     WriteLn (ReneGadeInfo);
     {$ENDIF}
     WriteLn;

     {$IFNDEF OS2}
     {$IFOPT G+}
     { check for PC/AT or higher }
     IF (Test8086 = 0) THEN
     BEGIN
          WriteLn (DesktopProgramName+' requires a PC/AT (286) or higher to run');
          Halt (1);
     END;
     {$ENDIF}
     {$ENDIF}

     { Verwerk de opties op de command line VOOR we het hele programma }
     { gaan opstarten.                                                 }

     MenuAuto:=kUnknown;
     WorkFlags:=0;

     ForceNoNet:=FALSE;
     ForceNoEcho:=FALSE;
     ForceNoRoute:=FALSE;
     ForceNoExport:=FALSE;         { gedefinieerd in Globals }
     ForceNoImport:=FALSE;         { gedefinieerd in Globals }
     ForceNoDupes:=FALSE;          { lokaal gedefinieerd     }
     ForceNoCheck:=FALSE;
     ForceNoNewsToss:=FALSE;
     ForceNoFAKill:=FALSE;
     ForceCleanScan:=FALSE;
     ForceNoTunnel:=FALSE;
     ForceDebugLog:=FALSE;
     DebugMem:=FALSE;

     FSplit (ParamStr (0),Dir,Name,Ext);

     IF (ParamCount > 0) THEN
     BEGIN
          FOR ParamTel:=1 TO ParamCount DO
          BEGIN
               Param:=UpCaseString (ParamStr (ParamTel));

               IF (Param = '-NOCHECK') THEN
               BEGIN
                    ForceNoCheck:=TRUE;
                    Continue; { for }
               END;

               IF (Param = '-NODUPE') THEN
               BEGIN
                    ForceNoDupes:=TRUE;
                    Continue; { for }
               END;

               IF (Param = '-NOLOCAL') THEN
               BEGIN
                    ForceNoImport:=TRUE;
                    Continue;
               END;

               IF (Param = '-NOEXPORT') THEN
               BEGIN
                    ForceNoExport:=TRUE;
                    Continue;
               END;

               IF (Param = '-NONETSCAN') THEN
               BEGIN
                    ForceNoNet:=TRUE;
                    Continue;
               END;

               IF (Param = '-NONETMAIL') THEN
               BEGIN
                    ForceNoRoute:=TRUE;
                    Continue;
               END;

               IF (Param = '-NOECHOSCAN') OR (Param = '-NOES') THEN
               BEGIN
                    ForceNoEcho:=TRUE;
                    Continue;
               END;

               IF (Param = '-NONEWSTOSS') THEN
               BEGIN
                    ForceNoNewsToss:=TRUE;
                    Continue;
               END;

               IF (Param = '-NOTUNNEL') THEN
               BEGIN
                    ForceNoTunnel:=TRUE;
                    Continue;
               END;

               IF (Param = '-CLEANSCAN') THEN
               BEGIN
                    ForceCleanScan:=TRUE;
                    Continue;
               END;

               IF (Param = '-KEEPFA') THEN
               BEGIN
                    ForceNoFAKill:=TRUE;
                    Continue;
               END;

               IF (Param = '-MEMUSAGE') THEN
               BEGIN
                    DebugMem:=TRUE;
                    Continue;
               END;

               IF (Param = '-OVR25K') OR (Param = '-OVR50K') THEN
                  Continue;

               IF (Param = '-DEBUG') THEN
               BEGIN
                    ForceDebugLog:=TRUE;
                    Continue;
               END;

               IF (Param = 'TOSSFIDO') OR (Param = 'TOSS') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_FIDOTOSS;
                    Continue;
               END;

               IF (Param = 'SCANFIDO') OR (Param = 'SCAN') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_FIDOSCAN;
                    Continue; { for }
               END;

               IF (Param = 'TOSSUSE') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_UUCPTOSS OR WORK_BAGTOSS;
                    Continue; { for }
               END;

               IF (Param = 'UUCP') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_UUCPTOSS;
                    Continue; { for }
               END;

               IF (Param = 'BAG') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_BAGTOSS;
                    Continue; { for }
               END;

               IF (Param = 'SMTP') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_SMTPTOSS;
                    Continue; { for }
               END;

               IF (Param = 'POP3') THEN
               BEGIN
                    MenuAuto:=mOpt10;
                    WorkFlags:=WorkFlags OR WORK_POP3TOSS;
                    Continue; { for }
               END;

               IF (Param = '?') OR (Param = 'HELP') OR (Param = '-H') OR (Param = '-?') OR (Param = '/?') THEN
               BEGIN
                    ShowHelp (Name);
                    Exit;
               END;

               WriteLn ('Unknown command line option "'+Param+'" found.');
               WriteLn;
               WriteLn ('Use '+Name+' ? for help');
               Exit;
          END; { for }
     END; { if }

     { lees de configuratie file }
     IF (NOT ReadConfigFile) THEN
     BEGIN
          WriteLn ('  Could not find CONFIG.TDB. Please run WtrConf.',#7);
          Exit; { RWI 960902: added }
     END;

     {$IFNDEF OS2}
     {$IFNDEF DPMI}
     IF (NOT XMSPresent) AND (Config.CacheTdbs) THEN
     BEGIN
          LogMessage ('XMS not detected; switching TDB caching OFF');
          Config.CacheTdbs:=FALSE;
     END;
     {$ENDIF}
     {$ENDIF}

     { OpenDatabases moet EERST ivm LOCKING }
     IF (NOT OpenDatabases) OR
        (NOT InitLang (Config.SystemDir)) OR
        (NOT InitCharSets) THEN
     BEGIN
          CloseDatabases;
          LogClose;
          WriteLn;
          WriteLn (' Unable to open configuration files'#7);
          WriteLn;
          Halt (1);
     END;

     { Forceer dupe checking }
     IF ForceNoDupes THEN
        Config.DoDupeChk:=FALSE;

     IF (WtrCheckKey = BogusKey) THEN
        DoBogusKey;

     WtrCheckBetaKey;
     HeapError:=@HeapErrorHandler;
     ConditionRed:=0; { geen error conditie (ivm ErrorLevel) }

     { controleer of er wel genoeg geheugen is }

     { RWI 950524: MaxAvail was eerst MemAvail. Dit lijkt me beter }
     { RWI 960118: weer terug veranderd. Language file laat een    }
     {             gat van 64k achter..                            }
     { RWI 961011: Nu altijd checken, ook bij -NOCHECK             }
     IF (MemAvail < MemNeeded) THEN
     BEGIN
          { RWI 950524: hij is nu wat preciezer met zijn foutmelding }
          WriteLn ('  Not enough low memory to run '+DesktopProgramName+
                   ', need '+Word2String (((MemNeeded-MemAvail) DIV 1024)+1)+'kb more');
          GOTO Fatal;
     END;

     { check directory existance }
     IF (NOT ForceNoCheck) AND (NOT StartUpWtrGate) THEN
     BEGIN
          ConditionRed:=1;
          GOTO Fatal;
     END;

     DesktopCopyright:='WSD';
     OpenDesktop (DesktopProgramName,FullProgramVersion);
     WriteKeysLine (' Initializing...');

     LogScreenLines:=Video.Rows-20;

     BoxDrawNS (Single,1,Video.Rows-LogScreenLines-2,80,LogScreenLines+2);
     WriteXY (2,Video.Rows-LogScreenLines-2,' Log ');
     ScreenToo:=TRUE; { logs ook op het scherm afdrukken }

     {$IFDEF ReneGade}
     WriteXY (1,2,AddUpWithSpaces (80,' '+ReneGadeInfo));
     {$ENDIF}

     LogExtraMessage ('');
     Log_StoreFilePos;
     LogMessage ('Starting '+DeskTopProgramName+' v'+FullProgramVersion);

     {$IFDEF UseOvr}
     IF Config.LogDebug THEN
        LogMessage ('Overlay: Permanent='+Longint2String (OvrGetBuf));
     {$ENDIF}

     IF Config.LogDebug THEN
     BEGIN
          Param:='';
          FOR ParamTel:=1 TO ParamCount DO
              Param:=Param+' '+ParamStr (ParamTel);

          IF (Param = '') THEN
             LogMessage ('No command line arguments')
          ELSE
              LogMessage ('Command line:'+Param);
     END;

     IF DebugMem THEN
     BEGIN
          LogExtraMessage (MEMUSEFOR+'Language = '+Word2String (LangSize));
          LogExtraMessage (MEMUSEFOR+'TdbCache = '+Longint2String (TdbCacheMem));
     END;

     IF Config.UseSwapfile THEN
     BEGIN
          StartSwapfile (Config.SwapfilePath,Longint (Config.SwapfileSize)*1024*1024{mb});
          IF (NOT SwapIsOpen) THEN
          BEGIN
               LogClose; { RWI 961208: added }
               GOTO StartFail;
          END;
     END;

     (*
     {$IFNDEF OS2}
     { Controleer of we DesqView in het geheugen aantreffen }
     { Zoja, maak dan even een melding. Dit omdat we dan nu }
     { Desqview screen writes gebruiken.                    }

     DV_Versie:=DV_Get_Version;
     IF (DV_Versie > 0) THEN
        LogExtraMessage ('Detected DesqView '+Word2String (DV_Versie SHR 8)+'.'+Word2String (DV_Versie AND 255));
     {$ENDIF}
     *)

     IF Config.TimeSlicing THEN
        Slice_Detect;

     { kijken of alle spool paden wel bestaan, anders aanmaken }
     FOR Lp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (Lp,UserData);

          IF (NOT UserData.Deleted) AND (UserData.System = _U) THEN
          BEGIN
               { kijken of het spool pad al bestaat, anders aanmaken }
               FindFirst (Config.SpoolBaseDir+UserData.UUCPName+'\*.*',Archive,Search);
               IF (DosError = 3) THEN { path not found }
               BEGIN
                    IORes:=CreatePath (Config.SpoolBaseDir+UserData.UUCPName);
                    IF (IORes <> 0) THEN
                       LogDiskIOError (IORes,'Cannot create spool directory: '+Config.SpoolBaseDir+UserData.UUCPName);
               END;

               FindClose (Search);
          END; { system = usenet }
     END; { for }

     ReadUserBaseIndexTable;
     ReadAreaBaseIndexTable;

     InitExportedList;
     InitRoutingTable;

     IF (BBSNormalAreaRecNr <> NILRecordNr) OR
        (BBSEMailAreaRecNr <> NILRecordNr) OR
        (BBSViaRecNr <> NILRecordNr)
     THEN
         ReadBBSUsersIndex (DebugMem);

     Slice_Now;

     LoadDefaultCharSets;

     { time slice detectie is nu uitgevoerd }
     {$IFNDEF OS2}
     IF Config.LogDebug AND (Slice_GetMultiTaskerName <> '') THEN
        LogMessage ('Detected '+Slice_GetMultiTaskerName+'; giving up time slices');
     {$ENDIF}

     ListServerTabelInit;
     StatsInit;
     DupeCheckInit;

     LogClose;

     { Laat de Beta/CopyRight melding alleen zien als dit een }
     { beta compilatie is, en er geen opties op de command    }
     { line zijn meegegeven.                                  }

     IF (MenuAuto = kUnknown) THEN
     BEGIN
          {$IFDEF Alfa}
          ShowCopyright;
          {$ENDIF}

          {$IFDEF Beta}
          ShowCopyright;
          {$ENDIF}

          {$IFDEF Gamma}
          ShowCopyright;
          {$ENDIF}

          MenuDefine (30,3,'Main Menu');
          MenuAddItem ('Scan message bases');
          MenuAddItem ('Process FTN files');
          MenuAddItem ('Process UUCP files');
          MenuAddItem ('Process BAG files');
          MenuAddItem ('Process SMTP files ');
          MenuAddItem ('Process POP3 files');
          MenuAddItem ('About WaterGate');
          MenuAddItem ('Exit program');
          MenuShow;
          WriteKeysLine (' ^Esc Exit  ^'#24#25' Choose  ^Enter Select');
     END;

     { De beveiliging zit overal... }
     Quit:=(regKeyNumber = $FFFE); { = FALSE }
     REPEAT
           IF (MenuAuto <> kUnknown) THEN
           BEGIN
                Key:=MenuAuto;
                Quit:=TRUE;
           END ELSE
           BEGIN
                LogClose;
                MenuSelect;
           END;

           CASE Key OF
                mOpt01 : StartWork (WORK_FIDOSCAN,TRUE);
                mOpt02 : StartWork (WORK_FIDOTOSS,TRUE);
                mOpt03 : StartWork (WORK_UUCPTOSS,TRUE);
                mOpt04 : StartWork (WORK_BAGTOSS,TRUE);
                mOpt05 : StartWork (WORK_SMTPTOSS,TRUE);
                mOpt06 : StartWork (WORK_POP3TOSS,TRUE);

                mOpt07 : TellAboutMessage;

                kEsc,
                mOpt08 : Quit:=TRUE;

                mOpt10 : StartWork (WorkFlags,FALSE);

           END; { case }
     UNTIL Quit;

     IF (MenuAuto = kUnknown) THEN
        MenuErase;

     DupeCheckEnd;
     StatsEnd;

     StopSwapfile;
     CloseDatabases;

     JunkAreaBaseIndexTable;
     JunkUserBaseIndexTable;
     JunkExportedList;
     JunkRoutingTable;
     DeleteUUCPRoutingTable;
     JunkLang;
     JunkCharSets;
     JunkBBSUsersIndex;
     JunkGatewayChecks;
     JunkListServerTable;

     {$IFDEF UseOvr}
     IF Config.LogDebug THEN
        LogMessage ('Overlay statistics: LoadCount='+Word2String (OvrLoadCount));
     {$ENDIF}

     IF (SwapTopUse > 0) THEN
        LogMessage ('Swap file usage: '+Longint2String (SwapTopUse)+' bytes');

StartFail:

     { En sluit de log af }
     LogMessage ('Ending program');
     LogExtraMessage ('');
     LogClose;

     NoKeySignOff;

     CloseDesktop;
     ScreenToo:=FALSE; { prevent log from corrupting memory }

     WriteLn ('Ending ',DesktopProgramName,' v',FullProgramVersion);

     KeySignOff;

Fatal:
     IF (ConditionRed > 0) THEN
        WriteLn ('  Exiting with errorlevel ',ConditionRed);

     TdbDone;

     {$IFNDEF OS2}
     {$IFNDEF DPMI}
     UnExtendHandles;
     {$ENDIF}
     {$ENDIF}

     DumpMem;

     Halt (ConditionRed);
END;

END.
