PROGRAM Test;

{ snelheidstests voor DeleteFrontSpaces oude en nieuwe versie
                      DeleteBackSpaces oude en nieuwe versie
                      DeleteFrontAndBackSpaces oude en nieuwe versie
                      DeleteFrontAndBackSpaces vs DeleteFrontSpaces (DeleteBackSpaces ()) voor oude en nieuwe versie
                      DeleteFrontAndBackSpaces nieuw vs DeleteFrontSpaces (DeleteBackSpaces ()) oude
}

USES Ramon;


FUNCTION OldDeleteFrontSpaces (Tekst : STRING) : STRING;
BEGIN
     WHILE (Tekst <> '') AND (Tekst[1] = ' ') DO
           Delete (Tekst,1,1);

     OldDeleteFrontSpaces:=Tekst;
END;

FUNCTION OldDeleteBackSpaces (Tekst : STRING) : STRING;
BEGIN
     WHILE (Tekst <> '') AND (Tekst[Length (Tekst)]= ' ') DO
           Delete (Tekst,Length (Tekst),1);

     OldDeleteBackSpaces:=Tekst;
END;

PROCEDURE RunTest;

VAR StartTimer,
    StopTimer  : LONGINT;
    Lp         : WORD;
    Tekst      : STRING;

BEGIN
     StartTimer:=GetTimer;

     FOR Lp:=1 TO 5000 DO
     BEGIN
          Tekst:=Spaces (10)+RepChar (40,'X')+Spaces (10);
          Tekst:=DeleteFrontAndBackSpaces (Tekst);
     END;

     StopTimer:=GetTimer;
     WriteLn ('Runtime = ',Round ((StopTimer-StartTimer)/18.2*1000),' ms');
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

VAR Lp : BYTE;

BEGIN
     WriteLn;
     WriteLn ('DeleteFrontSpaces ('''+''') = "'+DeleteFrontSpaces ('')+'"');
     WriteLn ('DeleteFrontSpaces (''  '') = "'+DeleteFrontSpaces ('  ')+'"');
     WriteLn ('DeleteFrontSpaces (''X'') = "'+DeleteFrontSpaces ('X')+'"');
     WriteLn ('DeleteFrontSpaces (''  X X'') = "'+DeleteFrontSpaces ('  X X')+'"');
     WriteLn ('DeleteFrontSpaces (''X X  '') = "'+DeleteFrontSpaces ('X X  ')+'"');
     WriteLn ('DeleteFrontSpaces (''  X X  '') = "'+DeleteFrontSpaces ('  X X  ')+'"');

     WriteLn ('DeleteBackSpaces ('''+''') = "'+DeleteBackSpaces ('')+'"');
     WriteLn ('DeleteBackSpaces (''  '') = "'+DeleteBackSpaces ('  ')+'"');
     WriteLn ('DeleteBackSpaces (''X'') = "'+DeleteBackSpaces ('X')+'"');
     WriteLn ('DeleteBackSpaces (''  X X'') = "'+DeleteBackSpaces ('  X X')+'"');
     WriteLn ('DeleteBackSpaces (''X X  '') = "'+DeleteBackSpaces ('X X  ')+'"');
     WriteLn ('DeleteBackSpaces (''  X X  '') = "'+DeleteBackSpaces ('  X X  ')+'"');

     WriteLn ('DeleteFrontAndBackSpaces ('''+''') = "'+DeleteFrontAndBackSpaces ('')+'"');
     WriteLn ('DeleteFrontAndBackSpaces (''  '') = "'+DeleteFrontAndBackSpaces ('  ')+'"');
     WriteLn ('DeleteFrontAndBackSpaces (''X'') = "'+DeleteFrontAndBackSpaces ('X')+'"');
     WriteLn ('DeleteFrontAndBackSpaces (''  X X'') = "'+DeleteFrontAndBackSpaces ('  X X')+'"');
     WriteLn ('DeleteFrontAndBackSpaces (''X X  '') = "'+DeleteFrontAndBackSpaces ('X X  ')+'"');
     WriteLn ('DeleteFrontAndBackSpaces (''  X X  '') = "'+DeleteFrontAndBackSpaces ('  X X  ')+'"');
END.
