{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT CharSets;

{$i platform.inc}

INTERFACE

CONST MAXLEN_CHARSETNAME = 30;

CONST LAST_INTERNAL_CODE  = 620;      { can be increased in the future }

TYPE CharSetType    = (stFtn,stMime);
     CharTableType  = ARRAY[128..LAST_INTERNAL_CODE] OF BYTE;
     CharSetNr      = BYTE;
     CharSetNameStr = STRING[MAXLEN_CHARSETNAME];

VAR DefaultFtnInSetNr,
    DefaultFtnOutSetNr,
    DefaultMimeInSetNr,
    DefaultMimeOutSetNr : CharSetNr;

FUNCTION  CharSets_Init : BOOLEAN;
PROCEDURE CharSets_Junk;
PROCEDURE CharSets_LoadDefault;
FUNCTION  CharSets_Load (SetName : STRING; SetType : CharSetType; OutSet : BOOLEAN) : CharSetNr; { index }
FUNCTION  CharSets_LoadIfExist (SetName : STRING; SetType : CharSetType; OutSet : BOOLEAN; VAR SetNr : CharSetNr) : BOOLEAN;
PROCEDURE CharSets_BuildTransTable (VAR CharTable : CharTableType; InSetNr,OutSetNr : CharSetNr);
{$IFDEF WtrConf}
FUNCTION  CharSets_PickList (RFC : BOOLEAN; VAR SetName : STRING) : BOOLEAN;
{$ENDIF}
FUNCTION  CharSets_MakeDecision_RFC2FTN (IsNews : BOOLEAN; VAR InSetNr,OutSetNr : CharSetNr) : STRING;

PROCEDURE RfcBodyToFtn (InSetNr,OutSetNr : CharSetNr);
FUNCTION  FtnBodyToMime : LONGINT;
FUNCTION  BuildCHRSKludge (CharSetStr : STRING) : STRING;
PROCEDURE AddStandardMimeHeaders;
FUNCTION  CharSets_MimeEncodeHeader (CharSet,Line : STRING) : STRING;


IMPLEMENTATION

USES Ramon,
     Logs,
     Cfg,
     Globals,
     Msgs,
     SwapMem,
     Database,
     Decode; { base64 }

CONST MAX_CHARSETS_CACHED = 6; { 2/4 default, rest vrij }
      CHARSETS_FILENAME   = 'CHARSETS.TDB';

TYPE InternalCodeType = WORD;

CONST SetDescr : ARRAY[CharSetType] OF STRING[4] = ('FTN','MIME');

TYPE CharSetRecord = RECORD
                           SetType    : CharSetType;
                           SetName    : CharSetNameStr;
                           UsageCount : BYTE;

                           MapIn      : ARRAY[128..255] OF InternalCodeType;
                           MapOut     : ARRAY[128..LAST_INTERNAL_CODE] OF BYTE;
                     END;

     CharSetRecordPtr = ^CharSetRecord;

VAR CharSetCount : 0..MAX_CHARSETS_CACHED;
    CharSetPtrs  : ARRAY[1..MAX_CHARSETS_CACHED] OF CharSetRecordPtr;

    FixedSets    : CharSetNr;

    { alleen voor overgang CharSets_Init to CharSets_LoadDefault }
    FtnIn,
    MimeIn,
    FtnOut,
    MimeOut       : CharSetNameStr;

    { voor FtnBodyToMime processing }
    FtnCharSetNr  : CharSetNr;
    FtnLines      : LONGINT;
    FtnHaveHigh   : BOOLEAN;
    FtnDoQuotePrn : BOOLEAN;  { use quoted printable encoding? }
    FtnSinceCR    : BYTE;     { Ftn_UnparagraphBody }


{--------------------------------------------------------------------------}
{ CharSets_TryLoad                                                         }
{                                                                          }
{ This routine searches for the needed character set in charsets.tdb and   }
{ if found, loads it into memory. Sets are cached, so often the set does   }
{ not have to be loaded at all. When the cache is full, the least-used     }
{ one is replaced.                                                         }
{ When the set was not found, 0 is returned. Otherwise the index into the  }
{ the cache is returned.                                                   }
{                                                                          }
FUNCTION CharSets_TryLoad (SetName : STRING; SetType : CharSetType; OutSet : BOOLEAN) : BYTE; { set index }

VAR SetNr : BYTE; { assigned by CheckSetStart }

    PROCEDURE CheckSetStart (Regel : STRING);

    VAR Lp : WORD;

    BEGIN
         IF (NOT CaselessMatch (Regel,SetName)) THEN
            Exit;

         { vraag geheugen aan voor de set; kijk of er een vrij is }
         IF (CharSetCount < MAX_CHARSETS_CACHED) THEN
         BEGIN
              Inc (CharSetCount);
              SetNr:=CharSetCount;
              GetMem (CharSetPtrs[SetNr],SizeOf (CharSetRecord));
         END ELSE
         BEGIN
              { een set eruit gooien }
              SetNr:=FixedSets+1;

              { zoek de oudste set met de laagste UsageCount }
              FOR Lp:=FixedSets+2 TO CharSetCount DO
                  IF (CharSetPtrs[Lp]^.UsageCount < CharSetPtrs[SetNr]^.UsageCount) THEN
                     SetNr:=Lp;

              { SetNr moet er nu uitgegooid worden }
              IF Config.LogDebug THEN
                 LogMessage (liDebug,'Discarding character set '+Regel);
         END;

         { initialise the new set }
         WITH CharSetPtrs[SetNr]^ DO
         BEGIN
              { default from and to mapping is to a question-mark }
              { this avoids an unnecessarily large charsets.tdb   }
              { where half the output set is mapped there.        }
              { zet een een-op-een mapping op }
              FOR Lp:=128 TO 255 DO
                  MapIn[Lp]:=Ord ('?');

              FOR Lp:=128 TO LAST_INTERNAL_CODE DO
                  MapOut[Lp]:=Ord ('?');

              SetName:=Regel;
              UsageCount:=0;
         END; { with }

         CharSetPtrs[SetNr]^.SetType:=SetType;

         IF Config.LogDebug THEN
            LogMessage (liTrivial,'Loading '+SetDescr[SetType]+' character set '+Regel);
    END;

{ CharSets_TryLoad }

VAR Lp      : BYTE;
    InFile  : TEXT;
    IORes   : BYTE;
    Regel   : STRING;
    Keyword : STRING[20];
    P       : BYTE;
    Map1,
    Map2    : WORD;
    Nop     : ValNop;

BEGIN
     SetName:=UpCaseString (SetName);

     { kijk of de karakter set al ingeladen is }
     FOR Lp:=1 TO CharSetCount DO
         IF (SetType = CharSetPtrs[Lp]^.SetType) AND
            (CaselessMatch (SetName,CharSetPtrs[Lp]^.SetName)) THEN
         BEGIN
              IF (CharSetPtrs[Lp]^.UsageCount < 255) THEN
                 Inc (CharSetPtrs[Lp]^.UsageCount);

              CharSets_TryLoad:=Lp;
              Exit;  { ## EXIT ## }
         END;

     CharSets_TryLoad:=0; { assume not found }

     { load the character set }
     Assign (InFile,Config.SystemDir+CHARSETS_FILENAME);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          { log de fout en default to the default character set }
          LogDiskIOError (IORes,'Cannot re-open '+Config.SystemDir+CHARSETS_FILENAME);

          LogExtraMessage ('Cannot load charset "'+SetName+'"; using default');

          Exit;  { ## EXIT ## }
     END;

     {$IFDEF LogFileIO}PostOpenT (InFile);{$ENDIF}

     { Open gelukt. Lees tot de character set definitie gevonden is }
     SetNr:=0; { assume not found }

     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF (Regel = '') OR (Regel[1] = ';') THEN
             Continue;

          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          P:=Pos (';',Regel);
          IF (P > 0) THEN
             Regel:=DeleteBackSpaces (Copy (Regel,1,P-1));

          IF (Regel = '') THEN
             Continue;

          IF (Regel = 'SET-END') THEN
          BEGIN
               { einde van een set bereikt }

               { waren we deze set aan het inladen? }
               IF (SetNr <> 0) THEN
               BEGIN
                    {$IFDEF LogFileIO}PreCloseT (InFile);{$ENDIF}
                    Close (InFile);

                    CharSets_TryLoad:=SetNr;
                    Exit; { ## EXIT ## }
               END;

               { ignore }

               Continue;
          END;

          P:=Pos (' ',Regel);
          IF (P = 0) THEN
             Continue; { warned for elsewhere }

          Keyword:=UpCaseString (Copy (Regel,1,P-1));
          Delete (Regel,1,P);
          Regel:=DeleteFrontSpaces (Regel);

          IF (Keyword = 'FTN-SET') THEN
          BEGIN
               { kijk of dit de juiste set is }
               IF (SetType = stFtn) THEN
                  CheckSetStart (Regel);

               Continue;
          END;

          IF (Keyword = 'MIME-SET') THEN
          BEGIN
               { kijk of dit de juiste set is }
               IF (SetType = stMime) THEN
                  CheckSetStart (Regel);

               Continue;
          END;

          IF (SetNr = 0) THEN
             Continue; { niet de juiste set }

          IF (Keyword = 'MAP-IN') THEN
          BEGIN
               { the real thing! }
               P:=Pos (' ',Regel);

               Val (Copy (Regel,1,P-1),Map1,Nop);

               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               Val (Regel,Map2,Nop);
               IF (Nop <> 0) THEN
                  Map2:=Ord (Regel[1]);

               CharSetPtrs[SetNr]^.MapIn[Map1]:=Map2;

               Continue;
          END;

          IF (Keyword = 'MAP-OUT') THEN
          BEGIN
               { the real thing! }
               P:=Pos (' ',Regel);

               Val (Copy (Regel,1,P-1),Map1,Nop);

               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               Val (Regel,Map2,Nop);
               IF (Nop <> 0) THEN
                  Map2:=Ord (Regel[1]);

               CharSetPtrs[SetNr]^.MapOut[Map1]:=Map2;

               Continue;
          END;

          { ignore other keywords }

     END; { while }

     {$IFDEF LogFileIO}PreCloseT (InFile);{$ENDIF}
     Close (InFile);

     { can be zero! }
     CharSets_TryLoad:=SetNr;
END;


{--------------------------------------------------------------------------}
{ CharSets_Load                                                            }
{                                                                          }
{ This routine tries to load the character set wanted and if this fails,   }
{ it reverts to the default character set for RFC/FTN and the direction.   }
{                                                                          }
FUNCTION CharSets_Load (SetName : STRING; SetType : CharSetType; OutSet : BOOLEAN) : BYTE; { set index }

VAR SetNr : BYTE;

BEGIN
     SetNr:=CharSets_TryLoad (SetName,SetType,OutSet);

     IF (SetNr = 0{not found}) THEN
     BEGIN
          { als de karakterset niet gevonden is, dan maar de default nemen }
          LogMessage (liGeneral,'Charset "'+SetName+'" not found, using default');

          IF (SetType = stFtn) THEN
          BEGIN
               IF OutSet THEN
                  SetNr:=DefaultFtnOutSetNr
               ELSE
                   SetNr:=DefaultFtnInSetNr;
          END ELSE
          BEGIN
               IF OutSet THEN
                  SetNr:=DefaultMimeOutSetNr
               ELSE
                   SetNr:=DefaultMimeInSetNr;
          END;
     END;

     CharSets_Load:=SetNr;
END;


{--------------------------------------------------------------------------}
{ CharSets_LoadIfExist                                                     }
{                                                                          }
{ This routine works like CharSets_Load but tells you when it could not    }
{ find the character set. This is needed during the MIME header decoding   }
{ where we do not want to do the decoding at all when we do not known the  }
{ character set.                                                           }
{ When FALSE is returned, the set did not exist.                           }
{                                                                          }
FUNCTION CharSets_LoadIfExist (SetName : STRING; SetType : CharSetType; OutSet : BOOLEAN; VAR SetNr : CharSetNr) : BOOLEAN;
BEGIN
     SetNr:=CharSets_TryLoad (SetName,SetType,OutSet);
     CharSets_LoadIfExist:=(SetNr <> 0);
END;


{--------------------------------------------------------------------------}
{ CharSets_Init                                                            }
{                                                                          }
{ Deze routine initialiseert de multi-character set handling. It checks    }
{ CHARSETS.TDB file syntax and loads the two default character sets.       }
{ Returns FALSE if something fatal occured and WaterGate should be halted. }
{                                                                          }
FUNCTION CharSets_Init : BOOLEAN;

VAR SetCount : BYTE;
    SetPtrs  : ARRAY[1..255] OF StringPtr;
    SetTypes : ARRAY[1..255] OF CharSetType;
    LineNr   : WORD;
    Path     : STRING;

    { check if we know a certain set name }
    FUNCTION FindSet (SetName : STRING; SetType : CharSetType) : BOOLEAN;

    VAR Lp : BYTE;

    BEGIN
         FindSet:=TRUE; { assume found }

         FOR Lp:=1 TO SetCount DO
             IF (SetType = SetTypes[Lp]) AND CaselessMatch (SetName,SetPtrs[Lp]^) THEN
                Exit; { true }

         WriteLn (' Cannot find ',SetDescr[SetType],' set "'+SetName+'" referenced in line ',LineNr);
         WriteLn ('  of ',Path);

         FindSet:=FALSE; { not found }
    END;

    { Add a found set name to the table of found sets }
    FUNCTION AddSet (SetName : STRING; SetType : CharSetType) : BOOLEAN;

    VAR Lp : BYTE;

    BEGIN
         AddSet:=FALSE; { assume error }

         IF (Length (SetName) > MAXLEN_CHARSETNAME) THEN
         BEGIN
              WriteLn (' Character set name is too long (max ',MAXLEN_CHARSETNAME,')');
              WriteLn ('  in line ',LineNr,' of ',Path);
              Exit;
         END;

         IF (SetCount = 255) THEN
         BEGIN
              WriteLn (' Maximum is 255 sets in line ',LineNr,' of ',Path);
              Exit;
         END;

         {SetName:=UpCaseString (SetName);}

         Inc (SetCount);
         GetMem (SetPtrs[SetCount],Length (SetName)+1);
         SetPtrs[SetCount]^:=SetName;
         SetTypes[SetCount]:=SetType;

         AddSet:=TRUE; { no problem }
    END;

    { free up memory used by the set storage }
    PROCEDURE FreeSetNames;
    BEGIN
         WHILE (SetCount > 0) DO
         BEGIN
              FreeMem (SetPtrs[SetCount],Length (SetPtrs[SetCount]^)+1);
              Dec (SetCount);
         END; { while }
    END;

{ CharSets_Init }

VAR InFile      : TEXT;
    IORes       : BYTE;
    Keyword,
    Regel       : STRING;
    P           : BYTE;
    InSet       : BOOLEAN;
    Map1,Map2   : INTEGER;
    Nop         : ValNop;

LABEL Abort;

BEGIN
     CharSets_Init:=FALSE; { assume problems }

     Path:=Config.SystemDir+CHARSETS_FILENAME;

     Assign (InFile,Path);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 2) OR (IORES = 3) THEN
             WriteLn (' Cannot find '+Path)
          ELSE
              WriteLn (' Error opening '+Path);

          LogDiskIOError (IORes,'Error open '+Path);

          Exit; { FALSE }
     END;

     {$IFDEF LogFileIO}PostOpenT (InFile);{$ENDIF}

     { doorloop de hele file en doe een syntax check }

     LineNr:=0;
     InSet:=FALSE;
     SetCount:=0;

     FtnIn:='';
     FtnOut:='';
     MimeIn:='';
     MimeOut:='';

     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);
          Inc (LineNr);

          IF (Regel = '') OR (Regel[1] = ';') THEN
             Continue;

          { tabs omzetten in spaties en alle voorloop en aanvul spaties verwijderen }
          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          IF (Regel = '') OR (Regel[1] = ';') THEN
             Continue;

          { commentaar verwijderen }
          P:=Pos (';',Regel);
          IF (P > 0) THEN
             Regel:=DeleteBackSpaces (Copy (Regel,1,P-1));

          IF (Regel = '') THEN
             Continue;

          IF (Regel = 'SET-END') THEN
          BEGIN
               { keyword without argument }
               IF (NOT InSet) THEN
               BEGIN
                    WriteLn (' Need FTN-SET / MIME-SET keyword before '+Keyword+' in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               InSet:=FALSE;

               Continue;
          END;

          { nu moet er <keyword><space><rest> staan }
          P:=Pos (' ',Regel);

          IF (P = 0) THEN
          BEGIN
               WriteLn (' Syntax error in line ',LineNr,' in ',Path);
               GOTO Abort;
          END;

          { haal het keyword uit de regel }
          Keyword:=UpCaseString (Copy (Regel,1,P-1));

          Delete (Regel,1,P);
          Regel:=DeleteFrontSpaces (Regel);

          { --- default set indicator? }

          IF (Keyword = 'FTN-IN') THEN
          BEGIN
               FtnIn:=Regel;
               Continue;
          END;

          IF (Keyword = 'FTN-OUT') THEN
          BEGIN
               FtnOut:=Regel;
               Continue;
          END;

          IF (Keyword = 'MIME-IN') THEN
          BEGIN
               MimeIn:=Regel; { case is important! }
               Continue;
          END;

          IF (Keyword = 'MIME-OUT') THEN
          BEGIN
               MimeOut:=Regel; { case is important! }
               Continue;
          END;

          { --- character set definition? }

          IF (Keyword = 'FTN-SET') THEN
          BEGIN
               { nieuwe set definitie }
               IF (NOT AddSet (Regel,stFtn)) THEN
                  GOTO Abort;

               InSet:=TRUE;
               Continue;
          END;

          IF (Keyword = 'MIME-SET') THEN
          BEGIN
               IF (NOT AddSet (Regel,stMime)) THEN
                  GOTO Abort;

               InSet:=TRUE;
               Continue;
          END;

          { als we nu niet in een set zitten, dan niet mappen }
          IF (NOT InSet) THEN
          BEGIN
               WriteLn (' Need FTN-SET / MIME-SET keyword before '+Keyword+' in line ',LineNr);
               WriteLn ('  of ',Path);
               GOTO Abort;
          END;

          IF (Keyword = 'MAP-IN') THEN
          BEGIN
               { check spelling }
               P:=Pos (' ',Regel);

               IF (P = 0) THEN
               BEGIN
                    WriteLn (' Second argument for MAP-IN not present in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Val (Copy (Regel,1,P-1),Map1,Nop);
               IF (Nop <> 0) THEN
               BEGIN
                    WriteLn (' Error in first value of MAP-IN statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               IF (Map1 < 128) OR (Map1 > 255) THEN
               BEGIN
                    WriteLn (' First value out of range (128..255) in MAP-IN statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               IF (Regel = '') THEN
               BEGIN
                    WriteLn (' Second value missing in MAP-IN statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Val (Regel,Map2,Nop);

               IF (Nop <> 0) THEN
               BEGIN
                    Map2:=Ord (Regel[1]);
                    Nop:=0;
               END;

               IF (Nop <> 0) THEN
               BEGIN
                    WriteLn (' Error in second value in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               { can map to non high-ascii in the range 32-127 too! }
               IF (Map2 < 32) OR (Map2 > LAST_INTERNAL_CODE) THEN
               BEGIN
                    WriteLn (' Second value out of range (32..',LAST_INTERNAL_CODE,') in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Continue;
          END;

          IF (Keyword = 'MAP-OUT') THEN
          BEGIN
               { check spelling }
               P:=Pos (' ',Regel);

               IF (P = 0) THEN
               BEGIN
                    WriteLn (' Second argument for MAP-OUT not present in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Val (Copy (Regel,1,P-1),Map1,Nop);
               IF (Nop <> 0) THEN
               BEGIN
                    WriteLn (' Error in first value of MAP-OUT statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               IF (Map1 < 128) OR (Map1 > LAST_INTERNAL_CODE) THEN
               BEGIN
                    WriteLn (' First value out of range (128..',LAST_INTERNAL_CODE,') in MAP-OUT statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               IF (Regel = '') THEN
               BEGIN
                    WriteLn (' Second value missing in MAP-OUT statement in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Val (Regel,Map2,Nop);

               IF (Nop <> 0) THEN
               BEGIN
                    Map2:=Ord (Regel[1]);
                    Nop:=0;
               END;

               IF (Nop <> 0) THEN
               BEGIN
                    WriteLn (' Error in second value in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               IF (Map2 < 1) OR (Map2 > 255) THEN
               BEGIN
                    WriteLn (' Second value out of range (1..255) in line ',LineNr);
                    WriteLn ('  of ',Path);
                    GOTO Abort;
               END;

               Continue;
          END;

          { unknown keyword }

          WriteLn (' Unknown keyword "'+Keyword+'" in line ',LineNr);
          WriteLn ('  of ',Path);

          GOTO Abort;

     END; { while }

     { controleer of de default sets voorkwamen }
     IF (FtnIn= '') THEN
        WriteLn (' FTN-IN set not defined in '+Path);

     IF (FtnOut = '') THEN
        WriteLn (' FTN-OUT set not defined in '+Path);

     IF (MimeIn = '') THEN
        WriteLn (' MIME-IN set not defined in '+Path);

     IF (MimeOut = '') THEN
        WriteLn (' MIME-OUT set not defined in '+Path);

     IF (MimeIn = '') OR (MimeOut = '') OR (FtnIn = '') OR (FtnOut = '') THEN
        GOTO Abort;

     IF (NOT FindSet (FtnIn,stFtn)) THEN
     BEGIN
          WriteLn ('  (the FTN-IN set!!)');
          GOTO Abort;
     END;

     IF (NOT FindSet (FtnOut,stFtn)) THEN
     BEGIN
          WriteLn ('  (the FTN-OUT set!!)');
          GOTO Abort;
     END;

     IF (NOT FindSet (MimeIn,stMime)) THEN
     BEGIN
          WriteLn ('  (the MIME-IN set!!)');
          GOTO Abort;
     END;

     IF (NOT FindSet (MimeOut,stMime)) THEN
     BEGIN
          WriteLn ('  (the MIME-OUT set!!)');
          GOTO Abort;
     END;

     CharSets_Init:=TRUE; { no problems }

Abort:
     {$IFDEF LogFileIO}PreCloseT (InFile);{$ENDIF}
     Close (InFile);

     FreeSetNames;
END;


{--------------------------------------------------------------------------}
{ CharSets_LoadDefault                                                     }
{                                                                          }
{ Deze routine laadt de default karakter sets in nadat het systeem         }
{ overgeschakeld is naar full-screen mode.                                 }
{                                                                          }
PROCEDURE CharSets_LoadDefault;
BEGIN
     DefaultFtnInSetNr:=CharSets_Load (FtnIn,stFtn,FALSE{in});
     DefaultFtnOutSetNr:=CharSets_Load (FtnOut,stFtn,TRUE{out});

     DefaultMimeInSetNr:=CharSets_Load (MimeIn,stMime,FALSE{in});
     DefaultMimeOutSetNr:=CharSets_Load (MimeOut,stMime,FALSE{out});

     { stop het hoogste nummer in FixedSets, zodat deze sets nooit }
     { vrijgegeven worden.                                         }

     FixedSets:=DefaultFtnInSetNr;

     IF (DefaultFtnOutSetNr > FixedSets) THEN
        FixedSets:=DefaultFtnOutSetNr;

     IF (DefaultMimeInSetNr > FixedSets) THEN
        FixedSets:=DefaultMimeInSetNr;

     IF (DefaultMimeOutSetNr > FixedSets) THEN
        FixedSets:=DefaultMimeOutSetNr;
END;


{--------------------------------------------------------------------------}
{ CharSets_Junk                                                            }
{                                                                          }
{ Frees up all memory used by the multiple character set support.          }
{                                                                          }
PROCEDURE CharSets_Junk;
BEGIN
     WHILE (CharSetCount > 0) DO
     BEGIN
          FreeMem (CharSetPtrs[CharSetCount],SizeOf (CharSetRecord));
          CharSetPtrs[CharSetCount]:=NIL;
          Dec (CharSetCount);
     END; { while }
END;


{--------------------------------------------------------------------------}
{ CharSets_BuildTransTable                                                 }
{                                                                          }
{ This routine builds a translation table that translates directly from    }
{ one set to another for all character set values in the range 128..255.   }
{                                                                          }
PROCEDURE CharSets_BuildTransTable (VAR CharTable : CharTableType; InSetNr,OutSetNr : CharSetNr);

VAR Lp : BYTE;
    B  : WORD;

BEGIN
     FOR Lp:=128 TO 255 DO
         CharTable[Lp]:=Ord ('?');

     IF (InSetNr = 0) THEN
     BEGIN
          LogMessage (liReport,'[CharSets_BuildTransTable] In-charset number is undefined!');
          Exit;  { ## EXIT ## }
     END;

     IF (OutSetNr = 0) THEN
     BEGIN
          LogMessage (liReport,'[CharSets_BuildTransTable] Out-charset number is undefined!');
          Exit;  { ## EXIT ## }
     END;

     FOR Lp:=128 TO 255 DO
     BEGIN
          { MAP Getal naar interne set }
          { dit kan ook gewone ASCII zijn!! }
          B:=CharSetPtrs[InSetNr]^.MapIn[Lp];

          { MAP Getal nu naar de out set }
          IF (B >= 128) THEN
             B:=CharSetPtrs[OutSetNr]^.MapOut[B];

          { RWI 970112: prevent 00's in the body because of errors }
          IF (B = 0) THEN
             B:=Ord ('?');

          { Getal nu in de FTN set }
          CharTable[Lp]:=B;
     END; { for }
END;


VAR Rfc2Ftn_TransTable : CharTableType;

{--------------------------------------------------------------------------}
{ Rfc_TranslateBodyLineToFtn                                               }
{                                                                          }
{ This routine is called upon for each line in the body and translates it  }
{ to the FTN character set based on the default RFC character set.         }
{                                                                          }
FUNCTION Rfc_TranslateBodyLineToFtn (VAR OrigRegel : STRING) : BOOLEAN; FAR;

VAR Regel : STRING;
    Lp    : BYTE;
    Digit : CHAR;
    Getal : BYTE;

BEGIN
     Rfc_TranslateBodyLineToFtn:=FALSE; { continue always }

     { do not change the original line }
     Regel:=OrigRegel;

     FOR Lp:=1 TO Length (OrigRegel) DO
     BEGIN
          { als het een 8-bit teken is, dan vertalen we de karakterset code }
          Getal:=Byte (Regel[Lp]);

          { Getal nu in MIME character set }
          IF (Getal >= 128) THEN
          BEGIN
               Getal:=Rfc2Ftn_TransTable[Getal];

               { Getal nu in de FTN set }
               Regel[Lp]:=Char (Getal);
          END;

          { prevent NUL's in the body in case of errors }
          IF (Getal = 0) THEN
             Regel[Lp]:='?';

     END; { for }

     MsgsAddLineToNoEOL (Body,Regel);
END;


{--------------------------------------------------------------------------}
{ RfcBodyToFtn                                                             }
{                                                                          }
{ This routine is used to translate a non-MIME RFC body to FTN, adhering   }
{ to the character set translation.                                        }
{                                                                          }
PROCEDURE RfcBodyToFtn (InSetNr,OutSetNr : CharSetNr);

VAR OldBody           : TopRegelRecordPtr;
    OldPartStatus     : PartStatusType;
    OldAttachmentInfo : STRING;
    Lp                : 1..MAX_BODY_PARTS;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating RFC body to FTN');

     { build the translation table only once }
     CharSets_BuildTransTable (Rfc2Ftn_TransTable,InSetNr,OutSetNr);

     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Charsets: "'+CharSetPtrs[InSetNr]^.SetName+
                                   '" -> "'+CharSetPtrs[OutSetNr]^.SetName+'"');

     { doorloop nu de body en doe het vertaalwerk }
     FOR Lp:=1 TO MAX_BODY_PARTS DO
     BEGIN
          Msg.CurrentBodyPart:=Lp;

          { copy the pointer to the body part and then clean it }
          OldBody:=Msg.BodyParts[Lp];
          IF (OldBody <> NIL) THEN
          BEGIN
               Msg.BodyParts[Lp]:=NIL;

               { save the old part status and attachment info }
               OldPartStatus:=OldBody^.PartStatus;
               OldAttachmentInfo:=OldBody^.AttachmentInfo;

               { translate all lines and store them again; kill processed lines }
               MsgsForEachKill (OldBody,Rfc_TranslateBodyLineToFtn);

               { restore the part status and attachment info }
               Msg.BodyParts[Lp]^.PartStatus:=OldPartStatus;
               Msg.BodyParts[Lp]^.AttachmentInfo:=OldAttachmentInfo;
          END;
     END; { for }
END;


{--------------------------------------------------------------------------}
{ Ftn_CheckIfNeedQuotedPrintable                                           }
{                                                                          }
{ Deze routine doorloopt iedere regel van de body om te kijken of we       }
{ Quoted-printable encoding nodig hebben. Als de body geen 8-bit tekens    }
{ bevat, dan gebruiken we geen quoted-printable encoding. Ook = tekens     }
{ blijven dan gewone = tekens.                                             }
{ Quoted printable betekent ook automatisch soft line breaks. Dit kan      }
{ geforceerd worden van de config.                                         }
{                                                                          }
FUNCTION Ftn_CheckIfNeedQuotedPrintable (VAR Regel : STRING) : BOOLEAN; FAR;

VAR Lp    : BYTE;
    Teken : BYTE;

BEGIN
     IF FtnDoQuotePrn THEN
     BEGIN
          Ftn_CheckIfNeedQuotedPrintable:=TRUE; { abort }
          Exit;
     END;

     FOR Lp:=1 TO Length (Regel) DO
         IF NOT (Byte (Regel[Lp]) IN [13,32..127]) THEN
         BEGIN
              { first do the character set translation before   }
              { we are really sure. This is simple, because an  }
              { FTN message has only one character set. So far. }

              Teken:=Byte (Regel[Lp]);

              { voorkom array access voor [0..12,14..31] }
              IF (Teken >= 128) THEN
              BEGIN
                   { vertaal naar interne set }
                   Teken:=CharSetPtrs[FtnCharSetNr]^.MapIn[Teken];

                   { nu een interne code, of een gewone ascii code }
                   IF (Teken >= 128) THEN
                      Teken:=CharSetPtrs[DefaultMimeOutSetNr]^.MapOut[Teken];
              END;

              IF NOT (Teken IN [13,32..127]) THEN
              BEGIN
                   FtnDoQuotePrn:=TRUE;
                   Ftn_CheckIfNeedQuotedPrintable:=TRUE; { abort }
                   Exit;
              END;
         END; { if, for }

     Ftn_CheckIfNeedQuotedPrintable:=FALSE; { continue feeding Regels }
END;


{---------------------------------------------------------------------------}
{ Ftn_UnparagraphBody                                                       }
{                                                                           }
{ Deze routine kijkt of de regel te lang is en zoja, breekt em af op de     }
{ opgegeven wrap positie. De regels worden aan de body toegevoegd.          }
{                                                                           }
{ Werkt als volgt: we tellen het aantal tekens sinds de laatste CR en als   }
{ dat meer dan Config.WrapLineLen is, dan zoeken we de woord grens en       }
{ voegen een extra CR toe.                                                  }
{                                                                           }
FUNCTION Ftn_UnparagraphBody (VAR OrigRegel : STRING) : BOOLEAN; FAR;

VAR P     : BYTE;
    Regel : STRING;
    Teken : BYTE;

BEGIN
     Ftn_UnparagraphBody:=FALSE; { continue always }

     Regel:='';

     FOR P:=1 TO Length (OrigRegel) DO
     BEGIN
          Teken:=Ord (OrigRegel[P]);

          IF (Teken >= 128) THEN
          BEGIN
               { teken nu in FTN set }

               { vertaal naar interne set }
               Teken:=CharSetPtrs[FtnCharSetNr]^.MapIn[Teken];

               { nu een interne code, of een gewone ascii code }
               IF (Teken >= 128) THEN
               BEGIN
                    Teken:=CharSetPtrs[DefaultMimeOutSetNr]^.MapOut[Teken];

                    IF (Teken > 128) THEN
                       FtnHaveHigh:=TRUE; { add MIME-version + 8bit header }
               END;
          END;

          Regel:=Regel+Char (Teken);
     END;

     { RAWI 991224: added support for WrapLineLength==0 -> do not wrap }
     {              FtnLines is needed for news!                       }
     IF (Config.WrapLineLen = 0) THEN
     BEGIN
          MsgsAddLineToNoEOL (Body,Regel);
          IF (Pos (#13,Regel) > 0) THEN
             Inc (FtnLines);
          Exit;                 { ## EXIT ## }
     END;

     { snelle controle of deze regel zo mee kan }
     P:=Pos (#13,Regel);

     IF (P = Length (Regel)) AND (FtnSinceCR+P <= Config.WrapLineLen) THEN
     BEGIN
          { 90% case: <regel>#13 }
          MsgsAddLineToNoEOL (Body,Regel);
          Inc (FtnLines); { RWI 970130: toegevoegd }
          FtnSinceCR:=0; { weer 0 toegevoegd }
          Exit;  { ## EXIT ## }
     END;

     { eventueel <regel> zonder CR testen, als ie vaak voorkomt tenminste }

     WHILE (Regel <> '') DO
     BEGIN
          { ### kunnen we nu precies Config.WrapLineLen tekens toegevoegd hebben? }

          P:=Pos (#13,Regel);

          { als dit hele stuk zonder CR nog past, dan gewoon doen en klaar }
          IF (P = 0) AND (FtnSinceCR+Length (Regel) < Config.WrapLineLen) THEN
          BEGIN
               Inc (FtnSinceCR,Length (Regel));
               MsgsAddLineToNoEOL (Body,Regel);  { RAWI 971018: added NoEOL }
               Exit;
          END;

          { als het stuk tot de volgende enter nog past, dan gewoon doen }
          IF (P <> 0) AND (FtnSinceCR+P <= Config.WrapLineLen) THEN
          BEGIN
               { RWI 970130: P is inclusief CR, changed to NoEOL }
               MsgsAddLineToNoEOL (Body,Copy (Regel,1,P{inclusive CR}));
               Inc (FtnLines); { RWI 970130: toegevoegd }
               Delete (Regel,1,P);
               FtnSinceCR:=0;
               Continue;
          END;

          { stuk is te lang. Wrappen! }

          { hoeveel mogen we nog toevoegen? }
          { moet altijd een valid offset in Regel zijn!! }
          P:=Config.WrapLineLen-FtnSinceCR;

          { ga op zoek naar de spatie voor wordwrap }
          WHILE (P > 0) AND (Regel[P] <> ' ') DO
                Dec (P);

          IF (P = 0) THEN
          BEGIN
               { geen spatie gevonden. Dat wordt dus keihard afbreken }
               P:=Config.WrapLineLen-FtnSinceCR;
               MsgsAddLineToNoEOL (Body,Copy (Regel,1,P)+#13);
               Delete (Regel,1,P);
          END ELSE
          BEGIN
               { braaf wordwrappen }
               MsgsAddLineToNoEOL (Body,Copy (Regel,1,P-1{spatie weg})+#13);
               Delete (Regel,1,P); { incluis spatie }
               { pech als er twee spaties achter elkaar }
               { staan.                                 }
          END;

          { we hebben nu altijd een CR aan het einde gehad }
          FtnSinceCR:=0;
          Inc (FtnLines); { RWI 970130: toegevoegd }

     END; { while Regel<>'' }
END;


{--------------------------------------------------------------------------}
{ Ftn_TranslateBodyLineToMimeQuotedPrintable                               }
{                                                                          }
{ Deze routine vertaald een regel tekst van FTN formaat naar MIME formaat. }
{ We gebruiken 7BIT content-transfer-encoding en moeten dus hex codering   }
{ gebruiken (=E7 enzo). Karakterset wordt ook omgezet.                     }
{                                                                          }
FUNCTION Ftn_TranslateBodyLineToMimeQuotedPrintable (VAR OrigRegel : STRING) : BOOLEAN; FAR;

VAR Regel : STRING;

    {----------------------------------------------------------------------}
    { SoftWrappedOutput                                                    }
    {                                                                      }
    { Schrijf een stuk van Regel weg door af te kappen op het laatste      }
    { woord. Voeg een = teken aan het einde toe om een MIME soft break     }
    { aan te geven. Verwijder het weggeschreven stuk uit Regel.            }
    {                                                                      }
    PROCEDURE SoftWrappedOutput;

    VAR P : BYTE;

    BEGIN
         P:=Length (Regel);
         WHILE (P > 30) AND (Regel[P] <> ' ') DO
               Dec (P);

         IF (P = 30) THEN
            P:=Length (Regel);

         MsgsAddLineTo (Body,Copy (Regel,1,P)+'=');
         Inc (FtnLines);

         Delete (Regel,1,P);
    END;

{ Ftn_TranslateBodyLineToMimeQuotedPrintable }

VAR Lp    : BYTE;
    Teken : BYTE;

BEGIN
     Ftn_TranslateBodyLineToMimeQuotedPrintable:=FALSE; { continue always }

     Regel:='';

     { zolang er geen 8-bit in voorkomt zijn we veilig }
     FOR Lp:=1 TO Length (OrigRegel) DO
     BEGIN
          Teken:=Byte (OrigRegel[Lp]);

          { RWI 970110: fast processing of valid characters }
          IF (Teken >= 32) AND (Teken < 128) AND (Teken <> Ord ('=')) THEN
          BEGIN
               IF (Length (Regel) >= 76{maxlen}) THEN
                  SoftWrappedOutput;

               Regel:=Regel+Char (Teken);
               Continue;
          END;

          IF (Teken = 13{line break}) THEN
          BEGIN
               MsgsAddLineTo (Body,Regel);  { geen softbreak! }
               Inc (FtnLines);
               Regel:='';
               Continue;
          END;

          IF (Teken >= 128) THEN
          BEGIN
               { teken nu in FTN set }

               { vertaal naar interne set }
               Teken:=CharSetPtrs[FtnCharSetNr]^.MapIn[Teken];

               { nu een interne code, of een gewone ascii code }
               IF (Teken >= 128) THEN
                  Teken:=CharSetPtrs[DefaultMimeOutSetNr]^.MapOut[Teken];
          END;

          { there are extra, optional characters we are allowed to encode }
          IF (Teken < 32) OR (Teken >= 128) OR (Teken = Ord ('=')) THEN
          BEGIN
               IF (Length (Regel) > 73{maxlen 76}) THEN
                  SoftWrappedOutput;

               { quoted-printable toevoegen }
               Regel:=Regel+'='+Byte2HexString (Teken);
               FtnHaveHigh:=TRUE;
          END ELSE
          BEGIN
               IF (Length (Regel) >= 76{maxlen}) THEN
                  SoftWrappedOutput;

               Regel:=Regel+Char (Teken);
          END;
     END; { for }

     IF (Regel <> '') THEN
     BEGIN
          MsgsAddLineTo (Body,Regel+'='{MIME soft break});
          Inc (FtnLines);
     END;
END;


{--------------------------------------------------------------------------}
{ FtnBodyToMime                                                            }
{                                                                          }
{ Deze routine zet de body om van een 8-bits FTN karakter set (nu in       }
{ Msg.Chr_F en anders de default set) in een MIME encoded body van het     }
{ gewenste type.                                                           }
{                                                                          }
FUNCTION FtnBodyToMime : LONGINT;

VAR OldBody : TopRegelRecordPtr;
    Lp      : 1..MAX_BODY_PARTS;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating FTN body to MIME');

     { initialiseer default variabelen }
     IF (Msg.Chrs_F = '') THEN
        FtnCharSetNr:=DefaultFtnInSetNr
     ELSE
         FtnCharSetNr:=CharSets_Load (Msg.Chrs_F,stFtn,FALSE{in});

     FtnLines:=0;
     FtnHaveHigh:=FALSE; { alleen maar 7bit data }

     { RWI 970115: if the sysop doesn't like quoted printable, then }
     {             check if we really need to use it. This avoids   }
     {             encoded equal signs..                            }

     FtnDoQuotePrn:=FALSE;   { do not use quoted printable encoding }

     IF (NOT Config.Allow8Bit) THEN
     BEGIN
          IF Config.AlwaysMimeQuotePrint THEN
             FtnDoQuotePrn:=TRUE
          ELSE
              FOR Lp:=1 TO MAX_BODY_PARTS DO
                  MsgsForEach (Msg.BodyParts[Lp],Ftn_CheckIfNeedQuotedPrintable);
     END;

     { doorloop nu de body en doe het vertaalwerk }
     { dit kost dus even twee keer zoveel geheugen/swapfile! }

     { all will be added to 1 new body part }
     Msg.CurrentBodyPart:=1;

     { nu _of_ quoted-printable coderen, of gewoon paragrafen vernietigen }
     FOR Lp:=1 TO MAX_BODY_PARTS DO
     BEGIN
          OldBody:=Msg.BodyParts[Lp];
          IF (OldBody <> NIL) THEN
          BEGIN
               Msg.BodyParts[Lp]:=NIL;

               IF FtnDoQuotePrn THEN
               BEGIN
                    MsgsForEachKill (OldBody,Ftn_TranslateBodyLineToMimeQuotedPrintable);
               END ELSE
               BEGIN
                    { afkappen gebeurt op MAXLENREGEL afstand vanaf de laatste CR, }
                    { wat door SinceCR geteld wordt.                               }
                    FtnSinceCR:=0; { nul tekens sinds laatste CR }

                    MsgsForEachKill (OldBody,Ftn_UnparagraphBody);
               END;
          END;
     END; { for }

     FtnBodyToMime:=FtnLines; { voor Lines: header in news }
END;


{--------------------------------------------------------------------------}
{ BuildCHRSKludge                                                          }
{                                                                          }
{ Deze routine geeft een "^ACHRS: <name> 2" kludge terug.                  }
{                                                                          }
FUNCTION BuildCHRSKludge (CharSetStr : STRING) : STRING;
BEGIN
     IF (CharSetStr = '') THEN
        CharSetStr:=CharSetPtrs[DefaultFtnOutSetNr]^.SetName;

     BuildCHRSKludge:=#1'CHRS: '+CharSetStr+' 2';
END;


{--------------------------------------------------------------------------}
{ AddStandardMimeHeaders                                                   }
{                                                                          }
{ Deze routine voegt de drie MIME headers toe: version, content and        }
{ encoding.                                                                }
{                                                                          }
PROCEDURE AddStandardMimeHeaders;
BEGIN
     IF FtnHaveHigh OR FtnDoQuotePrn THEN
     BEGIN
          MsgsAddLineTo (Header_U,'MIME-version: 1.0');
          Msg.IsMime:=TRUE; { direct internal RFC -> FTN doesn't work otherwise! }

          IF FtnHaveHigh THEN
             MsgsAddLineTo (Header_U,'Content-type: text/plain; charset='+CharSetPtrs[DefaultMimeOutSetNr]^.SetName);

          IF Config.Allow8Bit THEN
             MsgsAddLineTo (Header_U,'Content-transfer-encoding: 8bit')
          ELSE
              IF FtnDoQuotePrn THEN
                 MsgsAddLineTo (Header_U,'Content-transfer-encoding: Quoted-printable');
     END;
END;


{--------------------------------------------------------------------------}
{ CharSets_MimeEncodeHeader                                                }
{                                                                          }
{ This routine translates a header picked up from an FTN body to RFC       }
{ format, performing a character set translation and header-QP encoding if }
{ required.                                                                }
{ Example: "Header: Skne" -> "Header: =?iso-8859-1?Q?Sk=E5ne?="           }
{ See RFC1342 and RFC2047 for details.                                     }
{                                                                          }
FUNCTION CharSets_MimeEncodeHeader (CharSet,Line : STRING) : STRING;

VAR Regel  : STRING;
    Lp     : BYTE;
    Teken  : BYTE;
    HaveQP : BOOLEAN;
    {Header : STRING;}

BEGIN
     IF (CharSet = '') THEN
        FtnCharSetNr:=DefaultFtnInSetNr
     ELSE
         FtnCharSetNr:=CharSets_Load (CharSet,stFtn,FALSE{in});

     {
     Lp:=Pos (': ',Line);
     Header:=Copy (Line,1,Lp+1);
     Delete (Line,1,Lp+1);
     }

     Regel:='';
     HaveQP:=FALSE;

     { zolang er geen 8-bit in voorkomt zijn we veilig }
     FOR Lp:=1 TO Length (Line) DO
     BEGIN
          Teken:=Byte (Line[Lp]);

          { RWI 970110: fast processing of valid characters }
          IF (Teken >= 32) AND (Teken < 128) AND (Teken <> Ord ('=')) THEN
          BEGIN
               Regel:=Regel+Char (Teken);
               Continue;
          END;

          IF (Teken >= 128) THEN
          BEGIN
               { teken nu in FTN set }

               { vertaal naar interne set }
               Teken:=CharSetPtrs[FtnCharSetNr]^.MapIn[Teken];

               { nu een interne code, of een gewone ascii code }
               IF (Teken >= 128) THEN
                  Teken:=CharSetPtrs[DefaultMimeOutSetNr]^.MapOut[Teken];
          END;

          { there are extra, optional characters we are allowed to encode }
          IF (Teken < 32) OR (Teken >= 128) OR (Teken = Ord ('=')) THEN
          BEGIN
               { quoted-printable toevoegen }
               {##do we need to do this when 8bit transport is allowed?}
               Regel:=Regel+'='+Byte2HexString (Teken);
               HaveQP:=TRUE;
          END ELSE
              Regel:=Regel+Char (Teken);
     END; { for }

     { add QP header and footer, if required }
     IF HaveQP THEN
        Regel:='=?'+CharSetPtrs[DefaultMimeOutSetNr]^.SetName+'?Q?'+Regel+'?=';

     CharSets_MimeEncodeHeader:={Header+}Regel;
END;


{$IFDEF WtrConf}

{$I wtrhlp.inc}

{--------------------------------------------------------------------------}
{ CharSets_PickList                                                        }
{                                                                          }
{ This function allows the user to select a character set. The pointed to  }
{ variable is updated with the new set. The function returns TRUE if the   }
{ user aborted or FALSE when a selection was made. SetName is modified     }
{ whether a selection has been made or not, but it is not corrupted (just  }
{ spaces removed).                                                         }
{                                                                          }
FUNCTION CharSets_PickList (RFC : BOOLEAN; VAR SetName : STRING) : BOOLEAN;

VAR InFile  : TEXT;
    IORes   : BYTE;
    Regel   : STRING;
    Keyword : STRING[20];
    P       : BYTE;
    CursorNr,
    Nr      : WORD;

BEGIN
     CharSets_PickList:=TRUE; { assume no selection made }

     SetName:=DeleteFrontAndBackSpaces (SetName);

     IF RFC THEN
        ListDefine (25,20,35,14,BottomLeft,'RFC Character Sets',htr_AreaEdit_CharSetPickList)
     ELSE
        ListDefine (25,20,35,14,BottomLeft,'FTN Character Sets',htr_AreaEdit_CHarSetPickList);

     Assign (InFile,Config.SystemDir+CHARSETS_FILENAME);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          Error ('Cannot open '+Config.SystemDir+CHARSETS_FILENAME+' (error '+Byte2String (IORes)+')');
          Exit;
     END;

     Nr:=0;
     CursorNr:=0;

     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF (Regel = '') OR (Regel[1] = ';') THEN
             Continue;

          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          IF (Regel = '') THEN
             Continue;

          P:=Pos (';',Regel);
          IF (P > 0) THEN
             Regel:=DeleteBackSpaces (Copy (Regel,1,P-1));

          P:=Pos (' ',Regel);
          IF (P = 0) THEN
             Continue; { warned for elsewhere }

          Keyword:=UpCaseString (Copy (Regel,1,P-1));
          Delete (Regel,1,P);
          Regel:=DeleteFrontSpaces (Regel);

          IF RFC THEN
          BEGIN
               IF (Keyword = 'MIME-SET') THEN
               BEGIN
                    Inc (Nr);
                    ListAddItem (Regel,Nr,Sorted);
                    IF CaselessMatch (Regel,SetName) THEN
                       CursorNr:=Nr;
               END;
          END ELSE
          BEGIN
               IF (Keyword = 'FTN-SET') THEN
               BEGIN
                    Inc (Nr);
                    ListAddItem (Regel,Nr,Sorted);
                    IF CaselessMatch (Regel,SetName) THEN
                       CursorNr:=Nr;
               END;
          END;
     END; { while }

     Close (InFile);

     IF (ListItemCount = 0) THEN
     BEGIN
          ListErase;
          Error ('No character set names were found in CHARSETS.TDB');
          Exit;
     END;

     ListSetCursorOnItem (CursorNr);
     Nr:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
     BEGIN
          SetName:=ListGetItemTekst (Nr);
          CharSets_PickList:=FALSE; { selection has been made }
     END;

     ListErase;
END;
{$ENDIF}


{==========================================================================}
{                       CHARSET SELECTION                                  }
{==========================================================================}

TYPE MD_SetRecordPtr = ^MD_SetRecord;

     MD_SetRecord = RECORD
                          SetType    : BYTE; {1=RFC; 2=FTN}
                          Name       : CharSetNameStr;
                          FoundCount : BYTE;
                          NextPtr    : MD_SetRecordPtr;
                    END;

VAR MD_IsMulti     : BOOLEAN; { if true, then is multi-part msg }
    MD_InContent   : BOOLEAN; { true in Content-Type / continuation header }
    MD_RFCCount    : BYTE;
    MD_FTNCount    : BYTE;
    MD_FirstSetPtr : MD_SetRecordPtr;

{--------------------------------------------------------------------------}
{ CharSet_MD_FoundCharSet                                                  }
{                                                                          }
{ This routine is called when an RFC character set has been found.         }
{                                                                          }
PROCEDURE CharSet_MD_FoundCharSet (SetType : BYTE; SetName : STRING);

VAR SetPtr : MD_SetRecordPtr;

BEGIN
     IF (SetName = '') THEN
        Exit;

     {LogMessage (liDebug,'Found charset: Type='+Byte2String (SetType)+', Name="'+SetName+'"');}

     { see if we know this set already }
     SetPtr:=MD_FirstSetPtr;

     WHILE (SetPtr <> NIL) DO
     BEGIN
          IF (SetPtr^.SetType = SetType) AND CaselessMatch (SetPtr^.Name,SetName) THEN
          BEGIN
               { found! }
               IF (SetPtr^.FoundCount < 255) THEN
                  Inc (SetPtr^.FoundCount);

               Exit; { ## EXIT ## }
          END;

          SetPtr:=SetPtr^.NextPtr;
     END; { while }

     { not found; add a new set }
     GetMem (SetPtr,SizeOf (MD_SetRecord));
     SetPtr^.SetType:=SetType;
     SetPtr^.Name:=SetName;
     SetPtr^.FoundCount:=1;
     SetPtr^.NextPtr:=MD_FirstSetPtr;

     MD_FirstSetPtr:=SetPtr;

     IF (SetType = 1) THEN
     BEGIN
          IF (MD_RFCCount < 255) THEN
             Inc (MD_RFCCount);
     END ELSE
         IF (MD_FTNCount < 255) THEN
            Inc (MD_FTNCount);
END;


{--------------------------------------------------------------------------}
{ CharSet_MD_CheckForMimeCharSetHeaders                                    }
{                                                                          }
{ This routine checks for MIME headers and records any character set       }
{ references.                                                              }
{                                                                          }
FUNCTION CharSet_MD_CheckForMimeCharSetHeaders (VAR OrigRegel : STRING) : BOOLEAN; FAR;

VAR P     : BYTE;
    Regel : STRING;

BEGIN
     { return FALSE (=continue to call this function) until we find an empty line }
     CharSet_MD_CheckForMimeCharsetHeaders:=(OrigRegel = '');

     Regel:=OrigRegel;

     { set MimeLineType to mlt_Other if this is not a continuation line }
     IF MD_InContent AND (NOT (OrigRegel[1] IN [' ',#9])) THEN
        MD_InContent:=FALSE;

     IF CaselessStartMatch (OrigRegel,'Content-Type: ') THEN
     BEGIN
          MD_InContent:=TRUE;
          Delete (Regel,1,14);
     END;

     IF (NOT MD_InContent) THEN
        Exit; { ## EXIT ## }

     Regel:=UpCaseString (Regel);

     IF (Pos ('MULTIPART',Regel) > 0) THEN
        MD_IsMulti:=TRUE;

     { check for a charset }
     P:=Pos ('CHARSET',Regel);
     IF (P > 1) AND (Regel[P-1] IN [' ',#9,';',',']) THEN
     BEGIN
          { alles tot en met de charset verwijderen }
          Delete (Regel,1,P+6);

          { andere variabelen strippen }
          P:=Pos (';',Regel);
          IF (P > 0) THEN
             Regel:=Copy (Regel,1,P-1);

          { spaties tot en met de = verwijderen }
          IF (Pos ('=',Regel) > 0) THEN
          BEGIN
               WHILE (Regel[1] <> '=') DO
                     Delete (Regel,1,1);

               { = zelf verwijderen }
               Delete (Regel,1,1);

               { nog meer spaties overslaan }
               WHILE (Regel[1] = ' ') DO
                     Delete (Regel,1,1);

               { CR aan het einde verwijderen }
               P:=Length (Regel);
               IF (Regel[P] = #13) THEN
                  Delete (Regel,P,1);

               { kijk of er aanhalingstekens omheen staan }
               IF (Regel[1] = '"') THEN
                  Delete (Regel,1,1);

               P:=Length (Regel);
               IF (Regel[P] = '"') THEN
                  Delete (Regel,P,1);

               { laadt de karakterset }
               CharSet_MD_FoundCharset (1{=RFC},Regel);
          END;
     END;
END;


{--------------------------------------------------------------------------}
{ CharSets_MakeDecision_RFC2FTN                                            }
{                                                                          }
{ These routines decides for a mail message or news article which FTN      }
{ character set to use when translating from RFC to FTN format. The FTN    }
{ side can only have one character set, although a multi-part MIME message }
{ can dicate more than one (source) character set for the body.            }
{ There are a few other limitation: if a message is cross-posted (news) to }
{ more than one area, then only one translation will be made to only one   }
{ FTN character set. In this case we take the one most often mentioned.    }
{                                                                          }
{ Following are the rules:                                                 }
{ - Non-MIME message:  initially no source set.                            }
{ - MIME, single-part: scan main headers for source set indication.        }
{ - MIME, multi-part:  scan main headers and headers for each body part    }
{                      find the most often used source character set.      }
{ - For news, scan all areas definitions for source and destination        }
{   character sets to use. Take the most often mentioned set.              }
{   If source set was unknown, take this source set.                       }
{ - If no set is found, take MIME-IN and FTN-OUT sets from CHARSETS.TDB.   }
{                                                                          }
{ The decided character sets are loaded and the FTN set name is returned   }
{ so it can be put in a CHRS kludge.                                       }
{                                                                          }
FUNCTION CharSets_MakeDecision_RFC2FTN (IsNews : BOOLEAN;
                                        VAR InSetNr : CharSetNr;
                                        VAR OutSetNr : CharSetNr) : STRING;

VAR Lp      : WORD;
    AreaRec : AreaBaseRecord;
    DoRFC   : BOOLEAN;
    SetPtr  : MD_SetRecordPtr;
    HighPtr : MD_SetRecordPtr;

BEGIN
     { empty the source and destination character set lists }
     MD_RFCCount:=0;
     MD_FTNCount:=0;
     MD_FirstSetPtr:=NIL;

     { search for character set indication in the RFC message }
     IF Msg.IsMime THEN
     BEGIN
          MD_IsMulti:=FALSE;

          MD_InContent:=FALSE;
          MsgsForEach (Msg.HeaderTop_U,CharSet_MD_CheckForMimeCharSetHeaders);

          { if we found a multi-part indication, then check the headers }
          { for each part as well.                                      }
          IF MD_IsMulti THEN
          BEGIN
               { multi-part MIME message }
               FOR Lp:=1 TO MAX_BODY_PARTS DO
                   IF (Msg.BodyParts[Lp] <> NIL) THEN
                   BEGIN
                        MD_InContent:=FALSE;
                        MsgsForEach (Msg.BodyParts[Lp],CharSet_MD_CheckForMimeCharSetHeaders);
                   END;
          END;
     END;

     {LogMessage (liDebug,'Charsets found(1): '+Byte2String (MD_RFCCount)+' / '+Byte2String (MD_FTNCount));}

     { check all the area definitions in which the area will be posted }
     IF IsNews THEN
     BEGIN
          { only include the RFC sets when nothing is mentioned in the }
          { message! (avoids statistical competition).                 }
          DoRFC:=(MD_RFCCount = 0);

          FOR Lp:=1 TO MAX_AREA_CROSS_POSTS DO
              IF (Msg.AreaRecNrs[Lp] <> NILRecordNr) THEN
              BEGIN
                   ReadAreaBaseRecord (Msg.AreaRecNrs[Lp],AreaRec);
                   CharSet_MD_FoundCharSet (1{=RFC},AreaRec.CharSet_RFC);
                   CharSet_MD_FoundCharSet (2{=FTN},AreaRec.CharSet_FTN);
              END; { if,for }
     END;

     {LogMessage (liDebug,'Charsets found(2): '+Byte2String (MD_RFCCount)+' / '+Byte2String (MD_FTNCount));}

     { now decide which in set and out set to use; load the sets }
     { and return the FTN character set name.                    }

     {## at this moment, the MIME character sets are not used   }
     {## since MimeToFtn translation anyway works out which     }
     {## source set to use for each part.                       }

     {## in the future, check which one-to-one mappings we have }
     {## and take the decide for the most used FTN-out set      }

     { assume the default sets }
     InSetNr:=DefaultMimeInSetNr;
     OutSetNr:=DefaultFtnOutSetNr;

     IF (MD_RFCCount <> 0) THEN
     BEGIN
          { take one mentioned most often }
          HighPtr:=NIL;
          SetPtr:=MD_FirstSetPtr;

          WHILE (SetPtr <> NIL) DO
          BEGIN
               IF (SetPtr^.SetType = 1{=RFC}) THEN
               BEGIN
                    IF (HighPtr = NIL) THEN
                       HighPtr:=SetPtr
                    ELSE
                        { first found is last in chain so use >= to get that one }
                        IF (SetPtr^.FoundCount >= HighPtr^.FoundCount) THEN
                           HighPtr:=SetPtr;
               END;

               SetPtr:=SetPtr^.NextPtr;
          END; { while }

          IF (HighPtr <> NIL) THEN
          BEGIN
               {LogMessage (liDebug,'Winning RFC set: "'+HighPtr^.Name+'" ('+Byte2String (HighPtr^.FoundCount)+')');}

               { if we don't know the set, we get the default one }
               {## is that acceptable?}
               InSetNr:=CharSets_Load (HighPtr^.Name,stMime,FALSE{=in-set});
          END;
     END;

     IF (MD_FTNCount <> 0) THEN
     BEGIN
          { take one mentioned most often }
          HighPtr:=NIL;
          SetPtr:=MD_FirstSetPtr;

          WHILE (SetPtr <> NIL) DO
          BEGIN
               IF (SetPtr^.SetType = 2{=FTN}) THEN
               BEGIN
                    IF (HighPtr = NIL) THEN
                       HighPtr:=SetPtr
                    ELSE
                        { first found is last in chain so use >= to get that one }
                        IF (SetPtr^.FoundCount > HighPtr^.FoundCount) THEN
                           HighPtr:=SetPtr;
               END;

               SetPtr:=SetPtr^.NextPtr;
          END; { while }

          IF (HighPtr <> NIL) THEN
          BEGIN
               {LogMessage (liDebug,'Winning FTN set: "'+HighPtr^.Name+'" ('+Byte2String (HighPtr^.FoundCount)+')');}

               { if we don't know the set, we get the default one }
               {## is that acceptable?}
               InSetNr:=CharSets_Load (HighPtr^.Name,stFTN,TRUE{=out-set});
          END;
     END;

     CharSets_MakeDecision_RFC2FTN:=CharSetPtrs[DefaultFtnOutSetNr]^.SetName;

     { remove all the allocated MD_SetRecords }
     WHILE (MD_FirstSetPtr <> NIL) DO
     BEGIN
          SetPtr:=MD_FirstSetPtr;
          MD_FirstSetPtr:=SetPtr^.NextPtr;
          FreeMem (SetPtr,SizeOf (MD_SetRecord));
     END;
END;


{--------------------------------------------------------------------------}
{ Unit Initialization                                                      }
{                                                                          }
BEGIN
     CharSetCount:=0;

     DefaultFtnInSetNr:=0;
     DefaultFtnOutSetNr:=0;
     DefaultMimeInSetNr:=0;
     DefaultMimeOutSetNr:=0;
END.
