{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT ReadRout;

{$i platform.inc}

{ deze file bevat de code die de routing table inleest. Aangezien dit }
{ alleen aan het begin van wtrgate.exe nodig is, gaat deze code in de }
{ overlay en wordt ie maar e'e'n keer aangeroepen.                    }

INTERFACE

USES Ramon,
     {$IFDEF WtrUtil}
     DList,
     {$ENDIF}
     Database;


PROCEDURE InitRoutingTable;
PROCEDURE JunkRoutingTable;


TYPE RouteRecordPtr = ^RouteRecord;
     RouteRecord    = RECORD
{ 1 = 2:All 2 = 2:280/All } Level              : BYTE;
{ adres masker }            MaskFidoAddr,
{ via adres }               ViaFidoAddr        : FidoAddrType;
                            NextRouteRecordPtr : RouteRecordPtr;
                      END;


     MapValidType   = (UUCP_Map_Both,UUCP_Map_FU,UUCP_Map_UF);
     MapRecordPtr   = ^MapRecord;
     MapNameField   = STRING[60];

     MapRecord = RECORD
                       LType,
                       RType       : BYTE;
                       MapType     : MapValidType;
                       LFidoAddr,
                       RFidoAddr   : FidoAddrType;
                       LName,
                       RName       : MapNameField;
                 END;

     SignatureRecord = RECORD
                             Level    : BYTE;        { 255 = e-mail address }
                             Address  : FidoAddrType;
                             UserName : STRING[80];  { now user@adress or User Name }
                             Path     : STRING[79];
                       END;
     SignaturePtr    = ^SignatureRecord;

     FilterOptionType = (foEXACT,foPLUSBELOW,foBELOWONLY);

     FilterPtr    = ^FilterRecord;
     FilterRecord = RECORD
                          NamePtr : StringPtr;
                          Allow   : BOOLEAN; { FALSE = Exclude }
                          Option  : FilterOptionType;
                          LineNr  : WORD;
                          PathPtr : StringPtr;
                    END;

     SendFilePtr    = ^SendFileRecord;
     SendFileRecord = RECORD
                            Username  : STRING[MaxLenUserName];
                            FilePath  : STRING[80];
                            ForceText : BOOLEAN;
                      END;

     BouncePtr    = ^BounceRecord;
     BounceRecord = RECORD
                          EmailAddress : STRING[60];
                          Reason       : STRING[80];
                          FromBounce   : BOOLEAN;
                          WildMatch    : BOOLEAN; { * aan begin? }
                    END;

     (*
     MapAreaPtr    = ^MapAreaRecord;
     MapAreaRecord = RECORD
                           EMailAddress : STRING[60];
                           AreaIndex    : LONGINT;
                           ReplyAddr    : STRING[60];
                     END;
     *)

     MailTunnelIOType = (mtFrom,mtTo);
     MailTunnelPtr    = ^MailTunnelRecord;
     MailTunnelRecord = RECORD
                              FromOrTo     : MailTunnelIOType;
                              FidoAddress  : FidoAddrType;
                              EMailAddress : STRING[60];
                              ArchiveName  : STRING[8];
                              MinimumSize  : BYTE; { 0..255 kb }
                              ExtractPath  : FilePathStr;
                              Seat         : BOOLEAN;
                        END;

     ForcePackPtr    = ^ForcePackRecord;
     ForcePackRecord = RECORD
                             FidoAddr : FidoAddrType;
                       END;

     NotLocalPtr    = ^NotLocalRecord;
     NotLocalRecord = RECORD
                            Domain : STRING[60];
                      END;

     MimeAttachPtr    = ^MimeAttachRecord;
     MimeAttachRecord = RECORD
                              MimeType : STRING[80];
                        END;

     {$IFDEF WtrUtil}
     NodeListRecord = RECORD
                            Path : STRING;
                      END;
     {$ENDIF}

{$IFDEF WtrUtil}
VAR NodeListsList   : List;
{$ENDIF}

IMPLEMENTATION

USES Dos,
     Fido,
     UserBase,
     UUCPRout,
     Routing,
     Logs,
     Globals,
     Cfg,
     Gateway,
     Outbound;

CONST NotRegMaxLimit = 'statements when not registered!';

VAR MemSignatures,
    MemRouting,
    MemMapping,
    MemSendfile,
    MemFilter,
    MemTunnel       : LONGINT;


{--------------------------------------------------------------------------}
{ SubStractMapField                                                        }
{                                                                          }
FUNCTION SubStractMapField (VAR Inf : STRING) : STRING;

VAR P : BYTE;

BEGIN
     Inf:=DeleteFrontSpaces (DeleteBackSpaces (Inf));

     { Zoek naar de volgende string: }
     {                               }
     { domainadres                   }
     { user@domainadres              }
     { "user"                        }
     { "user"@fidoadres              }

     { Zoek naar de '"' }
     P:=1;
     IF (Inf[1] = '"') THEN
     BEGIN
          P:=2;

          WHILE (P <= Length (Inf)) AND (Inf[P] <> '"') DO
                Inc (P);

          IF (P = Length (Inf)) AND (Inf[P] <> '"') THEN   {invalid?}
          BEGIN
               Inf:=''; {invalid!}
               Exit;
          END;
     END;

     { Zoek naar een spatie of het einde van de string }
     WHILE (P <= Length (Inf)) AND (Inf[P] <> ' ') DO
           Inc (P);

     SubStractMapField:=DeleteBackSpaces (Copy (Inf,1,P));
     { Inf := Copy( Inf , P + 1 , 255 ); }
END;


{--------------------------------------------------------------------------}
{ ParseMapLine                                                             }
{                                                                          }
{ Een veld kan de volgende formaten hebben :                               }
{                                                                          }
{  1 - "UserName"           2 - domainadres       3 - user@domainadres     }
{    - "UserName"%FidoAddr                                                 }
{    - FidoAddr (contains ':' or '/' ?)                                    }
{                                                                          }
PROCEDURE ParseMapLine (OrgInf : STRING; VAR Tiepe : BYTE; VAR Name : MapNameField; VAR Adres : FidoAddrType);

VAR X   : BYTE;
    Inf : STRING;

BEGIN
     Name:='';
     Inf:=DeleteBackSpaces (OrgInf);
     FidoSplit ('0',Adres);

     { Kijk of we " " tegenkomen }
     IF (Inf[1] = '"') THEN
     BEGIN
          Tiepe:=1;
          X:=Pos ('"',Copy (Inf,2,42));
          IF (X = 0) THEN
          BEGIN
               LogMessage (liConfig,'Invalid name in following MAP line:');
               LogExtraMessage (OrgInf);
               Exit;
          END;

          Name:=Copy (Inf,2,X-1);
          X:=Pos ('%',Inf);
          IF (X > 0) THEN
          BEGIN
               FidoSplit (Copy (Inf,X+1,255),Adres);
               IF (Adres.Zone = 0) THEN
               BEGIN
                    LogMessage (liConfig,'Invalid Fido adres in following MAP line:');
                    LogExtraMessage (OrgInf);
               END;
          END;

          Exit;
     END;

     IF (Pos ('/',Inf) > 0) THEN                { z:n/n.p ? }
     BEGIN
          FidoSplit (Inf,Adres);
          Tiepe:=1;
     END ELSE
     BEGIN
          Name:=Inf;
          IF (Pos ('@',Inf) > 0) THEN           { jaap@aap ? }
             Tiepe:=3
          ELSE
              Tiepe:=2;                         { aap.wlink? }
     END;
END;


{--------------------------------------------------------------------------}
{ CleanMapRecord                                                           }
{                                                                          }
PROCEDURE CleanMapRecord (MapPtr : MapRecordPtr);
BEGIN
     WITH MapPtr^ DO
     BEGIN
          LType:=0;
          RType:=0;
          FidoSplit ('0',LFidoAddr);
          FidoSplit ('0',RFidoAddr);
          LName:='';
          RName:='';
     END;
END;


{--------------------------------------------------------------------------}
{ AddMapFidoLine                                                           }
{                                                                          }
{ Voegt een lijn met een fidoadres toe aan het geheel.                     }
{                                                                          }
PROCEDURE AddMapFidoLine (OrgLine : STRING);

VAR Zoek,
    Tmp      : MapRecordPtr;
    FidoAddr : FidoAddrType;
    TmpLine  : STRING;
    Line     : STRING;

LABEL ClearUp,
      ClearUp2;

BEGIN
     Line:=OrgLine;

     GetMem (Tmp,SizeOf (MapRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (MapRecord),'GetMem MapRecord (fido)'); {$ENDIF}

     CleanMapRecord (Tmp);

     TmpLine:=SubStractMapField (Line);

     IF (Line = '') THEN
        GOTO ClearUp;

     ParseMapLine (TmpLine,Tmp^.LType,Tmp^.LName,Tmp^.LFidoAddr);
     Tmp^.MapType:=UUCP_Map_Both;
     Delete (Line,1,Length (Tmpline));

     IF (Tmp^.LType <> 1) THEN
        GOTO ClearUp;

     TmpLine:=SubStractMapField (Line);

     IF (TmpLine = '') THEN
        GOTO ClearUp;

     ParseMapLine (TmpLine,Tmp^.RType,Tmp^.RName,Tmp^.RFidoAddr);

     IF (Tmp^.LType = 2) THEN
        GOTO ClearUp;

     { kijk of deze al bestaat }
     Zoek:=FidoMappingList.GetFirstItem;
     WHILE (Zoek <> NIL) DO
     BEGIN
          IF (Tmp^.MapType = Zoek^.MapType) AND
             (Tmp^.LType   = Zoek^.LType) AND
             (Tmp^.LName   = Zoek^.LName) AND
             (Tmp^.RType   = Zoek^.RType) AND
             (Tmp^.RName   = Zoek^.RName) AND
             FidoCompare (Tmp^.LFidoAddr,Zoek^.LFidoAddr) AND
             FidoCompare (Tmp^.RFidoAddr,Zoek^.RFidoAddr) THEN
          BEGIN
               LogMessage (liConfig,'Following MAP-FIDO line is a duplicate:');
               GOTO ClearUp2;
          END;

          Zoek:=FidoMappingList.GetNextItem;
     END;

     FidoMappingList.Add (Tmp);
     Inc (MemMapping,SizeOf (MapRecord)+4);
     Exit;

ClearUp:
     LogMessage (liConfig,'Following MAP-FIDO line is invalid:');

ClearUp2:
     LogExtraMessage (OrgLine);

     FreeMem (Tmp,SizeOf (MapRecord));
END;


{--------------------------------------------------------------------------}
{ AddMapUUCPLine                                                           }
{                                                                          }
{ Voegt een lijn met een fidoadres toe aan het geheel.                     }
{                                                                          }
PROCEDURE AddMapUUCPLine (OrgLine : STRING);

VAR Zoek,
    Tmp      : MapRecordPtr;
    FidoAddr : FidoAddrType;
    TmpLine  : STRING;
    Line     : STRING;

LABEL ClearUp,
      ClearUp2;

BEGIN
     Line:=OrgLine;

     GetMem (Tmp,SizeOf (MapRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (MapRecord),'GetMem MapRecord (uucp)'); {$ENDIF}

     CleanMapRecord (Tmp);

     TmpLine:=SubStractMapField (Line);

     IF (Line = '') THEN
        GOTO ClearUp;

     { Kijk of er aan het begin van de lijn mapping restricties staan }
     {                                                                }
     { -FU   dit commando geld alleen voor Fido -> Usenet mappings    }
     { -UF   dit commando geld alleen voor Usenet -> Fido mappings    }
     Tmp^.MapType:=UUCP_Map_Both;

     IF (UpCaseString (Copy (TmpLine,1,3)) = '-FU') THEN
     BEGIN
          Delete (Line,1,3);
          Tmp^.MapType:=UUCP_Map_FU;
     END;

     IF (UpCaseString (Copy (TmpLine,1,3)) = '-UF') THEN
     BEGIN
          Delete (Line,1,3);
          Tmp^.MapType:=UUCP_Map_UF;
     END;

     TmpLine:=SubStractMapField (Line);

     { Verwerk de regel door beide velden uit de regel te halen }
     {                                                          }
     { Verwerk de linkerkant van de regel                       }

     ParseMapLine (TmpLine,Tmp^.LType,Tmp^.LName,Tmp^.LFidoAddr);

     Delete (Line,1,Length (TmpLine));        { Haal eerste deel weg }
     TmpLine:=SubStractMapField (Line);       { Pak het tweede deel  }

     IF (TmpLine = '') THEN
        GOTO ClearUp;

     { verwerk de rechterkant van de regel }
     ParseMapLine (TmpLine,Tmp^.RType,Tmp^.RName,Tmp^.RFidoAddr);

     { kijk of deze al bestaat }
     Zoek:=UUCPMappingList.GetFirstItem;
     WHILE (Zoek <> NIL) DO
     BEGIN
          IF (Tmp^.MapType = Zoek^.MapType) AND
             (Tmp^.LType   = Zoek^.LType) AND
             (Tmp^.LName   = Zoek^.LName) AND
             (Tmp^.RType   = Zoek^.RType) AND
             (Tmp^.RName   = Zoek^.RName) AND
             FidoCompare (Tmp^.LFidoAddr,Zoek^.LFidoAddr) AND
             FidoCompare (Tmp^.RFidoAddr,Zoek^.RFidoAddr) THEN
          BEGIN
               LogMessage (liConfig,'Following MAP-UUCP line is a duplicate:');
               GOTO ClearUp2;
          END;

          Zoek:=UUCPMappingList.GetNextItem;
     END;

     { voeg de regel toe aan de lijst in het geheugen }

     { RWI 951117: added check for the key }
     {$IFNDEF WtrTest}
     {$IFNDEF NOKEYS}
     IF (regKeyNumber < $FFFE) OR (UUCPMappingList.ItemCount < 5) THEN
     {$ENDIF}
     {$ENDIF}
     BEGIN
          Inc (MemMapping,SizeOf (MapRecord)+4);
          UUCPMappingList.Add (Tmp);
          Exit;
     END;

     LogMessage (liConfig,'Max 5 MAP-UUCP '+NotRegMaxLimit);
     GOTO ClearUp2;

ClearUp:
     LogMessage (liConfig,'Following MAP-UUCP line is invalid:');

ClearUp2:
     LogExtraMessage (OrgLine);

     FreeMem (Tmp,SizeOf (MapRecord));
END;


(*
{--------------------------------------------------------------------------}
{ AddMapAreaLine                                                           }
{                                                                          }
PROCEDURE AddMapAreaLine (Line : STRING);

VAR Tmp  : MapAreaPtr;
    Area : STRING;

BEGIN
     IF (Pos (' ',Line) = 0) THEN
     BEGIN
          LogMessage ('Following MAP-AREA line is invalid:');
          LogExtraMessage (Line);
          Exit; { RWI 960304 }
     END;

     GetMem (Tmp,SizeOf (MapAreaRecord));

     Tmp^.EMailAddress:=UpCaseString (Copy (Line,1,Pos (' ',Line)-1));
     Delete (Line,1,Pos (' ',Line));
     Line:=DeleteFrontSpaces (Line);

     Line:=Line+' ';
     Tmp^.AreaIndex:=GetAreaNameIndexValue (Copy (Line,1,Pos (' ',Line)-1));
     Delete (Line,1,Pos (' ',Line));
     Line:=DeleteFrontSpaces (Line);

     IF (Pos (' ',Line) > 0) THEN
        Line:=Copy (Line,1,Pos (' ',Line)-1);
     Tmp^.ReplyAddr:=Line;

     Inc (MemMapping,SizeOf (MapAreaRecord)+4);
     MapAreaList.Add (Tmp);
END;
*)

{--------------------------------------------------------------------------}
{ GetNextFtnAddrPart                                                       }
{                                                                          }
{ RWI961230: point deel wordt nu geinterpreteerd en Val() resultaat        }
{ gecontroleerd.                                                           }
{                                                                          }
{ RAWI 980522: now adding parts from "base" address, which is updated at   }
{              the same time. This is used for routing statements like     }
{              ROUTE-FIDO 2:200/111 2:200/100 200/* 300/* 400/10 11 12     }
{                                                                          }
{ Legale mogelijkheden                                                     }
{                                                                          }
{ Text                  FAdr       Return code    Zeker                    }
{ *                     Error      0              Ja                       }
{ z:                    z:0/0.0    1                                       }
{ z:*                   z:0/0.0    1                                       }
{ z:                    z:0/0.0    1                                       }
{ z:n                   z:n/0.0    2                                       }
{ z:n/                  z:n/0.0    2                                       }
{ z:/                   z:0/0.0    2                                       }
{ z:n/*                 z:n/0.0    2                                       }
{ z:n/f                 z:n/f.0    3                                       }
{ z:n/f.                z:n/f.0    3                                       }
{ z:n/f.*               z:n/f.0    3                                       }
{ z:n/f.p               z:n/f.p    4                                       }
{ n/*                   Z:n/0.0    2                                       }
{ f                     Z:N/f.0    3                                       }
{ *.*                   0:0/0.0    2                                       }
{ Z:*/*                 Z:0/0.0    1                                       }
{                                                                          }
{ Interpretation logic:                                                    }
{  ":" missing -> no zone                                                  }
{  "/" missing -> no net                                                   }
{  "." missing -> no point                                                 }
{  Domain not supported!                                                   }
{                                                                          }
FUNCTION GetNextFtnAddrPart (VAR Invoer : STRING; VAR FAdr : FidoAddrType) : INTEGER;

CONST ERR_IN_ADDR = 'Error in address: ';

VAR OrigAdres,
    Adres     : STRING;
    PZ,
    PN,
    PF,
    PP        : BYTE;
    ZStr,
    NStr,
    FStr,
    PStr      : STRING[30];
    Nop       : ValNop;

BEGIN
     GetNextFtnAddrPart:=0;     { assume error }

     Invoer:=DeleteFrontSpaces (Invoer);

     IF (Pos (' ',Invoer) > 0) THEN
     BEGIN
          Adres:=Copy (Invoer,1,Pos (' ',Invoer)-1);
          Invoer:=DeleteFrontSpaces (Copy (Invoer,Pos (' ',Invoer),Length (Invoer)));
     END ELSE
     BEGIN
          Adres:=Invoer;
          Invoer:='';
     END;

     IF (Adres = '') THEN
        Exit;            { ## EXIT ## }

     IF (Adres = '*') THEN
     BEGIN
          LogMessage (liConfig,ERR_IN_ADDR+' *');
          Exit;          { ## EXIT ## }
     END;

     { check which parts are present and extract these }
     PZ:=Pos (':',Adres);
     PN:=Pos ('/',Adres);
     PP:=Pos ('.',Adres);

     { make sure ":" is before "/" and "." }
     { make sure "/" is before "." }
     IF ((PZ > PN) AND (PN > 0)) OR
        ((PZ > PP) AND (PP > 0)) OR
        ((PN > PP) AND (PP > 0)) THEN
     BEGIN
          LogMessage (liConfig,ERR_IN_ADDR+Adres);
          Exit;           { ## EXIT ## }
     END;

     { extract the parts }

     OrigAdres:=Adres;

     ZStr:='';
     NStr:='';
     FStr:='';
     PStr:='';

     IF (PZ > 0) THEN
     BEGIN
          ZStr:=Copy (Adres,1,PZ-1);
          Delete (Adres,1,PZ);
     END;

     { re-calc point part position }
     PP:=Pos ('.',Adres);
     IF (PP > 0) THEN
     BEGIN
          PStr:=Copy (Adres,PP+1,255);
          Adres:=Copy (Adres,1,PP-1);
     END;

     { re-calc net part position }
     PN:=Pos ('/',Adres);
     IF (PN > 0) THEN
     BEGIN
          NStr:=Copy (Adres,1,PN-1);
          Delete (Adres,1,PN);
     END;

     { rest is node part }
     FStr:=Adres;

     {$IFDEF LogRouteFido}
     LogExtraMessage ('"'+OrigAdres+'" -> Z="'+ZStr+'", N="'+NStr+'", F="'+FStr+'", P="'+PStr+'"');
     {$ENDIF}

     { if there is an "*", it has to be the only thing in that part }
     IF (Pos ('*',ZStr) > 0) OR
        ((Pos ('*',NStr) > 0) AND (NStr <> '*')) OR
        ((Pos ('*',FStr) > 0) AND (FStr <> '*')) OR
        ((Pos ('*',PStr) > 0) AND (PStr <> '*')) THEN
     BEGIN
          LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
          Exit;              { ## EXIT ## }
     END;

     { only the last argument can be the "*" }
     PZ:=Pos ('*',ZStr);
     PN:=Pos ('*',NStr);
     PF:=Pos ('*',FStr);
     PP:=Pos ('*',PStr);

     IF ((PZ=1) AND (PN+PF+PP <> 0)) OR
        ((PN=1) AND (PF+PP <> 0)) OR
        ((PF=1) AND (PP=1)) THEN
     BEGIN
          LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
          Exit;      { ## EXIT ## }
     END;

     { "*" doesn't mean anything (equal to empty) }

     IF (NStr = '*') THEN NStr:='';
     IF (FStr = '*') THEN FStr:='';
     IF (PStr = '*') THEN PStr:='';

     { convert all the strings to numbers and }
     { decide how many levels must be checked }

     IF (ZStr <> '') THEN
     BEGIN
          Val (ZStr,FAdr.Zone,Nop);
          IF (Nop <> 0) THEN
          BEGIN
               LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
               Exit;
          END;

          GetNextFtnAddrPart:=1;
     END;

     IF (NStr <> '') THEN
     BEGIN
          Val (NStr,FAdr.Net,Nop);
          IF (Nop <> 0) THEN
          BEGIN
               LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
               GetNextFtnAddrPart:=0;
               Exit;
          END;

          GetNextFtnAddrPart:=2;
     END;

     IF (FStr <> '') THEN
     BEGIN
          Val (FStr,FAdr.Node,Nop);
          IF (Nop <> 0) THEN
          BEGIN
               LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
               GetNextFtnAddrPart:=0;
               Exit;
          END;

          GetNextFtnAddrPart:=3;
     END;

     IF (PStr <> '') THEN
     BEGIN
          Val (PStr,FAdr.Point,Nop);
          IF (Nop <> 0) THEN
          BEGIN
               LogMessage (liConfig,ERR_IN_ADDR+OrigAdres);
               GetNextFtnAddrPart:=0;
               Exit;
          END;

          GetNextFtnAddrPart:=4;
     END;


(*
     GetNextFtnAddrPart:=4;

     { is there a ":"? }
     Z:=Pos (':',Adres);
     IF (Z > 0) THEN
        { yes, extract the zone part (2:??? etc) }
        Val (Copy (Adres,1,Z-1),FAdr.Zone,Error);

     { 0+1 = 1 -> "*" of "zzz:*" is dus alle mogelijke adressen }
     { zone dus altijd gebruikt want kan geen 0 terug geven!    }
     IF (Adres[Z+1] = '*') THEN
     BEGIN
          { "zzz:*" or "*" }
          GetNextFtnAddrPart:=1;
          Exit;
     END;

     { kijk of er een net deel is }
     N:=Pos ('/',Adres);
     IF (N > 0) THEN
        { "2:3/" of "3/" }
        Val (Copy (Adres,Z+1,N-(Z+1)),FAdr.Net,Error)
     ELSE
         { 2:3 }
         Val (Copy (Adres,Z+1,Length (Adres)),FAdr.Net,Error);
         { niet meteen fout! Kan ook een * zijn }

     { ???/* }
     IF (Adres[N+1] = '*') THEN
     BEGIN
          GetNextFtnAddrPart:=2;
          Exit;
     END;

     { kijk of er een point deel is }
     Z:=Pos ('.',Adres);
     IF (Z > 0) THEN
        { "???/n.???" }
        Val (Copy (Adres,N+1,Z-(N+1)),FAdr.Node,Error)
     ELSE
         { "???/n" }
         Val (Copy (Adres,N+1,Length (Adres)),FAdr.Node,Error);

     { ???/n.*, triggered niet als er geen "." was, dus Z=0 }
     IF (Adres[Z+1] = '*') THEN
     BEGIN
          GetNextFtnAddrPart:=3;
          Exit;
     END;

     { RWI961230: interpreteer point deel }
     Val (Copy (Adres,Z+1,255),FAdr.Point,Error);
*)
END;


{--------------------------------------------------------------------------}
{ AddSignatureToList                                                       }
{                                                                          }
{ Voegt een Signature toe aan de lijst in het geheugen, een signature is   }
{ hier een verwijzing naar een disk bestandje dat toegevoegt wordt aan     }
{ een fido user als deze een bericht Fido->Usenet stuurt.                  }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ SIGNATURE <filepath> <(partitial) address> [<UserName>]                  }
{ SIGNATURE <filepath> <e-mail address or domain>                          }
{                                                                          }
PROCEDURE AddSignatureToList (OrgRegel : STRING);

VAR Tmp   : SignaturePtr;
    Regel : STRING;

LABEL BadSig;

BEGIN
     Regel:=OrgRegel;

     GetMem (Tmp,SizeOf (SignatureRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (SignatureRecord),'GetMem SignatureRecord'); {$ENDIF}

     CleanTabs (Regel,1);

     IF (Pos (' ',Regel) = 0) THEN
        GOTO BadSig;

     Tmp^.Path:=Copy (Regel,1,Pos (' ',Regel)-1);
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     IF (NOT TestIfExist (Tmp^.Path)) THEN
     BEGIN
          LogMessage (liFatal,'Cannot open signature file '+Tmp^.Path);
          FreeMem (Tmp,SizeOf (SignatureRecord));
          Exit;
     END;

     IF (NOT (Regel[1] IN ['0'..'9','*'])) THEN
     BEGIN
          { assume e-mail address / domain }
          Tmp^.Level:=255;
          Tmp^.UserName:=UpCaseString (Regel);
          Tmp^.Address:=NullAdres;
     END ELSE
     BEGIN
          { fido style adres + optional user name }
          IF (Regel[1] = '*') THEN
          BEGIN
               Tmp^.Level:=0;
               Delete (Regel,1,1);

               IF (Regel[1] <> ' ') THEN
                  GOTO BadSig;
          END ELSE
          BEGIN
               Tmp^.Address:=NullAdres;
               Tmp^.Level:=GetNextFtnAddrPart (Regel,Tmp^.Address);
          END;

          Tmp^.UserName:=UpCaseString (DeleteFrontAndBackSpaces (Regel));
     END;

     Inc (MemSignatures,SizeOf (SignatureRecord)+4);

     SignatureList.Add (Tmp);
     Exit;

BadSig:

     LogMessage (liConfig,'Invalid SIGNATURE line format in following line:');
     LogExtraMessage (OrgRegel);
     FreeMem (Tmp,SizeOf (SignatureRecord));
END;


(*
{--------------------------------------------------------------------------}
{ AddSaveFileToList                                                        }
{                                                                          }
{ SAVE <address> <directory>                                               }
{                                                                          }
PROCEDURE AddSaveFileToList (SaveFrom : BOOLEAN; Regel : STRING);

VAR Tmp    : SaveFilePtr;
    Search : SearchRec;

BEGIN
     GetMem (Tmp,SizeOf (SaveFileRecord));

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.SaveFrom:=SaveFrom;
     Tmp^.EmailAddress:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.Directory:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     IF (Tmp^.Directory[Length (Tmp^.Directory)] <> '\') THEN
        Tmp^.Directory:=Tmp^.Directory+'\';

     { controleer of het pad bestaat }
     FindFirst (Tmp^.Directory+'*.*',$3F,Search);
     IF (NOT (DosError IN [0,18])) THEN
     BEGIN
          LogDiskIOError (DosError,'Cannot access SAVE directory '+Tmp^.Directory);
          FreeMem (Tmp,SizeOf (SaveFileRecord));
          FindClose (Search);
          Exit;
     END;

     FindClose (Search);

     SaveFileList.Add (Tmp);
END;
*)


{--------------------------------------------------------------------------}
{ AddSendFileToList                                                        }
{                                                                          }
{ SENDFILE <address> <filename path>                                       }
{                                                                          }
PROCEDURE AddSendFileToList (Regel : STRING; ForceText : BOOLEAN);

VAR Tmp : SendFilePtr;

BEGIN
     GetMem (Tmp,SizeOf (SendFileRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (SendFileRecord),'GetMem SendFileRecord'); {$ENDIF}

     Tmp^.ForceText:=ForceText;

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.UserName:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.FilePath:=Copy (Regel,1,Pos (' ',Regel)-1);

     { controleer of de file aanwezig is }
     IF (NOT TestIfExist (Tmp^.FilePath)) THEN
     BEGIN
          LogMessage (liFatal,'Cannot access SENDFILE: '+Tmp^.FilePath);
          FreeMem (Tmp,SizeOf (SendFileRecord));
          Exit;
     END;

     Inc (MemSendfile,SizeOf (SendFileRecord)+4);
     SendFileList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddBounceToList                                                          }
{                                                                          }
{ BOUNCE <address>                                                         }
{                                                                          }
PROCEDURE AddBounceToList (FromBounce : BOOLEAN; OrgRegel : STRING);

VAR Tmp   : BouncePtr;
    Regel : STRING;

BEGIN
     Regel:=OrgRegel;

     GetMem (Tmp,SizeOf (BounceRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (BounceRecord),'GetMem BounceRecord'); {$ENDIF}

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.EmailAddress:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Tmp^.WildMatch:=FALSE;

     IF (Tmp^.EMailAddress[1] = '*') THEN
     BEGIN
          Tmp^.WildMatch:=TRUE;
          Delete (Tmp^.EMailAddress,1,1);
     END;

     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.Reason:='Ask system administrator for reason';
     Tmp^.FromBounce:=FromBounce;

     IF (Regel[1] <> '"') THEN
     BEGIN
          LogMessage (liConfig,'Missing " at start of bounce reason in the following line:');
          LogExtraMessage (OrgRegel);
     END ELSE
     BEGIN
          Delete (Regel,1,1);
          IF (Pos ('"',Regel) = 0) THEN
          BEGIN
               LogMessage (liConfig,'Missing " at end of bounce reason in the following line:');
               LogExtraMessage (OrgRegel);
          END ELSE
              Tmp^.Reason:=Copy (Regel,1,Pos ('"',Regel)-1);
     END;

     BounceList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddFilterToList                                                          }
{                                                                          }
{ Deze routine voegt een filter toe aan de filter lijst. Alles wordt       }
{ omgezet in hoofdletters.                                                 }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ [!]<partitial newsgroup name>["." | ".*"]                                }
{                                                                          }
PROCEDURE AddFilterToList (Filter,Path : STRING; LineNr : WORD);

VAR Tmp  : FilterPtr;

BEGIN
     GetMem (Tmp,SizeOf (FilterRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (FilterRecord),'GetMem FilterRecord'); {$ENDIF}

     Tmp^.LineNr:=LineNr;

     { controleer op het uitroepteken aan het begin van de filter }
     Tmp^.Allow:=(Filter[1] <> '!');
     IF (NOT Tmp^.Allow) THEN
        Delete (Filter,1,1);

     { als er niets achter de naam staat, dan geldt alles plus eronder }
     Tmp^.Option:=foPLUSBELOW;

     { maar.. als er een punt achter staat, dan geldt alleen deze naam }
     IF (Filter[Length (Filter)] = '.') THEN
     BEGIN
          Delete (Filter,Length (Filter),1);
          Tmp^.Option:=foEXACT;
     END ELSE
         { RWI 950827: added check for '*' }
         IF (Filter = '*') THEN
         BEGIN
              Filter:='';
              Tmp^.Option:=foBELOWONLY; { no empty names }
         END ELSE
             { als de laatste twee tekens een punt en een astriks zijn, }
             { dan geldt alles hieronder, maar niet deze naam zelf.     }
             IF (Copy (Filter,Length (Filter)-1,2) = '.*') THEN
             BEGIN
                  Delete (Filter,Length (Filter)-1,2);
                  Tmp^.Option:=foBELOWONLY;
             END;

     { nu is de naam schoongemaakt }

     { geheugen aanvragen voor de Name }
     GetMem (Tmp^.NamePtr,Length (Filter)+1);
     {$IFDEF LogGetMem} LogGetMem (Tmp^.NamePtr,Length (Filter)+1,'GetMem Filter Name'); {$ENDIF}

     Tmp^.NamePtr^:=UpCaseString (Filter);

     { geheugen aanvragen voor de path }
     IF (Path = '') THEN
        Tmp^.PathPtr:=NIL
     ELSE BEGIN
          GetMem (Tmp^.PathPtr,Length (Path)+1);
          {$IFDEF LogGetMem} LogGetMem (Tmp^.PathPtr,Length (Path)+1,'GetMem Filter Path'); {$ENDIF}
          Tmp^.PathPtr^:=UpCaseString (Path);
     END;

     Inc (MemFilter,SizeOf (FilterRecord)+4+Length (Path)+1+Length (Filter)+1);
     FilterList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ ProcessFilterFile                                                        }
{                                                                          }
{ Deze routine leest de filter file van disk en verwerkt alle regels die   }
{ zich daarin bevinden.                                                    }
{                                                                          }
PROCEDURE ProcessFilterFile (Filename : STRING);

VAR FilterFile : TEXT;
    IORes      : BYTE;
    Filter,
    Regel      : STRING;
    LineNr     : WORD;

BEGIN
{$IFDEF WtrTest}
     Exit;
{$ENDIF}

     Assign (FilterFile,Filename);
     {$I-} Reset (FilterFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 2) THEN
             LogMessage (liFatal,'Cannot find filter file '+Filename)
          ELSE
              LogDiskIOError (IORes,'Cannot open filter file '+Filename);
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenT (FilterFile);{$ENDIF}

     LogMessage (liTrivial,'Reading new newsgroup names filter file '+Filename);

     LineNr:=0;
     WHILE (NOT Eof (FilterFile)) DO
     BEGIN
          ReadLn (FilterFile,Regel);
          Inc (LineNr);

          IF (Pos (';',Regel) > 0) THEN
             Regel:=Copy (Regel,1,Pos (';',Regel)-1);

          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          IF (Regel = '') THEN
             Continue;

          IF (Pos (' ',Regel) > 0) THEN
          BEGIN
               Filter:=Copy (Regel,1,Pos (' ',Regel)-1);
               Delete (Regel,1,Pos (' ',Regel));
               Regel:=DeleteFrontSpaces (Regel);
          END ELSE
          BEGIN
               Filter:=Regel;
               Regel:='';
          END;

          AddFilterToList (Filter,Regel,LineNr);

     END; { while }

     {$IFDEF LogFileIO}PreCloseT (FilterFile);{$ENDIF}
     Close (FilterFile);
END;


{--------------------------------------------------------------------------}
{ AddMailTunnel                                                            }
{                                                                          }
{ Deze routine interpreteert een mail tunnel entry en voegt deze toe.      }
{                                                                          }
PROCEDURE AddMailTunnel (IO : MailTunnelIOType; Seat : BOOLEAN; OrigRegel : STRING);

VAR Regel : STRING;
    Tmp   : MailTunnelPtr;
    P     : BYTE;
    MSize : LONGINT;
    Nop   : ValNop;

LABEL Abort;

BEGIN
     Regel:=OrigRegel;
     Delete (Regel,1,Pos (' ',Regel));
     Regel:=DeleteFrontAndBackSpaces (Regel);

     IF (Pos (' ',Regel) = 0) THEN
     BEGIN
          LogMessage (liConfig,'Error in '+OrigRegel);
          Exit;
     END;

     GetMem (Tmp,SizeOf (MailTunnelRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (MailTunnelRecord),'GetMem MailTunnelRecord'); {$ENDIF}

     Tmp^.FromOrTo:=IO;
     Tmp^.EmailAddress:=Copy (Regel,1,Pos (' ',Regel)-1);
     Tmp^.MinimumSize:=0;
     Tmp^.ArchiveName:='';
     Tmp^.ExtractPath:='';
     Tmp^.Seat:=Seat;

     Delete (Regel,1,Pos (' ',Regel));
     Regel:=DeleteFrontSpaces (Regel);

     IF (IO = mtTo) THEN
     BEGIN
          P:=Pos (' ',Regel);
          IF (P = 0) THEN
          BEGIN
               LogMessage (liConfig,'Error in '+OrigRegel);
               FreeMem (Tmp,SizeOf (MailTunnelRecord));
               Exit;
          END;

          { extract the fido address }
          FidoSplit (Copy (Regel,1,P-1),Tmp^.FidoAddress);
          Delete (Regel,1,P);
          Regel:=DeleteFrontSpaces (Regel);

          { extract the filename }
          P:=Pos (' ',Regel);
          IF (P > 9) OR ((P = 0) AND (Length (Regel) > 8)) THEN
          BEGIN
               LogMessage (liConfig,'Filename error in '+OrigRegel);
               GOTO Abort;
          END;

          IF (P > 0) THEN
          BEGIN
               { extract filename }
               Tmp^.ArchiveName:=Copy (Regel,1,P-1);
               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               { extract minimum size }
               Val (Regel,MSize,Nop);
               IF (Nop <> 0) THEN
               BEGIN
                    LogMessage (liConfig,'MinimumSize error in '+OrigRegel);
                    GOTO Abort;
               END;

               IF (MSize < 0) OR (MSize > 255) THEN
               BEGIN
                    LogMessage (liConfig,'MinimumSize range is 0 to 255 (Kb) in '+OrigRegel);
                    GOTO Abort;
               END;

               Tmp^.MinimumSize:=MSize;
          END ELSE
              { filename only }
              Tmp^.ArchiveName:=Regel;
     END ELSE
     BEGIN
          FidoSplit ('0:0/0',Tmp^.FidoAddress);
          Tmp^.ExtractPath:=CorrectPath (Regel);
     END;

     { RWI 951117: added check for the key }
     {$IFNDEF WtrTest}
     {$IFNDEF NOKEYS}
     IF (regKeyNumber < $FFFE) OR (MailTunnelList.ItemCount < 4) THEN
     {$ENDIF}
     {$ENDIF}
     BEGIN
          MailTunnelList.Add (Tmp);
          Inc (MemTunnel,SizeOf (MailTunnelRecord)+4);
          Exit;
     END;

     LogMessage (liConfig,'Max 4 TUNNEL-xxx '+NotRegMaxLimit);
     LogExtraMessage ('  Ignoring: '+OrigRegel);

Abort:
     FreeMem (Tmp,SizeOf (MailTunnelRecord));
END;


{--------------------------------------------------------------------------}
{ AddForcePack                                                             }
{                                                                          }
{ Deze routine interpreteert een FORCEPACK entry en voegt deze toe.        }
{                                                                          }
PROCEDURE AddForcePack (Regel : STRING);

VAR Tmp : ForcePackPtr;

BEGIN
     GetMem (Tmp,SizeOf (ForcePackRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (ForcePackRecord),'GetMem ForcePackRecord'); {$ENDIF}

     FidoSplit (Regel,Tmp^.FidoAddr);
     WITH Tmp^.FidoAddr DO
          IF (Zone = 0) AND (Net = 0) AND (Node = 0) AND (Point = 0) THEN
          BEGIN
               { vast verkeerd }
               FreeMem (Tmp,SizeOf (ForcePackRecord));
               LogMessage (liConfig,'Error interpreting FORCEPACK line: '+Regel);
               Exit;
          END;

     ForcePackList.Add (Tmp);
END;


{$IFDEF WtrUtil}
{--------------------------------------------------------------------------}
{ AddNodeListEntry                                                         }
{                                                                          }
{ Deze routine spaart een NODELIST entry in een List (WtrUtil ONLY).       }
{                                                                          }
PROCEDURE AddNodeListEntry (Regel : STRING);

VAR Tmp : ^NodeListRecord;

BEGIN
     IF (Pos ('\',Regel) = 0) THEN
     BEGIN
          LogMessage (liConfig,'NODELIST requires complete path to nodelist files!');
          Exit;
     END;

     IF (Regel[Length (Regel)] = '\') THEN
     BEGIN
          LogMessage (liConfig,'NODELIST requires path PLUS filename, without extension');
          Exit;
     END;

     GetMem (Tmp,SizeOf (NodeListRecord));
     {$IFDEF LogGetMem} LogGetMem (Tmp,SizeOf (NodeListRecord),'GetMem NodeListRecord'); {$ENDIF}

     Tmp^.Path:=Regel;
     NodeListsList.Add (Tmp);
END;
{$ENDIF (WtrUtil)}


{--------------------------------------------------------------------------}
{ AddRouteFido                                                             }
{                                                                          }
{ This routine handles the ROUTE-FIDO keyword.                             }
{                                                                          }
PROCEDURE AddRouteFido (InvoerRegel : STRING);

VAR BaseAddr,
    InvoerAdres,
    RouteToAdres : FidoAddrType;
    InvoerLevel  : INTEGER;
    UserRecNr    : UserBaseRecordNrType;
    PrevPtr,
    NewPtr       : RouteRecordPtr;

    OriginalInvoerRegel : STRING;

BEGIN
     {$IFDEF LogRouteFido}
     LogMessage (liDebug,'In='+InvoerRegel);
     {$ENDIF}

     OriginalInvoerRegel:=InvoerRegel;

     { Het eerste adres is het Route-To adres }
     RouteToAdres:=NullAdres;
     GetNextFtnAddrPart (InvoerRegel,RouteToAdres);

     { Controleer of dat adres bestaat ! Het  }
     { moet namelijk een van onze buren zijn  }

     IF (NOT FindUserBaseRecordByFidoAddress (RouteToAdres,UserRecNr)) THEN
     BEGIN
          LogMessage (liConfig,'Unknown ROUTE-FTN destination '+Fido2Str (RouteToAdres));
          Exit;
     END;

     { find the last one in the chain }
     PrevPtr:=FirstRouteRecordPtr;
     IF (PrevPtr <> NIL) THEN
        WHILE (PrevPtr^.NextRouteRecordPtr <> NIL) DO
              PrevPtr:=PrevPtr^.NextRouteRecordPtr;

     { start with route-to address as the base for the search mask }
     InvoerAdres:=RouteToAdres;

     { process everything address on this line }
     WHILE (InvoerRegel <> '') DO
     BEGIN
          InvoerLevel:=GetNextFtnAddrPart (InvoerRegel,InvoerAdres);

          IF (InvoerLevel = 0) THEN
          BEGIN
               LogMessage (liConfig,'Invalid: ROUTE-FTN '+OriginalInvoerRegel);
               Exit;
          END;

          {$IFDEF LogRouteFido}
          LogExtraMessage ('Level='+Byte2String (InvoerLevel)+', Address='+Fido2Str (InvoerAdres));
          {$ENDIF}

          { add a new entry }
          GetMem (NewPtr,SizeOf (RouteRecord));
          {$IFDEF LogGetMem} LogGetMem (NewPtr,SizeOf (RouteRecord),'GetMem RouteRecord'); {$ENDIF}

          WITH NewPtr^ DO
          BEGIN
               Level:=InvoerLevel;
               MaskFidoAddr:=InvoerAdres;
               ViaFidoAddr:=RouteToAdres;
               NextRouteRecordPtr:=NIL;
          END; { with }

          IF (PrevPtr = NIL) THEN
             FirstRouteRecordPtr:=NewPtr
          ELSE
              PrevPtr^.NextRouteRecordPtr:=NewPtr;

          PrevPtr:=NewPtr;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ ProcessBbsVia                                                            }
{                                                                          }
{ This routine is called to process a BBS-VIA statement found in the       }
{ ROUTE.TDB file.                                                          }
{                                                                          }
PROCEDURE ProcessBbsVia (InvoerRegel : STRING);

VAR InvoerAdres : FidoAddrType;
    UserLp      : UserBaseRecordNrType;

BEGIN
     FidoSplit (DeleteFrontSpaces (InvoerRegel),InvoerAdres);

     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserData);

          IF (NOT UserData.Deleted) THEN
             IF (UserData.System = _F) AND
                FidoCompare (UserData.Address,InvoerAdres) THEN
             BEGIN
                  BBSViaRecNr:=UserLp;
                  Break; { for }
             END ELSE
                 IF (UserData.System = _BBS) AND
                    (InvoerAdres.Point = 0) AND
                    (InvoerAdres.Net = UserData.FakeNet) AND
                    (InvoerAdres.Node = UserData.FakeNode) AND
                    (InvoerAdres.Zone = UserData.FakeZone) THEN
                 BEGIN
                      BBSViaRecNr:=UserLp;
                      Break; { for }
                 END;
     END; { for }

     IF (BBSViaRecNr = NILRecordNr) THEN
        LogMessage (liConfig,'Cannot find user with BBS-VIA node number '+InvoerRegel);
END;


(* RAWI 980521: disabled
{--------------------------------------------------------------------------}
{ Schedule                                                                 }
{                                                                          }
{ Kijkt of een gegeven schedule op dit tijdstip actief is, en dus verwerkt }
{ mag worden.                                                              }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ Sched <tag> [day] [start] [end]                                          }
{                                                                          }
{ Start en eind tijden zijn in 24 uurs formaat (eg 00:00 - 23:59)          }
{ Day kan 'Mon' zijn, maar ook 'Tue|Sat|Sun' of 'All'                      }
{                                                                          }
FUNCTION Schedule (Regel : STRING) : BOOLEAN;

VAR DagF  : STRING[3];
    DagS,
    Tag   : STRING;
    Hour,
    Min,
    DoW,
    Dum   : WordLong;
    e     : ValNop;
    SHour,
    SMin  : WORD;
    Space : BYTE;

BEGIN
     Schedule:=TRUE;

     Regel:=UpCaseString (DeleteFrontAndBackSpaces (CleanTabs (Regel,1)));
     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        Tag:=Regel   { alleen een tag op de regel }
     ELSE BEGIN
          Tag:=Copy (Regel,1,Space-1);
          Delete (Regel,1,Space-1);
     END;

     { Voorlopig negeren we de tag }
     IF (Regel = '') THEN
        Exit;

     { Haal de huidige dag en tijd uit de systeem klok }
     GetDate (Dum,Dum,Dum,DoW);
     GetTime (Hour,Min,Dum,Dum);

     Regel:=DeleteFrontSpaces (Regel);
     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        DagS:=Regel                       { Alleen een dag op de regel   }
     ELSE BEGIN
          DagS:=Copy (Regel,1,Space-1);
          Delete (Regel,1,Space-1);
     END;

     DagF:=UpCaseString (Day[Dow]);

     IF (Pos (DagF,DagS) = 0) THEN       { Zit vandaag er tussen ?      }
        IF (Pos ('ALL',DagS) = 0) THEN     { Probeer of ALL er tussen zit }
        BEGIN
             Schedule:=FALSE;      { nee dus, pech gehad }
             Exit;
        END;

     IF (Regel = '') THEN        { niets meer op de regel? }
        Exit;

     Regel:=DeleteFrontSpaces (Regel);
     DagS:=Copy (Regel,1,2);      { Haal uur van de regel        }
     Val (DagS,SHour,e);
     DagS:=Copy (Regel,4,2);      { Haal minuut van de regel     }
     Val (Dags,SMin,e);

     IF (Hour < SHour) OR ((SHour = Hour) AND (Min < SMin)) THEN
     BEGIN
          Schedule:=FALSE;
          Exit;
     END;

     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        Exit;

     Regel:=DeleteFrontSpaces (Copy (Regel,6,255));
     DagS:=Copy (Regel,1,2);      { Haal uur van de regel        }
     Val (Dags,SHour,e);
     DagS:=Copy (Regel,4,2);      { Haal minuut van de regel     }
     Val (Dags,SMin,e);

     { Kijk of de eind tijd van het schedule wel geldig is }
     IF (SHour < Hour) OR ((Shour = Hour) AND (SMin < Min)) THEN
     BEGIN
          Schedule:=FALSE;
          Exit;
     END;
END;
*)


{--------------------------------------------------------------------------}
{ AddNotLocalDomain                                                        }
{                                                                          }
{ Adds a new 'not local' domain entry .                                    }
{                                                                          }
PROCEDURE AddNotLocalDomain (Domain: STRING);

VAR Tmp : NotLocalPtr;

BEGIN
     GetMem (Tmp,SizeOf (NotLocalRecord));

     Tmp^.Domain := DeleteFrontAndBackSpaces (Domain);

     NotLocalList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddMimeAttachType                                                        }
{                                                                          }
{ Adds a new MIME type to the list of types that will be considered as     }
{ attachments.                                                             }
{                                                                          }
PROCEDURE AddMimeAttachType (MimeType: STRING);

VAR Tmp : MimeAttachPtr;

BEGIN
     { check for dupes }
     IF IsMimeAttachment (MimeType) THEN
        Exit;

     GetMem (Tmp,SizeOf (MimeAttachRecord));

     Tmp^.MimeType:=DeleteFrontAndBackSpaces (MimeType);

     MimeAttachList.Add (Tmp);
END;


VAR InIncludeFile : BOOLEAN;

{--------------------------------------------------------------------------}
{ ReadRouteFile                                                            }
{                                                                          }
{ This routine opens and reads the contents of a ROUTE.TDB file or one of  }
{ its INCLUDEd files. Only one level of inclusion is supported.            }
{                                                                          }
PROCEDURE ReadRouteFile (Filename : STRING);

VAR RouteFile        : TEXT;
    IORes            : BYTE;
    InvoerRegel,
    NoUpperCaseRegel : STRING;
    Keyword          : STRING[30];
    TmpUUCPName      : STRING;
    UserRecNr        : UserBaseRecordNrType;
    B                : CHAR;
    MapRfcFirst,
    MapFtnFirst,
    RouteRfcFirst,
    RouteFtnFirst    : BOOLEAN;

BEGIN
     Assign (RouteFile,Filename);
     {$I-} Reset (RouteFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Error opening '+Filename);
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenT (RouteFile);{$ENDIF}

     IF InIncludeFile THEN
        LogMessage (liTrivial,'Reading include file '+Filename)
     ELSE
         LogMessage (liTrivial,'Reading '+Filename);

     RouteRfcFirst:=TRUE;
     RouteFtnFirst:=TRUE;
     MapRfcFirst:=TRUE;
     MapFtnFirst:=TRUE;

     WHILE (NOT Eof (RouteFile)) DO
     BEGIN
          ReadLn (RouteFile,InvoerRegel);

          InvoerRegel:=DeleteBackSpaces (InvoerRegel); { RWI 960219 }

          IF (InvoerRegel = '') OR (InvoerRegel[1] = ';') THEN
             Continue;

          InvoerRegel:=CleanTabs (InvoerRegel,1);
          NoUpperCaseRegel:=InvoerRegel;

          { UPCASE een eventueel keyword }
          IF (Pos (' ',InvoerRegel) > 0) THEN
              Keyword:=UpCaseString (Copy (InvoerRegel,1,Pos (' ',InvoerRegel)-1))
          ELSE
              Keyword:=UpCaseString (InvoerRegel);

          { RAWI 980521: removed SCHEDULE keyword
          IF (Keyword = 'SCHEDULE') THEN
          BEGIN
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,9,255));
               Verder:=Schedule (InvoerRegel);
          END;
          }

          { Als we een schedule tegen gekomen zijn die ons niet }
          { toestaat om verder te lezen, negeren we alle regels }
          { tot een volgende schedule                           }
          {
          IF (NOT Verder) THEN
             Continue;
          }

          IF (Keyword = 'INCLUDE') THEN
          BEGIN
               IF InIncludeFile THEN
                  LogMessage (liConfig,'Nested INCLUDE statements not supported')
               ELSE
               BEGIN
                    InvoerRegel:=DeleteFrontAndBackSpaces (Copy (InvoerRegel,8,255));
                    IF (Pos ('\',InvoerRegel) = 0) AND (Pos (':',InvoerRegel) = 0) THEN
                       InvoerRegel:=Config.SystemDir+InvoerRegel;

                    InIncludeFile:=TRUE;
                    ReadRouteFile (InvoerRegel);
                    InIncludeFile:=FALSE;
               END;

               Continue;
          END;

          IF (Keyword = 'SIGNATURE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,10,255));
               AddSignatureToList (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NEWSFILTER') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,11,255));
               IF (Pos ('\',InvoerRegel) = 0) THEN
                  InvoerRegel:=Config.SystemDir+InvoerRegel;

               ProcessFilterFile (UpCaseString (InvoerRegel));
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-UUCP') THEN
          BEGIN
               Keyword[5]:='R';
               Keyword[6]:='F';
               Keyword[7]:='C';
               Delete (Keyword,8,1);
               IF MapRfcFirst THEN
               BEGIN
                    MapRfcFirst:=FALSE;
                    LogMessage (liConfig,'Please replace MAP-UUCP with MAP-RFC');
               END;
          END;

          IF (Keyword = 'MAP-RFC') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapUUCPLine (NoUpperCaseRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-FIDO') THEN
          BEGIN
               Keyword[6]:='T';
               Keyword[7]:='N';
               Delete (Keyword,8,1);
               IF MapFtnFirst THEN
               BEGIN
                    MapFtnFirst:=FALSE;
                    LogMessage (liConfig,'Please replace MAP-FIDO with MAP-FTN');
               END;
          END;

          IF (Keyword = 'MAP-FTN') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapFidoLine (NoUpperCaseRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-AREA') THEN
          BEGIN
               LogMessage (liConfig,'Replace MAP-AREA with a Filter Definition please');
               (*
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapAreaLine (NoUpperCaseRegel);
               {$ENDIF}
               *)
               Continue;
          END;

          IF (Keyword = 'ALLOW-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddAllowFIDOLine (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'FORBID-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddDisallowFIDOLine (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'ROUTE-UUCP') THEN
          BEGIN
               Keyword[7]:='R';
               Keyword[8]:='F';
               Keyword[9]:='C';
               Delete (Keyword,10,1);
               IF RouteRfcFirst THEN
               BEGIN
                    RouteRfcFirst:=FALSE;
                    LogMessage (liConfig,'Please replace ROUTE-UUCP with ROUTE-RFC');
               END;
          END;

          IF (Keyword = 'ROUTE-RFC') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,11,255));
               TmpUUCPName:=Copy (InvoerRegel,1,Pos (' ',InvoerRegel)-1);
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,Length (TmpUUCPName)+1,255));

               { Controleer of deze UUCP name wel bestaat }
               IF FindUserBaseRecordByUUCPName (TmpUUCPName,UserRecNr) THEN
                  Inc (MemRouting,AddUUCPRouteLine (UserRecNr,InvoerRegel))
               ELSE
                   LogMessage (liConfig,'Found unknown ROUTE-RFC address '+TmpUUCPName+' in ROUTE.TDB ');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'ROUTE-FIDO') THEN
          BEGIN
               Keyword[8]:='T';
               Keyword[9]:='N';
               Delete (Keyword,10,1);
               IF RouteFtnFirst THEN
               BEGIN
                    RouteFtnFirst:=FALSE;
                    LogMessage (liConfig,'Please replace ROUTE-FIDO with ROUTE-FTN');
               END;
          END;

          IF (Keyword = 'ROUTE-FTN') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontAndBackSpaces (Copy (InvoerRegel,11,255));
               AddRouteFido (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'SAVE') THEN
          BEGIN
               LogMessage (liConfig,'Replace SAVE with a Filter definition please');
               (*
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,6,255)));
               AddSaveFileToList (FALSE,InvoerRegel);
               {$ENDIF}
               *)
               Continue;
          END;

          IF (Keyword = 'SAVEFROM') THEN
          BEGIN
               LogMessage (liConfig,'Replace SAVEFROM with a Filter definition please');
               (*
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,10,255)));
               AddSaveFileToList (TRUE,InvoerRegel);
               {$ENDIF}
               *)
               Continue;
          END;

          IF (Keyword = 'SENDFILE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,10,255)));
               AddSendFileToList (InvoerRegel,FALSE);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'SENDTEXTFILE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,14,255)));
               AddSendFileToList (InvoerRegel,TRUE);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BOUNCE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,8,255));
               AddBounceToList (FALSE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BOUNCEFROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,12,255));
               AddBounceToList (TRUE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'GZIPBATCH') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               IF (Pos (' ',InvoerRegel) > 0) THEN
                  B:=LoCase (InVoerRegel[Pos (' ',InvoerRegel)+1]);

               IF (B IN ['a'..'z']) THEN
               BEGIN
                    GZipBatchLetter:=B;
                    {LogMessage (liConfig,'GZip Batch letter set to '+GZipBatchLetter);}
               END ELSE
                   LogMessage (liConfig,'Ignoring invalid GZIPBATCH letter! ('+B+')');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'FORCENOBITMASK') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               LogMessage (liConfig,'FORCENOBITMASK is now an option in WtrConf,System Configuration,UUCP Settings');
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'TUNNEL-TO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtTo,FALSE{Seat},InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          (*
          IF (Keyword = 'SEAT-TO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtTo,TRUE{Seat},InvoerRegel);
               {$ENDIF}
               Continue;
          END;
          *)

          IF (Keyword = 'TUNNEL-FROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtFrom,FALSE{Seat},InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          (*
          IF (Keyword = 'SEAT-FROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtFrom,TRUE{Seat},InvoerRegel);
               {$ENDIF}
               Continue;
          END;
          *)

          IF (Keyword = 'FORCEPACK') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               AddForcePack (DeleteFrontSpaces (InvoerRegel));
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'IGNOREFIDOUSER') THEN
          BEGIN
               IF (CustomSkipCount = MAX_CUSTOMSKIPUSERNAMES) THEN
                  LogMessage (liConfig,'Only '+Byte2String (MAX_CUSTOMSKIPUSERNAMES)+
                              ' IGNOREFIDOUSER statements possible!')
               ELSE BEGIN
                    Delete (InvoerRegel,1,15);
                    Inc (CustomSkipCount);
                    CustomSkipUsernames[CustomSkipCount]:=UpCaseString (InvoerRegel);
               END;

               Continue;
          END;

          IF (Keyword = 'GIGOTERROR') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               GigoMinusFLine:=DeleteFrontAndBackSpaces (InvoerRegel);

               IF (GigoMinusFLine <> '') THEN
               BEGIN
                    IF (Pos ('@',GigoMinusFLine) = 0) AND (Pos ('!',GigoMinusFLine) = 0) THEN
                    BEGIN
                         LogMessage (liConfig,'GIGOTERROR: invalid error address');
                         GigoMinusFLine:='';
                    END;
               END;

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAIL2NEWS') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               Mail2NewsAddress:=DeleteFrontSpaces (InvoerRegel);

               IF (Mail2NewsAddress = '') THEN
               BEGIN
                    LogMessage (liConfig,'MAIL2NEWS misses e-mail address argument');
                    Continue;
               END;

               LogMessage (liTrivial,'Enabled mail2news via '+Mail2NewsAddress);

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-AREA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,9);
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (InvoerRegel));

               BBSNormalAreaRecNr:=GetAreaBaseRecordNrByAreaName_F (InvoerRegel);

               IF (BBSNormalAreaRecNr = NILRecordNr) THEN
                  LogMessage (liConfig,'Cannot find BBS-AREA "'+InvoerRegel+'"');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-EMAILAREA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,14);
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (InvoerRegel));

               BBSEMailAreaRecNr:=GetAreaBaseRecordNrByAreaName_F (InvoerRegel);

               IF (BBSEMailAreaRecNr = NILRecordNr) THEN
                  LogMessage (liConfig,'Cannot find BBS-EMAILAREA "'+InvoerRegel+'"');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-VIA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,8);
               ProcessBbsVia (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NODELIST') THEN
          BEGIN
               {$IFDEF WtrUtil}
               Delete (InvoerRegel,1,9);
               AddNodeListEntry (DeleteFrontAndBackSpaces (InvoerRegel));
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NEWSDOMAIN') THEN
          BEGIN
               Delete (InvoerRegel,1,11);
               NewsDomain:=InvoerRegel;
               Continue;
          END;

          (*
          IF (Keyword = 'UUPCMODE') THEN
          BEGIN
               UUPCMode:=TRUE;
               LogMessage (liTrivial,'Enabling UUPC mode');
               Continue;
          END;
          *)

          { See description in USENET.PAS:UsenetIsOurDomain }
          IF (Keyword = 'NOTLOCAL') THEN
          BEGIN
               Delete (InvoerRegel, 1, 8);
               AddNotLocalDomain (InvoerRegel);
               Continue;
          END;

          IF (Keyword = 'MIME-ATTACH') THEN
          BEGIN
               Delete (InvoerRegel, 1, 12);
               AddMimeAttachType (InvoerRegel);
               Continue;
          END;

          LogMessage (liConfig,'ROUTE.TDB: Don''t know how to handle "'+NoUppercaseRegel+'"');
     END; { while not eof }

     {$IFDEF LogFileIO}PreCloseT (RouteFile);{$ENDIF}
     Close (RouteFile);
END;


{--------------------------------------------------------------------------}
{ AddUserRouting                                                           }
{                                                                          }
{ This routine reads all the user defintions and adds routing entries      }
{ where needed.                                                            }
{                                                                          }
PROCEDURE AddUserRouting;

VAR UserLp            : UserBaseRecordNrType;
    NextRout          : RouteRecordPtr;
    CntDomains        : INTEGER;
    NewRouteRecordPtr : RouteRecordPtr;

BEGIN
     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserData);

          { Zorg ervoor dat BAG file suppliers NIET in de routing worden }
          { opgenomen.                                                   }
          IF (NOT UserData.Deleted) AND (UserData.System <> _B) THEN
          BEGIN
               { Voor alle system die niet gedelete zijn, en een UUCP name }
               { hebben:                                                   }
               { RWI 950212: mag dit wel? Het mag toch alleen als dat }
               {             systeem een worldreg systeempje is? Nu   }
               {             gaat take!takev@wsd.uucp goed, terwijl   }
               {             take niet worldreg is... Ik kan alleen   }
               {             geen reden bedenken waarom het niet zou  }
               {             mogen...                                 }
               IF (UserData.UUCPName <> '') THEN
                  Inc (MemRouting,AddUUCPRouteLine (UserLp,UserData.UUCPName));

               { Voeg alle domain addressen toe zover die gedefinieerd zijn }
               { Controleer of voor de domains sub domains zijn toegestaan  }
               FOR CntDomains:=1 TO MaxUserDomains DO
                   IF (UserData.Domains[CntDomains] <> '') THEN
                      { RWI 950524: AllowSubDomains weer ingevoerd }
                      IF (UserData.AllowSubDomains AND (UserData.Domains[CntDomains,1] <> '.')) THEN
                         { .A.B.C is inclusief A.B.C zelf. Zie UUCPROUT.PAS }
                         Inc (MemRouting,AddUUCPRouteLine (UserLp,'.'+UserData.Domains[CntDomains]))
                      ELSE
                          Inc (MemRouting,AddUUCPRouteLine (UserLp,UserData.Domains[CntDomains]));

               { voeg alle fido addressen toe als die er zijn }
               IF (UserData.System = _F) THEN
               BEGIN
                    IF (FirstRouteRecordPtr = NIL) THEN
                    BEGIN
                         GetMem (FirstRouteRecordPtr,SizeOf (RouteRecord));
                         {$IFDEF LogGetMem} LogGetMem (FirstRouteRecordPtr,SizeOf (RouteRecord),
                                                       'GetMem RouteRecord (2)'); {$ENDIF}
                         NewRouteRecordPtr:=FirstRouteRecordPtr;
                    END ELSE
                    BEGIN
                         GetMem (NewRouteRecordPtr^.NextRouteRecordPtr,SizeOf (RouteRecord));
                         {$IFDEF LogGetMem} LogGetMem (NewRouteRecordPtr^.NextRouteRecordPtr,SizeOf (RouteRecord),
                                                       'GetMem RouteRecord (3)'); {$ENDIF}
                         NewRouteRecordPtr:=NewRouteRecordPtr^.NextRouteRecordPtr;
                    END;

                    WITH NewRouteRecordPtr^ DO
                    BEGIN
                         Level:=4;                       { check level }
                         MaskFidoAddr:=UserData.Address; { mask }
                         ViaFidoAddr:=UserData.Address;  { via }
                         NextRouteRecordPtr:=NIL;
                    END;
               END; { not deleted and fido system }

          END; { Not Deleted en niet een bag supplier }
     END; { for }

     PeekMem;
END;


{--------------------------------------------------------------------------}
{ InitRoutingTable                                                         }
{                                                                          }
{ Bouwt de fido netmail routing tabel uit alle fido adressen in de         }
{ Userbase en alle routing informatie die in de config is opgegeven.       }
{                                                                          }
PROCEDURE InitRoutingTable;
BEGIN
     MemSignatures:=0;
     MemRouting:=0;
     MemMapping:=0;
     MemSendfile:=0;
     MemFilter:=0;
     MemTunnel:=0;

     AddUserRouting;

     { Kijk dan of er in de systeem directory \ROUTE.TDB bestaat }
     { Deze bevat alle andere routing informatie. In tekst vorm! }

     IF (NOT TestIfExist (Config.SystemDir+'ROUTE.TDB')) THEN
        LogMessage (liConfig,'Unable to locate ROUTE.TDB')
     ELSE BEGIN
          InIncludeFile:=FALSE;
          ReadRouteFile (Config.SystemDir+'ROUTE.TDB');
     END;

     IF (BBSViaRecNr <> NILRecordNr) AND
        ((BBSNormalAreaRecNr <> NILRecordNr) OR (BBSEMailAreaRecNr <> NILRecordNr))
     THEN
         LogMessage (liConfig,'Found both BBS-(EMAIL)AREA and BBS-VIA. Latter will be used.');

     { als er geen NEWSFILTER commando was, of de file niet geopend kon }
     { worden, of er geen ROUTE.TDB file was, dan staan we toch alle    }
     { newsgroup namen toe door een * toe te voegen.                    }

     { in plaats van regel nummer 0 kunnen we nog eens iets speciaals }
     { toevoegen, zoals 65535 en dan een speciale melding in de log.  }
     IF (FilterList.FirstItem = NIL) THEN
     BEGIN
          {$IFNDEF WtrUtil}
          {$IFNDEF WtrTest}
          IF Config.LogDebug THEN
             LogMessage (liGeneral,'Allowing all new newsgroup names');
          {$ENDIF}
          {$ENDIF}
          AddFilterToList ('*','',0);
     END;

     AddMimeAttachType ('image');
     AddMimeAttachType ('sound');
     AddMimeAttachType ('application');

     IF (GigoMinusFLine = '') THEN
        GigoMinusFLine:='wtrgate@'+Config.Domains[1];

     IF (NewsDomain = '') THEN
        NewsDomain:=Config.Domains[1];

     PeekMem;

     IF DebugMem THEN
     BEGIN
          LogExtraMessage (MEMUSEFOR+'Signatures = '+Longint2String (MemSignatures));
          LogExtraMessage (MEMUSEFOR+'Mapping = '+Longint2String (MemMapping));
          LogExtraMessage (MEMUSEFOR+'Routing = '+Longint2String (MemRouting));
          LogExtraMessage (MEMUSEFOR+'Sendfile = '+Longint2String (MemSendfile));
          LogExtraMessage (MEMUSEFOR+'NewsFilter = '+Longint2String (MemFilter));
          LogExtraMessage (MEMUSEFOR+'MailTunnels = '+Longint2String (MemTunnel));
     END;
END;


{--------------------------------------------------------------------------}
{ JunkRoutingTable                                                         }
{                                                                          }
{ Geeft het geheugen van de routing table weer vrij.                       }
{                                                                          }
PROCEDURE JunkRoutingTable;

VAR EraseRouteRecordPtr : RouteRecordPtr;

BEGIN
     WHILE (FirstRouteRecordPtr <> NIL) DO
     BEGIN
          EraseRouteRecordPtr:=FirstRouteRecordPtr;
          FirstRouteRecordPtr:=FirstRouteRecordPtr^.NextRouteRecordPtr;
          FreeMem (EraseRouteRecordPtr,SizeOf (RouteRecord));
     END;

     FidoMappingList.Clear;
     UUCPMappingList.Clear;
     SignatureList.Clear;
     FilterList.Clear;
    {SaveFileList.Clear;}
     SendFileList.Clear;
     BounceList.Clear;
    {MapAreaList.Clear;}
     MailTunnelList.Clear;
     ForcePackList.Clear;
     NotLocalList.Clear;
     MimeAttachList.Clear;
     {$IFDEF WtrUtil}
     NodeListsList.Clear;
     {$ENDIF}
END;


{--------------------------------------------------------------------------}
{ FreeFilterRecord                                                         }
{                                                                          }
{ This is routine is called by the DList routine to clean up a record that }
{ contains pointers to dynamically allocated memory, so all that memory    }
{ gets freed as well.                                                      }
{                                                                          }
PROCEDURE FreeFilterRecord (VAR Tmp : POINTER); FAR;
BEGIN
     WITH FilterRecord (Tmp^) DO
     BEGIN
          {$IFDEF LogGetMem} LogGetMem (NamePtr,Length (NamePtr^)+1,'FreeMem Filter Name'); {$ENDIF}
          FreeMem (NamePtr,Length (NamePtr^)+1);

          IF (PathPtr <> NIL) THEN
          BEGIN
               {$IFDEF LogGetMem} LogGetMem (PathPtr,Length (PathPtr^)+1,'FreeMem Filter Path'); {$ENDIF}
               FreeMem (PathPtr,Length (PathPtr^)+1);
          END;
     END;
END;


{ Unit Initialization }
BEGIN
     FidoMappingList.Init (SizeOf (MapRecord),NIL);
     UUCPMappingList.Init (SizeOf (MapRecord),NIL);
     SignatureList.Init (SizeOf (SignatureRecord),NIL);
     FilterList.Init (SizeOf (FilterRecord),FreeFilterRecord);
    {SaveFileList.Init (SizeOf (SaveFileRecord),NIL);}
     SendFileList.Init (SizeOf (SendFileRecord),NIL);
     BounceList.Init (SizeOf (BounceRecord),NIL);
    {MapAreaList.Init (SizeOf (MapAreaRecord),NIL);}
     MailTunnelList.Init (SizeOf (MailTunnelRecord),NIL);
     ForcePackList.Init (SizeOf (ForcePackRecord),NIL);
     NotLocalList.Init (SizeOf (NotLocalRecord),NIL);
     MimeAttachList.Init (SizeOf (MimeAttachRecord),NIL);
     {$IFDEF WtrUtil}
     NodeListsList.Init (SizeOf (NodeListRecord),NIL);
     {$ENDIF}
END.
