UNIT UpgrUser;

{$I platform.inc}

INTERFACE

USES UpgrGlob;

(* not supported
TYPE UserBase01Record = RECORD
                              Deleted      : BOOLEAN;
                              System       : BYTE;
                              Organization : STRING[MaxLenOrganization];
                              Groups       : GroupFlagType;
                              Passive      : BOOLEAN;
                              AreaFixPwd   : STRING[MaxLenAreaFixPwd];
                              AllowFrom    : BOOLEAN;
                              AllowCreate  : BOOLEAN;
                              AreaList     : SubscriptBaseRecordNrType;
                              UUCPName     : STRING[MaxLenUUCPName];
                              WorldReg     : BOOLEAN;
                              Domains      : ARRAY[1..60] OF STRING[MaxLenDomain];

                              CASE INTEGER OF
                                   0 : (Address      : FidoAddrType;
                                        Sysop        : STRING[MaxLenSysopName];
                                        PacketPwd    : STRING[8];
                                        Compression  : CompressionType;
                                        MaxPktLength : LONGINT;
                                        SendFormat   : SendType;
                                       );

                                   1 : (Compress     : BOOLEAN;
                                        CunBatch     : BOOLEAN;
                                       );
                        END;

TYPE UserBase02Record = RECORD
                              Deleted       : BOOLEAN;
                              System        : BYTE;
                              Organization  : STRING[MaxLenOrganization];
                              Groups        : LONGINT;
                              Passive       : BOOLEAN;
                              AreaFixPwd    : STRING[MaxLenAreaFixPwd];
                              AllowFrom     : BOOLEAN;
                              AllowCreate   : BOOLEAN;
                              NewAreaDefault: LONGINT; {*}
                              AllowForward  : BOOLEAN; {*}
                              AreaList      : SubscriptBaseRecordNrType;
                              UUCPName      : STRING[10];
                              WorldReg      : BOOLEAN;
                              Domains       : ARRAY[1..6] OF STRING[MaxLenDomain];

                              CASE INTEGER OF
                                   0 : (Address      : FidoAddrType;
                                        Sysop        : STRING[MaxLenSysopName];
                                        PacketPwd    : STRING[8];
                                        Compression  : BYTE;
                                        MaxPktLength : LONGINT;
                                        SendFormat   : BYTE;
                                       );

                                   1 : (Compress     : BYTE;
                                        CunBatch     : BOOLEAN;
                                       );
                        END;
*)

{ missing: 03 }
(* not anymore!!
NewAreaDefault from LONGINT to GroupFlagType
See database.03
Taken from backup dated "8/4"
TYPE UserBase03Record = RECORD
                              Deleted       : BOOLEAN; { record is free? }

                              System        : SystemType;
                              Organization  : STRING[MaxLenOrganization];
                              Groups        : GroupFlagType;
                              Passive       : BOOLEAN;
                              AreaFixPwd    : STRING[MaxLenAreaFixPwd];
                              AllowFrom     : BOOLEAN;
                              AllowCreate   : BOOLEAN;

                              NewAreaDefault: GroupFlagType; {*}
                              AllowForward  : BOOLEAN; {*}

                              AreaList     : SubscriptBaseRecordNrType;
                              UUCPName     : STRING[MaxLenUUCPName];
  { Allow Sub Domains }       WorldReg     : BOOLEAN;
                              Domains      : ARRAY[1..MaxDomains] OF STRING[MaxLenDomain];

                              CASE INTEGER OF
                          { Fido } 0 : (Address      : FidoAddrType;
                                        Sysop        : STRING[MaxLenSysopName];
                                        PacketPwd    : STRING[8];
                                        Compression  : CompressionType;
                                        MaxPktLength : LONGINT;
                                        SendFormat   : SendType;
                                        LastArchDow  : BYTE; { 0 = first, 1..7 = dow }
                                        LastArchNr   : BYTE; { 0..n = nummer }
                                       );

                        { Usenet } 1 : (Compress     : UseCompressType;
                                        CunBatch     : BOOLEAN;
                                        BAGbacklink  : STRING[MaxLenUUCPName];
                                       );
                      END;

*)

TYPE UserBase04Record = RECORD
    { starts at byte  0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : LONGINT;
                 {   67 }     Passive         : BOOLEAN;
                 {   68 }     AreaFixPwd      : STRING[20];
                 {   89 }     AllowFrom       : BOOLEAN;
                 {   90 }     AllowCreate     : BOOLEAN;
                 {   91 }     AllowSubDomains : BOOLEAN;
                 {   92 }     OLD1            : LONGINT;
                 {   96 }     AreaList        : WORD;
                 {   98 }     UUCPName        : STRING[10];
                 {  101 }     WorldReg        : BOOLEAN;
                 {  102 }     Domains         : ARRAY[1..6] OF STRING[50];

                              CASE INTEGER OF
                 {  416 }          0 : (Address      : FidoAddrType;
                 {  450 }               Sysop        : STRING[50];
                 {  501 }               PacketPwd    : STRING[8];
                 {  510 }               Compression  : BYTE;
                 {  511 }               MaxPktLength : LONGINT;
                 {  515 }               SendFormat   : BYTE;
                 {  516 }               LastArchDow  : BYTE;
                 {  517 }               LastArchNr   : BYTE;
{ next would be at  518 }              );

                 {  416 }          1 : (Compress     : BYTE;
                 {  417 }               CunBatch     : BOOLEAN;
                 {  418 }               BAGbacklink  : STRING[10];
{ next would be at  429 }              );
                        END;


TYPE UserBase05Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : LONGINT;
                 {   67 }     Passive         : BOOLEAN;
                 {   68 }     AreaFixPwd      : STRING[20];
                 {   89 }     AllowFrom       : BOOLEAN;
                 {   90 }     AllowCreate     : BOOLEAN;
                 {   91 }     AllowSubDomains : BOOLEAN;
                 {   92 }     OLD1            : LONGINT;
                 {   96 }     AreaList        : WORD;
                 {   98 }     UUCPName        : STRING[10];
                 {  101 }     WorldReg        : BOOLEAN;
                 {  102 }     Domains         : ARRAY[1..6] OF STRING[50];

                              CASE INTEGER OF
                 {  416 }          0 : (Address      : FidoAddrType;
                 {  450 }               Sysop        : STRING[50];
                 {  501 }               PacketPwd    : STRING[8];
                 {  510 }               Compression  : BYTE;
                 {  511 }               MaxPktLength : LONGINT;
                 {  515 }               SendFormat   : BYTE;
                 {  516 }               LastArchDow  : BYTE;
                 {  517 }               LastArchNr   : BYTE;
        { ++ 05 }{  518 }               ExportAKA    : BYTE;
{ next would be at  519 }              );

                 {  416 }          1 : (Compress     : BYTE;
                 {  417 }               CunBatch     : BOOLEAN;
                 {  418 }               BAGbacklink  : STRING[10];
{ next would be at  429 }              );
                        END;


TYPE UserBase06Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : LONGINT;
                 {   67 }     Passive         : BOOLEAN;
                 {   68 }     AreaFixPwd      : STRING[20];
                 {   89 }     AllowFrom       : BOOLEAN;
                 {   90 }     AllowCreate     : BOOLEAN;
                 {   91 }     AllowSubDomains : BOOLEAN;
                 {   92 }     OLD1            : LONGINT;
                 {   96 }     AreaList        : WORD;
                 {   98 }     UUCPName        : STRING[10];
                 {  101 }     WorldReg        : BOOLEAN;
                 {  102 }     Domains         : ARRAY[1..6] OF STRING[50];

                              CASE INTEGER OF
                 {  416 }          0 : (Address      : FidoAddrType;
                 {  450 }               Sysop        : STRING[50];
                 {  501 }               PacketPwd    : STRING[8];
                 {  510 }               Compression  : BYTE;
                 {  511 }               MaxPktLength : LONGINT;
                 {  515 }               SendFormat   : BYTE;
                 {  516 }               LastArchDow  : BYTE;
                 {  517 }               LastArchNr   : BYTE;
                 {  518 }               ExportAKA    : BYTE;
        { ++ 06 }{  519 }               DecodeFiles  : BOOLEAN;
{ next would be at  520 }              );

  { added option}{  416 }          1 : (Compress     : BYTE;
                 {  417 }               CunBatch     : BOOLEAN;
        { -- 06    (418)                BAGbacklink  : STRING[10]; }
{ next would be at  418 }              );

        { ++ 06 }{  416 }          2 : (BAGbacklink  : STRING[10];
        { ++ 06 }{  427 }               BagPath      : STRING[79];
{ next would be at  507 }              );

        { ++ 06 }{  416 }          3 : (SmtpInPath   : STRING[79];
        { ++ 06 }{  496 }               SmtpOutPath  : STRING[79];
{ next would be at  576 }              );
                        END;


{ 0.93.PRE2 }
TYPE UserBase07Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                              { @67 +12 L25 }
    { Changed }  {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
    { --07                    OLD1            : LONGINT; }
                              { @96 +8 L480 }
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     WorldReg        : BOOLEAN;
                 {  118 }     Domains         : ARRAY[1..6] OF STRING[50];

                              CASE INTEGER OF
                 {  424 }          0 : (Address      : FidoAddrType;
                 {  458 }               Sysop        : STRING[50];
                 {  509 }               PacketPwd    : STRING[8];
                 {  518 }               Compression  : BYTE;
                 {  519 }               MaxPktLength : LONGINT;
                 {  523 }               SendFormat   : BYTE;
                 {  524 }               LastArchDow  : BYTE;
                 {  525 }               LastArchNr   : BYTE;
                 {  526 }               ExportAKA    : BYTE;
                 {  527 }               DecodeFiles  : BOOLEAN;
{ next would be at  528 }              );

                 {  424 }          1 : (Compress     : BYTE;
                 {  425 }               CunBatch     : BOOLEAN;
{ next would be at  426 }              );

                 {  424 }          2 : (BAGbacklink  : STRING[10];
                 {  435 }               BagPath      : STRING[79];
{ next would be at  515 }              );

                 {  424 }          3 : (SmtpInPath   : STRING[79];
                 {  504 }               SmtpOutPath  : STRING[79];
{ next would be at  584 }              );
                        END;


{ 0.93.PRE11 }
TYPE UserBase08Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     WorldReg        : BOOLEAN;
                 {  118 }     Domains         : ARRAY[1..6] OF STRING[50];

                              CASE INTEGER OF
                 {  424 }          0 : (Address      : FidoAddrType;
                 {  458 }               Sysop        : STRING[50];
                 {  509 }               PacketPwd    : STRING[8];
                 {  518 }               Compression  : BYTE;
                 {  519 }               MaxPktLength : LONGINT;
                 {  523 }               SendFormat   : BYTE;
                 {  524 }               LastArchDow  : BYTE;
                 {  525 }               LastArchNr   : BYTE;
                 {  526 }               ExportAKA    : BYTE;
                 {  527 }               DecodeFiles  : BOOLEAN;
{ next would be at  528 }              );

                 {  424 }          1 : (Compress     : BYTE;
                 {  425 }               CunBatch     : BOOLEAN;
           {++}  {  426 }               MailGrade    : CHAR;
           {++}  {  427 }               NewsGrade    : CHAR;
           {++}  {  428 }               GigoT        : BOOLEAN;
{ next would be at  429 }              );

                 {  424 }          2 : (BAGbacklink  : STRING[10];
                 {  435 }               BagPath      : STRING[79];
{ next would be at  515 }              );

                 {  424 }          3 : (SmtpInPath   : STRING[79];
                 {  504 }               SmtpOutPath  : STRING[79];
{ next would be at  584 }              );

           {++}  {  424 }          4 : (Pop3File     : STRING[79];
           {++}  {  504 }               Recipient    : STRING[50];
           {++}  {  555 }               Separator    : STRING[15];
           {++}  {  571 }               EnvelopeHdr  : STRING[25];
{ next would be at  597 }              );
                        END;

{ 0.94.PRE4 }
TYPE UserBase09Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                              {@118 -1 L153}
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];
                              {@424 -154 L173}
                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
       {++}      {  374 }               MaxArcLen    : LONGINT;
       {++}      {  378 }               TunnelTo     : STRING[50];
{ next would be at  429 }              );

                 {  270 }          1 : (Compress     : BYTE;
                 {  271 }               CunBatch     : BOOLEAN;
                 {  272 }               MailGrade    : CHAR;
                 {  273 }               NewsGrade    : CHAR;
                 {  274 }               GigoT        : BOOLEAN;
{ next would be at  275 }              );

                 {  270 }          2 : (BAGbacklink  : STRING[10];
                 {  281 }               BagPath      : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath   : STRING[79];
                 {  350 }               SmtpOutPath  : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File     : STRING[79];
                 {  350 }               Recipient    : STRING[50];
                 {  401 }               Separator    : STRING[15];
                 {  417 }               EnvelopeHdr  : STRING[25];
{ next would be at  443 }              );
                        END;

{ 0.94.PRE9 }
TYPE UserBase10Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];
                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
                 {  374 }               MaxArcLen    : LONGINT;
                 {  378 }               TunnelTo     : STRING[50];
          {++}   {  429 }               Notify_F     : BOOLEAN;
{ next would be at  430 }              );

                 {  270 }          1 : (Compress     : BYTE;
                 {  271 }               CunBatch     : BOOLEAN;
                 {  272 }               MailGrade    : CHAR;
                 {  273 }               NewsGrade    : CHAR;
                 {  274 }               GigoT        : BOOLEAN;
          {++}   {  275 }               Notify_U     : BOOLEAN;
{ next would be at  276 }              );

                 {  270 }          2 : (BAGbacklink  : STRING[10];
                 {  281 }               BagPath      : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath   : STRING[79];
                 {  350 }               SmtpOutPath  : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File     : STRING[79];
                 {  350 }               Recipient    : STRING[50];
                 {  401 }               Separator    : STRING[15];
                 {  417 }               EnvelopeHdr  : STRING[25];
{ next would be at  443 }              );
{  note: missing = BBS type!!}
                        END;

{ 0.94.PRE11 }
TYPE UserBase11Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];

                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
                 {  374 }               MaxArcLen    : LONGINT;
                 {  378 }               TunnelTo     : STRING[50];
                 {  429 }               Notify_F     : BOOLEAN;
           {++}  {  430 }               PktFormat    : BYTE;
{ next would be at  431 }              );

                 {  270 }          1 : (Compress     : BYTE;
                 {  271 }               CunBatch     : BOOLEAN;
                 {  272 }               MailGrade    : CHAR;
                 {  273 }               NewsGrade    : CHAR;
                 {  274 }               GigoT        : BOOLEAN;
                 {  275 }               Notify_U     : BOOLEAN;
{ next would be at  276 }              );

                 {  270 }          2 : (BAGbacklink  : STRING[10];
                 {  281 }               BagPath      : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath   : STRING[79];
                 {  350 }               SmtpOutPath  : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File     : STRING[79];
                 {  350 }               Recipient    : STRING[50];
                 {  401 }               Separator    : STRING[15];
                 {  417 }               EnvelopeHdr  : STRING[25];
{ next would be at  443 }              );

                 {  270 }          5 : (Inbound      : STRING[79];
                 {  350 }               Outbound     : STRING[79];
                 {  430 }               SystemAKA    : BYTE; { 1..MaxAkas }
                 {  431 }               FakeZone     : WORD;
                 {  433 }               FakeNet      : WORD;
                 {  435 }               FakeNode     : WORD;
                 {  437 }               InboundExt   : STRING[3];
                 {  441 }               KeepSBP      : BOOLEAN;
                 {  442 }               Reserved1    : BYTE;
{ next would be at  443 }              );
                        END;


{ 0.94.PRE30 }
TYPE UserBase12Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];

                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
                 {  374 }               MaxArcLen    : LONGINT;
                 {  378 }               TunnelTo     : STRING[50];
                 {  429 }               Notify_F     : BOOLEAN;
                 {  430 }               PktFormat    : BYTE;
           {++}  {  431 }               NodeOutDir   : STRING[79];
{ next would be at  511 }              );

                 {  270 }          1 : (Compress  : BYTE;
                 {  271 }               CunBatch  : BOOLEAN;
                 {  272 }               MailGrade : CHAR;
                 {  273 }               NewsGrade : CHAR;
                 {  274 }               GigoT     : BOOLEAN;
                 {  275 }               Notify_U  : BOOLEAN;
{ next would be at  276 }              );

                 {  270 }          2 : (BAGbacklink : STRING[10];
                 {  281 }               BagPath     : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath  : STRING[79];
                 {  350 }               SmtpOutPath : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File        : STRING[79];
                 {  350 }               Pop3Recipient   : STRING[50];
                 {  401 }               Pop3Separator   : STRING[15];
                 {  417 }               Pop3EnvelopeHdr : STRING[25];
{ next would be at  443 }              );

                 {  270 }          5 : (Inbound    : STRING[79];
                 {  350 }               Outbound   : STRING[79];
                 {  430 }               SystemAKA  : BYTE; { 1..MaxAkas }
                 {  431 }               FakeZone   : WORD;
                 {  433 }               FakeNet    : WORD;
                 {  435 }               FakeNode   : WORD;
                 {  437 }               InboundExt : STRING[3];
                 {  441 }               KeepSBP    : BOOLEAN;
                 {  442 }               Reserved1  : BYTE;
{ next would be at  443 }              );

                 {  270 }          6 : (SoupInPath      : STRING[79];
                 {  350 }               SoupOutPath     : STRING[79];
       {++}      {  430 }               SoupEnvelopeHdr : STRING[25];
       {++}      {  456 }               SoupRecipient   : STRING[50];
{ next would be at  507 }              );
                        END;

{ 0.94.PRE35 }
TYPE UserBase13Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];

                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
                 {  374 }               MaxArcLen    : LONGINT;
                 {  378 }               TunnelTo     : STRING[50];
                 {  429 }               Notify_F     : BOOLEAN;
                 {  430 }               PktFormat    : BYTE;
                 {  431 }               NodeOutDir   : STRING[79];
{ next would be at  511 }              );

                 {  270 }          1 : (Compress  : BYTE;
                 {  271 }               CunBatch  : BOOLEAN;
                 {  272 }               MailGrade : CHAR;
                 {  273 }               NewsGrade : CHAR;
                 {  274 }               GigoT     : BOOLEAN;
                 {  275 }               Notify_U  : BOOLEAN;
{ next would be at  276 }              );

                 {  270 }          2 : (BAGbacklink : STRING[10];
                 {  281 }               BagPath     : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath  : STRING[79];
                 {  350 }               SmtpOutPath : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File        : STRING[79];
                 {  350 }               Pop3Recipient   : STRING[50];
                 {  401 }               Pop3Separator   : STRING[15];
                 {  417 }               Pop3EnvelopeHdr : STRING[25];
{ next would be at  443 }              );

                 {  270 }          5 : (Inbound    : STRING[79];
                 {  350 }               Outbound   : STRING[79];
                 {  430 }               SystemAKA  : BYTE; { 1..MaxAkas }
                 {  431 }               FakeZone   : WORD;
                 {  433 }               FakeNet    : WORD;
                 {  435 }               FakeNode   : WORD;
                 {  437 }               InboundExt : STRING[3];
                 {  441 }               KeepSBP    : BOOLEAN;
                 {  442 }               Reserved1  : BYTE;
{ next would be at  443 }              );

                 {  270 }          6 : (SoupInPath      : STRING[79];
                 {  350 }               SoupOutPath     : STRING[79];
                 {  430 }               SoupEnvelopeHdr : STRING[25];
                 {  456 }               SoupRecipient   : STRING[50];
      {++}       {  507 }               UsingWGSOUP     : BOOLEAN;
{ next would be at  508 }              );
               END;

{ 0.94.PRE35 (two updates in one version) }
TYPE UserBase14Record = RECORD
  { starts at byte    0 }     Deleted         : BOOLEAN;
                 {    1 }     System          : BYTE;
                 {    2 }     Organization    : STRING[60];
                 {   63 }     Groups          : ARRAY[1..16] OF BYTE;
                 {   79 }     Passive         : BOOLEAN;
                 {   80 }     AreaFixPwd      : STRING[20];
                 {  101 }     AllowFrom       : BOOLEAN;
                 {  102 }     AllowCreate     : BOOLEAN;
                 {  103 }     AllowSubDomains : BOOLEAN;
                 {  104 }     AreaList        : WORD;
                 {  106 }     UUCPName        : STRING[10];
                 {  117 }     Domains         : ARRAY[1..3] OF STRING[50];

                              CASE INTEGER OF
                 {  270 }          0 : (Address      : FidoAddrType;
                 {  304 }               Sysop        : STRING[50];
                 {  355 }               PacketPwd    : STRING[8];
                 {  364 }               Compression  : BYTE;
                 {  365 }               MaxPktLength : LONGINT;
                 {  369 }               SendFormat   : BYTE;
                 {  370 }               LastArchDow  : BYTE;
                 {  371 }               LastArchNr   : BYTE;
                 {  372 }               ExportAKA    : BYTE;
                 {  373 }               DecodeFiles  : BOOLEAN;
                 {  374 }               MaxArcLen    : LONGINT;
                 {  378 }               TunnelTo     : STRING[50];
                 {  429 }               Notify_F     : BOOLEAN;
                 {  430 }               PktFormat    : BYTE;
                 {  431 }               NodeOutDir   : STRING[79];
{ next would be at  511 }              );

                 {  270 }          1 : (Compress  : BYTE;
                 {  271 }               CunBatch  : BOOLEAN;
                 {  272 }               MailGrade : CHAR;
                 {  273 }               NewsGrade : CHAR;
                 {  274 }               GigoT     : BOOLEAN;
                 {  275 }               Notify_U  : BOOLEAN;
{ next would be at  276 }              );

                 {  270 }          2 : (BAGbacklink : STRING[10];
                 {  281 }               BagPath     : STRING[79];
{ next would be at  361 }              );

                 {  270 }          3 : (SmtpInPath  : STRING[79];
                 {  350 }               SmtpOutPath : STRING[79];
{ next would be at  430 }              );

                 {  270 }          4 : (Pop3File        : STRING[79];
                 {  350 }               Pop3Recipient   : STRING[50];
                 {  401 }               Pop3Separator   : STRING[15];
                 {  417 }               Pop3EnvelopeHdr : STRING[25];
{ next would be at  443 }              );

                 {  270 }          5 : (Inbound    : STRING[79];
                 {  350 }               Outbound   : STRING[79];
                 {  430 }               SystemAKA  : BYTE; { 1..MaxAkas }
                 {  431 }               FakeZone   : WORD;
                 {  433 }               FakeNet    : WORD;
                 {  435 }               FakeNode   : WORD;
                 {  437 }               InboundExt : STRING[3];
                 {  441 }               KeepSBP    : BOOLEAN;
                 {  442 }               Reserved1  : BYTE;
{ next would be at  443 }              );

                 {  270 }          6 : (SoupInPath      : STRING[79];
                 {  350 }               SoupOutPath     : STRING[79];
                 {  430 }               SoupEnvelopeHdr : STRING[25];
                 {  456 }               SoupRecipient   : STRING[50];
                 {  507 }               UsingWGSOUP     : BOOLEAN;
{ next would be at  508 }              );

        {++}     {  270 }          7 : (InetMailQueue   : STRING[79];
        {++}     {  350 }               InetMailSourceDomain: STRING[50];
{ next would be at  401 }              );
                        END;

PROCEDURE UpgradeUserBase (VAR Rec; VAR Version : BYTE);

CONST Database_UserBase : DatabaseRecord =
       (Filename : 'USERBASE';
        Proc     : UpgradeUserbase;
        Header   : 'WtrGate UserBase ';
        Oldest   : 4;
        Latest   : 14;
        RecSizes : (0, { 01 }
                    0, { 02 }
                    0, { 03 }
                    SizeOf (UserBase04Record),
                    SizeOf (UserBase05Record),
                    SizeOf (UserBase06Record),
                    SizeOf (UserBase07Record),
                    SizeOf (UserBase08Record),
                    SizeOf (UserBase09Record),
                    SizeOf (UserBase10Record),
                    SizeOf (UserBase11Record),
                    SizeOf (UserBase12Record),
                    SizeOf (UserBase13Record),
                    SizeOf (UserBase14Record),
                    0, { 15 }
                    0, { 16 }
                    0, { 17 }
                    0, { 18 }
                    0, { 19 }
                    0, { 20 }
                    0, { 21 }
                    0, { 22 }
                    0, { 23 }
                    0, { 24 }
                    0, { 25 }
                    0, { 26 }
                    0, { 27 }
                    0, { 28 }
                    0, { 29 }
                    0, { 30 }
                    0, { 31 }
                    0, { 32 }
                    0, { 33 }
                    0, { 34 }
                    0, { 35 }
                    0, { 36 }
                    0, { 37 }
                    0, { 38 }
                    0, { 39 }
                    0  { 40 }
               )
       );

IMPLEMENTATION

USES Ramon;


{--------------------------------------------------------------------------}
{ UpgradeUserBase                                                          }
{                                                                          }
{ Deze routine upgrade een UserBase record.                                }
{                                                                          }
PROCEDURE UpgradeUserBase (VAR Rec; VAR Version : BYTE);

VAR Lp : BYTE;
    S  : BYTE;

BEGIN
     IF (Version = 4) THEN
     BEGIN
          { 04 -> 05

            FIDO: export AKA is nieuw; op 0 zetten.
            Is al gedaan door record initialisatie (veld is aan einde record)
          }

          Version:=5;
     END;

     IF (Version = 5) THEN
     BEGIN
          { 05 -> 06

            SMTP erbij: heeft niemand, dus geen actie.
            BAG erbij:  BagBackLink verplaats, BagPath toegevoegd
            FIDO:       DecodeFiles toegevoegd, op FALSE zetten (is automatisch)

            RAR compressie toegevoegd: verhogen als Compress > ZOO
          }

          WITH UserBase06Record (Rec) DO
          BEGIN
               IF (System = 2{_B}) THEN
               BEGIN
                    BagBackLink:=UserBase05Record (Rec).BagBackLink;
                    BagPath:='';
               END;

               { RWI 960822: was "compress", which is a UUCP user field ;( }
               IF (System = 0{_F}) AND (Compression > 5{ZOO}) THEN
                  Inc (Compression);
          END;

          Version:=6;
     END;


     IF (Version = 6) THEN
     BEGIN
          { 06 -> 07

            GroupFlags uitgebreid
            - schuif andere velden op
            - wis oude ongebruikte bits
            - wis nieuwe bits

            OLD1 veld verwijderd
          }

          { @96 +8 L480 }
          Move (BA(Rec)[96],BA(Rec)[96+8],480);

          { @67 +12 L25 }
          Move (BA(Rec)[67],BA(Rec)[67+12],25);

          { ongebruikte bits in oude groups verwijderen }
          BA(Rec)[63+3]:=BA(Rec)[63+3] AND 3;

          { nieuwe bits in groups veld verwijderen }
          FOR Lp:=4 TO 15 DO
              BA(Rec)[63+Lp]:=0;

          Version:=7;
     END;

     IF (Version = 7) THEN
     BEGIN
          { 07 -> 08

            Added POP3 style user, which makes the entire record
            a little bit longer. All set to zeros already.
            Emptying EnvelopeHdr.

            Added mailgrade, newsgrade and GigoT to UUCP record;
            setting to default values.

          }

          WITH UserBase08Record (Rec) DO
          BEGIN
               IF (System = 1{_U}) THEN
               BEGIN
                    MailGrade:='A';
                    NewsGrade:='Z';
                    GigoT:=FALSE;
               END;

               IF (System = 4{_P}) THEN
               BEGIN
                    EnvelopeHdr:='';
               END;
          END; { with }

          Version:=8;
     END;

     IF (Version = 8) THEN
     BEGIN
          { 08 -> 09

            Removed WorldReg field
            Reduced Domains from 6 to 3
            Added MaxArcLen for _F
            Added TunnelTo for _F

          }

          { optimize all domains into the first three }
          S:=1;
          WITH UserBase08Record (Rec) DO
               FOR Lp:=1 TO 6 DO
                   IF (DeleteBackSpaces (Domains[Lp]) <> '') THEN
                      IF (S = 4) THEN
                         WriteLn ('Removing domain: ',Domains[Lp])
                      ELSE BEGIN
                           Domains[S]:=Domains[Lp];
                           Inc (S);
                      END;

          {@118 -1 L153}
          Move (BA(Rec)[118],BA(Rec)[117],153);

          {@424 -154 L173}
          Move (BA(Rec)[424],BA(Rec)[270],173);

          { initialise new fields }
          WITH UserBase09Record (Rec) DO
               IF (System = 0{_F}) THEN
               BEGIN
                    MaxArcLen:=0;
                    TunnelTo:=Spaces (50);
                    TunnelTo:='';
               END;

          Version:=9;
     END;

     IF (Version = 9) THEN
     BEGIN
          { 09 -> 10

            Added Notify_F and Notify_U
            Added BBS Interface (no change in structure size)

          }

          WITH UserBase12Record (Rec) DO
               IF (System = 0{_F}) THEN
                  Notify_F:=FALSE
               ELSE
                   IF (System = 1{_U}) THEN
                      Notify_U:=FALSE;

          Version:=10;
     END;

     IF (Version = 10) THEN
     BEGIN
          { 10 -> 11

            Added PktFormat

          }

          WITH UserBase12Record(Rec) DO
               IF (System = 0{FNT}) THEN  {RAWI981022: added!!}
                  PktFormat:=0;

          Version:=11;
     END;

     IF (Version = 11) THEN
     BEGIN
          { 11 -> 12

            Added SoupEnvelopeHdr (_SOUP)
            Added SoupRecipient (_SOUP)
            Added NodeOut (_FTN)

          }
          WITH UserBase12Record (Rec) DO
          BEGIN
               IF (System = 6{SOUP}) THEN
               BEGIN
                    { existing record, must be created with pre-sw }
                    { just initialise the fields we added now }
                    SoupEnvelopeHdr:='';
                    SoupRecipient:='';
               END;

               IF (System = 0{FTN}) THEN
                  NodeOutDir:='';
          END; { with }

          Version:=12;
     END;

     IF (Version = 12) THEN
     BEGIN
          { 12 -> 13

            Added UsingWGSOUP (_SOUP)

          }
          WITH UserBase13Record (Rec) DO
          BEGIN
               IF (System = 6{SOUP}) THEN
               BEGIN
                    UsingWGSOUP := TRUE;
               END;
          END; { with }

          Version:=13;
     END;

     IF (Version = 13) THEN
     BEGIN
          { 13 -> 14

            Added InetMailQueue and InetMailSourceDomain
          }

          { Don't have do anything because there can't be any records of   }
          { this type.                                                     }

          Version := 14;
     END;
END;


END.
