{ Startup WtrGate                                                       }
{                                                                       }
{ Deze routine controleerd of de configuratie file in orde is, en of    }
{ er genoeg geheugen is om door te gaan.                                }

{ Include file voor WtrGate.PAS and WtrTest.PAS }

{ RWI 950524: was 200000. Omlaag gehaald omdat we nu een swapfile hebben }
{ RWI 961012: was 120000. Omlaag gehaald omdat we nu een beter met ons   }
{                         geheugen om gaan en makkelijk met 80kb uit de  }
{                         voeten kunnen.                                 }
{ RAWI 990110: was 80000. Reduced even more.                             }
CONST MemNeeded = LONGINT(70000);

{ functie om bestaan directory te controleren }
FUNCTION DirExist (Dir : STRING) : BOOLEAN;

VAR FindFile : SearchRec;
    DosErr   : INTEGER;

BEGIN
     DirExist:=FALSE;

     IF (Dir[Length(Dir)] = '\') THEN
        Dec (Dir[0]);

     IF (Copy (Dir,1,2) <> '\\') THEN
        IF (DiskFree (Ord (UpCase (Dir[1]))-64) = -1) THEN
           Exit;

     IF (Length (Dir) > 3) THEN
     BEGIN
          FindFirst (Dir,saDirAndFiles,FindFile);
          DosErr:=DosError;
          FindClose (FindFile);

          IF (DosErr <> 0) THEN
             Exit;
     END;

     DirExist:=TRUE;
END;

{--------------------------------------------------------------------------}
{ SmartHostConfiguredOK                                                    }
{                                                                          }
{ This routine checks that the configured smart host exists in the user    }
{ base. If not, FALSE is returned. When no smart host is configured this   }
{ function returns TRUE.                                                   }
{                                                                          }
FUNCTION SmartHostConfiguredOK : BOOLEAN;

VAR UserLp  : UserBaseRecordNrType;
    UserRec : UserBaseRecord;

BEGIN
     SmartHostConfiguredOK:=TRUE; { assume it exists }
     SmartHostUserRecNr:=NILRecordNr;

     Config.Smarthost:=DeleteFrontAndBackSpaces (Config.Smarthost);

     IF (Config.Smarthost = '') THEN
        Exit;

     FindUserBaseRecordByUUCPName (Config.SmartHost,SmartHostUserRecNr);

     IF (SmartHostUserRecNr = NILRecordNr) THEN
        SmartHostConfiguredOK:=FALSE;  { not configured properly }
END;

{--------------------------------------------------------------------------}
{ StartUpWtrGate                                                           }
{                                                                          }
FUNCTION StartUpWtrGate : BOOLEAN;

VAR LoopVar : WORD;

BEGIN
     StartUpWtrGate:=TRUE; { assume ok }

     WITH Config DO
     BEGIN
          { controleer of de systeem directory wel bestaat }
          IF (NOT DirExist (SystemDir)) THEN
          BEGIN
               WriteLn (' # Unable to find System directory! ('+SystemDir+')');
               StartUpWtrGate:=FALSE;
          END;

          IF (Fido2Str (Config.NodeNrs[1]) = '0') THEN
          BEGIN
               WriteLn (' # Primary FTN system node number is not defined!');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de TooLarge directory wel bestaat }
          IF (NOT DirExist (TooLargePath)) THEN
          BEGIN
               WriteLn (' # Directory for too big messages does not exist! ('+TooLargePath+')');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de Inbound directory's wel bestaan }
          FOR LoopVar:=1 TO MaxInboundDirs DO
              IF (DeleteBackSpaces (Inbound_F[LoopVar]) <> '') THEN
                 IF (NOT DirExist (Inbound_F[LoopVar])) THEN
                 BEGIN
                      WriteLn (' # FTN inbound does not exist! ('+Inbound_F[LoopVar]+')');
                      StartUpWtrGate:=FALSE;
                 END;

          { Controleer of de Outbound directory wel bestaat }
          IF (NOT DirExist (Outbound_F)) THEN
          BEGIN
               WriteLn (' # FTN outbound directory does not exist! ('+Outbound_F+')');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de spool base directory wel bestaat }
          IF (SpoolBaseDir <> '') THEN
             IF (NOT DirExist (SpoolBaseDir)) THEN
             BEGIN
                  WriteLn (' # UUCP spool directory does not exist! ('+SpoolBaseDir+')');
                  StartUpWtrGate:=FALSE;
             END;

          { check that the configured smarthost exists }
          IF (NOT SmartHostConfiguredOK) THEN
          BEGIN
               WriteLn (' # Could not find configured smart host (',Config.Smarthost,') in user/link definitions');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of er wel een TimeZone string is }
          { non-fatal error                             }
          IF (DeleteBackSpaces (TimeZone) = '') THEN
             TimeZone:='GMT';

     END; { with }
END;

{ end of include file WTRSTART.PAS }
