{ -------------------------------------------------- }
{ ListServ.Inc                                       }
{                                                    }
{ This file contains the structure definitions of    }
{ the WaterGate List Server Information Base.        }
{                                                    }
{ (c) 1994 WaterLine Software Development            }


{$IFNDEF Wtr_ListServer}
{$DEFINE Wtr_ListServer}

{$I Globals.Inc}

TYPE ListSystemType = (lstName,lstFido,lstUsenet,lstEcho);
     ListNameType   = STRING[MaxLenListNameType];
     ListPswdType   = STRING[MaxLenListPswdType];

     ListServerRecord     = RECORD
                            Deleted     : Boolean;
                            ListSystem  : ListSystemType;
                            NextUser    : ListServerRecordNrType;

                            CASE INTEGER OF
                            {ServerInfo}   0 : (
                                                ListName        : ListNameType;
                                                ListDescription : STRING[40];
                                                ListWelcome     : STRING[79];
                                                ListAKA         : BYTE;
                                                AllowRemote     : Boolean;
                                                AllowKnown      : Boolean;
                                                Active          : Boolean;
                                                AreaName        : STRING[MaxLenAreaName];
                                                EchoList        : Boolean; { From list to echo }
                                                ListEcho        : Boolean; { From echo to list }
                                               );
                            {Fido}         1 : (
                                                Address : FidoAddrType;
                                                Name    : STRING[MaxLenSysopName];
                                               );
                            {Usenet}       2 : (
                                                Domain  : STRING[MaxLenDomain];
                                               );

                           END;

{$ENDIF}
