PROGRAM WTR2PB;

{$X+}

{ WaterGate to ProBoard 1.31                                                }
{                                                                           }
{ File    : WTR2PB.PAS                                                      }
{ Compiler: Turbo Pascal v7.00                                              }
{ Date    : 19/03/1994                                                      }
{ Version : 1.01                                                            }
{                                                                           }
{ This program exports all active areas in the WaterGate configuration to   }
{ a file that ProBoard can read. The program searches for the WaterGate     }
{ configuration in its current directory, or the directory set by the       }
{ WTRGATE enviroment variable.                                              }
{                                                                           }
{ Usage:                                                                    }
{                                                                           }
{ WTR2PB <outputfile>                                                       }
{                                                                           }
{ ProBoard 1.31 is a Bulletin Board Program                                 }
{ Copyrighted 1990-1993 by Philippe Leybaert                                }


{ WaterGate is copyrighted 1993,94 by Waterline Software Development        }
{ "WtrFunc" contains some basic functions to access the configuration       }

USES WtrFunc,Dos,Strings;

CONST MaxPBAreas = 10000;


{ ProBoard Message Area structure                                           }

TYPE PBMSGLIST = RECORD
                   AreaNum    : Integer;                 { # of message area (1-10000)                 }
                   Name       : Array [1..31] OF Char;   { Name of message areas                       }
                   MsgType,                              { Type of messages                            }
                   MsgKind,                              { Kind of message area                        }
                   MsgBaseType: Byte;                    { 0 = hudson , 1 = squish , 2 = *.MSG         }
                   Path       : Array [1..80] OF Char;   { Path/Directory for Squish{.MSG              }
                   Flags      : Byte;                    { Alias allowed/forced/prohibited             }
                   ReadLevel  : Word;                    { Minimum level needed to read msgs           }
                   ReadFlags  : Longint;                 { flags needed to read msgs                   }
                   WriteLevel : Word;                    { Minimum level needed to write msgs          }
                   WriteFlags : Longint;                 { flags needed to write msgs                  }
                   SysopLevel : Word;                    { Minimum level needed to change msgs         }
                   SysopFlags : Longint;                 { flags needed to change msgs                 }
                   Origin     : Array [1..62] OF Char;   { Origin line                                 }
                   Aka,                                  { AKA                                         }
                   RcvKillDays,                          { Kill received after xx days                 }
                   MsgKillDays: Integer;                 { Kill after xx days                          }
                   MaxMsg     : Integer;                 { Max # msgs                                  }
                   Sysop      : Array [1..36] OF Char;   { Area Sysop                                  }
                   ReplyBoard : Integer;                 { Reply area # (0=here)                       }
                   EchoTag    : Array [1..21] OF Char;   { Echomail Tag Name                           }
                   QwkTag     : Array [1..13] OF Char;   { QWK Area Name                               }
                   Extra      : Array [1..23] OF Char;
                 END;


{ -------------------------------------------------------------------------- }
{ ShowInfo                                                                   }
{                                                                            }
{ Show the program startup message                                           }

PROCEDURE ShowInfo;
BEGIN
 Writeln('Wtr2Pb');
 Writeln('Waterline Software Dev. 1994');
 Writeln;
END;

{ -------------------------------------------------------------------------- }
{ ShowHelp                                                                   }
{                                                                            }
{ Show a little information on how to use this program                       }

PROCEDURE ShowHelp;
BEGIN
 Writeln('Usage:');
 Writeln;
 Writeln('WTR2PB <Export.File>');
 Writeln;
 Writeln('This will write a ProBoard MsgAreas compatible configuration');
 Writeln('file to disk, containing all areas defined in WtrGate.');
 Writeln('You probably want to name it "MSGAREAS.PB". If a file with');
 Writeln('this name already exists, then the new entry''s are appended');
 Writeln('to it.');
 Writeln;
END;


{ -------------------------------------------------------------------------- }
{ FileExist                                                                  }
{                                                                            }
{ Simple function to check if a given filename exists.                       }

FUNCTION FileExist( Filename : String ) : Boolean;
VAR Search : SearchRec;
BEGIN
 FindFirst( FileName , $3C , Search );
 FileExist := (DosError = 0);
END;


VAR AreaCounter,
    AreaLimit,
    NumAreas     : Longint;
    AreaData     : AreaBaseRecord;
    AreaBaseFile : FILE;
    Config       : ConfigRecord;
    ProMsgRec    : PBMSGLIST;
    ProMsgFile   : FILE;
    ProConfigName: STRING;

BEGIN

  { Show program information         }
  ShowInfo;

  { Look for the output filename     }

  ProConfigName := ParamStr(1);

  IF ProConfigName = '' THEN
   BEGIN
   ShowHelp;
   Halt(1);
   END;

  { Read the WaterGate configuration }

  IF NOT ReadConfiguration( Config ) THEN
   BEGIN
   Writeln('Fatal: Error opening WaterGate configuration files');
   Halt (1);
   END;

  { Try to open the Areabase         }

  IF NOT OpenAreaBase( AreaBaseFile ) THEN
   BEGIN
   Writeln('Error! Unable to open WaterGate Area Base !');
   Halt(1);
   END;

  { Retrieve the total number of Areabase records                    }

  NumAreas := AreaBaseRecordCount( AreaBaseFile );

  { Open the export file for output, Append if a file with the given }
  { name already exists, Rewrite for a new file.                     }

  IF FileExist( ProConfigName ) THEN
   BEGIN
   {$I-} Assign( ProMsgFile , ProConfigName);   { Append }
   Reset( ProMsgFile , 1 );

   IF IoResult>0 THEN
    BEGIN
    Writeln( 'Error while appending to : ' + ProConfigName );
    Halt(1);
    END;

   Seek( ProMsgFile, FileSize( ProMsgFile )); {$I+}
   Writeln('Appending to existing file..');
   END
  ELSE
   BEGIN
   {$I-} Assign( ProMsgFile , ProConfigName);  { Rewrite }
   Rewrite( ProMsgFile , 1 ); {$I+}

   IF IoResult>0 THEN
    BEGIN
    Writeln( 'Error while creating : ' + ProConfigName );
    Halt(1);
    END;

   Writeln('Creating new file..');
   END;

  IF IoResult > 0 THEN
   BEGIN
   Writeln('Fatal: Unable to open "',ProConfigName,'" for output.');
   Halt(1);
   END;


  { Set the maximum PB area counter at the number of boards       }
  { currently defined.                                            }

  AreaLimit := FileSize( ProMsgFile ) DIV SizeOf( PBMSGLIST );

  { Walk through every record in the configuration file,          }
  { and append it to the ProBoard output file.                    }

  FOR AreaCounter := 1 TO NumAreas DO
   BEGIN
   ReadAreaBaseRecord( AreaBaseFile, AreaData , AreaCounter );

   { Show that we are still alive                                 }
   Write( 'Area: ' , AreaCounter , #13 );


   { If we found a not deleted Squish or Fido *.MSG area, then    }
   { fill in a blank ProBoard record and write it to disk.        }

   IF (NOT AreaData.Deleted) AND (AreaData.FidoMsgStyle IN [FidoMsgType,SquishType]) THEN
   BEGIN

    WITH ProMsgRec , AreaData DO
     BEGIN
     Inc( AreaLimit );

     IF Length( AreaName_F ) > 30 THEN      { Cut off to long area names }
      AreaName_F[0] := #30;

     StrPCopy( @Name , AreaName_F );        { Pascal to C '\0' strings   }

     MsgType := 2;                        { Public                     }
     MsgKind := 2;                        { Echo                       }

     CASE FidoMsgStyle OF
      SquishType : MsgBaseType := 1;      { Squish Base                }
      FidoMsgType: MsgBaseType := 2;      { Fido *.MSG Base            }
     END;

     StrPCopy( @Path , FidoMsgPath );     { Pascal to C '\0' strings   }

     Flags     := 0;
     ReadLevel := 0;
     ReadFlags := 0;
     WriteLevel:= 0;
     WriteFlags:= 0;
     SysopLevel:= 0;
     SysopFlags:= 0;

     IF OriginNr = 0 THEN
      StrPCopy( @ProMsgRec.Origin, AreaData.Origin)
     ELSE
      StrPCopy( @ProMsgRec.Origin, Config.Origins[ AreaData.OriginNr ] );

     Aka         := 0;
     RcvKillDays := FidoMsgAge;
     MsgKillDays := FidoMsgAge;
     MaxMsg      := FidoMsgLimit;
     Sysop[1]    := #0;
     ReplyBoard  := 0;
     QwkTag[1]   := #0;
     Extra[1]    := #0;

     IF Length( AreaName_F ) > 21 THEN
      Byte(AreaData.AreaName_F[0]) := 21;

     StrPCopy( @EchoTag, AreaName_F );

     { Write Area information to Disk                                  }
     {$I-} BlockWrite( ProMsgFile , ProMsgRec , Sizeof( ProMsgRec )); {$I+}

     IF IoResult > 0 THEN
      BEGIN
      Writeln('Error! Export configuration disk write error');
      Halt(1);
      END;

    END; { WITH }
  END; { IF }

  { Check if we reach the magical boundry of 10,000 areas in the ProBoard }
  { configuration file.                                                   }

  IF AreaLimit = MaxPBAreas THEN
   BEGIN
   Writeln( 'Warning ! Maximum number of areas to store in Proboard config reached !');
   Break;
   END;

 END; { WHILE }

 { Close all open files }

 CloseAreaBase( AreaBaseFile );
 Close( ProMsgFile );

 Writeln;
 Writeln( 'Finished !');

END.
