PROGRAM FromPop3;

USES Ramon;

VAR InFile   : TEXT;
    RestFile : TEXT;
    OutFile  : TEXT;
    IORes    : BYTE;
    Regel    : STRING;
    Common,
    Special  : STRING[80];
    Extract  : BOOLEAN;
    Apped    : BOOLEAN;

    CommonCount,
    OutCount    : WORD;

BEGIN
     WriteLn ('FromPop3 v1.00 - 970406');
     WriteLn ('Copyright (c) 1997 WaterLine Software Development');
     WriteLn ('Written by Ramon van der Winkel - ramon@wsd.wline.se');
     WriteLn;

     IF (ParamCount <> 4) THEN
     BEGIN
          WriteLn ('Usage: frompop3 <mailbox> <common separator> <special separator> <output>');
          WriteLn;
          WriteLn ('Separators can be found on the same line that starts with "From ".');
          WriteLn ('The <common separator> can be found on all separator lines in the');
          WriteLn ('mailbox file, while the <special separator> indicates the start of');
          WriteLn ('a message you want to extract. From that point until the next');
          WriteLn ('separator is written to the output file.');
          WriteLn;
          WriteLn ('Messages are extracted from the original mailbox file.');
          WriteLn ('Messages are appended to an already existing <output>');
          WriteLn;
          WriteLn ('Example: frompop3 island.txt POP3@ POP3@atlas.iobbs.com atlas.txt');
          WriteLn;
          Halt (1);
     END;

     Assign (InFile,ParamStr (1));
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes IN [2,3]) THEN
             WriteLn (' Cannot find '+ParamStr (1)+' (error ',IORes,')',#7)
          ELSE
              WriteLn (' Cannot open '+ParamStr (1)+' (error ',IORes,')',#7);

          Halt (1);
     END;

     Assign (RestFile,'frompop3.tmp');
     {$I-} ReWrite (RestFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (' Cannot create temporary file frompop3.tmp (error ',IORes,')',#7);
          Close (InFile);
          Halt (1);
     END;

     Apped:=TRUE;

     Assign (OutFile,ParamStr (4));
     {$I-} Append (OutFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
          Apped:=FALSE;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (' Cannot create/append to ',ParamStr (4),' (error ',IORes,')',#7);
          Close (RestFile);
          Close (InFile);
          Halt (1);
     END;

     Common:=ParamStr (2);
     Special:=ParamStr (3);

     OutCount:=0;
     CommonCount:=0;

     Extract:=FALSE;

     WriteLn ('Reading from ',ParamStr (1));
     IF Apped THEN
        Write ('Append')
     ELSE
         Write ('Writ');

     WriteLn ('ing to ',ParamStr (4));

     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF (UpCaseString (Copy (Regel,1,5)) = 'FROM ') THEN
          BEGIN
               IF (Pos (Common,Regel) > 0) THEN
               BEGIN
                    Inc (CommonCount);
                    Extract:=FALSE;
               END;

               IF (Pos (Special,Regel) > 0) THEN
               BEGIN
                    Inc (OutCount);
                    Extract:=TRUE;
               END;
          END;

          IF Extract THEN
             WriteLn (OutFile,Regel)
          ELSE
              WriteLn (RestFile,Regel);
     END; { while }

     WriteLn;
     WriteLn ('Extracted ',OutCount,' messages');
     WriteLn ('Kept ',CommonCount-OutCount,' messages');
     WriteLn;

     Close (OutFile);
     Close (RestFile);
     Close (InFile);

     {$I-} Erase (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        WriteLn (' Failed to remove '+ParamStr (1)+' (error ',IORes,')')
     ELSE BEGIN
          {$I-} Rename (RestFile,ParamStr (1)); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             WriteLn (' Failed to rename frompop3.tmp to '+ParamStr (1)+' (error ',IORes,')');
     END;

     WriteLn ('Program finished');
END.
