PROGRAM TGUsers;

{ this program exports a tgusers.txt file with all users in a Telegard }
{ 3.00 users.idx file. Note that deleted and locked out users are      }
{ included as well, as only the index is processed. Have not found a   }
{ use to include the user number since JAM/Squish is used only.        }

TYPE UserIndexRecord = RECORD
                             Name   : STRING[36];
                             Number : INTEGER;
                       END;

VAR InFile     : FILE;
    OutFile    : TEXT;
    IORes      : BYTE;
    Count      : WORD;
    UserIdxRec : UserIndexRecord;

BEGIN
     WriteLn ('TGUsers v1.00 - 970825');
     WriteLn ('Written by Ramon van der Winkel, ramon@wsd.wline.se');
     WriteLn;

     IF (ParamCount = 0) THEN
     BEGIN
          WriteLn ('Exports a tgusers.txt file with all user names');
          WriteLn ('for use by WaterGate''s "bbsusers" features.');
          WriteLn;
          WriteLn ('Usage: tgusers <path to users.idx file>');
          WriteLn ('Example: tgusers c:\tg\users.idx');
          WriteLn;
          WriteLn ('The tgusers.txt file is created in the current');
          WriteLn ('directory - probaly the WaterGate system directory.');
          WriteLn;
          Halt;
     END;

     Assign (InFile,ParamStr (1));
     {$I-} Reset (InFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Failed to open USERS.IDX (error ',IORes,')');
          { in case of sharing violations: tgusers.txt not overwritten }
          Halt;
     END;

     Assign (OutFile,'tgusers.txt');
     {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Failed to create tgusers.txt');
          Close (InFile);
          Halt;
     END;

     Count:=0;

     WHILE (FilePos (InFile) < FileSize (InFile)) DO
     BEGIN
          BlockRead (InFile,UserIdxRec,SizeOf (UserIndexRecord));

          { not in documentation - but assumed not a user }
          IF (Count = 0) AND (UserIdxRec.Name = 'Sorted Records') THEN
             Continue; { skip }

          WriteLn (OutFile,UserIdxRec.Name);
          Inc (Count);
     END; { while }

     WriteLn ('Exported ',Count,' user names to tgusers.txt');

     Close (InFile);
     Close (OutFile);
END.

