#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdarg.h>
#include <string.h>
#include <getopt.h>
#include <time.h>

#include <smapi/msgapi.h>

#include "qwk.h"
#include "cfg.h"
#include "rep.h"
#include "yaqn.h"


void logger (char *fmt, ...)
{
	va_list argptr;
	FILE *fptr;
	time_t t;
	struct tm *tm;
	char buffer[512],datestr[81],buf2[512];

	va_start(argptr, fmt);
	vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	printf("\n\r%s",buffer);
	if(!strlen(conf.logfile))	return;

	t=time(NULL);
	tm=localtime(&t);
	strftime(datestr,81,"%Y/%m/%d %H:%M:%S",tm);	
	sprintf(buf2,"\n%s : %s",datestr,buffer);

	fptr=fopen(conf.logfile,"at");
	if(!fptr)	fptr=fopen(conf.logfile,"wt");
	if(fptr){
		fputs(buf2,fptr);
		fclose(fptr);
		}
	else{
		printf("\n\rUnable to open log file.");
		}
}

int del_tmp()
{
    DIR	*tdir;
    struct dirent *tent;
	char rmfile[128];
	int ret=0;

	tdir=opendir(conf.tmppath);

    while((tent = readdir(tdir))) {
		sprintf(rmfile,"%s%s",conf.tmppath,tent->d_name);
		ret+=remove(rmfile);
		}
	return(ret);
}

int fexist(char *path)
{
	FILE *fptr;
	int ret=0;

	fptr=fopen(path,"rb");
	if(fptr){
		fclose(fptr);
		ret=1;
		}
	return(ret);
}

char *strrepl(char *Str, size_t BufSiz, const char *OldStr, const char *NewStr)
{
	int OldLen, NewLen;
	char *p, *q;

	if(NULL == (p = strstr(Str, OldStr)))
		return Str;
	OldLen = strlen(OldStr);
	NewLen = strlen(NewStr);
	if ((strlen(Str) + NewLen - OldLen + 1) > BufSiz)
		return NULL;
	memmove(q = p+NewLen, p+OldLen, strlen(p+OldLen)+1);
	memcpy(p, NewStr, NewLen);
	return q;
}

void translate(char *in, unsigned int size)
{
	while(strstr(in,"b"))	strrepl(in,size,"b","");
	while(strstr(in,"c"))	strrepl(in,size,"c","");
	while(strstr(in,"g"))	strrepl(in,size,"g","");
	while(strstr(in,"h"))	strrepl(in,size,"h","");
	while(strstr(in,"k"))	strrepl(in,size,"k","");
	while(strstr(in,"n"))	strrepl(in,size,"n","");
	while(strstr(in,"p"))	strrepl(in,size,"p","");
	while(strstr(in,"r"))	strrepl(in,size,"r","");
	while(strstr(in,"w"))	strrepl(in,size,"w","");
	while(strstr(in,"y"))	strrepl(in,size,"y","");

	while(strstr(in,"B"))	strrepl(in,size,"B","");
	while(strstr(in,"C"))	strrepl(in,size,"C","");
	while(strstr(in,"G"))	strrepl(in,size,"G","");
	while(strstr(in,"H"))	strrepl(in,size,"H","");
	while(strstr(in,"K"))	strrepl(in,size,"K","");
	while(strstr(in,"N"))	strrepl(in,size,"N","");
	while(strstr(in,"P"))	strrepl(in,size,"P","");
	while(strstr(in,"R"))	strrepl(in,size,"R","");
	while(strstr(in,"W"))	strrepl(in,size,"W","");
	while(strstr(in,"Y"))	strrepl(in,size,"Y","");
}

void usage()
{
	printf("\n\r%s\n\r",PROGNAME);
	printf("\n\rUsage: yaqn -ief? [ -c config.file ]\n\r");

	printf("\n\r\t?   Shows this help message");
	printf("\n\r\te   Export Rep packets");
	printf("\n\r\ti   Import Qwk packets");
	printf("\n\r\tf   Export and import");
	printf("\n\r\tc config.file\n\r\t\tUse specified config file");
	printf("\n\r\ts   Show Config data and exit");
	printf("\n\r\n\r");
}

void show_config()
{
	
	printf("\n\r%s\n\r\n\rQWK Hosts\n\r",PROGNAME);
	printf("Hubs     Arc Fido AKA        DefPath\n\r");
	printf("-------- --- --------------- -------------------------------------------------");
	for(hubs = conf.hosts; hubs; hubs = hubs->next){
		printf("\n\r%-8.8s %3.3s %-15.15s %s",
				hubs->hub,hubs->arc,hubs->aka,hubs->defpath);
		}

	printf("\n\r\n\rArchivers\n\r");
	printf("Arc Pack command              Unpack command\n\r");
	printf("--- ------------------------- -------------------------");
	for(packr = conf.packers; packr; packr = packr->next){
		printf("\n\r%-3.3s %-25.25s %-25.25s",
			packr->name,packr->arc,packr->unarc);
		}

	printf("\n\r\n\rAreas\n\r");
	printf("Conf  Host     Type  Path\n\r");
	printf("----- -------- ----- ---------------------------------------------------------");
	for(tarea= conf.areas; tarea; tarea = tarea->next){
		printf("\n\r%5.5d %-8.8s %-5.5s %s", tarea->num,tarea->hub,
			(tarea->type)==MSGTYPE_JAM?"Jam":"Squish",tarea->path);
		}
	printf("\n\r");
}


int main(int argc, char *argv[])
{
    static struct _minf minf;
	char opt;
	int cnt=0;
    
    minf.req_version = MSGAPI_VERSION;
    minf.def_zone = 2;
    
    if(MsgOpenApi(&minf) == -1){
		printf("\n\rMsgOpenApi Failed.\n\r");
		exit(0);
		}

	strcpy(hostname,"");
	strcpy(configfile,"qwk.cfg");
	runmode=NO_GO;

	cnt=0;
	while((opt=getopt(argc,argv,"?c:efis"))!=-1){
		cnt++;
		switch(opt){
			case 'c': 	strcpy(configfile,optarg); break;
			case 'e': 	runmode=EXPORT_REP; break;
			case 'f': 	runmode=IMPORT_EXPORT; break;
			case 'i': 	runmode=IMPORT_QWK; break;
			case 's':	runmode=SHOW_CFG;	break;
			case '?':	usage(); break;
			}
		}
	if(!cnt){
		usage();
		exit(0);
		}

    read_config(&conf);

	switch(runmode){
		case IMPORT_QWK: process_ndx();	break;
		case EXPORT_REP: read_jam(); break;
		case IMPORT_EXPORT: process_ndx();	read_jam();	break;
		case SHOW_CFG:	show_config();	break;
		case NO_GO: usage(); break;
		}
	return (0);
}
