load("sbbsdefs.js");

function UserInput() {
    this.__keys__ = {
        DOWN:KEY_DOWN,
        UP:KEY_UP,
        LEFT:KEY_LEFT,
        RIGHT:KEY_RIGHT,
        HOME:KEY_HOME,
        END:KEY_END,
        PGDN:'ESC[U',
        PGUP:'ESC[V',
        ENTER:"\r",
        INSERT:"\x16",
        DELETE:"\x7f",
        BACKSPACE:"\x08",
        TAB:"\x09",
        ESC:"ESC",
        DOUBLE_ESC:"ESCESC",
        F1:'ESCOP',
        F2:'ESCOQ',
        F3:'ESCOR',
        F4:'ESCOS',
        F5:'ESCOt',
        F6:'ESC[17~',
        F7:'ESC[18~',
        F8:'ESC[19~',
        F9:'ESC[20~',
        F10:'ESC[21~',
        F11:'ESC[23~',
        F12:'ESC[24~',
        CTRL_A:"\x01",
        CTRL_D:"\x04",
        CTRL_G:"\x07",
        CTRL_L:"\x0c",
        CTRL_N:"\x0e",
        CTRL_Q:"\x11",
        CTRL_R:"\x12",
        CTRL_S:"\x13",
        CTRL_W:"\x17",
        CTRL_X:"\x18",
        CTRL_Y:"\x19"
     }

    this.GetKey = function() {
        while(bbs.online) {
            var userInput = console.inkey(K_NONE, 5);
            var userInputFull = userInput;
            userInputFull = userInputFull.replace(/\x1b/g, "ESC");

            if (userInputFull == "ESC") {
                while (bbs.online) {
                    var userInputSub = console.inkey(K_NONE, 2);
                    userInputSub = userInputSub.replace(/\x1b/g, "ESC");

                    if (userInputFull == "ESC" && userInputSub == "ESC") {
                        userInputFull = "ESCESC";
                        return userInputFull;
                    }

                    if (userInputSub.length > 0)
                        userInputFull = userInputFull + userInputSub;
                    else
                        return userInputFull;
                }
            }
            return userInputFull;
        }
    }

    this.WaitForKey = function() {
        while (bbs.online) {
            userInput = this.GetKey();
            if (userInput.length > 0)
              return userInput;
        }
    }
}

function Config() {
    this.values = {};
    this.sections = {};
    this.defaults = {};

    this.load = function(filename) {
        if (filename == null) throw("Config:load not provided file to load.");
        var cfgFile = new File(filename);

        if (cfgFile.open('r')) {
            this.sections = cfgFile.iniGetSections();

            for (var s in this.sections) {
                var sectionName = this.sections[s];
                this[sectionName] = cfgFile.iniGetObject(sectionName);

                for (var propertyName in this.defaults[sectionName]) {
                    if (typeof this[sectionName][propertyName] === 'undefined')
                        this[sectionName][propertyName] = this.defaults[sectionName][propertyName];
                }
                for (var propertyName in this[sectionName]) {
                    if (typeof this[sectionName][propertyName] === 'string') {
                        this[sectionName][propertyName] = this[sectionName][propertyName].replace(/\\1/g, "").replace(/\\x01/g, "").replace(/^"(.+(?="$))"$/, '$1');;
                        //this[sectionName][propertyName] = this[sectionName][propertyName].replace(/\\x01/g, "");
                    }
                }
            }
        } else {
            console.print("Failed to open config ini file: " + filename + "\r\n");
            console.print("Please alert the sysop of this.\r\n");
            console.pause();
            throw("Failed to open config ini file: " + filename + "\r\n");
        }
    }

    this.printConfig = function() {
        console.crlf();
        log(LOG_INFO, "Printing Configuration");
        console.crlf();
        for (var s in this.sections) {
            var sectionName = this.sections[s];
            console.print(sectionName + " = " + this[sectionName] + "\1n\r\n");
            for (var propertyName  in this[sectionName]) {
                console.print(sectionName + "." + propertyName + " = " + this[sectionName][propertyName] + "\1n\r\n");
            }
        }
    }
}

function Selection() {
    this.height     = 0;
    this.items      = 0;
    this.row        = 0;
    this.col        = 0;
    this.col_max    = 0;
    this.page       = 0;

    this.prev       = {};
    this.prev.row   = 0;
    this.prev.col   = 0;
    this.prev.page  = 0;


    //function setup(numItems, maxHeight, numColumns) {
    this.setup = function(numItems, maxHeight, numColumns) {
        if (numItems    == null) numItems   = 0;
        if (maxHeight   == null) maxHeight  = 0;
        if (numColumns  == null) numColumns = 0;

        if (numItems    < 1) numItems   = 1;
        if (maxHeight   < 1) maxHeight  = 1;
        if (numColumns  < 1) numColumns = 1;

        this.items      = numItems;
        this.height     = maxHeight;
        this.col_max    = numColumns;
    }

    this.next = function(wrap) {
        if (wrap == null) wrap = false;
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextRow     = this.row + 1;
        var nextPage    = this.page;

        if (nextRow >= this.height) {
            if ((this.page * this.height) + nextRow - 1 > this.items - 1)
                --nextRow;
            else {
                ++nextPage;
                nextRow = 0;
                if ((nextPage * this.height) > this.items - 1) {
                    --nextPage;
                    nextRow = this.height - 1;
                }
            }
        } else if ((this.page * this.height) + nextRow > this.items - 1) {
            if (wrap) {
                nextRow = 0;
                nextPage = 0;
            } else
                --nextRow;
        }

        this.row = nextRow;
        this.page = nextPage;
    }

    this.prev = function(wrap) {
        if (wrap == null) wrap = false;
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextRow     = this.row - 1;
        var nextPage    = this.page;

        if (nextRow < 0) {
            if (this.page > 0) {
                --nextPage;
                nextRow = this.height - 1;
            } else {
                if (wrap) {
                    nextPage = ~~(this.items / this.height)
                    nextRow = this.items - 1 - (nextPage * this.height);
                } else
                    nextRow = 0;
            }
        }

        this.row = nextRow;
        this.page = nextPage;
    }

    this.nextPage = function() {
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextRow = this.row;
        var nextPage = this.page + 1;

        if ((nextPage * this.height) > this.items - 1) {
            --nextPage;
            if ((nextPage * this.height) + nextRow < this.items - 1)
                nextRow = (this.items - 1 - (nextPage * this.height));
        }
        if ((nextPage * this.height) + nextRow > this.items - 1)
            nextRow = (this.items - 1 - (nextPage * this.height));

        this.row = nextRow;
        this.page = nextPage;
    }

    this.prevPage = function() {
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextRow = this.row;
        var nextPage = this.page - 1;

        if (nextPage < 0) {
            nextPage = 0;
            if (nextRow > 0)
                nextRow = 0;
        }

        this.row = nextRow;
        this.page = nextPage;
    }

    this.nextColumn = function(wrap) {
        if (wrap == null) wrap = false;
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextCol = this.col + 1;

        if (nextCol > this.col_max - 1) {
            if (wrap)   nextCol = 0;
            else        nextCol = this.col_max - 1;
        }


        this.col = nextCol;
    }
    this.prevCol = function(wrap) {
        if (wrap == null) wrap = false;
        this.prev.row   = this.row;
        this.prev.col   = this.col;
        this.prev.page  = this.page;
        var nextCol = this.col - 1;

        if (nextCol < 0) {
            if (wrap)   nextCol = this.col_max - 1;
            else        nextCol = 0;
        }

        this.col = nextColumn;
    }

    this.active = function() {
        return (this.page * this.height) + this.row;
    }

    this.total = function() {
        return this.items;
    }

    this.totalPages = function() {
        return ~~(this.items / this.height);
    }

    this.getItem = function(row) {
        row = typeof row === 'number' ? row : 0;
        return (this.page * this.height) + row;
    }

    this.isOver = function(check) {
        check = typeof check === 'number' ? check : 0;
        if ((this.page * this.height) + check > this.items - 1)
            return true;
        else
            return false;
    }
}

function Scrollbar(x, y, length, orientation, color, arrows)
{
	this.index;
	this.bar;
	this.x=x;
	this.y=y;
	this.orientation=orientation;
    //this.length=length-2;
    this.length=length;
	this.color=color?color:'';
    this.arrows=arrows?1:0;

    if (this.arrows)
        this.length = length-2;

	this.draw = function(index, range)
	{
		if (index > range)
			return;
		if ((isNaN(index) || isNaN(range)) &&
			(!this.index || !this.bar))
			return;

        if (range < this.length)
            adj = 0;
            //adj = Math.floor(this.length / (this.length / range+1))
        else
            adj = Math.floor(this.length * (this.length / range))

        this.bar = this.length - (isNaN(adj) ? 0 : adj);

        if (range < this.length)
            adj = 1;
        else
            adj = Math.ceil(((index + 1) / range) * (this.length-this.bar+1));

        this.index = (isNaN(adj) || adj < 1) ? 1 : adj;

        //console.gotoxy(1, console.screen_rows);
        //console.clearline("\1n");
        //console.print("t.index=" + this.index + ", t.bar=" + this.bar + "; index=" + index + ", range=" + range + "; t.length=" + this.length + "; adj=" + adj);

		if (this.orientation == "vertical")
			this.drawVert(this.index, this.index + this.bar);
		else
			this.drawHoriz(this.index, this.index + this.bar);
	}

	this.drawVert = function(s, f)
	{
		console.gotoxy(this);
        if (arrows)
		    console.putmsg('\1n' + this.color + ascii(30), P_SAVEATR);
		var ch='\xB0';
		for (var i = 1; i <= this.length; i++) {
			console.gotoxy(this.x, this.y + i - !this.arrows);
			if (i == s) 
				ch='\1h\xDB';
			else if (i >= f) 
				ch='\xB0';
			console.putmsg("\1n" + this.color + ch, P_SAVEATR);
		}
        if (this.arrows) {
		    console.gotoxy(this.x, this.y + this.length + 1);
		    console.putmsg("\1n" + this.color + ascii(31),P_SAVEATR);
        }
	}

	this.drawHoriz=function(s,f)
	{
		if(f > this.length) {
			s--;
			f--;
		}
		console.gotoxy(this);
		console.putmsg('\1n' + this.color + ascii(17),P_SAVEATR);
		for(i=1;i<=this.length;i++)	{
			if(i == s) 
				ch='\1h\xDB';
			else if(i == f+1)
				ch='\xB0';
			console.putmsg(ch,P_SAVEATR);
		}
		console.putmsg(ascii(16),P_SAVEATR);
	}
}
