// onelinerz.js v1.14
// bbs-scene.org global oneliners for Synchronet bulletin board systems
// echicken - echicken@bbs.electronicchicken.com

load("sbbsdefs.js");
var esc = String.fromCharCode(27);

// Configuration section
var bbsname = "example"; // Your board's name, preferably in its shortest form
var username = "ex@am.pl"; // Your bbs-scene.org API username
var password = "3x4mpl3"; // Your bbs-scene.org API password
var server = "http://bbs-scene.org/api/"; // The URL where onelinerz.php and onelinerz.xml are located
var outfile = system.node_dir + "onelinerz.tmp"; // You probably don't need to change this
var displayfile = "onelinerz"; // A header file, location relative to sbbs/text/menu, no extension (file must be .asc or .ans.)
var limit = 13; // How many oneliners to display in the listing
var onelinerlength = 55; // Size of the oneliner input box & truncated length of fetched oneliners
var aliasvialength = 20; // Truncated length of the alias@bbsname text
var ansi_colour_oneliner = esc + "[0;37;40m"; // ANSI sequence, the colour of the oneliner text
var ansi_colour_aliasvia = esc + "[1;37;40m"; // ANSI sequence, the colour of the alias@bbsname text
var wgetpath = system.mods_dir; // Directory containing wget, "" if it's on your path. *nix people can probably change this to ""
var timeout = 2; // If the server takes more than this many seconds to respond, abort the script
var bannedusers = new Array("guest", "spidy", "chinaman"); // Users disallowed from posting oneliners (case insensitive), can match alias, chat handle, or real name
// End of configurable variables.

function pad_right(string, padchar, spaces) {
    if (! string || ! padchar || string.length >= spaces) { return string; }
    var max = (spaces - string.length)/padchar.length;
    for (var i = 0; i < max; i++) { string += padchar; }
    return string;
}

function pad_left(string, padchar, spaces) {
    if (! string || ! padchar || string.length >= spaces) { return string; }
    var max = (spaces - string.length)/padchar.length;
    for (var i = 0; i < max; i++) { string = padchar + string; }
    return string;
}

// Some of this is probably redundant, but just in case anybody tries any funny business . . .
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = html_encode(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}

// Fetch the current XML from onelinerz.php, if this fails, don't display anything
system.exec(wgetpath + "wget -q -O " + outfile + " --timeout=" + timeout + " --http-user=" + username + " --http-password=" + password + " " + server + "onelinerz.php?limit=" + limit);
if(file_exists(outfile)) {
	console.clear();
	bbs.menu(displayfile);
	console.crlf();

	var handle = new File(outfile);
	handle.open(mode="r");
	var onelinerz = handle.read();
	handle.close();
	file_remove(outfile);
	onelinerz = onelinerz.replace("<?xml version=\"1.0\" standalone=\"yes\"?>", "");
	
	var x = new XML(onelinerz);
	for each(var node in x.node) {
		thisoneliner = node.oneliner.substr(0, onelinerlength);
		thisoneliner = pad_right(thisoneliner, " ", onelinerlength);
		thisaliasvia = node.alias + "@" + node.bbsname;
		thisaliasvia = thisaliasvia.substr(0, aliasvialength);
		thisaliasvia = pad_left(thisaliasvia, " ", aliasvialength);
		console.print(ansi_colour_aliasvia + thisaliasvia + " " + ansi_colour_oneliner + thisoneliner); console.crlf();
	}
	
	var banned = 0;
	var userrealname = user.name.toUpperCase();
	var useralias = user.alias.toUpperCase();
	var userhandle = user.handle.toUpperCase();
	for(i in bannedusers) {
		if(userrealname == bannedusers[i].toUpperCase() || useralias == bannedusers[i].toUpperCase() || userhandle == bannedusers[i].toUpperCase()) {
			banned = 1;
		}
	}
	
	if(banned == 0) {
		console.pushxy();
		if(!console.noyes("Post a oneliner to bbs-scene.org")) {
			console.popxy(); console.clearline();
			thisaliasvia = user.alias + "@" + bbsname; thisaliasvia = thisaliasvia.substr(0, aliasvialength); thisaliasvia = pad_left(thisaliasvia, " ", aliasvialength);
			console.print(thisaliasvia + " ");
			var oneliner = console.getstr("", onelinerlength, K_EDIT|K_LINE|K_AUTODEL);
			if(oneliner != "" && oneliner != null) {
				oneliner = clean_input(oneliner);
				system.exec(wgetpath + "wget -q -O " + outfile + " --timeout=" + timeout + " --http-user=" + username + " --http-password=" + password + " --post-data=\"bbsname=" + bbsname + "&alias=" + user.alias + "&oneliner=" + oneliner + "\" " + server + "onelinerz.xml");
				if(file_exists(outfile)) { file_remove(outfile); }
			}
		}
	}
}