
type

charset = set of char;

const

fmReadOnly  = 0 ;   { $0000 ---- ---- ---- -000 }
fmWriteOnly = 1 ;   { $0001 ---- ---- ---- -001 }
fmReadWrite = 2 ;   { $0002 ---- ---- ---- -010 }
fmDenyAll   = 16 ;  { $0010 ---- ---- -001 ---- }
fmDenyWrite = 32 ;  { $0020 ---- ---- -010 ---- }
fmDenyRead  = 48 ;  { $0030 ---- ---- -011 ---- }
fmDenyNone  = 64 ;  { $0040 ---- ---- -100 ---- }

hexchars     : charset = ['0'..'9','A'..'F'] ;

CRLF = #13#10 ;



function exist(filename: string): boolean;
{$ifdef existdirinfo}
var
 dirinfo: searchrec; {$endif}
begin
 findfirst(filename, $20, dirinfo);
 exist:=(doserror=0) and (filename<>#0) ;
end;

function fAddSlash(inpath:string):string;
begin;
If (Length(InPath) > 0) and (InPath[Length(InPath)] <> '\') Then
 Begin
 {   If InPath[Length(InPath)] <> '\' Then
     Begin}
 InPath[0] := Chr(Length(InPath) + 1);
 InPath[Length(InPath)] := '\';
 End;
    {End;}
faddslash:=inpath;
end;

function IntToStr(I: Longint): String; { Convert any integer type to a string }
var
 S: string[11];
begin
Str(I, S);
IntToStr := S;
end;

FUNCTION PADR( s: STRING; n: BYTE; c: CHAR ): STRING;
ASSEMBLER;
ASM
      PUSH   DS
      CLD
      LDS    SI, s
      XOR    AX, AX
      LODSB
      MOV    CX, AX

      LES    DI, @Result
      INC    DI
      REP    MOVSB

      MOV    CL, n
      SUB    CL, AL

      CMP    CX, 0
      JNB    @@1
      XOR    CX, CX

@@1:  MOV    AL, c
      REP    STOSB

      MOV    DI, WORD PTR @Result
      MOV    AL, n
      MOV    BYTE PTR ES:[DI], AL

      POP    DS
END;

FUNCTION PADL( s: STRING; n: BYTE; c: CHAR ): STRING; ASSEMBLER;
ASM
      PUSH   DS
      CLD

      LES    DI, @Result
      INC    DI
      LDS    SI, s
      XOR    AX, AX
      LODSB
      PUSH   AX

      XOR    CX, CX
      MOV    CL, n
      SUB    CL, AL

      CMP    CX, 0
      JNB    @@1
      XOR    CX, CX

@@1:  MOV    AL, c
      REP    STOSB

      POP    CX
      REP    MOVSB

      MOV    DI, WORD PTR @Result
      MOV    AL, n
      MOV    BYTE PTR ES:[DI], AL
      POP    DS
END;

FUNCTION Empty( s: STRING ): BOOLEAN; ASSEMBLER;
ASM
       CLD
       XOR   CH, CH
       LES   DI, s
       MOV   CL, BYTE PTR ES:[DI]
       JCXZ  @@1
       INC   DI
       MOV   AL, ' '
       REPE  SCASB
       JZ    @@1          { empty }
       MOV   AL, False
       JMP   @@2
@@1:   MOV   AL, True
@@2:
END;
