; == T-MAIL 2400 ======= T-Mail's main control file =======================
;
;
; ============================= System section=============================
;
; This section contains the main parameters of your system
;
;--------------------------------------------------------------------------
;
Address         0:0/0@fidonet
;
; Main address of your node as Zone:Net/Node or
;                              Zone:Net/Node.Point or
;                              Zone:Net/Node.Point@domain 
;
AKA            0:0/0@HIPnet    ; HIPnet ZC
;
; You may also include a number "AKA" (Also Known As) addresses, conforming 
; the standard addressing scheme.  Up to 100 AKAs may be listed for THIS node
;
SysOp            Richard Ross      ; SysOp name
;
; The name of the system operator (SysOp) of the system.
;
[1] BBSname          kaOs BBS Node2;
[2] BBSname          kaOs BBS Node3;
;
; The name of the system, which will be used for EMSI/YooHoo handshaking.
;
Phone            1-608-256-5680     ; My Phone no.
;
; The telephone number of the system.  This is used in handshaking and
; for private system, this can be -Unpublished- or something similar.
;
Country          1           ; International country telephone code;
;
; The international dialing code for your country.  Russia - 7, USA - 1,
; UK - 44, Finland - 358 etc.
;
;
Place           [Telegard Beta Site] ; Location
;
; Physical location of the system, used in handshaking only
;
; Synchronize 5030/15        ; Synchronize clock with this node
;
; The address of a node which will act as a "reference" system for the 
; purposes of synchronizing your system's real-time clock.  Whenever your
; system connects with the system defined by this line, your real-time 
; clock will be set to the same time as the remote system.
;
; Default_OH [*:*/*.*] 04:30-05:30
;
; Default Operating hours interval for specified systems.  General syntax
; is:
;       Default_OH [<address list>] <time interval>
;
;  As many Default Operating Hours as necessary may be defined.
;
;  Default_OH [2:*/*.* !2:5030/122]   06:30-07:30  ; Zone 2 ZMH
;  Default_OH [1:*/*.*]               13:00-14:00  ; Zone 1 ZMH
;  Default_OH [2:5030/124 ZYX !5030/132] 4:00-5:00,7:00-9:00,0.2:00-0.4:00
;
;  Note:  The only flags which may be used in Default_OH are those defined 
;         in the nodelist.  Flags defined in subst.lst, may not be used.
;
;
UTC -4                       ; Time Zone
;
; Establishes the difference (in hours) between UTC and local time.  For 
; Moscow time this is +3 hrs in winter and +4 hrs in summer.
;
[1] Task_Mode Slave
[2] Task_Mode Master
;
; In a multi-tasking environment it is necessary to define one system as 
; the system which will handle the packing of mail, this system is called 
; the Master system and all others are Slave systems.  Busy flags are 
; created by both Master and Slave systems when they need to lock an address
; against other lines.  For Bink_mode these are -BSY flags and for 
; Arcmial_attach are compatible with FrontDoor (CRC-32 calculated).
;
; ============================ Miscellaneous info ==========================
;
; This section defines the system's various additional parameters
;
;--------------------------------------------------------------------------
;
; T-Password my_password_no_5; Service request access control password
;
; Password which will be used to permit the execution of "service requests" 
; from remote systems.  For more details on service requests, please see
; Chapter 18.
; 
; T-serverNotify      5030/124.1023
;
; Send a copy of the T-Mail server report to the specified system.  The 
; report is placed into a message and sent as Direct.
;
Output       Memory          ; Output by BIOS routines (default) or
;                              Directly to video memory
;
; Defines the methos of writing to the terminal screen, either as BIOS (via 
; BIOS calls) or Memory (directly to the video memory).  T-Mail can detect 
; the curent video mode and operate in either 80 x 25, 80 x 30, 80 x 43 or 
; 80 x 50 mode
;
;
Highlight ZR-16 2e           ; Highlight screen item, max 29 items
Highlight ZS-16 4e            
Highlight Human caller 1f
;
; Set screen attributes for specific fields.  The attribute is defined by 
; 2 hexadecimal numbers, the first number defines the background color
; and the second the foreground color.  The colors are identical to 
; BIOS attributes and a maximum of 29 such attributes may be set.
;
Saver           << Slam a key >>
;
; Defines the text which is displayed to the user when the screen saver
; is in effect.
;
Saver_time 10
;
; Defines the inactivity time, since the last key depression, before the 
; screen saver is activated.  Setting this value to zero, disables the 
; screen saver.  The screen saver consists of the text defined by the 
; command "Saver" being moved around the screen periodically.
;
Dos_Critical_Errors No         ;  No Dos critical error handler
;
; This variable defines how Dos critical errors are handled.  This variable 
; is only meaningful for the Dos version of T-Mail. Other possible values
; are:
;
;  ABORT   -  Immediate termination with errorlevel 4
;  IGNORE  -  Ignore the error and continue
;  EXIT    -  Exit with errorlevel 4 after cleanup
;  RETRY   -  Retry the function, up to 10 times, then ABORT
;
; ============================ Key Definitions ==============================
;
;                         Definition of "hot" keys
;
;-----------------------------------------------------------------------------
;
; Syntax:
;
; Key <Mnemonic keycode> [<flag>] <command> [<parameters>]
;
;
Key <Alt-E> C:\T-MAIL\TIMED\TIMED.CMD ; Alt-E, execute mail editor
; Key <Shift-F6> !C:\nc\nc.exe        ; Shift-F6, execute the program "nc" without
;                                     ; a swap to disk
[1] Key <Alt-L> C:\DOS\Q.EXE C:\TG\LOGS\T-MAIL1.LOG
[2] Key <Alt-L> C:\DOS\Q.EXE C:\TG\LOGS\T-MAIL2.LOG
;                                                    with the supplied parameter
Key <Alt-J> EXIT 100   ; Local Login BBS
Key <F10> EXIT 15      ; Reload T-Mail
;
; Definitions of keys, by mnemonic keycode, and the actions which will be
; invoked.  Up to 20 "hot-keys" may be defined here, for a more detailed 
; description see chapter 20.
;
; Note:  Although mnemonic key codes are the simplest method to identify key
; strokes, it is also possible to define the actual scan/code.  i.e 1200 
; instead of <Alt-E>
;
; ============================ T-Mail sound control ===========================
;
;                          Definition of sound effects
;
;-----------------------------------------------------------------------------
;
Sound            CADT         ; Sound yes/no (symbolic mask)
;
; Enables or disables sounds for each of the defined functions.  The 
; Symbolic mask is used to define which sounds are to be enabled.
; For more information on the meaning of each symbol, see chapter 20.
;
; Syntax: SoundOf <event> <occurrences> <sample>
;
; Each sample contains one or some groups of 4 numbers, which are
; interpreted:-
;
; 1st number of group - starting tone (Hz) (-1 = silence)
; 2nd                   tone increment
; 3rd                   increment duration (ms); 4th                   number of increments
;
;
;============================ T-Mail sound control ===========================
;
;
SoundOf   Connect      1   100 10 100 4 100 -3 100 4
;                                               ; Modem connection
SoundOf   Begin        1   37 1 10 64
;                                               ; Begin sessoin
SoundOf   End          20  5700 1500 2 7
;                                               ; End of session
SoundOf   Abort        1   900 1 5 50
;                                               ; Transfer aborted
SoundOf   Human        10  300 150 6 10
;                                               ; Human Caller
SoundOf   Error        1   200 1 2 800 1000 -1 2 800
;                                               ; Error (modem, fossil)
SoundOf   Chat         4   3500 0 50 1 3000 0 50 1 4000 0 5 1
;                                               ; Chat
SoundOf   Unpack       1   12000 -100 6 100
;                                               ; Unpacking mail
SoundOf   Ring         10   595 0 55 1 743 0 55 1
;                                               ; Ring
SoundOf   Tick         1   500 0 2 1
;                                               ; Simple 'tick'
;
; ============================= Directory Settings ============================
;
;                           File names and pathnames
;
;-----------------------------------------------------------------------------
;
Files         C:\T-Mail\SECURE\   ; Inbound files directory
;
; The directory where files, coming in from remote systems are stored, also 
; the default directory where files (bound for other systems) may be stored.
;
Files_UnSecured C:\T-MAIL\FILES\ ; Inbound for non session-password
;                                     protected systems
;
; The directory where files, coming in from remote systems with whom a 
; session password has NOT been established, will be stored.  If this 
; directive is ommitted, the path defined by <Files> will be used. 
;
; File_Boxes c:\t-mail\files\boxes\; Fileboxes path
;
; The directory where the file-boxes will be created and scanned.  If 
; not specified, this will default to <Files>\boxes\.  Directories will 
; be created, in this directory, for the purpose of of storing files, 
; according to the address to which the files will be sent.
;
File_Boxes_Scan Full
;
;  Set detail level for the scan of File Boxes.  Detail levels are:
;
;  Full    -  File boxes are to be scanned every 'scan_circle'
;
;  Normal  -  File boxes are to be scanned only on appearance or when
;             a full repack is required.
;
;
[1] Log C:\TG\LOGS\T-MAIL1.LOG
[2] Log C:\TG\LOGS\T-MAIL2.LOG
;
; The full pathname to the log file to be used by T-Mail.  
; Default is T-Mail.log
;
; Chat_Log chat.log          ; Chat log name.
;
; The full pathname to the log file to be used for recording CHAT
;
NodelistPath C:\T-Mail\NODELIST\; Path to nodelist (s)
;
; The full pathname to the directory used to store the nodelists and 
; pointlists.
;
Security C:\T-MAIL\DATA\password.lst        ; Password security list
;
; The name of the file containing session passwords to be used in mail 
; sessions
;
; SubstList C:\T-MAIL\DATA\subst.lst          ; Substitution list
;
; The name of the file containing substitution information
;
; BroadCast 5030/*.* !5030/2 read.me     ; Broadcast list and file
;                                              
; An <address list>, followed by a file pathname.  The specified file
; will be automatically delivered to any qualifying node who calls in
;
; Swap_Order XED             ; swap order XMS, EMS, Disk
;
; The priority order for swapping T-Mail when running an external program.
; X = XMS memory, E = EMS memory and D = disk
;
Swap          C:\T-MAIL\DATA\ ; Swap directory
;
; The directory where T-Mail will create the necessary temporary and swap 
; files, such as DOBBS.BAT, ANYFILE.BAT etc.  Default is the system 
; directory and the swap file will be around 350Kb.  You must ensure that 
; enough disk space is available for these files, failing which external 
; programs will not execute.
;
[*] Sys_Path      C:\T-MAIL\DATA   ; Service file storage
;
; 
; Defines the directory where t-mail service files are stored prior to
; exit.  Default - The path where t-mail.exe resides.
;
; ============================== Terminal setup ===============================
;
;                  Set-up parameters for the terminal emulator
;
;-----------------------------------------------------------------------------
;
;
; Terminal          C:\tm\tm.bat /O ; Terminal program
;
; The full pathname of the executable for or batch file to be executed
; Whenever the terminal emulator is called (Alt-T and some other cases).
; If this variable is not defined, then an internal emulator will be
; called instead.
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; If the external terminal emulator is not defined, then the following
; parameters can be used as long as the programs are available:
;
Term_Download C:\TG\PROT\gsz.exe port *P speed *B rz -rr
;
; External protocol which the emulator will use for receiving files.
; If this is not defined, an internal Zmodem implementation will be used.
;
Term_Upload       C:\TG\PROT\gsz.exe port *P speed *B sz *F
;
; External protocol which the emulator will use for transmitting files.
; If this is not defined, an internal Zmodem implementation will be used.
;
; Macro definitions which may be used as parameters of external protocols:
;
; *B - connection speed (DCE baudrate);
; *L - locked port baudrate (0 if not locked);
; *P - COM-port number;
; *T - task number;
; *O - handle of open COM port (OS/2 only);
; *F - for download - path to the download directory (Term_DownDir)
;      for upload   - name of file to be transmitted
;
; Term_UpDir        C:\t-mail\files\
;
; Default directory for files to be uploaded.
;
;
Term_DownDir C:\FILES\UPLOADS\
;
; Directory for downloaded files.
;
Term_Log           C:\TG\LOGS\T-term.log
;
; The name of the log file, which will hold information concerning
; the session, uploads and downloads.
;
Term_Inactivity 10  ; Terminal emulator inactivity timeout (minutes)
;
; The maximum operator inactivity time before the emulator session is 
; terminated. If a key is not depressed within this time, or if not 
; transferring a file, the emulator connection will be closed.  Setting 
; this value to zero signifies an infinite timeout.
; ============================ Flags definitions ==============================
;
;                       Definition of flags (semaphores)
;
;-----------------------------------------------------------------------------
;
Flag_Dir C:\T-MAIL\DATA\               ; Semaphores/Flags directory
;
; The full pathname of the directory in which inter and intra-task flags
; are stored.  Default is the T-Mail system directory.
;
Flag_Session busy.t-m        ; Global busy flag
;
; This flag is created by T-Mail whenever a mailer session is initiated.
; At the completion of the mailer session, the flag is removed.  It is 
; created, by default, in the directory defined by Flag_Dir.
;
; Flag_Noscan noscan.t-m      ; Inhibit scanning
;
; This flag inhibits the scanning of netMail, Mailboxes and Fileboxes.
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Process flags may be defined for use by other programs to control the 
; execution of T-Mail.
;
; Syntax:
;
; Process_Flag [!]<flag_name> <KeyWord>|<[!]command>|<dvpname>
[2] Process_Flag ARC.NOW EXIT 70
[2] Process_Flag FDRESCAN.NOW RePack
[2] Process_Flag NODELIST.NOW EXIT 80
[2] Process_Flag TIC.NOW EXIT 40
[2] Process_Flag INTERBBS.NOW EXIT 50
;
; where
; <flag_name> - 
;                The name of the flag.  This may be defined as a file 
;                name or a full path and file name.  If only a file
;                name is given, the Flag_Dir directory is the path.
;
;                T-Mail's habndling of flags is, generally, as follows:
;
;                1)  Kill the defined flag
;                2)  If the flag was succesfully killed, action the function
;                    specified by the supplied Keyword.  
;                    If the flag cannot be killed for some reason, locked 
;                    or already killed, then the keyword action will not be
;                    taken.
;                The single exception to this is the keyword Sleep, in 
;                which the task waits for the flag to be removed or created.
;
;                The exclamation mark "!" may be used to signify a NOT 
;                function applied to the flag.  This is equal to inverting
;                the meaning of the flag and whatever action is defined
;                will occur if the flag does NOT exist, rather than the 
;                usual case where actions occurs if the flag DOES exist.
;
; <KeyWord> -    One of key words, which determines the action to occur 
;                when the flag is created/removed:
;
;                  Exit <errorlevel>   - exit from T-Mail with specified
;                                        Errorlevel, errorlevel - number in
;                                        range 1-255.
;
;                  Sleep               - wait for the flag to be removed or 
;                                        wait for it to be created if 
;                                        inverted (!).
;
;                  Set <var> = <value> - Set a new value to a variable
;                                        defined in T-mail.ctl
;                  Poll <addr group>   - Generate a Poll to the address or
;                                        group of addresses, given in <addr
;                                        group>.
;
;                  Drop <addr group>   - Kill poll messages to systems 
;                                        defined in <addr group>
;
;                  Control             - Re-read configuration files
;
;                  Repack <addr group> - repack Netmail (rescan outbound).
;                                        If an <addr group> is given, then
;                                        mail repacking occurs for those 
;                                        nodes only.
;
;                  Create <filename>   - create file <filename>
;
;                  Kill <filename>     - erase file <filename>
;
;                  Nothing             - do nothing.  This may be used to 
;                                        remove or create a flag.
;
; <command> -    The name of the program or batch file (.exe, .com, .bat..)
;                which handles the appropriate processing, and the required 
;                parameters.  Under Dos, an exclamation mark preceding the 
;                command signifies NO MEMORY SWAP (fast execution).  Under 
;                OS/2, a preceding exclamation mark signifies that the 
;                communications port needs to be closed before the <command> 
;                is executed and in this case the macro, *O, has no 
;                meaning.
;
; <dvpname> -    The name of the DesqView program, i.e. the name of a 
;                .dvp-file, defining the window to be opened.
;
; Examples:
; ~~~~~~~~
; Process_Flag anyarc.t-m c:\squish\squish In Out
; Process_Flag c:\anytic.000 anytic.bat -Debug
; Process_Flag doswap.t-m doswap.bat
; Process_Flag sleep.t-m Sleep                    ; Force sleep
; Process_Flag exit.t-m Exit 99                   ; Exit with errorlevel 99
; Process_Flag repack.t-m Repack                  ; Repack netmail
; Process_Flag alive.t-m Kill flags\alive.t-m     ; Erase file
; Process_Flag !Alive1.T-m Nothing                ; Create flagfile
; Process_Flag poll.t-m Poll /2 /100 /6           ; create polls
; Process_Flag set1.T-m Set Freq_Size=1000; set parameter
; Process_Flag test.t-m test.bat *A *P *B -debug  ; execute
;
; Macros mey be freely used to define variable parameters to <command>.
;
; *A - Current address in queue
; *B - connection speed (DCE baudrate);
; *L - locked port speed (or 0);
; *P - COM-port number;
; *T - task number;
; *O - (only for OS/2 versions) - handle of open COM port;
;
; The maximum number of Process_Flags - 32.
;
;
; The directive 'KeyMacro' may be included within the 'Process', 
; 'Process_Flag' and 'Key' directive.   It is used to define a keystroke
; sequence for simulated keyboard input.
;
;  Examples:
;  (t-mail.ctl)
;
;  Process_Flag  key1.t-m  KeyMacro  <Alt-D>C:\command.com<0d>5030/124<0d>
;  Key  <F10>  KeyMacro  <Ctrl-F1>5030/53<0d><5100>
;  Key  <Shift-F9>  KeyMacro  <Alt-F4><Alt-P>/124<0d><Ctrl-O>/124<0d>
;  Key  <Alt-F4>  service.exe
;  Process  Imm  *.exe  KeyMacro  <Alt-C>Hey, man!<0d>
;                                  Thank you for this stuff!<0d>
;
;  Note:  The last line is wrapped to due line length.
;
;   The keystroke list may include:
;        1) ASCII symbols
;        2) mnemonic codes (such as <Ctrl-F1>)
;        3) hex-codes
;   (2) and (3) must be enclosed in <>
;   hex-codes must contain more than one symbol and cannot begin with the
;   letter 'F', use '0F' instead.
;
;  The first example above is used to send the file, command.com, to /124
;  The second displays the hidden line of /53 ('5100' hexcode is PgDn).
;  The third shows a more complex variant of usage.
;  The last example activates Chat mode and sends a few words to the remote
;  whenever a .EXE file is received.
;
;  The maximum length of keystroke -- 128 scancodes.
;
;  Symbols within keystrokes are not interpreted as KeyMacro of another 
;  (or the same) keystroke.
;
; =============================== Packer options =============================
;
;              Parameters defining the packing and processing of mail
;
;-----------------------------------------------------------------------------
;
Packets C:\T-Mail\PACKETS\   ; Outbound packets directory
;
; The full pathname to the directory into which temporary packets and 
; control files are stored for outbound mail.  This may be defined, in order 
; to improve performance, as a directory on a ram-disk.  In BinkMode, this 
; directory is the top of a tree-structure of mail directories, see chapter 
; 17 for more details.
;
Repack_On_Start Yes
;
; Used to define whether mail should be repacked whenever T-Mail is 
; started.  Default is No, in which case the outbound mail status is
; preserved upon exit from T-Mail.
;
; Bink_Mode No               ; BinkleyTerm mode (no-ArcMail-attach)
;
; Defines the mode of operation of T-Mail.  Default is No, which signifies
; that the operational mode is ArcMial-Attach as used in FrontDoor, SEAdog
; and Dutchie.  Yes, signifies that BinkleyTerm style of mail processing
; is to be used.
;
; Scan_Circle 300            ; Bink Outbound rescan (for Bink mode)
;                                or netmail scan period in seconds
;
; For bink mode:
; Time interval between Bink-style outbound directory rescans.  
; Default is 300 seconds = 5 minutes.
;
; For arcmail-attach mode:
; Time interval between outbound directory (Mail_Out) rescans and potential
; repacking of mail.  By default this is executed at the end of each cycle 
; of operation.  For more details, see the definition of the Circle variable.
;
Mail_In C:\T-Mail\mail\      ; Inbound mail path
Mail_Out C:\T-Mail\mail\     ; Outbound mail path
;
; Source and target directories for messages, usually these are the same.
;
Ignore_MsgTimestamp No       ; Do not repack NetMail folder on message
;                            ; timestamp change
;
; When NetMail messages are handled and if the timestamp of a NetMail 
; changes, T-Mail will repack the NetMail directory.  This variable may be 
; used to stop T-Mail from performing this function.  Default - No. 
; 
Total_Messages 100           ; Small system
;
;  A variable, 'Total_Messages' may be defined to control the amount of
;  memory used for processing NetMail messages, this also limits the 
;  number of NetMail messages which T-Mail can handle, {Note -- not the 
;  maximum .msg number!}.  The default value is 1000, meaning a maximum
;  of 1000 .msg files may be simultaneously in the netmail folder}.  Every
;  message requires 4 Bytes of memory and the maximum value for 
;  'Total_Messages' is 8192.
;
;
; Direct          ArcMail      ; Never route messages from this robot
; Direct          EchoMan      ; Max to 16 robot names
; Direct          Allfix
; Direct          T-Fix
; Direct          TIC
;
; Messages "From" any of the above listed sources, will always be sent in 
; Direct mode, i.e. never routed.  Up to 16 such sources may be defined.
;
Sort_Queue Address           ;  Sort the mail queue by address
;
;  Specified the criteria by which the mail queue will be sorted.  This may 
; be one of:
;
;  Address      ..   Destination address
;  Mail         ..   Size of mail bundle waiting for system
;  Files        ..   Size of files waiting for system
;  Size         ..   Sum of Mail and Files
; 
;  Sorting sequence may be inverted, from ascending to descending, by 
; specifying the final parameter as Reverse.
;
;  Example:
;
;  Sort_Queue Mail Reverse
;
; ================================ MailBoxes ===============================
;
;                       Definition of personal post boxes
;
;--------------------------------------------------------------------------
;
; This section describes mail boxes, or "personal post boxes" -
; additional directories for mail, for specific users.
;
; Syntax:
;
; MailBox  [(<flash indicator>)]  <Name> = <dir> [|<command>]
;          Messages To and From NetMail directory
;
; MailBox  [(<flash indicator>)]  <Name> -> <dir> [|<command>]
;          Messages From NetMail directory
;
; MailBox  [(<flash indicator>)]  <Name> <- <dir> [|<command>]
;          Messages To NetMail directory
;
; where:
;
; (<flash indicator>)
;                  - A single symbol which will be displayed, blinking,
;                    in the bottom left portion of the screen when new
;                    mail is placed in the defined Mail_Box.         
;
; <Name>           - The name of user of the post box (as it appears in
;                    the 'TO: ' field of messages.  This may be a user name
;                    or 'system address'.
;
; <dir>            - The full pathname of the directory to hold messages
;                    addressed to <owner>
;
; <command>        - The name of a program, which will be executed upon
;                    the arrival of mail to this post box.
;
; If a mailbox 'user' name is defined as UUCP, any messages addressed 
; directly to UUCP or with a 'To:' field containing a commercial at symbol 
; '@' will be directed to this mailbox for processing.
;
; Maximum number of mailboxes - 100.
;
; Examples:
; ~~~~~~~~
; MailBox (J) John Smith = c:\t-mail\mail\johnmail
; MailBox (*) Andy Elkin = \t-mail\mail\mymail
; MailBox (S) SysOp = c:\t-mail\mail.1 | beep 10
; MailBox (N) NewsMaster = c:\t-mail\mail\nsm | run-ed.bat
; MailBox UUCP = c:\t-mail\mail 5020/23
; MailBox UUCP = c:\t-mail\uumail | gate.bat
; MailBox 5030/15.43  =  c:\t-mail\mail\junkmail | !echo Junkmail received
; MailBox /15.13      -> c:\t-mail\mail\13mail  /15.0
;
; In the last two examples above, the MailBox owner (name) is defined as 
; a 'system address'.  In this case all NetMail for this defined 'system 
; address' will be moved to the local MailBox and/or readdressed to another 
; system.
;
; Crash_as_immediate Yes
;
; Defines that messages marked as 'Crash' are also to be considered as if 
; they were marked as 'Direct' AND 'immediate'.  Default - No, meaning crash 
; as Direct.
;
; ========================== 'After-session' Control ==========================
;
; This section defines the behavior of T-Mail at the end of session,
; i.e. sets the conditions for the processing received mail and files.
;
;-----------------------------------------------------------------------------
;
; Unpack       No            ; Do not unpack .pkt files
;
; Defines whether received mail bundles should be unpacked by T-Mail.  
; Default is Yes
;
; Unpack_Size 2048             ; Max size of .pkt to be unpacked online
;
; This defines the maximum size of an inbound .PKT file to be unpacked if 
; unpacking is to take place while the session is in progress.  The size
; should be defined according to the performance of your system and it 
; should be borne in mind that that this unpacking takes place while the 
; session is active.  This could cause a time-out on a slow system.  The 
; default size is 8000 bytes.
;
Kill_Empty Yes               ; Kill empty messages
;
; Defines whether empty messages should be removed once unpacking has 
; occurred.  Empty messages are those which contain no text and are used for 
; file attach or service requests.  Default is No, i.e. leave empty messages
;
Kill_Transit Yes             ; Kill In-Transit messages
;
; Forces T-Mail to flag In-Transit messages as Kill/Sent, which will result 
; in the message being deleted after dispatch.
;
Transit_Files_From All     ; Allow In-Transit files FROM list
;
Transit_Files_For All      ; Allow In-Transit files TO list
;
; A list of addresses for which you permit remote systems to send files.
;
; For In-Transit files, the following conditions must be met:
;
; 1) The address of the author of the message to which the file is attached
;    must be in the list specified by the Transit_Files_From command.
; 2) The address of the system from which the file was received must also
;    be in the list specified by the Transit_Files_From command.
; 3) The address of recipient (destination) must be in the list specified 
;    by the Transit_Files_For command.
;
; Examples:
; ~~~~~~~~
; Transit_Files_From V32B!/100.13
; Transit_Files_From 2:5030/100.1 50/*.* !50 /919.5
; Transit_Files_For @trlist.txt  ; List of allowable recipients
;
; Audit_Send_Msg Yes         ; Audit message
;
; Defines whether confirmation receipts should be handled or ignored.
; If defines as Yes, then messages with the ARQ attributes will cause a
; confirmation receipt message to be generated to the originator.  The 
; confirmation receipt is generated from a template file (AUDIT.TPL).
; Default is NO confirmation receipts.
;
Kill_Truncate YES           ; Truncate files after transmission
;
; Defines whether sent files (mail bundles) are to be killed (deleted) 
; or simply truncated after transmission.
;
; =========================== Process Control ==============================
;
; Description of the mechanisms of activity process control.  External 
; programs executed at end of session, receipt of control files, network 
; mail, echomail and file echoes.
;
;--------------------------------------------------------------------------
;
; Syntax:
;
; Process [Online|Imm] <macro>|<filemask> <KeyWord>|<[!]command>|<dvpname>
; 
; The optional parameter 'Online' sets the condition for which the external 
; program will be run or the action specified by <KeyWord> will be taken, 
; during the session, after reception of all files, if a file specified by 
; <macro>|<filemask> is received.
;
; The optional parameter 'Imm' sets the condition for which the external 
; program will be run or the action specified by <KeyWord> will be taken, 
; immediately upon the arrival of a file specified by <macro>|<filemask>.
;
; where <macro>: 
; ArcMail              - Processing of inbound netmail and echomail
; Freq                 - Process incoming file requests externally
; Tic                  - Processing of inbound .?IC files
; NetMail              - Mail (.PKT) files
; Files                - Any file
; BBS                  - BBS request
; Session              - At session termination
; Fax                  - Upon receipt of a facsimile
; Voice                - Upon receipt of a voice message
; Nodelist             - When T-Mail requires to compile the nodelist
; Empty_Queue          - For Multi-line systems only, launch on Master when 
;                        the mail queue becomes empty
; Empty_Fax_Queue      - As for Empty_Queue, but applies to the Fax queue.
;
; Handshake_Timeout    - If handshake not received or explicit BBS call
;
; <filemask>           - filename, wildcards according to Dos or OS/2
;                        conventions
;
; <KeyWord>            - One of the following key words, which will 
;                        determinate the action to be taken
;
;                  Keyword                     Action
;
;                  Exit <errorlevel>   - exit from T-Mail with specified
;                                        Errorlevel, errorlevel - number in
;                                        range 1-255.
;
;                  Set <var> = <value> - Set the new value of the specified
;                                        (T-mail.ctl) variable
;
;                  Poll <addr group>   - Poll the systems specified by <addr
;                                        Group>
;
;                  Drop <addr group>   - Kill poll messages to systems 
;                                        defined in <addr group>
;
;                  Control             - Check if the configuration files
;                                        have been modified and if necessary
;                                        re-read them.
;
;                  Repack <addr group> - repack Netmail (rescan outbound).
;                                        If an <addr group> is given, then
;                                        mail repacking occurs for those 
;                                        nodes only.
;
;                  Create <filename>   - create file <filename>
;
;                  Kill <filename>     - erase file <filename>
;
; 
;                  Nothing             - do nothing.
;
; <command> -    The name of the program or batch file (.exe, .com, .bat..)
;                which handles the appropriate processing, and the required 
;                parameters.  Under Dos, an exclamation mark preceding the 
;                command signifies NO MEMORY SWAP (fast execution).  Under 
;                OS/2, a preceding exclamation mark signifies that the 
;                communications port needs to be closed before the <command> 
;                is executed and in this case the macro, *O, has no 
;                meaning.
;
; <dvpname> -    The name of the DesqView program, i.e. the name of a 
;                .dvp-file, defining the window to be opened.
;
;
; Examples:
; ~~~~~~~~
; Process Online *.reg doreg.bat *A *D *B         ; Process key registration
; Process Imm *.reg dojob.bat *A *D *B            ; Process job immediately
; Process Freq profr.exe *F *A *B *T              ; Process file requests
;                                                 ; using an external File
;                                                 ; request processor
Process ArcMail CREATE ARC.NOW
Process nodediff.* CREATE NODELIST.NOW
Process TGST.* CREATE NODELIST.NOW
Process Tic EXIT CREATE TIC.NOW                ; System directory is
Process LN*.Z?? CREATE INTERBBS.NOW
Process 666*.* CREATE INTERBBS.NOW
;                                                   searched
Process Netmail EXIT 70                           ; Created flag
; Process *.doc copy files\*.doc \doc             ; File mask used
; Process *.zip Exit 98                           ; Exit with errorlevel
; Process Files c:\tools\fixfiles.com             ; Full path of .exe file
Process Handshake_Timeout C:\T-MAIL\DATA\BBS.CMD *T *B *H ; BBS if no EMSI/YooHoo
; Process BBS C:\T-MAIL\DATA\BBS.CMD *T *B *H       ; or explicit BBS request
; Process *.exe del ..\inbound\*.exe
; Process test *.* move ..\inbound\test*.* ..\inbound\testfiles
; Process Arcmail Create flags\anyarc.t-m
;
; If a process has not been defined for ArcMail or Tic, the files received
; will receive no special processing.
;
; Macros may be freely used to define variable parameters to <command>.
;
; *A - Full address of the remote system of the current session.  
; *B - Connection speed (DCE baudrate);
; *D - Full default filebox name
; *F - Pathname to the external file request processor executable
; *L - Locked port speed (or 0);
; *P - COM-port number;
; *T - Task number;
; *O - (only for OS/2 versions) - handle of open COM port;
; *N - 1 at successful completion of session, otherwise - 0.
;
; The maximum number of Process definitions - 32.
;
;
; Process Fax fax.bat                         ; If fax input
;
; Defines the process to be executed when a fax file is received, it 
; is possible to send the executable file (or batch file), the file name of 
; the input fax file, as a parameter.  The fax processor should not use 
; substitution macros defined above. 
;
;
; Process Voice voice.bat                     ; If voice message recorded
;
; Defines the process to be executed when a voice message is received, it 
; is possible to send the executable file (or batch file), the file name of 
; the input voice file, as a parameter.  The voice processor should not use 
; substitution macros defined above. 
;
;
; External file request processing:
;
; External FREQs processors are supported by the use of the 'Process FREQ'
; in t-mail.ctl.  The name of the .REQ-file is passed by the macro *F. 
; The results, list of files to be returned must be placed in the file 
; RESPONSE.FRQ which is located in the directory:-
;
;                 <packets>\T-$$-<task no>
;
; (i.e. c:\t-mail\packets\T-$$-1\RESPONSE.FRQ).  This is a textfile, 
; containing a number of strings which are the full pathnames of the files
; to be returned to complete the file request.
;
; Prefixing the pathname with a circumflex, '^', will erase the specified
; file after transmission, prefixing the pathname with a hash mark, '#',
; will cause the file to be truncated after it is sent.
;
;
;   Example (t-mail.ctl)
;
; Process Freq  allfix.exe *F *A *B *T
;
;
; ============================== Modem Control ================================
;
;                               Modem management
;
;-----------------------------------------------------------------------------
;
Include C:\T-MAIL\DATA\Modem.ctl            ; Modem configuration
;
; The name of the modem configuration file.  This file will contain the
; modem initialization sequence(s), commands, responses etc.
;
; Init_Interval 20           ; Cyclic modem initialization time (min).
;
; The time interval between cyclic modem initialization sequences.  This 
; is the maximum time between modem initialization sequences, i.e. if no 
; call has answered or no calls made to remote systems within this time-
; period, the modem will be re-initialized to ensure that it is fully 
; operational.  If no "OK" response is received from the modem, then the
; process described under "No Modem" will be initiated.  If no "OK" response
; is received as a result of this process, then T-Mail will exit with 
; ErrorLevel 5.  The default and recommended value is 20 minutes.
;
Modem_Delay 10               ; Delay before passing a command to the
;                                modem, in units of 0.1 seconds
;
; The delay, in tenths of a second, before sending a command to the
; modem
;
Init_After_Dial Yes        ; Force modem initialization after dial
;
; Forces re-initialization of modem after each dial attempt.  If set to 'No' 
; the modem initialization will take place only if a non-standard 
; dial-prefix is used for this dial attempt.  A non-standard dial-prefix is
; any dial-prefix other than the default.
;
Carrier_Lost_Delay 30        ; Carrier loss detection delay (0.1 sec)
;
; T-Mail will ignore a loss of carrier for the time specified here.  This 
; allows T-Mail to possibly keep a session "alive" even during short-term 
; line drops.  The time is specified in units of 0.1 seconds.
;
Busy_Hang_Off Yes          ; Go "off-hook" when busy
;
; Defines whether T-Mail should force the modem off-hook when running an
; external program.  This is done such that callers will see a "busy"
; line while T-Mail is not able to answer the phone.  Default is No - leave 
; the modem on-hook.
;
; Process No Modem init.bat *P ; Process for modem initialization failure
;
; Defines the executable program, or batch file which will be executed in 
; the event of T-Mail being unable to initialize the modem.  Macros may
; be used on this command line as substitution variables defined below:
;
; *B - connection speed (DCE baudrate)  Baud variable in T-MAIL.CTL
; *L - locked port speed (or 0);
; *P - COM-port number;
; *T - task number;
; *O - (only for OS/2 versions) - handle of open COM port;
;
; ============================== Dial Control ==============================
;
;  Modem calling control, dialing frequency, limit, duration etc.
;
;--------------------------------------------------------------------------
;
Time_Dial 40                 ; Dial time-out, in seconds
;
; Sets the length of time, in seconds that the modem will wait for carrier 
; before hanging up.  Internal modem register S7, should be set to at least 
; the same value as defined here
;
Call_Tries 25                ; Number of time to call to a node
;
; The number of times T-Mail should attempt to call out to each address 
;
Max_Rings 4                  ; Maximum number of Rings to remote system
;
; For modems which can return a "RINGING" response when calling to remote 
; systems, the maximum number of "RINGING" responses before aborting the
; current dial attempt.
;
;
Circle         60            ; Interval between outgoing calls (sec)
;
; The time interval, in seconds, between calls to remote systems.  The 
; delay between calls is necessary to allow remote systems to call in as 
; well as to allow event analysis to take place.
;
Call_Time 0:00-24:00       ; Outgoing call schedule
;
; The time period during which outgoing calls are permitted.  It is 
; reasonable to only permit outgoing calls to occur at certain times of 
; the day, for example when the call cost is at it's lowest.  Also, not
; allowing T-Mail to make outgoing calls at certain times, will improve 
; performance by lowering the overhead required to examine the mail 
; queues and statii.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; This section defines the telephone number translation rules.  The format 
; of telephone numbers in the nodelist is a universal, international 
; standard and the numbers must be modified to accommodate local dialing 
; practices.  This is handled by substituting one set of characters 
; <substring for replacement> (1 or more) by another set of characters 
; <new substring> (0 or more) in the telephone number strings.
; When using the Dial International string, this is forced before the
; telephone number before the call is made.
;
; Syntax:
;
; Dial <substring for replacement> [<new substring>] [|<suffix>]
;         Or
; Dial International <substring for international calls>
;
; It is recommended, that if a large number of dial translations are required,
; as is sometimes the case for North America, then a seperate file is used and
; the INCLUDE verb is used to link the file to T-Mail.ctl
; 
Include C:\T-MAIL\DATA\Dialtran.ctl
;
Dial 1-608                   ; local calls, remove international
;                              and local area code
; Dial 7-    8W                ; National calls, remove international
;                              code and add outside line request
Dial International 011-      ; International calls, add outside line
;                              request and international dial code.
;
;
; =============================== Answer Control ===========================
;
;                   Modem answer control, BBS open hours etc.
;
;--------------------------------------------------------------------------
;
Answer 0:00-24:00
;
; The time period(s) during which T-Mail will respond to remote calls
;
Answer_Ring 1                ; Number of rings before picking up the phone
;
; The number of RING responses to receive before answering an incoming call.
; Default is 1 ring.
;
BBS_Time 04:30-04:00          ; Allow human Callers
;
; The time period(s) during which human callers are allowed access to the 
; BBS software defined in Process BBS
;
Wait_Carrier 25              ; Wait for carrier (sec) on answer
;
; Maximum time to wait for a successful CARRIER DETECT after answering a 
; call.
;
; Hardware_Ring Yes          ; Answer by Ring Indicator (RI) signal
;
; Defines how a modem RING will be detected.  This may be by either the 
; hardware "Ring Indicator" signal or by the modem sending the string 
; "RING" to the computer.  Default is No, indicating that a "RING" 
; response is expected as defined in MODEM.CTL.
;
BBS_Banner C:\T-MAIL\DATA\BANNER.MSG        ; File displayed if BBS available
;
; The name of the file to be displayed to a human caller, requesting
; access to the BBS, if the BBS IS available.
;
NoBBS_Banner C:\T-MAIL\DATA\NOBBS.MSG       ; File displayed if BBS unavailable
;
; The name of the file to be displayed to a human caller, requesting
; access to the BBS, if the BBS is NOT available due to time restrictions.
;
Process BBS C:\T-MAIL\DATA\BBS.CMD *T *B *H ; BBS software
;
; Define the program, or batch file, which will be executed to load the
; BBS software into memory and start it.  This process will only be
; executed in the event that BBS access is permitted and the current time
; is within the constraints given in BBS_Time.
;
; Macros may be used on this command line as substitution variables defined 
; below:
;
; *B - connection speed (DCE baudrate);
; *L - locked port speed (or 0);
; *P - COM-port number;
; *T - task number;
; *O - (only for OS/2 versions) - handle of open COM port;
; *H - The maximum time (in minutes) that a user may use the BBS.
;      i.e. the time before the period defined in BBS_Time expires.
;
[1] Force_BBS Press <ESC> Twice to Enter kaOs s Node1 !;
[2] Force_BBS Press <ESC> Twice to Enter kaOs s Node2 !;
;
; A short text, given to the remote caller, to identify a human caller 
; requiring access to te BBS software.  This is subject to BBS access time 
; limitations.
;
; Force_NoBBS Sorry.. Mail only event please call back later.; BBS unavailable text
;
; A short text, given to the remote caller, if BBS access is denied.
;
Wait_Mailer 13               ; Time, in seconds, to recognize mailer.
;
; The time, in seconds, during which T-Mail will attempt to identify if the 
; remote caller is a mailer of a human caller.  The default is 13 seconds
; and upon expiration will cause an automatic exit to the BBS software if 
; time constraints allow.
;
Min_Baud 9600              ; Minimum speed for incoming calls
;
; Establishes the minimum speed for remote connection.  Calls slower than 
; this speed will be rejected.
;
; Process FTS-1 gsz.exe port *P speed *B z pr1 rc *F
;
; Defines an external protocol (X-Modem) for the receipt of mail according 
; to FTS-0001.  If not defined, an FTS-0001 session cannot be initiated and 
; is thus not supported.  Received files are placed in the directory defined 
; by the variable Files.
;
; Macros may be used on this command line as substitution variables defined 
; below:
;
; *B - connection speed (DCE baudrate);
; *L - locked port speed (or 0);
; *P - COM-port number;
; *T - task number;
; *O - (only for OS/2 versions) - handle of open COM port;
; *F - name of inbound file (generated by T-Mail automatically).
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; External mailers are initiated by keywords exchanged during  
; handshaking.  Up to 16 external mailers may be defined:
;
; Syntax:
;
; Extern_Mail [[addr_list]] <keyword> <command> [<parameters>]
;
; Example:
; ~~~~~~~
; Extern_Mail [2:5030/124 2:220/22.*] dobb dobbs.bat *P *B *L
; Extern_Mail uuc uupc.bat *B *P
;
; Macros may be used on this command line as substitution variables defined 
; below:
;
; *B - connection speed (DCE baudrate);
; *L - locked port speed (or 0);
; *P - COM-port number;
; *T - task number;
; *O - (only for OS/2 versions) - handle of open COM port;
; *N - number of the description of the Extermail as it appears in T-MAIL.CTL
;
;  Note:  The construct shown above which includes an [addr_list] is only
;         valid for outgoing calls.
;
;  For outgoing calls only it is possible to run an external mailer by 
;  receiving nothing.  Thus T-Mail runs the external mailer instead of 
;  EMSI handshake and session.  To initiate this possibility you should 
;  use the word 'Nothing' as a keyword.
;
;   Example
;   (t-mail.ctl):
;
;   Extern_Mail  [/124.99 /15.99]   Nothing    uupc.bat DIRECT *P
;
; ================================ EMSI/YooHoo Control =======================
;
;                         EMSI/YooHoo handshaking parameters 
;
;-----------------------------------------------------------------------------
;
; You may define a limited sub-set of systems with which your system will 
; communicate.
;
Accept_Nodes All
;
; Defines the systems with which this system will communicate.  For a 
; description of the formation of a list of addresses, see Chapter 2.
;
; Example: 
; ~~~~~~~
;
;        Accept_Nodes 5030/*.* !CM !5030/101
;        Accept_Nodes @c:\t-mail\in_list.txt
;
Flags CM,XA,V32b,V34,VFC,V42b                ; EMSI flags
;
EMSI_OH 00:00-24:00            ; Load answer times to EMSI field
;
EMSI_FR 00:00-24:00            ; Load File request time to EMSI field
;
; Flags defining this system's capabilities
;
; AKA_Mode Yes                 ; Allow mail and files to AKA addresses.
;
; Set to Yes, this will ensure that any mail and files for ALL listed
; AKA addresses will be exchanged along with mail and files for the
; primary address.  If set to No, only mail and files for the primary 
; address will be exchanged.
;
; Ignore_NRQ Yes             ; Ignore remote's NRQ (No_Requests) flag
;
; Set to Yes, will ignore the remote system's "No File Requests" status
; and transmit File Requests anyway.  Set to No, will honor the remote
; system's denial of File Requests.
;
YooHoo_Enable Yes             ;  Enable/Disable YooHoo handshake sessions
;                             ;  while answering.  Default Yes.
;
; ========================== File request control =============================
;
;                     Making and handling File Requests
;
;-----------------------------------------------------------------------------
;
Freq_Time 00:00-23:59; Freq times
;
; The definition of the time period(s) when File requests ARE allowed to
; your system.
;
; Freq_Password Fpassw       ; Password for Freqs
;
; The password which is required, when sending a service message to 
; perform a File Request.  
;
Freq_Dir C:\T-MAIL\DATA\FREQ.LST ; List of directories from which files may be
;                                  requested
;
; The name of a file containing a list of directories (full pathnames) from 
; which files may be requested.  As many directories as required may be 
; specified.
;
Freq_Ndx C:\T-MAIL\DATA\ALIAS.LST           ; Alias list
;
; The name of a file containing a list of alias names and the files to which 
; they refer.  As many aliases as required may be specified.
;
Freq_Number 10                ; Max # Of files which may be requested
;
; The maximum number of files which may be requested, by any system, 
; at any one time.
;
Freq_Size 4098                ; Max. Total size of files (kBytes)
;
; The maximum number of bytes which may be requested, by any system, 
; at any one time.   Default is 2048Kb
;
Freq_Day_Lim 4098            ; Daily Freq limit, kB
Freq_Week_Lim 8196           ; Weekly Freq limit, kB
Freq_Month_Lim 32784         ; Montly Freq limit, kB
;
; File Request limits  on a daily, weekly and monthly basis.  
; Default is 64Mb, 0 = unlimited
;
Freq_MinBaud 9600            ; Min baudrate for Freqs
;
; Minimum speed at which File Requests will be honored.  Default 300bps.
;
Freq_MaxTime 120             ; Time limit for freqs (min)
;
; The maximum time which a File Request may take.  This time is 
; calculated, based upon the fact that the caller's modem does 
; not use data compression.  Default value is 120 minutes and if 
; the File Request exceeds that estimated time, only those files
; which can be transmitted within the allotted time are sent.
;
Freq_Nodes All               ; Who May request files
;
; Defines the list of systems which are permitted to make File Requests
; to this system.  The list of systems is defined according to the 
; rules for creating an <address list> in Chapter 2.
; 
;    Example:
;
;        Freq_Nodes @c:\t-mail\fr_list.txt
;
; If this variable is not defined, File Requests are not supported
;
; Freq_Transit YES            ; Allow In-Transit File requests
;
; Defines if this system will allow File Requests to be to remote 
; systems, VIA this system.  Default is No, disabling the feature.
;
; Freq_Hold YES               ; Pickup File requests
;
; Allow pickup of File requests.
;
Freq_Policy C:\T-MAIL\DATA\policy.frq       ; File to send on Freq failure
;
; Whenever a File Request is refused, T-Mail will send a message to the 
; remote system giving the reasons for the failure.  This file will be
; included in that message.
;
Freq_Confirm Yes            ; Disable File Request confirmation
;
; Allows T-Mail to send a confirmation of a File Request upon
; completion.  Set to No = No confirmation sent.
;
; =============================== Fax definitions =============================
;
;        Variables defining the operations of T-Mail with a Fax mode.
;
;                     Available only in commercial version.
;
;-----------------------------------------------------------------------------
;
; Fax_Class 2                ; Fax Class operations
;
; This variable defines the type of fax modem present.  Permitted values 
; are 2 or 2.0, indicating Fax class 2 or Fax class 2.0.
;
; Fax_Baud 9600              ; Max fax data rate
;
; Defines the maximum speed for Fax transfers.  Ignored for Fax class 2 
; Fax_Lock_Baud 19200        ; Lock at 19200 for faxes
;
; Defines the DTE-DCE baudrate for cases when it differs from that given
; by the Lock_Baud value.  Some types of modem, i.e. US Courier V.* allows 
; Lock_Baud 115200, but Fax_Lock_Baud must be fixed at 19200.
;
; The default value is the same as Lock_Baud.  If Lock_Baud is not
; defined the default will be 19200.
;
; Note: your communication driver, FOSSIL, must NOT be set for a locked
; DCE-DTE baudrate if Fax_Lock_Baud differs from Lock_Baud.
;
; Fax_Mode Any               ; Access level to fax-gate
;
; Defines the list of systems who may access the Fax gate.
;
; Possible values:
;
;                Any - Available to anyone
;                Reg - Available only to systems defined by the variable 
;                      Fax_Nodes
;                Nod - Available to all systems defined in the nodelist.
;                Psw - Available to all systems supplying the correct 
;                      password, which is sent in the Subject field
;                      The password is defined by the variable Fax_password
;
; Fax_Nodes           5030/100.*
;
; Defines the list of addresses which are permitted access to the 
; Fax-Gate.  The <address list> format is defined in Chapter 2.
;
; Examples:
; ~~~~~~~~
; Fax_Nodes 5030/*.* !CM !5030/101
; Fax_Nodes @c:\t-mail\f_list.txt
;
; Fax_Password Fax_it!       ; Fax-gate password
;
; Password for access to the Fax-gate.  This password must be supplied in 
; the Subject field of the inbound message.
;
; Fax_Call 17:38-8:00        ; Fax open hours
;
; Defines the time at which T-Mail will call out to deliver pending 
; Faxes.  Normal mail activity will be interspersed with fax activity
; during fax events.  By default, outbound calls to fax machines are
; not made.
;
; Fax_Tries 25               ; Attempts to send fax message
;
; Defines the number of times to attempt to deliver a fax message.
; Should this number of attempts be made, unsuccessfully, to deliver
; a fax, the System Operator will be informed.
;
; Fax_Answer 18:00-8:00      ; Allow incoming faxes
;
; Defines the times when T-Mail will allow incoming fax calls.  If
; the variable Fax_Adaptive is set to No, T-Mail will only answer
; to fax calls during these hours.
;
; Fax_Inbound C:\faxes       ; Path for received faxes
;                            
; Defines the directory, where fax-messages will be stored.
;
; Fax_ID 358-0-2983308       ; Fax id string
;
; Defines the ID string for fax handshake (20 characters maximum). 
; The ID string from the remote will be shown both on screen and in
; the log.
; 
; Fax_Adaptive Yes           ; Allow adaptive fax/data answer
;
; For Class 2 fax, adaptive answer is supported but may be inhibited.
;
; Fax_Cover cover.gr3        ; filename of fax cover page
;
; The name of the file which will be sent before each fax message
;
;  HINT:
;
;  Fax receiving for faxclass 2.0
;  Below are Andy's settings for the USR Courier:
;
;   Init             ~ATZ|
;   Dial_Prefix  Fax  ATDP
;   Fax_Lock_Baud     19200
;   Lock_Baud         38400
;   Fax_Class         2.0
;   Modem_Answer      ATA|
;   (The active profile is virtually the same as the factory settings)
;
; ============================== Voice definitions ============================
;
;              Parameters for voice Answer-back with ZyXEL modems
;                             Commercial version only.
;
;-----------------------------------------------------------------------------
;
; Voice_Answer 8:00-1:00     ; Allow voice answers
;
; Defines the hours during which voice answer-back will be enabled.
;
; Voice_Password 12345       ; Remote playback password
;
; Defines the password, numeric DTMF tones, which may be used to interrupt 
; the pre-recorded message and causes the playback of files from the 
; voice_inbound to the caller.  The hash character "#" may be used 
; to reset the password if an error occurs.
;
; DTMF tones for the numeric digits 1, 2 and 3 are used for playback control
;
; 1 - next message
; 2 - remove current message, playback next message
; 3 - terminate voice answer-back
;
; Voice_Inbound c:\t-mail\files\voice    ; Voice inbound
;
; The directory in which voice messages are stored
;
; The name of a message file is in the format: ddmmhhnn.zyx
;
; where dd - day of month,
;            mm - month
;            hh - hour
;            nn - minute.
;
; e.g. File 04021355.Zyx was recorded at 13:55 on february 4th.
;
; Voice_Greeting greet.zyx   ; Greeting message
;
; Defines the files, containing a voice message, which will be
; played to a voice caller.
;
; Voice_Max_Time 70          ; Limit (sec) of voice message
;
; Defines the maximum length, in seconds, of a recorded message.
;
; Voice_Silence_Time 4       ; Silence interval (sec)
;
; The maximum length of silence, after which it is assumed that the
; incoming voice message is complete.  If the call did not begin with
; a period of silence, it started with tones, then T-Mail will attempt
; to answer as a modem or fax.  Default interval is 7 seconds.
;
; Voice_Silence_Level 14     ; Silence level, dB
;
; Defines the volume level, below which it is considered silent.
; Default is 16dB.
;
; Voice_StartPlay start.zyx
; Voice_EndPlay end.zyx
; 
;  These variables define that ZYX filenames will be played BEFORE and
;  AFTER playing voice messages in voice inbound
;
; ============================== Port definitions =============================
;
;                  Parameters defining communication port(s)
;
;-----------------------------------------------------------------------------
;
[1] Port 2
[2] Port 3
;
; Defines the number of the COM-port to be used for modem communication.
; A value of 0 may be used when defining a Master system which will
; perform mail packing only.
;
; [1] Xport 3E8
; [2] Xport 2E8
;                            ; for non-standard addresses.
;
HardWare_Flow Yes            ; RTS/CTS flow control
;
; Defines whether hardware or software flow control is used.  Hardware
; flow control is handled by RTS/CTS handshaking and the default is Yes.
;
[1] Baud 38400                   ; Baud rate
[2] Baud 57600
;
; Maximum speed of the modem
;
[1] Lock_Baud 38400             ; Locked port speed
[2] Lock_Baud 57600
;
; Defines the speed at which a communications port is "Locked" by 
; a FOSSIL or communications driver.  See the explanation of the FOSSIL 
; driver in Chapter 4.
;
; Stream_Sending  Yes          ;  use function "send byte"
;                              ;  instead "send block"
;   
; It is possible to anable/disable the block mode in fossil and use
; byte mode instead.  This is controlled by the variable Stream_Sending 
; which has a default of No.  In other words, Fossil transfer is normally
; handled in byte_send but data may be streamed by using this variable.
;
;============================= END OF T-MAIL.CTL FILE =========================
