<?php
/*
 * ----------------------------------------------------------------------------
 * Forum-DispDb.php                                                  08/02/2006
 * This script will display the databases of the specified topic.
 * The variable $t is passed to the script to set the topic number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Reading Messages';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-userfile.inc.php');  // Include userfile functions.
require_once('layout_forum.inc.php');               // Webpage header and footer.

if (isset($_POST['msgupd'])) {              // Set the passed variables.
    $msgupd = (integer) $_POST['msgupd'];
} else {
    $msgupd = 0;
}

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    $t = 1;
}

if ($t < 1) {
    $t = 1;
}

$topic = GetTopicInfo($t, 'M');             // Get the topic information.
// If this is an invalid section, display an error message.
if (!$topic) {
    die('<br /><h4>Invalid topic. Please press the BACK button on your browser.</h4>');
}
// Determine if the user has access to this section.
if ($topic['dbno'] == 0) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if (trim($topic['desc']) != '') {
    $topicDesc = htmlspecialchars($topic['desc']);
} else {
    $topicDesc = '(No Topic Description)';
}

ForumHeader();                              // Display the webpage header.
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="forum-disptopics.php">Back to Forum Topics</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php print HtmlSpace($topicDesc); ?></span></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="425" height="15" bgcolor="#000080" align="left">&nbsp;Forum&nbsp;</td>
        <td class="msgHeader" width="50" height="15" bgcolor="#000080" align="center">&nbsp;Posts&nbsp;</td>
        <td class="msgHeader" width="195" height="15" bgcolor="#000080" align="center">&nbsp;Last Post&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Moderator&nbsp;</td>
    </tr>

<?php
// Set the fileString variable.
$file = $VA_SYSPATHS['main'] . '/DATABASE.CFG';
if (!is_file($file)) {
    die('<br /><h4>Requested configuration file is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

$flag = 1;
for ($x = 1; $flag <= $topic['dbno']; $x++) {
    $db = GetDbInfo($t, $x, $fileString);   // Retrieve the database information.
    $last = GetLastPostInfo($db);           // Retrieve the last post information of the database.
    $dateTime = ConvertDateTime($last['creation']);

    if (strlen($db['desc']) >= 31) {
        $db['desc'] = $db['desc'] . '...';
    }
    
    $moderator = '';
    if ($db['moderator'] != 0) {            // If there is a moderator, get the handle.
        $user = GetUser($db['moderator']);
        $moderator = htmlspecialchars($user['handle']);
    }
    
    $msgno = $db['msgno'];                  // Get the number of messages in the database.
    if (!$msgno) {
        $msgno = 0;                         // If there is no file, then there is no messages.
    }

    if (DbAccess($db)) {
        $flag++;

        if (trim($db['desc']) != '') {
            $dbDesc = htmlspecialchars($db['desc']);
        } else {
            $dbDesc = '(No Description)';
        }
        
        $newMessage = 0;
        if (($USER['userno'] > 0) &&
            ($USER['userno'] != $CONFIG['guestacct'])) {
            if (GetMessagePointer($db, $USER['userno']) < $db['msgno']) {
                if ($msgupd == 0) {     // Check message update.
                    $newMessage = 1;    // New messages detected, update pointer.
                } else {
                    WriteMessagePointer($db, $USER['userno'], $db['msgno']);
                }
            }
        }
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($newMessage == 1) {
                                print 'src="' . $rootDir . 'images/folder-new.gif" alt="Database Folder (New Messages!)"';
                            } else {
                                print 'src="' . $rootDir . 'images/folder.gif" alt="Database Folder"';
                            }
                            ?> width="13" height="11"></td>
        <td width="425" height="30" align="left">
            <span class="heading">&nbsp;<?php
                                        if ($db['networked']) {
                                            print '<img src="' . $rootDir . 'images/networked.gif" alt="Networked Database" width="12" height="11">&nbsp;';
                                        } else {
                                            print '<img src="' . $rootDir . 'images/local.gif" alt="Local Database" width="12" height="11">&nbsp;';
                                        }
                                        if ($msgno > 0) {
                                            print '<a href="forum-dispmsg.php?t=' . $t . '&d=' . $x . '">';
                                        }
                                        print HtmlSpace($dbDesc);
                                        if ($msgno > 0) {
                                            print "</a>";
                                        }
                                        ?>&nbsp;</span></td>
        <td width="50" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="msgBody">&nbsp;<?php print $msgno; ?>&nbsp;</span></td>
        <?php if ($msgno > 0) { ?>
        <td width="195" height="30" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime">&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                          if (!$dateTime['tz']) {
                                                                                                                                              print '*';
                                                                                                                                          }
                                                                                                                                          ?></span><?php
                                                                                                                                                   if ($dateTime['time'] != 0) {
                                                                                                                                                       $from = $last['fromhandle'];
                                                                                                                                                       $pos = strpos($from, '@');
                                                                                                                                                       if (is_int($pos)) {
                                                                                                                                                           $from = substr($from, 0, $pos);
                                                                                                                                                       }
                                                                                                                                                       $char = substr($from, 0, 1);
                                                                                                                                                       if ($char == '<') {
                                                                                                                                                           $from = substr($from, 1);
                                                                                                                                                       }
                                                                                                                                                       if ($char == '"') {
                                                                                                                                                           $pos = strpos($from, '"', 1);
                                                                                                                                                           $from = substr($from, 1, $pos - 1);
                                                                                                                                                       }
                                                                                                                                                       $from = trim(htmlspecialchars($from));
                                                                                                                                                       print '<br /><span class="body">&nbsp;by </span><span class="boldBody">' . HtmlSpace($from) . '&nbsp;</span>';
                                                                                                                                                   }
                                                                                                                                                   ?></td>
        <?php } else if (($USER['userno'] > 0) && ($USER['securitylevel'] >= $db['minwritesl'])) { ?>
        <form action="post-message.php" name="post" method="POST">
            <td width="195" height="30" align="center" nowrap>
                <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                <input type="hidden" name="t" value="<?php print $t; ?>">
                <input type="hidden" name="d" value="<?php print $db['dbno']; ?>">
                <input type="hidden" name="reply" value="0">
                <input type="image" name="submit" src="<?php print $rootDir; ?>images/post.gif" border="0" alt="Post a New Message" width="80" height="25">
            </td>
        </form>
        <?php } else { ?>
        <td width="195" height="30" align="center" nowrap></td>
        <?php } ?>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body"><?php print HtmlSpace($moderator); ?></span></td>
    </tr>

<?php
    }
}
?>

    <form name="msgupd" method="post" action="forum-dispdb.php?t=<?php print $t; ?>">
        <input type="hidden" name="msgupd" value="1">
        <tr>
            <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">&nbsp;
                <?php
                if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct'])) {
                    print '<a class="msgHeader" href="javascript: document.msgupd.submit()">Update Topic Message Pointers</a>';
                    print '&nbsp;|&nbsp;<a class="msgHeader" href="subscribe.php?t=' . $t . '">Edit Subscription</a>';
                }
                ?>
            </td>
        </tr>
    </form>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="forum-disptopics.php">Back to Forum Topics</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php

ForumFooter();                              // Display the webpage footer.

?>