<?php
/*
 * ----------------------------------------------------------------------------
 * Post-Email_Help.php                                               10/14/2006
 * Email Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Sending Email';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>Email Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="post" />
<p>
    <span style="color: #FFFFFF"><b>Posting an Email</b></span>
    <br />
    Sending emails from a BBS has advantages over other methods since you can
    send email to many different networks using the same interface.
    <br /><br />
    To send a local email, simply type in the user's handle (or user number) in
    the To: field. Make sure the drop down box is set to "Local". Enter a
    subject for the message, then write the message content. When you are
    finished, press "Submit". That's it!
    <br /><br />
    To send a network email, enter the user's network email address in the form
    "user@system". You may be familiar with internet email which is in the same
    form and looks like "someone@domain.com". Another type of network is
    FidoNet, and an address may look like "someone@1:18/15". Set the drop down
    box to the appropriate network that the message should pass through. Enter
    a subject for the message, then write the message content. When you are
    finished, press "Submit". Not hard at all!
    <br /><br />
    If you have a high enough access level, you may be able to send attached
    files as well. To send a file, press the "Browse" button to browse through
    your hard drive to find the file. Once you find the file, click on it and
    the location should appear next to "Att file". When you submit the message,
    the file will be uploaded and attached to the message.
</p>

<?php
if ($USER['securitylevel'] >= 255) {
?>
<a name="all" />
<p>
    <span style="color: #FFFFFF"><b>Sending Mail to All Users</b></span>
    <br />
    As the SysOp, you are able to send one email that will be delivered to all
    users, or to a specific group of users. This is very useful for making
    system wide announcements or sending information to user groups.
</p>
<p>
    To send an email to all users, just address it to "all users" (without quotes).
</p>
<p>
    To specify a group of users based on security level, user flags or access
    flags, use these identifiers:
    <br /><br />
    ">" Allows you to specify users with a security level higher than the value.
    <br />
    For example: "all users > 10" sends to all users with a security level greater than
    10.
    <br /><br />
    "<" Allows you to specify users with a security level lower than the value.
    <br />
    For example: "all < 10" sends to all users with a security level lower than
    10.
    <br /><br />
    "=" Allows you to specify users with a specific security level.
    <br />
    For example: "all users = 10" sends to all users with a security level of 10.
    <br /><br />
    "!" Allows you to specify users that have a specific user flag set.
    <br />
    For example: "all users ! F" sends to all users that have user flag "F" enabled.
    <br /><br />
    "$" Allows you to specify users that have a specific access flag set.
    <br />
    For example: "all users $ F" sends to all users that have access flag "F" enabled.
    <br /><br />
    <b>NOTE: Currently you cannot specify more than one identifier. If you do, then
    it will use the first identifier listed.</b>
</p>
<?php
}
?>
</body>

</html>