<?php
/*
 * ----------------------------------------------------------------------------
 * RegistrationBox_Help.php                                          10/14/2006
 * New User Registration Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'New User Registration';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>Registration Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="username" />
<p>
    <span style="color: #FFFFFF"><b>Username/Handle</b></span>
    <br />
    Enter a name that you wish to use to login to the system. This name will
    also be what you are referred as while using the system. You may use your
    real name if you choose to do so.
</p>

<a name="password" />
<p>
    <span style="color: #FFFFFF"><b>Password</b></span>
    <br />
    Your password can be up to eight characters in length. You will be asked for
    it when attempting to login the system. Make your password something that
    is not guessable that contains both numbers and letters. You will have to
    enter the password twice in order to verify that it is what you want.
</p>

<a name="realname" />
<p>
    <span style="color: #FFFFFF"><b>Real Name</b></span>
    <br />
    Enter your real name. If invalid or false information is given, the account
    could be suspended or deleted.
</p>

<a name="address" />
<p>
    <span style="color: #FFFFFF"><b>Address</b></span>
    <br />
    Enter your street address.
</p>

<a name="city" />
<p>
    <span style="color: #FFFFFF"><b>City</b></span>
    <br />
    Enter the city in which you are currently living.
</p>

<a name="state" />
<p>
    <span style="color: #FFFFFF"><b>State</b></span>
    <br />
    Enter the state or province that you are currently living.
</p>

<a name="zipcode" />
<p>
    <span style="color: #FFFFFF"><b>Zip Code</b></span>
    <br />
    Enter your zip code.
</p>

<a name="voice" />
<p>
    <span style="color: #FFFFFF"><b>Phone Number</b></span>
    <br />
    Enter your telephone number including area code.
</p>

<a name="data" />
<p>
    <span style="color: #FFFFFF"><b>Fax/Data Number</b></span>
    <br />
    Enter your fax or data line telephone number including area code.
</p>

<a name="bday" />
<p>
    <span style="color: #FFFFFF"><b>Birthday</b></span>
    <br />
    Enter your birthdate in the format MM/DD/YYYY. This is used to verify
    your age.
</p>
</body>

</html>