<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_Main_Help.php                                             10/14/2006
 * Main Configuration Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>Main VConfig Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="bbsname" />
<p>
    <span style="color: #FFFFFF"><b>BBS Name</b></span>
    <br />
    The name of your BBS.
    <br />
    Default = Virtual Advanced BBS
</p>

<a name="sysopname" />
<p>
    <span style="color: #FFFFFF"><b>SysOp Name</b></span>
    <br />
    The name of the SysOp or System Administrator. Whether you enter your real
    name here, or an alias is up to you. If you have multiple system operators
    then this field should contain the name of the primary operator.
    <br />
    Default = SysOp
</p>

<a name="timezone" />
<p>
    <span style="color: #FFFFFF"><b>Local Time Zone</b></span>
    <br />
    This field should contain a description of the time zone your BBS is
    located in. For US SysOps, there are generally four time zones: Eastern,
    Central, Mountain and Pacific. The proper abbreviation depends on the time
    of year:
    <br /><br />
    Standard Time:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; EST, CST, MST, PST
    <br />
    Daylight Savings Time: EDT, CDT, MDT, PDT
    <br /><br />
    Note: This matters in VADV-PHP! You need to change the time zone
    abbreviation when daylight savings comes and goes. If you do not, then the
    times associated with messages will be off.
    <br />
    Default = EST (-0500)
</p>

<a name="wfcdrives" />
<p>
    <span style="color: #FFFFFF"><b>WFC Drive List</b></span>
    <br />
    This is the list of hard drives you want displayed on the WFC (Waiting-For-
    Call) screen. The drive letter, size, free space, and percentage of space
    free will be displayed. If free space drops below a particular percentage,
    that display line will change color.
    <br />
    Default = C
</p>

<a name="phoneformat" />
<p>
    <span style="color: #FFFFFF"><b>Phone Number Format</b></span>
    <br />
    This settings lets you customize the entry format for phone numbers as
    prompted during new user account creation. United States systems, for
    example, should set this field to ###-###-####. Non-US systems should set
    this field as appropriate for their local calling region.
    <br />
    Default = ###-###-####
</p>

<a name="netlowtime" />
<a name="nethightime" />
<p>
    <span style="color: #FFFFFF"><b>Net Low Time</b></span>
    <br />
    <span style="color: #FFFFFF"><b>Net High Time</b></span>
    <br />
    These two settings let you specify a period of time for network transfers.
    During net time, users calling the BBS will receive the text message as
    configured in the external string file and be logged off. This is a way to
    open up a busy BBS for network calls, typically late at night. Use of this
    feature may be required in some networks. The "net low time" is the
    beginning of the net period; the "net high time" is the end of the net
    period. The times must be entered in HH:MM format using military time; if
    both are set to 00:00, the feature is disabled.
    <br />
    Default = 00:00
</p>

<a name="qwkfilename" />
<p>
    <span style="color: #FFFFFF"><b>QWK Packet Name</b></span>
    <br />
    This is the name you wish to give to QWK packets being sent from your
    system. It is recommended that you give this field a unique six-character
    alphanumeric name.
    <br />
    Default = VA1QWK
</p>

<a name="tossopt" />
<p>
    <span style="color: #FFFFFF"><b>Tossing Options</b></span>
    <br />
    The possibilities of this switch are:
    <br /><br />
    Direct - Incoming network posts written directly to the destination
    database, skipping LOCAL.NET and increasing system efficiency.
    <br /><br />
    Background - Instructs mail tossers to toss mail in the background, if
    possible, after completing network transfers with other systems.
    <br /><br />
    LoadSense - Allows the mail tosser to sense when users are online. When
    users are online, a small amount of CPU time is yielded by the mail tosser
    so that the system is more responsive to users, while only slightly slowing
    the pace of mail tossing. When no users are online, the mail tosser goes
    at full speed.
    <br /><br />
    Standard - This indicates that all three switches are disabled.
    <br /><br />
    The switches Direct, Background, and LoadSense may be used together in any
    desired combination.
    <br />
    Default = Standard
</p>

<a name="uploadscan" />
<p>
    <span style="color: #FFFFFF"><b>New Upload Scanner</b></span>
    <br />
    If set to Scan & Warn, VADV will automatically scan uploaded files for
    viruses, alert you, and keep the file for your inspection. If set to Scan &
    Delete, a suspect upload will be automatically deleted. If set to Disabled,
    VADV will not check uploaded files at all.
    <br /><br />
    The included scanner programm automatically identifies the archive format
    (ZIP, ARJ, LZH, and ARC) and also tests upload files for integrity. In
    addition, it automatically adds your archive comment (ZIPCOMNT.TXT) and reads
    file descriptions provided in FILE_ID.DIZ format.
    <br /><br />
    The default virus scanner software supported by the upload checker is McAfees
    SCAN software for DOS and OS/2. A log file, UPLOAD.LOG is created for your
    review. Alternate virus scanners can be configured through SCANNER1.CFG and
    SCANNER2.CFG files. View the VADV documentation for more information.
    <br />
    Default = Disabled
</p>

<a name="logdetail" />
<p>
    <span style="color: #FFFFFF"><b>Log Detail Level</b></span>
    <br />
    This defines the level of detail that VADV maintains in its BBS.LOG file.
    There are two settings: Normal, which shows the typical actions of a user
    (login time, door calls, etc.), and Extended, which also shows the
    individual key-strokes the user makes at the various menus within the
    system.
    <br /><br />
    The Extended level is useful for tracking the users of the BBS; it can be
    particularly helpful in identifying users who head straight for the Game or
    File Transfer sections.
    <br />
    Default = Normal
</p>

<a name="logoffbat" />
<p>
    <span style="color: #FFFFFF"><b>Logoff BAT/CMD</b></span>
    <br />
    There are three possibile settings for this option: No, Channel 1 Only, and
    All Channels. This option allows you to configure utilities (archive
    converters, information updates, etc.) to be run when a user logs off.
    <br /><br />
    Parameters passed to the batch file are:
    <br />
    %1 Channel Number
    <br />
    %2 COM Port
    <br />
    Default = No
</p>

<a name="multitasker" />
<p>
    <span style="color: #FFFFFF"><b>Multitasker</b></span>
    <br />
    This switch lets you optimize program execution depending on which
    multitasker (Desqview, Windows 3.1, Windows 95, Windows NT, or OS/2) you
    may optionally be using to multitask two or more sessions of VADV.
    <br />
    Default = Disabled
</p>

<a name="allowhandle" />
<p>
    <span style="color: #FFFFFF"><b>Allow Handles</b></span>
    <br />
    If this setting is set to No, then users will be required to use their
    real name as their Account or Login ID. If this setting is set to Yes, then
    users are free to use either their real name, or an arbitrary "handle"
    identification for their Login ID.
    <br />
    Default = Yes
</p>

<a name="needwfcpw" />
<p>
    <span style="color: #FFFFFF"><b>System PW at WFC</b></span>
    <br />
    If this is set to Yes, then the system password is required to access
    certain functions from the WFC screen. It is useful if your BBS needs to be
    secure locally; if you have a lot of your users dropping by, or if you
    have small children lurking about the computer, for example.
    <br />
    Default = No
</p>

<a name="ignoreext" />
<p>
    <span style="color: #FFFFFF"><b>Ignore Extension</b></span>
    <br />
    VADV automatically checks for duplicates when a caller uploads a new file to
    the system. With this option enabled, VADV will treat filenames with the
    same name (but different extensions) as being the same, and therefore,
    duplicates of each other.
    <br />
    Default = No
</p>

<a name="forcefilename" />
<p>
    <span style="color: #FFFFFF"><b>Require Filename Entry</b></span>
    <br />
    If set to No, the user is given the choice between entering filenames and
    descriptions prior to upload or after the upload. If set to Yes, the user
    is required to enter filenames and descriptions before the upload. When
    filenames and descriptions are entered before the upload, the user is also
    given the optoin to automatically logoff when the upload is complete.
    <br /><br />
    It should also be noted that once the file has actually been received, the
    BBS will check for the existance FILE_ID.DIZ within the archive, and make
    use of that description data also.
    <br />
    Default = No
</p>

<a name="inversebar" />
<p>
    <span style="color: #FFFFFF"><b>Inverse Bar</b></span>
    <br />
    If set to Yes, an inverse-color bar will be drawn on certain input fields,
    to show the user how much space he/she has to enter the information. If set
    to No, the bar is not displayed.
    <br />
    Default = No
</p>

<a name="displaynet" />
<p>
    <span style="color: #FFFFFF"><b>Display Networks</b></span>
    <br />
    If set to No, minimal network information is displayed when the user does
    an online database listing. If set to Yes, then full network information
    is displayed.
    <br />
    Default = No
</p>

<a name="forcefeedback" />
<p>
    <span style="color: #FFFFFF"><b>Force Feedback</b></span>
    <br />
    If set to Yes, then external string #397 is displayed to the new user, and
    they are prompted to leave feedback to the SysOp.
    <br />
    Default = No
</p>

<a name="checkpolls" />
<p>
    <span style="color: #FFFFFF"><b>Auto-Check Polls</b></span>
    <br />
    If set to Yes, VADV checks to see if there are voting questions the user
    has not answered yet. If new questions are found, the user is prompted to
    vote.
    <br />
    Default = No
</p>

<a name="directmail" />
<p>
    <span style="color: #FFFFFF"><b>Allow DIRECTmail</b></span>
    <br />
    If set to Yes, DIRECTmail is enabled. This is necessary for DIRECTmail
    FREQ ability.
    <br /><br />
    For DIRECTmail to pass between two VADV systems, this feature must be
    enabled at BOTH ends of the connection.
    <br />
    Default = No
</p>

<a name="secuploads" />
<p>
    <span style="color: #FFFFFF"><b>Secure Uploads</b></span>
    <br />
    If set to Yes, then all new uploads are pathed to the \SYSOP directory,
    where they sit until the SysOp manually moves them to their proper
    directories. If set to No, uploads go directly into the directory in which
    they're uploaded.
    <br /><br />
    When enabled, you have the ability to check over each file before it is
    made available to the users of your BBS.
    <br />
    Default = Yes
</p>

<a name="sysfkey" />
<p>
    <span style="color: #FFFFFF"><b>SysOp F-Key Lockout</b></span>
    <br />
    When set to Yes, the SysOp Function Keys normally available to a SysOp when
    he/she or a user is online, are disabled. You would use this option if you
    are using VADV as a multi-user mail system on a local area network with many
    people using the system locally (ie not via modem).
    <br />
    Default = No
</p>

<a name="detectfido" />
<p>
    <span style="color: #FFFFFF"><b>Detect FIDOnet</b></span>
    <br />
    If set to Yes, VADV internal FIDOnet detection is enabled. The included
    VFIDO.EXE is called upon to handle the remainder of the call if an
    incoming FIDOnet call is detected.
    <br />
    Default = Yes
</p>

<a name="allowremote" />
<p>
    <span style="color: #FFFFFF"><b>Allow Remote SysOp</b></span>
    <br />
    If set to Yes, VADV will allow remote SysOp logins (security level >= 255).
    If set to No, then VADV will allow the caller to login, but at only 254 SL.
    <br />
    Default = Yes
</p>

<a name="autopostsl" />
<p>
    <span style="color: #FFFFFF"><b>Autopost</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to write an autopost
    on the system.
    <br />
    Default = 10
</p>

<a name="emlothers" />
<p>
    <span style="color: #FFFFFF"><b>Email Others</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to write email to
    other users (other than the SysOp). You might use this to screen out problem
    users who misuse the email functions of your BBS.
    <br />
    Default = 10
</p>

<a name="emlsysfile" />
<p>
    <span style="color: #FFFFFF"><b>Email SysOp Att File</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to write email to
    the sysop with attached file.
    <br />
    Default = 10
</p>

<a name="emlotherfile" />
<p>
    <span style="color: #FFFFFF"><b>Email Other Att File</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to write email to
    other users with attached file.
    <br />
    Default = 50
</p>

<a name="multimail" />
<p>
    <span style="color: #FFFFFF"><b>MultiMail</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to be allowed to
    use the system's multi-mail (Mail List) facilities.
    <br />
    Default = 255
</p>

<a name="carboncopy" />
<p>
    <span style="color: #FFFFFF"><b>Email Carbon Copy</b></span>
    <br />
    This setting is the minimum security level (MSL) needed to be allowed to
    use the carbon copy feature.
    <br />
    Default = 255
</p>

<a name="newusersl" />
<p>
    <span style="color: #FFFFFF"><b>Security Level</b></span>
    <br />
    This setting specifies the security level which is assigned to new users
    who call your BBS.
    <br />
    Default = 1
</p>

<a name="newusertime" />
<p>
    <span style="color: #FFFFFF"><b>Time Limit</b></span>
    <br />
    This setting specifies the time limit which is assigned to new users who
    call your BBS.
    <br />
    Default = 10
</p>

<a name="nucredits" />
<p>
    <span style="color: #FFFFFF"><b>Credits</b></span>
    <br />
    This setting specifies the number of credits which are given to new users
    who call your BBS.
    <br />
    Default = 0
</p>

<a name="creditcost" />
<p>
    <span style="color: #FFFFFF"><b>Cost per Minute</b></span>
    <br />
    This setting specifies the number of credits deducted per minute of online
    time used by the caller. A setting of zero disables this feature.
    <br />
    Default = 0
</p>

<a name="credperdlk" />
<p>
    <span style="color: #FFFFFF"><b>Cost per Download KB</b></span>
    <br />
    This setting specifies the number of credits deducted per kilobyte
    downloaded by the caller. A setting of zero disables this feature.
    <br />
    Default = 0
</p>

<a name="credperpost" />
<p>
    <span style="color: #FFFFFF"><b>Given per Post</b></span>
    <br />
    This setting specifies the number of credits awarded per message posted by
    the caller. A setting of zero disables this feature. Note that if a user
    posts a message and deletes it, they lose the credits they were awarded.
    This keeps callers from posting nonsense just to get credits.
    <br />
    Default = 0
</p>

<a name="credperuplk" />
<p>
    <span style="color: #FFFFFF"><b>Given per Upload KB</b></span>
    <br />
    This setting specifies the number of credits awarded per kilobyte uploaded
    by the caller. A setting of zero disables this feature.
    <br />
    Default = 0
</p>

<a name="cbvsl" />
<p>
    <span style="color: #FFFFFF"><b>Security Level</b></span>
    <br />
    This setting specifies the security level assigned to new users who
    successfully pass call-back verification. A setting of zero for this field
    disables the call-back verifier.
    <br />
    Default = 0
</p>

<a name="cbvtime" />
<p>
    <span style="color: #FFFFFF"><b>Time Limit</b></span>
    <br />
    This setting specifies the time limit assigned to new users who
    successfully complete call-back verification.
    <br />
    Default = 0
</p>

<a name="autosysopsl" />
<p>
    <span style="color: #FFFFFF"><b>Security Level</b></span>
    <br />
    This setting specifies the security level assigned to new users who request
    auto-sysop validation. A setting of zero for this field disables auto-sysop
    validation.
    <br />
    Default = 0
</p>

<a name="autosysoptime" />
<p>
    <span style="color: #FFFFFF"><b>Time Limit</b></span>
    <br />
    This setting specifies the time limit assigned to new users who request
    auto-sysop validation.
    <br />
    Default = 0
</p>

<a name="timeout" />
<p>
    <span style="color: #FFFFFF"><b>Inactivity Timeout</b></span>
    <br />
    This numeric value determines how long a user may remain inactive (not typing
    anything) before being automatically logged off the BBS. The value is
    expressed in seconds, and the user will receive a "beep" warning at the
    midpoint of the interval. For example, a setting of 360 seconds would allow
    for 6 minutes of inactivity. The user would receive an audible warning
    after 3 minutes, and be logged off after 3 more minutes of inactivity.
    <br />
    Default = 300
</p>

<a name="sblank" />
<p>
    <span style="color: #FFFFFF"><b>Blank WFC Screen</b></span>
    <br />
    This setting configures the VADV automatic WFC (Waiting For Call) screen
    blanker. Like the "Timeout" option, this value is expressed in seconds; a
    value of 300 seconds in this field would blank the WFC screen after 5
    minutes. A value of 0 in this field disables screen blanking.
    <br />
    Default = 0
</p>

<a name="reservekb" />
<p>
    <span style="color: #FFFFFF"><b>Reserve Space (KB)</b></span>
    <br />
    This setting, expressed in kilobytes (KB), instructs VADV to reserve some
    of your hard-drive space so that sufficient space to operate the BBS is
    always available on your hard drive. When the free space on your upload
    drive drops below this value, uploads will not be allowed onto the board;
    this is for your protection. A value of 0 in this field disables this
    feature.
    <br />
    Default = 0
</p>

<a name="maxchannelno" />
<p>
    <span style="color: #FFFFFF"><b># Active Channels</b></span>
    <br />
    This setting lets you optimize VADV for the number of simultaneous online
    users (active ports) that you will be running on your multi-user VADV
    installation. If you have two lines running into your multi-user VADV, set
    this to 2; if you have four lines, set it to 4, and so on. Single-line VADV
    installations should set this value to 1.
    <br />
    Default = 1
</p>

<a name="polldelay" />
<p>
    <span style="color: #FFFFFF"><b>Network Poll Delay</b></span>
    <br />
    This setting configures how often VADV checks to see if it needs to perform
    some type of automatic network dial-out. It is expressed in seconds (i.e.,
    a value of 600 would represent 10 minutes).
    <br />
    Default = 300
</p>

<a name="qwklimit" />
<p>
    <span style="color: #FFFFFF"><b>QWK Message Limit</b></span>
    <br />
    This setting defines the maximum number of QWK messages to put into one QWK
    packet.
    <br /><br />
    Suggesting a good number to enter in this field is difficult to do. If you
    have a large number of active networked message bases, you will probably
    want to set this high (say, 500 or so). This is a trial-and-error setting,
    but easily changed.
    <br />
    Default = 500
</p>

<a name="mailholdtime" />
<p>
    <span style="color: #FFFFFF"><b>Mail Hold Time</b></span>
    <br />
    This specifies the time, in days, that E-mail should be kept active on the
    system. When an E-mail reaches the age limit, it is automatically purged
    from the BBS. A value of 0 disables this feature, although this is not
    recommended.
    <br />
    Default = 90
</p>

<a name="maxtimebank" />
<p>
    <span style="color: #FFFFFF"><b>Max Time Bank</b></span>
    <br />
    This specifies the maximum number of minutes that a user may deposit into
    their time bank. A setting of zero will disable the built-in time bank
    features.
    <br />
    Default = 90
</p>

<a name="redials" />
<p>
    <span style="color: #FFFFFF"><b>Redial Attempts</b></span>
    <br />
    This specifies the number of network redial attempts VADV's network
    utilities should make for each try.
    <br />
    Default = 1
</p>

<a name="ringtoanswer" />
<p>
    <span style="color: #FFFFFF"><b>Rings to Answer On</b></span>
    <br />
    This setting defines how many times the phone will be allowed to ring before
    VADV answers. For most installations, a setting of 1 is proper. If you have
    Caller ID on your system, you may want to set this to 2 to give your
    equipment time to "capture" the originating phone number.
    <br />
    Default = 1
</p>
</body>

</html>