<?php
/*
 * ----------------------------------------------------------------------------
 * AT2k.inc.php                                                      02/26/2005
 * This script contains functions that work with AT2k scripts and programs.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* AT2k.inc.php :: GetNewsListConfig()
*
* This function will return the complete newslist configuration. It is in the
* format of $config[topicno][dbno]['setting'].
*
* @return
*/
function GetNewsListConfig() {
    global $VA_SYSPATHS;                    // Global variable.

    $file = $VA_SYSPATHS['text'] . '/NEWSLIST.CFG';

    if (!is_file($file)) {
        return FALSE;
    }

    $datFile = $VA_SYSPATHS['text'] . '/NEWSLIST.';
    $config = ReadAt2kConfig($file);

    if (!$config) {
        return FALSE;
    }

    $tempCfg = explode(',', $config[1]);
    $newsConfig['ver']  = $tempCfg[0];
    $newsConfig['help'] = (boolean) $tempCfg[1];

    // Get topics.
    $cnt = 0;
    $pos = 1;
    for ($x = 2; $x <= count($config); $x++) {
        $tempCfg = explode(',', $config[$x]);
        $newsConfig[$pos]['desc'] = trim(StripBBSCodes($tempCfg[0]));
        $newsConfig[$pos]['path'] = trim($tempCfg[1]);
        $cnt++;
        $pos++;
    }
    $newsConfig[0] = $cnt;                  // Total number of topics.

    // Get databases.
    for ($x = 1; $x <= $newsConfig[0]; $x++) {
        $config = ReadAt2kConfig($datFile . $x, 0);
        $cnt = 0;
        $pos = 1;
        if ($config != FALSE) {
            for ($y = 1; $y <= count($config); $y++) {
                $newsConfig[$x][$pos]['display']  = trim(substr($config[$y], 0, 1));
                $newsConfig[$x][$pos]['filename'] = trim(substr($config[$y], 1, 12));
                $newsConfig[$x][$pos]['desc']     = trim(StripBBSCodes(substr($config[$y], 14)));
                $cnt++;
               $pos++;
            }
        }
        $newsConfig[$x][0] = $cnt;          // Total number of bulletins.
    }

    return $newsConfig;                     // Return the configuration.
}


/**
* AT2k.inc.php :: GetPostItConfig()
*
* This function will retrieve the Post-It! Network configuration. It is in the
* format of $config['setting'].
*
* @return mixed
*/
function GetPostItConfig() {
    global $VA_SYSPATHS;                    // Global variable.

    $file = $VA_SYSPATHS['text'] . '/POSTITNT.CFG';

    if (!is_file($file)) {
        return FALSE;
    }

    $config = ReadAt2kConfig($file);

    if (!$config) {
        return FALSE;
    }

    // Setup the configuration variable array.
    $postitCfg['ver']         = $config[1];
    $postitCfg['topic']       = strtoupper($config[2]);
    $postitCfg['topicno']     = ord($postitCfg['topic']) - 64;
    $postitCfg['db']          = (integer) $config[3];
    $postitCfg['networknode'] = $config[4];
    $postitCfg['vnetnode']    = $config[5];
    $postitCfg['minwritesl']  = (integer) $config[6];
    $postitCfg['filter']      = (boolean) $config[7];

    return $postitCfg;                      // Return the configuration.
}


/**
* AT2k.inc.php :: GetSysNewsConfig()
*
* This function will read the sysnews.v script and extract the database
* information. It is in the format of $config['setting'].
*
* @return mixed
*/
function GetSysNewsConfig() {
    global $VA_SYSPATHS;                    // Global variable.

    $file = $VA_SYSPATHS['script'] . '/SYSNEWS.V';

    if (!is_file($file)) {
        return FALSE;
    }

    $fileArray = file($file);               // Read the file into an array.

    if (!$fileArray) {
        return FALSE;
    }

    // Set default values.
    $config['topicno'] = 0;
    $config['topic'] = '';
    $config['db'] = 0;

    for ($x = 0; $x < count($fileArray); $x++) {
        $line = str_replace(' ', '', $fileArray[$x]);   // Take out all spaces.
        $searchGroup = substr($line, 0, 7); // Search variable for DBGROUP.
        $searchDb = substr($line, 0, 2);    // Search variable for DB.
        if (strtoupper($searchGroup) == 'DBGROUP') {
            $config['topic'] = strtoupper(substr($line, 8, 1));
        } else if (strtoupper($searchDb) == 'DB') {
            $config['db'] = (integer) substr($line, 2, 1);
            break;
        }
    }

    if (($config['topic'] == '') || ($config['db'] == 0)) {
        return FALSE;
    }

    $config['topicno'] = ord($config['topic']) - 64;

    return $config;                         // Return the configuration.
}

?>