<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Random.inc.php                                                 11/24/2006
 * This script will retrieve all of the random quotes from the BBS's
 * RANDOM.CFG file and store them into a simple array.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Random.inc.php :: GetRandomQuotes()
*
* This function will put all of the VADV random quotes into a simple array.
*
* @return array
*/
function GetRandomQuotes() {
    $fileString = ReadRandom();
    if ($fileString === FALSE) {
        trigger_error(VA_Error(3));
    }

    $random = array();                      // Create the array.
    $offset = 0;
    
    for ($x = 1; $offset < strlen($fileString); $x++) {
        $random[$x]['line1'] = GetString($fileString, 1 + $offset, 70);
        $random[$x]['line2'] = GetString($fileString, 71 + $offset, 70);
        $random[$x]['line3'] = GetString($fileString, 141 + $offset, 70);
        $random[$x] = trim($random[$x]['line1']) . ' ' . trim($random[$x]['line2']) . ' ' . trim($random[$x]['line3']);
        $offset = 210 * $x;
    }

    $random[0] = $x - 1;                    // Put the number of quotes in position 0.

    return $random;                         // Return the random quotes.
}


/**
* Va-Random.inc.php :: PutRandomQuotes()
*
* This function will change the random.cfg to match the configuration variable
* passed. It then returns the new file string. The configuration variable MUST
* be in the format of $variable[1].
*
* @param string $fileString
* @param array $configVariable
* @return string
*/
function PutRandomQuotes($fileString, $configVariable) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    if (!is_array($configVariable)) {
        trigger_error(VA_Error(1));
    }

    $length  = count($configVariable);      // Get the number of elements in the config variable.
    $pointer = 0;                           // Reset the pointer.
    $offset  = 0;

    if (isset($configVariable[0])) {
        $length--;
    }

    for ($x = 1; $pointer < $length; $x++) {
        $total = intval(strlen($fileString) / 210);
        if ($x > $total) {
            $fileString = $fileString . str_pad('', 210, chr(0));
        }

        if (isset($configVariable[$x])) {
            $pointer++;
            $fileString = PutString($fileString, $configVariable[$x], 1 + $offset, 210);
        }
        $offset = 210 * $x;
    }

    return $fileString;                     // Return the new file string.
}


/**
* Va-Random.inc.php :: ReadRandom()
*
* This function will read the random.cfg file.
*
* @return string
*/
function ReadRandom() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/RANDOM.CFG';
    $fileString = ReadCfgFile($file);       // Read the file.

    return $fileString;                     // Return the file string.
}


/**
* Va-Download.inc.php :: WriteRandom()
*
* This function will write a new random.cfg file based on the file string
* passed to it. If the file string is not in the correct format, then your
* random.cfg file will become corrupt and the BBS could stop functioning!
*
* @param string $fileString
* @return mixed
*/
function WriteRandom($fileString) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }

    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/RANDOM.CFG';
    $status = WriteCfgFile($file, $fileString);

    return $status;                         // Return the result status.
}


// Retrieve the random quotes automatically.
$VA_RANDOMQUOTES = GetRandomQuotes();
 
?>