<?php
/*
 * ----------------------------------------------------------------------------
 * Login.php                                                         10/02/2006
 * This script is called when a user trys to login. If successful, then the
 * user's session data is updated.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if (!isset($_POST['referer'])) {
    die('<br /><h4>An error occurred. Please press the BACK button on your browser.</h4>');
}

if (isset($_POST['url'])) {
    $redirectUrl = $_POST['referer'] . '?url=' . urlencode($_POST['url']);
} else {
    $redirectUrl = $_POST['referer'];
}

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-userfile.inc.php');  // User information.
require_once($includeDir . 'vadv-php_dat.inc.php'); // User settings.

if (isset($_POST['logoff'])) {
    setcookie('vadvphp', '', time() - 86400, '/', '', 0);
    $_SESSION = array('');
    session_destroy();
    RedirectUser($redirectUrl);
}

// Save the default values.
$_SESSION['userno']   = base64_encode(0);
$_SESSION['username'] = base64_encode('');
$_SESSION['password'] = base64_encode('');
$_SESSION['login']    = FALSE;
$_SESSION['mobile']   = FALSE;

if ((isset($_POST['username'])) && (trim($_POST['username']) != '')) {
    $username = trim(htmlspecialchars($_POST['username']));
    if (strlen($username) > 40) {
        $username = substr($username, 0, 40);
    }
} else {
    $username = '';
}

$userno = FindHandle($username);
if ($userno == 0) {
    $userno = FindRealName($username);
}

if (((isset($_POST['password'])) && (trim($_POST['password']) != '')) ||
    ((isset($_POST['md5'])) && (trim($_POST['md5']) != ''))) {
    if ((isset($_POST['md5'])) && (trim($_POST['md5']) != '')) {    // MD5 authentication.
        $md5 = substr(trim($_POST['md5']), 5);      // Remove identifier.
        $loginId = '';
        $user = GetUser($userno);                   // Get user info.
        $userdat = GetUserSettings($userno);        // Get user settings.
        for ($x = 1; $x <= $VA_USERS[0]; $x++) {    // Get user id.
            if ($VA_USERS[$x]['session'] == session_id()) {
                $loginId = $VA_USERS[$x]['id'];
                break;
            }
        }

        UpdateWhosOnline('Logging In...', 900, 1);  // Reset the id.

        if (trim($userdat['password']) == '') {
            $userpw = $user['password'];
        } else {
            $userpw = $userdat['password'];
        }

        if (hmac_md5($loginId, $userpw) === $md5) {
            $password = $userpw;            // Set password as correct.
        } else {
            $password = '';
        }
    } else {                                // Plain text authentication.
        $password = trim(htmlspecialchars($_POST['password']));
        if (strlen($password) > 32) {
            $password = substr($password, 0, 32);
        }
        $password = md5(strtoupper($password));
    }
} else {
    $password = '';
}


if ((isset($_POST['mobile'])) && ($_POST['mobile'] == 1)) {
    $_SESSION['mobile'] = TRUE;
}

// Set the log temp variable.
$_SESSION['login'] = TRUE;

// Save the user's information.
$_SESSION['userno']   = base64_encode($userno);
$_SESSION['username'] = base64_encode($username);
$_SESSION['password'] = base64_encode($password);

// If the remember checkbox is enabled, then set cookie.
if ((isset($_POST['remember'])) &&
    ($_POST['remember'] == 1) &&
    ($CONFIG['cookielife'] > 0)) {
    $cookie     = $_SESSION['userno'] . ' , ' . $_SESSION['username'] . ' , ' . $_SESSION['password'];
    $cookieLife = time() + ($CONFIG['cookielife'] * 86400);
    setcookie('vadvphp', $cookie, $cookieLife, '/', '', 0);
}

RedirectUser($redirectUrl);
?>