<?php
/*
 * ----------------------------------------------------------------------------
 * Index.php                                                         08/20/2006
 * Display VADV-PHP menu to mobile device.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Viewing Home Page';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-database.inc.php');
require_once($includeDir . 'va-main.inc.php');
require_once($includeDir . 'va-control.inc.php');
require_once($includeDir . 'va-misc.inc.php');

// Determine if browswer is HTML capable.
if ((isset($_SERVER['HTTP_ACCEPT'])) &&
    (strpos(strtolower($_SERVER['HTTP_ACCEPT']), 'vnd.wap.wml') !== FALSE)) {   // Check whether the browser/gateway says it accepts WML.
    $br = 'WML';
} else {
    if (isset($_SERVER['HTTP_USER_AGENT'])) {
        $browser = substr(trim($_SERVER['HTTP_USER_AGENT']), 0, 4);
    } else {
        $browser = '';
    }
    if ($browser == 'Noki' ||            // Nokia phones and emulators
        $browser == 'Eric' ||            // Ericsson WAP phones and emulators
        $browser == 'WapI' ||            // Ericsson WapIDE 2.0
        $browser == 'MC21' ||            // Ericsson MC218
        $browser == 'AUR ' ||            // Ericsson R320
        $browser == 'R380' ||            // Ericsson R380
        $browser == 'UP.B' ||            // UP.Browser
        $browser == 'WinW' ||            // WinWAP browser
        $browser == 'UPG1' ||            // UP.SDK 4.0
        $browser == 'upsi' ||            // another kind of UP.Browser ??
        $browser == 'QWAP' ||            // unknown QWAPPER browser
        $browser == 'Jigs' ||            // unknown JigSaw browser
        $browser == 'Java' ||            // unknown Java based browser
        $browser == 'Alca' ||            // unknown Alcatel-BE3 browser (UP based?)
        $browser == 'MITS' ||            // unknown Mitsubishi browser
        $browser == 'MOT-' ||            // unknown browser (UP based?)
        $browser == 'My S' ||            // unknown Ericsson devkit browser ?
        $browser == 'WAPJ' ||            // Virtual WAPJAG www.wapjag.de
        $browser == 'fetc' ||            // fetchpage.cgi Perl script from www.wapcab.de
        $browser == 'ALAV' ||            // yet another unknown UP based browser ?
        $browser == 'Wapa')              // another unknown browser (Web based "Wapalyzer"?)
    {
        $br = 'WML';
    } else {
        $br = 'HTML';
    }
}

if ($br == 'HTML') {
    RedirectUser($rootDir . 'index.php');
}

$control = GetControl();
$usersOnline = $control['activenodes'] + $VA_USERS[0];
$todaysCallers = GetTodaysCallers();

include_once('wml_header.php');
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="<?php print $VA_MAIN['bbsname']; ?>">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Home</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?><br />
            <small><?php print UserDate("m/d/y g:ia"); ?></small>
        </p>
        <p mode="wrap">
            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct'])) {
                print 'Logged in as:<br /><b>' . WMLSpecialChars($USER['handle']) . '</b> (#' . $USER['userno'] . ')<br /><br />' . "\n";
                $msgcnt = GetEmailCount($USER['userno']);
                if ($msgcnt['unread'] > 0) {
                    print 'You have new email!' . "\n";
                } else {
                    print 'You have no new email.' . "\n";
                }
                print '<br />' . "\n";
            }
            ?>
        </p>
        <p mode="nowrap">
            Choose:
            <br />
            <?php
            if (($USER['userno'] == 0) ||
                ($USER['userno'] == $CONFIG['guestacct'])) {
                print '<anchor>Login<go href="login.php" /></anchor>' . "\n";
                print '<br />' . "\n";
            }
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct'])) {
                print '<anchor>Email Menu<go href="email.php" /></anchor>' . "\n";
                print '<br />' . "\n";
            }
            ?>
            <anchor>Who's Online<go href="who.php" /></anchor> (<?php print $usersOnline; ?>)
            <br />
            <anchor>Today's Callers<go href="todays_callers.php" /></anchor> (<?php print $todaysCallers[0]; ?>)
            <?php
            if (($USER['userno'] > 0) &&
                ($USER['userno'] != $CONFIG['guestacct'])) {
                print '<br />' . "\n";
                print '<anchor>';
                print 'Logoff';
                print '<go href="' . $rootDir . 'login.php" method="post">';
                print '<postfield name="logoff" value="logoff" />';
                print '<postfield name="referer" value="wap/index.php" />';
                print '</go>';
                print '</anchor>' . "\n";
            }
            ?>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>