/*****************************************************************************/
/* MAXUSERS.CMD : Make Userlist from Maximus' (v3.0x) USERS.BBS (v0.3)       */
/*                                                                           */
/* This script will read the maximus USERS.BBS file and make a plain ascii   */
/* file (BBSUSERS.LST) with all users (names only).                          */
/*                                                                           */
/* You can than use the file BBSUSERS.LST with WaterGate's WtrUtil2 to make  */
/* the index file for the bbs users.                                         */
/*                                                                           */
/* Are you one of those sysops who don't import their own netmail into the   */
/* online netmail area on your BBS? Do you wan't to leave your own netmails  */
/* in the netmail directory so another netmail utility can handle them?      */
/* Just add the extra '/S' (case unsensitive) switch. Using this switch will */
/* leave user0 (the sysop) out of the BBSUSERS.LST file. Use this switch     */
/* only in this case and only as third parameter.                            */
/*                                                                           */
/* Author: Jos Huijnen                     E-Mail : jos@snake.xs4all.nl      */
/*                                                  the_snake@compuserve.com */
/*                                CompuServe Mail : 101350,1074              */
/*                              Fidonet (Netmail) : 2:284/312                */
/*****************************************************************************/

arg x
parse upper var x maxdir wgdir sysopswitch

call RxFuncAdd 'MaxLoadFuncs', 'MAXUAPI', 'MaxLoadFuncs'
call MaxLoadFuncs

'@echo off'

if maxdir='' | wgdir='' then
do
   say ''
   say ''
   say 'You didn''t specify the drive/path to your Maximus'' USER.BBS'
   say 'or you didn''t specify the drive/path WaterGate is installed.'
   say ''
   say '     Usage   : MAXUSERS [drive]:\[Maximus path] [drive]:\[Watergate path]'
   say '     Example : MAXUSERS C:\MAX C:\WTRGATE'
   say ''
   exit
end
if substr(maxdir,length(maxdir))='\' then maxdir=delstr(maxdir,length(maxdir))
if lines(maxdir || '\USER.BBS')=0 then
do
   say ''
   say ''
   say 'Path to Maximus'' USER.BBS is incorrect or doesn''t exist.'
   say 'Correct the path (and check if the file USER.BBS is really there).'
   say ''
   exit
end
call lineout(maxdir || '\USER.BBS')
if substr(wgdir,length(wgdir))='\' then wgdir=delstr(wgdir,length(wgdir))
if lines(wgdir || '\WTRCFG.TDB')=0 then
do
   say ''
   say ''
   say 'Drive/path where WaterGate is installed is not correct or doesn''t exist.'
   say 'Start MAXUSERS with the correct path.'
   say ''
   exit
end
call lineout(wgdir || '\WTRCFG.TDB')
nosysop=0
if sysopswitch='/S' then nosysop=1
if lines(wgdir || '\BBSUSERS.LST')<>0 then
do
   call lineout(wgdir || '\BBSUSERS.LST')
   'DEL ' || wgdir || '\BBSUSERS.LST'
end
huf = UserFileOpen(maxdir || '\USER', '')
if huf=-1 then
do
   say 'Error opening user file!'
   exit
end
huff=UserFileFindOpen(huf, '', '')
if huff=-1 then
   say 'Error doing userfilefindopen!'
else do
   do until UserFileFindNext(huff, '', '')=0
      user=left(usr.name,33)
      if usr.num=0 & nosysop=0 then rc=lineout(wgdir || '\BBSUSERS.LST',user)
      if usr.num<>0 then rc=lineout(wgdir || '\BBSUSERS.LST',user)
   end
   rc=UserFileFindClose(huff)
end
rc=UserFileClose(huf)
if rc<>1 then
do
   say 'Error closing user file!'
   exit
end
