@echo off & setlocal enableextensions

rem This script file is part of the following collection:
rem   ftp://garbo.uwasa.fi/pc/link/tscmd.zip
rem   Useful NT/2000/XP script tricks and tips, T.Salmi
rem Please do not distribute separately from that package.

echo Ŀ
echo  NAMEDOWN.CMD Covert a filename to lower case 
echo  By Prof. Timo Salmi                          
echo  Last modified Sat 22-Dec-2007                
echo 
echo.

rem Converts also the Scandinavian characters
rem   --    --    -- 
rem If you do not want that customize the ToLowCase subroutine

:: Usage
if [%1]==[] (
  echo Usage: "%~f0" "FileName.Ext"
  echo.
  echo For wildcards use e.g.
  echo. for %%f in ^("*.*"^) ^do namedown "%%f"
  echo. for %%f in ^("*.HTM"^) do call namedown "%%f"
  echo. for %%f in ^("*.JPG"^) do call namedown "%%f"
  if not defined cmdbox if defined PauseIfFromDesktop pause
  goto :EOF)

:: Don't allow wildcards
echo "%1"|findstr "[*?]">nul
if %errorlevel% EQU 0 (
  echo Wildcards not allowed in %1
  echo.
  echo Apply e.g.
  echo. for %%f in ^("*.*"^) ^do namedown "%%f"
  echo. for %%f in ^("*.HTM"^) do call namedown "%%f"
  echo. for %%f in ^("*.JPG"^) ^do namedown "%%f"
  goto :EOF)

:: Test for LFN peculiarities
if not [%2]==[] (
  echo A file name with spaces in it should be enclosed in parentheses ""
  goto :EOF)

:: Check that the file exists
if exist "%~f1" goto _getname
echo File %~f1 not found
goto _out

:: Get the file's parts
:_getname
set fullname_=%~f1
set name_=%~n1
set ext_=%~x1

:: Covert to lower case
call :ToLowCase "%name_%" name_
call :ToLowCase "%ext_%" ext_

:: Ask for confirmation
:_ask
set ask_=
echo Convert "%fullname_%" to "%name_%%ext_%"
set /p ask_="are you sure [n/Y]?"
if /i [%ask_%]==[n] goto :EOF
if /i not [%ask_%]==[y] if not [%ask_%]==[] goto _ask
set ask_=

:: Do the conversion
ren "%fullname_%" "%name_%%ext_%"
echo.
dir "%fullname_%"

:_out
if not defined cmdbox if defined PauseIfFromDesktop pause
endlocal & goto :EOF

:: ====================================================================
:ToLowCase
setlocal enableextensions
set var_=%1
set var_=%var_:A=a%
set var_=%var_:B=b%
set var_=%var_:C=c%
set var_=%var_:D=d%
set var_=%var_:E=e%
set var_=%var_:F=f%
set var_=%var_:G=g%
set var_=%var_:H=h%
set var_=%var_:I=i%
set var_=%var_:J=j%
set var_=%var_:K=k%
set var_=%var_:L=l%
set var_=%var_:M=m%
set var_=%var_:N=n%
set var_=%var_:O=o%
set var_=%var_:P=p%
set var_=%var_:Q=q%
set var_=%var_:R=r%
set var_=%var_:S=s%
set var_=%var_:T=t%
set var_=%var_:U=u%
set var_=%var_:V=v%
set var_=%var_:W=w%
set var_=%var_:X=x%
set var_=%var_:Y=y%
set var_=%var_:Z=z%
set var_=%var_:=%
set var_=%var_:=%
set var_=%var_:=%
set var_=%var_:"=%
endlocal & set %2=%var_%& goto :EOF
